/*
 *
 *  $Id: volume.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "reconstructionviews.h"
#include "commands/voiextractioncommand.h"
#include <yasper/yasper.h>
#include "../../estudios/visualizatorstudy.h"
#include <api/icontroladoreventos.h>

namespace GNC {
	namespace GUI {
		class StatusBarProgreso;
	}
	namespace GCS {
		class IComando;
	}
}

namespace MedicalViewer {
	namespace Reconstruction {
		namespace DataSet {
			class Slice;
			class DataSet;
		}

		namespace Pipelines {
			class VolumePipeline;
		}
	}
}


namespace MedicalViewer {

	namespace Reconstruction {

		namespace GUI {

			class VolumeTimerDemo;

			class wxVolumeRendering : public wxVolumeRenderingBase, GNC::GCS::IObservador, MedicalViewer::Reconstruction::Commands::IRangeListener
			{

			public:
				typedef GNC::GCS::IContextoEstudio         TStudy;
				typedef GNC::GCS::IContextoEstudioReferido TRefStudy;
				typedef MedicalViewer::Reconstruction::Pipelines::VolumePipeline TPipeline;

				wxVolumeRendering(wxWindow* pParent, const GnkPtr<TStudy>& study, double cwindow, double clevel);
				~wxVolumeRendering();


			public:
				void SetStereo(bool enabled);
				void SetDemo(bool enabled);
				void Reset();

				void SaveFrameToSerie();

				void SetInteractorStyleToDefault();
				void SetInteractorStyleToWindowLevel();

				virtual void OnRangeCalculated();

			public:

				virtual void OnWindowSize( wxSizeEvent& event );
				virtual void OnToolTitleButtonClick( wxCommandEvent& event );
				virtual void OnTitleLeftUp( wxMouseEvent& event );
				virtual void OnEraseBackground( wxEraseEvent& event );
				virtual void OnDataSetSliderChanged( wxScrollEvent& event );
				virtual void OnApplyClick(wxCommandEvent &event);
				virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);


			protected:
				GnkPtr<TRefStudy> RefStudy;
				GnkPtr<TPipeline> Pipeline;
				VolumeTimerDemo* m_pTimer;
				bool m_editing;
				GNC::GUI::StatusBarProgreso* m_pProgressBar;
			};
		}
	}
}
