/*
 *  
 *  $Id: iconoimagenctrl.h 3784 2011-04-27 12:07:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <wx/panel.h>
#include <wx/bitmap.h>
#include <wx/string.h>

class EXTAPI IconoImagenCtrl: public wxPanel {
public:

	IconoImagenCtrl(wxWindow* pPadre, const wxImage& icono, const wxString toolTip=wxEmptyString, bool hasMenu = false, bool ajustado = false);
	IconoImagenCtrl(wxWindow* pPadre, const wxBitmap& icono, const wxString toolTip=wxEmptyString, bool hasMenu = false, bool ajustado = false);

protected:
	void Inicializar(const wxImage& icono, const wxString toolTip=wxEmptyString, bool hasMenu = false, bool ajustado = false);
public:

	~IconoImagenCtrl();

	void SetIcono(const wxImage& icono);

	void SetCheck(bool check);

	bool IsChecked();

	void SetNumero(int numero);

	//esto sirve para que se comporte como el disabled pero sigue pillando eventos
	void SetIcoActivado(bool activar = true);

	bool EstaActivado();

	virtual bool Enable(bool enable = true);

	// Dibuja manualmente el fondo seleccionado
	virtual void OnPaint(wxPaintEvent& evt);

	virtual void OnMouseEvents(wxMouseEvent& evt);

protected:
	wxBitmap m_bitmap;
	wxBitmap m_disabled_bitmap;
	bool     m_MouseDown;
	bool     m_MouseDownMenu;
	bool		m_check;
	bool		m_hasMenu;
	int		m_dimension;
	bool		m_activado;
	wxColour m_ColorFondo;
	wxColour m_ColorFondoSeleccionado;
	wxColour m_ColorLineaSeleccion;
	wxColour m_ColorLineaNormal;
	wxColour m_ColorLineaTachadura;
	wxString m_texto;
};
