/*
 *  
 *  $Id: toolzoom.cpp 4491 2011-12-14 10:17:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "toolzoom.h"
#include <resources/ginkgoresourcemanager.h>
#include <vtkInteractorStyle.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>


GNC::ToolZoom::ToolZoom() 
{
	m_Activa = false;

	m_Descripcion = _Std("Zoom\tCtrl+Z");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoZoom();
	m_pBuilder = NULL;
}

GNC::ToolZoom::~ToolZoom()
{
	;
}

//region "Realización de la interfaz IHerramienta"

void GNC::ToolZoom::CrearPaneles( wxPanel* /*panel*/ ) 
{
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::ToolZoom::ConectarContratoFalso(bool activar) 
{
	if (TContractableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContractableWidgets::IteradorListaContratos it = TContractableWidgets::m_pListaActiva->begin(); it != TContractableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolZoom: Conectando contrato falso de vista " << TContractableWidgets::m_pVistaActiva );
			} else {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolZoom: Desconectando contrato falso de vista " << TContractableWidgets::m_pVistaActiva );
			}
		}
	}
}

void GNC::ToolZoom::SetVistaActiva(GNC::GCS::IVista* pVista) 
{
	if (pVista == NULL) {
		;
	}
	TContractableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::ToolZoom::SetVistaActiva(" <<  pVista << ")");

}

void GNC::ToolZoom::ConectarContratos(bool activar) 
{

	TContractableWidgets::ListaContratos* lista1 = TContractableWidgets::ObtenerContratosDeActiva();
	if (lista1 == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pBuilder != NULL)
			{
				delete m_pBuilder;
				m_pBuilder = NULL;
			}
		}
		return;
	}
	
	

	for (TContractableWidgets::IteradorListaContratos it1 = lista1->begin(); it1 != lista1->end(); it1++) {
		TContratoWidgets* pC = (*it1);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "ToolZoom: Conectando contratos de vista " << TContractableWidgets::m_pVistaActiva );
				m_pBuilder = new TBuilder(pC->GetManager(),this, GetTriggerButton(), (unsigned long)this);
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pBuilder->GetCursor());
			}
			else {
				GTRACE( "ToolZoom: Desconectando contratos de vista " << TContractableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				if (m_pBuilder != NULL) {
					delete m_pBuilder;
					m_pBuilder = NULL;
				}
			}
		}
	}
}

//endregion


//region "IWZoomObserver"
void GNC::ToolZoom::ChangeZoom(int steps)
{
	TContractableWidgets::ListaContratos* lista1 = TContractableWidgets::ObtenerContratosDeActiva();
	if (lista1 == NULL) {
		return;
	}
	for (TContractableWidgets::IteradorListaContratos it1 = lista1->begin(); it1 != lista1->end(); it1++) {
		TContratoWidgets* pC = (*it1);
		if (pC->Inicializado()) {
			vtkSmartPointer<vtkInteractorStyle> interactor = pC->GetViewer()->GetInteractorStyle();
			interactor->StartDolly();
			double factor = 0.1 *steps * interactor->GetMouseWheelMotionFactor();
			//this->Dolly(pow((double)1.1, factor));
			pC->GetViewer()->SyncSetZoom(pow((double) 1.1, factor) * pC->GetViewer()->GetZoom());
			interactor->EndDolly();			
		}
	}
}
//endregion
