/*
 *  
 *  $Id: ginkgohttp.h 4158 2011-09-19 13:25:20Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <map>

namespace GIL {
	namespace GnkNetwork {
		namespace GnkHTTP {
			class GinkgoHTTP{
			public:
				typedef std::map<std::string,std::string> MapaHeaders;
				typedef MapaHeaders::iterator IteradorHeaders;
				typedef MapaHeaders::const_iterator IteradorHeadersConst;

				enum GnkHTTP_Req
				{
					HTTP_GET,
					HTTP_POST
				};

				GinkgoHTTP();
				~GinkgoHTTP();

				std::string BuildGetRequest(const std::string& path);
				std::string BuildPostRequest(const std::string& path);

				bool ParseResponse(std::string response);
				static int ParseResponseBinary(char* buffer, int sizeOfBuffer, MapaHeaders& headers, int& positionEndOfHeaders);

				const std::string GetContent() const;
				const std::string GetContentType() const;
				const int& GetHttpResponseCode() const;
				void SetHeader(const std::string& clave, const std::string& valor);
				std::string GetHeader(const std::string& header) const;
				void SetPostBuffer(const std::string& post_buf);

				int GetResponse() { return m_http_response; }

			protected:
				std::string BuildRequest(const std::string& path,GnkHTTP_Req req);

				static int GetLinea(const std::string& cadena, std::string& linea, int indice);


				std::string ConstruyeHeaders();

				// find the header in m_headers
				IteradorHeaders FindHeader(const std::string& header);
				IteradorHeadersConst FindHeader(const std::string& header) const;

				// deletes the header value strings
				void ClearHeaders();
				MapaHeaders m_headers;
				std::string m_post_buf;
				int m_http_response;
				std::string m_content;

			};
		};
	};
};
