/*
 *  
 *  $Id: gvistacompleja.h 4400 2011-11-11 12:52:23Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <wx/aui/auibar.h>
#include "visualizatorviews.h"
#include <export/icontratoscore.h>
#include "../exportacion/icontratosaprimaria.h"
#include <api/icontroladoreventos.h>
#include "../estudios/overlay.h"
#include <api/ianotador.h>

#include <vtkCommand.h>

namespace GNKVisualizator{
	class VisualizatorStudy;
	class Vista2D;
}

class GVistaSimple;

class TimerPlay;
class BarraHerramientasBotones;

class vtkScalarsToColors;
class vtkAlgorithmOutput;
class GVistaCompleja: public VistaComplejaBase, public GNKVisualizator::IContratoMapaColor, public GNC::GCS::IContratoWidgets, public GNC::GCS::IContratoWindowLevel, public GNKVisualizator::IReconstructionContract, public GNC::GCS::IObservador, public GNKVisualizator::IContratoOverlays, public GNC::GCS::IAnotador, public GNC::GCS::IContratoLayoutVentana {
public:

   /* Constructor */
	GVistaCompleja( GNKVisualizator::Vista2D* pIVista);
   /* Destructor */
	~GVistaCompleja();

	virtual void OnEraseBackground( wxEraseEvent& event ) { event.Skip(false); }

	void AddVistaSimple();

	void IniciarPipeline();

	void DetenerPipeline();

	virtual void OnCargaFinalizada();

	void SetOverlays(GNKVisualizator::TListaOverlays* pListaOverlays);

	bool GetManipulacionEnabled()
	{
		return m_pPanelManipulacion->IsEnabled();
	}

   //region "Eventos"
	virtual void OnPaint(wxPaintEvent& evt);

	void OnMenuVerClick(wxCommandEvent& event);
	void OnMenuCineClick(wxAuiToolBarEvent& evt);
	void OnMenuLayout(wxCommandEvent &event);
	void OnDesencajar(wxCommandEvent &event);
	void OnInvertColorMap(wxCommandEvent &event);
	void OnRotateLeft(wxCommandEvent &event);
	void OnRotateRight(wxCommandEvent &event);
	void OnFlipVertical(wxCommandEvent &event);
	void OnFlipHorizontal(wxCommandEvent &event);

	void ActualizarMaxMinSlider();

	void OnFocus(wxChildFocusEvent &event);

	void SetPeriodo(int milisegundos);

	void OnSize(wxSizeEvent &event);

	void OnZSliderScroll (wxScrollEvent& event);

	void OnKeyDown( wxKeyEvent& event );

	void OnMouseWheel( wxMouseEvent& event );

	void OnPlayStopClick(wxCommandEvent &event);

	void Play();
	void Stop();

	void OnBucleClick(wxCommandEvent &event);

	void OnTimer();

	void OnSincronizarClick(wxCommandEvent &event);

	void Sincronizar(bool sincronizar);

	void GoToSlice(int posicion, bool relativa =  true, bool propagar = true, bool render= true);
	int GetCurrentSlice();

	void PreProcesarEvento(GNC::GCS::Eventos::IEvento* evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista);

	void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;

	typedef std::vector<GNKVisualizator::Vista2D*> TipoListaVista2D;
	void Sincronizar(const TipoListaVista2D& lista);
	void DesSincronizar();
	bool EsSincronizable();

	//endregion

	//contrato widgets
	virtual vtkGinkgoImageViewer* GetViewer();

	//region "Realizacion de la interfaz IAnnotator"
	virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetAnotacionPosicion(GNC::GCS::Vector* pPosicion);
	//endregion

	// Asigna los valores de los apuntadores a la la imagen y el slice actual
	void AsignarConexionesDeFiltrado(vtkImageData** pImagen, int* slice, vtkImageData** pChroma);
	void ActualizarImagen();

	//contrato mapa de color
	virtual void SetMapaColor(vtkLookupTable* pTabla, int idLookupTable);

	//contrato layout
	virtual void SetLayoutVentana(int filas, int columnas);
	virtual int GetColumnas();
	virtual int GetFilas();
	//
	//region "IContratoExportacionImagenes interface realization"
	void GetImage(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, int index, bool conWidgets, const GNC::GCS::Vector& size);

	//region "IReconstructionContract interface realization"
	void SetReconstructionMode(GNKVisualizator::Reconstruction::ReconstructionMode mode);

	vtkScalarsToColors* GetLookupTable();

protected:
	GNKVisualizator::Vista2D*                  IVista;
	TimerPlay*                           m_playTimer;
	BarraHerramientasBotones*            m_pBarraIzquierda;
	BarraHerramientasBotones*            m_pBarraCine;
	BarraHerramientasBotones*            m_pBarraDerecha;

	int                                  m_orientacion;
	TipoListaVista2D                     m_ListaSincronizacion;
	int m_posicion;
	bool                                 m_ReproducirBucle;
	int                                  m_PeriodoMs;
	typedef std::vector<GVistaSimple*>   TListaGVistasSimples;
	TListaGVistasSimples                 m_VistasSimples;
	///widgets
	//TipoFicherosGNKVisualizator*              m_pFicherosAprimaria;
	

	//si se ha pintado
	bool                                 m_hasBeenRendered;

	friend class GNKVisualizator::Vista2D;
};
