/*
 *  
 *  $Id: selectimagesimportationvisualizator.cpp 4361 2011-11-02 13:23:30Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include <string>
#include <sstream>
#include <cmath>

#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/valtext.h>
#include <wx/busyinfo.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <main/controllers/configurationcontroller.h>
#include <main/entorno.h>


#include <api/dicom/idicommanager.h>

#include <api/icontroladorcomandos.h>

#include <commands/comandopacs.h>

#include <export/tagsprivadoscomunes.h>

#include "../../comandos/comandodicomizacionintegracion.h"
#include "../../exportacion/tagsprivados.h"

#include "selectimagesimportationvisualizator.h"

namespace GNKVisualizator {
	namespace GUI {

		SelectImagesImportationVisualizator::SelectImagesImportationVisualizator(wxWindow* pParent,IWizard* pWizard,const GnkPtr<TipoWizardImportacion>& datosPersistentes,const std::string &dirTemporal): 
			GNC::GUI::SelectImagesImportation(pParent, dirTemporal, pWizard, datosPersistentes->m_pModeloImportacion)
		{
			Hide();
			m_dicomizado = false;
			m_pDatosPersistentes=datosPersistentes;

			m_dirTemporal=dirTemporal;
		}

		SelectImagesImportationVisualizator::~SelectImagesImportationVisualizator()
		{
		}

//region "Metodos heredados de Ipasowizard"
		bool SelectImagesImportationVisualizator::Validar(){
			bool correcto =  true;
			if(GNC::GUI::SelectImagesImportation::Validar())
			{
				if(!m_dicomizado) {
					m_dicomizado = Dicomizar();
					correcto = m_dicomizado;
				}
			} else {
				correcto = false;
			}
			return correcto;
		}

		bool SelectImagesImportationVisualizator::Dicomizar() 
		{
			for(ListaFicheros::const_iterator it=m_pListaFicheros->begin(); it!= m_pListaFicheros->end(); it++) {
				std::string rutaFichero = (*it);
				GNKVisualizator::GUI::TipoWizardImportacion::TFicheroDicomizacionGNKVisualizator ficheroADicomizar;
				ficheroADicomizar.pathImagen = rutaFichero;

				m_pDatosPersistentes->m_listaFicherosADicomizar.push_back(ficheroADicomizar);
			}

			RellenarTagsComunes(m_pDatosPersistentes->baseImagenes);
			GADAPI::ComandoDicomizacionIntegracionParams* pDicomParams = new GADAPI::ComandoDicomizacionIntegracionParams(m_pDatosPersistentes,GNC::Entorno::Instance(),m_dirTemporal);
			GADAPI::ComandoDicomizacionIntegracion* pDicomCmd = new GADAPI::ComandoDicomizacionIntegracion(pDicomParams);
			GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Performing tasks of integration ..."),pDicomCmd,NULL);
			//se limpia la lista porque ya avisaremos de los nuevos ficheros
			m_pListaFicheros->clear();
			//
			return true;
			
		}

		void SelectImagesImportationVisualizator::RellenarTagsComunes(GIL::DICOM::TipoJerarquia& base)
		{
			std::string tag;

			//institucion
			if(m_pDatosPersistentes->NombreCentro == "" ){
				if (GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/Estacion","CentroNombre",tag)) {
					base.tags[std::string("0008|0080")] = tag;
				}
			} else {
				base.tags[std::string("0008|0080")] = m_pDatosPersistentes->NombreCentro;
			}

			//nombre del medico responsable de la institucion
			if(m_pDatosPersistentes->NombreMedico == ""){
				if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Estacion","NombreMedico",tag)) {
					base.tags[std::string("0008|0090")] = tag;
				}
			} else {
				base.tags[std::string("0008|0090")] = m_pDatosPersistentes->NombreMedico;
			}

			base.tags[std::string("0008|0070")] = EXT_PROVIDER;

			base.tags[std::string("0008|1090")] = EXT_NAME;

			//uid de aprimaria
			base.tags[std::string("0018|1030")] = EXT_IMPORTER_SID;

			base.tags[std::string("0008|0020")] = m_pDatosPersistentes->EstudioFecha;

			base.tags[std::string("0008|0030")] =  m_pDatosPersistentes->EstudioHora;

			base.tags[std::string("0008|1030")] = m_pDatosPersistentes->EstudioDescripcion;

			//uid de la serie
			if(m_pDatosPersistentes->SerieUID!=""){
				base.tags[std::string("0020|000e")] = m_pDatosPersistentes->SerieUID;
			}

			//si procede referenciar estudio
			if(m_pDatosPersistentes->StudyInstanceUID!=""){
				base.tags[std::string("0020|000d")] = m_pDatosPersistentes->StudyInstanceUID;
			}

			if(m_pDatosPersistentes->AccessionNumber!="") {
				base.tags[std::string("0008|0050")] = m_pDatosPersistentes->AccessionNumber;
			}

			//fecha serie
			base.tags[std::string("0008|0021")] = m_pDatosPersistentes->SerieFecha;

			//hora serie
			base.tags[std::string("0008|0031")] = m_pDatosPersistentes->SerieHora;

			//descripcion serie
			base.tags[std::string("0008|103e")] = m_pDatosPersistentes->SerieDescripcion;

			//fecha imagen
			base.tags[std::string("0008|0022")] = m_pDatosPersistentes->SerieFecha;
			//hora imagen
			base.tags[std::string("0008|0032")] = m_pDatosPersistentes->SerieHora;
			//descripcion imagen
			base.tags[std::string("0020|4000")] = m_pDatosPersistentes->SerieDescripcion;


			base.tags[std::string("0010|0010")] = m_pDatosPersistentes->PacienteNombre + "^" + m_pDatosPersistentes->PacienteApellido1 + "^" + m_pDatosPersistentes->PacienteApellido2;

			base.tags[std::string("0010|0020")] = m_pDatosPersistentes->PacienteIdentificador;

			base.tags[std::string("0010|1010")] = m_pDatosPersistentes->PacienteEdad;

			base.tags[std::string("0010|0030")] = m_pDatosPersistentes->PacienteFechaNacimiento;

			base.tags[std::string("0010|0040")] = m_pDatosPersistentes->PacienteSexo;

			base.tags[std::string("0010|1020")] = m_pDatosPersistentes->PacienteAltura;

			base.tags[std::string("0010|1030")] = m_pDatosPersistentes->PacientePeso;
		}
	//endregion
	}
}
