/*
 *  
 *  $Id: barraherramientasderecha.cpp 4330 2011-10-25 10:28:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/menu.h>
#include <wx/aui/aui.h>
#include <wx/aui/auibar.h>
#include <wx/dcclient.h>

#include <main/gui/mainwindow/ventanaprincipal.h>
#include "barraherramientasderecha.h"

#include <resources/ginkgoresourcemanager.h>


#define ID_BOTON_PESTANIAS			1701
#define ID_BOTON_GRID				1702

namespace GNC {
	namespace GUI {
		BarraHerramientasDerecha::BarraHerramientasDerecha(wxWindow* pParent, VentanaPrincipal* pVentanaPrincipal): wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize,wxAUI_TB_DEFAULT_STYLE )
		{
			m_pVentanaPrincipal = pVentanaPrincipal;

			SetToolBitmapSize(wxSize(16,16));
			wxAuiDefaultToolBarArt* pToolArt= new wxAuiDefaultToolBarArt();
			/*
			wxColor color = pToolArt->GetDefaultBaseColor();
			color = wxColor(198,198,198);
			pToolArt->SetBaseColor(color);
			*/
			SetArtProvider(pToolArt);

			AddTool(ID_BOTON_PESTANIAS,_("Tabbed organization"),GinkgoResourcesManager::MenusTabs::GetIcoReagrupar(),_("Tabbed organization"));
			SetToolDropDown(ID_BOTON_PESTANIAS,true);
			AddTool(ID_BOTON_GRID,_("Column organization (2 columns)"),GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col(),_("Column organization (2 columns)"));
			SetToolDropDown(ID_BOTON_GRID,true);

			Realize();
			SetAutoLayout(true);

			this->Connect(ID_BOTON_PESTANIAS,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler( BarraHerramientasDerecha::OnMenuPestanias), NULL, this);
			this->Connect(ID_BOTON_GRID,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler( BarraHerramientasDerecha::OnMenuGrid), NULL, this);
		}

		BarraHerramientasDerecha::~BarraHerramientasDerecha()
		{
			m_pVentanaPrincipal = NULL;

			this->Disconnect(ID_BOTON_PESTANIAS,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler( BarraHerramientasDerecha::OnMenuPestanias), NULL, this);
			this->Disconnect(ID_BOTON_GRID,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler( BarraHerramientasDerecha::OnMenuGrid), NULL, this);
		}

		void BarraHerramientasDerecha::OnMenuPestanias(wxAuiToolBarEvent& evt)
		{
			if (evt.IsDropDownClicked())
			{
				wxMenu*  menu = new wxMenu();
				//cerrar pestania activa
				int id=1;
				wxMenuItem* pMenuRestaurar = new wxMenuItem(menu, id++, wxString( _("Tab grouping") ), _("Tab grouping"), wxITEM_NORMAL );
				wxMenuItem*  pMosaicoHorizontal = new wxMenuItem( menu, id++, _("Horizontal mosaic"), _("Horizontal mosaic"), wxITEM_NORMAL );
				wxMenuItem*  pMosaicoVertical = new wxMenuItem( menu, id++, _("Vertical mosaic"), _("Vertical mosaic"), wxITEM_NORMAL );

				#ifdef __WXMSW__
					pMenuRestaurar->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
				#else
					pMenuRestaurar->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
				#endif

				menu->Append(pMenuRestaurar);
				menu->AppendSeparator();
				menu->Append(pMosaicoHorizontal);
				menu->Append(pMosaicoVertical);

				menu->Connect( pMosaicoVertical->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( BarraHerramientasDerecha::OnMosaicoVertical ),NULL,this );
				menu->Connect( pMosaicoHorizontal->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( BarraHerramientasDerecha::OnMosaicoHorizontal ),NULL,this );
				menu->Connect( pMenuRestaurar->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( BarraHerramientasDerecha::OnMosaicoRestaurar),NULL,this);
				PopupMenu(menu);
				delete menu;
			} else {
				wxCommandEvent evt1;
				OnMosaicoRestaurar(evt1);
			}
		}

		void BarraHerramientasDerecha::OnMenuGrid(wxAuiToolBarEvent& evt )
		{
			if (evt.IsDropDownClicked())
			{
				wxMenu*  menu = new wxMenu();
				//cerrar pestania activa
				int id=1;

				wxMenuItem*  pGrid2Col = new wxMenuItem( menu, id++, _("Grid (two columns)"), _("Grid (two columns)"), wxITEM_NORMAL );
				wxMenuItem*  pGrid3Col = new wxMenuItem( menu, id++, _("Grid (three columns)"), _("Grid (three columns)"), wxITEM_NORMAL );

				#ifdef __WXMSW__
				pGrid2Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
				pGrid3Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
				#else
				pGrid2Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
				pGrid3Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
				#endif

				menu->Append(pGrid2Col);
				menu->Append(pGrid3Col);

				menu->Connect(pGrid3Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( BarraHerramientasDerecha::OnMosaicoGrid3Col),NULL,this);
				menu->Connect(pGrid2Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( BarraHerramientasDerecha::OnMosaicoGrid2Col),NULL,this);

				PopupMenu(menu);
				delete menu;
			} else {
				wxCommandEvent evt1;
				OnMosaicoGrid2Col(evt1);
			}
		}

		////////
		void BarraHerramientasDerecha::OnMosaicoHorizontal(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoHorizontal(event);
		}
		void BarraHerramientasDerecha::OnMosaicoVertical(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoVertical(event);
		}

		void BarraHerramientasDerecha::OnMosaicoRestaurar(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoRestaurar(event);
		}

		void BarraHerramientasDerecha::OnMosaicoGrid2Col(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoGrid2Col(event);
		}

		void BarraHerramientasDerecha::OnMosaicoGrid3Col(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoGrid3Col(event);
		}
	}
}
