/*
 *  
 *  $Id: ievento.cpp 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include "ievento.h"
#include <wx/event.h>

void GNC::GCS::Eventos::EventoRaton::ParseWXEvent(wxMouseEvent* evt)
{
	wX = (double) evt->m_x;
	wY = (double) evt->m_y;
	wZ = 0.0f;
	
	m_leftDown   = evt->m_leftDown;
	m_middleDown = evt->m_middleDown;
	m_rightDown  = evt->m_rightDown;
	m_anyDown    = m_leftDown || m_middleDown || m_rightDown;
	int etype = evt->GetEventType();
	
	if (etype == wxEVT_MOTION) {
		m_tipo = ET_MOTION;
	}
	else if (etype == wxEVT_LEFT_DOWN) {
		m_tipo = ET_DOWN;
		m_left = true;
	}
	else if (etype == wxEVT_LEFT_UP) {
		m_tipo = ET_UP;
		m_left = true;
	}
	else if (etype == wxEVT_LEFT_DCLICK) {
		m_tipo = ET_DCLICK;
		m_left = true;
	}
	else if (etype == wxEVT_MIDDLE_DOWN) {
		m_tipo = ET_DOWN;
		m_middle = true;
	}
	else if (etype == wxEVT_MIDDLE_UP) {
		m_tipo = ET_UP;
		m_middle = true;
	}
	else if (etype == wxEVT_MIDDLE_DCLICK) {
		m_tipo = ET_DCLICK;
		m_middle = true;
	}
	else if (etype == wxEVT_RIGHT_DOWN) {
		m_tipo = ET_DOWN;
		m_right = true;
	}
	else if (etype == wxEVT_RIGHT_UP) {
		m_tipo = ET_UP;
		m_right = true;
	}
	else if (etype == wxEVT_RIGHT_DCLICK) {
		m_tipo = ET_DCLICK;
		m_right = true;
	}
	else if (etype == wxEVT_ENTER_WINDOW) {
		m_tipo = ET_ENTER;
	}
	else if (etype == wxEVT_LEAVE_WINDOW) {
		m_tipo = ET_LEAVE;
	}
	else {
		m_tipo = ET_UNKNOWN;
	}
	
	m_any = m_anyDown || m_left || m_right || m_middle;
	
	m_controlDown    = evt->m_controlDown;
	m_shiftDown      = evt->m_shiftDown;
	m_altDown        = evt->m_altDown;
	m_metaDown       = evt->m_metaDown;
	
	m_wheelRotation  = evt->m_wheelRotation;
	m_wheelDelta     = evt->m_wheelDelta;
	m_linesPerAction = evt->m_linesPerAction;
	sX               = evt->m_x;
	sY               = evt->m_y;
	
}

void GNC::GCS::Eventos::EventoTeclado::ParseWXEvent(wxKeyEvent* evt)
{
	m_isKeyDown = evt->GetEventType() == wxEVT_KEY_DOWN;
	m_keyCode     = evt->m_keyCode;
	m_controlDown = evt->m_controlDown;
	m_shiftDown   = evt->m_shiftDown;
	m_altDown     = evt->m_altDown;
	m_metaDown    = evt->m_metaDown;
	m_scanCode    = evt->m_scanCode;
	m_rawCode     = evt->m_rawCode;
	m_rawFlags    = evt->m_rawFlags;
	m_uniChar     = evt->m_uniChar;
}
