/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __EVENT_H__
#define __EVENT_H__

#include <glib.h>
#include <libgift/libgift.h>

#define GIFTUI_EVENT(arg) ((GiftuiEvent_t *) (arg))

#define GIFTUI_REGISTRED_CB(arg) ((GiftuiRegistredCB_t) (arg))

typedef struct _GiftuiEvent_t GiftuiEvent_t;

typedef enum
{
	/* Search, locate and browse */
	EVENT_ITEM = 0,
	
	/* Downloads */
	EVENT_ADDDOWNLOAD,
	EVENT_CHGDOWNLOAD,
	EVENT_DELDOWNLOAD,
	EVENT_ADDSOURCE,
	EVENT_DELSOURCE,
	
	/* Uploads */
	EVENT_ADDUPLOAD,
	EVENT_CHGUPLOAD,
	EVENT_DELUPLOAD,
	
	/* Status */
	EVENT_SHARE,
	EVENT_STATS,
	
	EVENT_OPEN, /* Connection has been opened by giftui (currently
		     * not used). */
	EVENT_CLOSE, /* Connection has been closed by giftui. */
	EVENT_ATTACH, /* GiFT has attach the client and is now ready
		       * to send informations. */
	EVENT_DISCONNECT, /* Connection has closed/lost by/from
			   * giFT. */
	
	EVENT_MESSAGE, /* Messages from giFT. */
	
	EVENT_OTHER /* Not defined events. */
} GiftuiEventType_t;

struct _GiftuiEvent_t
{
	GiftuiEventType_t type;
	guint id;
	Interface *iface;
};

typedef void (* GiftuiRegistredCB_t) (gpointer *, GiftuiEvent_t *);

/* Events */
void giftui_event_free (GiftuiEvent_t *ev);
GiftuiEvent_t *giftui_event_new_from_interface (Interface *in);
void giftui_event_send_to_widgets (GiftuiEvent_t *ev);

/* Registration */
void giftui_event_register (GiftuiEventType_t type, guint id, gpointer instance,
			    GiftuiRegistredCB_t callback);
void giftui_event_unregister (gconstpointer instance, GiftuiEventType_t type,
			      guint id);
void giftui_event_unregister_all (gconstpointer instance);

#endif
