#ifndef __halfopencone_h
#define __halfopencone_h

#include "polyhedralcone.h"
#include "termorder.h"

#include "polyhedralfan.h"

class HalfOpenCone{
  static void appendList(IntegerVectorList &to, IntegerVectorList const &from, int appendValue);
  static IntegerVectorList shrink(const IntegerVectorList &l);
  int liftedDimension;
  PolyhedralCone lifted;  
  HalfOpenCone(int dimension_, PolyhedralCone const &lifted_);
 public:
  int dimension;
  HalfOpenCone(PolyhedralCone C, TermOrder const &t);//only for full dimensional cones!
  HalfOpenCone(int dimension_, IntegerVectorList const &equations, IntegerVectorList const &nonstrict, IntegerVectorList const &strict, bool findFacets=false);
  bool isEmpty();
  friend HalfOpenCone intersection(const HalfOpenCone &a, const HalfOpenCone &b, bool findFacets=false);
  friend bool haveEmptyIntersection(const HalfOpenCone &a, const HalfOpenCone &b);
  PolyhedralCone closure();
  void splitIntoRelativelyOpenCones(list<HalfOpenCone> &l);
  void print(class Printer &p)const;
  bool contains(IntegerVector const &v)const;
};

typedef list<HalfOpenCone> HalfOpenConeList;

HalfOpenConeList orientedBoundary(PolyhedralCone C, TermOrder const &t);

HalfOpenConeList splitIntoRelativelyOpenCones(HalfOpenConeList const &l);

HalfOpenConeList tropicalHyperSurfaceIntersection(int dimension, PolynomialSet const &g);
PolyhedralFan tropicalHyperSurfaceIntersectionClosed(int dimension, PolynomialSet const &g);

void printHalfOpenConeList(HalfOpenConeList const &l, class Printer & p);//Assuming that the union is closed and the cones have a common linearity space


PolyhedralFan faceComplexOfCone(HalfOpenCone &c);

#endif
