#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "buchberger.h"
#include "wallideal.h"
#include "termorder.h"
#include "gfanapplication.h"
#include "tropical2.h"

class InitialFormsApplication : public GFanApplication
{
  SimpleOption optionIdeal;
  SimpleOption optionPair;
public:
  const char *helpText()
  {
    return "This program converts a list of polynomials to a list of their initial forms with respect to the vector given after the list.\n";
  }
  InitialFormsApplication():
    optionIdeal("--ideal","Treat input as an ideal. This will make the program compute the initial ideal of the ideal generated by the input polynomials. The computation is done by computing a Groebner basis with respect to the given vector. The vector must be positive or the input polynomials must be homogenous in a positive grading. None of these conditions are checked by the program.\n"),
    optionPair("--pair","Produce a pair of polynomial lists. Used together with --ideal this option will also write a compatible reduced Groebner basis for the input ideal to the output. This is useful for finding the Groebner cone of a non-monomial initial ideal.\n")
  {
    registerOptions();
  }
  
  char *name()
  {
    return "_initialforms";
  }

  int main()
  {
    FileParser P(Stdin);
    
    PolynomialSet g=P.parsePolynomialSetWithRing();
    IntegerVector w=P.parseIntegerVector();

    assert(w.size()==g.getRing().getNumberOfVariables());

    if(optionIdeal.getValue())
      {
	WeightReverseLexicographicTermOrder T(w);
	buchberger(&g,T);
      }

    AsciiPrinter(Stdout).printPolynomialRing(g.getRing());
    AsciiPrinter(Stdout).printNewLine();
    AsciiPrinter(Stdout).printPolynomialSet(initialForms(g,w));
    if(optionPair.getValue())
      {
	AsciiPrinter(Stdout).printNewLine();
	AsciiPrinter(Stdout).printPolynomialSet(g);
      }

    return 0;
  }
};

static InitialFormsApplication theApplication;
