#include "parser.h"
#include "printer.h"
#include "saturation.h"
#include "gfanapplication.h"
#include "lp.h"

class IdealProductApplication : public GFanApplication
{
  FieldOption theFieldOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program computes the product IJ of ideals generated by sets of polynomials given in the input.\n";
  }
  IdealProductApplication()
  {
    registerOptions();
  }
  
  char *name()
  {
    return "_idealproduct";
  }

  int main()
  {
    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");

    FileParser P(Stdin);

    PolynomialRing theRing=P.parsePolynomialRing();
    PolynomialSet a=P.parsePolynomialSet(theRing);
    PolynomialSet b=P.parsePolynomialSet(theRing);

    /*    int n1=a.numberOfVariablesInRing();
    int n2=b.numberOfVariablesInRing();

    int n=n1;
    if(n2>n1)n=n2;
    a.changeNumberOfVariables(n);
    b.changeNumberOfVariables(n);
    */

    PolynomialSet ret(theRing);
    for(PolynomialSet::const_iterator i=a.begin();i!=a.end();i++)
      for(PolynomialSet::const_iterator j=b.begin();j!=b.end();j++)
	{
	  ret.push_back(*i * *j);
	}
    AsciiPrinter(Stdout).printPolynomialSet(ret);
    
    return 0;
  }
};

static IdealProductApplication theApplication;
