#include "parser.h"
#include "printer.h"
#include "saturation.h"
#include "gfanapplication.h"
#include "lp.h"

class IdealIntersectionApplication : public GFanApplication
{
  FieldOption theFieldOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program computes the intersection of two ideals generated by sets of polynomials given in the input.\n";
  }
  IdealIntersectionApplication()
  {
    registerOptions();
  }
  
  char *name()
  {
    return "_idealintersection";
  }

  int main()
  {
    LpSolver::printList(Stderr);
    lpSetSolver("cddgmp");

    FileParser P(Stdin);

    PolynomialRing theRing=P.parsePolynomialRing();
    PolynomialSet a=P.parsePolynomialSet(theRing);
    PolynomialSet b=P.parsePolynomialSet(theRing);

    /*    int n1=a.numberOfVariablesInRing();
    int n2=b.numberOfVariablesInRing();

    int n=n1;
    if(n2>n1)n=n2;
    a.changeNumberOfVariables(n);
    b.changeNumberOfVariables(n);
    */
    AsciiPrinter(Stdout).printPolynomialRing(theRing);
    AsciiPrinter(Stdout).printPolynomialSet(idealIntersection(a,b));
    
    return 0;
  }
};

static IdealIntersectionApplication theApplication;
