% FUNCTION [x] = gf_mesh_im_set(meshim MIM, operation [, args])
% 
%   General function for modifying mesh_im objects
% 
%   * gf_mesh_im_set(MIM,'integ,'{Integ im|int im_degree}[, ivec CVids])
%   Set the integration method.  Assign an integration method to all convexes
%   whose #ids are listed in `CVids`. If `CVids` is not given, the integration is
%   assigned to all convexes. It is possible to assign a specific integration
%   method with an integration method handle `im` obtained via
%   gf_integ('IM_SOMETHING'), or to let getfem choose a suitable integration
%   method with `im_degree` (choosen such that polynomials of `degree <=
%   im_degree` are exactly integrated. If `im_degree=-1`, then the dummy
%   integration method IM_NONE will be used.)
% 
% 
%   $Id: gf_mesh_im_set.cc 3008 2009-05-16 14:08:01Z renard $
function [varargout]=gf_mesh_im_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im_set',varargin{:});
  else
    gf_matlab('mesh_im_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
