% FUNCTION M = gf_mdbrick(brick_name, [, args])
%   General constructor for mdbrick object. Returns a getfem handle to the newly
%   created object.
% 
%   Many of the bricks take a "numfem" optional parameter, which
%   is the meshfem number in the stack of parent bricks (by default
%   numfem=0, i.e. it refers to the first meshfem in the stack of
%   bricks).
% 
%   * B = gf_mdbrick('constraint', MdBrick pb, string CTYPE[, int nfem])
%   Build a generic constraint brick.  It may be useful in some situations, such
%   as the Stokes problem where the pressure is defined modulo a constant. In such
%   a situation, this brick can be used to add an additional constraint on the
%   pressure value.
%    `CTYPE` has to be chosen among 'augmented', 'penalized', and 'eliminated'.
%   The constraint can be specified with gf_mdbrick_set(b,'constraints'). Note
%   that Dirichlet bricks (except the 'generalized Dirichlet' one) are also
%   specializations of the 'constraint' brick.
% 
%   * B = gf_mdbrick('dirichlet', MdBrick pb, int bnum, MeshFem mf_m, string CTYPE[,
%   int nfem])
%   Build a Dirichlet condition brick which impose the value of a field along a
%   mesh boundary.  The `bnum` parameter selects on which mesh region the
%   Dirichlet condition is imposed. `CTYPE` has to be chosen among 'augmented',
%   'penalized', and 'eliminated'. The `mf_m` may generally be taken as the
%   MeshFem of the unknown, but for 'augmented' Dirichlet conditions, you may have
%   to respect the Inf-Sup condition and choose an adequate MeshFem.
% 
%   * B = gf_mdbrick('dirichlet_on_normal_component', MdBrick pb, int bnum, MeshFem
%   mf_m, string CTYPE[, int nfem])
%   Build a Dirichlet condition brick which imposes the value of the normal
%   component of a vector field.
% 
%   * B = gf_mdbrick('dirichlet_on_normal_derivative', MdBrick pb, int bnum, MeshFem
%   mf_m, string CTYPE[, int nfem])
%   Build a Dirichlet condition brick which imposes the value of the normal
%   derivative of the unknown.
% 
%   * B = gf_mdbrick('generalized_dirichlet', MdBrick pb, int bnum[, int nfem])
%   This is the "old" Dirichlet brick of getfem.  This brick can be used to impose
%   general Dirichlet conditions `h(x)u(x) = r(x)`, however it may have some
%   issues with elaborated Fem's (such as Argyris, etc). It should be avoided when
%   possible.
% 
%   * B = gf_mdbrick('source_term', MdBrick pb[, int bnum=-1[, int nfem]])
%   Add a boundary or volumic source term ( \int B.v ).  If `bnum` is omitted (or
%   set to -1) , the brick adds a volumic source term on the whole mesh. For
%   `bnum` >= 0, the source term is imposed on the mesh region `bnum`. Use
%   gf_mdbrick_set(b,'param','source term',mf,B) to set the source term field. The
%   source term is expected as a vector field of size Q (with Q = qdim).
% 
%   * B = gf_mdbrick('normal_source_term', MdBrick pb, int bnum[, int nfem])
%   Add a boundary source term ( \int (Bn).v ).  The source term is imposed on the
%   mesh region `bnum` (which of course is not allowed to be a volumic region,
%   only boundary regions are allowed). Use gf_mdbrick_set(b,'param','source
%   term',mf,B) to set the source term field. The source term B is expected as
%   tensor field of size QxN (with Q = qdim, N = mesh dim). For example, if you
%   consider an elasticity problem, this brick may be used to impose a force on
%   the boundary with B as the stress tensor.
% 
%   * B = gf_mdbrick('normal_derivative_source_term', MdBrick parent, int bnum[, int
%   nfem])
%   Add a boundary source term ( \int (\partial_n B).v ).  The source term is
%   imposed on the mesh region `bnum`. Use gf_mdbrick_set(b,'param','source
%   term',mf,B) to set the source term field, which is expected as a vector field
%   of size Q (with Q = qdim).
% 
%   * B = gf_mdbrick('neumann KirchhoffLove source term', MdBrick pb, int bnum[, int
%   nfem])
%   Add a boundary source term for neumann Kirchhoff-Love plate problems.  Should
%   be used with the Kirchhoff-Love flavour of the bilaplacian brick.
% 
%   * B = gf_mdbrick('qu_term', MdBrick pb[, int bnum[, int nfem]])
%   Update the tangent matrix with a \int (Qu).v term.  The Q(x) parameter is a
%   matrix field of size qdim x qdim. An example of use is for the "iku" part of
%   Robin boundary conditions \partial_n u + iku = ...
% 
%   * B = gf_mdbrick('mass_matrix', MeshIm mim, MeshFem mf_u[, 'real'|'complex'])
%   Build a mass-matrix brick.
% 
%   * B = gf_mdbrick('generic_elliptic', MeshIm mim, MeshFem mfu[,
%   'scalar'|'matrix'|'tensor'][, 'real'|'complex'])
%   Setup a generic elliptic problem.  a(x)*grad(U).grad(V)
%   
%     The brick parameter `a` may be a scalar field, a matrix field, or a tensor
%   field (default is scalar).
% 
%   * B = gf_mdbrick('helmholtz', MeshIm mim, MeshFem mfu[, 'real'|'complex'])
%   Setup a Helmholtz problem.  The brick has one parameter, 'wave_number'.
% 
%   * B = gf_mdbrick('isotropic_linearized_elasticity', MeshIm mim, MeshFem mfu)
%   Setup a linear elasticity problem.  The brick has two scalar parameter,
%   'lambda' and 'mu' (the Lame coefficients).
% 
%   * B = gf_mdbrick('linear_incompressibility_term', MdBrick pb, MeshFem mfp[, int
%   nfem])
%   Add an incompressibily constraint (div u = 0).
% 
%   * B = gf_mdbrick('nonlinear_elasticity', MeshIm mim, MeshFem mfu, string law)
%   Setup a nonlinear elasticity (large deformations) problem.
%   
%     The material `law` can be chosen among:
%     - 'SaintVenant Kirchhoff'
%        Linearized material law.
%     - 'Mooney Rivlin'
%        To be used with the nonlinear incompressibily term.
%     - 'Ciarlet Geymonat'
% 
%   * B = gf_mdbrick('nonlinear_elasticity_incompressibility_term', MdBrick pb,
%   MeshFem mfp[, int nfem])
%   Add an incompressibily constraint to a large strain elasticity problem.
% 
%   * B = gf_mdbrick('small_deformations_plasticity', MeshIm mim, MeshFem mfu,
%   scalar THRESHOLD)
%   Setup a plasticity problem (with small deformations).  The `THRESHOLD`
%   parameter is the maximum value of the Von Mises stress before 'plastification'
%   of the material.
% 
%   * B = gf_mdbrick('dynamic', MdBrick pb, scalar rho[, int numfem])
%   Dynamic brick. This brick is not ready.
% 
%   * B = gf_mdbrick('navier_stokes', MeshIm mim, MeshFem mfu, MeshFem mfp)
%   Setup a Navier-Stokes problem (this brick is not ready, do not use it).
% 
%   * B = gf_mdbrick('bilaplacian', MeshIm mim, MeshFem mfu[, 'Kirchhoff-Love'])
%   Setup a bilaplacian problem.  If the 'Kirchhoff-Love' option is specified, the
%   Kirchhoff-Love plate model is used.
% 
%   * B = gf_mdbrick('isotropic_linearized_plate', MeshIm mim, MeshIm mims, MeshFem
%   mfut, MeshFem mfu3, MeshFem mftheta, scalar eps)
%   Setup a linear plate model brick.  For moderately thick plates, using the
%   Reissner-Mindlin model. `eps` is the plate thinkness, the MeshFem `mfut` and
%   `mfu3` are used respectively for the membrane displacement and the transverse
%   displacement of the plate. The MeshFem `mftheta` is the rotation of the normal
%   ("section rotations").  The second integration method `mims` can be chosen
%   equal to `mim`, or different if you want to perform sub-integration on the
%   transverse shear term (mitc4 projection).  This brick has two parameters
%   "lambda" and "mu" (the Lame coefficients)
% 
%   * B = gf_mdbrick('mixed_isotropic_linearized_plate', MeshIm mim, MeshFem mfut,
%   MeshFem mfu3, MeshFem mftheta, scalar eps)
%   Setup a mixed linear plate model brick.  For thin plates, using Kirchhoff-Love
%   model. For a non-mixed version, use the bilaplacian brick.
% 
%   * B = gf_mdbrick('plate_source_term', MdBrick pb[, int bnum=-1[, int nfem]])
%   Add a boundary or a volumic source term to a plate problem.  This brick has
%   two parameters: "B" is the displacement (ut and u3) source term, "M" is the
%   moment source term (i.e. the source term on the rotation of the normal).
% 
%   * B = gf_mdbrick('plate_simple_support', MdBrick pb, int bnum, string CTYPE[,
%   int nfem])
%   Add a "simple support" boundary condition to a plate problem.  Homogeneous
%   Dirichlet condition on the displacement, free rotation. `CTYPE` specifies how
%   the constraint is enforced ('penalized', 'augmented' or 'eliminated').
% 
%   * B = gf_mdbrick('plate_clamped_support', MdBrick pb, int bnum, string CTYPE[,
%   int nfem])
%   Add a "clamped support" boundary condition to a plate problem.  Homogeneous
%   Dirichlet condition on the displacement and on the rotation. `CTYPE` specifies
%   how the constraint is enforced ('penalized', 'augmented' or 'eliminated').
% 
%   * B = gf_mdbrick('plate_closing', MdBrick pb[, int nfem])
%   Add a free edges condition for the mixed plate model brick.  This brick is
%   required when the mixed linearized plate brick is used. It must be inserted
%   after all other boundary conditions (the reason is that the brick has to
%   inspect all other boundary conditions to determine the number of disconnected
%   boundary parts which are free edges).
% 
%   $Id: gf_mdbrick.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_mdbrick(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick',varargin{:});
  else
    gf_matlab('mdbrick',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
