% FUNCTION I = gf_geotrans_get(GT, ...)
%     General function for querying information about geometric transformations
%     objects.
% 
%   * d = gf_geotrans_get(CVS,'dim')
%   Get the dimension of the GeoTrans.  This is the dimension of the source space,
%   i.e. the dimension of the reference convex.
% 
%   * b = gf_geotrans_get(CVS,'is_linear')
%   Return 0 if the GeoTrans is not linear.
% 
%   * n = gf_geotrans_get(CVS,'nbpts')
%   Return the number of points of the GeoTrans.
% 
%   * P = gf_geotrans_get(CVS,'pts')
%   Return the reference convex points of the GeoTrans.  The points are stored in
%   the columns of the output matrix.
% 
%   * N = gf_geotrans_get(CVS,'normals')
%   Get the normals for each face of the reference convex of the GeoTrans.  The
%   normals are stored in the columns of the output matrix.
% 
%   * Pt = gf_geotrans_get(CVS,'transform',mat G, mat Pr)
%   Apply the GeoTrans to a set of points.  `G` is the set of vertices of the real
%   convex, `Pr` is the set of points (in the reference convex) that are to be
%   transformed. The corresponding set of points in the real convex is returned.
% 
%   * s = gf_geotrans_get(CVS,'char')
%   Output a (unique) string representation of the GeoTrans.  This can be used to
%   perform comparisons between two different GeoTrans objects.
% 
function [varargout]=gf_geotrans_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('geotrans_get',varargin{:});
  else
    gf_matlab('geotrans_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
