#  ui.rb - 
#  Copyright (c) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'geekast/views/lib/callback'
require 'geekast/views/lib/interface'

module Geekast
  module View


    class UI < CallbackMain

      def initialize
        super
        @main.signal_connect('delete_event') {
          puts "\nbye" if $DEBUG
          on_quit_activate(@main)
        }

        # test ARGV url
        if URL
          url =  "http://" + Config::PEERCAST_IP + ":" + Config::PEERCAST_PORT + "/stream/" + URL.sub("peercast://pls/", "")
        else
          url = nil
        end


        @geekastmenu_yp = ContextualMenu.new(@treeview_yp, "menu_yp", url, @model_yp)
        @geekastmenu_yp.popup

        @geekastmenu_relay = ContextualMenu.new(@treeview_relay, "menu_relay", url, @model_relay)
        @geekastmenu_relay.popup

        @geekastmenu_bookmark = ContextualMenu.new(@treeview_bookmark, "menu_bookmark", url, @model_bookmark)
        @geekastmenu_bookmark.popup

        if url
          @geekastmenu_peercast.on_play_activate
        end
    
      end
    end 

    
  end
end
