import xml.sax.handler, re


class NewsHandler(xml.sax.handler.ContentHandler):
	def __init__(self):
		self.month			= [	"Jan", "Feb", "Mar", "Apr", "May", "June", "July",
								"Aug", "Sep", "Oct", "Nov", "Dec" ]
		self.item			= []
		self.image			= ()
		self.data			= ""
		self.title			= ""
		self.description	= ""
		self.link			= ""
		self.date			= ""
		self.subject		= ""
		self.rights			= ""
		self.creator		= ""
		self.url			= ""
		self.channel		= 0

	def startElement(self, name, attributes):
		if name == "item" and self.channel == 1:
			self.channel = 0
			self.addItem()
		elif name == "channel":
			self.channel = 1

			
	def characters(self, data):
		self.data = self.data + data.strip()

		
	def addItem(self):
		self.item.append((self.title, self.description, self.link, self.date, self.subject, self.rights, self.creator))
		self.title			= ""
		self.description	= ""
		self.link			= ""
		self.date			= ""
		self.subject		= ""
		self.rights			= ""
		self.creator		= ""

		
	def addImage(self):
		self.image = (self.title, self.url, self.link)

		
	def endElement(self, name):
		if name == "channel":
			self.addItem()
			if self.channel == 1:
				self.channel = 0
		elif name == "item":
			self.addItem()
		elif name == "image":
			self.addImage()
		elif name == "title":
			self.title = self.data
		elif name == "description":
			self.description = self.data
		elif name == "link":
			self.link = self.data
		elif name == "url":
			self.url = self.data
		elif name == "dc:date" or name == "pubDate":
			m = re.search("(\d+)-(\d+)-(\d+)T(\d+):(\d+)", self.data)
			if m:
				year		= int(m.group(1))
				month		= int(m.group(2)) - 1
				date		= m.group(3)
				hour		= int(m.group(4))
				minute		= int(m.group(5))
				self.date	= "%s%s %s %d, %.2d:%.2d" % (date, self.extension(date), self.month[month], year, hour, minute)
			else:
				self.date = self.data
		elif name == "dc:subject":
			self.subject = self.data
		elif name == "dc:rights" or name == "copyright":
			self.rights = self.data
		elif name == "dc:creator" or name == "managingEditor":
			self.creator = self.data

		self.data = ""
		
		
	def extension(self, value):
		n = len(value) - 1
		if int(value) > 3 and int(value) < 21:
			return "th"
		elif value[n:] == "1":
			return "st"
		elif value[n:] == "2":
			return "nd"
		elif value[n:] == "3":
			return "rd"
		else:
			return "th"
			
