from code.Observable import Observable
from iCalLoader import iCalLoader
from iCalWriter import iCalWriter
from code import formats
from Popup import Popup
from cal.Calendar import Calendar
from CalEditor import CalEditor
from code.FileWatcher import FileWatcher
from code import sfrmapper
from code import configvalues as conf
from code import values
from code import errormessage

import gtk
import os


#
# Class for day planning functionality.
#
class Planner(Observable):

    OBS_CHANGE_CALENDAR = 0


    def __init__(self):

        self.__local_numerals = 0

        #self.__caleditor = CalEditor()
        self.__popup = Popup()
        self.__calendars = {}
        self.__my_calendar = None


        #self.__caleditor.connect_close(self.__propagate_calendar_change)

        # try loading Evolution's calendar file
        evocal = os.path.expanduser(values.EVOLUTION_CALENDAR)
        filewatcher = FileWatcher(evocal)
        filewatcher.add_observer(self.__on_calendar_change)

        # try loading my calendar file
        mycal = os.path.join(os.environ[values.DESKCALUSERHOME],
                             values.MY_CALENDAR)
        self.__calendars[mycal] = Calendar()
        #filewatcher = FileWatcher(mycal)
        #filewatcher.add_observer(self.__on_calendar_change)
        self.__on_calendar_change(None, None, mycal)
        self.__my_calendar = mycal




    #
    # Reacts on changes to calendar files.
    #
    def __on_calendar_change(self, src, cmd, file):

        if (not os.path.exists(file)): return
        
        try:
            self.__calendars[file] = iCalLoader().load(file)

        except:
            errormessage.error(_("Invalid calendar file %(file)s.") % vars())
            
        self.__propagate_calendar_change(dontsave = 1)



    #
    # Propagates changes of calendar data.
    #
    def __propagate_calendar_change(self, dontsave = 0):

        self.update_observer(self.OBS_CHANGE_CALENDAR)
        if (not dontsave):
            self.__save_calendars()



    #
    # Saves the calendars.
    #
    def __save_calendars(self):

        # save only the gDeskCal calendar
        filename = self.__my_calendar
        cal = self.__calendars[self.__my_calendar]
        try:
            iCalWriter().save(filename, cal)
            pass
        except:
            pass




    #
    # Finds a good position for the popup window.
    #
    def __find_position(self, calx, caly, calwidth, calheight):

        w, h = self.__popup.size_request()

        if (caly + calheight + h < gtk.gdk.screen_height()):
            y = caly + calheight + 4
            if (calx + w < gtk.gdk.screen_width()):
                x = calx
            else:
                x = calx + calwidth - w
                
        else:
            y = caly
            if (calx + calwidth + w < gtk.gdk.screen_width()):
                x = calx + calwidth + 4
            else:
                x = calx - w - 4
            
        return (x, y)



    #
    # Returns the events of all active calendars.
    #
    def get_events(self, year, month, day):

        events = []
        for cal in self.__calendars.values():
            events += cal.get_events(year, month, day)

        # sort events by time
        if (events):
            e = events[0]
            events.sort(e.daytime_comparator)

        return events



    #
    # Displays a popup window with events.
    #
    def popup(self, year, month, day, calwindow):

        events = self.get_events(year, month, day)
        if (not events):
            self.close_popup()
            return

        offx, offy = calwindow.get_position()
        w, h = calwindow.size_request()
        title = formats.DATEFORMAT % vars()
        if (self.__local_numerals):
            title = sfrmapper.map(title, sfrmapper.LOCAL)
        self.__popup.set_title(title)
        self.__popup.show(year, month, day, events)
        
        x, y = self.__find_position(offx, offy, w, h)
        self.__popup.move(x, y)



    #
    # Closes the popup window.
    #
    def close_popup(self):

        self.__popup.hide()



    #
    # Displays an editor for events.
    #
    def edit(self, year, month, day):

        caleditor = CalEditor()
        caleditor.connect_close(self.__propagate_calendar_change)
        caleditor.set_day(year, month, day,
                          self.__calendars[self.__my_calendar])
        caleditor.show()



    #
    # Configures the planner.
    #
    def set_config(self, config):

        # whether we use local numerals
        self.__local_numerals = config.get([conf.BEHAVIOUR,
                                            conf.NATIONAL_NUMERALS])
