###############################################################################
##
#W    bench.g    The Matrix Schreier-Sims package                
##
#H    File      : $RCSfile: bench.g,v $
#H    Author    : Henrik Brnhielm
#H    Dev start : 2004-03-22
##
#H    Version   : $Revision: 1.6 $
#H    Date      : $Date: 2004/09/15 00:52:00 $
#H    Last edit : $Author: redstar_ $
##
#H    @(#)$Id: bench.g,v 1.6 2004/09/15 00:52:00 redstar_ Exp $
###############################################################################

Revision.("matrixss/tst/bench_g") := 
  "@(#)$Id: bench.g,v 1.6 2004/09/15 00:52:00 redstar_ Exp $";;

# Must not define method for Size, since we want to compare with GAP:s
# performance.
BindGlobal("MATRIXSS_TEST", true);;
LoadPackage("matrixss");;

SetAssertionLevel(0);
MATRIXSS_DEBUGLEVEL := 0;;
SetInfoLevel(MatrixSchreierSimsInfo, MATRIXSS_DEBUGLEVEL);

MATRIXSS_RandomSchreierSimsBenchmark := 
  function(maxDegree, maxFieldSize, maxReeSize, maxSuzukiSize)
    local groups, group, test_time, size, group_time, g;
    
    test_time := Runtime();
    groups := MATRIXSS_GetBenchmarkGroups(maxDegree, maxFieldSize, 
                      maxReeSize, maxSuzukiSize);
    
    Print("Group\t\tTime [ms]\n\n");
    
    for group in [1 .. Length(groups)] do
        #DefaultStabChainOptions.random := 1;
        Print(groups[group], "\t", MATRIXSS_TimedCall(Size, 
                [Group(GeneratorsOfGroup(groups[group]))]), "\n");        
        Unbind(groups[group]);
    od;
    
    Print("Total time for test : ", Runtime() - test_time, "\n");
    
    Print("Benchmark completed\n");
    return true;
end;;

ReadTest("tst/bench.tst");;

###############################################################################
#E
