/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <unistd.h>
#include "widgets.h"
#include "gettext.h"

extern int activated;



int status_update(struct w *widgets)
{
    struct sockaddr_in myaddr;
    int port=67; /* ipv4 */
    int mastersd=0;
    int reuse=0;
    gchar *utf8, *text;
    GdkColor color;

    if((mastersd=socket(AF_INET, SOCK_DGRAM, 0))==-1)
    {
	perror("socket");
	text = g_strdup_printf(_("Status: Deactivated"));
        utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(widgets->onoff_label), utf8);
        g_free(utf8);
	g_free(text);
	activated = 0;

	/* Set status color */
	gdk_color_parse("red", &color);
	gtk_widget_modify_fg(widgets->onoff_label, GTK_STATE_NORMAL, &color);

        return TRUE;
    }

    if(setsockopt(mastersd, SOL_SOCKET, SO_REUSEADDR, &reuse, sizeof(int))==-1)
    {
        perror("setsockopt");
	text = g_strdup_printf(_("Status: Deactivated"));
        utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(widgets->onoff_label), utf8);
        g_free(utf8);
	g_free(text);
        close(mastersd);
        activated = 0;

	/* Set status color */
	gdk_color_parse("red", &color);
	gtk_widget_modify_fg(widgets->onoff_label, GTK_STATE_NORMAL, &color);

        return TRUE;
    }
    
    myaddr.sin_family = AF_INET;
    myaddr.sin_addr.s_addr = INADDR_ANY;
    myaddr.sin_port = htons(port);
    memset(&(myaddr.sin_zero), 0, sizeof(myaddr.sin_zero));
    
    if(bind(mastersd, (struct sockaddr *)&myaddr, sizeof(myaddr))==-1)
    {
	text = g_strdup_printf(_("Status: Activated"));
	utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
	gtk_label_set_text(GTK_LABEL(widgets->onoff_label), utf8);
	g_free(utf8);
        g_free(text);
	close(mastersd);
	activated = 1;

	/* Set status color */
	gdk_color_parse("dark green", &color);
	gtk_widget_modify_fg(widgets->onoff_label, GTK_STATE_NORMAL, &color);
    }
    else
      {
	  text = g_strdup_printf(_("Status: Deactivated"));
	  utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
	  gtk_label_set_text(GTK_LABEL(widgets->onoff_label), utf8);
	  g_free(utf8);
	  g_free(text);
	  close(mastersd);
	  activated=0;

	  /* Set status color */
	  gdk_color_parse("red", &color);
	  gtk_widget_modify_fg(widgets->onoff_label, GTK_STATE_NORMAL, &color);
      }

    return TRUE;
}
