/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "populate_leases.h"
#include "clear_leases.h"


void create_lease_tab(struct w *widgets)
{
    /* Create the leases textview in a scrolled window */
    GtkWidget *leases_hbox, *leases_scrolled_window;
    GtkWidget *leases_hbuttonbox, *leases_clear_button, *leases_update_button;
    
    leases_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox3), leases_hbox, TRUE, TRUE, 0);

    leases_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(leases_hbox), leases_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(leases_scrolled_window), 
							    GTK_POLICY_AUTOMATIC, 
							    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(leases_scrolled_window, -1, 140);

    widgets->leases_textview = gtk_text_view_new();
    gtk_container_add (GTK_CONTAINER (leases_scrolled_window), widgets->leases_textview);

    /* The leases clear and update buttons */
    leases_hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox3), leases_hbuttonbox, FALSE, TRUE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(leases_hbuttonbox), GTK_BUTTONBOX_SPREAD);

    leases_clear_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_container_add(GTK_CONTAINER(leases_hbuttonbox), leases_clear_button);
    g_signal_connect_swapped(G_OBJECT(leases_clear_button), "clicked", 
                             G_CALLBACK(clear_leases), widgets);
    
    leases_update_button = gtk_button_new_from_stock(GTK_STOCK_REFRESH);
    gtk_container_add(GTK_CONTAINER(leases_hbuttonbox), leases_update_button);
    g_signal_connect_swapped(G_OBJECT(leases_update_button), "clicked", 
                             G_CALLBACK(populate_leases), widgets);
}
