/********************************************************************************/
static gboolean read_orbitals_in_nbo_file(gchar *fileName,gint nAlpha, gint nBeta)
{
 	FILE *file;
 	gint i;
	gint k;
	gint j;
	gdouble **CoefOrbitals;
	gdouble *EnerOrbitals;
	gchar **SymOrbitals;
	
 	if ((!fileName) || (strcmp(fileName,"") == 0))
 	{
		Message(_("Sorry No file selected\n"),_("Error"),TRUE);
    		return FALSE;
 	}

 	file = FOpen(fileName, "rb");
 	if(file ==NULL)
 	{
		gchar buffer[BSIZE];
		sprintf(buffer,_("Sorry, I can not open '%s' file\n"),fileName);
  		Message(buffer,_("Error"),TRUE);
  		return FALSE;
 	}
	if(!goToLine(file,"--------")) return FALSE;

  
	Debug("Norb = %d\n",NOrb);
	CoefOrbitals = CreateTable2(NOrb);
	EnerOrbitals = g_malloc(NOrb*sizeof(gdouble));
	SymOrbitals = g_malloc(NOrb*sizeof(gchar*));

	for(j=0;j<NOrb;j++)
	{
		EnerOrbitals[j]=0.0;
		for(i=0;i<NOrb;i++)
		{
			if(1!=fscanf(file,"%lf",&CoefOrbitals[i][j]))break;
		}
		if(i!=NOrb)
		{
			for(k=j;k<NOrb;k++) SymOrbitals[k] = g_strdup("DELETED");
			break;
		}
		SymOrbitals[j] = g_strdup("UNK");
	}
	printf("norb read=%d\n",j);
	CoefAlphaOrbitals = CoefOrbitals;
	EnerAlphaOrbitals = EnerOrbitals;
	SymAlphaOrbitals = SymOrbitals;
	OccAlphaOrbitals = g_malloc(NOrb*sizeof(gdouble));
	for(i=0;i<nAlpha;i++) OccAlphaOrbitals[i] = 1.0;
	for(i=nAlpha;i<NOrb;i++) OccAlphaOrbitals[i] = 0.0;

	CoefBetaOrbitals = CoefOrbitals;
	EnerBetaOrbitals = EnerOrbitals;
	OccBetaOrbitals = OccAlphaOrbitals;
	SymBetaOrbitals = SymOrbitals;
	NAlphaOcc = nAlpha;
	NBetaOcc = nBeta;
	NAlphaOrb = NOrb;
	NBetaOrb = NOrb;
 	fclose(file);

	return TRUE;
}
