//
// C++ Interface: keyboardview
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KEYBOARDVIEW_H
#define KEYBOARDVIEW_H

#include <qcanvas.h>
#include <qpainter.h>
#include <qmutex.h>
#include "pics/icons.h"
#include "defs.h"
#include "beatlinedata.h"
#include "qfontmetrics.h"

/**
@author Predrag Viceic
*/
class KeyboardView : public QCanvasRectangle
{


public:
    KeyboardView(QCanvas* canvas);

    ~KeyboardView();
    void setY(double y);
    void setX(double x);
    int rtti() const;
    void initKeys();
    void mouseReleaseEvent(QMouseEvent * e);
    void mousePressEvent(QMouseEvent * e);
    void bake();
    void setVisible ( bool yes );

    void setBeatlinePos(const long& theValue);
	

    long getBeatlinePos() const;
    int getMidiNoteFor(long samplepos);
    enum arrow_pressed_t {LEFT,RIGHT,NONE};
    arrow_pressed_t arrowPressed;
	
	
	
    enum keyState {KEY_FREE, KEY_ASSIGNED, KEY_CURRENT};
    enum invisibleMidi {FROM_LEFT, FROM_RIGHT, NOT_A_NOTE, IM_NONE};
    invisibleMidi invMidi;
    struct Key{
        int note;
        int color; //0=white, 1=black
        keyState state;
        QRect rect;
        int midiOn;
        long beatlinesamplepos;
        int getOctave(){
            return note/12;
        }
        bool operator<( const Key _key)
        {
            return note<_key.note;
        }
        bool operator==( const Key _key)
        {
            return note==_key.note;
        }
    };
    typedef QValueList<Key> KeyList;
    void setKeys(KeyList theValue);
    KeyList getKeys();
    void showMidiKey(int onoff, int key, int velocity);
    long getSamplePosFor(int midiNote);
    void initKeys(QValueList <beatline_data>);
    Key* getKey(int midiNote);
    void transposeAll(int amountNotes);
    void assignMissingMidiAll(int start_note);
    void assignMissingMidiLoop(int start_note);
    int getCurrentKey();
    void setLoop(long l, long r);
    void setBeatlineData(QValueList <beatline_data> bld);
    Key* getNextFreeKey(int note);
    enum transposeKeyClicked_t {TKC_NOTE_DOWN, TKC_NOTE_UP, TKC_OCTAVE_DOWN, TKC_OCTAVE_UP, TKC_NONE};
    enum aaKeyClicked_t {AAKC_LOOP, AAKC_ALL, AAKC_CLEAR,AAKC_NONE};
    
protected:
    int octaveheight;
    int octavewidth;
    int visibleNbOctaves;
    int blackWidth;
    int whiteWidth;
    int blackHeight;
    KeyList keys;
    long beatlinePos;
    int arrowWidth;
    int currentOctave;
    int maxNbOctaves;
    int headerHeight;
    QRect noteDownR;
    QRect noteUpR;
    QRect octaveDownR;
    QRect octaveUpR;
    transposeKeyClicked_t transposeKeyClicked;
    aaKeyClicked_t aaKeyClicked;
    QRect aaMidiAllR;
    QRect aaMidiLoopR;
    QRect clearMidiR;
    long rightLoop;
    long leftLoop;
    QValueList <beatline_data> beatlineData;
protected:
    void drawShape(QPainter & p);
    

};

#endif
