/* set-duplicate-email.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from set-duplicate-email.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_SET_DUPLICATE_EMAIL_TESTS (set_duplicate_email_tests_get_type ())
#define SET_DUPLICATE_EMAIL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTests))
#define SET_DUPLICATE_EMAIL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsClass))
#define IS_SET_DUPLICATE_EMAIL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS))
#define IS_SET_DUPLICATE_EMAIL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_DUPLICATE_EMAIL_TESTS))
#define SET_DUPLICATE_EMAIL_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsClass))

typedef struct _SetDuplicateEmailTests SetDuplicateEmailTests;
typedef struct _SetDuplicateEmailTestsClass SetDuplicateEmailTestsClass;
typedef struct _SetDuplicateEmailTestsPrivate SetDuplicateEmailTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData;
typedef struct _SetDuplicateEmailTestsTryToAddData SetDuplicateEmailTestsTryToAddData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SetDuplicateEmailTestsAddPersonasData SetDuplicateEmailTestsAddPersonasData;

struct _SetDuplicateEmailTests {
	FolksTestCase parent_instance;
	SetDuplicateEmailTestsPrivate * priv;
};

struct _SetDuplicateEmailTestsClass {
	FolksTestCaseClass parent_class;
};

struct _SetDuplicateEmailTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _email_1;
	gboolean _added_personas;
	GStaticRecMutex __lock__added_personas;
	TrfPersonaStore* _pstore;
	gboolean _email_found;
};

struct _SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksBackendStore* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksBackendStore* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _backend_it;
	GeeIterator* _tmp13_;
	gboolean _tmp14_;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	FolksBackend* backend;
	FolksBackend* _tmp17_;
	GeeMap* _tmp18_;
	GeeMap* _tmp19_;
	gpointer _tmp20_;
	TrfPersonaStore* _tmp21_;
	TrfPersonaStore* _tmp22_;
	TrfPersonaStore* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};

struct _SetDuplicateEmailTestsTryToAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrfPersonaStore* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_;
};

struct _SetDuplicateEmailTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SetDuplicateEmailTests* self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* details1;
	GValue* val;
	GValue _tmp3_;
	GValue _tmp4_;
	GValue _tmp5_;
	GValue* _tmp6_;
	GValue* _tmp7_;
	const gchar* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GValue* _tmp12_;
	GValue _tmp13_;
	GValue _tmp14_;
	GValue _tmp15_;
	GValue* _tmp16_;
	GeeHashSet* _tmp17_;
	GeeHashSet* emails1;
	const gchar* _tmp18_;
	FolksEmailFieldDetails* _tmp19_;
	FolksEmailFieldDetails* email_1;
	GeeHashSet* _tmp20_;
	FolksEmailFieldDetails* _tmp21_;
	GValue* _tmp22_;
	GeeHashSet* _tmp23_;
	GHashTable* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GValue* _tmp27_;
	FolksIndividualAggregator* _tmp28_;
	TrfPersonaStore* _tmp29_;
	GHashTable* _tmp30_;
	FolksPersona* _tmp31_;
	FolksPersona* _tmp32_;
	GError* e;
	GError* _tmp33_;
	const gchar* _tmp34_;
	GError * _inner_error_;
};


static gpointer set_duplicate_email_tests_parent_class = NULL;

GType set_duplicate_email_tests_get_type (void) G_GNUC_CONST;
#define SET_DUPLICATE_EMAIL_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SET_DUPLICATE_EMAIL_TESTS, SetDuplicateEmailTestsPrivate))
enum  {
	SET_DUPLICATE_EMAIL_TESTS_DUMMY_PROPERTY
};
SetDuplicateEmailTests* set_duplicate_email_tests_new (void);
SetDuplicateEmailTests* set_duplicate_email_tests_construct (GType object_type);
void set_duplicate_email_tests_test_set_duplicate_email (SetDuplicateEmailTests* self);
static void _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method (gpointer self);
static void set_duplicate_email_tests_real_set_up (FolksTestCase* base);
static void set_duplicate_email_tests_real_tear_down (FolksTestCase* base);
static void _set_duplicate_email_tests_test_set_duplicate_email_async (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_test_set_duplicate_email_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (SetDuplicateEmailTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _set_duplicate_email_tests_test_set_duplicate_email_async_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_test_set_duplicate_email_async_co (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_);
static void _set_duplicate_email_tests_test_set_duplicate_email_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _set_duplicate_email_tests_individuals_changed_cb (SetDuplicateEmailTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _set_duplicate_email_tests_notify_pstore_cb (SetDuplicateEmailTests* self, GObject* _pstore, GParamSpec* ps);
static void __set_duplicate_email_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _set_duplicate_email_tests_try_to_add (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_try_to_add_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static void _set_duplicate_email_tests_reset_email_address (SetDuplicateEmailTests* self, FolksIndividual* i);
static gboolean _set_duplicate_email_tests_has_email (SetDuplicateEmailTests* self, TrfPersona* persona, const gchar* email);
static void _set_duplicate_email_tests_email_addresses_cb (SetDuplicateEmailTests* self, GObject* p, GParamSpec* ps);
static void __set_duplicate_email_tests_email_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _set_duplicate_email_tests_try_to_add_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_try_to_add_co (SetDuplicateEmailTestsTryToAddData* _data_);
static void _set_duplicate_email_tests_add_personas (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _set_duplicate_email_tests_add_personas_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_);
static void _set_duplicate_email_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _set_duplicate_email_tests_add_personas_data_free (gpointer _data);
static gboolean _set_duplicate_email_tests_add_personas_co (SetDuplicateEmailTestsAddPersonasData* _data_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _set_duplicate_email_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void set_duplicate_email_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method (gpointer self) {
	set_duplicate_email_tests_test_set_duplicate_email (self);
}


SetDuplicateEmailTests* set_duplicate_email_tests_construct (GType object_type) {
	SetDuplicateEmailTests * self = NULL;
	TrackerTestBackend* _tmp0_;
	self = (SetDuplicateEmailTests*) folks_test_case_construct (object_type, "SetDuplicateEmailTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test re-setting an existing e-mail address", _set_duplicate_email_tests_test_set_duplicate_email_folks_test_case_test_method, self);
	return self;
}


SetDuplicateEmailTests* set_duplicate_email_tests_new (void) {
	return set_duplicate_email_tests_construct (TYPE_SET_DUPLICATE_EMAIL_TESTS);
}


static void set_duplicate_email_tests_real_set_up (FolksTestCase* base) {
	SetDuplicateEmailTests * self;
	self = (SetDuplicateEmailTests*) base;
}


static void set_duplicate_email_tests_real_tear_down (FolksTestCase* base) {
	SetDuplicateEmailTests * self;
	TrackerTestBackend* _tmp0_;
	self = (SetDuplicateEmailTests*) base;
	_tmp0_ = self->priv->_tracker_backend;
	tracker_test_backend_tear_down (_tmp0_);
}


static gboolean _lambda0_ (SetDuplicateEmailTests* self) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	_tmp0_ = self->priv->_main_loop;
	g_main_loop_quit (_tmp0_);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void set_duplicate_email_tests_test_set_duplicate_email (SetDuplicateEmailTests* self) {
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	self->priv->_email_found = FALSE;
	_set_duplicate_email_tests_test_set_duplicate_email_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->_main_loop;
	g_main_loop_run (_tmp1_);
	_tmp2_ = self->priv->_email_found;
	g_assert (_tmp2_ == TRUE);
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async_data_free (gpointer _data) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	SetDuplicateEmailTests* _tmp0_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_test_set_duplicate_email_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_test_set_duplicate_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_set_duplicate_email_tests_test_set_duplicate_email_async_co (_data_);
}


static void _set_duplicate_email_tests_test_set_duplicate_email_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _set_duplicate_email_tests_test_set_duplicate_email_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_set_duplicate_email_tests_test_set_duplicate_email_async_co (_data_);
}


static void __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_set_duplicate_email_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void __set_duplicate_email_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_set_duplicate_email_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _set_duplicate_email_tests_test_set_duplicate_email_async_co (SetDuplicateEmailTestsTestSetDuplicateEmailAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_backend_store_dup ();
	_data_->store = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->store;
	_data_->_state_ = 1;
	folks_backend_store_prepare (_data_->_tmp1_, _set_duplicate_email_tests_test_set_duplicate_email_async_ready, _data_);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_tmp2_ = folks_individual_aggregator_new ();
	_g_object_unref0 (_data_->self->priv->_aggregator);
	_data_->self->priv->_aggregator = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->_aggregator;
	g_signal_connect_object (_data_->_tmp3_, "individuals-changed", (GCallback) __set_duplicate_email_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, _data_->self, 0);
	{
		_data_->_tmp4_ = _data_->self->priv->_aggregator;
		_data_->_state_ = 2;
		folks_individual_aggregator_prepare (_data_->_tmp4_, _set_duplicate_email_tests_test_set_duplicate_email_async_ready, _data_);
		return FALSE;
		_state_2:
		folks_individual_aggregator_prepare_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->self->priv->_pstore);
		_data_->self->priv->_pstore = NULL;
		{
			_data_->_tmp5_ = _data_->store;
			_data_->_tmp6_ = folks_backend_store_get_enabled_backends (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = gee_map_get_values (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_g_object_unref0 (_data_->_tmp10_);
			_data_->_backend_it = _data_->_tmp12_;
			while (TRUE) {
				_data_->_tmp13_ = _data_->_backend_it;
				_data_->_tmp14_ = FALSE;
				_data_->_tmp14_ = gee_iterator_next (_data_->_tmp13_);
				if (!_data_->_tmp14_) {
					break;
				}
				_data_->_tmp15_ = _data_->_backend_it;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
				_data_->backend = (FolksBackend*) _data_->_tmp16_;
				_data_->_tmp17_ = _data_->backend;
				_data_->_tmp18_ = folks_backend_get_persona_stores (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = gee_map_get (_data_->_tmp19_, "tracker");
				_g_object_unref0 (_data_->self->priv->_pstore);
				_data_->self->priv->_pstore = TRF_PERSONA_STORE ((FolksPersonaStore*) _data_->_tmp20_);
				_data_->_tmp21_ = _data_->self->priv->_pstore;
				if (_data_->_tmp21_ != NULL) {
					_g_object_unref0 (_data_->backend);
					break;
				}
				_g_object_unref0 (_data_->backend);
			}
			_g_object_unref0 (_data_->_backend_it);
		}
		_data_->_tmp22_ = _data_->self->priv->_pstore;
		g_assert (_data_->_tmp22_ != NULL);
		_data_->_tmp23_ = _data_->self->priv->_pstore;
		g_signal_connect_object ((GObject*) _data_->_tmp23_, "notify::is-prepared", (GCallback) __set_duplicate_email_tests_notify_pstore_cb_g_object_notify, _data_->self, 0);
		_set_duplicate_email_tests_try_to_add (_data_->self, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_warning ("set-duplicate-email.vala:100: Error when calling prepare: %s\n", _data_->_tmp25_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _set_duplicate_email_tests_individuals_changed_cb (SetDuplicateEmailTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp6_ = i;
			_tmp7_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->_persona_fullname_1;
			if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
				FolksIndividual* _tmp10_;
				_tmp10_ = i;
				_set_duplicate_email_tests_reset_email_address (self, _tmp10_);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp11_ = removed;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	g_assert (_tmp13_ == 0);
}


static void __set_duplicate_email_tests_email_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_set_duplicate_email_tests_email_addresses_cb (self, _sender, pspec);
}


static void _set_duplicate_email_tests_reset_email_address (SetDuplicateEmailTests* self, FolksIndividual* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	{
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = i;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksPersona* p;
			FolksPersona* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = self->priv->_email_1;
			_tmp10_ = _set_duplicate_email_tests_has_email (self, TRF_PERSONA (_tmp8_), _tmp9_);
			if (_tmp10_) {
				GeeHashSet* _tmp11_;
				GeeHashSet* emails1;
				const gchar* _tmp12_;
				FolksEmailFieldDetails* _tmp13_;
				FolksEmailFieldDetails* email_1;
				GeeHashSet* _tmp14_;
				FolksEmailFieldDetails* _tmp15_;
				FolksPersona* _tmp16_;
				GeeHashSet* _tmp17_;
				FolksPersona* _tmp18_;
				_tmp11_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
				emails1 = _tmp11_;
				_tmp12_ = self->priv->_email_1;
				_tmp13_ = folks_email_field_details_new (_tmp12_, NULL);
				email_1 = _tmp13_;
				_tmp14_ = emails1;
				_tmp15_ = email_1;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
				_tmp16_ = p;
				_tmp17_ = emails1;
				folks_email_details_set_email_addresses (FOLKS_EMAIL_DETAILS (_tmp16_), (GeeSet*) _tmp17_);
				_tmp18_ = p;
				g_signal_connect_object ((GObject*) _tmp18_, "notify::email-addresses", (GCallback) __set_duplicate_email_tests_email_addresses_cb_g_object_notify, self, 0);
				_g_object_unref0 (email_1);
				_g_object_unref0 (emails1);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


static void _set_duplicate_email_tests_email_addresses_cb (SetDuplicateEmailTests* self, GObject* p, GParamSpec* ps) {
	GObject* _tmp0_;
	TrfPersona* _tmp1_;
	TrfPersona* persona;
	TrfPersona* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (TRF_PERSONA (_tmp0_));
	persona = _tmp1_;
	_tmp2_ = persona;
	_tmp3_ = self->priv->_email_1;
	_tmp4_ = _set_duplicate_email_tests_has_email (self, _tmp2_, _tmp3_);
	if (_tmp4_) {
		GMainLoop* _tmp5_;
		self->priv->_email_found = TRUE;
		_tmp5_ = self->priv->_main_loop;
		g_main_loop_quit (_tmp5_);
	}
	_g_object_unref0 (persona);
}


static gboolean _set_duplicate_email_tests_has_email (SetDuplicateEmailTests* self, TrfPersona* persona, const gchar* email) {
	gboolean result = FALSE;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (persona != NULL, FALSE);
	g_return_val_if_fail (email != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		{
			TrfPersona* _tmp3_;
			GeeSet* _tmp4_;
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _fd_it;
			_tmp3_ = persona;
			_tmp4_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_fd_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				gboolean _tmp8_ = FALSE;
				GeeIterator* _tmp9_;
				gpointer _tmp10_ = NULL;
				FolksEmailFieldDetails* fd;
				FolksEmailFieldDetails* _tmp11_;
				gconstpointer _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp7_ = _fd_it;
				_tmp8_ = gee_iterator_next (_tmp7_);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = _fd_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				fd = (FolksEmailFieldDetails*) _tmp10_;
				_tmp11_ = fd;
				_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = email;
				if (g_strcmp0 ((const gchar*) _tmp13_, _tmp14_) == 0) {
					result = TRUE;
					_g_object_unref0 (fd);
					_g_object_unref0 (_fd_it);
					return result;
				}
				_g_object_unref0 (fd);
			}
			_g_object_unref0 (_fd_it);
		}
	}
	result = FALSE;
	return result;
}


static void _set_duplicate_email_tests_notify_pstore_cb (SetDuplicateEmailTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_set_duplicate_email_tests_try_to_add (self, NULL, NULL);
}


static void _set_duplicate_email_tests_try_to_add_data_free (gpointer _data) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SetDuplicateEmailTestsTryToAddData, _data_);
}


static void _set_duplicate_email_tests_try_to_add (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	SetDuplicateEmailTests* _tmp0_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsTryToAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_try_to_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_try_to_add_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_set_duplicate_email_tests_try_to_add_co (_data_);
}


static void _set_duplicate_email_tests_try_to_add_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _set_duplicate_email_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsTryToAddData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_set_duplicate_email_tests_try_to_add_co (_data_);
}


static gboolean _set_duplicate_email_tests_try_to_add_co (SetDuplicateEmailTestsTryToAddData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_added_personas;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__added_personas);
		{
			_data_->_tmp2_ = _data_->self->priv->_pstore;
			_data_->_tmp3_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) _data_->_tmp2_);
			_data_->_tmp4_ = _data_->_tmp3_;
			if (_data_->_tmp4_) {
				_data_->_tmp5_ = _data_->self->priv->_added_personas;
				_data_->_tmp1_ = _data_->_tmp5_ == FALSE;
			} else {
				_data_->_tmp1_ = FALSE;
			}
			_data_->_tmp6_ = _data_->_tmp1_;
			if (_data_->_tmp6_) {
				_data_->self->priv->_added_personas = TRUE;
				_data_->_state_ = 1;
				_set_duplicate_email_tests_add_personas (_data_->self, _set_duplicate_email_tests_try_to_add_ready, _data_);
				return FALSE;
				_state_1:
				_set_duplicate_email_tests_add_personas_finish (_data_->self, _data_->_res_);
			}
		}
		__finally1:
		{
			_data_->_tmp7_ = _data_->self->priv->_added_personas;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__added_personas);
		}
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _set_duplicate_email_tests_add_personas_data_free (gpointer _data) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SetDuplicateEmailTestsAddPersonasData, _data_);
}


static void _set_duplicate_email_tests_add_personas (SetDuplicateEmailTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	SetDuplicateEmailTests* _tmp0_;
	_data_ = g_slice_new0 (SetDuplicateEmailTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _set_duplicate_email_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _set_duplicate_email_tests_add_personas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_set_duplicate_email_tests_add_personas_co (_data_);
}


static void _set_duplicate_email_tests_add_personas_finish (SetDuplicateEmailTests* self, GAsyncResult* _res_) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add 1 persona and once we've seen it try to re-set it's
   * e-mail address (the Tracker backend should figure it already
   * exist so we don't bump into a constraint error).
   * See https://bugzilla.gnome.org/show_bug.cgi?id=647331 */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _set_duplicate_email_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SetDuplicateEmailTestsAddPersonasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_set_duplicate_email_tests_add_personas_co (_data_);
}


static gboolean _set_duplicate_email_tests_add_personas_co (SetDuplicateEmailTestsAddPersonasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, __vala_GValue_free0_);
	_data_->details1 = _data_->_tmp2_;
	memset (&_data_->_tmp3_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp3_, G_TYPE_STRING);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = __g_value_dup0 (&_data_->_tmp5_);
	__vala_GValue_free0 (_data_->val);
	_data_->val = _data_->_tmp6_;
	G_IS_VALUE (&_data_->_tmp5_) ? (g_value_unset (&_data_->_tmp5_), NULL) : NULL;
	_data_->_tmp7_ = _data_->val;
	_data_->_tmp8_ = _data_->self->priv->_persona_fullname_1;
	g_value_set_string (_data_->_tmp7_, _data_->_tmp8_);
	_data_->_tmp9_ = _data_->details1;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->val;
	_data_->val = NULL;
	g_hash_table_insert (_data_->_tmp9_, _data_->_tmp11_, _data_->_tmp12_);
	memset (&_data_->_tmp13_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp13_, GEE_TYPE_SET);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = __g_value_dup0 (&_data_->_tmp15_);
	__vala_GValue_free0 (_data_->val);
	_data_->val = _data_->_tmp16_;
	G_IS_VALUE (&_data_->_tmp15_) ? (g_value_unset (&_data_->_tmp15_), NULL) : NULL;
	_data_->_tmp17_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_data_->emails1 = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->self->priv->_email_1;
	_data_->_tmp19_ = folks_email_field_details_new (_data_->_tmp18_, NULL);
	_data_->email_1 = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->emails1;
	_data_->_tmp21_ = _data_->email_1;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp20_, _data_->_tmp21_);
	_data_->_tmp22_ = _data_->val;
	_data_->_tmp23_ = _data_->emails1;
	g_value_set_object (_data_->_tmp22_, (GObject*) _data_->_tmp23_);
	_data_->_tmp24_ = _data_->details1;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
	_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->val;
	_data_->val = NULL;
	g_hash_table_insert (_data_->_tmp24_, _data_->_tmp26_, _data_->_tmp27_);
	{
		_data_->_tmp28_ = _data_->self->priv->_aggregator;
		_data_->_tmp29_ = _data_->self->priv->_pstore;
		_data_->_tmp30_ = _data_->details1;
		_data_->_state_ = 1;
		folks_individual_aggregator_add_persona_from_details (_data_->_tmp28_, NULL, (FolksPersonaStore*) _data_->_tmp29_, _data_->_tmp30_, _set_duplicate_email_tests_add_personas_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_g_object_unref0 (_data_->_tmp32_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				goto __catch2_folks_individual_aggregator_error;
			}
			_g_object_unref0 (_data_->email_1);
			_g_object_unref0 (_data_->emails1);
			__vala_GValue_free0 (_data_->val);
			_g_hash_table_unref0 (_data_->details1);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally2;
	__catch2_folks_individual_aggregator_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = _data_->e;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("set-duplicate-email.vala:216: [AddPersonaError] add_persona_from_detai" \
"ls: %s\n", _data_->_tmp34_);
		_g_error_free0 (_data_->e);
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->email_1);
		_g_object_unref0 (_data_->emails1);
		__vala_GValue_free0 (_data_->val);
		_g_hash_table_unref0 (_data_->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->email_1);
	_g_object_unref0 (_data_->emails1);
	__vala_GValue_free0 (_data_->val);
	_g_hash_table_unref0 (_data_->details1);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void set_duplicate_email_tests_class_init (SetDuplicateEmailTestsClass * klass) {
	set_duplicate_email_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetDuplicateEmailTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = set_duplicate_email_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = set_duplicate_email_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = set_duplicate_email_tests_finalize;
}


static void set_duplicate_email_tests_instance_init (SetDuplicateEmailTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = SET_DUPLICATE_EMAIL_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("persona #1");
	self->priv->_persona_fullname_1 = _tmp0_;
	_tmp1_ = g_strdup ("some-address@example.org");
	self->priv->_email_1 = _tmp1_;
	g_static_rec_mutex_init (&self->priv->__lock__added_personas);
	self->priv->_added_personas = FALSE;
}


static void set_duplicate_email_tests_finalize (GObject* obj) {
	SetDuplicateEmailTests * self;
	self = SET_DUPLICATE_EMAIL_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_email_1);
	g_static_rec_mutex_free (&self->priv->__lock__added_personas);
	_g_object_unref0 (self->priv->_pstore);
	G_OBJECT_CLASS (set_duplicate_email_tests_parent_class)->finalize (obj);
}


GType set_duplicate_email_tests_get_type (void) {
	static volatile gsize set_duplicate_email_tests_type_id__volatile = 0;
	if (g_once_init_enter (&set_duplicate_email_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetDuplicateEmailTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_duplicate_email_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetDuplicateEmailTests), 0, (GInstanceInitFunc) set_duplicate_email_tests_instance_init, NULL };
		GType set_duplicate_email_tests_type_id;
		set_duplicate_email_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "SetDuplicateEmailTests", &g_define_type_info, 0);
		g_once_init_leave (&set_duplicate_email_tests_type_id__volatile, set_duplicate_email_tests_type_id);
	}
	return set_duplicate_email_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	GTestSuite* _tmp1_;
	SetDuplicateEmailTests* _tmp2_;
	SetDuplicateEmailTests* _tmp3_;
	GTestSuite* _tmp4_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = root;
	_tmp2_ = set_duplicate_email_tests_new ();
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_test_case_get_suite ((FolksTestCase*) _tmp3_);
	g_test_suite_add_suite (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



