/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Feb 21 19:02:42 EST 2012 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2cf.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 10 -name r2cfII_10 -dft-II -include r2cfII.h */

/*
 * This function contains 32 FP additions, 18 FP multiplications,
 * (or, 14 additions, 0 multiplications, 18 fused multiply/add),
 * 37 stack variables, 4 constants, and 20 memory accesses
 */
#include "r2cfII.h"

static void r2cfII_10(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(rs), MAKE_VOLATILE_STRIDE(csr), MAKE_VOLATILE_STRIDE(csi)) {
	       E Tq, Ti, Tk, Tu, Tw, Tp, Tb, Tj, Tr, Tv;
	       {
		    E T1, To, Ts, Tt, T8, Ta, Te, Tm, Tl, Th, Tn, T9;
		    T1 = R0[0];
		    To = R1[WS(rs, 2)];
		    {
			 E T2, T3, T5, T6;
			 T2 = R0[WS(rs, 2)];
			 T3 = R0[WS(rs, 3)];
			 T5 = R0[WS(rs, 4)];
			 T6 = R0[WS(rs, 1)];
			 {
			      E Tc, T4, T7, Td, Tf, Tg;
			      Tc = R1[0];
			      Ts = T2 + T3;
			      T4 = T2 - T3;
			      Tt = T5 + T6;
			      T7 = T5 - T6;
			      Td = R1[WS(rs, 4)];
			      Tf = R1[WS(rs, 1)];
			      Tg = R1[WS(rs, 3)];
			      T8 = T4 + T7;
			      Ta = T4 - T7;
			      Te = Tc - Td;
			      Tm = Tc + Td;
			      Tl = Tf + Tg;
			      Th = Tf - Tg;
			 }
		    }
		    Cr[WS(csr, 2)] = T1 + T8;
		    Tn = Tl - Tm;
		    Tq = Tm + Tl;
		    Ti = FMA(KP618033988, Th, Te);
		    Tk = FNMS(KP618033988, Te, Th);
		    Ci[WS(csi, 2)] = Tn - To;
		    T9 = FNMS(KP250000000, T8, T1);
		    Tu = FMA(KP618033988, Tt, Ts);
		    Tw = FNMS(KP618033988, Ts, Tt);
		    Tp = FMA(KP250000000, Tn, To);
		    Tb = FMA(KP559016994, Ta, T9);
		    Tj = FNMS(KP559016994, Ta, T9);
	       }
	       Tr = FMA(KP559016994, Tq, Tp);
	       Tv = FNMS(KP559016994, Tq, Tp);
	       Cr[WS(csr, 1)] = FNMS(KP951056516, Tk, Tj);
	       Cr[WS(csr, 3)] = FMA(KP951056516, Tk, Tj);
	       Cr[0] = FMA(KP951056516, Ti, Tb);
	       Cr[WS(csr, 4)] = FNMS(KP951056516, Ti, Tb);
	       Ci[WS(csi, 1)] = FNMS(KP951056516, Tw, Tv);
	       Ci[WS(csi, 3)] = FMA(KP951056516, Tw, Tv);
	       Ci[WS(csi, 4)] = FMS(KP951056516, Tu, Tr);
	       Ci[0] = -(FMA(KP951056516, Tu, Tr));
	  }
     }
}

static const kr2c_desc desc = { 10, "r2cfII_10", {14, 0, 18, 0}, &GENUS };

void X(codelet_r2cfII_10) (planner *p) {
     X(kr2c_register) (p, r2cfII_10, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2cf.native -compact -variables 4 -pipeline-latency 4 -n 10 -name r2cfII_10 -dft-II -include r2cfII.h */

/*
 * This function contains 32 FP additions, 12 FP multiplications,
 * (or, 26 additions, 6 multiplications, 6 fused multiply/add),
 * 21 stack variables, 4 constants, and 20 memory accesses
 */
#include "r2cfII.h"

static void r2cfII_10(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(rs), MAKE_VOLATILE_STRIDE(csr), MAKE_VOLATILE_STRIDE(csi)) {
	       E T1, To, T8, Tq, T9, Tp, Te, Ts, Th, Tn;
	       T1 = R0[0];
	       To = R1[WS(rs, 2)];
	       {
		    E T2, T3, T4, T5, T6, T7;
		    T2 = R0[WS(rs, 2)];
		    T3 = R0[WS(rs, 3)];
		    T4 = T2 - T3;
		    T5 = R0[WS(rs, 4)];
		    T6 = R0[WS(rs, 1)];
		    T7 = T5 - T6;
		    T8 = T4 + T7;
		    Tq = T5 + T6;
		    T9 = KP559016994 * (T4 - T7);
		    Tp = T2 + T3;
	       }
	       {
		    E Tc, Td, Tm, Tf, Tg, Tl;
		    Tc = R1[0];
		    Td = R1[WS(rs, 4)];
		    Tm = Tc + Td;
		    Tf = R1[WS(rs, 1)];
		    Tg = R1[WS(rs, 3)];
		    Tl = Tf + Tg;
		    Te = Tc - Td;
		    Ts = KP559016994 * (Tm + Tl);
		    Th = Tf - Tg;
		    Tn = Tl - Tm;
	       }
	       Cr[WS(csr, 2)] = T1 + T8;
	       Ci[WS(csi, 2)] = Tn - To;
	       {
		    E Ti, Tk, Tb, Tj, Ta;
		    Ti = FMA(KP951056516, Te, KP587785252 * Th);
		    Tk = FNMS(KP587785252, Te, KP951056516 * Th);
		    Ta = FNMS(KP250000000, T8, T1);
		    Tb = T9 + Ta;
		    Tj = Ta - T9;
		    Cr[WS(csr, 4)] = Tb - Ti;
		    Cr[WS(csr, 3)] = Tj + Tk;
		    Cr[0] = Tb + Ti;
		    Cr[WS(csr, 1)] = Tj - Tk;
	       }
	       {
		    E Tr, Tw, Tu, Tv, Tt;
		    Tr = FMA(KP951056516, Tp, KP587785252 * Tq);
		    Tw = FNMS(KP587785252, Tp, KP951056516 * Tq);
		    Tt = FMA(KP250000000, Tn, To);
		    Tu = Ts + Tt;
		    Tv = Tt - Ts;
		    Ci[0] = -(Tr + Tu);
		    Ci[WS(csi, 3)] = Tw + Tv;
		    Ci[WS(csi, 4)] = Tr - Tu;
		    Ci[WS(csi, 1)] = Tv - Tw;
	       }
	  }
     }
}

static const kr2c_desc desc = { 10, "r2cfII_10", {26, 6, 6, 0}, &GENUS };

void X(codelet_r2cfII_10) (planner *p) {
     X(kr2c_register) (p, r2cfII_10, &desc);
}

#endif				/* HAVE_FMA */
