/*  
 *    ffe - Flat File Extractor
 *
 *    Copyright (C) 2006 Timo Savinen
 *    This file is part of ffe.
 * 
 *    ffe is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    ffe is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with ffe; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* $Id: ffe.h,v 1.38 2007-05-21 16:23:32 timo Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_FEATURES_H
#include <features.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_ERROR_H
#include <error.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_REGEX_H
#include <regex.h>
#endif


#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif 

#include <stdio.h>

#if defined(__MINGW32__)
#ifndef WIN32
#define WIN32 1
#endif
#endif

#if defined(HAVE_REGEX) && !defined(HAVE_REGCOMP)
#undef HAVE_REGEX
#endif


#ifdef WIN32 
#define PATH_SEPARATOR_STRING "\\"
#else
#define PATH_SEPARATOR_STRING "/"
#endif


/* Types */

#define DEFALT_OUTPUT "default"
#define LEFT_JUSTIFY 1
#define RIGHT_JUSTIFY 2

#define EXACT 1
#define LONGEST 2

/* contains field names from include-option or from -f paramter */
struct include_field {
    char *name;
    int found;  /* does this belong to any record */
    int reported; /* is this field reported to be unmatched */
    struct include_field *next;
};

struct output {
    char *name;
    char *file_header;
    char *file_trailer;
    char *header;
    char *data;
    char *lookup;
    char *separator;
    char *record_header;
    char *record_trailer;
    char justify;
    char *indent;
    int no_data;
    char *empty_chars;
    int print_empty;
    struct include_field *fl;
    struct output *next;
};

struct lookup_data {
    char *key;
    char *value;
    int key_len;
    struct lookup_data *next;
};

struct lookup {
    char *name;
    char type; 
    char *default_value;
    int max_key_len;
    struct lookup_data *data;
    struct lookup *next;
};

/* replace, field and value */
struct replace {
    char *field;
    char *value;
    int found;
    struct replace *next;
};


/* Information for one field */
struct field {
    char *name;
    char *const_data;
    int position; /* first position = 0 byte position for fixed, first position = 1 for field number for separated */
    int bposition; /* position in current input buffer */
    int length;
    int print;
    char *lookup_table_name;
    struct lookup *lookup;
    struct replace *rep;  /* non NULL if value should be replaced */
    struct field *next;
};

/* search expression */
struct expression {
    char *field;
    char op;
    char *value;
    int value_len;
#if HAVE_REGEX
    regex_t reg;
#endif
    int found;
    struct field *f;  /* pointer to field used in expression */
    struct expression *next;
};

/* contains pointer to fields which will be printed */
struct print_field {
    struct field *f;
    char *data;                 // data start position in output buffer;
    int justify_length;
    int empty;                  // does the field contain only "empty" chars
    struct print_field *next;
};

struct id {
    int position;
    char *key;
    struct id *next;
};


struct record {
    char *name;
    struct id *i;
    struct field *f;
    char *fields_from;
    struct print_field *pf;
    struct output *o;
    char *output_name;
    int vote;
    int length;
    struct record *next;
};

#define FIXED_LENGTH 'f'
#define SEPARATED 's'

/* header types of input files */
#define HEADER_NO 0
#define HEADER_FIRST 1
#define HEADER_ALL 2

struct structure {
    char *name;
    char type[3]; /* [0] = f or s,[1] = separator, [2] = asterisk or 0 */
    char quote;
    int header;
    char *output_name;
    int vote;
    struct output *o;
    struct record *r;
    struct structure *next;
};

struct input_file {
    char *name;
    long int lineno;
    struct input_file *next;
};


/* Constants */
/* exit values */
#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define OP_START '^'
#define OP_EQUAL '='
#define OP_CONTAINS '~'
#define OP_NOT_EQUAL '!'
#define OP_REQEXP '?'

/* function prototypes */
extern void 
panic(char *msg,char *info,char *syserror);

extern void *
xmalloc (size_t size);

extern char *
xstrdup(char *str);

extern void
parserc(char *,char *);

extern void
set_input_file(char *);

extern void
open_input_file();

extern void *
xrealloc (void *, size_t);

extern char *
guess_structure();

extern void
set_output_file(char *);

extern void 
close_output_file();

extern void 
execute(struct structure *,int,int,int);

/* global variables */
extern struct structure *structure;
extern struct output *output;
extern struct expression *expression;
extern struct lookup *lookup;
extern struct output *no_output;
extern struct field *const_field;
