// This code conforms with the UFC specification version 2.0.2
// and was automatically generated by FFC version 1.0-beta+.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'quadrature'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __P5TET_H
#define __P5TET_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class p5tet_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  p5tet_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~p5tet_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0060978812, 0.0035206134, 0.0024894496, 0.0070594623, 0.005468236, 0.004464796, 0.0031570875, 0.0025777512, 0.0018227453, -0.0029826742, -0.0025208198, -0.002183094, -0.0019526186, -0.0016910173, -0.0013807099, -0.0011273449, -0.0009763093, -0.00079715321, -0.00056367244, 0.0027868711, 0.0024577893, 0.0021983136, 0.0020772111, 0.0018579141, 0.0016090008, 0.0016090008, 0.0014391341, 0.0012463267, 0.0010176215, 0.00092895704, 0.00083088444, 0.00071956703, 0.00058752402, 0.00041544222, -0.0070559352, -0.0063823336, -0.0058262468, -0.0056286891, -0.0051382667, -0.0045958054, -0.0047571106, -0.0043426279, -0.0038841645, -0.0033637851, -0.003684842, -0.0033637851, -0.0030086609, -0.0026055768, -0.0021274445, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, -0.0060978812, 0.0035206134, 0.0024894496, 0.0070594623, -0.005468236, -0.004464796, 0.0031570875, 0.0025777512, 0.0018227453, 0.0029826742, -0.0025208198, -0.002183094, 0.0019526186, 0.0016910173, 0.0013807099, -0.0011273449, -0.0009763093, -0.00079715321, -0.00056367244, 0.0027868711, -0.0024577893, -0.0021983136, 0.0020772111, 0.0018579141, 0.0016090008, -0.0016090008, -0.0014391341, -0.0012463267, -0.0010176215, 0.00092895704, 0.00083088444, 0.00071956703, 0.00058752402, 0.00041544222, 0.0070559352, -0.0063823336, -0.0058262468, 0.0056286891, 0.0051382667, 0.0045958054, -0.0047571106, -0.0043426279, -0.0038841645, -0.0033637851, 0.003684842, 0.0033637851, 0.0030086609, 0.0026055768, 0.0021274445, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0, -0.0070412267, 0.0024894496, 0.0, 0.0, 0.0, 0.0094712626, -0.0051555024, 0.0018227453, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0045093795, -0.0029289279, 0.0015943064, -0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0046447852, -0.0033235377, 0.0021587011, -0.001175048, 0.00041544222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.012764667, -0.0097104113, 0.0069482047, -0.0045129913, 0.0024565613, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0, 0.0, -0.0074683487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.010936472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0062316333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.0, 0.037471875, -0.028961418, 0.0, 0.0, 0.0, 0.028413788, 0.0051555024, -0.0061973341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.031565657, -0.011390275, 0.0026571774, -0.00018789081, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.023223926, -0.0016617689, -0.0064761033, 0.0064627642, -0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.021362905, -0.027792819, 0.024370153, -0.015721993, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.0, -0.028757485, 0.053609434, 0.0, 0.0, 0.0, -0.018942525, 0.015466507, 0.015311061, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0045093795, 0.037099753, -0.02816608, 0.010897667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02991184, -0.0043174022, -0.012338004, 0.0087242866, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.031266921, -0.048740307, 0.04127023, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.0, 0.040957631, -0.044982629, 0.0, 0.0, 0.0, 0.018942525, -0.0051555024, -0.021143846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0045561101, 0.035606177, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.030221815, 0.0041126681, -0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.037909127, -0.055026974, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.0, -0.014814462, 0.044982629, 0.0, 0.0, 0.0, 0.0, 0.020622009, 0.021143846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.010628709, 0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.020563341, 0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034391859, -0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.032451596, -0.018735937, -0.028961418, 0.021178387, -0.016404708, 0.004464796, 0.0094712626, -0.0025777512, -0.0061973341, 0.020878719, -0.017645738, -0.0084898099, 0.01366833, 0.0065761785, 0.0023011831, -0.0078914141, -0.0037967584, -0.0013285887, -0.00018789081, 0.013934356, -0.012288947, -0.0010991568, 0.010386055, 0.00092895704, -0.0048270024, -0.008045004, -0.00071956703, 0.00373898, 0.005596918, 0.0046447852, 0.00041544222, -0.0021587011, -0.0032313821, -0.0029080955, 0.0, 0.0, 0.012817743, 0.0, -0.011304187, -0.018383222, 0.0, 0.0095537815, 0.015536658, 0.01816444, 0.0, -0.0074003273, -0.012034644, -0.014070115, -0.013615645, 0.0, 0.004272581, 0.0069482047, 0.0081233844, 0.0078609963, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, -0.024904713, 0.014378743, 0.053609434, -0.014118925, 0.010936472, 0.013394388, -0.0063141751, -0.0077332535, 0.015311061, -0.0029826742, 0.0025208198, 0.027652524, -0.0019526186, -0.021419553, -0.024392541, 0.0011273449, 0.012366584, 0.01408304, 0.010897667, 0.0, 0.0, 0.019784822, 0.0, -0.016721227, -0.0032180016, 0.0, 0.012952207, 0.0024926533, -0.010685025, 0.0, -0.0074779599, -0.0014391341, 0.0061690022, 0.0087242866, 0.0, 0.0, 0.0, 0.0, 0.0, 0.020681124, 0.0, 0.0, -0.01747874, -0.03632888, 0.0, 0.0, 0.013538974, 0.028140229, 0.035741068, 0.0, 0.0, -0.0078167303, -0.016246769, -0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.035470349, -0.020478815, -0.044982629, 0.014118925, -0.010936472, -0.004464796, 0.0063141751, 0.0025777512, -0.021143846, 0.0, 0.0, 0.0033959239, 0.0, -0.0026304714, 0.030835853, 0.0, 0.0015187034, -0.017803088, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.022526011, 0.0, 0.0, -0.017448573, 0.0035616751, 0.0, 0.0, 0.010073938, -0.0020563341, -0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.028255795, 0.0, 0.0, 0.0, -0.021886845, -0.047654757, 0.0, 0.0, 0.0, 0.012636376, 0.027513487, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, -0.012829701, 0.0074072311, 0.044982629, 0.0, 0.0, 0.017859184, 0.0, -0.010311005, 0.021143846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0092047324, 0.0, 0.0, -0.0053143547, 0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.017808375, 0.0, 0.0, 0.0, -0.01028167, 0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.029784223, 0.0, 0.0, 0.0, 0.0, -0.017195929, -0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.032451596, -0.0335504, -0.0080106051, 0.021178387, 0.0010936472, -0.016966225, -0.0056827576, 0.0056710526, 0.0083846285, 0.020878719, -0.010923552, -0.016251922, 0.0049900253, 0.0095824315, 0.010892267, -0.0018789081, -0.0046645889, -0.0055800725, -0.0046972703, 0.013934356, -0.0024577893, -0.012090725, -0.0041544222, 0.0046447852, 0.0096540048, 0.0064360032, -0.00071956703, -0.0049853066, -0.0066145394, -0.0046447852, -0.00041544222, 0.0021587011, 0.0032313821, 0.0029080955, 0.0, 0.012764667, -0.0011652494, -0.020263281, -0.0071935734, 0.0018383222, 0.022834131, 0.011290833, 0.0031073316, -0.0020182711, -0.020635115, -0.011436869, -0.0048138574, -0.00052111535, 0.0017019556, 0.012764667, 0.0073799126, 0.0034741024, 0.00090259827, -0.00049131227, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, -0.024904713, 0.055336373, -0.0043134027, -0.014118925, 0.015311061, 0.0080366328, 0.0088398451, -0.015982057, 0.00072909813, -0.0029826742, 0.027729018, -0.001455396, -0.03015711, -0.01164923, 0.0035284807, 0.019164863, 0.009763093, 0.0013285887, -0.0026304714, 0.0, 0.019662314, -0.0021983136, -0.0072702388, -0.014863313, 0.004022502, -0.0072405036, 0.012952207, 0.0068547966, -0.0045792965, 0.0092895704, -0.0066470755, -0.0057565362, -0.00029376201, 0.0029080955, 0.0, 0.0, 0.0, 0.020263281, -0.0041106133, 0.00045958054, -0.039959729, -0.0030398396, 0.004272581, -0.0010091355, 0.046429009, 0.0090822199, -0.0027077948, -0.0023450191, 0.0012764667, -0.031911668, -0.007768329, 0.00086852559, 0.0018051965, 0.00024565613, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.035470349, -0.049236301, -0.0043134027, 0.014118925, -0.0065618832, -0.0098225512, -0.016416855, 0.014950957, 0.00072909813, 0.0, 0.003361093, -0.00048513199, 0.028204491, -0.012400794, 0.0029148319, -0.035323473, 0.0088952625, 0.0023914596, -0.0026304714, 0.0, 0.0, 0.0, 0.021810716, -0.0055737422, 0.0008045004, -0.004022502, -0.014391341, 0.0093474499, -0.0025440536, -0.0092895704, 0.014125035, -0.0028782681, -0.0038189061, 0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.026639819, -0.0091195187, 0.0023304987, -0.00033637851, -0.051587788, 0.0084094629, 0.0030086609, -0.0028661344, 0.00085097781, 0.04254889, -0.0038841645, -0.0034741024, 0.0012034644, 0.00098262453, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, -0.012829701, 0.044879106, -0.0080106051, 0.0, 0.017498355, -0.0035718368, 0.013259768, -0.017528708, 0.0083846285, 0.0, 0.0, 0.0, 0.0086783049, -0.003006253, 0.00061364883, 0.022546898, -0.01920075, 0.012223016, -0.0046972703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.016090008, -0.0071956703, 0.0024926533, -0.00050881073, 0.0046447852, -0.010801498, 0.010793505, -0.0073440502, 0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.025793894, -0.013455141, 0.0060173218, -0.0020844614, 0.0004254889, -0.031911668, 0.013594576, -0.0034741024, -0.00090259827, 0.0017195929, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, -0.032451596, -0.018735937, -0.028961418, 0.021178387, 0.016404708, -0.004464796, 0.0094712626, -0.0025777512, -0.0061973341, -0.020878719, -0.017645738, -0.0084898099, -0.01366833, -0.0065761785, -0.0023011831, -0.0078914141, -0.0037967584, -0.0013285887, -0.00018789081, 0.013934356, 0.012288947, 0.0010991568, 0.010386055, 0.00092895704, -0.0048270024, 0.008045004, 0.00071956703, -0.00373898, -0.005596918, 0.0046447852, 0.00041544222, -0.0021587011, -0.0032313821, -0.0029080955, 0.0, 0.0, 0.012817743, 0.0, 0.011304187, 0.018383222, 0.0, 0.0095537815, 0.015536658, 0.01816444, 0.0, 0.0074003273, 0.012034644, 0.014070115, 0.013615645, 0.0, 0.004272581, 0.0069482047, 0.0081233844, 0.0078609963, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.024904713, 0.014378743, 0.053609434, -0.014118925, -0.010936472, -0.013394388, -0.0063141751, -0.0077332535, 0.015311061, 0.0029826742, 0.0025208198, 0.027652524, 0.0019526186, 0.021419553, 0.024392541, 0.0011273449, 0.012366584, 0.01408304, 0.010897667, 0.0, 0.0, -0.019784822, 0.0, -0.016721227, -0.0032180016, 0.0, -0.012952207, -0.0024926533, 0.010685025, 0.0, -0.0074779599, -0.0014391341, 0.0061690022, 0.0087242866, 0.0, 0.0, 0.0, 0.0, 0.0, -0.020681124, 0.0, 0.0, -0.01747874, -0.03632888, 0.0, 0.0, -0.013538974, -0.028140229, -0.035741068, 0.0, 0.0, -0.0078167303, -0.016246769, -0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, -0.035470349, -0.020478815, -0.044982629, 0.014118925, 0.010936472, 0.004464796, 0.0063141751, 0.0025777512, -0.021143846, 0.0, 0.0, 0.0033959239, 0.0, 0.0026304714, -0.030835853, 0.0, 0.0015187034, -0.017803088, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.022526011, 0.0, 0.0, 0.017448573, -0.0035616751, 0.0, 0.0, 0.010073938, -0.0020563341, -0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.028255795, 0.0, 0.0, 0.0, 0.021886845, 0.047654757, 0.0, 0.0, 0.0, 0.012636376, 0.027513487, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.012829701, 0.0074072311, 0.044982629, 0.0, 0.0, -0.017859184, 0.0, -0.010311005, 0.021143846, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0092047324, 0.0, 0.0, -0.0053143547, 0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.017808375, 0.0, 0.0, 0.0, -0.01028167, 0.014540478, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.029784223, 0.0, 0.0, 0.0, 0.0, -0.017195929, -0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, -0.032451596, -0.0335504, -0.0080106051, 0.021178387, -0.0010936472, 0.016966225, -0.0056827576, 0.0056710526, 0.0083846285, -0.020878719, -0.010923552, -0.016251922, -0.0049900253, -0.0095824315, -0.010892267, -0.0018789081, -0.0046645889, -0.0055800725, -0.0046972703, 0.013934356, 0.0024577893, 0.012090725, -0.0041544222, 0.0046447852, 0.0096540048, -0.0064360032, 0.00071956703, 0.0049853066, 0.0066145394, -0.0046447852, -0.00041544222, 0.0021587011, 0.0032313821, 0.0029080955, 0.0, 0.012764667, -0.0011652494, 0.020263281, 0.0071935734, -0.0018383222, 0.022834131, 0.011290833, 0.0031073316, -0.0020182711, 0.020635115, 0.011436869, 0.0048138574, 0.00052111535, -0.0017019556, 0.012764667, 0.0073799126, 0.0034741024, 0.00090259827, -0.00049131227, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.024904713, 0.055336373, -0.0043134027, -0.014118925, -0.015311061, -0.0080366328, 0.0088398451, -0.015982057, 0.00072909813, 0.0029826742, 0.027729018, -0.001455396, 0.03015711, 0.01164923, -0.0035284807, 0.019164863, 0.009763093, 0.0013285887, -0.0026304714, 0.0, -0.019662314, 0.0021983136, -0.0072702388, -0.014863313, 0.004022502, 0.0072405036, -0.012952207, -0.0068547966, 0.0045792965, 0.0092895704, -0.0066470755, -0.0057565362, -0.00029376201, 0.0029080955, 0.0, 0.0, 0.0, -0.020263281, 0.0041106133, -0.00045958054, -0.039959729, -0.0030398396, 0.004272581, -0.0010091355, -0.046429009, -0.0090822199, 0.0027077948, 0.0023450191, -0.0012764667, -0.031911668, -0.007768329, 0.00086852559, 0.0018051965, 0.00024565613, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, -0.035470349, -0.049236301, -0.0043134027, 0.014118925, 0.0065618832, 0.0098225512, -0.016416855, 0.014950957, 0.00072909813, 0.0, 0.003361093, -0.00048513199, -0.028204491, 0.012400794, -0.0029148319, -0.035323473, 0.0088952625, 0.0023914596, -0.0026304714, 0.0, 0.0, 0.0, 0.021810716, -0.0055737422, 0.0008045004, 0.004022502, 0.014391341, -0.0093474499, 0.0025440536, -0.0092895704, 0.014125035, -0.0028782681, -0.0038189061, 0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.026639819, -0.0091195187, 0.0023304987, -0.00033637851, 0.051587788, -0.0084094629, -0.0030086609, 0.0028661344, -0.00085097781, 0.04254889, -0.0038841645, -0.0034741024, 0.0012034644, 0.00098262453, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.012829701, 0.044879106, -0.0080106051, 0.0, -0.017498355, 0.0035718368, 0.013259768, -0.017528708, 0.0083846285, 0.0, 0.0, 0.0, -0.0086783049, 0.003006253, -0.00061364883, 0.022546898, -0.01920075, 0.012223016, -0.0046972703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.016090008, 0.0071956703, -0.0024926533, 0.00050881073, 0.0046447852, -0.010801498, 0.010793505, -0.0073440502, 0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.025793894, 0.013455141, -0.0060173218, 0.0020844614, -0.0004254889, -0.031911668, 0.013594576, -0.0034741024, -0.00090259827, 0.0017195929, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, -0.045281296, -0.011328706, -0.0080106051, -0.0014118925, 0.016404708, 0.013394388, 0.014522603, 0.011857655, 0.0083846285, -0.0089480226, -0.014284645, -0.012370866, -0.014536161, -0.012588684, -0.010278618, -0.0093945406, -0.0081359109, -0.0066429434, -0.0046972703, -0.0083606134, 0.0024577893, 0.0021983136, 0.0083088444, 0.0074316563, 0.0064360032, 0.0096540048, 0.0086348044, 0.0074779599, 0.0061057287, 0.0065026993, 0.0058161911, 0.0050369692, 0.0041126681, 0.0029080955, 0.035279676, 0.019147001, 0.01747874, 0.0078801648, 0.0071935734, 0.0064341276, 0.00095142211, 0.00086852559, 0.0007768329, 0.00067275703, -0.0022109052, -0.0020182711, -0.0018051965, -0.0015633461, -0.0012764667, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, 0.060375061, -0.0061000726, -0.0043134027, -0.0056475699, -0.021872944, -0.017859184, 0.001262835, 0.0010311005, 0.00072909813, 0.041757439, 0.016805465, 0.01455396, -0.00086783049, -0.00075156325, -0.00061364883, -0.0052609428, -0.0045561101, -0.0037200483, -0.0026304714, 0.0055737422, -0.019662314, -0.017586509, -0.010386055, -0.0092895704, -0.008045004, 0.0032180016, 0.0028782681, 0.0024926533, 0.0020352429, 0.0065026993, 0.0058161911, 0.0050369692, 0.0041126681, 0.0029080955, -0.070559352, -0.012764667, -0.011652494, 0.0045029513, 0.0041106133, 0.0036766443, 0.0038056885, 0.0034741024, 0.0031073316, 0.0026910281, -0.0007369684, -0.00067275703, -0.00060173218, -0.00052111535, -0.0004254889, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442, -0.060375061, -0.0061000726, -0.0043134027, -0.0056475699, 0.021872944, 0.017859184, 0.001262835, 0.0010311005, 0.00072909813, -0.041757439, 0.016805465, 0.01455396, 0.00086783049, 0.00075156325, 0.00061364883, -0.0052609428, -0.0045561101, -0.0037200483, -0.0026304714, 0.0055737422, 0.019662314, 0.017586509, -0.010386055, -0.0092895704, -0.008045004, -0.0032180016, -0.0028782681, -0.0024926533, -0.0020352429, 0.0065026993, 0.0058161911, 0.0050369692, 0.0041126681, 0.0029080955, 0.070559352, -0.012764667, -0.011652494, -0.0045029513, -0.0041106133, -0.0036766443, 0.0038056885, 0.0034741024, 0.0031073316, 0.0026910281, 0.0007369684, 0.00067275703, 0.00060173218, 0.00052111535, 0.0004254889, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.045281296, -0.011328706, -0.0080106051, -0.0014118925, -0.016404708, -0.013394388, 0.014522603, 0.011857655, 0.0083846285, 0.0089480226, -0.014284645, -0.012370866, 0.014536161, 0.012588684, 0.010278618, -0.0093945406, -0.0081359109, -0.0066429434, -0.0046972703, -0.0083606134, -0.0024577893, -0.0021983136, 0.0083088444, 0.0074316563, 0.0064360032, -0.0096540048, -0.0086348044, -0.0074779599, -0.0061057287, 0.0065026993, 0.0058161911, 0.0050369692, 0.0041126681, 0.0029080955, -0.035279676, 0.019147001, 0.01747874, -0.0078801648, -0.0071935734, -0.0064341276, 0.00095142211, 0.00086852559, 0.0007768329, 0.00067275703, 0.0022109052, 0.0020182711, 0.0018051965, 0.0015633461, 0.0012764667, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.067921944, -0.0043571947, -0.003081002, 0.070594623, -0.032809416, -0.026788776, 0.01262835, 0.036088516, -0.0072909813, 0.029826742, 0.015124919, 0.013098564, -0.032543643, -0.022922679, -0.024852777, 0.024801587, 0.016922695, 0.0164745, 0.014279702, 0.0, 0.024577893, 0.021983136, -0.036351194, -0.0074316563, -0.034593517, 0.036202518, 0.0, 0.01308643, 0.033581508, -0.023223926, 0.0016617689, -0.0035978352, -0.0146881, -0.017864015, 0.0, 0.0, 0.0, 0.0, 0.022608373, -0.0045958054, 0.0, -0.033438235, -0.019420823, 0.0090822199, 0.0, 0.033301473, 0.027077948, 0.0070350573, -0.010211734, 0.0, -0.021362905, -0.019107563, -0.0081233844, 0.0019652491, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.0037734413, 0.0021785974, -0.021567014, 0.0, 0.098428248, -0.031253572, -0.085241363, -0.018044258, 0.030986671, 0.0, 0.045374756, -0.011643168, 0.0, 0.023674242, -0.0013807099, -0.020292208, -0.033519953, -0.00079715321, 0.0039457071, 0.0, 0.0, 0.0, 0.036351194, 0.024152883, -0.0072405036, -0.06033753, 0.0, -0.03925929, 0.018825997, 0.046447852, -0.010801498, 0.025904413, 0.010869194, -0.017864015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.033438235, -0.015536658, 0.0030274066, 0.0, -0.055502455, 0.0, 0.016415134, -0.0068078225, 0.0, 0.04272581, 0.0069482047, -0.010831179, -0.0039304981, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.030187531, 0.061000726, -0.003081002, 0.0, 0.021872944, 0.017859184, 0.075770101, -0.041244019, -0.0072909813, 0.0, 0.0, 0.0, 0.052069829, -0.012776575, 0.0018409465, -0.009018759, 0.028638406, -0.029760386, 0.014279702, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04022502, 0.014391341, -0.013709593, 0.0040704858, -0.046447852, 0.018279458, -0.034539217, 0.036426489, -0.017864015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.037001637, -0.030086609, 0.014070115, -0.0034039112, 0.0, -0.04272581, 0.024318717, 0.0, -0.0098262453, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.0037734413, -0.019607376, 0.0092430059, 0.0, -0.010936472, 0.10269031, 0.0094712626, -0.069599282, -0.060150596, 0.0, -0.0050416396, 0.046572671, 0.0065087287, 0.021419553, -0.0078240225, -0.0045093795, -0.028963843, -0.026306056, 0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.033442453, 0.028962014, 0.0, -0.043174022, -0.0024926533, -0.060548476, 0.0, 0.02991184, -0.0043174022, 0.018507007, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034957481, -0.012109627, 0.0, 0.0, -0.045129913, -0.028140229, 0.023827379, 0.0, 0.0, 0.031266921, 0.027077948, 0.0, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, -0.015093765, 0.013071584, 0.0092430059, 0.0, -0.010936472, -0.008929592, 0.0094712626, 0.12373206, -0.060150596, 0.0, 0.0, 0.0, -0.0065087287, 0.057494589, -0.026693724, 0.0067640693, 0.012692021, 0.0063772257, 0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.043174022, 0.019941226, -0.0142467, 0.0, -0.04486776, 0.021587011, -0.061690022, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.045129913, -0.037520305, 0.011913689, 0.0, 0.0, -0.046900382, 0.016246769, 0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.030187531, 0.017428779, 0.058539037, 0.0, 0.021872944, 0.017859184, -0.018942525, 0.010311005, 0.083846285, 0.0, 0.0, 0.0, 0.0, 0.0052609428, 0.053387448, 0.0, -0.0045561101, 0.030823257, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034897146, 0.028493401, 0.0, 0.0, -0.030221815, 0.016450673, -0.064393544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04377369, -0.023827379, 0.0, 0.0, 0.0, -0.037909127, -0.013756743, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, -0.067921944, -0.0043571947, -0.003081002, 0.070594623, 0.032809416, 0.026788776, 0.01262835, 0.036088516, -0.0072909813, -0.029826742, 0.015124919, 0.013098564, 0.032543643, 0.022922679, 0.024852777, 0.024801587, 0.016922695, 0.0164745, 0.014279702, 0.0, -0.024577893, -0.021983136, -0.036351194, -0.0074316563, -0.034593517, -0.036202518, 0.0, -0.01308643, -0.033581508, -0.023223926, 0.0016617689, -0.0035978352, -0.0146881, -0.017864015, 0.0, 0.0, 0.0, 0.0, -0.022608373, 0.0045958054, 0.0, -0.033438235, -0.019420823, 0.0090822199, 0.0, -0.033301473, -0.027077948, -0.0070350573, 0.010211734, 0.0, -0.021362905, -0.019107563, -0.0081233844, 0.0019652491, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, -0.0037734413, 0.0021785974, -0.021567014, 0.0, -0.098428248, 0.031253572, -0.085241363, -0.018044258, 0.030986671, 0.0, 0.045374756, -0.011643168, 0.0, -0.023674242, 0.0013807099, -0.020292208, -0.033519953, -0.00079715321, 0.0039457071, 0.0, 0.0, 0.0, 0.036351194, 0.024152883, -0.0072405036, 0.06033753, 0.0, 0.03925929, -0.018825997, 0.046447852, -0.010801498, 0.025904413, 0.010869194, -0.017864015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.033438235, -0.015536658, 0.0030274066, 0.0, 0.055502455, 0.0, -0.016415134, 0.0068078225, 0.0, 0.04272581, 0.0069482047, -0.010831179, -0.0039304981, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, -0.030187531, 0.061000726, -0.003081002, 0.0, -0.021872944, -0.017859184, 0.075770101, -0.041244019, -0.0072909813, 0.0, 0.0, 0.0, -0.052069829, 0.012776575, -0.0018409465, -0.009018759, 0.028638406, -0.029760386, 0.014279702, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.04022502, -0.014391341, 0.013709593, -0.0040704858, -0.046447852, 0.018279458, -0.034539217, 0.036426489, -0.017864015, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.037001637, 0.030086609, -0.014070115, 0.0034039112, 0.0, -0.04272581, 0.024318717, 0.0, -0.0098262453, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, -0.0037734413, -0.019607376, 0.0092430059, 0.0, 0.010936472, -0.10269031, 0.0094712626, -0.069599282, -0.060150596, 0.0, -0.0050416396, 0.046572671, -0.0065087287, -0.021419553, 0.0078240225, -0.0045093795, -0.028963843, -0.026306056, 0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.033442453, 0.028962014, 0.0, 0.043174022, 0.0024926533, 0.060548476, 0.0, 0.02991184, -0.0043174022, 0.018507007, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034957481, -0.012109627, 0.0, 0.0, 0.045129913, 0.028140229, -0.023827379, 0.0, 0.0, 0.031266921, 0.027077948, 0.0, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.015093765, 0.013071584, 0.0092430059, 0.0, 0.010936472, 0.008929592, 0.0094712626, 0.12373206, -0.060150596, 0.0, 0.0, 0.0, 0.0065087287, -0.057494589, 0.026693724, 0.0067640693, 0.012692021, 0.0063772257, 0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.043174022, -0.019941226, 0.0142467, 0.0, -0.04486776, 0.021587011, -0.061690022, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.045129913, 0.037520305, -0.011913689, 0.0, 0.0, -0.046900382, 0.016246769, 0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, -0.030187531, 0.017428779, 0.058539037, 0.0, -0.021872944, -0.017859184, -0.018942525, 0.010311005, 0.083846285, 0.0, 0.0, 0.0, 0.0, -0.0052609428, -0.053387448, 0.0, -0.0045561101, 0.030823257, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.034897146, -0.028493401, 0.0, 0.0, -0.030221815, 0.016450673, -0.064393544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.04377369, 0.023827379, 0.0, 0.0, 0.0, -0.037909127, -0.013756743, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, -0.037734413, -0.056643532, -0.003081002, 0.042356774, 0.05468236, 0.04464796, 0.03788505, 0.0051555024, -0.0072909813, 0.041757439, -0.0050416396, 0.029593052, -0.024733169, 0.010146104, 0.026693724, -0.020292208, 0.0021695762, 0.013285887, 0.014279702, -0.055737422, -0.024577893, -0.0021983136, -0.0051930277, -0.013005399, -0.016894508, 0.004022502, -0.015830475, -0.026796023, -0.029511022, 0.0046447852, -0.010801498, -0.01942831, -0.021738389, -0.017864015, 0.0, 0.0, -0.051270972, 0.0, -0.022608373, -0.036766443, 0.0, -0.0047768907, -0.007768329, -0.0090822199, 0.0, 0.0037001637, 0.0060173218, 0.0070350573, 0.0068078225, 0.0, 0.004272581, 0.0069482047, 0.0081233844, 0.0078609963, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.0, -0.0043571947, -0.021567014, -0.12707032, 0.0, 0.0, 0.028413788, 0.036088516, 0.030986671, 0.0, 0.045374756, -0.042206483, 0.0, 0.0, 0.0, -0.020292208, -0.0061832922, 0.0015943064, 0.0039457071, 0.083606134, 0.0, 0.0, -0.010386055, 0.024152883, 0.043443021, 0.0, 0.0, 0.0, 0.0, 0.0046447852, -0.010801498, -0.01942831, -0.021738389, -0.017864015, 0.0, 0.0, 0.076906457, 0.0, 0.0, 0.0, 0.0, -0.0095537815, -0.015536658, -0.01816444, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.004272581, 0.0069482047, 0.0081233844, 0.0078609963, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.037734413, -0.056643532, -0.003081002, 0.042356774, -0.05468236, -0.04464796, 0.03788505, 0.0051555024, -0.0072909813, -0.041757439, -0.0050416396, 0.029593052, 0.024733169, -0.010146104, -0.026693724, -0.020292208, 0.0021695762, 0.013285887, 0.014279702, -0.055737422, 0.024577893, 0.0021983136, -0.0051930277, -0.013005399, -0.016894508, -0.004022502, 0.015830475, 0.026796023, 0.029511022, 0.0046447852, -0.010801498, -0.01942831, -0.021738389, -0.017864015, 0.0, 0.0, -0.051270972, 0.0, 0.022608373, 0.036766443, 0.0, -0.0047768907, -0.007768329, -0.0090822199, 0.0, -0.0037001637, -0.0060173218, -0.0070350573, -0.0068078225, 0.0, 0.004272581, 0.0069482047, 0.0081233844, 0.0078609963, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, -0.018867207, 0.0065357921, 0.0092430059, 0.014118925, 0.0, -0.1116199, -0.0031570875, -0.054132775, -0.060150596, -0.0089480226, -0.0025208198, -0.027652524, 0.00065087287, 0.036075036, -0.018869701, 0.0011273449, 0.03742519, 0.01992883, 0.00056367244, 0.0, 0.0, 0.059354467, 0.0, 0.016721227, 0.0032180016, 0.0, -0.0043174022, 0.02243388, 0.046301776, 0.0, -0.0074779599, 0.018708743, 0.043183015, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, 0.062043373, 0.0, 0.0, 0.01747874, 0.03632888, 0.0, 0.0, -0.0045129913, -0.0093800764, -0.011913689, 0.0, 0.0, -0.0078167303, -0.016246769, -0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.018867207, 0.0065357921, 0.0092430059, 0.014118925, 0.0, 0.1116199, -0.0031570875, -0.054132775, -0.060150596, 0.0089480226, -0.0025208198, -0.027652524, -0.00065087287, -0.036075036, 0.018869701, 0.0011273449, 0.03742519, 0.01992883, 0.00056367244, 0.0, 0.0, -0.059354467, 0.0, 0.016721227, 0.0032180016, 0.0, 0.0043174022, -0.02243388, -0.046301776, 0.0, -0.0074779599, 0.018708743, 0.043183015, 0.046114086, 0.0, 0.0, 0.0, 0.0, 0.0, -0.062043373, 0.0, 0.0, 0.01747874, 0.03632888, 0.0, 0.0, 0.0045129913, 0.0093800764, 0.011913689, 0.0, 0.0, -0.0078167303, -0.016246769, -0.020635115, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.0, -0.034857558, 0.058539037, -0.028237849, 0.0, 0.0, 0.0063141751, -0.020622009, 0.083846285, 0.0, 0.0, -0.0067918479, 0.0, 0.0, 0.0, 0.0, 0.0015187034, -0.061646515, -0.031941438, 0.0, 0.0, 0.0, 0.0, 0.0, -0.045052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.010073938, -0.032901345, -0.064393544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.05651159, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.012636376, 0.027513487, 0.030398396};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, -0.037734413, -0.021785974, -0.052377033, 0.042356774, 0.05468236, 0.04464796, 0.0, 0.025777512, 0.029163925, 0.041757439, 0.028569291, -0.0092175079, 0.02733666, -0.0078914141, -0.024852777, 0.018789081, -0.003471322, -0.014348758, -0.015031265, -0.055737422, -0.0049155786, -0.024181449, -0.019733505, -0.0092895704, -0.0024135012, -0.039420519, -0.015830475, -0.00062316333, 0.0071233502, -0.032513496, -0.014125035, -0.0021587011, 0.0041126681, 0.0054007488, 0.0, -0.051058669, 0.0046609974, -0.040526562, -0.014387147, 0.0036766443, -0.011417065, -0.0056454163, -0.0015536658, 0.0010091355, 0.010317558, 0.0057184347, 0.0024069287, 0.00026055768, -0.00085097781, 0.012764667, 0.0073799126, 0.0034741024, 0.00090259827, -0.00049131227, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.0, -0.021785974, 0.003081002, -0.12707032, 0.0, 0.0, 0.047356313, 0.025777512, 0.012759217, 0.0, -0.035291477, 0.050938859, 0.0, 0.0, 0.0, 0.0022546898, -0.0094376566, -0.014348758, -0.012964466, 0.083606134, 0.0, 0.0, 0.047775855, 0.0092895704, -0.014481007, 0.0, 0.0, 0.0, 0.0, -0.032513496, -0.014125035, -0.0021587011, 0.0041126681, 0.0054007488, 0.0, 0.076588003, -0.0069914961, 0.0, 0.0, 0.0, -0.022834131, -0.011290833, -0.0031073316, 0.0020182711, 0.0, 0.0, 0.0, 0.0, 0.0, 0.012764667, 0.0073799126, 0.0034741024, 0.00090259827, -0.00049131227, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.037734413, -0.021785974, -0.052377033, 0.042356774, -0.05468236, -0.04464796, 0.0, 0.025777512, 0.029163925, -0.041757439, 0.028569291, -0.0092175079, -0.02733666, 0.0078914141, 0.024852777, 0.018789081, -0.003471322, -0.014348758, -0.015031265, -0.055737422, 0.0049155786, 0.024181449, -0.019733505, -0.0092895704, -0.0024135012, 0.039420519, 0.015830475, 0.00062316333, -0.0071233502, -0.032513496, -0.014125035, -0.0021587011, 0.0041126681, 0.0054007488, 0.0, -0.051058669, 0.0046609974, 0.040526562, 0.014387147, -0.0036766443, -0.011417065, -0.0056454163, -0.0015536658, 0.0010091355, -0.010317558, -0.0057184347, -0.0024069287, -0.00026055768, 0.00085097781, 0.012764667, 0.0073799126, 0.0034741024, 0.00090259827, -0.00049131227, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, -0.018867207, 0.010892987, 0.003081002, 0.014118925, -0.10936472, 0.02232398, -0.078927188, -0.012888756, 0.012759217, -0.0089480226, -0.027729018, 0.001455396, -0.0058578558, 0.038329726, -0.012426389, 0.019164863, 0.034821698, 0.0071743789, -0.012964466, 0.0, 0.058986943, -0.0065949408, 0.0072702388, 0.014863313, -0.004022502, 0.050683525, -0.0043174022, -0.0081011233, 0.0035616751, 0.065026993, -0.0016617689, -0.011513072, -0.0020563341, 0.0054007488, 0.0, 0.0, 0.0, 0.060789843, -0.01233184, 0.0013787416, 0.039959729, 0.0030398396, -0.004272581, 0.0010091355, -0.015476336, -0.0030274066, 0.00090259827, 0.00078167303, -0.0004254889, -0.031911668, -0.007768329, 0.00086852559, 0.0018051965, 0.00024565613, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478805, 0.018867207, 0.010892987, 0.003081002, 0.014118925, 0.10936472, -0.02232398, -0.078927188, -0.012888756, 0.012759217, 0.0089480226, -0.027729018, 0.001455396, 0.0058578558, -0.038329726, 0.012426389, 0.019164863, 0.034821698, 0.0071743789, -0.012964466, 0.0, -0.058986943, 0.0065949408, 0.0072702388, 0.014863313, -0.004022502, -0.050683525, 0.0043174022, 0.0081011233, -0.0035616751, 0.065026993, -0.0016617689, -0.011513072, -0.0020563341, 0.0054007488, 0.0, 0.0, 0.0, -0.060789843, 0.01233184, -0.0013787416, 0.039959729, 0.0030398396, -0.004272581, 0.0010091355, 0.015476336, 0.0030274066, -0.00090259827, -0.00078167303, 0.0004254889, -0.031911668, -0.007768329, 0.00086852559, 0.0018051965, 0.00024565613, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617, 0.0, 0.043571947, -0.052377033, -0.028237849, 0.0, 0.0, 0.063141751, -0.051555024, 0.029163925, 0.0, -0.0067221861, 0.00097026399, 0.0, 0.0, 0.0, -0.06012506, -0.012583542, 0.028697515, -0.015031265, 0.0, 0.0, 0.0, -0.043621433, 0.011147484, -0.0016090008, 0.0, 0.0, 0.0, 0.0, -0.065026993, 0.031573609, -0.0028782681, -0.0082253363, 0.0054007488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.053279638, 0.018239037, -0.0046609974, 0.00067275703, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04254889, -0.0038841645, -0.0034741024, 0.0012034644, 0.00098262453, -0.00086852559};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, -0.18867207, -0.10892987, -0.077025049, -0.070594623, -0.05468236, -0.04464796, -0.031570875, -0.025777512, -0.018227453, 0.089480226, -0.015124919, -0.013098564, 0.058578558, -0.028183622, 0.069035493, 0.074404762, 0.009763093, 0.03985766, 0.059749278, 0.0, 0.073733679, 0.065949408, 0.036351194, 0.0074316563, 0.034593517, -0.012067506, 0.043174022, 0.015579083, -0.025440536, -0.023223926, 0.046529528, 0.025184846, -0.0146881, -0.032819935, 0.0, 0.0, 0.0, 0.0, 0.06782512, -0.013787416, 0.0, 0.033438235, 0.019420823, -0.0090822199, 0.0, -0.011100491, -0.0090259827, -0.0023450191, 0.0034039112, 0.0, -0.021362905, -0.019107563, -0.0081233844, 0.0019652491, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.18867207, -0.10892987, -0.077025049, -0.070594623, 0.05468236, 0.04464796, -0.031570875, -0.025777512, -0.018227453, -0.089480226, -0.015124919, -0.013098564, -0.058578558, 0.028183622, -0.069035493, 0.074404762, 0.009763093, 0.03985766, 0.059749278, 0.0, -0.073733679, -0.065949408, 0.036351194, 0.0074316563, 0.034593517, 0.012067506, -0.043174022, -0.015579083, 0.025440536, -0.023223926, 0.046529528, 0.025184846, -0.0146881, -0.032819935, 0.0, 0.0, 0.0, 0.0, -0.06782512, 0.013787416, 0.0, 0.033438235, 0.019420823, -0.0090822199, 0.0, 0.011100491, 0.0090259827, 0.0023450191, -0.0034039112, 0.0, -0.021362905, -0.019107563, -0.0081233844, 0.0019652491, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.0, 0.21785974, -0.077025049, 0.0, 0.0, 0.0, -0.094712626, 0.051555024, -0.018227453, 0.0, -0.090749512, 0.023286336, 0.0, 0.0, 0.0, -0.09469697, -0.02278055, -0.079715321, 0.059749278, 0.0, 0.0, 0.0, -0.072702388, -0.048305766, 0.014481007, 0.0, 0.0, 0.0, 0.0, 0.046447852, -0.078103137, 0.043174022, 0.029376201, -0.032819935, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.06687647, 0.031073316, -0.0060548133, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.04272581, 0.0069482047, -0.010831179, -0.0039304981, 0.0060796791};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.0, 0.0, 0.23107515, 0.0, 0.0, 0.0, 0.0, 0.0, -0.10936472, 0.0, 0.010083279, -0.093145343, 0.0, 0.0, 0.0, -0.0045093795, -0.10413966, 0.0, -0.09244228, 0.0, 0.0, 0.0, 0.0, -0.066884907, -0.057924029, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02991184, -0.064761033, 0.0, 0.083503886, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.069914961, 0.024219253, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.031266921, 0.027077948, 0.0, -0.018239037};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0060978812, 0.0035206134, 0.0024894496, 0.0070594623, 0.005468236, 0.004464796, 0.0031570875, 0.0025777512, 0.0018227453, -0.0029826742, -0.0025208198, -0.002183094, -0.0019526186, -0.0016910173, -0.0013807099, -0.0011273449, -0.0009763093, -0.00079715321, -0.00056367244, 0.0027868711, 0.0024577893, 0.0021983136, 0.0020772111, 0.0018579141, 0.0016090008, 0.0016090008, 0.0014391341, 0.0012463267, 0.0010176215, 0.00092895704, 0.00083088444, 0.00071956703, 0.00058752402, 0.00041544222, -0.0070559352, -0.0063823336, -0.0058262468, -0.0056286891, -0.0051382667, -0.0045958054, -0.0047571106, -0.0043426279, -0.0038841645, -0.0033637851, -0.003684842, -0.0033637851, -0.0030086609, -0.0026055768, -0.0021274445, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4990908, 0.0, -3.3466401, -2.3664319, 15.491933, 0.0, 0.0, 0.69282032, 0.56568542, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.8989795, 0.0, 0.0, 0.0, 14.198591, -0.82807867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.2426407, 0.0, 0.0, 0.0, 0.0, 14.342743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.7635609, -1.5491933, 0.0, 0.0, 0.0, 9.5247047, -1.4813122, 0.26186147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1176915, 0.0, 3.1622777, 4.9193496, 0.0, 0.0, 0.0, 0.0, 10.69045, -2.4189726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5455844, 0.0, 0.0, 7.6681158, 0.0, 0.0, 0.0, 0.0, 0.0, 10.369185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.605769, 0.0, 0.0, 0.0, -4.2045893, -3.4330328, 0.0, 0.0, 0.0, 19.621417, 0.0, 0.0, 0.61167774, 0.52972846, 0.43252148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5313721, 0.0, 3.545621, -2.5071327, 4.7871355, 0.0, 0.0, -5.5662675, -1.0488088, 0.74161985, 0.0, 18.803495, -0.60312239, 0.0, 0.0, 0.0, 1.6818357, 0.70128378, 0.13213749, -0.093435318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0529824, 0.0, -1.5856499, 4.4848953, 4.2817442, 0.0, 0.0, 0.19148542, -3.7523326, -4.3116122, 0.0, 0.0, 18.880717, 0.0, 0.0, 0.0, 0.0, 0.84437134, 1.1818737, 1.0446386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.5951289, 0.0, 0.0, 0.0, 10.028531, -0.76764947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.413036, -1.2634761, 0.096714743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.3211538, 0.0, 0.0, 0.0, 3.9242834, 5.4928525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.304463, -1.7300859, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.0101782, 0.0, 0.0, 0.0, 0.0, 8.9192809, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.855856, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9664794, 0.0, 8.1240384, -1.6413036, 0.0, 0.0, 0.0, 11.77285, -2.403123, 0.48550416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.276186, -1.4832397, 0.30276504, -0.061167774, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6532998, 0.0, 4.1522062, 2.9360532, 0.0, 0.0, 0.0, 2.6324893, 9.8259133, -2.8226128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.608187, -3.0948718, 0.68387651, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2978251, 0.0, 1.4982984, 5.509176, 0.0, 0.0, 0.0, 0.0, 6.6480395, 4.1367689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.563614, -3.5535266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8761663, 0.0, 0.0, 6.2283093, 0.0, 0.0, 0.0, 0.0, 0.0, 11.054152, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.605769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.831867, 0.0, -4.4108709, -3.1189567, 16.674998, 0.0, 0.0, 2.1306531, 1.739671, 1.2301331, 0.0, -4.3665394, -3.7815341, 0.0, 0.0, 0.0, -0.55793594, -0.4831867, -0.39452029, -0.27896797, 23.698101, 0.0, 0.0, 0.49065338, 0.43885373, 0.38005848, 0.0, 0.0, 0.0, 0.0, 0.062693389, 0.056074672, 0.048562091, 0.039650781, 0.028037336, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.9105066, 0.0, 0.0, 0.0, 10.570624, -2.7255406, 0.0, 0.0, 0.0, 4.6733286, 0.0, 0.0, -7.8670587, -2.3971922, 0.6180945, 0.0, 0.0, 0.0, 0.0, 0.0, 23.105555, -0.46968719, 0.0, 0.0, 0.0, 1.6206575, 0.79066915, 0.24092688, -0.062120835, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.3084006, 0.0, 0.0, 0.0, -1.5236235, 11.1963, 0.0, 0.0, 0.0, 4.2661458, 0.0, 0.0, 0.13299276, -4.7221795, -6.676846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.153244, 0.0, 0.0, 0.0, 0.0, 0.72177888, 1.1112513, 1.1908744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8544964, 0.0, 5.9817182, -2.4880668, 1.9002924, 0.0, 0.0, -0.33993463, -2.3592215, 0.98130676, 0.0, 9.952267, -0.4309458, 0.0, 0.0, 0.0, -6.4536442, 0.077089929, 0.53502114, -0.22253946, 0.0, 0.0, 0.0, 21.52733, -1.0002405, 0.043311683, 0.0, 0.0, 0.0, 0.0, 2.7506613, 0.64861565, -0.0077478294, -0.053771648, 0.022366057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.5186578, 0.0, 1.9272482, 2.7255406, 1.7347217, 0.0, 0.0, -2.0170569, 3.4205263, -4.0311289, 0.0, 4.0883109, 5.3764379, 0.0, 0.0, 0.0, 0.36566964, -6.2514819, -2.0398101, 1.8080332, 0.0, 0.0, 0.0, 0.0, 22.188098, -1.2652152, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9845638, 1.4711358, 0.36381814, -0.29400945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1471832, 0.0, -0.86189161, 6.094494, 1.5515822, 0.0, 0.0, 0.069388867, -3.0594117, 1.8027756, 0.0, 0.0, 9.0312216, 0.0, 0.0, 0.0, 0.0, 0.40388851, -3.6746199, -5.4965068, 0.0, 0.0, 0.0, 0.0, 0.0, 21.784126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573, 1.7897486, 1.8079191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.5452363, 0.0, 0.0, 0.0, 6.7177802, -0.6094494, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.659398, -1.5234494, 0.13821013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501, -1.473325, 0.15311242, -0.013890641, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.4106013, 0.0, 0.0, 0.0, 3.6340541, 2.5035689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.5685703, 11.263055, -1.4929881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.36736, -2.650489, 0.26628761, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.2616801, 0.0, 0.0, 0.0, 1.4220486, 4.4785202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.2772513, 5.3790928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.965481, -2.6199237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.092647, 0.0, 0.0, 0.0, 0.0, 5.3868225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.437782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.90767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5233602, 0.0, 7.3712071, -1.628822, 0.0, 0.0, 0.0, 12.017131, -2.9072433, 0.64241607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882, -2.7252291, 0.6593008, -0.14568627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.804383, -1.405634, 0.27389583, -0.066262224, 0.014642021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3035022, 0.0, 4.4158804, 1.7842851, 0.0, 0.0, 0.0, 4.2661458, 7.8374103, -2.6389933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2342784, 13.222103, -4.6737922, 1.1836356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.125885, -3.1115036, 0.83361207, -0.19247437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.060315, 0.0, 2.256962, 3.9897829, 0.0, 0.0, 0.0, 0.9539392, 8.0114204, 1.1801937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.552549, 9.6224137, -3.5983084, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.393252, -4.6866619, 1.1835609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7842851, 0.0, 0.81441102, 5.0677049, 0.0, 0.0, 0.0, 0.0, 4.0151005, 6.5867231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.015931, 2.8329331, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.092945, -4.5555279, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4568627, 0.0, 0.0, 5.0781645, 0.0, 0.0, 0.0, 0.0, 0.0, 10.014276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.878481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.553559, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 9.1651514, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 0.0, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.6920998, 4.3817805, -0.77459667, 0.0, 10.998182, 0.96214047, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 2.7386128, 1.5811388, 2.4596748, 0.0, 0.0, 9.258201, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, 0.0, 0.0, 3.8340579, 0.0, 0.0, 0.0, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1961524, 0.0, -3.1622777, -2.236068, 0.0, 0.0, 0.0, 13.747727, 0.53452248, 0.37796447, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837, -2.8401878, 0.0, 0.0, 0.0, 0.0, 12.344268, 1.3965945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2045408, 0.0, 0.0, 6.6407831, 0.0, 0.0, 0.0, 0.0, 0.0, 8.9799777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 11.124298, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 0.0, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, -8.0917359, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 12.713483, 1.0194629, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 2.533114, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 0.0, 11.169983, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, 0.0, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 7.0356236, 4.0620192, -0.82065181, 0.0, -6.7970582, -2.0811655, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 14.832397, 0.85634884, 0.26220221, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, -2.696937, 2.0761031, 1.4680266, 0.0, 3.0397368, -6.3821179, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 0.0, 13.40398, 2.0101782, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 1.2975644, 0.74914918, 2.754588, 0.0, 0.0, 5.7573711, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 0.0, 10.880409, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 0.0, 0.0, 3.1141546, 0.0, 0.0, 0.0, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253954, 0.0, 9.3808315, 1.8952142, 0.0, 0.0, 0.0, -3.3985291, -2.7748874, -0.56061191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.798876, 0.42817442, 0.34960295, 0.070630462, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8297084, 0.0, -1.4982984, 4.2378277, 0.0, 0.0, 0.0, 3.799671, -3.545621, -4.0740906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.754974, 1.1167657, 0.98709071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.3266499, 0.0, 1.7300859, -3.1807243, 0.0, 0.0, 0.0, 0.0, 7.6764947, -2.3883647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.507211, 2.0516295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6248077, 0.0, 0.0, 5.3938741, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.050891, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 13.099618, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 0.0, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, -10.303721, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 14.555131, 1.0355629, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 2.4186773, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 0.0, 13.126656, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, 0.0, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 0.0, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 9.1544291, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, -9.4626009, -2.0760294, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 16.374523, 0.95102718, 0.2086488, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, -2.9322148, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 2.7642027, -9.0878388, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 0.0, 15.001892, 2.1386041, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.91792842, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, 0.0, 5.3429427, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 0.0, 12.887663, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 0.0, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, 0.0, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, -6.7826309, 3.6856035, -0.81441102, 0.0, 10.021691, 2.6751057, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, -7.5700807, -2.2727058, -0.60665695, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.71374, 0.76082174, 0.22841553, 0.060971317, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 3.8242646, 2.2079402, 0.89214257, 0.0, -2.4630604, 6.7873964, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 3.2249031, -7.6337846, -4.0476228, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.502208, 1.7964274, 0.72192923, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, -1.4659398, 1.128481, 1.9948914, 0.0, 1.1015141, -5.2035702, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, 0.0, 6.4115313, -6.2499411, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.465195, 3.0440762, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.70530063, 0.40720551, 2.5338524, 0.0, 0.0, 3.477179, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, 0.0, 8.6740509, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.204849, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 0.0, 2.5390823, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0990195, 0.0, -4.6547467, -3.2914029, 0.0, 0.0, 0.0, 13.490738, 1.8358568, 1.2981468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.5327043, -3.0594117, -0.4163332, -0.29439203, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.832697, 0.35505015, 0.30748245, 0.041843061, 0.029587512, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6598552, 0.0, 5.0990195, -2.060315, 0.0, 0.0, 0.0, -1.2315302, 9.0498619, 3.047247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.8698837, -3.8168923, -5.3968303, -1.3667446, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.002649, 0.89821372, 0.96257231, 0.22225026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9738086, 0.0, -0.81441102, 5.7587555, 0.0, 0.0, 0.0, 1.3768926, -2.8908723, 1.7034629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0144141, -3.4721895, -5.1937108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.331494, 1.6911535, 1.708323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.0301575, 0.0, 0.94040084, -2.9258408, 0.0, 0.0, 0.0, 0.0, 4.6362387, -3.8028463, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.565401, -1.6355947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.273132, 2.6301353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.0, 0.0, 4.3978195, 0.0, 0.0, 0.0, 0.0, 0.0, 8.672617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.019117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.871701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 1.3093073, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 9.0711474, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.63245553, 4.3817805, -0.77459667, 0.0, 3.1423376, -0.1069045, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 0.54772256, 1.5811388, 2.4596748, 0.0, 9.0711474, 1.8516402, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, -6.2609903, 0.0, 3.8340579, 0.0, 0.0, 10.583005, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0392305, 0.0, 3.1622777, -0.4472136, 0.0, 0.0, 0.0, 5.891883, -0.53452248, 0.075592895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.4605935, 1.4200939, 0.0, 0.0, 0.0, 9.0711474, 4.9377072, -0.69829725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692, 0.0, -6.2609903, 2.2135944, 0.0, 0.0, 0.0, 0.0, 10.583005, 2.9933259, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157677, 0.0, 0.0, -4.6957428, 0.0, 0.0, 0.0, 0.0, 0.0, 12.699606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 1.2360331, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 11.055416, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, 0.4045868, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 2.8252185, -0.050973145, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 0.36187343, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 11.055416, 1.5957118, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, -8.4615728, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 12.437343, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 0.3350297, 4.0620192, -0.82065181, 0.0, 1.6992645, -0.099103121, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 4.9441323, -0.21408721, 0.01248582, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, 0.29965967, 2.0761031, 1.4680266, 0.0, 0.86849624, 0.70912421, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 11.055416, 3.8297084, -0.22335313, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 0.25951289, 0.74914918, 2.754588, 0.0, -8.4615728, 1.1514742, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 12.437343, 2.1760817, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 7.6280899, 0.0, 3.1141546, 0.0, 0.0, -7.521398, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634884, 0.0, 2.6802376, -0.47380354, 0.0, 0.0, 0.0, 5.0977936, -0.79282497, 0.14015298, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.9106117, -0.64226163, 0.099886557, -0.017657615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.76594169, 0.0, 1.4982984, 0.84756554, 0.0, 0.0, 0.0, 1.6284304, 3.545621, -0.81481812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.055416, 7.1807033, -1.1167657, 0.19741814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66332496, 0.0, 0.69203437, 1.5903621, 0.0, 0.0, 0.0, -8.4615728, 3.0705979, 1.1941823, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.437343, 5.8028846, -1.0258148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.54160256, 0.0, 7.6280899, 1.797958, 0.0, 0.0, 0.0, 0.0, -7.521398, 3.1910589, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 3.350297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.3615918, 0.0, 0.0, 8.8994382, 0.0, 0.0, 0.0, 0.0, 0.0, -5.2649786, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583124, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 1.1908744, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 13.045375, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, 0.29439203, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 2.6463875, -0.029587512, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 0.26874192, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 13.045375, 1.4585173, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, -10.576284, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 14.349913, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 0.16060402, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, 1.1355121, -0.036421568, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 4.465779, -0.11412326, 0.0036605053, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, 0.14661074, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 0.61426726, 0.45439194, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 13.045375, 3.3337538, -0.1069302, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.13113263, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, -10.576284, 0.76327753, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 14.349913, 1.8410947, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 9.6529562, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, -9.915266, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.19948914, 3.6856035, -0.81441102, 0.0, 1.0278657, -0.078679579, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, 3.0280323, -0.23309803, 0.017842851, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.8049965, -0.3043287, 0.023427234, -0.001793274, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.18210784, 2.2079402, 0.89214257, 0.0, 0.61576511, 0.32320935, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 1.0749677, 1.9084461, -0.19274394, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 5.8340692, -0.44910686, 0.034377583, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, 0.1628822, 1.128481, 1.9948914, 0.0, 0.31471832, 0.57817447, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, -10.576284, 1.8318661, 0.6944379, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 4.4186272, -0.33823069, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.14106013, 0.40720551, 2.5338524, 0.0, 9.6529562, 0.6954358, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, -9.915266, 1.7348102, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 2.4409698, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, -7.9470826, 0.0, 2.5390823, 0.0, 0.0, 10.220777, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 2.3273733, -0.47020042, 0.0, 0.0, 0.0, 4.4969125, -0.91792842, 0.18544955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654087, -1.0198039, 0.2081666, -0.042056004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9239533, -0.71010029, 0.10249415, -0.02092153, 0.0042267875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66496381, 0.0, 1.4568627, 0.51507875, 0.0, 0.0, 0.0, 1.8472953, 2.5856748, -0.76181175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.7199483, 5.7253384, -1.5419515, 0.34168616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 9.3345107, -1.3473206, 0.27502066, -0.055562564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.59476171, 0.0, 0.81441102, 1.1517511, 0.0, 0.0, 0.0, 0.59009684, 2.8908723, 0.34069257, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -10.576284, 3.4347489, 3.4721895, -1.0387422, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 8.2849261, -1.6911535, 0.34166459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875, 0.0, 0.37616034, 1.4629204, 0.0, 0.0, 0.0, 9.6529562, 1.8544955, 1.9014232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.915266, 4.6261605, 0.81779736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 6.5092527, -1.3150676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.42056004, 0.0, -7.9470826, 1.4659398, 0.0, 0.0, 0.0, 0.0, 10.220777, 2.8908723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 4.0063725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 3.6239003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.5423789, 0.0, 0.0, -6.9105066, 0.0, 0.0, 0.0, 0.0, 0.0, 12.264933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -5.6658663, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20.499876, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, -0.0060978812, 0.0035206134, 0.0024894496, 0.0070594623, -0.005468236, -0.004464796, 0.0031570875, 0.0025777512, 0.0018227453, 0.0029826742, -0.0025208198, -0.002183094, 0.0019526186, 0.0016910173, 0.0013807099, -0.0011273449, -0.0009763093, -0.00079715321, -0.00056367244, 0.0027868711, -0.0024577893, -0.0021983136, 0.0020772111, 0.0018579141, 0.0016090008, -0.0016090008, -0.0014391341, -0.0012463267, -0.0010176215, 0.00092895704, 0.00083088444, 0.00071956703, 0.00058752402, 0.00041544222, 0.0070559352, -0.0063823336, -0.0058262468, 0.0056286891, 0.0051382667, 0.0045958054, -0.0047571106, -0.0043426279, -0.0038841645, -0.0033637851, 0.003684842, 0.0033637851, 0.0030086609, 0.0026055768, 0.0021274445, -0.0021274445, -0.0019420823, -0.0017370512, -0.0015043304, -0.0012282807, -0.00086852559};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4990908, 0.0, -3.3466401, -2.3664319, 15.491933, 0.0, 0.0, 0.69282032, 0.56568542, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.8989795, 0.0, 0.0, 0.0, 14.198591, -0.82807867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.2426407, 0.0, 0.0, 0.0, 0.0, 14.342743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.7635609, -1.5491933, 0.0, 0.0, 0.0, 9.5247047, -1.4813122, 0.26186147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1176915, 0.0, 3.1622777, 4.9193496, 0.0, 0.0, 0.0, 0.0, 10.69045, -2.4189726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5455844, 0.0, 0.0, 7.6681158, 0.0, 0.0, 0.0, 0.0, 0.0, 10.369185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.605769, 0.0, 0.0, 0.0, -4.2045893, -3.4330328, 0.0, 0.0, 0.0, 19.621417, 0.0, 0.0, 0.61167774, 0.52972846, 0.43252148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5313721, 0.0, 3.545621, -2.5071327, 4.7871355, 0.0, 0.0, -5.5662675, -1.0488088, 0.74161985, 0.0, 18.803495, -0.60312239, 0.0, 0.0, 0.0, 1.6818357, 0.70128378, 0.13213749, -0.093435318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0529824, 0.0, -1.5856499, 4.4848953, 4.2817442, 0.0, 0.0, 0.19148542, -3.7523326, -4.3116122, 0.0, 0.0, 18.880717, 0.0, 0.0, 0.0, 0.0, 0.84437134, 1.1818737, 1.0446386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.5951289, 0.0, 0.0, 0.0, 10.028531, -0.76764947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.413036, -1.2634761, 0.096714743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.3211538, 0.0, 0.0, 0.0, 3.9242834, 5.4928525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.304463, -1.7300859, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.0101782, 0.0, 0.0, 0.0, 0.0, 8.9192809, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.855856, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9664794, 0.0, 8.1240384, -1.6413036, 0.0, 0.0, 0.0, 11.77285, -2.403123, 0.48550416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.276186, -1.4832397, 0.30276504, -0.061167774, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6532998, 0.0, 4.1522062, 2.9360532, 0.0, 0.0, 0.0, 2.6324893, 9.8259133, -2.8226128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.608187, -3.0948718, 0.68387651, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2978251, 0.0, 1.4982984, 5.509176, 0.0, 0.0, 0.0, 0.0, 6.6480395, 4.1367689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.563614, -3.5535266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8761663, 0.0, 0.0, 6.2283093, 0.0, 0.0, 0.0, 0.0, 0.0, 11.054152, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.605769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.831867, 0.0, -4.4108709, -3.1189567, 16.674998, 0.0, 0.0, 2.1306531, 1.739671, 1.2301331, 0.0, -4.3665394, -3.7815341, 0.0, 0.0, 0.0, -0.55793594, -0.4831867, -0.39452029, -0.27896797, 23.698101, 0.0, 0.0, 0.49065338, 0.43885373, 0.38005848, 0.0, 0.0, 0.0, 0.0, 0.062693389, 0.056074672, 0.048562091, 0.039650781, 0.028037336, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.9105066, 0.0, 0.0, 0.0, 10.570624, -2.7255406, 0.0, 0.0, 0.0, 4.6733286, 0.0, 0.0, -7.8670587, -2.3971922, 0.6180945, 0.0, 0.0, 0.0, 0.0, 0.0, 23.105555, -0.46968719, 0.0, 0.0, 0.0, 1.6206575, 0.79066915, 0.24092688, -0.062120835, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.3084006, 0.0, 0.0, 0.0, -1.5236235, 11.1963, 0.0, 0.0, 0.0, 4.2661458, 0.0, 0.0, 0.13299276, -4.7221795, -6.676846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.153244, 0.0, 0.0, 0.0, 0.0, 0.72177888, 1.1112513, 1.1908744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8544964, 0.0, 5.9817182, -2.4880668, 1.9002924, 0.0, 0.0, -0.33993463, -2.3592215, 0.98130676, 0.0, 9.952267, -0.4309458, 0.0, 0.0, 0.0, -6.4536442, 0.077089929, 0.53502114, -0.22253946, 0.0, 0.0, 0.0, 21.52733, -1.0002405, 0.043311683, 0.0, 0.0, 0.0, 0.0, 2.7506613, 0.64861565, -0.0077478294, -0.053771648, 0.022366057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.5186578, 0.0, 1.9272482, 2.7255406, 1.7347217, 0.0, 0.0, -2.0170569, 3.4205263, -4.0311289, 0.0, 4.0883109, 5.3764379, 0.0, 0.0, 0.0, 0.36566964, -6.2514819, -2.0398101, 1.8080332, 0.0, 0.0, 0.0, 0.0, 22.188098, -1.2652152, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9845638, 1.4711358, 0.36381814, -0.29400945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1471832, 0.0, -0.86189161, 6.094494, 1.5515822, 0.0, 0.0, 0.069388867, -3.0594117, 1.8027756, 0.0, 0.0, 9.0312216, 0.0, 0.0, 0.0, 0.0, 0.40388851, -3.6746199, -5.4965068, 0.0, 0.0, 0.0, 0.0, 0.0, 21.784126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573, 1.7897486, 1.8079191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.5452363, 0.0, 0.0, 0.0, 6.7177802, -0.6094494, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.659398, -1.5234494, 0.13821013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501, -1.473325, 0.15311242, -0.013890641, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.4106013, 0.0, 0.0, 0.0, 3.6340541, 2.5035689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.5685703, 11.263055, -1.4929881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.36736, -2.650489, 0.26628761, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.2616801, 0.0, 0.0, 0.0, 1.4220486, 4.4785202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.2772513, 5.3790928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.965481, -2.6199237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.092647, 0.0, 0.0, 0.0, 0.0, 5.3868225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.437782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.90767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5233602, 0.0, 7.3712071, -1.628822, 0.0, 0.0, 0.0, 12.017131, -2.9072433, 0.64241607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882, -2.7252291, 0.6593008, -0.14568627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.804383, -1.405634, 0.27389583, -0.066262224, 0.014642021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3035022, 0.0, 4.4158804, 1.7842851, 0.0, 0.0, 0.0, 4.2661458, 7.8374103, -2.6389933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2342784, 13.222103, -4.6737922, 1.1836356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.125885, -3.1115036, 0.83361207, -0.19247437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.060315, 0.0, 2.256962, 3.9897829, 0.0, 0.0, 0.0, 0.9539392, 8.0114204, 1.1801937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.552549, 9.6224137, -3.5983084, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.393252, -4.6866619, 1.1835609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7842851, 0.0, 0.81441102, 5.0677049, 0.0, 0.0, 0.0, 0.0, 4.0151005, 6.5867231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.015931, 2.8329331, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.092945, -4.5555279, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4568627, 0.0, 0.0, 5.0781645, 0.0, 0.0, 0.0, 0.0, 0.0, 10.014276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.878481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.553559, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 9.1651514, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 0.0, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.6920998, 4.3817805, -0.77459667, 0.0, 10.998182, 0.96214047, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 2.7386128, 1.5811388, 2.4596748, 0.0, 0.0, 9.258201, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, 0.0, 0.0, 3.8340579, 0.0, 0.0, 0.0, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1961524, 0.0, -3.1622777, -2.236068, 0.0, 0.0, 0.0, 13.747727, 0.53452248, 0.37796447, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837, -2.8401878, 0.0, 0.0, 0.0, 0.0, 12.344268, 1.3965945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2045408, 0.0, 0.0, 6.6407831, 0.0, 0.0, 0.0, 0.0, 0.0, 8.9799777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 11.124298, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 0.0, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, -8.0917359, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 12.713483, 1.0194629, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 2.533114, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 0.0, 11.169983, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, 0.0, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 7.0356236, 4.0620192, -0.82065181, 0.0, -6.7970582, -2.0811655, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 14.832397, 0.85634884, 0.26220221, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, -2.696937, 2.0761031, 1.4680266, 0.0, 3.0397368, -6.3821179, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 0.0, 13.40398, 2.0101782, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 1.2975644, 0.74914918, 2.754588, 0.0, 0.0, 5.7573711, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 0.0, 10.880409, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 0.0, 0.0, 3.1141546, 0.0, 0.0, 0.0, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253954, 0.0, 9.3808315, 1.8952142, 0.0, 0.0, 0.0, -3.3985291, -2.7748874, -0.56061191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.798876, 0.42817442, 0.34960295, 0.070630462, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8297084, 0.0, -1.4982984, 4.2378277, 0.0, 0.0, 0.0, 3.799671, -3.545621, -4.0740906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.754974, 1.1167657, 0.98709071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.3266499, 0.0, 1.7300859, -3.1807243, 0.0, 0.0, 0.0, 0.0, 7.6764947, -2.3883647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.507211, 2.0516295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6248077, 0.0, 0.0, 5.3938741, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.050891, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 13.099618, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 0.0, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, -10.303721, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 14.555131, 1.0355629, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 2.4186773, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 0.0, 13.126656, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, 0.0, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 0.0, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 9.1544291, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, -9.4626009, -2.0760294, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 16.374523, 0.95102718, 0.2086488, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, -2.9322148, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 2.7642027, -9.0878388, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 0.0, 15.001892, 2.1386041, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.91792842, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, 0.0, 5.3429427, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 0.0, 12.887663, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 0.0, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, 0.0, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, -6.7826309, 3.6856035, -0.81441102, 0.0, 10.021691, 2.6751057, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, -7.5700807, -2.2727058, -0.60665695, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.71374, 0.76082174, 0.22841553, 0.060971317, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 3.8242646, 2.2079402, 0.89214257, 0.0, -2.4630604, 6.7873964, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 3.2249031, -7.6337846, -4.0476228, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.502208, 1.7964274, 0.72192923, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, -1.4659398, 1.128481, 1.9948914, 0.0, 1.1015141, -5.2035702, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, 0.0, 6.4115313, -6.2499411, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.465195, 3.0440762, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.70530063, 0.40720551, 2.5338524, 0.0, 0.0, 3.477179, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, 0.0, 8.6740509, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.204849, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 0.0, 2.5390823, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0990195, 0.0, -4.6547467, -3.2914029, 0.0, 0.0, 0.0, 13.490738, 1.8358568, 1.2981468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.5327043, -3.0594117, -0.4163332, -0.29439203, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.832697, 0.35505015, 0.30748245, 0.041843061, 0.029587512, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6598552, 0.0, 5.0990195, -2.060315, 0.0, 0.0, 0.0, -1.2315302, 9.0498619, 3.047247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.8698837, -3.8168923, -5.3968303, -1.3667446, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.002649, 0.89821372, 0.96257231, 0.22225026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9738086, 0.0, -0.81441102, 5.7587555, 0.0, 0.0, 0.0, 1.3768926, -2.8908723, 1.7034629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0144141, -3.4721895, -5.1937108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.331494, 1.6911535, 1.708323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.0301575, 0.0, 0.94040084, -2.9258408, 0.0, 0.0, 0.0, 0.0, 4.6362387, -3.8028463, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.565401, -1.6355947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.273132, 2.6301353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.0, 0.0, 4.3978195, 0.0, 0.0, 0.0, 0.0, 0.0, 8.672617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.019117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.871701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 1.3093073, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 9.0711474, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.63245553, 4.3817805, -0.77459667, 0.0, 3.1423376, -0.1069045, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 0.54772256, 1.5811388, 2.4596748, 0.0, 9.0711474, 1.8516402, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, -6.2609903, 0.0, 3.8340579, 0.0, 0.0, 10.583005, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0392305, 0.0, 3.1622777, -0.4472136, 0.0, 0.0, 0.0, 5.891883, -0.53452248, 0.075592895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.4605935, 1.4200939, 0.0, 0.0, 0.0, 9.0711474, 4.9377072, -0.69829725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692, 0.0, -6.2609903, 2.2135944, 0.0, 0.0, 0.0, 0.0, 10.583005, 2.9933259, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157677, 0.0, 0.0, -4.6957428, 0.0, 0.0, 0.0, 0.0, 0.0, 12.699606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 1.2360331, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 11.055416, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, 0.4045868, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 2.8252185, -0.050973145, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 0.36187343, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 11.055416, 1.5957118, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, -8.4615728, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 12.437343, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 0.3350297, 4.0620192, -0.82065181, 0.0, 1.6992645, -0.099103121, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 4.9441323, -0.21408721, 0.01248582, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, 0.29965967, 2.0761031, 1.4680266, 0.0, 0.86849624, 0.70912421, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 11.055416, 3.8297084, -0.22335313, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 0.25951289, 0.74914918, 2.754588, 0.0, -8.4615728, 1.1514742, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 12.437343, 2.1760817, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 7.6280899, 0.0, 3.1141546, 0.0, 0.0, -7.521398, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634884, 0.0, 2.6802376, -0.47380354, 0.0, 0.0, 0.0, 5.0977936, -0.79282497, 0.14015298, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.9106117, -0.64226163, 0.099886557, -0.017657615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.76594169, 0.0, 1.4982984, 0.84756554, 0.0, 0.0, 0.0, 1.6284304, 3.545621, -0.81481812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.055416, 7.1807033, -1.1167657, 0.19741814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66332496, 0.0, 0.69203437, 1.5903621, 0.0, 0.0, 0.0, -8.4615728, 3.0705979, 1.1941823, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.437343, 5.8028846, -1.0258148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.54160256, 0.0, 7.6280899, 1.797958, 0.0, 0.0, 0.0, 0.0, -7.521398, 3.1910589, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 3.350297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.3615918, 0.0, 0.0, 8.8994382, 0.0, 0.0, 0.0, 0.0, 0.0, -5.2649786, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583124, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 1.1908744, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 13.045375, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, 0.29439203, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 2.6463875, -0.029587512, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 0.26874192, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 13.045375, 1.4585173, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, -10.576284, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 14.349913, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 0.16060402, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, 1.1355121, -0.036421568, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 4.465779, -0.11412326, 0.0036605053, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, 0.14661074, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 0.61426726, 0.45439194, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 13.045375, 3.3337538, -0.1069302, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.13113263, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, -10.576284, 0.76327753, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 14.349913, 1.8410947, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 9.6529562, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, -9.915266, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.19948914, 3.6856035, -0.81441102, 0.0, 1.0278657, -0.078679579, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, 3.0280323, -0.23309803, 0.017842851, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.8049965, -0.3043287, 0.023427234, -0.001793274, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.18210784, 2.2079402, 0.89214257, 0.0, 0.61576511, 0.32320935, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 1.0749677, 1.9084461, -0.19274394, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 5.8340692, -0.44910686, 0.034377583, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, 0.1628822, 1.128481, 1.9948914, 0.0, 0.31471832, 0.57817447, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, -10.576284, 1.8318661, 0.6944379, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 4.4186272, -0.33823069, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.14106013, 0.40720551, 2.5338524, 0.0, 9.6529562, 0.6954358, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, -9.915266, 1.7348102, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 2.4409698, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, -7.9470826, 0.0, 2.5390823, 0.0, 0.0, 10.220777, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 2.3273733, -0.47020042, 0.0, 0.0, 0.0, 4.4969125, -0.91792842, 0.18544955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654087, -1.0198039, 0.2081666, -0.042056004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9239533, -0.71010029, 0.10249415, -0.02092153, 0.0042267875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66496381, 0.0, 1.4568627, 0.51507875, 0.0, 0.0, 0.0, 1.8472953, 2.5856748, -0.76181175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.7199483, 5.7253384, -1.5419515, 0.34168616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 9.3345107, -1.3473206, 0.27502066, -0.055562564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.59476171, 0.0, 0.81441102, 1.1517511, 0.0, 0.0, 0.0, 0.59009684, 2.8908723, 0.34069257, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -10.576284, 3.4347489, 3.4721895, -1.0387422, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 8.2849261, -1.6911535, 0.34166459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875, 0.0, 0.37616034, 1.4629204, 0.0, 0.0, 0.0, 9.6529562, 1.8544955, 1.9014232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.915266, 4.6261605, 0.81779736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 6.5092527, -1.3150676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.42056004, 0.0, -7.9470826, 1.4659398, 0.0, 0.0, 0.0, 0.0, 10.220777, 2.8908723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 4.0063725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 3.6239003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.5423789, 0.0, 0.0, -6.9105066, 0.0, 0.0, 0.0, 0.0, 0.0, 12.264933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -5.6658663, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20.499876, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0, -0.0070412267, 0.0024894496, 0.0, 0.0, 0.0, 0.0094712626, -0.0051555024, 0.0018227453, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0045093795, -0.0029289279, 0.0015943064, -0.00056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0046447852, -0.0033235377, 0.0021587011, -0.001175048, 0.00041544222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.012764667, -0.0097104113, 0.0069482047, -0.0045129913, 0.0024565613, -0.00086852559};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4990908, 0.0, -3.3466401, -2.3664319, 15.491933, 0.0, 0.0, 0.69282032, 0.56568542, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.8989795, 0.0, 0.0, 0.0, 14.198591, -0.82807867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.2426407, 0.0, 0.0, 0.0, 0.0, 14.342743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.7635609, -1.5491933, 0.0, 0.0, 0.0, 9.5247047, -1.4813122, 0.26186147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1176915, 0.0, 3.1622777, 4.9193496, 0.0, 0.0, 0.0, 0.0, 10.69045, -2.4189726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5455844, 0.0, 0.0, 7.6681158, 0.0, 0.0, 0.0, 0.0, 0.0, 10.369185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.605769, 0.0, 0.0, 0.0, -4.2045893, -3.4330328, 0.0, 0.0, 0.0, 19.621417, 0.0, 0.0, 0.61167774, 0.52972846, 0.43252148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5313721, 0.0, 3.545621, -2.5071327, 4.7871355, 0.0, 0.0, -5.5662675, -1.0488088, 0.74161985, 0.0, 18.803495, -0.60312239, 0.0, 0.0, 0.0, 1.6818357, 0.70128378, 0.13213749, -0.093435318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0529824, 0.0, -1.5856499, 4.4848953, 4.2817442, 0.0, 0.0, 0.19148542, -3.7523326, -4.3116122, 0.0, 0.0, 18.880717, 0.0, 0.0, 0.0, 0.0, 0.84437134, 1.1818737, 1.0446386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.5951289, 0.0, 0.0, 0.0, 10.028531, -0.76764947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.413036, -1.2634761, 0.096714743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.3211538, 0.0, 0.0, 0.0, 3.9242834, 5.4928525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.304463, -1.7300859, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.0101782, 0.0, 0.0, 0.0, 0.0, 8.9192809, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.855856, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9664794, 0.0, 8.1240384, -1.6413036, 0.0, 0.0, 0.0, 11.77285, -2.403123, 0.48550416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.276186, -1.4832397, 0.30276504, -0.061167774, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6532998, 0.0, 4.1522062, 2.9360532, 0.0, 0.0, 0.0, 2.6324893, 9.8259133, -2.8226128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.608187, -3.0948718, 0.68387651, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2978251, 0.0, 1.4982984, 5.509176, 0.0, 0.0, 0.0, 0.0, 6.6480395, 4.1367689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.563614, -3.5535266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8761663, 0.0, 0.0, 6.2283093, 0.0, 0.0, 0.0, 0.0, 0.0, 11.054152, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.605769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.831867, 0.0, -4.4108709, -3.1189567, 16.674998, 0.0, 0.0, 2.1306531, 1.739671, 1.2301331, 0.0, -4.3665394, -3.7815341, 0.0, 0.0, 0.0, -0.55793594, -0.4831867, -0.39452029, -0.27896797, 23.698101, 0.0, 0.0, 0.49065338, 0.43885373, 0.38005848, 0.0, 0.0, 0.0, 0.0, 0.062693389, 0.056074672, 0.048562091, 0.039650781, 0.028037336, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.9105066, 0.0, 0.0, 0.0, 10.570624, -2.7255406, 0.0, 0.0, 0.0, 4.6733286, 0.0, 0.0, -7.8670587, -2.3971922, 0.6180945, 0.0, 0.0, 0.0, 0.0, 0.0, 23.105555, -0.46968719, 0.0, 0.0, 0.0, 1.6206575, 0.79066915, 0.24092688, -0.062120835, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.3084006, 0.0, 0.0, 0.0, -1.5236235, 11.1963, 0.0, 0.0, 0.0, 4.2661458, 0.0, 0.0, 0.13299276, -4.7221795, -6.676846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.153244, 0.0, 0.0, 0.0, 0.0, 0.72177888, 1.1112513, 1.1908744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8544964, 0.0, 5.9817182, -2.4880668, 1.9002924, 0.0, 0.0, -0.33993463, -2.3592215, 0.98130676, 0.0, 9.952267, -0.4309458, 0.0, 0.0, 0.0, -6.4536442, 0.077089929, 0.53502114, -0.22253946, 0.0, 0.0, 0.0, 21.52733, -1.0002405, 0.043311683, 0.0, 0.0, 0.0, 0.0, 2.7506613, 0.64861565, -0.0077478294, -0.053771648, 0.022366057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.5186578, 0.0, 1.9272482, 2.7255406, 1.7347217, 0.0, 0.0, -2.0170569, 3.4205263, -4.0311289, 0.0, 4.0883109, 5.3764379, 0.0, 0.0, 0.0, 0.36566964, -6.2514819, -2.0398101, 1.8080332, 0.0, 0.0, 0.0, 0.0, 22.188098, -1.2652152, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9845638, 1.4711358, 0.36381814, -0.29400945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1471832, 0.0, -0.86189161, 6.094494, 1.5515822, 0.0, 0.0, 0.069388867, -3.0594117, 1.8027756, 0.0, 0.0, 9.0312216, 0.0, 0.0, 0.0, 0.0, 0.40388851, -3.6746199, -5.4965068, 0.0, 0.0, 0.0, 0.0, 0.0, 21.784126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573, 1.7897486, 1.8079191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.5452363, 0.0, 0.0, 0.0, 6.7177802, -0.6094494, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.659398, -1.5234494, 0.13821013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501, -1.473325, 0.15311242, -0.013890641, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.4106013, 0.0, 0.0, 0.0, 3.6340541, 2.5035689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.5685703, 11.263055, -1.4929881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.36736, -2.650489, 0.26628761, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.2616801, 0.0, 0.0, 0.0, 1.4220486, 4.4785202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.2772513, 5.3790928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.965481, -2.6199237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.092647, 0.0, 0.0, 0.0, 0.0, 5.3868225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.437782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.90767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5233602, 0.0, 7.3712071, -1.628822, 0.0, 0.0, 0.0, 12.017131, -2.9072433, 0.64241607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882, -2.7252291, 0.6593008, -0.14568627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.804383, -1.405634, 0.27389583, -0.066262224, 0.014642021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3035022, 0.0, 4.4158804, 1.7842851, 0.0, 0.0, 0.0, 4.2661458, 7.8374103, -2.6389933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2342784, 13.222103, -4.6737922, 1.1836356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.125885, -3.1115036, 0.83361207, -0.19247437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.060315, 0.0, 2.256962, 3.9897829, 0.0, 0.0, 0.0, 0.9539392, 8.0114204, 1.1801937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.552549, 9.6224137, -3.5983084, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.393252, -4.6866619, 1.1835609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7842851, 0.0, 0.81441102, 5.0677049, 0.0, 0.0, 0.0, 0.0, 4.0151005, 6.5867231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.015931, 2.8329331, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.092945, -4.5555279, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4568627, 0.0, 0.0, 5.0781645, 0.0, 0.0, 0.0, 0.0, 0.0, 10.014276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.878481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.553559, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 9.1651514, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 0.0, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.6920998, 4.3817805, -0.77459667, 0.0, 10.998182, 0.96214047, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 2.7386128, 1.5811388, 2.4596748, 0.0, 0.0, 9.258201, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, 0.0, 0.0, 3.8340579, 0.0, 0.0, 0.0, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1961524, 0.0, -3.1622777, -2.236068, 0.0, 0.0, 0.0, 13.747727, 0.53452248, 0.37796447, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837, -2.8401878, 0.0, 0.0, 0.0, 0.0, 12.344268, 1.3965945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2045408, 0.0, 0.0, 6.6407831, 0.0, 0.0, 0.0, 0.0, 0.0, 8.9799777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 11.124298, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 0.0, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, -8.0917359, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 12.713483, 1.0194629, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 2.533114, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 0.0, 11.169983, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, 0.0, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 7.0356236, 4.0620192, -0.82065181, 0.0, -6.7970582, -2.0811655, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 14.832397, 0.85634884, 0.26220221, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, -2.696937, 2.0761031, 1.4680266, 0.0, 3.0397368, -6.3821179, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 0.0, 13.40398, 2.0101782, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 1.2975644, 0.74914918, 2.754588, 0.0, 0.0, 5.7573711, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 0.0, 10.880409, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 0.0, 0.0, 3.1141546, 0.0, 0.0, 0.0, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253954, 0.0, 9.3808315, 1.8952142, 0.0, 0.0, 0.0, -3.3985291, -2.7748874, -0.56061191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.798876, 0.42817442, 0.34960295, 0.070630462, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8297084, 0.0, -1.4982984, 4.2378277, 0.0, 0.0, 0.0, 3.799671, -3.545621, -4.0740906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.754974, 1.1167657, 0.98709071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.3266499, 0.0, 1.7300859, -3.1807243, 0.0, 0.0, 0.0, 0.0, 7.6764947, -2.3883647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.507211, 2.0516295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6248077, 0.0, 0.0, 5.3938741, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.050891, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 13.099618, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 0.0, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, -10.303721, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 14.555131, 1.0355629, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 2.4186773, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 0.0, 13.126656, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, 0.0, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 0.0, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 9.1544291, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, -9.4626009, -2.0760294, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 16.374523, 0.95102718, 0.2086488, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, -2.9322148, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 2.7642027, -9.0878388, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 0.0, 15.001892, 2.1386041, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.91792842, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, 0.0, 5.3429427, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 0.0, 12.887663, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 0.0, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, 0.0, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, -6.7826309, 3.6856035, -0.81441102, 0.0, 10.021691, 2.6751057, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, -7.5700807, -2.2727058, -0.60665695, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.71374, 0.76082174, 0.22841553, 0.060971317, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 3.8242646, 2.2079402, 0.89214257, 0.0, -2.4630604, 6.7873964, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 3.2249031, -7.6337846, -4.0476228, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.502208, 1.7964274, 0.72192923, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, -1.4659398, 1.128481, 1.9948914, 0.0, 1.1015141, -5.2035702, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, 0.0, 6.4115313, -6.2499411, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.465195, 3.0440762, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.70530063, 0.40720551, 2.5338524, 0.0, 0.0, 3.477179, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, 0.0, 8.6740509, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.204849, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 0.0, 2.5390823, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0990195, 0.0, -4.6547467, -3.2914029, 0.0, 0.0, 0.0, 13.490738, 1.8358568, 1.2981468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.5327043, -3.0594117, -0.4163332, -0.29439203, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.832697, 0.35505015, 0.30748245, 0.041843061, 0.029587512, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6598552, 0.0, 5.0990195, -2.060315, 0.0, 0.0, 0.0, -1.2315302, 9.0498619, 3.047247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.8698837, -3.8168923, -5.3968303, -1.3667446, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.002649, 0.89821372, 0.96257231, 0.22225026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9738086, 0.0, -0.81441102, 5.7587555, 0.0, 0.0, 0.0, 1.3768926, -2.8908723, 1.7034629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0144141, -3.4721895, -5.1937108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.331494, 1.6911535, 1.708323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.0301575, 0.0, 0.94040084, -2.9258408, 0.0, 0.0, 0.0, 0.0, 4.6362387, -3.8028463, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.565401, -1.6355947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.273132, 2.6301353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.0, 0.0, 4.3978195, 0.0, 0.0, 0.0, 0.0, 0.0, 8.672617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.019117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.871701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 1.3093073, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 9.0711474, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.63245553, 4.3817805, -0.77459667, 0.0, 3.1423376, -0.1069045, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 0.54772256, 1.5811388, 2.4596748, 0.0, 9.0711474, 1.8516402, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, -6.2609903, 0.0, 3.8340579, 0.0, 0.0, 10.583005, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0392305, 0.0, 3.1622777, -0.4472136, 0.0, 0.0, 0.0, 5.891883, -0.53452248, 0.075592895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.4605935, 1.4200939, 0.0, 0.0, 0.0, 9.0711474, 4.9377072, -0.69829725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692, 0.0, -6.2609903, 2.2135944, 0.0, 0.0, 0.0, 0.0, 10.583005, 2.9933259, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157677, 0.0, 0.0, -4.6957428, 0.0, 0.0, 0.0, 0.0, 0.0, 12.699606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 1.2360331, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 11.055416, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, 0.4045868, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 2.8252185, -0.050973145, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 0.36187343, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 11.055416, 1.5957118, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, -8.4615728, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 12.437343, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 0.3350297, 4.0620192, -0.82065181, 0.0, 1.6992645, -0.099103121, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 4.9441323, -0.21408721, 0.01248582, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, 0.29965967, 2.0761031, 1.4680266, 0.0, 0.86849624, 0.70912421, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 11.055416, 3.8297084, -0.22335313, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 0.25951289, 0.74914918, 2.754588, 0.0, -8.4615728, 1.1514742, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 12.437343, 2.1760817, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 7.6280899, 0.0, 3.1141546, 0.0, 0.0, -7.521398, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634884, 0.0, 2.6802376, -0.47380354, 0.0, 0.0, 0.0, 5.0977936, -0.79282497, 0.14015298, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.9106117, -0.64226163, 0.099886557, -0.017657615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.76594169, 0.0, 1.4982984, 0.84756554, 0.0, 0.0, 0.0, 1.6284304, 3.545621, -0.81481812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.055416, 7.1807033, -1.1167657, 0.19741814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66332496, 0.0, 0.69203437, 1.5903621, 0.0, 0.0, 0.0, -8.4615728, 3.0705979, 1.1941823, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.437343, 5.8028846, -1.0258148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.54160256, 0.0, 7.6280899, 1.797958, 0.0, 0.0, 0.0, 0.0, -7.521398, 3.1910589, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 3.350297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.3615918, 0.0, 0.0, 8.8994382, 0.0, 0.0, 0.0, 0.0, 0.0, -5.2649786, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583124, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 1.1908744, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 13.045375, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, 0.29439203, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 2.6463875, -0.029587512, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 0.26874192, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 13.045375, 1.4585173, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, -10.576284, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 14.349913, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 0.16060402, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, 1.1355121, -0.036421568, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 4.465779, -0.11412326, 0.0036605053, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, 0.14661074, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 0.61426726, 0.45439194, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 13.045375, 3.3337538, -0.1069302, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.13113263, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, -10.576284, 0.76327753, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 14.349913, 1.8410947, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 9.6529562, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, -9.915266, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.19948914, 3.6856035, -0.81441102, 0.0, 1.0278657, -0.078679579, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, 3.0280323, -0.23309803, 0.017842851, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.8049965, -0.3043287, 0.023427234, -0.001793274, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.18210784, 2.2079402, 0.89214257, 0.0, 0.61576511, 0.32320935, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 1.0749677, 1.9084461, -0.19274394, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 5.8340692, -0.44910686, 0.034377583, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, 0.1628822, 1.128481, 1.9948914, 0.0, 0.31471832, 0.57817447, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, -10.576284, 1.8318661, 0.6944379, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 4.4186272, -0.33823069, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.14106013, 0.40720551, 2.5338524, 0.0, 9.6529562, 0.6954358, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, -9.915266, 1.7348102, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 2.4409698, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, -7.9470826, 0.0, 2.5390823, 0.0, 0.0, 10.220777, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 2.3273733, -0.47020042, 0.0, 0.0, 0.0, 4.4969125, -0.91792842, 0.18544955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654087, -1.0198039, 0.2081666, -0.042056004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9239533, -0.71010029, 0.10249415, -0.02092153, 0.0042267875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66496381, 0.0, 1.4568627, 0.51507875, 0.0, 0.0, 0.0, 1.8472953, 2.5856748, -0.76181175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.7199483, 5.7253384, -1.5419515, 0.34168616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 9.3345107, -1.3473206, 0.27502066, -0.055562564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.59476171, 0.0, 0.81441102, 1.1517511, 0.0, 0.0, 0.0, 0.59009684, 2.8908723, 0.34069257, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -10.576284, 3.4347489, 3.4721895, -1.0387422, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 8.2849261, -1.6911535, 0.34166459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875, 0.0, 0.37616034, 1.4629204, 0.0, 0.0, 0.0, 9.6529562, 1.8544955, 1.9014232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.915266, 4.6261605, 0.81779736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 6.5092527, -1.3150676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.42056004, 0.0, -7.9470826, 1.4659398, 0.0, 0.0, 0.0, 0.0, 10.220777, 2.8908723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 4.0063725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 3.6239003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.5423789, 0.0, 0.0, -6.9105066, 0.0, 0.0, 0.0, 0.0, 0.0, 12.264933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -5.6658663, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20.499876, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.009450674, 0.0, 0.0, -0.0074683487, 0.0, 0.0, 0.0, 0.0, 0.0, 0.010936472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0056367244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0062316333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.018239037};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4990908, 0.0, -3.3466401, -2.3664319, 15.491933, 0.0, 0.0, 0.69282032, 0.56568542, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.8989795, 0.0, 0.0, 0.0, 14.198591, -0.82807867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.2426407, 0.0, 0.0, 0.0, 0.0, 14.342743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.7635609, -1.5491933, 0.0, 0.0, 0.0, 9.5247047, -1.4813122, 0.26186147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1176915, 0.0, 3.1622777, 4.9193496, 0.0, 0.0, 0.0, 0.0, 10.69045, -2.4189726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5455844, 0.0, 0.0, 7.6681158, 0.0, 0.0, 0.0, 0.0, 0.0, 10.369185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.605769, 0.0, 0.0, 0.0, -4.2045893, -3.4330328, 0.0, 0.0, 0.0, 19.621417, 0.0, 0.0, 0.61167774, 0.52972846, 0.43252148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5313721, 0.0, 3.545621, -2.5071327, 4.7871355, 0.0, 0.0, -5.5662675, -1.0488088, 0.74161985, 0.0, 18.803495, -0.60312239, 0.0, 0.0, 0.0, 1.6818357, 0.70128378, 0.13213749, -0.093435318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0529824, 0.0, -1.5856499, 4.4848953, 4.2817442, 0.0, 0.0, 0.19148542, -3.7523326, -4.3116122, 0.0, 0.0, 18.880717, 0.0, 0.0, 0.0, 0.0, 0.84437134, 1.1818737, 1.0446386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.5951289, 0.0, 0.0, 0.0, 10.028531, -0.76764947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.413036, -1.2634761, 0.096714743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.3211538, 0.0, 0.0, 0.0, 3.9242834, 5.4928525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.304463, -1.7300859, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.0101782, 0.0, 0.0, 0.0, 0.0, 8.9192809, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.855856, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9664794, 0.0, 8.1240384, -1.6413036, 0.0, 0.0, 0.0, 11.77285, -2.403123, 0.48550416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.276186, -1.4832397, 0.30276504, -0.061167774, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6532998, 0.0, 4.1522062, 2.9360532, 0.0, 0.0, 0.0, 2.6324893, 9.8259133, -2.8226128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.608187, -3.0948718, 0.68387651, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2978251, 0.0, 1.4982984, 5.509176, 0.0, 0.0, 0.0, 0.0, 6.6480395, 4.1367689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.563614, -3.5535266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8761663, 0.0, 0.0, 6.2283093, 0.0, 0.0, 0.0, 0.0, 0.0, 11.054152, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.605769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.831867, 0.0, -4.4108709, -3.1189567, 16.674998, 0.0, 0.0, 2.1306531, 1.739671, 1.2301331, 0.0, -4.3665394, -3.7815341, 0.0, 0.0, 0.0, -0.55793594, -0.4831867, -0.39452029, -0.27896797, 23.698101, 0.0, 0.0, 0.49065338, 0.43885373, 0.38005848, 0.0, 0.0, 0.0, 0.0, 0.062693389, 0.056074672, 0.048562091, 0.039650781, 0.028037336, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.9105066, 0.0, 0.0, 0.0, 10.570624, -2.7255406, 0.0, 0.0, 0.0, 4.6733286, 0.0, 0.0, -7.8670587, -2.3971922, 0.6180945, 0.0, 0.0, 0.0, 0.0, 0.0, 23.105555, -0.46968719, 0.0, 0.0, 0.0, 1.6206575, 0.79066915, 0.24092688, -0.062120835, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.3084006, 0.0, 0.0, 0.0, -1.5236235, 11.1963, 0.0, 0.0, 0.0, 4.2661458, 0.0, 0.0, 0.13299276, -4.7221795, -6.676846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.153244, 0.0, 0.0, 0.0, 0.0, 0.72177888, 1.1112513, 1.1908744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8544964, 0.0, 5.9817182, -2.4880668, 1.9002924, 0.0, 0.0, -0.33993463, -2.3592215, 0.98130676, 0.0, 9.952267, -0.4309458, 0.0, 0.0, 0.0, -6.4536442, 0.077089929, 0.53502114, -0.22253946, 0.0, 0.0, 0.0, 21.52733, -1.0002405, 0.043311683, 0.0, 0.0, 0.0, 0.0, 2.7506613, 0.64861565, -0.0077478294, -0.053771648, 0.022366057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.5186578, 0.0, 1.9272482, 2.7255406, 1.7347217, 0.0, 0.0, -2.0170569, 3.4205263, -4.0311289, 0.0, 4.0883109, 5.3764379, 0.0, 0.0, 0.0, 0.36566964, -6.2514819, -2.0398101, 1.8080332, 0.0, 0.0, 0.0, 0.0, 22.188098, -1.2652152, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9845638, 1.4711358, 0.36381814, -0.29400945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1471832, 0.0, -0.86189161, 6.094494, 1.5515822, 0.0, 0.0, 0.069388867, -3.0594117, 1.8027756, 0.0, 0.0, 9.0312216, 0.0, 0.0, 0.0, 0.0, 0.40388851, -3.6746199, -5.4965068, 0.0, 0.0, 0.0, 0.0, 0.0, 21.784126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573, 1.7897486, 1.8079191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.5452363, 0.0, 0.0, 0.0, 6.7177802, -0.6094494, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.659398, -1.5234494, 0.13821013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501, -1.473325, 0.15311242, -0.013890641, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.4106013, 0.0, 0.0, 0.0, 3.6340541, 2.5035689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.5685703, 11.263055, -1.4929881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.36736, -2.650489, 0.26628761, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.2616801, 0.0, 0.0, 0.0, 1.4220486, 4.4785202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.2772513, 5.3790928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.965481, -2.6199237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.092647, 0.0, 0.0, 0.0, 0.0, 5.3868225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.437782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.90767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5233602, 0.0, 7.3712071, -1.628822, 0.0, 0.0, 0.0, 12.017131, -2.9072433, 0.64241607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882, -2.7252291, 0.6593008, -0.14568627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.804383, -1.405634, 0.27389583, -0.066262224, 0.014642021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3035022, 0.0, 4.4158804, 1.7842851, 0.0, 0.0, 0.0, 4.2661458, 7.8374103, -2.6389933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2342784, 13.222103, -4.6737922, 1.1836356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.125885, -3.1115036, 0.83361207, -0.19247437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.060315, 0.0, 2.256962, 3.9897829, 0.0, 0.0, 0.0, 0.9539392, 8.0114204, 1.1801937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.552549, 9.6224137, -3.5983084, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.393252, -4.6866619, 1.1835609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7842851, 0.0, 0.81441102, 5.0677049, 0.0, 0.0, 0.0, 0.0, 4.0151005, 6.5867231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.015931, 2.8329331, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.092945, -4.5555279, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4568627, 0.0, 0.0, 5.0781645, 0.0, 0.0, 0.0, 0.0, 0.0, 10.014276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.878481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.553559, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 9.1651514, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 0.0, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.6920998, 4.3817805, -0.77459667, 0.0, 10.998182, 0.96214047, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 2.7386128, 1.5811388, 2.4596748, 0.0, 0.0, 9.258201, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, 0.0, 0.0, 3.8340579, 0.0, 0.0, 0.0, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1961524, 0.0, -3.1622777, -2.236068, 0.0, 0.0, 0.0, 13.747727, 0.53452248, 0.37796447, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837, -2.8401878, 0.0, 0.0, 0.0, 0.0, 12.344268, 1.3965945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2045408, 0.0, 0.0, 6.6407831, 0.0, 0.0, 0.0, 0.0, 0.0, 8.9799777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 11.124298, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 0.0, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, -8.0917359, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 12.713483, 1.0194629, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 2.533114, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 0.0, 11.169983, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, 0.0, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 7.0356236, 4.0620192, -0.82065181, 0.0, -6.7970582, -2.0811655, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 14.832397, 0.85634884, 0.26220221, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, -2.696937, 2.0761031, 1.4680266, 0.0, 3.0397368, -6.3821179, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 0.0, 13.40398, 2.0101782, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 1.2975644, 0.74914918, 2.754588, 0.0, 0.0, 5.7573711, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 0.0, 10.880409, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 0.0, 0.0, 3.1141546, 0.0, 0.0, 0.0, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253954, 0.0, 9.3808315, 1.8952142, 0.0, 0.0, 0.0, -3.3985291, -2.7748874, -0.56061191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.798876, 0.42817442, 0.34960295, 0.070630462, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8297084, 0.0, -1.4982984, 4.2378277, 0.0, 0.0, 0.0, 3.799671, -3.545621, -4.0740906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.754974, 1.1167657, 0.98709071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.3266499, 0.0, 1.7300859, -3.1807243, 0.0, 0.0, 0.0, 0.0, 7.6764947, -2.3883647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.507211, 2.0516295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6248077, 0.0, 0.0, 5.3938741, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.050891, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 13.099618, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 0.0, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, -10.303721, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 14.555131, 1.0355629, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 2.4186773, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 0.0, 13.126656, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, 0.0, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 0.0, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 9.1544291, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, -9.4626009, -2.0760294, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 16.374523, 0.95102718, 0.2086488, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, -2.9322148, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 2.7642027, -9.0878388, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 0.0, 15.001892, 2.1386041, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.91792842, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, 0.0, 5.3429427, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 0.0, 12.887663, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 0.0, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, 0.0, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, -6.7826309, 3.6856035, -0.81441102, 0.0, 10.021691, 2.6751057, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, -7.5700807, -2.2727058, -0.60665695, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.71374, 0.76082174, 0.22841553, 0.060971317, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 3.8242646, 2.2079402, 0.89214257, 0.0, -2.4630604, 6.7873964, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 3.2249031, -7.6337846, -4.0476228, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.502208, 1.7964274, 0.72192923, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, -1.4659398, 1.128481, 1.9948914, 0.0, 1.1015141, -5.2035702, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, 0.0, 6.4115313, -6.2499411, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.465195, 3.0440762, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.70530063, 0.40720551, 2.5338524, 0.0, 0.0, 3.477179, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, 0.0, 8.6740509, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.204849, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 0.0, 2.5390823, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0990195, 0.0, -4.6547467, -3.2914029, 0.0, 0.0, 0.0, 13.490738, 1.8358568, 1.2981468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.5327043, -3.0594117, -0.4163332, -0.29439203, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.832697, 0.35505015, 0.30748245, 0.041843061, 0.029587512, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6598552, 0.0, 5.0990195, -2.060315, 0.0, 0.0, 0.0, -1.2315302, 9.0498619, 3.047247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.8698837, -3.8168923, -5.3968303, -1.3667446, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.002649, 0.89821372, 0.96257231, 0.22225026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9738086, 0.0, -0.81441102, 5.7587555, 0.0, 0.0, 0.0, 1.3768926, -2.8908723, 1.7034629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0144141, -3.4721895, -5.1937108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.331494, 1.6911535, 1.708323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.0301575, 0.0, 0.94040084, -2.9258408, 0.0, 0.0, 0.0, 0.0, 4.6362387, -3.8028463, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.565401, -1.6355947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.273132, 2.6301353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.0, 0.0, 4.3978195, 0.0, 0.0, 0.0, 0.0, 0.0, 8.672617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.019117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.871701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 1.3093073, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 9.0711474, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.63245553, 4.3817805, -0.77459667, 0.0, 3.1423376, -0.1069045, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 0.54772256, 1.5811388, 2.4596748, 0.0, 9.0711474, 1.8516402, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, -6.2609903, 0.0, 3.8340579, 0.0, 0.0, 10.583005, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0392305, 0.0, 3.1622777, -0.4472136, 0.0, 0.0, 0.0, 5.891883, -0.53452248, 0.075592895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.4605935, 1.4200939, 0.0, 0.0, 0.0, 9.0711474, 4.9377072, -0.69829725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692, 0.0, -6.2609903, 2.2135944, 0.0, 0.0, 0.0, 0.0, 10.583005, 2.9933259, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157677, 0.0, 0.0, -4.6957428, 0.0, 0.0, 0.0, 0.0, 0.0, 12.699606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 1.2360331, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 11.055416, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, 0.4045868, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 2.8252185, -0.050973145, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 0.36187343, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 11.055416, 1.5957118, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, -8.4615728, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 12.437343, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 0.3350297, 4.0620192, -0.82065181, 0.0, 1.6992645, -0.099103121, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 4.9441323, -0.21408721, 0.01248582, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, 0.29965967, 2.0761031, 1.4680266, 0.0, 0.86849624, 0.70912421, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 11.055416, 3.8297084, -0.22335313, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 0.25951289, 0.74914918, 2.754588, 0.0, -8.4615728, 1.1514742, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 12.437343, 2.1760817, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 7.6280899, 0.0, 3.1141546, 0.0, 0.0, -7.521398, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634884, 0.0, 2.6802376, -0.47380354, 0.0, 0.0, 0.0, 5.0977936, -0.79282497, 0.14015298, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.9106117, -0.64226163, 0.099886557, -0.017657615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.76594169, 0.0, 1.4982984, 0.84756554, 0.0, 0.0, 0.0, 1.6284304, 3.545621, -0.81481812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.055416, 7.1807033, -1.1167657, 0.19741814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66332496, 0.0, 0.69203437, 1.5903621, 0.0, 0.0, 0.0, -8.4615728, 3.0705979, 1.1941823, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.437343, 5.8028846, -1.0258148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.54160256, 0.0, 7.6280899, 1.797958, 0.0, 0.0, 0.0, 0.0, -7.521398, 3.1910589, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 3.350297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.3615918, 0.0, 0.0, 8.8994382, 0.0, 0.0, 0.0, 0.0, 0.0, -5.2649786, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583124, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 1.1908744, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 13.045375, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, 0.29439203, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 2.6463875, -0.029587512, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 0.26874192, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 13.045375, 1.4585173, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, -10.576284, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 14.349913, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 0.16060402, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, 1.1355121, -0.036421568, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 4.465779, -0.11412326, 0.0036605053, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, 0.14661074, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 0.61426726, 0.45439194, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 13.045375, 3.3337538, -0.1069302, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.13113263, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, -10.576284, 0.76327753, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 14.349913, 1.8410947, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 9.6529562, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, -9.915266, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.19948914, 3.6856035, -0.81441102, 0.0, 1.0278657, -0.078679579, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, 3.0280323, -0.23309803, 0.017842851, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.8049965, -0.3043287, 0.023427234, -0.001793274, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.18210784, 2.2079402, 0.89214257, 0.0, 0.61576511, 0.32320935, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 1.0749677, 1.9084461, -0.19274394, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 5.8340692, -0.44910686, 0.034377583, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, 0.1628822, 1.128481, 1.9948914, 0.0, 0.31471832, 0.57817447, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, -10.576284, 1.8318661, 0.6944379, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 4.4186272, -0.33823069, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.14106013, 0.40720551, 2.5338524, 0.0, 9.6529562, 0.6954358, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, -9.915266, 1.7348102, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 2.4409698, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, -7.9470826, 0.0, 2.5390823, 0.0, 0.0, 10.220777, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 2.3273733, -0.47020042, 0.0, 0.0, 0.0, 4.4969125, -0.91792842, 0.18544955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654087, -1.0198039, 0.2081666, -0.042056004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9239533, -0.71010029, 0.10249415, -0.02092153, 0.0042267875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66496381, 0.0, 1.4568627, 0.51507875, 0.0, 0.0, 0.0, 1.8472953, 2.5856748, -0.76181175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.7199483, 5.7253384, -1.5419515, 0.34168616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 9.3345107, -1.3473206, 0.27502066, -0.055562564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.59476171, 0.0, 0.81441102, 1.1517511, 0.0, 0.0, 0.0, 0.59009684, 2.8908723, 0.34069257, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -10.576284, 3.4347489, 3.4721895, -1.0387422, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 8.2849261, -1.6911535, 0.34166459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875, 0.0, 0.37616034, 1.4629204, 0.0, 0.0, 0.0, 9.6529562, 1.8544955, 1.9014232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.915266, 4.6261605, 0.81779736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 6.5092527, -1.3150676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.42056004, 0.0, -7.9470826, 1.4659398, 0.0, 0.0, 0.0, 0.0, 10.220777, 2.8908723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 4.0063725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 3.6239003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.5423789, 0.0, 0.0, -6.9105066, 0.0, 0.0, 0.0, 0.0, 0.0, 12.264933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -5.6658663, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20.499876, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.062857143 + 1.8857143*Z) - 0.82285714*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.77777778 + 2.3333333*Z) - 0.55555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.42857143 + 2.1428571*Z) - 0.71428571*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.73333333 + 2.4444444*Z) - 0.71111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442, 0.0, 0.037471875, -0.028961418, 0.0, 0.0, 0.0, 0.028413788, 0.0051555024, -0.0061973341, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.031565657, -0.011390275, 0.0026571774, -0.00018789081, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.023223926, -0.0016617689, -0.0064761033, 0.0064627642, -0.0029080955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.021362905, -0.027792819, 0.024370153, -0.015721993, 0.0060796791};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4990908, 0.0, -3.3466401, -2.3664319, 15.491933, 0.0, 0.0, 0.69282032, 0.56568542, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.8989795, 0.0, 0.0, 0.0, 14.198591, -0.82807867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.2426407, 0.0, 0.0, 0.0, 0.0, 14.342743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.7635609, -1.5491933, 0.0, 0.0, 0.0, 9.5247047, -1.4813122, 0.26186147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1176915, 0.0, 3.1622777, 4.9193496, 0.0, 0.0, 0.0, 0.0, 10.69045, -2.4189726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5455844, 0.0, 0.0, 7.6681158, 0.0, 0.0, 0.0, 0.0, 0.0, 10.369185, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.605769, 0.0, 0.0, 0.0, -4.2045893, -3.4330328, 0.0, 0.0, 0.0, 19.621417, 0.0, 0.0, 0.61167774, 0.52972846, 0.43252148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5313721, 0.0, 3.545621, -2.5071327, 4.7871355, 0.0, 0.0, -5.5662675, -1.0488088, 0.74161985, 0.0, 18.803495, -0.60312239, 0.0, 0.0, 0.0, 1.6818357, 0.70128378, 0.13213749, -0.093435318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0529824, 0.0, -1.5856499, 4.4848953, 4.2817442, 0.0, 0.0, 0.19148542, -3.7523326, -4.3116122, 0.0, 0.0, 18.880717, 0.0, 0.0, 0.0, 0.0, 0.84437134, 1.1818737, 1.0446386, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.5951289, 0.0, 0.0, 0.0, 10.028531, -0.76764947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.413036, -1.2634761, 0.096714743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.3211538, 0.0, 0.0, 0.0, 3.9242834, 5.4928525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.304463, -1.7300859, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.0101782, 0.0, 0.0, 0.0, 0.0, 8.9192809, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.855856, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9664794, 0.0, 8.1240384, -1.6413036, 0.0, 0.0, 0.0, 11.77285, -2.403123, 0.48550416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.276186, -1.4832397, 0.30276504, -0.061167774, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6532998, 0.0, 4.1522062, 2.9360532, 0.0, 0.0, 0.0, 2.6324893, 9.8259133, -2.8226128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.608187, -3.0948718, 0.68387651, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2978251, 0.0, 1.4982984, 5.509176, 0.0, 0.0, 0.0, 0.0, 6.6480395, 4.1367689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.563614, -3.5535266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8761663, 0.0, 0.0, 6.2283093, 0.0, 0.0, 0.0, 0.0, 0.0, 11.054152, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.605769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.831867, 0.0, -4.4108709, -3.1189567, 16.674998, 0.0, 0.0, 2.1306531, 1.739671, 1.2301331, 0.0, -4.3665394, -3.7815341, 0.0, 0.0, 0.0, -0.55793594, -0.4831867, -0.39452029, -0.27896797, 23.698101, 0.0, 0.0, 0.49065338, 0.43885373, 0.38005848, 0.0, 0.0, 0.0, 0.0, 0.062693389, 0.056074672, 0.048562091, 0.039650781, 0.028037336, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.9105066, 0.0, 0.0, 0.0, 10.570624, -2.7255406, 0.0, 0.0, 0.0, 4.6733286, 0.0, 0.0, -7.8670587, -2.3971922, 0.6180945, 0.0, 0.0, 0.0, 0.0, 0.0, 23.105555, -0.46968719, 0.0, 0.0, 0.0, 1.6206575, 0.79066915, 0.24092688, -0.062120835, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.3084006, 0.0, 0.0, 0.0, -1.5236235, 11.1963, 0.0, 0.0, 0.0, 4.2661458, 0.0, 0.0, 0.13299276, -4.7221795, -6.676846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.153244, 0.0, 0.0, 0.0, 0.0, 0.72177888, 1.1112513, 1.1908744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8544964, 0.0, 5.9817182, -2.4880668, 1.9002924, 0.0, 0.0, -0.33993463, -2.3592215, 0.98130676, 0.0, 9.952267, -0.4309458, 0.0, 0.0, 0.0, -6.4536442, 0.077089929, 0.53502114, -0.22253946, 0.0, 0.0, 0.0, 21.52733, -1.0002405, 0.043311683, 0.0, 0.0, 0.0, 0.0, 2.7506613, 0.64861565, -0.0077478294, -0.053771648, 0.022366057, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.5186578, 0.0, 1.9272482, 2.7255406, 1.7347217, 0.0, 0.0, -2.0170569, 3.4205263, -4.0311289, 0.0, 4.0883109, 5.3764379, 0.0, 0.0, 0.0, 0.36566964, -6.2514819, -2.0398101, 1.8080332, 0.0, 0.0, 0.0, 0.0, 22.188098, -1.2652152, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9845638, 1.4711358, 0.36381814, -0.29400945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1471832, 0.0, -0.86189161, 6.094494, 1.5515822, 0.0, 0.0, 0.069388867, -3.0594117, 1.8027756, 0.0, 0.0, 9.0312216, 0.0, 0.0, 0.0, 0.0, 0.40388851, -3.6746199, -5.4965068, 0.0, 0.0, 0.0, 0.0, 0.0, 21.784126, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573, 1.7897486, 1.8079191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.5452363, 0.0, 0.0, 0.0, 6.7177802, -0.6094494, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.659398, -1.5234494, 0.13821013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501, -1.473325, 0.15311242, -0.013890641, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.4106013, 0.0, 0.0, 0.0, 3.6340541, 2.5035689, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.5685703, 11.263055, -1.4929881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.36736, -2.650489, 0.26628761, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.2616801, 0.0, 0.0, 0.0, 1.4220486, 4.4785202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.2772513, 5.3790928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.965481, -2.6199237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.092647, 0.0, 0.0, 0.0, 0.0, 5.3868225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.437782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.90767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5233602, 0.0, 7.3712071, -1.628822, 0.0, 0.0, 0.0, 12.017131, -2.9072433, 0.64241607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882, -2.7252291, 0.6593008, -0.14568627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.804383, -1.405634, 0.27389583, -0.066262224, 0.014642021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3035022, 0.0, 4.4158804, 1.7842851, 0.0, 0.0, 0.0, 4.2661458, 7.8374103, -2.6389933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2342784, 13.222103, -4.6737922, 1.1836356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.125885, -3.1115036, 0.83361207, -0.19247437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.060315, 0.0, 2.256962, 3.9897829, 0.0, 0.0, 0.0, 0.9539392, 8.0114204, 1.1801937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.552549, 9.6224137, -3.5983084, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.393252, -4.6866619, 1.1835609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7842851, 0.0, 0.81441102, 5.0677049, 0.0, 0.0, 0.0, 0.0, 4.0151005, 6.5867231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.015931, 2.8329331, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.092945, -4.5555279, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4568627, 0.0, 0.0, 5.0781645, 0.0, 0.0, 0.0, 0.0, 0.0, 10.014276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.878481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.553559, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 9.1651514, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 0.0, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.6920998, 4.3817805, -0.77459667, 0.0, 10.998182, 0.96214047, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 2.7386128, 1.5811388, 2.4596748, 0.0, 0.0, 9.258201, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, 0.0, 0.0, 3.8340579, 0.0, 0.0, 0.0, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1961524, 0.0, -3.1622777, -2.236068, 0.0, 0.0, 0.0, 13.747727, 0.53452248, 0.37796447, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837, -2.8401878, 0.0, 0.0, 0.0, 0.0, 12.344268, 1.3965945, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2045408, 0.0, 0.0, 6.6407831, 0.0, 0.0, 0.0, 0.0, 0.0, 8.9799777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 11.124298, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 0.0, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, -8.0917359, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 12.713483, 1.0194629, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 2.533114, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 0.0, 11.169983, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, 0.0, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 0.0, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 7.0356236, 4.0620192, -0.82065181, 0.0, -6.7970582, -2.0811655, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 14.832397, 0.85634884, 0.26220221, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, -2.696937, 2.0761031, 1.4680266, 0.0, 3.0397368, -6.3821179, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 0.0, 13.40398, 2.0101782, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 1.2975644, 0.74914918, 2.754588, 0.0, 0.0, 5.7573711, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 0.0, 10.880409, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 0.0, 0.0, 3.1141546, 0.0, 0.0, 0.0, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253954, 0.0, 9.3808315, 1.8952142, 0.0, 0.0, 0.0, -3.3985291, -2.7748874, -0.56061191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.798876, 0.42817442, 0.34960295, 0.070630462, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.8297084, 0.0, -1.4982984, 4.2378277, 0.0, 0.0, 0.0, 3.799671, -3.545621, -4.0740906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.754974, 1.1167657, 0.98709071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.3266499, 0.0, 1.7300859, -3.1807243, 0.0, 0.0, 0.0, 0.0, 7.6764947, -2.3883647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.507211, 2.0516295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.6248077, 0.0, 0.0, 5.3938741, 0.0, 0.0, 0.0, 0.0, 0.0, 9.5731768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.050891, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 13.099618, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 0.0, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, -10.303721, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 14.555131, 1.0355629, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 2.4186773, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 0.0, 13.126656, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, 0.0, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 0.0, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 9.1544291, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, -9.4626009, -2.0760294, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 16.374523, 0.95102718, 0.2086488, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, -2.9322148, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 2.7642027, -9.0878388, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 0.0, 15.001892, 2.1386041, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.91792842, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, 0.0, 5.3429427, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 0.0, 12.887663, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 0.0, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, 0.0, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, -6.7826309, 3.6856035, -0.81441102, 0.0, 10.021691, 2.6751057, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, -7.5700807, -2.2727058, -0.60665695, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.71374, 0.76082174, 0.22841553, 0.060971317, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 3.8242646, 2.2079402, 0.89214257, 0.0, -2.4630604, 6.7873964, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 3.2249031, -7.6337846, -4.0476228, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.502208, 1.7964274, 0.72192923, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, -1.4659398, 1.128481, 1.9948914, 0.0, 1.1015141, -5.2035702, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, 0.0, 6.4115313, -6.2499411, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.465195, 3.0440762, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.70530063, 0.40720551, 2.5338524, 0.0, 0.0, 3.477179, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, 0.0, 8.6740509, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.204849, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 0.0, 2.5390823, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0990195, 0.0, -4.6547467, -3.2914029, 0.0, 0.0, 0.0, 13.490738, 1.8358568, 1.2981468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.5327043, -3.0594117, -0.4163332, -0.29439203, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.832697, 0.35505015, 0.30748245, 0.041843061, 0.029587512, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6598552, 0.0, 5.0990195, -2.060315, 0.0, 0.0, 0.0, -1.2315302, 9.0498619, 3.047247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.8698837, -3.8168923, -5.3968303, -1.3667446, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.002649, 0.89821372, 0.96257231, 0.22225026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9738086, 0.0, -0.81441102, 5.7587555, 0.0, 0.0, 0.0, 1.3768926, -2.8908723, 1.7034629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0144141, -3.4721895, -5.1937108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.331494, 1.6911535, 1.708323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.0301575, 0.0, 0.94040084, -2.9258408, 0.0, 0.0, 0.0, 0.0, 4.6362387, -3.8028463, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.565401, -1.6355947, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.273132, 2.6301353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.0, 0.0, 4.3978195, 0.0, 0.0, 0.0, 0.0, 0.0, 8.672617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.019117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.871701, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454, 5.7965507, -1.6733201, -1.183216, 7.7459667, -1.2, -0.9797959, 0.34641016, 0.28284271, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379, 2.4494897, 2.8284271, -1.0, 1.3093073, 7.0992957, -0.41403934, -2.0493902, -0.47809144, 0.16903085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124612, 2.1213203, -0.40824829, 3.1754265, 9.0711474, 0.0, 7.1713717, 0.0, -1.3801311, -1.5614401, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.63245553, 4.3817805, -0.77459667, 0.0, 3.1423376, -0.1069045, 4.7623524, -0.74065608, 0.13093073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5588457, 0.54772256, 1.5811388, 2.4596748, 0.0, 9.0711474, 1.8516402, 0.0, 5.3452248, -1.2094863, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2727922, -6.2609903, 0.0, 3.8340579, 0.0, 0.0, 10.583005, 0.0, 0.0, 5.1845926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0392305, 0.0, 3.1622777, -0.4472136, 0.0, 0.0, 0.0, 5.891883, -0.53452248, 0.075592895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.9, 0.0, 1.4605935, 1.4200939, 0.0, 0.0, 0.0, 9.0711474, 4.9377072, -0.69829725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692, 0.0, -6.2609903, 2.2135944, 0.0, 0.0, 0.0, 0.0, 10.583005, 2.9933259, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.7157677, 0.0, 0.0, -4.6957428, 0.0, 0.0, 0.0, 0.0, 0.0, 12.699606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5690465, 5.8028846, -2.0101782, -1.4214106, 8.1421522, -2.1022947, -1.7165164, 0.72825623, 0.59461873, 0.42045893, 9.8107084, -1.1845089, -1.0258148, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.091751661, -0.074914918, -0.052972846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2656861, 3.0705979, 1.7728105, -1.2535663, 2.3935678, 6.3037687, -0.90829511, -2.7831337, -0.52440442, 0.37080992, 1.2360331, 9.4017476, -0.30156119, -2.4275208, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.066068747, -0.046717659, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0264912, 2.7464262, -0.79282497, 2.2424476, 2.1408721, -0.33166248, 6.4992307, 0.095742711, -1.8761663, -2.1558061, 11.055416, 0.0, 9.4403586, 0.0, -1.4624941, -2.0470653, 0.0, 0.42218567, 0.59093684, 0.52231931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9148542, 1.2975644, 3.7457459, -1.0594569, 0.4045868, 5.0142654, -0.38382474, 1.8093672, -1.1080066, 0.31339159, 0.0, 2.8252185, -0.050973145, 8.2065181, -0.63173806, 0.048357371, -2.8428212, -0.22795884, 0.13959571, -0.039483628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7126977, 1.1605769, 1.3401188, 1.8952142, 0.36187343, 1.9621417, 2.7464262, -0.56642152, 3.1712999, -1.8219887, 0.0, 11.055416, 1.5957118, 0.0, 8.6522316, -0.86504296, 0.0, -2.4976841, -0.99886557, 0.44144039, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 1.0050891, -0.19342949, 3.5561578, -8.4615728, 0.0, 4.4596404, 0.0, -0.8582582, 2.6702729, 0.0, 0.0, 12.437343, 0.0, 0.0, 8.4279282, 0.0, 0.0, -1.6219555, -2.2937915, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4832397, 0.3350297, 4.0620192, -0.82065181, 0.0, 1.6992645, -0.099103121, 5.8864251, -1.2015615, 0.24275208, 0.0, 0.0, 0.0, 4.9441323, -0.21408721, 0.01248582, 5.138093, -0.74161985, 0.15138252, -0.030583887, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3266499, 0.29965967, 2.0761031, 1.4680266, 0.0, 0.86849624, 0.70912421, 1.3162447, 4.9129566, -1.4113064, 0.0, 0.0, 0.0, 11.055416, 3.8297084, -0.22335313, 0.0, 5.8040934, -1.5474359, 0.34193825, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125, 0.25951289, 0.74914918, 2.754588, 0.0, -8.4615728, 1.1514742, 0.0, 3.3240197, 2.0683845, 0.0, 0.0, 0.0, 0.0, 12.437343, 2.1760817, 0.0, 0.0, 6.2818068, -1.7767633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315, 7.6280899, 0.0, 3.1141546, 0.0, 0.0, -7.521398, 0.0, 0.0, 5.5270762, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 0.0, 0.0, 0.0, 5.8028846, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.85634884, 0.0, 2.6802376, -0.47380354, 0.0, 0.0, 0.0, 5.0977936, -0.79282497, 0.14015298, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.9106117, -0.64226163, 0.099886557, -0.017657615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.76594169, 0.0, 1.4982984, 0.84756554, 0.0, 0.0, 0.0, 1.6284304, 3.545621, -0.81481812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.055416, 7.1807033, -1.1167657, 0.19741814, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66332496, 0.0, 0.69203437, 1.5903621, 0.0, 0.0, 0.0, -8.4615728, 3.0705979, 1.1941823, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.437343, 5.8028846, -1.0258148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.54160256, 0.0, 7.6280899, 1.797958, 0.0, 0.0, 0.0, 0.0, -7.521398, 3.1910589, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.214106, 3.350297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.3615918, 0.0, 0.0, 8.8994382, 0.0, 0.0, 0.0, 0.0, 0.0, -5.2649786, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.583124, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4159335, 5.7298894, -2.2054355, -1.5594784, 8.337499, -2.7677995, -2.2598989, 1.0653265, 0.86983548, 0.61506656, 10.333118, -2.1832697, -1.890767, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.849051, -1.1610978, -1.0385175, 0.24532669, 0.21942686, 0.19002924, -0.081441102, -0.072843136, -0.063084006, -0.051507875, 0.031346695, 0.028037336, 0.024281045, 0.01982539, 0.014018668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.1852941, 3.4552533, 0.99744572, -1.4106013, 3.2320935, 5.2853121, -1.3627703, -2.8908723, -0.3933979, 0.55634864, 2.3366643, 9.0278481, -0.73296992, -3.9335293, -1.1985961, 0.30904725, 1.6401842, 0.65558822, 0.089214257, -0.12616801, 1.1908744, 11.552777, -0.2348436, -2.4409698, -0.90733287, 0.073666248, 0.81032873, 0.39533457, 0.12046344, -0.031060418, -0.31189567, -0.16484471, -0.065889096, -0.0089663702, 0.012680362, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9948914, 3.1542003, -1.092647, 1.5452363, 2.9504842, -0.76181175, 5.5981502, 0.26389933, -1.9392561, -2.2854353, 2.1330729, -0.25753938, 9.1444614, 0.066496381, -2.3610898, -3.338423, -0.023035022, 0.81790549, 1.1564636, 1.0250585, 13.045375, 0.0, 11.576622, 0.0, -1.3977188, -2.1519288, 0.0, 0.36088944, 0.55562564, 0.5954372, 0.0, -0.12501577, -0.19247437, -0.2062655, -0.16668769, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482, 1.8283482, 2.9908591, -1.2440334, 0.95014619, 5.7406446, -0.72111026, -0.16996732, -1.1796107, 0.49065338, 0.29439203, 4.9761335, -0.2154729, 5.7817447, -1.3018558, 0.16353243, -3.2268221, 0.038544964, 0.26751057, -0.11126973, 0.0, 2.6463875, -0.029587512, 10.763665, -0.50012024, 0.021655841, -3.5732138, -0.5810872, 0.13084143, -0.016435628, 1.3753306, 0.32430782, -0.0038739147, -0.026885824, 0.011183028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7593289, 1.6690459, 0.96362411, 1.3627703, 0.86736083, 2.2843064, 2.9622626, -1.0085284, 1.7102631, -2.0155644, 0.26874192, 2.0441554, 2.688219, -0.52779866, 7.0797705, -1.7665274, 0.18283482, -3.125741, -1.0199051, 0.90401661, 0.0, 13.045375, 1.4585173, 0.0, 11.094049, -0.63260762, 0.0, -2.8644711, -1.6660536, 0.31507575, 0.0, 0.9922819, 0.73556789, 0.18190907, -0.14700473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735916, 1.4928401, -0.4309458, 3.047247, 0.77579111, -0.12018504, 5.2990565, 0.034694433, -1.5297059, 0.90138782, -10.576284, 0.0, 4.5156108, 0.0, -0.69955541, 6.3646284, 0.0, 0.20194425, -1.83731, -2.7482534, 0.0, 0.0, 14.349913, 0.0, 0.0, 10.892063, 0.0, 0.0, -1.6873911, -3.0999355, 0.0, 0.0, 0.48710787, 0.89487429, 0.90395954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.628822, 0.77261813, 3.8659511, -1.0514001, 0.16060402, 3.3588901, -0.3047247, 3.8785122, -1.5247517, 0.41467779, 0.0, 1.1355121, -0.036421568, 7.3296992, -0.76172468, 0.069105066, 0.5642405, -0.8795639, 0.34578118, -0.094040084, 0.0, 0.0, 0.0, 4.465779, -0.11412326, 0.0036605053, 9.0597506, -0.73666248, 0.076556211, -0.0069453205, -3.4870996, -0.056708304, 0.088399498, -0.034752316, 0.0094513841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.4869043, 0.70530063, 2.0360275, 1.1517511, 0.14661074, 1.8170271, 1.2517844, 0.65566316, 3.6135904, -1.7034629, 0.0, 0.61426726, 0.45439194, 1.7842851, 5.6315277, -0.74649407, -0.6180945, 2.0321025, -2.1549428, 0.76403348, 0.0, 0.0, 0.0, 13.045375, 3.3337538, -0.1069302, 0.0, 9.6836798, -1.3252445, 0.1331438, 0.0, -3.3545251, -0.47820641, 0.38435306, -0.12424167, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3299276, 0.63084006, 0.72843136, 2.5753938, 0.13113263, 0.7110243, 2.2392601, -0.20525504, 2.5856748, 0.76181175, 0.0, -10.576284, 0.76327753, 0.0, 4.1386256, 2.6895464, 0.0, -1.1947183, 3.1056207, -2.3226981, 0.0, 0.0, 0.0, 0.0, 14.349913, 1.8410947, 0.0, 0.0, 9.9827407, -1.3099618, 0.0, 0.0, -2.881769, -1.5126136, 0.76398525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.54632352, -0.10514001, 3.2711894, 9.6529562, 0.0, 2.6934113, 0.0, -0.51834724, 4.2517115, 0.0, 0.0, -9.915266, 0.0, 0.0, 6.7188909, 0.0, 0.0, -1.2930512, 1.8286505, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 0.0, 0.0, 0.0, 9.4538352, 0.0, 0.0, 0.0, -1.8193914, -2.9405806, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2616801, 0.19948914, 3.6856035, -0.81441102, 0.0, 1.0278657, -0.078679579, 6.0085653, -1.4536216, 0.32120804, 0.0, 0.0, 0.0, 3.0280323, -0.23309803, 0.017842851, 6.992941, -1.3626145, 0.3296504, -0.072843136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.8049965, -0.3043287, 0.023427234, -0.001793274, 5.4021915, -0.70281702, 0.13694791, -0.033131112, 0.0073210106, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511, 0.18210784, 2.2079402, 0.89214257, 0.0, 0.61576511, 0.32320935, 2.1330729, 3.9187051, -1.3194967, 0.0, 0.0, 0.0, 1.0749677, 1.9084461, -0.19274394, 1.1171392, 6.6110514, -2.3368961, 0.59181779, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 5.8340692, -0.44910686, 0.034377583, 0.0, 6.0629426, -1.5557518, 0.41680604, -0.096237184, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0301575, 0.1628822, 1.128481, 1.9948914, 0.0, 0.31471832, 0.57817447, 0.4769696, 4.0057102, 0.59009684, 0.0, 0.0, 0.0, -10.576284, 1.8318661, 0.6944379, 0.0, 2.7762745, 4.8112069, -1.7991542, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 4.4186272, -0.33823069, 0.0, 0.0, 6.696626, -2.343331, 0.59178043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.89214257, 0.14106013, 0.40720551, 2.5338524, 0.0, 9.6529562, 0.6954358, 0.0, 2.0075502, 3.2933615, 0.0, 0.0, 0.0, 0.0, -9.915266, 1.7348102, 0.0, 0.0, 5.0079656, 1.4164666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 2.4409698, 0.0, 0.0, 0.0, 7.0464727, -2.277764, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, -7.9470826, 0.0, 2.5390823, 0.0, 0.0, 10.220777, 0.0, 0.0, 5.0071378, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 0.0, 0.0, 0.0, 6.9392407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 0.0, 0.0, 0.0, 0.0, 6.2767794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.72843136, 0.0, 2.3273733, -0.47020042, 0.0, 0.0, 0.0, 4.4969125, -0.91792842, 0.18544955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654087, -1.0198039, 0.2081666, -0.042056004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.9239533, -0.71010029, 0.10249415, -0.02092153, 0.0042267875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.66496381, 0.0, 1.4568627, 0.51507875, 0.0, 0.0, 0.0, 1.8472953, 2.5856748, -0.76181175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.7199483, 5.7253384, -1.5419515, 0.34168616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.045375, 9.3345107, -1.3473206, 0.27502066, -0.055562564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.59476171, 0.0, 0.81441102, 1.1517511, 0.0, 0.0, 0.0, 0.59009684, 2.8908723, 0.34069257, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -10.576284, 3.4347489, 3.4721895, -1.0387422, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.349913, 8.2849261, -1.6911535, 0.34166459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.51507875, 0.0, 0.37616034, 1.4629204, 0.0, 0.0, 0.0, 9.6529562, 1.8544955, 1.9014232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.915266, 4.6261605, 0.81779736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.944348, 6.5092527, -1.3150676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.42056004, 0.0, -7.9470826, 1.4659398, 0.0, 0.0, 0.0, 0.0, 10.220777, 2.8908723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -8.4987994, 4.0063725, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.937391, 3.6239003, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.5423789, 0.0, 0.0, -6.9105066, 0.0, 0.0, 0.0, 0.0, 0.0, 12.264933, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -5.6658663, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20.499876, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.6666667*tmp0*basisvalues[4] - 0.66666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.028571429*tmp3)*basisvalues[16] - 0.77142857*tmp4*basisvalues[7];
      basisvalues[50] = (1.8333333*tmp2 + 0.018518519*tmp3)*basisvalues[30] - 0.81481481*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.28571429*tmp3)*basisvalues[13] - 0.71428571*tmp4*basisvalues[5];
      basisvalues[45] = (1.9642857*tmp2 + 0.17857143*tmp3)*basisvalues[26] - 0.78571429*tmp4*basisvalues[13];
      basisvalues[23] = (2.5714286*tmp2 + 1.0204082*tmp3)*basisvalues[11] - 0.55102041*tmp4*basisvalues[4];
      basisvalues[41] = (2.2916667*tmp2 + 0.5787037*tmp3)*basisvalues[23] - 0.71296296*tmp4*basisvalues[11];
      basisvalues[38] = (3.0555556*tmp2 + 1.5123457*tmp3)*basisvalues[21] - 0.54320988*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.15555556 + 1.8666667*Z) - 0.71111111*basisvalues[3];
      basisvalues[34