/* -*- mode: c++; coding: utf-8; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; show-trailing-whitespace: t -*- vim:fenc=utf-8:ft=tcl:et:sw=4:ts=4:sts=4

  This file is part of the Feel library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2006-06-23

  Copyright (C) 2006 EPFL

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file imsimplex.hpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2006-06-23
 */
#ifndef __IMSimplex_H
#define __IMSimplex_H 1

#include <vector>

#include <boost/assign/list_of.hpp>
#include <boost/assign/std/vector.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/io.hpp>

#include <feel/feelcore/feel.hpp>
#include <feel/feelpoly/gauss.hpp>

/*
  1
-0.333333333333333  -0.333333333333333  2.000000000000000
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=1

3
-0.666666666666667  -0.666666666666667  0.666666666666667
-0.666666666666667  0.333333333333333  0.666666666666667
0.333333333333333  -0.666666666666667  0.666666666666667
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=2

4
-0.333333333333333  -0.333333333333333  -1.125000000000000
-0.600000000000000  -0.600000000000000  1.041666666666667
-0.600000000000000  0.200000000000000  1.041666666666667
0.200000000000000  -0.600000000000000  1.041666666666667
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=3

6
-0.108103018168070  -0.108103018168070  0.446763179356022
-0.108103018168070  -0.783793963663860  0.446763179356022
-0.783793963663860  -0.108103018168070  0.446763179356022
-0.816847572980458  -0.816847572980458  0.219903487310644
-0.816847572980458  0.633695145960918  0.219903487310644
0.633695145960918  -0.816847572980458  0.219903487310644
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=4

7
-0.333333333333333  -0.333333333333333  0.450000000000000
-0.059715871789770  -0.059715871789770  0.264788305577012
-0.059715871789770  -0.880568256420460  0.264788305577012
-0.880568256420460  -0.059715871789770  0.264788305577012
-0.797426985353088  -0.797426985353088  0.251878361089654
-0.797426985353088  0.594853970706174  0.251878361089654
0.594853970706174  -0.797426985353088  0.251878361089654
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=5

12
-0.501426509658180  -0.501426509658180  0.233572551452758
-0.501426509658180  0.002853019316358  0.233572551452758
0.002853019316358  -0.501426509658180  0.233572551452758
-0.873821971016996  -0.873821971016996  0.101689812740414
-0.873821971016996  0.747643942033992  0.101689812740414
0.747643942033992  -0.873821971016996  0.101689812740414
-0.379295097932432  0.273004998242798  0.165702151236748
0.273004998242798  -0.893709900310366  0.165702151236748
-0.893709900310366  -0.379295097932432  0.165702151236748
-0.379295097932432  -0.893709900310366  0.165702151236748
0.273004998242798  -0.379295097932432  0.165702151236748
-0.893709900310366  0.273004998242798  0.165702151236748
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=6

13
-0.333333333333333  -0.333333333333333  -0.299140088935364
-0.479308067841920  -0.479308067841920  0.351230514866416
-0.479308067841920  -0.041383864316160  0.351230514866416
-0.041383864316160  -0.479308067841920  0.351230514866416
-0.869739794195568  -0.869739794195568  0.106694471217676
-0.869739794195568  0.739479588391136  0.106694471217676
0.739479588391136  -0.869739794195568  0.106694471217676
-0.374269007990252  0.276888377139620  0.154227521780514
0.276888377139620  -0.902619369149368  0.154227521780514
-0.902619369149368  -0.374269007990252  0.154227521780514
-0.374269007990252  -0.902619369149368  0.154227521780514
0.276888377139620  -0.374269007990252  0.154227521780514
-0.902619369149368  0.276888377139620  0.154227521780514
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=7

16
-0.333333333333333  -0.333333333333333  0.288631215355574
-0.081414823414554  -0.081414823414554  0.190183268534570
-0.081414823414554  -0.837170353170892  0.190183268534570
-0.837170353170892  -0.081414823414554  0.190183268534570
-0.658861384496480  -0.658861384496480  0.206434741069436
-0.658861384496480  0.317722768992960  0.206434741069436
0.317722768992960  -0.658861384496480  0.206434741069436
-0.898905543365938  -0.898905543365938  0.064916995246396
-0.898905543365938  0.797811086731876  0.064916995246395
0.797811086731876  -0.898905543365938  0.064916995246396
-0.473774340730724  0.456984785910808  0.054460628348870
0.456984785910808  -0.983210445180084  0.054460628348870
-0.983210445180084  -0.473774340730724  0.054460628348870
-0.473774340730724  -0.983210445180084  0.054460628348870
0.456984785910808  -0.473774340730724  0.054460628348870
-0.983210445180084  0.456984785910808  0.054460628348870
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=8

19
-0.333333333333333  -0.333333333333333  0.194271592565598
-0.020634961602524  -0.020634961602524  0.062669400454278
-0.020634961602524  -0.958730076794950  0.062669400454278
-0.958730076794950  -0.020634961602524  0.062669400454278
-0.125820817014126  -0.125820817014126  0.155655082009548
-0.125820817014126  -0.748358365971746  0.155655082009548
-0.748358365971746  -0.125820817014126  0.155655082009548
-0.623592928761934  -0.623592928761934  0.159295477854420
-0.623592928761934  0.247185857523870  0.159295477854420
0.247185857523870  -0.623592928761934  0.159295477854420
-0.910540973211094  -0.910540973211094  0.051155351317396
-0.910540973211094  0.821081946422190  0.051155351317396
0.821081946422190  -0.910540973211094  0.051155351317396
-0.556074021678468  0.482397197568996  0.086567078754578
0.482397197568996  -0.926323175890528  0.086567078754578
-0.926323175890528  -0.556074021678468  0.086567078754578
-0.556074021678468  -0.926323175890528  0.086567078754578
0.482397197568996  -0.556074021678468  0.086567078754578
-0.926323175890528  0.482397197568996  0.086567078754578
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=9

25
-0.333333333333333  -0.333333333333333  0.181635980765508
-0.028844733232686  -0.028844733232686  0.073451915512934
-0.028844733232686  -0.942310533534630  0.073451915512934
-0.942310533534630  -0.028844733232686  0.073451915512934
-0.781036849029926  -0.781036849029926  0.090642118871056
-0.781036849029926  0.562073698059852  0.090642118871056
0.562073698059852  -0.781036849029926  0.090642118871056
-0.384120322471758  0.100705883641998  0.145515833690840
0.100705883641998  -0.716585561170240  0.145515833690840
-0.716585561170240  -0.384120322471758  0.145515833690840
-0.384120322471758  -0.716585561170240  0.145515833690840
0.100705883641998  -0.384120322471758  0.145515833690840
-0.716585561170240  0.100705883641998  0.145515833690840
-0.506654878720194  0.456647809194822  0.056654485062114
0.456647809194822  -0.949992930474628  0.056654485062114
-0.949992930474628  -0.506654878720194  0.056654485062114
-0.506654878720194  -0.949992930474628  0.056654485062114
0.456647809194822  -0.506654878720194  0.056654485062114
-0.949992930474628  0.456647809194822  0.056654485062114
-0.866393497975600  0.847311867175000  0.018843333927466
0.847311867175000  -0.980918369199402  0.018843333927466
-0.980918369199402  -0.866393497975600  0.018843333927466
-0.866393497975600  -0.980918369199402  0.018843333927466
0.847311867175000  -0.866393497975600  0.018843333927466
-0.980918369199402  0.847311867175000  0.018843333927466
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=10

27
0.069222096541516  0.069222096541516  0.001854012657922
0.069222096541516  -1.138444193083034  0.001854012657922
-1.138444193083034  0.069222096541516  0.001854012657922
-0.202061394068290  -0.202061394068290  0.154299069829626
-0.202061394068290  -0.595877211863420  0.154299069829626
-0.595877211863420  -0.202061394068290  0.154299069829626
-0.593380199137436  -0.593380199137436  0.118645954761548
-0.593380199137436  0.186760398274870  0.118645954761548
0.186760398274870  -0.593380199137436  0.118645954761548
-0.761298175434838  -0.761298175434838  0.072369081006836
-0.761298175434838  0.522596350869674  0.072369081006836
0.522596350869674  -0.761298175434838  0.072369081006836
-0.935270103777448  -0.935270103777448  0.027319462005356
-0.935270103777448  0.870540207554896  0.027319462005356
0.870540207554896  -0.935270103777448  0.027319462005356
-0.286758703477414  0.186402426856426  0.104674223924408
0.186402426856426  -0.899643723379010  0.104674223924408
-0.899643723379010  -0.286758703477414  0.104674223924408
-0.286758703477414  -0.899643723379010  0.104674223924408
0.186402426856426  -0.286758703477414  0.104674223924408
-0.899643723379010  0.186402426856426  0.104674223924408
-0.657022039391916  0.614978006319584  0.041415319278282
0.614978006319584  -0.957955966927668  0.041415319278282
-0.957955966927668  -0.657022039391916  0.041415319278282
-0.657022039391916  -0.957955966927668  0.041415319278282
0.614978006319584  -0.657022039391916  0.041415319278282
-0.957955966927668  0.614978006319584  0.041415319278282
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=11

33
-0.023565220452390  -0.023565220452390  0.051462132880910
-0.023565220452390  -0.952869559095220  0.051462132880910
-0.952869559095220  -0.023565220452390  0.051462132880910
-0.120551215411080  -0.120551215411080  0.087385089076076
-0.120551215411080  -0.758897569177842  0.087385089076076
-0.758897569177842  -0.120551215411080  0.087385089076076
-0.457579229975768  -0.457579229975768  0.125716448435770
-0.457579229975768  -0.084841540048464  0.125716448435770
-0.084841540048464  -0.457579229975768  0.125716448435770
-0.744847708916828  -0.744847708916828  0.069592225861418
-0.744847708916828  0.489695417833656  0.069592225861418
0.489695417833656  -0.744847708916828  0.069592225861418
-0.957365299093580  -0.957365299093580  0.012332522103118
-0.957365299093580  0.914730598187158  0.012332522103118
0.914730598187158  -0.957365299093580  0.012332522103118
-0.448573460628972  0.217886471559576  0.080743115532762
0.217886471559576  -0.769313010930604  0.080743115532762
-0.769313010930604  -0.448573460628972  0.080743115532762
-0.448573460628972  -0.769313010930604  0.080743115532762
0.217886471559576  -0.448573460628972  0.080743115532762
-0.769313010930604  0.217886471559576  0.080743115532762
-0.437348838020120  0.391672173575606  0.044713546404606
0.391672173575606  -0.954323335555486  0.044713546404606
-0.954323335555486  -0.437348838020120  0.044713546404606
-0.437348838020120  -0.954323335555486  0.044713546404606
0.391672173575606  -0.437348838020120  0.044713546404606
-0.954323335555486  0.391672173575606  0.044713546404606
-0.767496168184806  0.716028067088146  0.034632462217318
0.716028067088146  -0.948531898903340  0.034632462217318
-0.948531898903340  -0.767496168184806  0.034632462217318
-0.767496168184806  -0.948531898903340  0.034632462217318
0.716028067088146  -0.767496168184806  0.034632462217318
-0.948531898903340  0.716028067088146  0.034632462217318
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=12

37
-0.333333333333333  -0.333333333333333  0.105041846801604
-0.009903630120590  -0.009903630120590  0.022560290418660
-0.009903630120590  -0.980192739758818  0.022560290418660
-0.980192739758818  -0.009903630120590  0.022560290418660
-0.062566729780852  -0.062566729780852  0.062847036724908
-0.062566729780852  -0.874866540438296  0.062847036724908
-0.874866540438296  -0.062566729780852  0.062847036724908
-0.170957326397446  -0.170957326397446  0.094145005008388
-0.170957326397446  -0.658085347205106  0.094145005008388
-0.658085347205106  -0.170957326397446  0.094145005008388
-0.541200855914338  -0.541200855914338  0.094727173072710
-0.541200855914338  0.082401711828674  0.094727173072710
0.082401711828674  -0.541200855914338  0.094727173072710
-0.771151009607340  -0.771151009607340  0.062335058091588
-0.771151009607340  0.542302019214680  0.062335058091588
0.542302019214680  -0.771151009607340  0.062335058091588
-0.950377217273082  -0.950377217273082  0.015951542930148
-0.950377217273082  0.900754434546164  0.015951542930148
0.900754434546164  -0.950377217273082  0.015951542930148
-0.462410005882478  0.272702349123320  0.073696805457464
0.272702349123320  -0.810292343240842  0.073696805457464
-0.810292343240842  -0.462410005882478  0.073696805457464
-0.462410005882478  -0.810292343240842  0.073696805457464
0.272702349123320  -0.462410005882478  0.073696805457464
-0.810292343240842  0.272702349123320  0.073696805457464
-0.416539866531424  0.380338319973810  0.034802926607644
0.380338319973810  -0.963798453442386  0.034802926607644
-0.963798453442386  -0.416539866531424  0.034802926607644
-0.416539866531424  -0.963798453442386  0.034802926607644
0.380338319973810  -0.416539866531424  0.034802926607644
-0.963798453442386  0.380338319973810  0.034802926607644
-0.747285229016662  0.702819075668482  0.031043573678090
0.702819075668482  -0.955533846651820  0.031043573678090
-0.955533846651820  -0.747285229016662  0.031043573678090
-0.747285229016662  -0.955533846651820  0.031043573678090
0.702819075668482  -0.747285229016662  0.031043573678090
-0.955533846651820  0.702819075668482  0.031043573678090
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=13

42
-0.022072179275642  -0.022072179275642  0.043767162738858
-0.022072179275642  -0.955855641448714  0.043767162738858
-0.955855641448714  -0.022072179275642  0.043767162738858
-0.164710561319092  -0.164710561319092  0.065576707088250
-0.164710561319092  -0.670578877361816  0.065576707088250
-0.670578877361816  -0.164710561319092  0.065576707088250
-0.453044943382322  -0.453044943382322  0.103548209014584
-0.453044943382322  -0.093910113235354  0.103548209014584
-0.093910113235354  -0.453044943382322  0.103548209014584
-0.645588935174914  -0.645588935174914  0.084325177473986
-0.645588935174914  0.291177870349826  0.084325177473986
0.291177870349826  -0.645588935174914  0.084325177473986
-0.876400233818254  -0.876400233818254  0.028867399339554
-0.876400233818254  0.752800467636510  0.028867399339554
0.752800467636510  -0.876400233818254  0.028867399339554
-0.961218077502598  -0.961218077502598  0.009846807204800
-0.961218077502598  0.922436155005196  0.009846807204800
0.9224361550051960  -0.961218077502598  0.009846807204800
-0.655466624357288  0.541217109549992  0.049331506425128
0.541217109549992  -0.885750485192704  0.049331506425128
-0.885750485192704  -0.655466624357288  0.049331506425128
-0.655466624357288  -0.885750485192704  0.049331506425128
0.541217109549992  -0.655466624357288  0.049331506425128
-0.885750485192704  0.541217109549992  0.049331506425128
-0.326277080407310  0.140444581693366  0.077143021574122
0.140444581693366  -0.814167501286056  0.077143021574122
-0.814167501286056  -0.326277080407310  0.077143021574122
-0.326277080407310  -0.814167501286056  0.077143021574122
0.140444581693366  -0.326277080407310  0.077143021574122
-0.814167501286056  0.140444581693366  0.077143021574122
-0.403254235727484  0.373960335616176  0.028872616227068
0.373960335616176  -0.970706099888692  0.028872616227068
-0.970706099888692  -0.403254235727484  0.028872616227068
-0.403254235727484  -0.970706099888692  0.028872616227068
0.373960335616176  -0.403254235727484  0.028872616227068
-0.970706099888692  0.373960335616176  0.028872616227068
-0.762051004606086  0.759514342740342  0.010020457677002
0.759514342740342  -0.997463338134256  0.010020457677002
-0.997463338134256  -0.762051004606086  0.010020457677002
-0.762051004606086  -0.997463338134256  0.010020457677002
0.759514342740342  -0.762051004606086  0.010020457677002
-0.997463338134256  0.759514342740342  0.010020457677002
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=14

48
0.013945833716486  0.013945833716486  0.003833751285698
0.013945833716486  -1.027891667432972  0.003833751285698
-1.027891667432972  0.013945833716486  0.003833751285698
-0.137187291433954  -0.137187291433954  0.088498054542290
-0.137187291433954  -0.725625417132090  0.088498054542290
-0.725625417132090  -0.137187291433954  0.088498054542290
-0.444612710305712  -0.444612710305712  0.102373097437704
-0.444612710305712  -0.110774579388578  0.102373097437704
-0.110774579388578  -0.444612710305712  0.102373097437704
-0.747070217917492  -0.747070217917492  0.047375471741376
-0.747070217917492  0.494140435834984  0.047375471741376
0.494140435834984  -0.747070217917492  0.047375471741376
-0.858383228050628  -0.858383228050628  0.026579551380042
-0.858383228050628  0.716766456101256  0.026579551380042
0.716766456101256  -0.858383228050628  0.026579551380042
-0.962069659517854  -0.962069659517854  0.009497833216384
-0.962069659517854  0.924139319035706  0.009497833216384
0.924139319035706  -0.962069659517854  0.009497833216384
-0.477377257719826  0.209908933786582  0.077100145199186
0.209908933786582  -0.732531676066758  0.077100145199186
-0.732531676066758  -0.477377257719826  0.077100145199186
-0.477377257719826  -0.732531676066758  0.077100145199186
0.209908933786582  -0.477377257719826  0.077100145199186
-0.732531676066758  0.209908933786582  0.077100145199186
-0.223906465819462  0.151173111025628  0.054431628641248
0.151173111025628  -0.927266645206166  0.054431628641248
-0.927266645206166  -0.223906465819462  0.054431628641248
-0.223906465819462  -0.927266645206166  0.054431628641248
0.151173111025628  -0.223906465819462  0.054431628641248
-0.927266645206166  0.151173111025628  0.054431628641248
-0.428575559900168  0.448925326153310  0.004364154733594
0.448925326153310  -1.020349766253142  0.004364154733594
-1.020349766253142  -0.428575559900168  0.004364154733594
-0.428575559900168  -1.020349766253142  0.004364154733594
0.448925326153310  -0.428575559900168  0.004364154733594
-1.020349766253142  0.448925326153310  0.004364154733594
-0.568800671855432  0.495112932103676  0.043010639695462
0.495112932103676  -0.926312260248244  0.043010639695462
-0.926312260248244  -0.568800671855432  0.043010639695462
-0.568800671855432  -0.926312260248244  0.043010639695462
0.495112932103676  -0.568800671855432  0.043010639695462
-0.926312260248244  0.495112932103676  0.043010639695462
-0.792848766847228  0.767929148184832  0.015347885262098
0.767929148184832  -0.975080381337602  0.015347885262098
-0.975080381337602  -0.792848766847228  0.015347885262098
-0.792848766847228  -0.975080381337602  0.015347885262098
0.767929148184832  -0.792848766847228  0.015347885262098
-0.975080381337602  0.767929148184832  0.015347885262098
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=15

52
-0.333333333333333  -0.333333333333333  0.093751394855284
-0.005238916103124  -0.005238916103124  0.012811757157170
-0.005238916103124  -0.989522167793754  0.012811757157170
-0.989522167793754  -0.005238916103124  0.012811757157170
-0.173061122901296  -0.173061122901296  0.083420593478774
-0.173061122901296  -0.653877754197410  0.083420593478774
-0.653877754197410  -0.173061122901296  0.083420593478774
-0.059082801866018  -0.059082801866018  0.053782968500128
-0.059082801866018  -0.881834396267966  0.053782968500128
-0.881834396267966  -0.059082801866018  0.053782968500128
-0.518892500060958  -0.518892500060958  0.084265045523300
-0.518892500060958  0.037785000121916  0.084265045523300
0.037785000121916  -0.518892500060958  0.084265045523300
-0.704068411554854  -0.704068411554854  0.060000533685546
-0.704068411554854  0.408136823109708  0.060000533685546
0.408136823109708  -0.704068411554854  0.060000533685546
-0.849069624685052  -0.849069624685052  0.028400197850048
-0.849069624685052  0.698139249370104  0.028400197850048
0.698139249370104  -0.849069624685052  0.028400197850048
-0.966807194753950  -0.966807194753950  0.007164924702546
-0.966807194753950  0.933614389507900  0.007164924702546
0.933614389507900  -0.966807194753950  0.007164924702546
-0.406888806840226  0.199737422349722  0.065546294921254
0.199737422349722  -0.792848615509496  0.065546294921254
-0.792848615509496  -0.406888806840226  0.065546294921254
-0.406888806840226  -0.792848615509496  0.065546294921254
0.199737422349722  -0.406888806840226  0.065546294921254
-0.792848615509496  0.199737422349722  0.065546294921254
-0.324553873193842  0.284387049883010  0.030596612496882
0.284387049883010  -0.959833176689168  0.030596612496882
-0.959833176689168  -0.324553873193842  0.030596612496882
-0.324553873193842  -0.959833176689168  0.030596612496882
0.284387049883010  -0.324553873193842  0.030596612496882
-0.959833176689168  0.284387049883010  0.030596612496882
-0.590503436714376  0.599185441942654  0.004772488385678
0.599185441942654  -1.008682005228278  0.004772488385678
-1.008682005228278  -0.590503436714376  0.004772488385678
-0.590503436714376  -1.008682005228278  0.004772488385678
0.599185441942654  -0.590503436714376  0.004772488385678
-1.008682005228278  0.599185441942654  0.004772488385678
-0.621283015738754  0.537399442802736  0.038169585511798
0.537399442802736  -0.916116427063980  0.038169585511798
-0.916116427063980  -0.621283015738754  0.038169585511798
-0.621283015738754  -0.916116427063980  0.038169585511798
0.537399442802736  -0.621283015738754  0.038169585511798
-0.916116427063980  0.537399442802736  0.038169585511798
-0.829432768634686  0.800798128173322  0.013700109093084
0.800798128173322  -0.971365359538638  0.013700109093084
-0.971365359538638  -0.829432768634686  0.013700109093084
-0.829432768634686  -0.971365359538638  0.013700109093084
0.800798128173322  -0.829432768634686  0.013700109093084
-0.971365359538638  0.800798128173322  0.013700109093084
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=16

61
-0.333333333333333  -0.333333333333333  0.066874398581606
-0.005658918886452  -0.005658918886452  0.010186830881014
-0.005658918886452  -0.988682162227096  0.010186830881014
-0.988682162227096  -0.005658918886452  0.010186830881014
-0.035647354750750  -0.035647354750750  0.029341729055276
-0.035647354750750  -0.928705290498498  0.029341729055276
-0.928705290498498  -0.035647354750750  0.029341729055276
-0.099520061958436  -0.099520061958436  0.048701756707344
-0.099520061958436  -0.800959876083126  0.048701756707344
-0.800959876083126  -0.099520061958436  0.048701756707344
-0.199467521245206  -0.199467521245206  0.062215101737938
-0.199467521245206  -0.601064957509588  0.062215101737938
-0.601064957509588  -0.199467521245206  0.062215101737938
-0.495717464058094  -0.495717464058094  0.062514222437240
-0.495717464058094  -0.008565071883810  0.062514222437240
-0.008565071883810  -0.495717464058094  0.062514222437240
-0.675905990683078  -0.675905990683078  0.049631308679330
-0.675905990683078  0.351811981366154  0.049631308679330
0.351811981366154  -0.675905990683078  0.049631308679330
-0.848248235478508  -0.848248235478508  0.028112146141114
-0.848248235478508  0.696496470957016  0.028112146141114
0.696496470957016  -0.848248235478508  0.028112146141114
-0.968690546064356  -0.968690546064356  0.006389352347558
-0.968690546064356  0.937381092128712  0.006389352347558
0.937381092128712  -0.968690546064356  0.006389352347558
-0.331360265272684  0.310986407618846  0.016239310637986
0.310986407618846  -0.979626142346162  0.016239310637986
-0.979626142346162  -0.331360265272684  0.016239310637986
-0.331360265272684  -0.979626142346162  0.016239310637986
0.310986407618846  -0.331360265272684  0.016239310637986
-0.979626142346162  0.310986407618846  0.016239310637986
-0.415556924406112  0.144675181064040  0.053611484566326
0.144675181064040  -0.729118256657928  0.053611484566326
-0.729118256657928  -0.415556924406112  0.053611484566326
-0.415556924406112  -0.729118256657928  0.053611484566326
0.144675181064040  -0.415556924406112  0.053611484566326
-0.729118256657928  0.144675181064040  0.053611484566326
-0.360850229153620  0.252002380572456  0.036919986421644
0.252002380572456  -0.891152151418834  0.036919986421644
-0.891152151418834  -0.360850229153620  0.036919986421644
-0.360850229153620  -0.891152151418834  0.036919986421644
0.252002380572456  -0.360850229153620  0.036919986421644
-0.891152151418834  0.252002380572456  0.036919986421644
-0.618591551615416  0.592854429948142  0.016953737068656
0.592854429948142  -0.974262878332726  0.016953737068656
-0.974262878332726  -0.618591551615416  0.016953737068656
-0.618591551615416  -0.974262878332726  0.016953737068656
0.592854429948142  -0.618591551615416  0.016953737068656
-0.974262878332726  0.592854429948142  0.016953737068656
-0.639033576702508  0.504702011875458  0.036585593540050
0.504702011875458  -0.865668435172952  0.036585593540050
-0.865668435172952  -0.639033576702508  0.036585593540050
-0.639033576702508  -0.865668435172952  0.036585593540050
0.504702011875458  -0.639033576702508  0.036585593540050
-0.865668435172952  0.504702011875458  0.036585593540050
-0.838577372640872  0.809251008191216  0.013331264008330
0.809251008191216  -0.970673635550344  0.013331264008330
-0.970673635550344  -0.838577372640872  0.013331264008330
-0.838577372640872  -0.970673635550344  0.013331264008330
0.809251008191216  -0.838577372640872  0.013331264008330
-0.970673635550344  0.809251008191216  0.013331264008330
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=17

70
-0.333333333333333  -0.333333333333333  0.061619879875294
-0.013310382738158  -0.013310382738158  0.018144873358808
-0.013310382738158  -0.973379234523686  0.018144873358808
-0.973379234523686  -0.013310382738158  0.018144873358808
-0.061578811516086  -0.061578811516086  0.037522633879188
-0.061578811516086  -0.876842376967828  0.037522633879188
-0.876842376967828  -0.061578811516086  0.037522633879188
-0.127437208225988  -0.127437208225988  0.038882195970954
-0.127437208225988  -0.745125583548022  0.038882195970954
-0.745125583548022  -0.127437208225988  0.038882195970954
-0.210307658653168  -0.210307658653168  0.055507897221620
-0.210307658653168  -0.579384682693664  0.055507897221620
-0.579384682693664  -0.210307658653168  0.055507897221620
-0.500410862393686  -0.500410862393686  0.064512450702914
-0.500410862393686  0.000821724787372  0.064512450702914
0.000821724787372  -0.500410862393686  0.064512450702914
-0.677135612512314  -0.677135612512314  0.050148065233844
-0.677135612512314  0.354271225024630  0.050148065233844
0.354271225024630  -0.677135612512314  0.050148065233844
-0.846803545029258  -0.846803545029258  0.030543855943664
-0.846803545029258  0.693607090058514  0.030543855943664
0.693607090058514  -0.846803545029258  0.030543855943664
-0.951495121293100  -0.951495121293100  0.013587844045926
-0.951495121293100  0.902990242586200  0.013587844045926
0.902990242586200  -0.951495121293100  0.013587844045926
-0.913707265566070  -0.913707265566070  -0.004446197459840
-0.913707265566070  0.827414531132142  -0.004446197459840
0.827414531132142  -0.913707265566070  -0.004446197459840
-0.282177010118112  0.265315937713272  0.012663828152812
0.265315937713272  -0.983138927595160  0.012663828152812
-0.983138927595160  -0.282177010118112  0.012663828152812
-0.282177010118112  -0.983138927595160  0.012663828152812
0.265315937713272  -0.282177010118112  0.012663828152812
-0.983138927595160  0.265315937713272  0.012663828152812
-0.411195046496086  0.148821943021710  0.054515076098276
0.148821943021710  -0.737626896525624  0.054515076098276
-0.737626896525624  -0.411195046496086  0.054515076098276
-0.411195046496086  -0.737626896525624  0.054515076098276
0.148821943021710  -0.411195046496086  0.054515076098276
-0.737626896525624  0.148821943021710  0.054515076098276
-0.349964396716372  0.249558093585024  0.035353571298930
0.249558093585024  -0.899593696868650  0.035353571298930
-0.899593696868650  -0.349964396716372  0.035353571298930
-0.349964396716372  -0.899593696868650  0.035353571298930
0.249558093585024  -0.349964396716372  0.035353571298930
-0.899593696868650  0.249558093585024  0.035353571298930
-0.630524880667908  0.497866353046074  0.036758969276140
0.497866353046074  -0.867341472378168  0.036758969276140
-0.867341472378168  -0.630524880667908  0.036758969276140
-0.630524880667908  -0.867341472378168  0.036758969276140
0.497866353046074  -0.630524880667908  0.036758969276140
-0.867341472378168  0.497866353046074  0.036758969276140
-0.562406399973358  0.538414010840886  0.016209465616384
0.538414010840886  -0.976007610867528  0.016209465616384
-0.976007610867528  -0.562406399973358  0.016209465616384
-0.562406399973358  -0.976007610867528  0.016209465616384
0.538414010840886  -0.562406399973358  0.016209465616384
-0.976007610867528  0.538414010840886  0.016209465616384
-0.797640805727184  0.767924604546934  0.015268258141450
0.767924604546934  -0.970283798819750  0.015268258141450
-0.970283798819750  -0.797640805727184  0.015268258141450
-0.797640805727184  -0.970283798819750  0.015268258141450
0.767924604546934  -0.797640805727184  0.015268258141450
-0.970283798819750  0.767924604546934  0.015268258141450
-0.958250489434828  1.028694520010726  0.000092375321588
1.028694520010726  -1.070444030575898  0.000092375321588
-1.070444030575898  -0.9582504894348281  0.000092375321588
-0.958250489434828  -1.070444030575898  0.000092375321588
1.028694520010726  -0.958250489434828  0.000092375321588
-1.070444030575898    1.028694520010726  0.000092375321588
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=18

73
-0.333333333333333  -0.333333333333333  0.065812662777838
-0.020780025853988  -0.020780025853988  0.020661463782544
-0.020780025853988  -0.958439948292026  0.020661463782544
-0.958439948292026  -0.020780025853988  0.020661463782544
-0.090926214604214  -0.090926214604214  0.044774494526032
-0.090926214604214  -0.818147570791570  0.044774494526032
-0.818147570791570  -0.090926214604214  0.044774494526032
-0.197166638701138  -0.197166638701138  0.060532251738936
-0.197166638701138  -0.605666722597724  0.060532251738936
-0.605666722597724  -0.197166638701138  0.060532251738936
-0.488896691193804  -0.488896691193804  0.060981935604396
-0.488896691193804  -0.022206617612390  0.060981935604396
-0.022206617612390  -0.488896691193804  0.060981935604396
-0.645844115695740  -0.645844115695740  0.048318425483282
-0.645844115695740  0.291688231391482  0.048318425483282
0.291688231391482  -0.645844115695740  0.048318425483282
-0.779877893544096  -0.779877893544096  0.032101607173602
-0.779877893544096  0.559755787088192  0.032101607173602
0.559755787088192  -0.779877893544096  0.032101607173602
-0.888942751496320  -0.888942751496320  0.016169160523568
-0.888942751496320  0.777885502992642  0.016169160523568
0.777885502992642  -0.888942751496320  0.016169160523568
-0.974756272445542  -0.974756272445542  0.004158724054970
-0.974756272445542  0.949512544891086  0.004158724054970
0.949512544891086  -0.974756272445542  0.004158724054970
-0.208490425286114  0.201267589589290  0.007769753809962
0.201267589589290  -0.992777164303176  0.007769753809962
-0.992777164303176  -0.208490425286114  0.007769753809962
-0.208490425286114  -0.992777164303176  0.007769753809962
0.201267589589290  -0.208490425286114  0.007769753809962
-0.992777164303176  0.201267589589286  0.007769753809962
-0.384140032239128  0.115206523177568  0.051148321224044
0.115206523177568  -0.731066490938440  0.051148321224044
-0.731066490938440  -0.384140032239128  0.051148321224044
-0.384140032239128  -0.731066490938440  0.051148321224044
0.115206523177568  -0.384140032239128  0.051148321224044
-0.731066490938440  0.115206523177568  0.051148321224044
-0.470866103186960  0.441974051634730  0.017761807146676
0.441974051634730  -0.971107948447770  0.017761807146676
-0.971107948447770  -0.470866103186960  0.017761807146676
-0.470866103186960  -0.971107948447770  0.017761807146676
0.441974051634730  -0.470866103186960  0.017761807146676
-0.971107948447770  0.441974051634730  0.017761807146676
-0.282921295588098  0.189054137911742  0.032249093523462
0.189054137911742  -0.906132842323644  0.032249093523462
-0.906132842323644  -0.282921295588098  0.032249093523462
-0.282921295588098  -0.906132842323644  0.032249093523462
0.189054137911742  -0.282921295588098  0.032249093523462
-0.906132842323644  0.189054137911742  0.032249093523462
-0.684385188062810  0.678662947361678  0.004983883634982
0.678662947361678  -0.994277759298866  0.004983883634982
-0.994277759298866  -0.684385188062810  0.004983883634982
-0.684385188062810  -0.994277759298866  0.004983883634982
0.678662947361678  -0.684385188062810  0.004983883634982
-0.994277759298866  0.678662947361678  0.004983883634982
-0.849898806048178  0.402175957852346  0.036485680237902
0.402175957852346  -0.552277151804168  0.036485680237902
-0.552277151804168  -0.849898806048178  0.036485680237902
-0.849898806048178  -0.552277151804168  0.036485680237902
0.402175957852346  -0.849898806048178  0.036485680237902
-0.552277151804168  0.402175957852346  0.036485680237902
-0.715156797773234  0.645862648139714  0.020517127472398
0.645862648139714  -0.930705850366480  0.020517127472398
-0.930705850366480  -0.715156797773234  0.020517127472398
-0.715156797773234  -0.930705850366480  0.020517127472398
0.645862648139714  -0.715156797773234  0.020517127472398
-0.930705850366480  0.645862648139714  0.020517127472398
-0.869010743834124  0.848688505241568  0.007599857710604
0.848688505241568  -0.979677761407444  0.007599857710604
-0.979677761407444  -0.869010743834124  0.007599857710604
-0.869010743834124  -0.979677761407444  0.007599857710604
0.848688505241568  -0.869010743834124  0.007599857710604
-0.979677761407444  0.848688505241568  0.007599857710604
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=19

79
-0.333333333333333  -0.333333333333333  0.066114111083248
0.001900928704400  0.001900928704400  0.001734038371326
0.001900928704400  -1.003801857408800  0.001734038371326
-1.003801857408800  0.001900928704400  0.001734038371326
-0.023574084130543  -0.023574084130543  0.023320105432896
-0.023574084130543  -0.952851831738914  0.023320105432896
-0.952851831738914  -0.023574084130543  0.023320105432896
-0.089726626099435  -0.089726626099435  0.045753872712842
-0.089726626099435  -0.820546727801130  0.045753872712842
-0.820546727801130  -0.089726626099435  0.045753872712842
-0.196007481363421  -0.196007481363421  0.060897965347876
-0.196007481363421  -0.607985037273158  0.060897965347876
-0.607985037273158  -0.196007481363421  0.060897965347876
-0.488214180481157  -0.488214180481157  0.061249783450710
-0.488214180481157  -0.023571639037686  0.061249783450710
-0.023571639037686  -0.488214180481157  0.061249783450710
-0.647023488009788  -0.647023488009788  0.048736115353600
-0.647023488009788  0.294046976019576  0.048736115353600
0.294046976019576  -0.647023488009788  0.048736115353600
-0.791658289326483  -0.791658289326483  0.031994864064048
-0.791658289326483  0.583316578652966  0.031994864064048
0.583316578652966  -0.791658289326483  0.031994864064048
-0.893862072318140  -0.893862072318140  0.015396603631204
-0.893862072318140  0.787724144636280  0.015396603631204
0.787724144636280  -0.893862072318140  0.015396603631204
-0.916762569607942  -0.916762569607942  -0.001264120994976
-0.916762569607942  0.833525139215884  -0.001264120994976
0.833525139215884  -0.916762569607942  -0.001264120994976
-0.976836157186356  -0.976836157186356  0.003502268602386
-0.976836157186356  0.953672314372712  0.003502268602386
0.953672314372712  -0.976836157186356  0.003502268602386
-0.310288459541998  0.212805292212320  0.032931678379152
0.212805292212320  -0.902516832670322  0.032931678379152
-0.902516832670322  -0.310288459541998  0.032931678379152
-0.310288459541998  -0.902516832670322  0.032931678379152
0.212805292212320  -0.310288459541998  0.032931678379152
-0.902516832670322  0.212805292212320  0.032931678379152
-0.244313460810292  0.231685228913082  0.009678067080970
0.231685228913082  -0.987371768102790  0.009678067080970
-0.987371768102790  -0.244313460810292  0.009678067080970
-0.244313460810292  -0.987371768102790  0.009678067080970
0.231685228913082  -0.244313460810292  0.009678067080970
-0.987371768102790  0.231685228913082  0.009678067080970
-0.386729041875286  0.118096000780590  0.051609813069300
0.118096000780590  -0.731366958905304  0.051609813069300
-0.731366958905304  -0.386729041875286  0.051609813069300
-0.386729041875286  -0.731366958905304  0.051609813069300
0.118096000780590  -0.386729041875286  0.051609813069300
-0.731366958905304  0.118096000780590  0.051609813069300
-0.501161274450516  0.473213486525732  0.016942182108882
0.473213486525732  -0.972052212075216  0.016942182108882
-0.972052212075216  -0.501161274450516  0.016942182108882
-0.501161274450516  -0.972052212075216  0.016942182108882
0.473213486525732  -0.501161274450516  0.016942182108882
-0.972052212075216  0.473213486525732  0.016942182108882
-0.574448550394396  0.423350284574868  0.036709828212560
0.423350284574868  -0.848901734180472  0.036709828212560
-0.848901734180472  -0.574448550394396  0.036709828212560
-0.574448550394396  -0.848901734180472  0.036709828212560
0.423350284574868  -0.574448550394396  0.036709828212560
-0.848901734180472  0.423350284574868  0.036709828212560
-0.706069127893522  0.722805434309974  0.001408809355816
0.722805434309974  -1.016736306416454  0.001408809355816
-1.016736306416454  -0.706069127893522  0.001408809355816
-0.706069127893522  -1.016736306416454  0.001408809355816
0.722805434309974  -0.706069127893522  0.001408809355816
-1.016736306416454  0.722805434309974  0.001408809355816
-0.724546042342154  0.671173915824726  0.020225369854924
0.671173915824726  -0.946627873482572  0.020225369854924
-0.946627873482572  -0.724546042342154  0.020225369854924
-0.724546042342154  -0.946627873482572  0.020225369854924
0.671173915824726  -0.724546042342154  0.020225369854924
-0.946627873482572  0.671173915824726  0.020225369854924
-0.880607781701986  0.859512343113706  0.007147818771900
0.859512343113706  -0.978904561411718  0.007147818771900
-0.978904561411718  -0.880607781701986  0.007147818771900
-0.880607781701986  -0.978904561411718  0.007147818771900
0.859512343113706  -0.880607781701986  0.007147818771900
-0.978904561411718  0.859512343113706  0.007147818771900
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=20

 */

namespace Feel
{
namespace ublas = boost::numeric::ublas;

/// \cond detail
/**
 * \internal
 * \namespace Feel::detail
 */
namespace detail
{
using namespace boost::assign;

/**
 * \internal
 * \class IMTetrahedra
 */
template<int Order, typename T>
struct IMTriangle
{
};
/*
  1
  -0.333333333333333  -0.333333333333333  2.000000000000000
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=1
*/

/// \cond detail
template<typename T>
struct IMTriangle<1,T>
{
    typedef T value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 1;
    static const uint16_type nPoints = 1;

    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  2.000000000000000;
    }

    std::vector<value_type> q;
};

template<typename T> struct IMTriangle<0,T>: public IMTriangle<1,T> {};

/*
3
-0.666666666666667  -0.666666666666667  0.666666666666667
-0.666666666666667  0.333333333333333  0.666666666666667
0.333333333333333  -0.666666666666667  0.666666666666667
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=2
*/
template<typename T>
struct IMTriangle<2,T>
{
    typedef T value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 2;
    static const uint16_type nPoints = 3;

    IMTriangle()
        :
        q()
    {
        q += -0.666666666666667,  -0.666666666666667,  0.666666666666667,
            -0.666666666666667,  0.333333333333333,  0.666666666666667,
            0.333333333333333,  -0.666666666666667,  0.666666666666667;
    }



    std::vector<value_type> q;
};

/*
4
-0.333333333333333  -0.333333333333333  -1.125000000000000
-0.600000000000000  -0.600000000000000  1.041666666666667
-0.600000000000000  0.200000000000000  1.041666666666667
0.200000000000000  -0.600000000000000  1.041666666666667
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=3
*/

template<>
struct IMTriangle<3,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 3;
    static const uint16_type nPoints = 4;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  -1.125000000000000,
            -0.600000000000000,  -0.600000000000000,  1.041666666666667,
            -0.600000000000000,  0.200000000000000,  1.041666666666667,
            0.200000000000000,  -0.600000000000000,  1.041666666666667;
    }

    std::vector<value_type> q;
};

/*
6
-0.108103018168070  -0.108103018168070  0.446763179356022
-0.108103018168070  -0.783793963663860  0.446763179356022
-0.783793963663860  -0.108103018168070  0.446763179356022
-0.816847572980458  -0.816847572980458  0.219903487310644
-0.816847572980458  0.633695145960918  0.219903487310644
0.633695145960918  -0.816847572980458  0.219903487310644
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=4

*/

template<>
struct IMTriangle<4,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 4;
    static const uint16_type nPoints = 6;
    IMTriangle()
        :
        q()
    {
        q += -0.108103018168070,  -0.108103018168070,  0.446763179356022,
            -0.108103018168070,  -0.783793963663860,  0.446763179356022,
            -0.783793963663860,  -0.108103018168070,  0.446763179356022,
            -0.816847572980458,  -0.816847572980458,  0.219903487310644,
            -0.816847572980458,  0.633695145960918,  0.219903487310644,
            0.633695145960918,  -0.816847572980458,  0.219903487310644;
    }

    std::vector<value_type> q;
};

/*
7
-0.333333333333333  -0.333333333333333  0.450000000000000
-0.059715871789770  -0.059715871789770  0.264788305577012
-0.059715871789770  -0.880568256420460  0.264788305577012
-0.880568256420460  -0.059715871789770  0.264788305577012
-0.797426985353088  -0.797426985353088  0.251878361089654
-0.797426985353088  0.594853970706174  0.251878361089654
0.594853970706174  -0.797426985353088  0.251878361089654
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=5
*/
template<>
struct IMTriangle<5,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 5;
    static const uint16_type nPoints = 7;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  0.450000000000000,
            -0.059715871789770,  -0.059715871789770,  0.264788305577012,
            -0.059715871789770,  -0.880568256420460,  0.264788305577012,
            -0.880568256420460,  -0.059715871789770,  0.264788305577012,
            -0.797426985353088,  -0.797426985353088,  0.251878361089654,
            -0.797426985353088,  0.594853970706174,  0.251878361089654,
            0.594853970706174,  -0.797426985353088,  0.251878361089654;
    }

    std::vector<value_type> q;
};

/*
12
-0.501426509658180  -0.501426509658180  0.233572551452758
-0.501426509658180  0.002853019316358  0.233572551452758
0.002853019316358  -0.501426509658180  0.233572551452758
-0.873821971016996  -0.873821971016996  0.101689812740414
-0.873821971016996  0.747643942033992  0.101689812740414
0.747643942033992  -0.873821971016996  0.101689812740414
-0.379295097932432  0.273004998242798  0.165702151236748
0.273004998242798  -0.893709900310366  0.165702151236748
-0.893709900310366  -0.379295097932432  0.165702151236748
-0.379295097932432  -0.893709900310366  0.165702151236748
0.273004998242798  -0.379295097932432  0.165702151236748
-0.893709900310366  0.273004998242798  0.165702151236748
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=6
*/
template<>
struct IMTriangle<6,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 6;
    static const uint16_type nPoints = 12;
    IMTriangle()
        :
        q()
    {
        q+= -0.501426509658180,  -0.501426509658180,  0.233572551452758,
            -0.501426509658180,  0.002853019316358,  0.233572551452758,
            0.002853019316358,  -0.501426509658180,  0.233572551452758,
            -0.873821971016996,  -0.873821971016996,  0.101689812740414,
            -0.873821971016996,  0.747643942033992,  0.101689812740414,
            0.747643942033992,  -0.873821971016996,  0.101689812740414,
            -0.379295097932432,  0.273004998242798,  0.165702151236748,
            0.273004998242798,  -0.893709900310366,  0.165702151236748,
            -0.893709900310366,  -0.379295097932432,  0.165702151236748,
            -0.379295097932432,  -0.893709900310366,  0.165702151236748,
            0.273004998242798,  -0.379295097932432,  0.165702151236748,
            -0.893709900310366,  0.273004998242798,  0.165702151236748;
    }
    std::vector<value_type> q;
};

/*
13
-0.333333333333333  -0.333333333333333  -0.299140088935364
-0.479308067841920  -0.479308067841920  0.351230514866416
-0.479308067841920  -0.041383864316160  0.351230514866416
-0.041383864316160  -0.479308067841920  0.351230514866416
-0.869739794195568  -0.869739794195568  0.106694471217676
-0.869739794195568  0.739479588391136  0.106694471217676
0.739479588391136  -0.869739794195568  0.106694471217676
-0.374269007990252  0.276888377139620  0.154227521780514
0.276888377139620  -0.902619369149368  0.154227521780514
-0.902619369149368  -0.374269007990252  0.154227521780514
-0.374269007990252  -0.902619369149368  0.154227521780514
0.276888377139620  -0.374269007990252  0.154227521780514
-0.902619369149368  0.276888377139620  0.154227521780514
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=7
*/
template<>
struct IMTriangle<7,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 7;
    static const uint16_type nPoints = 13;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  -0.299140088935364,
            -0.479308067841920,  -0.479308067841920,  0.351230514866416,
            -0.479308067841920,  -0.041383864316160,  0.351230514866416,
            -0.041383864316160,  -0.479308067841920,  0.351230514866416,
            -0.869739794195568,  -0.869739794195568,  0.106694471217676,
            -0.869739794195568,  0.739479588391136,  0.106694471217676,
            0.739479588391136,  -0.869739794195568,  0.106694471217676,
            -0.374269007990252,  0.276888377139620,  0.154227521780514,
            0.276888377139620,  -0.902619369149368,  0.154227521780514,
            -0.902619369149368,  -0.374269007990252,  0.154227521780514,
            -0.374269007990252,  -0.902619369149368,  0.154227521780514,
            0.276888377139620,  -0.374269007990252,  0.154227521780514,
            -0.902619369149368,  0.276888377139620,  0.154227521780514;
    }
    std::vector<value_type> q;
};

/*
16
-0.333333333333333  -0.333333333333333  0.288631215355574
-0.081414823414554  -0.081414823414554  0.190183268534570
-0.081414823414554  -0.837170353170892  0.190183268534570
-0.837170353170892  -0.081414823414554  0.190183268534570
-0.658861384496480  -0.658861384496480  0.206434741069436
-0.658861384496480  0.317722768992960  0.206434741069436
0.317722768992960  -0.658861384496480  0.206434741069436
-0.898905543365938  -0.898905543365938  0.064916995246396
-0.898905543365938  0.797811086731876  0.064916995246395
0.797811086731876  -0.898905543365938  0.064916995246396
-0.473774340730724  0.456984785910808  0.054460628348870
0.456984785910808  -0.983210445180084  0.054460628348870
-0.983210445180084  -0.473774340730724  0.054460628348870
-0.473774340730724  -0.983210445180084  0.054460628348870
0.456984785910808  -0.473774340730724  0.054460628348870
-0.983210445180084  0.456984785910808  0.054460628348870
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=8
*/
template<>
struct IMTriangle<8,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 8;
    static const uint16_type nPoints = 16;
    IMTriangle()
        :
        q()
    {
        q+= -0.333333333333333,  -0.333333333333333,  0.288631215355574,
            -0.081414823414554,  -0.081414823414554,  0.190183268534570,
            -0.081414823414554,  -0.837170353170892,  0.190183268534570,
            -0.837170353170892,  -0.081414823414554,  0.190183268534570,
            -0.658861384496480,  -0.658861384496480,  0.206434741069436,
            -0.658861384496480,  0.317722768992960,  0.206434741069436,
            0.317722768992960,  -0.658861384496480,  0.206434741069436,
            -0.898905543365938,  -0.898905543365938,  0.064916995246396,
            -0.898905543365938,  0.797811086731876,  0.064916995246395,
            0.797811086731876,  -0.898905543365938,  0.064916995246396,
            -0.473774340730724,  0.456984785910808,  0.054460628348870,
            0.456984785910808,  -0.983210445180084,  0.054460628348870,
            -0.983210445180084,  -0.473774340730724,  0.054460628348870,
            -0.473774340730724,  -0.983210445180084,  0.054460628348870,
            0.456984785910808,  -0.473774340730724,  0.054460628348870,
            -0.983210445180084,  0.456984785910808,  0.054460628348870;
    }
    std::vector<value_type> q;
};

/*
19
-0.333333333333333  -0.333333333333333  0.194271592565598
-0.020634961602524  -0.020634961602524  0.062669400454278
-0.020634961602524  -0.958730076794950  0.062669400454278
-0.958730076794950  -0.020634961602524  0.062669400454278
-0.125820817014126  -0.125820817014126  0.155655082009548
-0.125820817014126  -0.748358365971746  0.155655082009548
-0.748358365971746  -0.125820817014126  0.155655082009548
-0.623592928761934  -0.623592928761934  0.159295477854420
-0.623592928761934  0.247185857523870  0.159295477854420
0.247185857523870  -0.623592928761934  0.159295477854420
-0.910540973211094  -0.910540973211094  0.051155351317396
-0.910540973211094  0.821081946422190  0.051155351317396
0.821081946422190  -0.910540973211094  0.051155351317396
-0.556074021678468  0.482397197568996  0.086567078754578
0.482397197568996  -0.926323175890528  0.086567078754578
-0.926323175890528  -0.556074021678468  0.086567078754578
-0.556074021678468  -0.926323175890528  0.086567078754578
0.482397197568996  -0.556074021678468  0.086567078754578
-0.926323175890528  0.482397197568996  0.086567078754578
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=9
*/
template<>
struct IMTriangle<9,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 9;
    static const uint16_type nPoints = 19;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  0.194271592565598,
            -0.020634961602524,  -0.020634961602524,  0.062669400454278,
            -0.020634961602524,  -0.958730076794950,  0.062669400454278,
            -0.958730076794950,  -0.020634961602524,  0.062669400454278,
            -0.125820817014126,  -0.125820817014126,  0.155655082009548,
            -0.125820817014126,  -0.748358365971746,  0.155655082009548,
            -0.748358365971746,  -0.125820817014126,  0.155655082009548,
            -0.623592928761934,  -0.623592928761934,  0.159295477854420,
            -0.623592928761934,  0.247185857523870,  0.159295477854420,
            0.247185857523870,  -0.623592928761934,  0.159295477854420,
            -0.910540973211094,  -0.910540973211094,  0.051155351317396,
            -0.910540973211094,  0.821081946422190,  0.051155351317396,
            0.821081946422190,  -0.910540973211094,  0.051155351317396,
            -0.556074021678468,  0.482397197568996,  0.086567078754578,
            0.482397197568996,  -0.926323175890528,  0.086567078754578,
            -0.926323175890528,  -0.556074021678468,  0.086567078754578,
            -0.556074021678468,  -0.926323175890528,  0.086567078754578,
            0.482397197568996,  -0.556074021678468,  0.086567078754578,
            -0.926323175890528,  0.482397197568996,  0.086567078754578;
    }
    std::vector<value_type> q;
};
/*
25
-0.333333333333333  -0.333333333333333  0.181635980765508
-0.028844733232686  -0.028844733232686  0.073451915512934
-0.028844733232686  -0.942310533534630  0.073451915512934
-0.942310533534630  -0.028844733232686  0.073451915512934
-0.781036849029926  -0.781036849029926  0.090642118871056
-0.781036849029926  0.562073698059852  0.090642118871056
0.562073698059852  -0.781036849029926  0.090642118871056
-0.384120322471758  0.100705883641998  0.145515833690840
0.100705883641998  -0.716585561170240  0.145515833690840
-0.716585561170240  -0.384120322471758  0.145515833690840
-0.384120322471758  -0.716585561170240  0.145515833690840
0.100705883641998  -0.384120322471758  0.145515833690840
-0.716585561170240  0.100705883641998  0.145515833690840
-0.506654878720194  0.456647809194822  0.056654485062114
0.456647809194822  -0.949992930474628  0.056654485062114
-0.949992930474628  -0.506654878720194  0.056654485062114
-0.506654878720194  -0.949992930474628  0.056654485062114
0.456647809194822  -0.506654878720194  0.056654485062114
-0.949992930474628  0.456647809194822  0.056654485062114
-0.866393497975600  0.847311867175000  0.018843333927466
0.847311867175000  -0.980918369199402  0.018843333927466
-0.980918369199402  -0.866393497975600  0.018843333927466
-0.866393497975600  -0.980918369199402  0.018843333927466
0.847311867175000  -0.866393497975600  0.018843333927466
-0.980918369199402  0.847311867175000  0.018843333927466
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=10
*/
template<>
struct IMTriangle<10,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 10;
    static const uint16_type nPoints = 25;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  0.181635980765508,
            -0.028844733232686,  -0.028844733232686,  0.073451915512934,
            -0.028844733232686,  -0.942310533534630,  0.073451915512934,
            -0.942310533534630,  -0.028844733232686,  0.073451915512934,
            -0.781036849029926,  -0.781036849029926,  0.090642118871056,
            -0.781036849029926,  0.562073698059852,  0.090642118871056,
            0.562073698059852,  -0.781036849029926,  0.090642118871056,
            -0.384120322471758,  0.100705883641998,  0.145515833690840,
            0.100705883641998,  -0.716585561170240,  0.145515833690840,
            -0.716585561170240,  -0.384120322471758,  0.145515833690840,
            -0.384120322471758,  -0.716585561170240,  0.145515833690840,
            0.100705883641998,  -0.384120322471758,  0.145515833690840,
            -0.716585561170240,  0.100705883641998,  0.145515833690840,
            -0.506654878720194,  0.456647809194822,  0.056654485062114,
            0.456647809194822,  -0.949992930474628,  0.056654485062114,
            -0.949992930474628,  -0.506654878720194,  0.056654485062114,
            -0.506654878720194,  -0.949992930474628,  0.056654485062114,
            0.456647809194822,  -0.506654878720194,  0.056654485062114,
            -0.949992930474628,  0.456647809194822,  0.056654485062114,
            -0.866393497975600,  0.847311867175000,  0.018843333927466,
            0.847311867175000,  -0.980918369199402,  0.018843333927466,
            -0.980918369199402,  -0.866393497975600,  0.018843333927466,
            -0.866393497975600,  -0.980918369199402,  0.018843333927466,
            0.847311867175000,  -0.866393497975600,  0.018843333927466,
            -0.980918369199402,  0.847311867175000,  0.018843333927466;
    }
    std::vector<value_type> q;
};
/*
27
0.069222096541516  0.069222096541516  0.001854012657922
0.069222096541516  -1.138444193083034  0.001854012657922
-1.138444193083034  0.069222096541516  0.001854012657922
-0.202061394068290  -0.202061394068290  0.154299069829626
-0.202061394068290  -0.595877211863420  0.154299069829626
-0.595877211863420  -0.202061394068290  0.154299069829626
-0.593380199137436  -0.593380199137436  0.118645954761548
-0.593380199137436  0.186760398274870  0.118645954761548
0.186760398274870  -0.593380199137436  0.118645954761548
-0.761298175434838  -0.761298175434838  0.072369081006836
-0.761298175434838  0.522596350869674  0.072369081006836
0.522596350869674  -0.761298175434838  0.072369081006836
-0.935270103777448  -0.935270103777448  0.027319462005356
-0.935270103777448  0.870540207554896  0.027319462005356
0.870540207554896  -0.935270103777448  0.027319462005356
-0.286758703477414  0.186402426856426  0.104674223924408
0.186402426856426  -0.899643723379010  0.104674223924408
-0.899643723379010  -0.286758703477414  0.104674223924408
-0.286758703477414  -0.899643723379010  0.104674223924408
0.186402426856426  -0.286758703477414  0.104674223924408
-0.899643723379010  0.186402426856426  0.104674223924408
-0.657022039391916  0.614978006319584  0.041415319278282
0.614978006319584  -0.957955966927668  0.041415319278282
-0.957955966927668  -0.657022039391916  0.041415319278282
-0.657022039391916  -0.957955966927668  0.041415319278282
0.614978006319584  -0.657022039391916  0.041415319278282
-0.957955966927668  0.614978006319584  0.041415319278282
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=11
*/

template<>
struct IMTriangle<11,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 11;
    static const uint16_type nPoints = 27;
    IMTriangle()
        :
        q()
    {
        q += 0.069222096541516,  0.069222096541516,  0.001854012657922,
            0.069222096541516,  -1.138444193083034,  0.001854012657922,
            -1.138444193083034,  0.069222096541516,  0.001854012657922,
            -0.202061394068290,  -0.202061394068290,  0.154299069829626,
            -0.202061394068290,  -0.595877211863420,  0.154299069829626,
            -0.595877211863420,  -0.202061394068290,  0.154299069829626,
            -0.593380199137436,  -0.593380199137436,  0.118645954761548,
            -0.593380199137436,  0.186760398274870,  0.118645954761548,
            0.186760398274870,  -0.593380199137436,  0.118645954761548,
            -0.761298175434838,  -0.761298175434838,  0.072369081006836,
            -0.761298175434838,  0.522596350869674,  0.072369081006836,
            0.522596350869674,  -0.761298175434838,  0.072369081006836,
            -0.935270103777448,  -0.935270103777448,  0.027319462005356,
            -0.935270103777448,  0.870540207554896,  0.027319462005356,
            0.870540207554896,  -0.935270103777448,  0.027319462005356,
            -0.286758703477414,  0.186402426856426,  0.104674223924408,
            0.186402426856426,  -0.899643723379010,  0.104674223924408,
            -0.899643723379010,  -0.286758703477414,  0.104674223924408,
            -0.286758703477414,  -0.899643723379010,  0.104674223924408,
            0.186402426856426,  -0.286758703477414,  0.104674223924408,
            -0.899643723379010,  0.186402426856426,  0.104674223924408,
            -0.657022039391916,  0.614978006319584,  0.041415319278282,
            0.614978006319584,  -0.957955966927668,  0.041415319278282,
            -0.957955966927668,  -0.657022039391916,  0.041415319278282,
            -0.657022039391916,  -0.957955966927668,  0.041415319278282,
            0.614978006319584,  -0.657022039391916,  0.041415319278282,
            -0.957955966927668,  0.614978006319584,  0.041415319278282;
    }
    std::vector<value_type> q;
};
/*
33
-0.023565220452390  -0.023565220452390  0.051462132880910
-0.023565220452390  -0.952869559095220  0.051462132880910
-0.952869559095220  -0.023565220452390  0.051462132880910
-0.120551215411080  -0.120551215411080  0.087385089076076
-0.120551215411080  -0.758897569177842  0.087385089076076
-0.758897569177842  -0.120551215411080  0.087385089076076
-0.457579229975768  -0.457579229975768  0.125716448435770
-0.457579229975768  -0.084841540048464  0.125716448435770
-0.084841540048464  -0.457579229975768  0.125716448435770
-0.744847708916828  -0.744847708916828  0.069592225861418
-0.744847708916828  0.489695417833656  0.069592225861418
0.489695417833656  -0.744847708916828  0.069592225861418
-0.957365299093580  -0.957365299093580  0.012332522103118
-0.957365299093580  0.914730598187158  0.012332522103118
0.914730598187158  -0.957365299093580  0.012332522103118
-0.448573460628972  0.217886471559576  0.080743115532762
0.217886471559576  -0.769313010930604  0.080743115532762
-0.769313010930604  -0.448573460628972  0.080743115532762
-0.448573460628972  -0.769313010930604  0.080743115532762
0.217886471559576  -0.448573460628972  0.080743115532762
-0.769313010930604  0.217886471559576  0.080743115532762
-0.437348838020120  0.391672173575606  0.044713546404606
0.391672173575606  -0.954323335555486  0.044713546404606
-0.954323335555486  -0.437348838020120  0.044713546404606
-0.437348838020120  -0.954323335555486  0.044713546404606
0.391672173575606  -0.437348838020120  0.044713546404606
-0.954323335555486  0.391672173575606  0.044713546404606
-0.767496168184806  0.716028067088146  0.034632462217318
0.716028067088146  -0.948531898903340  0.034632462217318
-0.948531898903340  -0.767496168184806  0.034632462217318
-0.767496168184806  -0.948531898903340  0.034632462217318
0.716028067088146  -0.767496168184806  0.034632462217318
-0.948531898903340  0.716028067088146  0.034632462217318
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=12
*/
template<>
struct IMTriangle<12,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 12;
    static const uint16_type nPoints = 33;
    IMTriangle()
        :
        q()
    {
        q += -0.023565220452390,  -0.023565220452390,  0.051462132880910,
            -0.023565220452390,  -0.952869559095220,  0.051462132880910,
            -0.952869559095220,  -0.023565220452390,  0.051462132880910,
            -0.120551215411080,  -0.120551215411080,  0.087385089076076,
            -0.120551215411080,  -0.758897569177842,  0.087385089076076,
            -0.758897569177842,  -0.120551215411080,  0.087385089076076,
            -0.457579229975768,  -0.457579229975768,  0.125716448435770,
            -0.457579229975768,  -0.084841540048464,  0.125716448435770,
            -0.084841540048464,  -0.457579229975768,  0.125716448435770,
            -0.744847708916828,  -0.744847708916828,  0.069592225861418,
            -0.744847708916828,  0.489695417833656,  0.069592225861418,
            0.489695417833656,  -0.744847708916828,  0.069592225861418,
            -0.957365299093580,  -0.957365299093580,  0.012332522103118,
            -0.957365299093580,  0.914730598187158,  0.012332522103118,
            0.914730598187158,  -0.957365299093580,  0.012332522103118,
            -0.448573460628972,  0.217886471559576,  0.080743115532762,
            0.217886471559576,  -0.769313010930604,  0.080743115532762,
            -0.769313010930604,  -0.448573460628972,  0.080743115532762,
            -0.448573460628972,  -0.769313010930604,  0.080743115532762,
            0.217886471559576,  -0.448573460628972,  0.080743115532762,
            -0.769313010930604,  0.217886471559576,  0.080743115532762,
            -0.437348838020120,  0.391672173575606,  0.044713546404606,
            0.391672173575606,  -0.954323335555486,  0.044713546404606,
            -0.954323335555486,  -0.437348838020120,  0.044713546404606,
            -0.437348838020120,  -0.954323335555486,  0.044713546404606,
            0.391672173575606,  -0.437348838020120,  0.044713546404606,
            -0.954323335555486,  0.391672173575606,  0.044713546404606,
            -0.767496168184806,  0.716028067088146,  0.034632462217318,
            0.716028067088146,  -0.948531898903340,  0.034632462217318,
            -0.948531898903340,  -0.767496168184806,  0.034632462217318,
            -0.767496168184806,  -0.948531898903340,  0.034632462217318,
            0.716028067088146,  -0.767496168184806,  0.034632462217318,
            -0.948531898903340,  0.716028067088146,  0.034632462217318;

    }
    std::vector<value_type> q;
};

/*
37
-0.333333333333333  -0.333333333333333  0.105041846801604
-0.009903630120590  -0.009903630120590  0.022560290418660
-0.009903630120590  -0.980192739758818  0.022560290418660
-0.980192739758818  -0.009903630120590  0.022560290418660
-0.062566729780852  -0.062566729780852  0.062847036724908
-0.062566729780852  -0.874866540438296  0.062847036724908
-0.874866540438296  -0.062566729780852  0.062847036724908
-0.170957326397446  -0.170957326397446  0.094145005008388
-0.170957326397446  -0.658085347205106  0.094145005008388
-0.658085347205106  -0.170957326397446  0.094145005008388
-0.541200855914338  -0.541200855914338  0.094727173072710
-0.541200855914338  0.082401711828674  0.094727173072710
0.082401711828674  -0.541200855914338  0.094727173072710
-0.771151009607340  -0.771151009607340  0.062335058091588
-0.771151009607340  0.542302019214680  0.062335058091588
0.542302019214680  -0.771151009607340  0.062335058091588
-0.950377217273082  -0.950377217273082  0.015951542930148
-0.950377217273082  0.900754434546164  0.015951542930148
0.900754434546164  -0.950377217273082  0.015951542930148
-0.462410005882478  0.272702349123320  0.073696805457464
0.272702349123320  -0.810292343240842  0.073696805457464
-0.810292343240842  -0.462410005882478  0.073696805457464
-0.462410005882478  -0.810292343240842  0.073696805457464
0.272702349123320  -0.462410005882478  0.073696805457464
-0.810292343240842  0.272702349123320  0.073696805457464
-0.416539866531424  0.380338319973810  0.034802926607644
0.380338319973810  -0.963798453442386  0.034802926607644
-0.963798453442386  -0.416539866531424  0.034802926607644
-0.416539866531424  -0.963798453442386  0.034802926607644
0.380338319973810  -0.416539866531424  0.034802926607644
-0.963798453442386  0.380338319973810  0.034802926607644
-0.747285229016662  0.702819075668482  0.031043573678090
0.702819075668482  -0.955533846651820  0.031043573678090
-0.955533846651820  -0.747285229016662  0.031043573678090
-0.747285229016662  -0.955533846651820  0.031043573678090
0.702819075668482  -0.747285229016662  0.031043573678090
-0.955533846651820  0.702819075668482  0.031043573678090
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=13
*/
template<>
struct IMTriangle<13,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 13;
    static const uint16_type nPoints = 37;
    IMTriangle()
        :
        q()
    {
        q += -0.333333333333333,  -0.333333333333333,  0.105041846801604,
            -0.009903630120590,  -0.009903630120590,  0.022560290418660,
            -0.009903630120590,  -0.980192739758818,  0.022560290418660,
            -0.980192739758818,  -0.009903630120590,  0.022560290418660,
            -0.062566729780852,  -0.062566729780852,  0.062847036724908,
            -0.062566729780852,  -0.874866540438296,  0.062847036724908,
            -0.874866540438296,  -0.062566729780852,  0.062847036724908,
            -0.170957326397446,  -0.170957326397446,  0.094145005008388,
            -0.170957326397446,  -0.658085347205106,  0.094145005008388,
            -0.658085347205106,  -0.170957326397446,  0.094145005008388,
            -0.541200855914338,  -0.541200855914338,  0.094727173072710,
            -0.541200855914338,  0.082401711828674,  0.094727173072710,
            0.082401711828674,  -0.541200855914338,  0.094727173072710,
            -0.771151009607340,  -0.771151009607340,  0.062335058091588,
            -0.771151009607340,  0.542302019214680,  0.062335058091588,
            0.542302019214680,  -0.771151009607340,  0.062335058091588,
            -0.950377217273082,  -0.950377217273082,  0.015951542930148,
            -0.950377217273082,  0.900754434546164,  0.015951542930148,
            0.900754434546164,  -0.950377217273082,  0.015951542930148,
            -0.462410005882478,  0.272702349123320,  0.073696805457464,
            0.272702349123320,  -0.810292343240842,  0.073696805457464,
            -0.810292343240842,  -0.462410005882478,  0.073696805457464,
            -0.462410005882478,  -0.810292343240842,  0.073696805457464,
            0.272702349123320,  -0.462410005882478,  0.073696805457464,
            -0.810292343240842,  0.272702349123320,  0.073696805457464,
            -0.416539866531424,  0.380338319973810,  0.034802926607644,
            0.380338319973810,  -0.963798453442386,  0.034802926607644,
            -0.963798453442386,  -0.416539866531424,  0.034802926607644,
            -0.416539866531424,  -0.963798453442386,  0.034802926607644,
            0.380338319973810,  -0.416539866531424,  0.034802926607644,
            -0.963798453442386,  0.380338319973810,  0.034802926607644,
            -0.747285229016662,  0.702819075668482,  0.031043573678090,
            0.702819075668482,  -0.955533846651820,  0.031043573678090,
            -0.955533846651820,  -0.747285229016662,  0.031043573678090,
            -0.747285229016662,  -0.955533846651820,  0.031043573678090,
            0.702819075668482,  -0.747285229016662,  0.031043573678090,
            -0.955533846651820,  0.702819075668482,  0.031043573678090;

    }
    std::vector<value_type> q;
};

/*
42
-0.022072179275642  -0.022072179275642  0.043767162738858
-0.022072179275642  -0.955855641448714  0.043767162738858
-0.955855641448714  -0.022072179275642  0.043767162738858
-0.164710561319092  -0.164710561319092  0.065576707088250
-0.164710561319092  -0.670578877361816  0.065576707088250
-0.670578877361816  -0.164710561319092  0.065576707088250
-0.453044943382322  -0.453044943382322  0.103548209014584
-0.453044943382322  -0.093910113235354  0.103548209014584
-0.093910113235354  -0.453044943382322  0.103548209014584
-0.645588935174914  -0.645588935174914  0.084325177473986
-0.645588935174914  0.291177870349826  0.084325177473986
0.291177870349826  -0.645588935174914  0.084325177473986
-0.876400233818254  -0.876400233818254  0.028867399339554
-0.876400233818254  0.752800467636510  0.028867399339554
0.752800467636510  -0.876400233818254  0.028867399339554
-0.961218077502598  -0.961218077502598  0.009846807204800
-0.961218077502598  0.922436155005196  0.009846807204800
0.9224361550051960  -0.961218077502598  0.009846807204800
-0.655466624357288  0.541217109549992  0.049331506425128
0.541217109549992  -0.885750485192704  0.049331506425128
-0.885750485192704  -0.655466624357288  0.049331506425128
-0.655466624357288  -0.885750485192704  0.049331506425128
0.541217109549992  -0.655466624357288  0.049331506425128
-0.885750485192704  0.541217109549992  0.049331506425128
-0.326277080407310  0.140444581693366  0.077143021574122
0.140444581693366  -0.814167501286056  0.077143021574122
-0.814167501286056  -0.326277080407310  0.077143021574122
-0.326277080407310  -0.814167501286056  0.077143021574122
0.140444581693366  -0.326277080407310  0.077143021574122
-0.814167501286056  0.140444581693366  0.077143021574122
-0.403254235727484  0.373960335616176  0.028872616227068
0.373960335616176  -0.970706099888692  0.028872616227068
-0.970706099888692  -0.403254235727484  0.028872616227068
-0.403254235727484  -0.970706099888692  0.028872616227068
0.373960335616176  -0.403254235727484  0.028872616227068
-0.970706099888692  0.373960335616176  0.028872616227068
-0.762051004606086  0.759514342740342  0.010020457677002
0.759514342740342  -0.997463338134256  0.010020457677002
-0.997463338134256  -0.762051004606086  0.010020457677002
-0.762051004606086  -0.997463338134256  0.010020457677002
0.759514342740342  -0.762051004606086  0.010020457677002
-0.997463338134256  0.759514342740342  0.010020457677002
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=14
*/
template<>
struct IMTriangle<14,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 14;
    static const uint16_type nPoints = 42;
    IMTriangle()
        :
        q()
    {
        q += -0.022072179275642,  -0.022072179275642,  0.043767162738858,
            -0.022072179275642,  -0.955855641448714,  0.043767162738858,
            -0.955855641448714,  -0.022072179275642,  0.043767162738858,
            -0.164710561319092,  -0.164710561319092,  0.065576707088250,
            -0.164710561319092,  -0.670578877361816,  0.065576707088250,
            -0.670578877361816,  -0.164710561319092,  0.065576707088250,
            -0.453044943382322,  -0.453044943382322,  0.103548209014584,
            -0.453044943382322,  -0.093910113235354,  0.103548209014584,
            -0.093910113235354,  -0.453044943382322,  0.103548209014584,
            -0.645588935174914,  -0.645588935174914,  0.084325177473986,
            -0.645588935174914,  0.291177870349826,  0.084325177473986,
            0.291177870349826,  -0.645588935174914,  0.084325177473986,
            -0.876400233818254,  -0.876400233818254,  0.028867399339554,
            -0.876400233818254,  0.752800467636510,  0.028867399339554,
            0.752800467636510,  -0.876400233818254,  0.028867399339554,
            -0.961218077502598,  -0.961218077502598,  0.009846807204800,
            -0.961218077502598,  0.922436155005196,  0.009846807204800,
            0.9224361550051960,  -0.961218077502598,  0.009846807204800,
            -0.655466624357288,  0.541217109549992,  0.049331506425128,
            0.541217109549992,  -0.885750485192704,  0.049331506425128,
            -0.885750485192704,  -0.655466624357288,  0.049331506425128,
            -0.655466624357288,  -0.885750485192704,  0.049331506425128,
            0.541217109549992,  -0.655466624357288,  0.049331506425128,
            -0.885750485192704,  0.541217109549992,  0.049331506425128,
            -0.326277080407310,  0.140444581693366,  0.077143021574122,
            0.140444581693366,  -0.814167501286056,  0.077143021574122,
            -0.814167501286056,  -0.326277080407310,  0.077143021574122,
            -0.326277080407310,  -0.814167501286056,  0.077143021574122,
            0.140444581693366,  -0.326277080407310,  0.077143021574122,
            -0.814167501286056,  0.140444581693366,  0.077143021574122,
            -0.403254235727484,  0.373960335616176,  0.028872616227068,
            0.373960335616176,  -0.970706099888692,  0.028872616227068,
            -0.970706099888692,  -0.403254235727484,  0.028872616227068,
            -0.403254235727484,  -0.970706099888692,  0.028872616227068,
            0.373960335616176,  -0.403254235727484,  0.028872616227068,
            -0.970706099888692,  0.373960335616176,  0.028872616227068,
            -0.762051004606086,  0.759514342740342,  0.010020457677002,
            0.759514342740342,  -0.997463338134256,  0.010020457677002,
            -0.997463338134256,  -0.762051004606086,  0.010020457677002,
            -0.762051004606086,  -0.997463338134256,  0.010020457677002,
            0.759514342740342,  -0.762051004606086,  0.010020457677002,
            -0.997463338134256,  0.759514342740342,  0.010020457677002;
    }
    std::vector<value_type> q;
};

/*
48
0.013945833716486  0.013945833716486  0.003833751285698
0.013945833716486  -1.027891667432972  0.003833751285698
-1.027891667432972  0.013945833716486  0.003833751285698
-0.137187291433954  -0.137187291433954  0.088498054542290
-0.137187291433954  -0.725625417132090  0.088498054542290
-0.725625417132090  -0.137187291433954  0.088498054542290
-0.444612710305712  -0.444612710305712  0.102373097437704
-0.444612710305712  -0.110774579388578  0.102373097437704
-0.110774579388578  -0.444612710305712  0.102373097437704
-0.747070217917492  -0.747070217917492  0.047375471741376
-0.747070217917492  0.494140435834984  0.047375471741376
0.494140435834984  -0.747070217917492  0.047375471741376
-0.858383228050628  -0.858383228050628  0.026579551380042
-0.858383228050628  0.716766456101256  0.026579551380042
0.716766456101256  -0.858383228050628  0.026579551380042
-0.962069659517854  -0.962069659517854  0.009497833216384
-0.962069659517854  0.924139319035706  0.009497833216384
0.924139319035706  -0.962069659517854  0.009497833216384
-0.477377257719826  0.209908933786582  0.077100145199186
0.209908933786582  -0.732531676066758  0.077100145199186
-0.732531676066758  -0.477377257719826  0.077100145199186
-0.477377257719826  -0.732531676066758  0.077100145199186
0.209908933786582  -0.477377257719826  0.077100145199186
-0.732531676066758  0.209908933786582  0.077100145199186
-0.223906465819462  0.151173111025628  0.054431628641248
0.151173111025628  -0.927266645206166  0.054431628641248
-0.927266645206166  -0.223906465819462  0.054431628641248
-0.223906465819462  -0.927266645206166  0.054431628641248
0.151173111025628  -0.223906465819462  0.054431628641248
-0.927266645206166  0.151173111025628  0.054431628641248
-0.428575559900168  0.448925326153310  0.004364154733594
0.448925326153310  -1.020349766253142  0.004364154733594
-1.020349766253142  -0.428575559900168  0.004364154733594
-0.428575559900168  -1.020349766253142  0.004364154733594
0.448925326153310  -0.428575559900168  0.004364154733594
-1.020349766253142  0.448925326153310  0.004364154733594
-0.568800671855432  0.495112932103676  0.043010639695462
0.495112932103676  -0.926312260248244  0.043010639695462
-0.926312260248244  -0.568800671855432  0.043010639695462
-0.568800671855432  -0.926312260248244  0.043010639695462
0.495112932103676  -0.568800671855432  0.043010639695462
-0.926312260248244  0.495112932103676  0.043010639695462
-0.792848766847228  0.767929148184832  0.015347885262098
0.767929148184832  -0.975080381337602  0.015347885262098
-0.975080381337602  -0.792848766847228  0.015347885262098
-0.792848766847228  -0.975080381337602  0.015347885262098
0.767929148184832  -0.792848766847228  0.015347885262098
-0.975080381337602  0.767929148184832  0.015347885262098
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=15
*/
template<>
struct IMTriangle<15,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 15;
    static const uint16_type nPoints = 48;
    IMTriangle()
        :
        q()
    {
        q += 0.013945833716486,  0.013945833716486,  0.003833751285698,
            0.013945833716486,  -1.027891667432972,  0.003833751285698,
            -1.027891667432972,  0.013945833716486,  0.003833751285698,
            -0.137187291433954,  -0.137187291433954,  0.088498054542290,
            -0.137187291433954,  -0.725625417132090,  0.088498054542290,
            -0.725625417132090,  -0.137187291433954,  0.088498054542290,
            -0.444612710305712,  -0.444612710305712,  0.102373097437704,
            -0.444612710305712,  -0.110774579388578,  0.102373097437704,
            -0.110774579388578,  -0.444612710305712,  0.102373097437704,
            -0.747070217917492,  -0.747070217917492,  0.047375471741376,
            -0.747070217917492,  0.494140435834984,  0.047375471741376,
            0.494140435834984,  -0.747070217917492,  0.047375471741376,
            -0.858383228050628,  -0.858383228050628,  0.026579551380042,
            -0.858383228050628,  0.716766456101256,  0.026579551380042,
            0.716766456101256,  -0.858383228050628,  0.026579551380042,
            -0.962069659517854,  -0.962069659517854,  0.009497833216384,
            -0.962069659517854,  0.924139319035706,  0.009497833216384,
            0.924139319035706,  -0.962069659517854,  0.009497833216384,
            -0.477377257719826,  0.209908933786582,  0.077100145199186,
            0.209908933786582,  -0.732531676066758,  0.077100145199186,
            -0.732531676066758,  -0.477377257719826,  0.077100145199186,
            -0.477377257719826,  -0.732531676066758,  0.077100145199186,
            0.209908933786582,  -0.477377257719826,  0.077100145199186,
            -0.732531676066758,  0.209908933786582,  0.077100145199186,
            -0.223906465819462,  0.151173111025628,  0.054431628641248,
            0.151173111025628,  -0.927266645206166,  0.054431628641248,
            -0.927266645206166,  -0.223906465819462,  0.054431628641248,
            -0.223906465819462,  -0.927266645206166,  0.054431628641248,
            0.151173111025628,  -0.223906465819462,  0.054431628641248,
            -0.927266645206166,  0.151173111025628,  0.054431628641248,
            -0.428575559900168,  0.448925326153310,  0.004364154733594,
            0.448925326153310,  -1.020349766253142,  0.004364154733594,
            -1.020349766253142,  -0.428575559900168,  0.004364154733594,
            -0.428575559900168,  -1.020349766253142,  0.004364154733594,
            0.448925326153310,  -0.428575559900168,  0.004364154733594,
            -1.020349766253142,  0.448925326153310,  0.004364154733594,
            -0.568800671855432,  0.495112932103676,  0.043010639695462,
            0.495112932103676,  -0.926312260248244,  0.043010639695462,
            -0.926312260248244,  -0.568800671855432,  0.043010639695462,
            -0.568800671855432,  -0.926312260248244,  0.043010639695462,
            0.495112932103676,  -0.568800671855432,  0.043010639695462,
            -0.926312260248244,  0.495112932103676,  0.043010639695462,
            -0.792848766847228,  0.767929148184832,  0.015347885262098,
            0.767929148184832,  -0.975080381337602,  0.015347885262098,
            -0.975080381337602,  -0.792848766847228,  0.015347885262098,
            -0.792848766847228,  -0.975080381337602,  0.015347885262098,
            0.767929148184832,  -0.792848766847228,  0.015347885262098,
            -0.975080381337602,  0.767929148184832,  0.015347885262098;

    }
    std::vector<value_type> q;
};

/*
52
-0.333333333333333  -0.333333333333333  0.093751394855284
-0.005238916103124  -0.005238916103124  0.012811757157170
-0.005238916103124  -0.989522167793754  0.012811757157170
-0.989522167793754  -0.005238916103124  0.012811757157170
-0.173061122901296  -0.173061122901296  0.083420593478774
-0.173061122901296  -0.653877754197410  0.083420593478774
-0.653877754197410  -0.173061122901296  0.083420593478774
-0.059082801866018  -0.059082801866018  0.053782968500128
-0.059082801866018  -0.881834396267966  0.053782968500128
-0.881834396267966  -0.059082801866018  0.053782968500128
-0.518892500060958  -0.518892500060958  0.084265045523300
-0.518892500060958  0.037785000121916  0.084265045523300
0.037785000121916  -0.518892500060958  0.084265045523300
-0.704068411554854  -0.704068411554854  0.060000533685546
-0.704068411554854  0.408136823109708  0.060000533685546
0.408136823109708  -0.704068411554854  0.060000533685546
-0.849069624685052  -0.849069624685052  0.028400197850048
-0.849069624685052  0.698139249370104  0.028400197850048
0.698139249370104  -0.849069624685052  0.028400197850048
-0.966807194753950  -0.966807194753950  0.007164924702546
-0.966807194753950  0.933614389507900  0.007164924702546
0.933614389507900  -0.966807194753950  0.007164924702546
-0.406888806840226  0.199737422349722  0.065546294921254
0.199737422349722  -0.792848615509496  0.065546294921254
-0.792848615509496  -0.406888806840226  0.065546294921254
-0.406888806840226  -0.792848615509496  0.065546294921254
0.199737422349722  -0.406888806840226  0.065546294921254
-0.792848615509496  0.199737422349722  0.065546294921254
-0.324553873193842  0.284387049883010  0.030596612496882
0.284387049883010  -0.959833176689168  0.030596612496882
-0.959833176689168  -0.324553873193842  0.030596612496882
-0.324553873193842  -0.959833176689168  0.030596612496882
0.284387049883010  -0.324553873193842  0.030596612496882
-0.959833176689168  0.284387049883010  0.030596612496882
-0.590503436714376  0.599185441942654  0.004772488385678
0.599185441942654  -1.008682005228278  0.004772488385678
-1.008682005228278  -0.590503436714376  0.004772488385678
-0.590503436714376  -1.008682005228278  0.004772488385678
0.599185441942654  -0.590503436714376  0.004772488385678
-1.008682005228278  0.599185441942654  0.004772488385678
-0.621283015738754  0.537399442802736  0.038169585511798
0.537399442802736  -0.916116427063980  0.038169585511798
-0.916116427063980  -0.621283015738754  0.038169585511798
-0.621283015738754  -0.916116427063980  0.038169585511798
0.537399442802736  -0.621283015738754  0.038169585511798
-0.916116427063980  0.537399442802736  0.038169585511798
-0.829432768634686  0.800798128173322  0.013700109093084
0.800798128173322  -0.971365359538638  0.013700109093084
-0.971365359538638  -0.829432768634686  0.013700109093084
-0.829432768634686  -0.971365359538638  0.013700109093084
0.800798128173322  -0.829432768634686  0.013700109093084
-0.971365359538638  0.800798128173322  0.013700109093084
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=16
*/
template<>
struct IMTriangle<16,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 16;
    static const uint16_type nPoints = 52;
    IMTriangle()
        :
        q()
    {
        q+=-0.333333333333333,  -0.333333333333333,  0.093751394855284,
            -0.005238916103124,  -0.005238916103124,  0.012811757157170,
            -0.005238916103124,  -0.989522167793754,  0.012811757157170,
            -0.989522167793754,  -0.005238916103124,  0.012811757157170,
            -0.173061122901296,  -0.173061122901296,  0.083420593478774,
            -0.173061122901296,  -0.653877754197410,  0.083420593478774,
            -0.653877754197410,  -0.173061122901296,  0.083420593478774,
            -0.059082801866018,  -0.059082801866018,  0.053782968500128,
            -0.059082801866018,  -0.881834396267966,  0.053782968500128,
            -0.881834396267966,  -0.059082801866018,  0.053782968500128,
            -0.518892500060958,  -0.518892500060958,  0.084265045523300,
            -0.518892500060958,  0.037785000121916,  0.084265045523300,
            0.037785000121916,  -0.518892500060958,  0.084265045523300,
            -0.704068411554854,  -0.704068411554854,  0.060000533685546,
            -0.704068411554854,  0.408136823109708,  0.060000533685546,
            0.408136823109708,  -0.704068411554854,  0.060000533685546,
            -0.849069624685052,  -0.849069624685052,  0.028400197850048,
            -0.849069624685052,  0.698139249370104,  0.028400197850048,
            0.698139249370104,  -0.849069624685052,  0.028400197850048,
            -0.966807194753950,  -0.966807194753950,  0.007164924702546,
            -0.966807194753950,  0.933614389507900,  0.007164924702546,
            0.933614389507900,  -0.966807194753950,  0.007164924702546,
            -0.406888806840226,  0.199737422349722,  0.065546294921254,
            0.199737422349722,  -0.792848615509496,  0.065546294921254,
            -0.792848615509496,  -0.406888806840226,  0.065546294921254,
            -0.406888806840226,  -0.792848615509496,  0.065546294921254,
            0.199737422349722,  -0.406888806840226,  0.065546294921254,
            -0.792848615509496,  0.199737422349722,  0.065546294921254,
            -0.324553873193842,  0.284387049883010,  0.030596612496882,
            0.284387049883010,  -0.959833176689168,  0.030596612496882,
            -0.959833176689168,  -0.324553873193842,  0.030596612496882,
            -0.324553873193842,  -0.959833176689168,  0.030596612496882,
            0.284387049883010,  -0.324553873193842,  0.030596612496882,
            -0.959833176689168,  0.284387049883010,  0.030596612496882,
            -0.590503436714376,  0.599185441942654,  0.004772488385678,
            0.599185441942654,  -1.008682005228278,  0.004772488385678,
            -1.008682005228278,  -0.590503436714376,  0.004772488385678,
            -0.590503436714376,  -1.008682005228278,  0.004772488385678,
            0.599185441942654,  -0.590503436714376,  0.004772488385678,
            -1.008682005228278,  0.599185441942654,  0.004772488385678,
            -0.621283015738754,  0.537399442802736,  0.038169585511798,
            0.537399442802736,  -0.916116427063980,  0.038169585511798,
            -0.916116427063980,  -0.621283015738754,  0.038169585511798,
            -0.621283015738754,  -0.916116427063980,  0.038169585511798,
            0.537399442802736,  -0.621283015738754,  0.038169585511798,
            -0.916116427063980,  0.537399442802736,  0.038169585511798,
            -0.829432768634686,  0.800798128173322,  0.013700109093084,
            0.800798128173322,  -0.971365359538638,  0.013700109093084,
            -0.971365359538638,  -0.829432768634686,  0.013700109093084,
            -0.829432768634686,  -0.971365359538638,  0.013700109093084,
            0.800798128173322,  -0.829432768634686,  0.013700109093084,
            -0.971365359538638,  0.800798128173322,  0.013700109093084;
    }
    std::vector<value_type> q;
};

/*
61
-0.333333333333333  -0.333333333333333  0.066874398581606
-0.005658918886452  -0.005658918886452  0.010186830881014
-0.005658918886452  -0.988682162227096  0.010186830881014
-0.988682162227096  -0.005658918886452  0.010186830881014
-0.035647354750750  -0.035647354750750  0.029341729055276
-0.035647354750750  -0.928705290498498  0.029341729055276
-0.928705290498498  -0.035647354750750  0.029341729055276
-0.099520061958436  -0.099520061958436  0.048701756707344
-0.099520061958436  -0.800959876083126  0.048701756707344
-0.800959876083126  -0.099520061958436  0.048701756707344
-0.199467521245206  -0.199467521245206  0.062215101737938
-0.199467521245206  -0.601064957509588  0.062215101737938
-0.601064957509588  -0.199467521245206  0.062215101737938
-0.495717464058094  -0.495717464058094  0.062514222437240
-0.495717464058094  -0.008565071883810  0.062514222437240
-0.008565071883810  -0.495717464058094  0.062514222437240
-0.675905990683078  -0.675905990683078  0.049631308679330
-0.675905990683078  0.351811981366154  0.049631308679330
0.351811981366154  -0.675905990683078  0.049631308679330
-0.848248235478508  -0.848248235478508  0.028112146141114
-0.848248235478508  0.696496470957016  0.028112146141114
0.696496470957016  -0.848248235478508  0.028112146141114
-0.968690546064356  -0.968690546064356  0.006389352347558
-0.968690546064356  0.937381092128712  0.006389352347558
0.937381092128712  -0.968690546064356  0.006389352347558
-0.331360265272684  0.310986407618846  0.016239310637986
0.310986407618846  -0.979626142346162  0.016239310637986
-0.979626142346162  -0.331360265272684  0.016239310637986
-0.331360265272684  -0.979626142346162  0.016239310637986
0.310986407618846  -0.331360265272684  0.016239310637986
-0.979626142346162  0.310986407618846  0.016239310637986
-0.415556924406112  0.144675181064040  0.053611484566326
0.144675181064040  -0.729118256657928  0.053611484566326
-0.729118256657928  -0.415556924406112  0.053611484566326
-0.415556924406112  -0.729118256657928  0.053611484566326
0.144675181064040  -0.415556924406112  0.053611484566326
-0.729118256657928  0.144675181064040  0.053611484566326
-0.360850229153620  0.252002380572456  0.036919986421644
0.252002380572456  -0.891152151418834  0.036919986421644
-0.891152151418834  -0.360850229153620  0.036919986421644
-0.360850229153620  -0.891152151418834  0.036919986421644
0.252002380572456  -0.360850229153620  0.036919986421644
-0.891152151418834  0.252002380572456  0.036919986421644
-0.618591551615416  0.592854429948142  0.016953737068656
0.592854429948142  -0.974262878332726  0.016953737068656
-0.974262878332726  -0.618591551615416  0.016953737068656
-0.618591551615416  -0.974262878332726  0.016953737068656
0.592854429948142  -0.618591551615416  0.016953737068656
-0.974262878332726  0.592854429948142  0.016953737068656
-0.639033576702508  0.504702011875458  0.036585593540050
0.504702011875458  -0.865668435172952  0.036585593540050
-0.865668435172952  -0.639033576702508  0.036585593540050
-0.639033576702508  -0.865668435172952  0.036585593540050
0.504702011875458  -0.639033576702508  0.036585593540050
-0.865668435172952  0.504702011875458  0.036585593540050
-0.838577372640872  0.809251008191216  0.013331264008330
0.809251008191216  -0.970673635550344  0.013331264008330
-0.970673635550344  -0.838577372640872  0.013331264008330
-0.838577372640872  -0.970673635550344  0.013331264008330
0.809251008191216  -0.838577372640872  0.013331264008330
-0.970673635550344  0.809251008191216  0.013331264008330
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=17
*/
template<>
struct IMTriangle<17,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 17;
    static const uint16_type nPoints = 61;
    IMTriangle()
        :
        q()
    {
        q+= -0.333333333333333,  -0.333333333333333,  0.066874398581606,
            -0.005658918886452,  -0.005658918886452,  0.010186830881014,
            -0.005658918886452,  -0.988682162227096,  0.010186830881014,
            -0.988682162227096,  -0.005658918886452,  0.010186830881014,
            -0.035647354750750,  -0.035647354750750,  0.029341729055276,
            -0.035647354750750,  -0.928705290498498,  0.029341729055276,
            -0.928705290498498,  -0.035647354750750,  0.029341729055276,
            -0.099520061958436,  -0.099520061958436,  0.048701756707344,
            -0.099520061958436,  -0.800959876083126,  0.048701756707344,
            -0.800959876083126,  -0.099520061958436,  0.048701756707344,
            -0.199467521245206,  -0.199467521245206,  0.062215101737938,
            -0.199467521245206,  -0.601064957509588,  0.062215101737938,
            -0.601064957509588,  -0.199467521245206,  0.062215101737938,
            -0.495717464058094,  -0.495717464058094,  0.062514222437240,
            -0.495717464058094,  -0.008565071883810,  0.062514222437240,
            -0.008565071883810,  -0.495717464058094,  0.062514222437240,
            -0.675905990683078,  -0.675905990683078,  0.049631308679330,
            -0.675905990683078,  0.351811981366154,  0.049631308679330,
            0.351811981366154,  -0.675905990683078,  0.049631308679330,
            -0.848248235478508,  -0.848248235478508,  0.028112146141114,
            -0.848248235478508,  0.696496470957016,  0.028112146141114,
            0.696496470957016,  -0.848248235478508,  0.028112146141114,
            -0.968690546064356,  -0.968690546064356,  0.006389352347558,
            -0.968690546064356,  0.937381092128712,  0.006389352347558,
            0.937381092128712,  -0.968690546064356,  0.006389352347558,
            -0.331360265272684,  0.310986407618846,  0.016239310637986,
            0.310986407618846,  -0.979626142346162,  0.016239310637986,
            -0.979626142346162,  -0.331360265272684,  0.016239310637986,
            -0.331360265272684,  -0.979626142346162,  0.016239310637986,
            0.310986407618846,  -0.331360265272684,  0.016239310637986,
            -0.979626142346162,  0.310986407618846,  0.016239310637986,
            -0.415556924406112,  0.144675181064040,  0.053611484566326,
            0.144675181064040,  -0.729118256657928,  0.053611484566326,
            -0.729118256657928,  -0.415556924406112,  0.053611484566326,
            -0.415556924406112,  -0.729118256657928,  0.053611484566326,
            0.144675181064040,  -0.415556924406112,  0.053611484566326,
            -0.729118256657928,  0.144675181064040,  0.053611484566326,
            -0.360850229153620,  0.252002380572456,  0.036919986421644,
            0.252002380572456,  -0.891152151418834,  0.036919986421644,
            -0.891152151418834,  -0.360850229153620,  0.036919986421644,
            -0.360850229153620,  -0.891152151418834,  0.036919986421644,
            0.252002380572456,  -0.360850229153620,  0.036919986421644,
            -0.891152151418834,  0.252002380572456,  0.036919986421644,
            -0.618591551615416,  0.592854429948142,  0.016953737068656,
            0.592854429948142,  -0.974262878332726,  0.016953737068656,
            -0.974262878332726,  -0.618591551615416,  0.016953737068656,
            -0.618591551615416,  -0.974262878332726,  0.016953737068656,
            0.592854429948142,  -0.618591551615416,  0.016953737068656,
            -0.974262878332726,  0.592854429948142,  0.016953737068656,
            -0.639033576702508,  0.504702011875458,  0.036585593540050,
            0.504702011875458,  -0.865668435172952,  0.036585593540050,
            -0.865668435172952,  -0.639033576702508,  0.036585593540050,
            -0.639033576702508,  -0.865668435172952,  0.036585593540050,
            0.504702011875458,  -0.639033576702508,  0.036585593540050,
            -0.865668435172952,  0.504702011875458,  0.036585593540050,
            -0.838577372640872,  0.809251008191216,  0.013331264008330,
            0.809251008191216,  -0.970673635550344,  0.013331264008330,
            -0.970673635550344,  -0.838577372640872,  0.013331264008330,
            -0.838577372640872,  -0.970673635550344,  0.013331264008330,
            0.809251008191216,  -0.838577372640872,  0.013331264008330,
            -0.970673635550344,  0.809251008191216,  0.013331264008330;
    }
    std::vector<value_type> q;
};

/*
70
-0.333333333333333  -0.333333333333333  0.061619879875294
-0.013310382738158  -0.013310382738158  0.018144873358808
-0.013310382738158  -0.973379234523686  0.018144873358808
-0.973379234523686  -0.013310382738158  0.018144873358808
-0.061578811516086  -0.061578811516086  0.037522633879188
-0.061578811516086  -0.876842376967828  0.037522633879188
-0.876842376967828  -0.061578811516086  0.037522633879188
-0.127437208225988  -0.127437208225988  0.038882195970954
-0.127437208225988  -0.745125583548022  0.038882195970954
-0.745125583548022  -0.127437208225988  0.038882195970954
-0.210307658653168  -0.210307658653168  0.055507897221620
-0.210307658653168  -0.579384682693664  0.055507897221620
-0.579384682693664  -0.210307658653168  0.055507897221620
-0.500410862393686  -0.500410862393686  0.064512450702914
-0.500410862393686  0.000821724787372  0.064512450702914
0.000821724787372  -0.500410862393686  0.064512450702914
-0.677135612512314  -0.677135612512314  0.050148065233844
-0.677135612512314  0.354271225024630  0.050148065233844
0.354271225024630  -0.677135612512314  0.050148065233844
-0.846803545029258  -0.846803545029258  0.030543855943664
-0.846803545029258  0.693607090058514  0.030543855943664
0.693607090058514  -0.846803545029258  0.030543855943664
-0.951495121293100  -0.951495121293100  0.013587844045926
-0.951495121293100  0.902990242586200  0.013587844045926
0.902990242586200  -0.951495121293100  0.013587844045926
-0.913707265566070  -0.913707265566070  -0.004446197459840
-0.913707265566070  0.827414531132142  -0.004446197459840
0.827414531132142  -0.913707265566070  -0.004446197459840
-0.282177010118112  0.265315937713272  0.012663828152812
0.265315937713272  -0.983138927595160  0.012663828152812
-0.983138927595160  -0.282177010118112  0.012663828152812
-0.282177010118112  -0.983138927595160  0.012663828152812
0.265315937713272  -0.282177010118112  0.012663828152812
-0.983138927595160  0.265315937713272  0.012663828152812
-0.411195046496086  0.148821943021710  0.054515076098276
0.148821943021710  -0.737626896525624  0.054515076098276
-0.737626896525624  -0.411195046496086  0.054515076098276
-0.411195046496086  -0.737626896525624  0.054515076098276
0.148821943021710  -0.411195046496086  0.054515076098276
-0.737626896525624  0.148821943021710  0.054515076098276
-0.349964396716372  0.249558093585024  0.035353571298930
0.249558093585024  -0.899593696868650  0.035353571298930
-0.899593696868650  -0.349964396716372  0.035353571298930
-0.349964396716372  -0.899593696868650  0.035353571298930
0.249558093585024  -0.349964396716372  0.035353571298930
-0.899593696868650  0.249558093585024  0.035353571298930
-0.630524880667908  0.497866353046074  0.036758969276140
0.497866353046074  -0.867341472378168  0.036758969276140
-0.867341472378168  -0.630524880667908  0.036758969276140
-0.630524880667908  -0.867341472378168  0.036758969276140
0.497866353046074  -0.630524880667908  0.036758969276140
-0.867341472378168  0.497866353046074  0.036758969276140
-0.562406399973358  0.538414010840886  0.016209465616384
0.538414010840886  -0.976007610867528  0.016209465616384
-0.976007610867528  -0.562406399973358  0.016209465616384
-0.562406399973358  -0.976007610867528  0.016209465616384
0.538414010840886  -0.562406399973358  0.016209465616384
-0.976007610867528  0.538414010840886  0.016209465616384
-0.797640805727184  0.767924604546934  0.015268258141450
0.767924604546934  -0.970283798819750  0.015268258141450
-0.970283798819750  -0.797640805727184  0.015268258141450
-0.797640805727184  -0.970283798819750  0.015268258141450
0.767924604546934  -0.797640805727184  0.015268258141450
-0.970283798819750  0.767924604546934  0.015268258141450
-0.958250489434828  1.028694520010726  0.000092375321588
1.028694520010726  -1.070444030575898  0.000092375321588
-1.070444030575898  -0.9582504894348281  0.000092375321588
-0.958250489434828  -1.070444030575898  0.000092375321588
1.028694520010726  -0.958250489434828  0.000092375321588
-1.070444030575898    1.028694520010726  0.000092375321588
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=18
*/
template<>
struct IMTriangle<18,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 18;
    static const uint16_type nPoints = 70;
    IMTriangle()
        :
        q()
    {
        q+= -0.333333333333333,  -0.333333333333333,  0.061619879875294,
            -0.013310382738158,  -0.013310382738158,  0.018144873358808,
            -0.013310382738158,  -0.973379234523686,  0.018144873358808,
            -0.973379234523686,  -0.013310382738158,  0.018144873358808,
            -0.061578811516086,  -0.061578811516086,  0.037522633879188,
            -0.061578811516086,  -0.876842376967828,  0.037522633879188,
            -0.876842376967828,  -0.061578811516086,  0.037522633879188,
            -0.127437208225988,  -0.127437208225988,  0.038882195970954,
            -0.127437208225988,  -0.745125583548022,  0.038882195970954,
            -0.745125583548022,  -0.127437208225988,  0.038882195970954,
            -0.210307658653168,  -0.210307658653168,  0.055507897221620,
            -0.210307658653168,  -0.579384682693664,  0.055507897221620,
            -0.579384682693664,  -0.210307658653168,  0.055507897221620,
            -0.500410862393686,  -0.500410862393686,  0.064512450702914,
            -0.500410862393686,  0.000821724787372,  0.064512450702914,
            0.000821724787372,  -0.500410862393686,  0.064512450702914,
            -0.677135612512314,  -0.677135612512314,  0.050148065233844,
            -0.677135612512314,  0.354271225024630,  0.050148065233844,
            0.354271225024630,  -0.677135612512314,  0.050148065233844,
            -0.846803545029258,  -0.846803545029258,  0.030543855943664,
            -0.846803545029258,  0.693607090058514,  0.030543855943664,
            0.693607090058514,  -0.846803545029258,  0.030543855943664,
            -0.951495121293100,  -0.951495121293100,  0.013587844045926,
            -0.951495121293100,  0.902990242586200,  0.013587844045926,
            0.902990242586200,  -0.951495121293100,  0.013587844045926,
            -0.913707265566070,  -0.913707265566070,  -0.004446197459840,
            -0.913707265566070,  0.827414531132142,  -0.004446197459840,
            0.827414531132142,  -0.913707265566070,  -0.004446197459840,
            -0.282177010118112,  0.265315937713272,  0.012663828152812,
            0.265315937713272,  -0.983138927595160,  0.012663828152812,
            -0.983138927595160,  -0.282177010118112,  0.012663828152812,
            -0.282177010118112,  -0.983138927595160,  0.012663828152812,
            0.265315937713272,  -0.282177010118112,  0.012663828152812,
            -0.983138927595160,  0.265315937713272,  0.012663828152812,
            -0.411195046496086,  0.148821943021710,  0.054515076098276,
            0.148821943021710,  -0.737626896525624,  0.054515076098276,
            -0.737626896525624,  -0.411195046496086,  0.054515076098276,
            -0.411195046496086,  -0.737626896525624,  0.054515076098276,
            0.148821943021710,  -0.411195046496086,  0.054515076098276,
            -0.737626896525624,  0.148821943021710,  0.054515076098276,
            -0.349964396716372,  0.249558093585024,  0.035353571298930,
            0.249558093585024,  -0.899593696868650,  0.035353571298930,
            -0.899593696868650,  -0.349964396716372,  0.035353571298930,
            -0.349964396716372,  -0.899593696868650,  0.035353571298930,
            0.249558093585024,  -0.349964396716372,  0.035353571298930,
            -0.899593696868650,  0.249558093585024,  0.035353571298930,
            -0.630524880667908,  0.497866353046074,  0.036758969276140,
            0.497866353046074,  -0.867341472378168,  0.036758969276140,
            -0.867341472378168,  -0.630524880667908,  0.036758969276140,
            -0.630524880667908,  -0.867341472378168,  0.036758969276140,
            0.497866353046074,  -0.630524880667908,  0.036758969276140,
            -0.867341472378168,  0.497866353046074,  0.036758969276140,
            -0.562406399973358,  0.538414010840886,  0.016209465616384,
            0.538414010840886,  -0.976007610867528,  0.016209465616384,
            -0.976007610867528,  -0.562406399973358,  0.016209465616384,
            -0.562406399973358,  -0.976007610867528,  0.016209465616384,
            0.538414010840886,  -0.562406399973358,  0.016209465616384,
            -0.976007610867528,  0.538414010840886,  0.016209465616384,
            -0.797640805727184,  0.767924604546934,  0.015268258141450,
            0.767924604546934,  -0.970283798819750,  0.015268258141450,
            -0.970283798819750,  -0.797640805727184,  0.015268258141450,
            -0.797640805727184,  -0.970283798819750,  0.015268258141450,
            0.767924604546934,  -0.797640805727184,  0.015268258141450,
            -0.970283798819750,  0.767924604546934,  0.015268258141450,
            -0.958250489434828,  1.028694520010726,  0.000092375321588,
            1.028694520010726,  -1.070444030575898,  0.000092375321588,
            -1.070444030575898,  -0.9582504894348281,  0.000092375321588,
            -0.958250489434828,  -1.070444030575898,  0.000092375321588,
            1.028694520010726,  -0.958250489434828,  0.000092375321588,
            -1.070444030575898,    1.028694520010726,  0.000092375321588;

    }
    std::vector<value_type> q;
};
/*
73
-0.333333333333333  -0.333333333333333  0.065812662777838
-0.020780025853988  -0.020780025853988  0.020661463782544
-0.020780025853988  -0.958439948292026  0.020661463782544
-0.958439948292026  -0.020780025853988  0.020661463782544
-0.090926214604214  -0.090926214604214  0.044774494526032
-0.090926214604214  -0.818147570791570  0.044774494526032
-0.818147570791570  -0.090926214604214  0.044774494526032
-0.197166638701138  -0.197166638701138  0.060532251738936
-0.197166638701138  -0.605666722597724  0.060532251738936
-0.605666722597724  -0.197166638701138  0.060532251738936
-0.488896691193804  -0.488896691193804  0.060981935604396
-0.488896691193804  -0.022206617612390  0.060981935604396
-0.022206617612390  -0.488896691193804  0.060981935604396
-0.645844115695740  -0.645844115695740  0.048318425483282
-0.645844115695740  0.291688231391482  0.048318425483282
0.291688231391482  -0.645844115695740  0.048318425483282
-0.779877893544096  -0.779877893544096  0.032101607173602
-0.779877893544096  0.559755787088192  0.032101607173602
0.559755787088192  -0.779877893544096  0.032101607173602
-0.888942751496320  -0.888942751496320  0.016169160523568
-0.888942751496320  0.777885502992642  0.016169160523568
0.777885502992642  -0.888942751496320  0.016169160523568
-0.974756272445542  -0.974756272445542  0.004158724054970
-0.974756272445542  0.949512544891086  0.004158724054970
0.949512544891086  -0.974756272445542  0.004158724054970
-0.208490425286114  0.201267589589290  0.007769753809962
0.201267589589290  -0.992777164303176  0.007769753809962
-0.992777164303176  -0.208490425286114  0.007769753809962
-0.208490425286114  -0.992777164303176  0.007769753809962
0.201267589589290  -0.208490425286114  0.007769753809962
-0.992777164303176  0.201267589589286  0.007769753809962
-0.384140032239128  0.115206523177568  0.051148321224044
0.115206523177568  -0.731066490938440  0.051148321224044
-0.731066490938440  -0.384140032239128  0.051148321224044
-0.384140032239128  -0.731066490938440  0.051148321224044
0.115206523177568  -0.384140032239128  0.051148321224044
-0.731066490938440  0.115206523177568  0.051148321224044
-0.470866103186960  0.441974051634730  0.017761807146676
0.441974051634730  -0.971107948447770  0.017761807146676
-0.971107948447770  -0.470866103186960  0.017761807146676
-0.470866103186960  -0.971107948447770  0.017761807146676
0.441974051634730  -0.470866103186960  0.017761807146676
-0.971107948447770  0.441974051634730  0.017761807146676
-0.282921295588098  0.189054137911742  0.032249093523462
0.189054137911742  -0.906132842323644  0.032249093523462
-0.906132842323644  -0.282921295588098  0.032249093523462
-0.282921295588098  -0.906132842323644  0.032249093523462
0.189054137911742  -0.282921295588098  0.032249093523462
-0.906132842323644  0.189054137911742  0.032249093523462
-0.684385188062810  0.678662947361678  0.004983883634982
0.678662947361678  -0.994277759298866  0.004983883634982
-0.994277759298866  -0.684385188062810  0.004983883634982
-0.684385188062810  -0.994277759298866  0.004983883634982
0.678662947361678  -0.684385188062810  0.004983883634982
-0.994277759298866  0.678662947361678  0.004983883634982
-0.849898806048178  0.402175957852346  0.036485680237902
0.402175957852346  -0.552277151804168  0.036485680237902
-0.552277151804168  -0.849898806048178  0.036485680237902
-0.849898806048178  -0.552277151804168  0.036485680237902
0.402175957852346  -0.849898806048178  0.036485680237902
-0.552277151804168  0.402175957852346  0.036485680237902
-0.715156797773234  0.645862648139714  0.020517127472398
0.645862648139714  -0.930705850366480  0.020517127472398
-0.930705850366480  -0.715156797773234  0.020517127472398
-0.715156797773234  -0.930705850366480  0.020517127472398
0.645862648139714  -0.715156797773234  0.020517127472398
-0.930705850366480  0.645862648139714  0.020517127472398
-0.869010743834124  0.848688505241568  0.007599857710604
0.848688505241568  -0.979677761407444  0.007599857710604
-0.979677761407444  -0.869010743834124  0.007599857710604
-0.869010743834124  -0.979677761407444  0.007599857710604
0.848688505241568  -0.869010743834124  0.007599857710604
-0.979677761407444  0.848688505241568  0.007599857710604
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=19
*/
template<>
struct IMTriangle<19,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 19;
    static const uint16_type nPoints = 73;
    IMTriangle()
        :
        q()
    {
        q+=-0.333333333333333,  -0.333333333333333,  0.065812662777838,
            -0.020780025853988,  -0.020780025853988,  0.020661463782544,
            -0.020780025853988,  -0.958439948292026,  0.020661463782544,
            -0.958439948292026,  -0.020780025853988,  0.020661463782544,
            -0.090926214604214,  -0.090926214604214,  0.044774494526032,
            -0.090926214604214,  -0.818147570791570,  0.044774494526032,
            -0.818147570791570,  -0.090926214604214,  0.044774494526032,
            -0.197166638701138,  -0.197166638701138,  0.060532251738936,
            -0.197166638701138,  -0.605666722597724,  0.060532251738936,
            -0.605666722597724,  -0.197166638701138,  0.060532251738936,
            -0.488896691193804,  -0.488896691193804,  0.060981935604396,
            -0.488896691193804,  -0.022206617612390,  0.060981935604396,
            -0.022206617612390,  -0.488896691193804,  0.060981935604396,
            -0.645844115695740,  -0.645844115695740,  0.048318425483282,
            -0.645844115695740,  0.291688231391482,  0.048318425483282,
            0.291688231391482,  -0.645844115695740,  0.048318425483282,
            -0.779877893544096,  -0.779877893544096,  0.032101607173602,
            -0.779877893544096,  0.559755787088192,  0.032101607173602,
            0.559755787088192,  -0.779877893544096,  0.032101607173602,
            -0.888942751496320,  -0.888942751496320,  0.016169160523568,
            -0.888942751496320,  0.777885502992642,  0.016169160523568,
            0.777885502992642,  -0.888942751496320,  0.016169160523568,
            -0.974756272445542,  -0.974756272445542,  0.004158724054970,
            -0.974756272445542,  0.949512544891086,  0.004158724054970,
            0.949512544891086,  -0.974756272445542,  0.004158724054970,
            -0.208490425286114,  0.201267589589290,  0.007769753809962,
            0.201267589589290,  -0.992777164303176,  0.007769753809962,
            -0.992777164303176,  -0.208490425286114,  0.007769753809962,
            -0.208490425286114,  -0.992777164303176,  0.007769753809962,
            0.201267589589290,  -0.208490425286114,  0.007769753809962,
            -0.992777164303176,  0.201267589589286,  0.007769753809962,
            -0.384140032239128,  0.115206523177568,  0.051148321224044,
            0.115206523177568,  -0.731066490938440,  0.051148321224044,
            -0.731066490938440,  -0.384140032239128,  0.051148321224044,
            -0.384140032239128,  -0.731066490938440,  0.051148321224044,
            0.115206523177568,  -0.384140032239128,  0.051148321224044,
            -0.731066490938440,  0.115206523177568,  0.051148321224044,
            -0.470866103186960,  0.441974051634730,  0.017761807146676,
            0.441974051634730,  -0.971107948447770,  0.017761807146676,
            -0.971107948447770,  -0.470866103186960,  0.017761807146676,
            -0.470866103186960,  -0.971107948447770,  0.017761807146676,
            0.441974051634730,  -0.470866103186960,  0.017761807146676,
            -0.971107948447770,  0.441974051634730,  0.017761807146676,
            -0.282921295588098,  0.189054137911742,  0.032249093523462,
            0.189054137911742,  -0.906132842323644,  0.032249093523462,
            -0.906132842323644,  -0.282921295588098,  0.032249093523462,
            -0.282921295588098,  -0.906132842323644,  0.032249093523462,
            0.189054137911742,  -0.282921295588098,  0.032249093523462,
            -0.906132842323644,  0.189054137911742,  0.032249093523462,
            -0.684385188062810,  0.678662947361678,  0.004983883634982,
            0.678662947361678,  -0.994277759298866,  0.004983883634982,
            -0.994277759298866,  -0.684385188062810,  0.004983883634982,
            -0.684385188062810,  -0.994277759298866,  0.004983883634982,
            0.678662947361678,  -0.684385188062810,  0.004983883634982,
            -0.994277759298866,  0.678662947361678,  0.004983883634982,
            -0.849898806048178,  0.402175957852346,  0.036485680237902,
            0.402175957852346,  -0.552277151804168,  0.036485680237902,
            -0.552277151804168,  -0.849898806048178,  0.036485680237902,
            -0.849898806048178,  -0.552277151804168,  0.036485680237902,
            0.402175957852346,  -0.849898806048178,  0.036485680237902,
            -0.552277151804168,  0.402175957852346,  0.036485680237902,
            -0.715156797773234,  0.645862648139714,  0.020517127472398,
            0.645862648139714,  -0.930705850366480,  0.020517127472398,
            -0.930705850366480,  -0.715156797773234,  0.020517127472398,
            -0.715156797773234,  -0.930705850366480,  0.020517127472398,
            0.645862648139714,  -0.715156797773234,  0.020517127472398,
            -0.930705850366480,  0.645862648139714,  0.020517127472398,
            -0.869010743834124,  0.848688505241568,  0.007599857710604,
            0.848688505241568,  -0.979677761407444,  0.007599857710604,
            -0.979677761407444,  -0.869010743834124,  0.007599857710604,
            -0.869010743834124,  -0.979677761407444,  0.007599857710604,
            0.848688505241568,  -0.869010743834124,  0.007599857710604,
            -0.979677761407444,  0.848688505241568,  0.007599857710604;
    }
    std::vector<value_type> q;
};
/*
79
-0.333333333333333  -0.333333333333333  0.066114111083248
0.001900928704400  0.001900928704400  0.001734038371326
0.001900928704400  -1.003801857408800  0.001734038371326
-1.003801857408800  0.001900928704400  0.001734038371326
-0.023574084130543  -0.023574084130543  0.023320105432896
-0.023574084130543  -0.952851831738914  0.023320105432896
-0.952851831738914  -0.023574084130543  0.023320105432896
-0.089726626099435  -0.089726626099435  0.045753872712842
-0.089726626099435  -0.820546727801130  0.045753872712842
-0.820546727801130  -0.089726626099435  0.045753872712842
-0.196007481363421  -0.196007481363421  0.060897965347876
-0.196007481363421  -0.607985037273158  0.060897965347876
-0.607985037273158  -0.196007481363421  0.060897965347876
-0.488214180481157  -0.488214180481157  0.061249783450710
-0.488214180481157  -0.023571639037686  0.061249783450710
-0.023571639037686  -0.488214180481157  0.061249783450710
-0.647023488009788  -0.647023488009788  0.048736115353600
-0.647023488009788  0.294046976019576  0.048736115353600
0.294046976019576  -0.647023488009788  0.048736115353600
-0.791658289326483  -0.791658289326483  0.031994864064048
-0.791658289326483  0.583316578652966  0.031994864064048
0.583316578652966  -0.791658289326483  0.031994864064048
-0.893862072318140  -0.893862072318140  0.015396603631204
-0.893862072318140  0.787724144636280  0.015396603631204
0.787724144636280  -0.893862072318140  0.015396603631204
-0.916762569607942  -0.916762569607942  -0.001264120994976
-0.916762569607942  0.833525139215884  -0.001264120994976
0.833525139215884  -0.916762569607942  -0.001264120994976
-0.976836157186356  -0.976836157186356  0.003502268602386
-0.976836157186356  0.953672314372712  0.003502268602386
0.953672314372712  -0.976836157186356  0.003502268602386
-0.310288459541998  0.212805292212320  0.032931678379152
0.212805292212320  -0.902516832670322  0.032931678379152
-0.902516832670322  -0.310288459541998  0.032931678379152
-0.310288459541998  -0.902516832670322  0.032931678379152
0.212805292212320  -0.310288459541998  0.032931678379152
-0.902516832670322  0.212805292212320  0.032931678379152
-0.244313460810292  0.231685228913082  0.009678067080970
0.231685228913082  -0.987371768102790  0.009678067080970
-0.987371768102790  -0.244313460810292  0.009678067080970
-0.244313460810292  -0.987371768102790  0.009678067080970
0.231685228913082  -0.244313460810292  0.009678067080970
-0.987371768102790  0.231685228913082  0.009678067080970
-0.386729041875286  0.118096000780590  0.051609813069300
0.118096000780590  -0.731366958905304  0.051609813069300
-0.731366958905304  -0.386729041875286  0.051609813069300
-0.386729041875286  -0.731366958905304  0.051609813069300
0.118096000780590  -0.386729041875286  0.051609813069300
-0.731366958905304  0.118096000780590  0.051609813069300
-0.501161274450516  0.473213486525732  0.016942182108882
0.473213486525732  -0.972052212075216  0.016942182108882
-0.972052212075216  -0.501161274450516  0.016942182108882
-0.501161274450516  -0.972052212075216  0.016942182108882
0.473213486525732  -0.501161274450516  0.016942182108882
-0.972052212075216  0.473213486525732  0.016942182108882
-0.574448550394396  0.423350284574868  0.036709828212560
0.423350284574868  -0.848901734180472  0.036709828212560
-0.848901734180472  -0.574448550394396  0.036709828212560
-0.574448550394396  -0.848901734180472  0.036709828212560
0.423350284574868  -0.574448550394396  0.036709828212560
-0.848901734180472  0.423350284574868  0.036709828212560
-0.706069127893522  0.722805434309974  0.001408809355816
0.722805434309974  -1.016736306416454  0.001408809355816
-1.016736306416454  -0.706069127893522  0.001408809355816
-0.706069127893522  -1.016736306416454  0.001408809355816
0.722805434309974  -0.706069127893522  0.001408809355816
-1.016736306416454  0.722805434309974  0.001408809355816
-0.724546042342154  0.671173915824726  0.020225369854924
0.671173915824726  -0.946627873482572  0.020225369854924
-0.946627873482572  -0.724546042342154  0.020225369854924
-0.724546042342154  -0.946627873482572  0.020225369854924
0.671173915824726  -0.724546042342154  0.020225369854924
-0.946627873482572  0.671173915824726  0.020225369854924
-0.880607781701986  0.859512343113706  0.007147818771900
0.859512343113706  -0.978904561411718  0.007147818771900
-0.978904561411718  -0.880607781701986  0.007147818771900
-0.880607781701986  -0.978904561411718  0.007147818771900
0.859512343113706  -0.880607781701986  0.007147818771900
-0.978904561411718  0.859512343113706  0.007147818771900
  Gauss  quadrature  points  and  weights  on  the  reference  triangle  order  p=20

 */
template<>
struct IMTriangle<20,double>
{
    typedef double value_type;
    static const uint16_type nDim = 2;
    static const uint16_type nOrder = 20;
    static const uint16_type nPoints = 79;
    IMTriangle()
        :
        q()
    {
        q+= -0.333333333333333,  -0.333333333333333,  0.066114111083248,
            0.001900928704400,  0.001900928704400,  0.001734038371326,
            0.001900928704400,  -1.003801857408800,  0.001734038371326,
            -1.003801857408800,  0.001900928704400,  0.001734038371326,
            -0.023574084130543,  -0.023574084130543,  0.023320105432896,
            -0.023574084130543,  -0.952851831738914,  0.023320105432896,
            -0.952851831738914,  -0.023574084130543,  0.023320105432896,
            -0.089726626099435,  -0.089726626099435,  0.045753872712842,
            -0.089726626099435,  -0.820546727801130,  0.045753872712842,
            -0.820546727801130,  -0.089726626099435,  0.045753872712842,
            -0.196007481363421,  -0.196007481363421,  0.060897965347876,
            -0.196007481363421,  -0.607985037273158,  0.060897965347876,
            -0.607985037273158,  -0.196007481363421,  0.060897965347876,
            -0.488214180481157,  -0.488214180481157,  0.061249783450710,
            -0.488214180481157,  -0.023571639037686,  0.061249783450710,
            -0.023571639037686,  -0.488214180481157,  0.061249783450710,
            -0.647023488009788,  -0.647023488009788,  0.048736115353600,
            -0.647023488009788,  0.294046976019576,  0.048736115353600,
            0.294046976019576,  -0.647023488009788,  0.048736115353600,
            -0.791658289326483,  -0.791658289326483,  0.031994864064048,
            -0.791658289326483,  0.583316578652966,  0.031994864064048,
            0.583316578652966,  -0.791658289326483,  0.031994864064048,
            -0.893862072318140,  -0.893862072318140,  0.015396603631204,
            -0.893862072318140,  0.787724144636280,  0.015396603631204,
            0.787724144636280,  -0.893862072318140,  0.015396603631204,
            -0.916762569607942,  -0.916762569607942,  -0.001264120994976,
            -0.916762569607942,  0.833525139215884,  -0.001264120994976,
            0.833525139215884,  -0.916762569607942,  -0.001264120994976,
            -0.976836157186356,  -0.976836157186356,  0.003502268602386,
            -0.976836157186356,  0.953672314372712,  0.003502268602386,
            0.953672314372712,  -0.976836157186356,  0.003502268602386,
            -0.310288459541998,  0.212805292212320,  0.032931678379152,
            0.212805292212320,  -0.902516832670322,  0.032931678379152,
            -0.902516832670322,  -0.310288459541998,  0.032931678379152,
            -0.310288459541998,  -0.902516832670322,  0.032931678379152,
            0.212805292212320,  -0.310288459541998,  0.032931678379152,
            -0.902516832670322,  0.212805292212320,  0.032931678379152,
            -0.244313460810292,  0.231685228913082,  0.009678067080970,
            0.231685228913082,  -0.987371768102790,  0.009678067080970,
            -0.987371768102790,  -0.244313460810292,  0.009678067080970,
            -0.244313460810292,  -0.987371768102790,  0.009678067080970,
            0.231685228913082,  -0.244313460810292,  0.009678067080970,
            -0.987371768102790,  0.231685228913082,  0.009678067080970,
            -0.386729041875286,  0.118096000780590,  0.051609813069300,
            0.118096000780590,  -0.731366958905304,  0.051609813069300,
            -0.731366958905304,  -0.386729041875286,  0.051609813069300,
            -0.386729041875286,  -0.731366958905304,  0.051609813069300,
            0.118096000780590,  -0.386729041875286,  0.051609813069300,
            -0.731366958905304,  0.118096000780590,  0.051609813069300,
            -0.501161274450516,  0.473213486525732,  0.016942182108882,
            0.473213486525732,  -0.972052212075216,  0.016942182108882,
            -0.972052212075216,  -0.501161274450516,  0.016942182108882,
            -0.501161274450516,  -0.972052212075216,  0.016942182108882,
            0.473213486525732,  -0.501161274450516,  0.016942182108882,
            -0.972052212075216,  0.473213486525732,  0.016942182108882,
            -0.574448550394396,  0.423350284574868,  0.036709828212560,
            0.423350284574868,  -0.848901734180472,  0.036709828212560,
            -0.848901734180472,  -0.574448550394396,  0.036709828212560,
            -0.574448550394396,  -0.848901734180472,  0.036709828212560,
            0.423350284574868,  -0.574448550394396,  0.036709828212560,
            -0.848901734180472,  0.423350284574868,  0.036709828212560,
            -0.706069127893522,  0.722805434309974,  0.001408809355816,
            0.722805434309974,  -1.016736306416454,  0.001408809355816,
            -1.016736306416454,  -0.706069127893522,  0.001408809355816,
            -0.706069127893522,  -1.016736306416454,  0.001408809355816,
            0.722805434309974,  -0.706069127893522,  0.001408809355816,
            -1.016736306416454,  0.722805434309974,  0.001408809355816,
            -0.724546042342154,  0.671173915824726,  0.020225369854924,
            0.671173915824726,  -0.946627873482572,  0.020225369854924,
            -0.946627873482572,  -0.724546042342154,  0.020225369854924,
            -0.724546042342154,  -0.946627873482572,  0.020225369854924,
            0.671173915824726,  -0.724546042342154,  0.020225369854924,
            -0.946627873482572,  0.671173915824726,  0.020225369854924,
            -0.880607781701986,  0.859512343113706,  0.007147818771900,
            0.859512343113706,  -0.978904561411718,  0.007147818771900,
            -0.978904561411718,  -0.880607781701986,  0.007147818771900,
            -0.880607781701986,  -0.978904561411718,  0.007147818771900,
            0.859512343113706,  -0.880607781701986,  0.007147818771900,
            -0.978904561411718,  0.859512343113706,  0.007147818771900;
    }
    std::vector<value_type> q;
};


/// \endcond

/**
 * \internal
 * \class IMTetrahedra
 */
template<int Order, typename T>
struct IMTetrahedra
{
};

/**
 *
 1
 -0.500000000000000  -0.500000000000000  -0.500000000000000  1.333333333333333
 Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=1
*/
template<typename T>
struct IMTetrahedra<1,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 1;
    static const uint16_type nPoints = 1;

    IMTetrahedra()
        :
        q ()
    {
        q += -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  1.333333333333333;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<0,T> : public IMTetrahedra<1,T> {};
/*
  4
  -0.723606797749979  -0.723606797749979  -0.723606797749979  0.333333333333333
  0.170820393249937  -0.723606797749979  -0.723606797749979  0.333333333333333
  -0.723606797749979  0.170820393249937  -0.723606797749979  0.333333333333333
  -0.723606797749979  -0.723606797749979  0.170820393249937  0.333333333333333
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=2
 */
template<typename T>
struct IMTetrahedra<2,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 2;
    static const uint16_type nPoints = 4;
    IMTetrahedra()
        :
        q()
    {
        q +=
            -0.723606797749979, -0.723606797749979, -0.723606797749979, 0.333333333333333,
            0.170820393249937, -0.723606797749979, -0.723606797749979, 0.333333333333333,
            -0.723606797749979, 0.170820393249937, -0.723606797749979, 0.333333333333333,
            -0.723606797749979, -0.723606797749979, 0.170820393249937, 0.333333333333333;
    }

    std::vector<value_type> q;
};

/*
  5
  -0.500000000000000  -0.500000000000000  -0.500000000000000  -1.066666666666667
  -0.666666666666667  -0.666666666666667  -0.666666666666667  0.600000000000000
  -0.666666666666667  -0.666666666666667  0.000000000000000  0.600000000000000
  -0.666666666666667  0.000000000000000  -0.666666666666667  0.600000000000000
  0.000000000000000  -0.666666666666667  -0.666666666666667  0.600000000000000
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=3
 */
template<typename T>
struct IMTetrahedra<3,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 3;
    static const uint16_type nPoints = 5;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.500000000000000  , -0.500000000000000  , -0.500000000000000  , -1.066666666666667,
            -0.666666666666667  , -0.666666666666667  , -0.666666666666667  , 0.600000000000000,
            -0.666666666666667  , -0.666666666666667  , 0.000000000000000  , 0.600000000000000,
            -0.666666666666667  , 0.000000000000000  , -0.666666666666667  , 0.600000000000000,
            0.000000000000000  , -0.666666666666667  , -0.666666666666667  , 0.600000000000000;
    }

    std::vector<value_type> q;
};
/*
  11
  -0.500000000000000  -0.500000000000000  -0.500000000000000  -0.105244444444444
  -0.857142857142857  -0.857142857142857  -0.857142857142857  0.060977777777778
  -0.857142857142857  -0.857142857142857  0.571428571428571  0.060977777777778
  -0.857142857142857  0.571428571428571  -0.857142857142857  0.060977777777778
  0.571428571428571  -0.857142857142857  -0.857142857142857  0.060977777777778
  -0.201192847666402  -0.201192847666402  -0.798807152333598  0.199111111111111
  -0.201192847666402  -0.798807152333598  -0.201192847666402  0.199111111111111
  -0.798807152333598  -0.201192847666402  -0.201192847666402  0.199111111111111
  -0.201192847666402  -0.798807152333598  -0.798807152333598  0.199111111111111
  -0.798807152333598  -0.201192847666402  -0.798807152333598  0.199111111111111
  -0.798807152333598  -0.798807152333598  -0.201192847666402  0.199111111111111
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=4
*/
template<typename T> struct IMTetrahedra<4,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 4;
    static const uint16_type nPoints = 11;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.105244444444444,
            -0.857142857142857,  -0.857142857142857,  -0.857142857142857,  0.060977777777778,
            -0.857142857142857,  -0.857142857142857,  0.571428571428571,  0.060977777777778,
            -0.857142857142857,  0.571428571428571,  -0.857142857142857,  0.060977777777778,
            0.571428571428571,  -0.857142857142857,  -0.857142857142857,  0.060977777777778,
            -0.201192847666402,  -0.201192847666402,  -0.798807152333598,  0.199111111111111,
            -0.201192847666402,  -0.798807152333598,  -0.201192847666402,  0.199111111111111,
            -0.798807152333598,  -0.201192847666402,  -0.201192847666402,  0.199111111111111,
            -0.201192847666402,  -0.798807152333598,  -0.798807152333598,  0.199111111111111,
            -0.798807152333598,  -0.201192847666402,  -0.798807152333598,  0.199111111111111,
            -0.798807152333598,  -0.798807152333598,  -0.201192847666402,  0.199111111111111;
    }

    std::vector<value_type> q;
};
/*
  14
  -0.814529499378218  -0.814529499378218  -0.814529499378218  0.097990724155149
0.443588498134653  -0.814529499378218  -0.814529499378218  0.097990724155149
-0.814529499378218  0.443588498134653  -0.814529499378218  0.097990724155149
-0.814529499378218  -0.814529499378218  0.443588498134653  0.097990724155149
-0.378228161473399  -0.378228161473399  -0.378228161473399  0.150250567624021
-0.865315515579804  -0.378228161473399  -0.378228161473399  0.150250567624021
-0.378228161473399  -0.865315515579804  -0.378228161473399  0.150250567624021
-0.378228161473399  -0.378228161473399  -0.865315515579804  0.150250567624021
-0.091007408251299  -0.091007408251299  -0.908992591748701  0.056728027702775
-0.091007408251299  -0.908992591748701  -0.091007408251299  0.056728027702775
-0.908992591748701  -0.091007408251299  -0.091007408251299  0.056728027702775
-0.091007408251299  -0.908992591748701  -0.908992591748701  0.056728027702775
-0.908992591748701  -0.091007408251299  -0.908992591748701  0.056728027702775
-0.908992591748701  -0.908992591748701  -0.091007408251299  0.056728027702775
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=5
*/
template<typename T> struct IMTetrahedra<5,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 5;
    static const uint16_type nPoints = 14;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.814529499378218,  -0.814529499378218,  -0.814529499378218,  0.097990724155149,
            0.443588498134653,  -0.814529499378218,  -0.814529499378218,  0.097990724155149,
            -0.814529499378218,  0.443588498134653,  -0.814529499378218,  0.097990724155149,
            -0.814529499378218,  -0.814529499378218,  0.443588498134653,  0.097990724155149,
            -0.378228161473399,  -0.378228161473399,  -0.378228161473399,  0.150250567624021,
            -0.865315515579804,  -0.378228161473399,  -0.378228161473399,  0.150250567624021,
            -0.378228161473399,  -0.865315515579804,  -0.378228161473399,  0.150250567624021,
            -0.378228161473399,  -0.378228161473399,  -0.865315515579804,  0.150250567624021,
            -0.091007408251299,  -0.091007408251299,  -0.908992591748701,  0.056728027702775,
            -0.091007408251299,  -0.908992591748701,  -0.091007408251299,  0.056728027702775,
            -0.908992591748701,  -0.091007408251299,  -0.091007408251299,  0.056728027702775,
            -0.091007408251299,  -0.908992591748701,  -0.908992591748701,  0.056728027702775,
            -0.908992591748701,  -0.091007408251299,  -0.908992591748701,  0.056728027702775,
            -0.908992591748701,  -0.908992591748701,  -0.091007408251299,  0.056728027702775;
    }

    std::vector<value_type> q;
};
/*
  24
  -0.570794257481696  -0.570794257481696  -0.570794257481696  0.053230333677557
  -0.287617227554912  -0.570794257481696  -0.570794257481696  0.053230333677557
  -0.570794257481696  -0.287617227554912  -0.570794257481696  0.053230333677557
  -0.570794257481696  -0.570794257481696  -0.287617227554912  0.053230333677557
  -0.918652082930777  -0.918652082930777  -0.918652082930777  0.013436281407094
  0.755956248792332  -0.918652082930777  -0.918652082930777  0.013436281407094
  -0.918652082930777  0.755956248792332  -0.918652082930777  0.013436281407094
  -0.918652082930777  -0.918652082930777  0.755956248792332  0.013436281407094
  -0.355324219715449  -0.355324219715449  -0.355324219715449  0.073809575391540
  -0.934027340853653  -0.355324219715449  -0.355324219715449  0.073809575391540
  -0.355324219715449  -0.934027340853653  -0.355324219715449  0.073809575391540
  -0.355324219715449  -0.355324219715449  -0.934027340853653  0.073809575391540
  -0.872677996249965  -0.872677996249965  -0.460655337083368  0.064285714285714
  -0.872677996249965  -0.460655337083368  -0.872677996249965  0.064285714285714
  -0.872677996249965  -0.872677996249965  0.206011329583298  0.064285714285714
  -0.872677996249965  0.206011329583298  -0.872677996249965  0.064285714285714
  -0.872677996249965  -0.460655337083368  0.206011329583298  0.064285714285714
  -0.872677996249965  0.206011329583298  -0.460655337083368  0.064285714285714
  -0.460655337083368  -0.872677996249965  -0.872677996249965  0.064285714285714
  -0.460655337083368  -0.872677996249965  0.206011329583298  0.064285714285714
  -0.460655337083368  0.206011329583298  -0.872677996249965  0.064285714285714
  0.206011329583298  -0.872677996249965  -0.460655337083368  0.064285714285714
  0.206011329583298  -0.872677996249965  -0.872677996249965  0.064285714285714
  0.206011329583298  -0.460655337083368  -0.872677996249965  0.064285714285714
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=6

 */
template<typename T>
struct IMTetrahedra<6,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 6;
    static const uint16_type nPoints = 24;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.570794257481696,  -0.570794257481696,  -0.570794257481696,  0.053230333677557,
            -0.287617227554912,  -0.570794257481696,  -0.570794257481696,  0.053230333677557,
            -0.570794257481696,  -0.287617227554912,  -0.570794257481696,  0.053230333677557,
            -0.570794257481696,  -0.570794257481696,  -0.287617227554912,  0.053230333677557,
            -0.918652082930777,  -0.918652082930777,  -0.918652082930777,  0.013436281407094,
            0.755956248792332,  -0.918652082930777,  -0.918652082930777,  0.013436281407094,
            -0.918652082930777,  0.755956248792332,  -0.918652082930777,  0.013436281407094,
            -0.918652082930777,  -0.918652082930777,  0.755956248792332,  0.013436281407094,
            -0.355324219715449,  -0.355324219715449,  -0.355324219715449,  0.073809575391540,
            -0.934027340853653,  -0.355324219715449,  -0.355324219715449,  0.073809575391540,
            -0.355324219715449,  -0.934027340853653,  -0.355324219715449,  0.073809575391540,
            -0.355324219715449,  -0.355324219715449,  -0.934027340853653,  0.073809575391540,
            -0.872677996249965,  -0.872677996249965,  -0.460655337083368,  0.064285714285714,
            -0.872677996249965,  -0.460655337083368,  -0.872677996249965,  0.064285714285714,
            -0.872677996249965,  -0.872677996249965,  0.206011329583298,  0.064285714285714,
            -0.872677996249965,  0.206011329583298,  -0.872677996249965,  0.064285714285714,
            -0.872677996249965,  -0.460655337083368,  0.206011329583298,  0.064285714285714,
            -0.872677996249965,  0.206011329583298,  -0.460655337083368,  0.064285714285714,
            -0.460655337083368,  -0.872677996249965,  -0.872677996249965,  0.064285714285714,
            -0.460655337083368,  -0.872677996249965,  0.206011329583298,  0.064285714285714,
            -0.460655337083368,  0.206011329583298,  -0.872677996249965,  0.064285714285714,
            0.206011329583298,  -0.872677996249965,  -0.460655337083368,  0.064285714285714,
            0.206011329583298,  -0.872677996249965,  -0.872677996249965,  0.064285714285714,
            0.206011329583298,  -0.460655337083368,  -0.872677996249965,  0.064285714285714;
    }

    std::vector<value_type> q;
};

/*
31
0.000000000000000  0.000000000000000  -1.000000000000000  0.007760141093474
0.000000000000000  -1.000000000000000  0.000000000000000  0.007760141093474
-1.000000000000000  0.000000000000000  0.000000000000000  0.007760141093474
-1.000000000000000  -1.000000000000000  0.000000000000000  0.007760141093474
-1.000000000000000  0.000000000000000  -1.000000000000000  0.007760141093474
0.000000000000000  -1.000000000000000  -1.000000000000000  0.007760141093474
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.146113787728871
-0.843573615339364  -0.843573615339364  -0.843573615339364  0.084799532195309
-0.843573615339364  -0.843573615339364  0.530720846018092  0.084799532195309
-0.843573615339364  0.530720846018092  -0.843573615339364  0.084799532195309
0.530720846018092  -0.843573615339364  -0.843573615339364  0.084799532195309
-0.756313566672190  -0.756313566672190  -0.756313566672190  -0.500141920914655
-0.756313566672190  -0.756313566672190  0.268940700016569  -0.500141920914655
-0.756313566672190  0.268940700016569  -0.756313566672190  -0.500141920914655
0.268940700016569  -0.756313566672190  -0.756313566672190  -0.500141920914655
-0.334921671107159  -0.334921671107159  -0.334921671107159  0.039131402104588
-0.334921671107159  -0.334921671107159  -0.995234986678524  0.039131402104588
-0.334921671107159  -0.995234986678524  -0.334921671107159  0.039131402104588
-0.995234986678524  -0.334921671107159  -0.334921671107159  0.039131402104588
-0.800000000000000  -0.800000000000000  -0.600000000000000  0.220458553791887
-0.800000000000000  -0.600000000000000  -0.800000000000000  0.220458553791887
-0.800000000000000  -0.800000000000000  0.200000000000000  0.220458553791887
-0.800000000000000  0.200000000000000  -0.800000000000000  0.220458553791887
-0.800000000000000  -0.600000000000000  0.200000000000000  0.220458553791887
-0.800000000000000  0.200000000000000  -0.600000000000000  0.220458553791887
-0.600000000000000  -0.800000000000000  -0.800000000000000  0.220458553791887
-0.600000000000000  -0.800000000000000  0.200000000000000  0.220458553791887
-0.600000000000000  0.200000000000000  -0.800000000000000  0.220458553791887
0.200000000000000  -0.800000000000000  -0.600000000000000  0.220458553791887
0.200000000000000  -0.800000000000000  -0.800000000000000  0.220458553791887
0.200000000000000  -0.600000000000000  -0.800000000000000  0.220458553791887
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=7
*/
template<typename T>
struct IMTetrahedra<7,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 7;
    static const uint16_type nPoints = 31;
    IMTetrahedra()
        :
        q()
    {
        q+=
            0.000000000000000,  0.000000000000000,  -1.000000000000000,  0.007760141093474,
            0.000000000000000,  -1.000000000000000,  0.000000000000000,  0.007760141093474,
            -1.000000000000000,  0.000000000000000,  0.000000000000000,  0.007760141093474,
            -1.000000000000000,  -1.000000000000000,  0.000000000000000,  0.007760141093474,
            -1.000000000000000,  0.000000000000000,  -1.000000000000000,  0.007760141093474,
            0.000000000000000,  -1.000000000000000,  -1.000000000000000,  0.007760141093474,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.146113787728871,
            -0.843573615339364,  -0.843573615339364,  -0.843573615339364,  0.084799532195309,
            -0.843573615339364,  -0.843573615339364,  0.530720846018092,  0.084799532195309,
            -0.843573615339364,  0.530720846018092,  -0.843573615339364,  0.084799532195309,
            0.530720846018092,  -0.843573615339364,  -0.843573615339364,  0.084799532195309,
            -0.756313566672190,  -0.756313566672190,  -0.756313566672190,  -0.500141920914655,
            -0.756313566672190,  -0.756313566672190,  0.268940700016569,  -0.500141920914655,
            -0.756313566672190,  0.268940700016569,  -0.756313566672190,  -0.500141920914655,
            0.268940700016569,  -0.756313566672190,  -0.756313566672190,  -0.500141920914655,
            -0.334921671107159,  -0.334921671107159,  -0.334921671107159,  0.039131402104588,
            -0.334921671107159,  -0.334921671107159,  -0.995234986678524,  0.039131402104588,
            -0.334921671107159,  -0.995234986678524,  -0.334921671107159,  0.039131402104588,
            -0.995234986678524,  -0.334921671107159,  -0.334921671107159,  0.039131402104588,
            -0.800000000000000,  -0.800000000000000,  -0.600000000000000,  0.220458553791887,
            -0.800000000000000,  -0.600000000000000,  -0.800000000000000,  0.220458553791887,
            -0.800000000000000,  -0.800000000000000,  0.200000000000000,  0.220458553791887,
            -0.800000000000000,  0.200000000000000,  -0.800000000000000,  0.220458553791887,
            -0.800000000000000,  -0.600000000000000,  0.200000000000000,  0.220458553791887,
            -0.800000000000000,  0.200000000000000,  -0.600000000000000,  0.220458553791887,
            -0.600000000000000,  -0.800000000000000,  -0.800000000000000,  0.220458553791887,
            -0.600000000000000,  -0.800000000000000,  0.200000000000000,  0.220458553791887,
            -0.600000000000000,  0.200000000000000,  -0.800000000000000,  0.220458553791887,
            0.200000000000000,  -0.800000000000000,  -0.600000000000000,  0.220458553791887,
            0.200000000000000,  -0.800000000000000,  -0.800000000000000,  0.220458553791887,
            0.200000000000000,  -0.600000000000000,  -0.800000000000000,  0.220458553791887;

    }

    std::vector<value_type> q;
};

/*43
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.164001509269119
-0.586340136778654  -0.586340136778654  -0.586340136778654  0.114002446582935
-0.586340136778654  -0.586340136778654  -0.240979589664039  0.114002446582935
-0.586340136778654  -0.240979589664039  -0.586340136778654  0.114002446582935
-0.240979589664039  -0.586340136778654  -0.586340136778654  0.114002446582935
-0.835792823378907  -0.835792823378907  -0.835792823378907  0.015736266505071
-0.835792823378907  -0.835792823378907  0.507378470136720  0.015736266505071
-0.835792823378907  0.507378470136720  -0.835792823378907  0.015736266505071
0.507378470136720  -0.835792823378907  -0.835792823378907  0.015736266505071
-0.988436098989604  -0.988436098989604  -0.988436098989604  0.001358672872743
-0.988436098989604  -0.988436098989604  0.965308296968812  0.001358672872743
-0.988436098989604  0.965308296968812  -0.988436098989604  0.001358672872743
0.965308296968812  -0.988436098989604  -0.988436098989604  0.001358672872743
-0.898934519962212  -0.898934519962212  -0.101065480037788  0.036637470595738
-0.898934519962212  -0.101065480037788  -0.898934519962212  0.036637470595738
-0.101065480037788  -0.898934519962212  -0.898934519962212  0.036637470595738
-0.898934519962212  -0.101065480037788  -0.101065480037788  0.036637470595738
-0.101065480037788  -0.898934519962212  -0.101065480037788  0.036637470595738
-0.101065480037788  -0.101065480037788  -0.898934519962212  0.036637470595738
-0.541866927766378  -0.541866927766378  -0.928720834422932  0.045635886469455
-0.541866927766378  -0.928720834422932  -0.541866927766378  0.045635886469455
-0.541866927766378  -0.541866927766378  0.012454689955687  0.045635886469455
-0.541866927766378  0.012454689955687  -0.541866927766378  0.045635886469455
-0.541866927766378  -0.928720834422932  0.012454689955687  0.045635886469455
-0.541866927766378  0.012454689955687  -0.928720834422932  0.045635886469455
-0.928720834422932  -0.541866927766378  -0.541866927766378  0.045635886469455
-0.928720834422932  -0.541866927766378  0.012454689955687  0.045635886469455
-0.928720834422932  0.012454689955687  -0.541866927766378  0.045635886469455
0.012454689955687  -0.541866927766378  -0.928720834422932  0.045635886469455
0.012454689955687  -0.541866927766378  -0.541866927766378  0.045635886469455
0.012454689955687  -0.928720834422932  -0.541866927766378  0.045635886469455
-0.926784500893605  -0.926784500893605  -0.619027916130733  0.017124153129297
-0.926784500893605  -0.619027916130733  -0.926784500893605  0.017124153129297
-0.926784500893605  -0.926784500893605  0.472596917917943  0.017124153129297
-0.926784500893605  0.472596917917943  -0.926784500893605  0.017124153129297
-0.926784500893605  -0.619027916130733  0.472596917917943  0.017124153129297
-0.926784500893605  0.472596917917943  -0.619027916130733  0.017124153129297
-0.619027916130733  -0.926784500893605  -0.926784500893605  0.017124153129297
-0.619027916130733  -0.926784500893605  0.472596917917943  0.017124153129297
-0.619027916130733  0.472596917917943  -0.926784500893605  0.017124153129297
0.472596917917943  -0.926784500893605  -0.619027916130733  0.017124153129297
0.472596917917943  -0.926784500893605  -0.926784500893605  0.017124153129297
0.472596917917943  -0.619027916130733  -0.926784500893605  0.017124153129297
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=8
*/
template<typename T>
struct IMTetrahedra<8,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 8;
    static const uint16_type nPoints = 43;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.164001509269119,
-0.586340136778654,  -0.586340136778654,  -0.586340136778654,  0.114002446582935,
-0.586340136778654,  -0.586340136778654,  -0.240979589664039,  0.114002446582935,
-0.586340136778654,  -0.240979589664039,  -0.586340136778654,  0.114002446582935,
-0.240979589664039,  -0.586340136778654,  -0.586340136778654,  0.114002446582935,
-0.835792823378907,  -0.835792823378907,  -0.835792823378907,  0.015736266505071,
-0.835792823378907,  -0.835792823378907,  0.507378470136720,  0.015736266505071,
-0.835792823378907,  0.507378470136720,  -0.835792823378907,  0.015736266505071,
0.507378470136720,  -0.835792823378907,  -0.835792823378907,  0.015736266505071,
-0.988436098989604,  -0.988436098989604,  -0.988436098989604,  0.001358672872743,
-0.988436098989604,  -0.988436098989604,  0.965308296968812,  0.001358672872743,
-0.988436098989604,  0.965308296968812,  -0.988436098989604,  0.001358672872743,
0.965308296968812,  -0.988436098989604,  -0.988436098989604,  0.001358672872743,
-0.898934519962212,  -0.898934519962212,  -0.101065480037788,  0.036637470595738,
-0.898934519962212,  -0.101065480037788,  -0.898934519962212,  0.036637470595738,
-0.101065480037788,  -0.898934519962212,  -0.898934519962212,  0.036637470595738,
-0.898934519962212,  -0.101065480037788,  -0.101065480037788,  0.036637470595738,
-0.101065480037788,  -0.898934519962212,  -0.101065480037788,  0.036637470595738,
-0.101065480037788,  -0.101065480037788,  -0.898934519962212,  0.036637470595738,
-0.541866927766378,  -0.541866927766378,  -0.928720834422932,  0.045635886469455,
-0.541866927766378,  -0.928720834422932,  -0.541866927766378,  0.045635886469455,
-0.541866927766378,  -0.541866927766378,  0.012454689955687,  0.045635886469455,
-0.541866927766378,  0.012454689955687,  -0.541866927766378,  0.045635886469455,
-0.541866927766378,  -0.928720834422932,  0.012454689955687,  0.045635886469455,
-0.541866927766378,  0.012454689955687,  -0.928720834422932,  0.045635886469455,
-0.928720834422932,  -0.541866927766378,  -0.541866927766378,  0.045635886469455,
-0.928720834422932,  -0.541866927766378,  0.012454689955687,  0.045635886469455,
-0.928720834422932,  0.012454689955687,  -0.541866927766378,  0.045635886469455,
0.012454689955687,  -0.541866927766378,  -0.928720834422932,  0.045635886469455,
0.012454689955687,  -0.541866927766378,  -0.541866927766378,  0.045635886469455,
0.012454689955687,  -0.928720834422932,  -0.541866927766378,  0.045635886469455,
-0.926784500893605,  -0.926784500893605,  -0.619027916130733,  0.017124153129297,
-0.926784500893605,  -0.619027916130733,  -0.926784500893605,  0.017124153129297,
-0.926784500893605,  -0.926784500893605,  0.472596917917943,  0.017124153129297,
-0.926784500893605,  0.472596917917943,  -0.926784500893605,  0.017124153129297,
-0.926784500893605,  -0.619027916130733,  0.472596917917943,  0.017124153129297,
-0.926784500893605,  0.472596917917943,  -0.619027916130733,  0.017124153129297,
-0.619027916130733,  -0.926784500893605,  -0.926784500893605,  0.017124153129297,
-0.619027916130733,  -0.926784500893605,  0.472596917917943,  0.017124153129297,
-0.619027916130733,  0.472596917917943,  -0.926784500893605,  0.017124153129297,
0.472596917917943,  -0.926784500893605,  -0.619027916130733,  0.017124153129297,
0.472596917917943,  -0.926784500893605,  -0.926784500893605,  0.017124153129297,
            0.472596917917943,  -0.619027916130733,  -0.926784500893605,  0.017124153129297;
    }

    std::vector<value_type> q;
};

/*
53
-0.500000000000000  -0.500000000000000  -0.500000000000000  -1.102392306608869
-0.903297922900526  -0.903297922900526  -0.903297922900526  0.014922692552682
-0.903297922900526  -0.903297922900526  0.709893768701580  0.014922692552682
-0.903297922900526  0.709893768701580  -0.903297922900526  0.014922692552682
0.709893768701580  -0.903297922900526  -0.903297922900526  0.014922692552682
-0.350841439764235  -0.350841439764235  -0.350841439764235  0.034475391755947
-0.350841439764235  -0.350841439764235  -0.947475680707294  0.034475391755947
-0.350841439764235  -0.947475680707294  -0.350841439764235  0.034475391755947
-0.947475680707294  -0.350841439764235  -0.350841439764235  0.034475391755947
-0.770766919552010  -0.770766919552010  -0.770766919552010  -0.721478131849612
-0.770766919552010  -0.770766919552010  0.312300758656029  -0.721478131849612
-0.770766919552010  0.312300758656029  -0.770766919552010  -0.721478131849612
0.312300758656029  -0.770766919552010  -0.770766919552010  -0.721478131849612
-0.549020096176972  -0.549020096176972  -0.549020096176972  0.357380609620092
-0.549020096176972  -0.549020096176972  -0.352939711469084  0.357380609620092
-0.549020096176972  -0.352939711469084  -0.549020096176972  0.357380609620092
-0.352939711469084  -0.549020096176972  -0.549020096176972  0.357380609620092
-0.736744381506260  -0.736744381506260  -0.832670596765630  0.277603247076406
-0.736744381506260  -0.832670596765630  -0.736744381506260  0.277603247076406
-0.736744381506260  -0.736744381506260  0.306159359778151  0.277603247076406
-0.736744381506260  0.306159359778151  -0.736744381506260  0.277603247076406
-0.736744381506260  -0.832670596765630  0.306159359778151  0.277603247076406
-0.736744381506260  0.306159359778151  -0.832670596765630  0.277603247076406
-0.832670596765630  -0.736744381506260  -0.736744381506260  0.277603247076406
-0.832670596765630  -0.736744381506260  0.306159359778151  0.277603247076406
-0.832670596765630  0.306159359778151  -0.736744381506260  0.277603247076406
0.306159359778151  -0.736744381506260  -0.832670596765630  0.277603247076406
0.306159359778151  -0.736744381506260  -0.736744381506260  0.277603247076406
0.306159359778151  -0.832670596765630  -0.736744381506260  0.277603247076406
-0.132097077177186  -0.132097077177186  -0.784460280901143  0.026820671221285
-0.132097077177186  -0.784460280901143  -0.132097077177186  0.026820671221285
-0.132097077177186  -0.132097077177186  -0.951345564744484  0.026820671221285
-0.132097077177186  -0.951345564744484  -0.132097077177186  0.026820671221285
-0.132097077177186  -0.784460280901143  -0.951345564744484  0.026820671221285
-0.132097077177186  -0.951345564744484  -0.784460280901143  0.026820671221285
-0.784460280901143  -0.132097077177186  -0.132097077177186  0.026820671221285
-0.784460280901143  -0.132097077177186  -0.951345564744484  0.026820671221285
-0.784460280901143  -0.951345564744484  -0.132097077177186  0.026820671221285
-0.951345564744484  -0.132097077177186  -0.784460280901143  0.026820671221285
-0.951345564744484  -0.132097077177186  -0.132097077177186  0.026820671221285
-0.951345564744484  -0.784460280901143  -0.132097077177186  0.026820671221285
-1.002752554636276  -1.002752554636276  -0.446893054726385  0.003453031004456
-1.002752554636276  -0.446893054726385  -1.002752554636276  0.003453031004456
-1.002752554636276  -1.002752554636276  0.452398163998938  0.003453031004456
-1.002752554636276  0.452398163998938  -1.002752554636276  0.003453031004456
-1.002752554636276  -0.446893054726385  0.452398163998938  0.003453031004456
-1.002752554636276  0.452398163998938  -0.446893054726385  0.003453031004456
-0.446893054726385  -1.002752554636276  -1.002752554636276  0.003453031004456
-0.446893054726385  -1.002752554636276  0.452398163998938  0.003453031004456
-0.446893054726385  0.452398163998938  -1.002752554636276  0.003453031004456
0.452398163998938  -1.002752554636276  -0.446893054726385  0.003453031004456
0.452398163998938  -1.002752554636276  -1.002752554636276  0.003453031004456
0.452398163998938  -0.446893054726385  -1.002752554636276  0.003453031004456
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=9
*/
template<typename T>
struct IMTetrahedra<9,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 9;
    static const uint16_type nPoints = 53;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -1.102392306608869,
-0.903297922900526,  -0.903297922900526,  -0.903297922900526,  0.014922692552682,
-0.903297922900526,  -0.903297922900526,  0.709893768701580,  0.014922692552682,
-0.903297922900526,  0.709893768701580,  -0.903297922900526,  0.014922692552682,
0.709893768701580,  -0.903297922900526,  -0.903297922900526,  0.014922692552682,
-0.350841439764235,  -0.350841439764235,  -0.350841439764235,  0.034475391755947,
-0.350841439764235,  -0.350841439764235,  -0.947475680707294,  0.034475391755947,
-0.350841439764235,  -0.947475680707294,  -0.350841439764235,  0.034475391755947,
-0.947475680707294,  -0.350841439764235,  -0.350841439764235,  0.034475391755947,
-0.770766919552010,  -0.770766919552010,  -0.770766919552010,  -0.721478131849612,
-0.770766919552010,  -0.770766919552010,  0.312300758656029,  -0.721478131849612,
-0.770766919552010,  0.312300758656029,  -0.770766919552010,  -0.721478131849612,
0.312300758656029,  -0.770766919552010,  -0.770766919552010,  -0.721478131849612,
-0.549020096176972,  -0.549020096176972,  -0.549020096176972,  0.357380609620092,
-0.549020096176972,  -0.549020096176972,  -0.352939711469084,  0.357380609620092,
-0.549020096176972,  -0.352939711469084,  -0.549020096176972,  0.357380609620092,
-0.352939711469084,  -0.549020096176972,  -0.549020096176972,  0.357380609620092,
-0.736744381506260,  -0.736744381506260,  -0.832670596765630,  0.277603247076406,
-0.736744381506260,  -0.832670596765630,  -0.736744381506260,  0.277603247076406,
-0.736744381506260,  -0.736744381506260,  0.306159359778151,  0.277603247076406,
-0.736744381506260,  0.306159359778151,  -0.736744381506260,  0.277603247076406,
-0.736744381506260,  -0.832670596765630,  0.306159359778151,  0.277603247076406,
-0.736744381506260,  0.306159359778151,  -0.832670596765630,  0.277603247076406,
-0.832670596765630,  -0.736744381506260,  -0.736744381506260,  0.277603247076406,
-0.832670596765630,  -0.736744381506260,  0.306159359778151,  0.277603247076406,
-0.832670596765630,  0.306159359778151,  -0.736744381506260,  0.277603247076406,
0.306159359778151,  -0.736744381506260,  -0.832670596765630,  0.277603247076406,
0.306159359778151,  -0.736744381506260,  -0.736744381506260,  0.277603247076406,
0.306159359778151,  -0.832670596765630,  -0.736744381506260,  0.277603247076406,
-0.132097077177186,  -0.132097077177186,  -0.784460280901143,  0.026820671221285,
-0.132097077177186,  -0.784460280901143,  -0.132097077177186,  0.026820671221285,
-0.132097077177186,  -0.132097077177186,  -0.951345564744484,  0.026820671221285,
-0.132097077177186,  -0.951345564744484,  -0.132097077177186,  0.026820671221285,
-0.132097077177186,  -0.784460280901143,  -0.951345564744484,  0.026820671221285,
-0.132097077177186,  -0.951345564744484,  -0.784460280901143,  0.026820671221285,
-0.784460280901143,  -0.132097077177186,  -0.132097077177186,  0.026820671221285,
-0.784460280901143,  -0.132097077177186,  -0.951345564744484,  0.026820671221285,
-0.784460280901143,  -0.951345564744484,  -0.132097077177186,  0.026820671221285,
-0.951345564744484,  -0.132097077177186,  -0.784460280901143,  0.026820671221285,
-0.951345564744484,  -0.132097077177186,  -0.132097077177186,  0.026820671221285,
-0.951345564744484,  -0.784460280901143,  -0.132097077177186,  0.026820671221285,
-1.002752554636276,  -1.002752554636276,  -0.446893054726385,  0.003453031004456,
-1.002752554636276,  -0.446893054726385,  -1.002752554636276,  0.003453031004456,
-1.002752554636276,  -1.002752554636276,  0.452398163998938,  0.003453031004456,
-1.002752554636276,  0.452398163998938,  -1.002752554636276,  0.003453031004456,
-1.002752554636276,  -0.446893054726385,  0.452398163998938,  0.003453031004456,
-1.002752554636276,  0.452398163998938,  -0.446893054726385,  0.003453031004456,
-0.446893054726385,  -1.002752554636276,  -1.002752554636276,  0.003453031004456,
-0.446893054726385,  -1.002752554636276,  0.452398163998938,  0.003453031004456,
-0.446893054726385,  0.452398163998938,  -1.002752554636276,  0.003453031004456,
0.452398163998938,  -1.002752554636276,  -0.446893054726385,  0.003453031004456,
0.452398163998938,  -1.002752554636276,  -1.002752554636276,  0.003453031004456,
            0.452398163998938,  -0.446893054726385,  -1.002752554636276,  0.003453031004456;
    }

    std::vector<value_type> q;
};

/*
126
-0.857142857142857  -0.857142857142857  0.571428571428571  0.362902592520648
-0.857142857142857  -0.571428571428571  0.285714285714286  0.362902592520648
-0.857142857142857  -0.285714285714286  0.000000000000000  0.362902592520648
-0.857142857142857  0.000000000000000  -0.285714285714286  0.362902592520648
-0.857142857142857  0.285714285714286  -0.571428571428571  0.362902592520648
-0.857142857142857  0.571428571428571  -0.857142857142857  0.362902592520648
-0.571428571428571  -0.857142857142857  0.285714285714286  0.362902592520648
-0.571428571428571  -0.571428571428571  0.000000000000000  0.362902592520648
-0.571428571428571  -0.285714285714286  -0.285714285714286  0.362902592520648
-0.571428571428571  0.000000000000000  -0.571428571428571  0.362902592520648
-0.571428571428571  0.285714285714286  -0.857142857142857  0.362902592520648
-0.285714285714286  -0.857142857142857  0.000000000000000  0.362902592520648
-0.285714285714286  -0.571428571428571  -0.285714285714286  0.362902592520648
-0.285714285714286  -0.285714285714286  -0.571428571428571  0.362902592520648
-0.285714285714286  0.000000000000000  -0.857142857142857  0.362902592520648
0.000000000000000  -0.857142857142857  -0.285714285714286  0.362902592520648
0.000000000000000  -0.571428571428571  -0.571428571428571  0.362902592520648
0.000000000000000  -0.285714285714286  -0.857142857142857  0.362902592520648
0.285714285714286  -0.857142857142857  -0.571428571428571  0.362902592520648
0.285714285714286  -0.571428571428571  -0.857142857142857  0.362902592520648
0.571428571428571  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.857142857142857  -0.857142857142857  0.285714285714286  0.362902592520648
-0.857142857142857  -0.571428571428571  0.000000000000000  0.362902592520648
-0.857142857142857  -0.285714285714286  -0.285714285714286  0.362902592520648
-0.857142857142857  0.000000000000000  -0.571428571428571  0.362902592520648
-0.857142857142857  0.285714285714286  -0.857142857142857  0.362902592520648
-0.571428571428571  -0.857142857142857  0.000000000000000  0.362902592520648
-0.571428571428571  -0.571428571428571  -0.285714285714286  0.362902592520648
-0.571428571428571  -0.285714285714286  -0.571428571428571  0.362902592520648
-0.571428571428571  0.000000000000000  -0.857142857142857  0.362902592520648
-0.285714285714286  -0.857142857142857  -0.285714285714286  0.362902592520648
-0.285714285714286  -0.571428571428571  -0.571428571428571  0.362902592520648
-0.285714285714286  -0.285714285714286  -0.857142857142857  0.362902592520648
0.000000000000000  -0.857142857142857  -0.571428571428571  0.362902592520648
0.000000000000000  -0.571428571428571  -0.857142857142857  0.362902592520648
0.285714285714286  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.857142857142857  -0.857142857142857  0.000000000000000  0.362902592520648
-0.857142857142857  -0.571428571428571  -0.285714285714286  0.362902592520648
-0.857142857142857  -0.285714285714286  -0.571428571428571  0.362902592520648
-0.857142857142857  0.000000000000000  -0.857142857142857  0.362902592520648
-0.571428571428571  -0.857142857142857  -0.285714285714286  0.362902592520648
-0.571428571428571  -0.571428571428571  -0.571428571428571  0.362902592520648
-0.571428571428571  -0.285714285714286  -0.857142857142857  0.362902592520648
-0.285714285714286  -0.857142857142857  -0.571428571428571  0.362902592520648
-0.285714285714286  -0.571428571428571  -0.857142857142857  0.362902592520648
0.000000000000000  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.857142857142857  -0.857142857142857  -0.285714285714286  0.362902592520648
-0.857142857142857  -0.571428571428571  -0.571428571428571  0.362902592520648
-0.857142857142857  -0.285714285714286  -0.857142857142857  0.362902592520648
-0.571428571428571  -0.857142857142857  -0.571428571428571  0.362902592520648
-0.571428571428571  -0.571428571428571  -0.857142857142857  0.362902592520648
-0.285714285714286  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.857142857142857  -0.857142857142857  -0.571428571428571  0.362902592520648
-0.857142857142857  -0.571428571428571  -0.857142857142857  0.362902592520648
-0.571428571428571  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.857142857142857  -0.857142857142857  -0.857142857142857  0.362902592520648
-0.833333333333333  -0.833333333333333  0.500000000000000  -0.932187812187812
-0.833333333333333  -0.500000000000000  0.166666666666667  -0.932187812187812
-0.833333333333333  -0.166666666666667  -0.166666666666667  -0.932187812187812
-0.833333333333333  0.166666666666667  -0.500000000000000  -0.932187812187812
-0.833333333333333  0.500000000000000  -0.833333333333333  -0.932187812187812
-0.500000000000000  -0.833333333333333  0.166666666666667  -0.932187812187812
-0.500000000000000  -0.500000000000000  -0.166666666666667  -0.932187812187812
-0.500000000000000  -0.166666666666667  -0.500000000000000  -0.932187812187812
-0.500000000000000  0.166666666666667  -0.833333333333333  -0.932187812187812
-0.166666666666667  -0.833333333333333  -0.166666666666667  -0.932187812187812
-0.166666666666667  -0.500000000000000  -0.500000000000000  -0.932187812187812
-0.166666666666667  -0.166666666666667  -0.833333333333333  -0.932187812187812
0.166666666666667  -0.833333333333333  -0.500000000000000  -0.932187812187812
0.166666666666667  -0.500000000000000  -0.833333333333333  -0.932187812187812
0.500000000000000  -0.833333333333333  -0.833333333333333  -0.932187812187812
-0.833333333333333  -0.833333333333333  0.166666666666667  -0.932187812187812
-0.833333333333333  -0.500000000000000  -0.166666666666667  -0.932187812187812
-0.833333333333333  -0.166666666666667  -0.500000000000000  -0.932187812187812
-0.833333333333333  0.166666666666667  -0.833333333333333  -0.932187812187812
-0.500000000000000  -0.833333333333333  -0.166666666666667  -0.932187812187812
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.932187812187812
-0.500000000000000  -0.166666666666667  -0.833333333333333  -0.932187812187812
-0.166666666666667  -0.833333333333333  -0.500000000000000  -0.932187812187812
-0.166666666666667  -0.500000000000000  -0.833333333333333  -0.932187812187812
0.166666666666667  -0.833333333333333  -0.833333333333333  -0.932187812187812
-0.833333333333333  -0.833333333333333  -0.166666666666667  -0.932187812187812
-0.833333333333333  -0.500000000000000  -0.500000000000000  -0.932187812187812
-0.833333333333333  -0.166666666666667  -0.833333333333333  -0.932187812187812
-0.500000000000000  -0.833333333333333  -0.500000000000000  -0.932187812187812
-0.500000000000000  -0.500000000000000  -0.833333333333333  -0.932187812187812
-0.166666666666667  -0.833333333333333  -0.833333333333333  -0.932187812187812
-0.833333333333333  -0.833333333333333  -0.500000000000000  -0.932187812187812
-0.833333333333333  -0.500000000000000  -0.833333333333333  -0.932187812187812
-0.500000000000000  -0.833333333333333  -0.833333333333333  -0.932187812187812
-0.833333333333333  -0.833333333333333  -0.833333333333333  -0.932187812187812
-0.800000000000000  -0.800000000000000  0.400000000000000  0.815498319838598
-0.800000000000000  -0.400000000000000  0.000000000000000  0.815498319838598
-0.800000000000000  0.000000000000000  -0.400000000000000  0.815498319838598
-0.800000000000000  0.400000000000000  -0.800000000000000  0.815498319838598
-0.400000000000000  -0.800000000000000  0.000000000000000  0.815498319838598
-0.400000000000000  -0.400000000000000  -0.400000000000000  0.815498319838598
-0.400000000000000  0.000000000000000  -0.800000000000000  0.815498319838598
0.000000000000000  -0.800000000000000  -0.400000000000000  0.815498319838598
0.000000000000000  -0.400000000000000  -0.800000000000000  0.815498319838598
0.400000000000000  -0.800000000000000  -0.800000000000000  0.815498319838598
-0.800000000000000  -0.800000000000000  0.000000000000000  0.815498319838598
-0.800000000000000  -0.400000000000000  -0.400000000000000  0.815498319838598
-0.800000000000000  0.000000000000000  -0.800000000000000  0.815498319838598
-0.400000000000000  -0.800000000000000  -0.400000000000000  0.815498319838598
-0.400000000000000  -0.400000000000000  -0.800000000000000  0.815498319838598
0.000000000000000  -0.800000000000000  -0.800000000000000  0.815498319838598
-0.800000000000000  -0.800000000000000  -0.400000000000000  0.815498319838598
-0.800000000000000  -0.400000000000000  -0.800000000000000  0.815498319838598
-0.400000000000000  -0.800000000000000  -0.800000000000000  0.815498319838598
-0.800000000000000  -0.800000000000000  -0.800000000000000  0.815498319838598
-0.750000000000000  -0.750000000000000  0.250000000000000  -0.280203089091978
-0.750000000000000  -0.250000000000000  -0.250000000000000  -0.280203089091978
-0.750000000000000  0.250000000000000  -0.750000000000000  -0.280203089091978
-0.250000000000000  -0.750000000000000  -0.250000000000000  -0.280203089091978
-0.250000000000000  -0.250000000000000  -0.750000000000000  -0.280203089091978
0.250000000000000  -0.750000000000000  -0.750000000000000  -0.280203089091978
-0.750000000000000  -0.750000000000000  -0.250000000000000  -0.280203089091978
-0.750000000000000  -0.250000000000000  -0.750000000000000  -0.280203089091978
-0.250000000000000  -0.750000000000000  -0.750000000000000  -0.280203089091978
-0.750000000000000  -0.750000000000000  -0.750000000000000  -0.280203089091978
-0.666666666666667  -0.666666666666667  0.000000000000000  0.032544642857143
-0.666666666666667  0.000000000000000  -0.666666666666667  0.032544642857143
0.000000000000000  -0.666666666666667  -0.666666666666667  0.032544642857143
-0.666666666666667  -0.666666666666667  -0.666666666666667  0.032544642857143
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.000752498530276
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=11
*/
template<typename T>
struct IMTetrahedra<11,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 11;
    static const uint16_type nPoints = 126;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.857142857142857,  -0.857142857142857,  0.571428571428571,  0.362902592520648,
-0.857142857142857,  -0.571428571428571,  0.285714285714286,  0.362902592520648,
-0.857142857142857,  -0.285714285714286,  0.000000000000000,  0.362902592520648,
-0.857142857142857,  0.000000000000000,  -0.285714285714286,  0.362902592520648,
-0.857142857142857,  0.285714285714286,  -0.571428571428571,  0.362902592520648,
-0.857142857142857,  0.571428571428571,  -0.857142857142857,  0.362902592520648,
-0.571428571428571,  -0.857142857142857,  0.285714285714286,  0.362902592520648,
-0.571428571428571,  -0.571428571428571,  0.000000000000000,  0.362902592520648,
-0.571428571428571,  -0.285714285714286,  -0.285714285714286,  0.362902592520648,
-0.571428571428571,  0.000000000000000,  -0.571428571428571,  0.362902592520648,
-0.571428571428571,  0.285714285714286,  -0.857142857142857,  0.362902592520648,
-0.285714285714286,  -0.857142857142857,  0.000000000000000,  0.362902592520648,
-0.285714285714286,  -0.571428571428571,  -0.285714285714286,  0.362902592520648,
-0.285714285714286,  -0.285714285714286,  -0.571428571428571,  0.362902592520648,
-0.285714285714286,  0.000000000000000,  -0.857142857142857,  0.362902592520648,
0.000000000000000,  -0.857142857142857,  -0.285714285714286,  0.362902592520648,
0.000000000000000,  -0.571428571428571,  -0.571428571428571,  0.362902592520648,
0.000000000000000,  -0.285714285714286,  -0.857142857142857,  0.362902592520648,
0.285714285714286,  -0.857142857142857,  -0.571428571428571,  0.362902592520648,
0.285714285714286,  -0.571428571428571,  -0.857142857142857,  0.362902592520648,
0.571428571428571,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.857142857142857,  -0.857142857142857,  0.285714285714286,  0.362902592520648,
-0.857142857142857,  -0.571428571428571,  0.000000000000000,  0.362902592520648,
-0.857142857142857,  -0.285714285714286,  -0.285714285714286,  0.362902592520648,
-0.857142857142857,  0.000000000000000,  -0.571428571428571,  0.362902592520648,
-0.857142857142857,  0.285714285714286,  -0.857142857142857,  0.362902592520648,
-0.571428571428571,  -0.857142857142857,  0.000000000000000,  0.362902592520648,
-0.571428571428571,  -0.571428571428571,  -0.285714285714286,  0.362902592520648,
-0.571428571428571,  -0.285714285714286,  -0.571428571428571,  0.362902592520648,
-0.571428571428571,  0.000000000000000,  -0.857142857142857,  0.362902592520648,
-0.285714285714286,  -0.857142857142857,  -0.285714285714286,  0.362902592520648,
-0.285714285714286,  -0.571428571428571,  -0.571428571428571,  0.362902592520648,
-0.285714285714286,  -0.285714285714286,  -0.857142857142857,  0.362902592520648,
0.000000000000000,  -0.857142857142857,  -0.571428571428571,  0.362902592520648,
0.000000000000000,  -0.571428571428571,  -0.857142857142857,  0.362902592520648,
0.285714285714286,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.857142857142857,  -0.857142857142857,  0.000000000000000,  0.362902592520648,
-0.857142857142857,  -0.571428571428571,  -0.285714285714286,  0.362902592520648,
-0.857142857142857,  -0.285714285714286,  -0.571428571428571,  0.362902592520648,
-0.857142857142857,  0.000000000000000,  -0.857142857142857,  0.362902592520648,
-0.571428571428571,  -0.857142857142857,  -0.285714285714286,  0.362902592520648,
-0.571428571428571,  -0.571428571428571,  -0.571428571428571,  0.362902592520648,
-0.571428571428571,  -0.285714285714286,  -0.857142857142857,  0.362902592520648,
-0.285714285714286,  -0.857142857142857,  -0.571428571428571,  0.362902592520648,
-0.285714285714286,  -0.571428571428571,  -0.857142857142857,  0.362902592520648,
0.000000000000000,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.857142857142857,  -0.857142857142857,  -0.285714285714286,  0.362902592520648,
-0.857142857142857,  -0.571428571428571,  -0.571428571428571,  0.362902592520648,
-0.857142857142857,  -0.285714285714286,  -0.857142857142857,  0.362902592520648,
-0.571428571428571,  -0.857142857142857,  -0.571428571428571,  0.362902592520648,
-0.571428571428571,  -0.571428571428571,  -0.857142857142857,  0.362902592520648,
-0.285714285714286,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.857142857142857,  -0.857142857142857,  -0.571428571428571,  0.362902592520648,
-0.857142857142857,  -0.571428571428571,  -0.857142857142857,  0.362902592520648,
-0.571428571428571,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.857142857142857,  -0.857142857142857,  -0.857142857142857,  0.362902592520648,
-0.833333333333333,  -0.833333333333333,  0.500000000000000,  -0.932187812187812,
-0.833333333333333,  -0.500000000000000,  0.166666666666667,  -0.932187812187812,
-0.833333333333333,  -0.166666666666667,  -0.166666666666667,  -0.932187812187812,
-0.833333333333333,  0.166666666666667,  -0.500000000000000,  -0.932187812187812,
-0.833333333333333,  0.500000000000000,  -0.833333333333333,  -0.932187812187812,
-0.500000000000000,  -0.833333333333333,  0.166666666666667,  -0.932187812187812,
-0.500000000000000,  -0.500000000000000,  -0.166666666666667,  -0.932187812187812,
-0.500000000000000,  -0.166666666666667,  -0.500000000000000,  -0.932187812187812,
-0.500000000000000,  0.166666666666667,  -0.833333333333333,  -0.932187812187812,
-0.166666666666667,  -0.833333333333333,  -0.166666666666667,  -0.932187812187812,
-0.166666666666667,  -0.500000000000000,  -0.500000000000000,  -0.932187812187812,
-0.166666666666667,  -0.166666666666667,  -0.833333333333333,  -0.932187812187812,
0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.932187812187812,
0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.932187812187812,
0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.932187812187812,
-0.833333333333333,  -0.833333333333333,  0.166666666666667,  -0.932187812187812,
-0.833333333333333,  -0.500000000000000,  -0.166666666666667,  -0.932187812187812,
-0.833333333333333,  -0.166666666666667,  -0.500000000000000,  -0.932187812187812,
-0.833333333333333,  0.166666666666667,  -0.833333333333333,  -0.932187812187812,
-0.500000000000000,  -0.833333333333333,  -0.166666666666667,  -0.932187812187812,
-0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.932187812187812,
-0.500000000000000,  -0.166666666666667,  -0.833333333333333,  -0.932187812187812,
-0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.932187812187812,
-0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.932187812187812,
0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.932187812187812,
-0.833333333333333,  -0.833333333333333,  -0.166666666666667,  -0.932187812187812,
-0.833333333333333,  -0.500000000000000,  -0.500000000000000,  -0.932187812187812,
-0.833333333333333,  -0.166666666666667,  -0.833333333333333,  -0.932187812187812,
-0.500000000000000,  -0.833333333333333,  -0.500000000000000,  -0.932187812187812,
-0.500000000000000,  -0.500000000000000,  -0.833333333333333,  -0.932187812187812,
-0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.932187812187812,
-0.833333333333333,  -0.833333333333333,  -0.500000000000000,  -0.932187812187812,
-0.833333333333333,  -0.500000000000000,  -0.833333333333333,  -0.932187812187812,
-0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.932187812187812,
-0.833333333333333,  -0.833333333333333,  -0.833333333333333,  -0.932187812187812,
-0.800000000000000,  -0.800000000000000,  0.400000000000000,  0.815498319838598,
-0.800000000000000,  -0.400000000000000,  0.000000000000000,  0.815498319838598,
-0.800000000000000,  0.000000000000000,  -0.400000000000000,  0.815498319838598,
-0.800000000000000,  0.400000000000000,  -0.800000000000000,  0.815498319838598,
-0.400000000000000,  -0.800000000000000,  0.000000000000000,  0.815498319838598,
-0.400000000000000,  -0.400000000000000,  -0.400000000000000,  0.815498319838598,
-0.400000000000000,  0.000000000000000,  -0.800000000000000,  0.815498319838598,
0.000000000000000,  -0.800000000000000,  -0.400000000000000,  0.815498319838598,
0.000000000000000,  -0.400000000000000,  -0.800000000000000,  0.815498319838598,
0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.815498319838598,
-0.800000000000000,  -0.800000000000000,  0.000000000000000,  0.815498319838598,
-0.800000000000000,  -0.400000000000000,  -0.400000000000000,  0.815498319838598,
-0.800000000000000,  0.000000000000000,  -0.800000000000000,  0.815498319838598,
-0.400000000000000,  -0.800000000000000,  -0.400000000000000,  0.815498319838598,
-0.400000000000000,  -0.400000000000000,  -0.800000000000000,  0.815498319838598,
0.000000000000000,  -0.800000000000000,  -0.800000000000000,  0.815498319838598,
-0.800000000000000,  -0.800000000000000,  -0.400000000000000,  0.815498319838598,
-0.800000000000000,  -0.400000000000000,  -0.800000000000000,  0.815498319838598,
-0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.815498319838598,
-0.800000000000000,  -0.800000000000000,  -0.800000000000000,  0.815498319838598,
-0.750000000000000,  -0.750000000000000,  0.250000000000000,  -0.280203089091978,
-0.750000000000000,  -0.250000000000000,  -0.250000000000000,  -0.280203089091978,
-0.750000000000000,  0.250000000000000,  -0.750000000000000,  -0.280203089091978,
-0.250000000000000,  -0.750000000000000,  -0.250000000000000,  -0.280203089091978,
-0.250000000000000,  -0.250000000000000,  -0.750000000000000,  -0.280203089091978,
0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.280203089091978,
-0.750000000000000,  -0.750000000000000,  -0.250000000000000,  -0.280203089091978,
-0.750000000000000,  -0.250000000000000,  -0.750000000000000,  -0.280203089091978,
-0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.280203089091978,
-0.750000000000000,  -0.750000000000000,  -0.750000000000000,  -0.280203089091978,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  0.032544642857143,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  0.032544642857143,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  0.032544642857143,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  0.032544642857143,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.000752498530276;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<10,T>: public IMTetrahedra<11,T> {};
/*
210
-0.875000000000000  -0.875000000000000  0.625000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  0.375000000000000  0.420407272132140
-0.875000000000000  -0.375000000000000  0.125000000000000  0.420407272132140
-0.875000000000000  -0.125000000000000  -0.125000000000000  0.420407272132140
-0.875000000000000  0.125000000000000  -0.375000000000000  0.420407272132140
-0.875000000000000  0.375000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  0.625000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  0.375000000000000  0.420407272132140
-0.625000000000000  -0.625000000000000  0.125000000000000  0.420407272132140
-0.625000000000000  -0.375000000000000  -0.125000000000000  0.420407272132140
-0.625000000000000  -0.125000000000000  -0.375000000000000  0.420407272132140
-0.625000000000000  0.125000000000000  -0.625000000000000  0.420407272132140
-0.625000000000000  0.375000000000000  -0.875000000000000  0.420407272132140
-0.375000000000000  -0.875000000000000  0.125000000000000  0.420407272132140
-0.375000000000000  -0.625000000000000  -0.125000000000000  0.420407272132140
-0.375000000000000  -0.375000000000000  -0.375000000000000  0.420407272132140
-0.375000000000000  -0.125000000000000  -0.625000000000000  0.420407272132140
-0.375000000000000  0.125000000000000  -0.875000000000000  0.420407272132140
-0.125000000000000  -0.875000000000000  -0.125000000000000  0.420407272132140
-0.125000000000000  -0.625000000000000  -0.375000000000000  0.420407272132140
-0.125000000000000  -0.375000000000000  -0.625000000000000  0.420407272132140
-0.125000000000000  -0.125000000000000  -0.875000000000000  0.420407272132140
0.125000000000000  -0.875000000000000  -0.375000000000000  0.420407272132140
0.125000000000000  -0.625000000000000  -0.625000000000000  0.420407272132140
0.125000000000000  -0.375000000000000  -0.875000000000000  0.420407272132140
0.375000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
0.375000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
0.625000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  0.375000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  0.125000000000000  0.420407272132140
-0.875000000000000  -0.375000000000000  -0.125000000000000  0.420407272132140
-0.875000000000000  -0.125000000000000  -0.375000000000000  0.420407272132140
-0.875000000000000  0.125000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  0.375000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  0.125000000000000  0.420407272132140
-0.625000000000000  -0.625000000000000  -0.125000000000000  0.420407272132140
-0.625000000000000  -0.375000000000000  -0.375000000000000  0.420407272132140
-0.625000000000000  -0.125000000000000  -0.625000000000000  0.420407272132140
-0.625000000000000  0.125000000000000  -0.875000000000000  0.420407272132140
-0.375000000000000  -0.875000000000000  -0.125000000000000  0.420407272132140
-0.375000000000000  -0.625000000000000  -0.375000000000000  0.420407272132140
-0.375000000000000  -0.375000000000000  -0.625000000000000  0.420407272132140
-0.375000000000000  -0.125000000000000  -0.875000000000000  0.420407272132140
-0.125000000000000  -0.875000000000000  -0.375000000000000  0.420407272132140
-0.125000000000000  -0.625000000000000  -0.625000000000000  0.420407272132140
-0.125000000000000  -0.375000000000000  -0.875000000000000  0.420407272132140
0.125000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
0.125000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
0.375000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  0.125000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  -0.125000000000000  0.420407272132140
-0.875000000000000  -0.375000000000000  -0.375000000000000  0.420407272132140
-0.875000000000000  -0.125000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  0.125000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  -0.125000000000000  0.420407272132140
-0.625000000000000  -0.625000000000000  -0.375000000000000  0.420407272132140
-0.625000000000000  -0.375000000000000  -0.625000000000000  0.420407272132140
-0.625000000000000  -0.125000000000000  -0.875000000000000  0.420407272132140
-0.375000000000000  -0.875000000000000  -0.375000000000000  0.420407272132140
-0.375000000000000  -0.625000000000000  -0.625000000000000  0.420407272132140
-0.375000000000000  -0.375000000000000  -0.875000000000000  0.420407272132140
-0.125000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
-0.125000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
0.125000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  -0.125000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  -0.375000000000000  0.420407272132140
-0.875000000000000  -0.375000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  -0.125000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  -0.375000000000000  0.420407272132140
-0.625000000000000  -0.625000000000000  -0.625000000000000  0.420407272132140
-0.625000000000000  -0.375000000000000  -0.875000000000000  0.420407272132140
-0.375000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
-0.375000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
-0.125000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  -0.375000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  -0.375000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
-0.625000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
-0.375000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  -0.625000000000000  0.420407272132140
-0.875000000000000  -0.625000000000000  -0.875000000000000  0.420407272132140
-0.625000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.875000000000000  -0.875000000000000  -0.875000000000000  0.420407272132140
-0.857142857142857  -0.857142857142857  0.571428571428571  -1.185481802234117
-0.857142857142857  -0.571428571428571  0.285714285714286  -1.185481802234117
-0.857142857142857  -0.285714285714286  0.000000000000000  -1.185481802234117
-0.857142857142857  0.000000000000000  -0.285714285714286  -1.185481802234117
-0.857142857142857  0.285714285714286  -0.571428571428571  -1.185481802234117
-0.857142857142857  0.571428571428571  -0.857142857142857  -1.185481802234117
-0.571428571428571  -0.857142857142857  0.285714285714286  -1.185481802234117
-0.571428571428571  -0.571428571428571  0.000000000000000  -1.185481802234117
-0.571428571428571  -0.285714285714286  -0.285714285714286  -1.185481802234117
-0.571428571428571  0.000000000000000  -0.571428571428571  -1.185481802234117
-0.571428571428571  0.285714285714286  -0.857142857142857  -1.185481802234117
-0.285714285714286  -0.857142857142857  0.000000000000000  -1.185481802234117
-0.285714285714286  -0.571428571428571  -0.285714285714286  -1.185481802234117
-0.285714285714286  -0.285714285714286  -0.571428571428571  -1.185481802234117
-0.285714285714286  0.000000000000000  -0.857142857142857  -1.185481802234117
0.000000000000000  -0.857142857142857  -0.285714285714286  -1.185481802234117
0.000000000000000  -0.571428571428571  -0.571428571428571  -1.185481802234117
0.000000000000000  -0.285714285714286  -0.857142857142857  -1.185481802234117
0.285714285714286  -0.857142857142857  -0.571428571428571  -1.185481802234117
0.285714285714286  -0.571428571428571  -0.857142857142857  -1.185481802234117
0.571428571428571  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.857142857142857  -0.857142857142857  0.285714285714286  -1.185481802234117
-0.857142857142857  -0.571428571428571  0.000000000000000  -1.185481802234117
-0.857142857142857  -0.285714285714286  -0.285714285714286  -1.185481802234117
-0.857142857142857  0.000000000000000  -0.571428571428571  -1.185481802234117
-0.857142857142857  0.285714285714286  -0.857142857142857  -1.185481802234117
-0.571428571428571  -0.857142857142857  0.000000000000000  -1.185481802234117
-0.571428571428571  -0.571428571428571  -0.285714285714286  -1.185481802234117
-0.571428571428571  -0.285714285714286  -0.571428571428571  -1.185481802234117
-0.571428571428571  0.000000000000000  -0.857142857142857  -1.185481802234117
-0.285714285714286  -0.857142857142857  -0.285714285714286  -1.185481802234117
-0.285714285714286  -0.571428571428571  -0.571428571428571  -1.185481802234117
-0.285714285714286  -0.285714285714286  -0.857142857142857  -1.185481802234117
0.000000000000000  -0.857142857142857  -0.571428571428571  -1.185481802234117
0.000000000000000  -0.571428571428571  -0.857142857142857  -1.185481802234117
0.285714285714286  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.857142857142857  -0.857142857142857  0.000000000000000  -1.185481802234117
-0.857142857142857  -0.571428571428571  -0.285714285714286  -1.185481802234117
-0.857142857142857  -0.285714285714286  -0.571428571428571  -1.185481802234117
-0.857142857142857  0.000000000000000  -0.857142857142857  -1.185481802234117
-0.571428571428571  -0.857142857142857  -0.285714285714286  -1.185481802234117
-0.571428571428571  -0.571428571428571  -0.571428571428571  -1.185481802234117
-0.571428571428571  -0.285714285714286  -0.857142857142857  -1.185481802234117
-0.285714285714286  -0.857142857142857  -0.571428571428571  -1.185481802234117
-0.285714285714286  -0.571428571428571  -0.857142857142857  -1.185481802234117
0.000000000000000  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.857142857142857  -0.857142857142857  -0.285714285714286  -1.185481802234117
-0.857142857142857  -0.571428571428571  -0.571428571428571  -1.185481802234117
-0.857142857142857  -0.285714285714286  -0.857142857142857  -1.185481802234117
-0.571428571428571  -0.857142857142857  -0.571428571428571  -1.185481802234117
-0.571428571428571  -0.571428571428571  -0.857142857142857  -1.185481802234117
-0.285714285714286  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.857142857142857  -0.857142857142857  -0.571428571428571  -1.185481802234117
-0.857142857142857  -0.571428571428571  -0.857142857142857  -1.185481802234117
-0.571428571428571  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.857142857142857  -0.857142857142857  -0.857142857142857  -1.185481802234117
-0.833333333333333  -0.833333333333333  0.500000000000000  1.198527187098616
-0.833333333333333  -0.500000000000000  0.166666666666667  1.198527187098616
-0.833333333333333  -0.166666666666667  -0.166666666666667  1.198527187098616
-0.833333333333333  0.166666666666667  -0.500000000000000  1.198527187098616
-0.833333333333333  0.500000000000000  -0.833333333333333  1.198527187098616
-0.500000000000000  -0.833333333333333  0.166666666666667  1.198527187098616
-0.500000000000000  -0.500000000000000  -0.166666666666667  1.198527187098616
-0.500000000000000  -0.166666666666667  -0.500000000000000  1.198527187098616
-0.500000000000000  0.166666666666667  -0.833333333333333  1.198527187098616
-0.166666666666667  -0.833333333333333  -0.166666666666667  1.198527187098616
-0.166666666666667  -0.500000000000000  -0.500000000000000  1.198527187098616
-0.166666666666667  -0.166666666666667  -0.833333333333333  1.198527187098616
0.166666666666667  -0.833333333333333  -0.500000000000000  1.198527187098616
0.166666666666667  -0.500000000000000  -0.833333333333333  1.198527187098616
0.500000000000000  -0.833333333333333  -0.833333333333333  1.198527187098616
-0.833333333333333  -0.833333333333333  0.166666666666667  1.198527187098616
-0.833333333333333  -0.500000000000000  -0.166666666666667  1.198527187098616
-0.833333333333333  -0.166666666666667  -0.500000000000000  1.198527187098616
-0.833333333333333  0.166666666666667  -0.833333333333333  1.198527187098616
-0.500000000000000  -0.833333333333333  -0.166666666666667  1.198527187098616
-0.500000000000000  -0.500000000000000  -0.500000000000000  1.198527187098616
-0.500000000000000  -0.166666666666667  -0.833333333333333  1.198527187098616
-0.166666666666667  -0.833333333333333  -0.500000000000000  1.198527187098616
-0.166666666666667  -0.500000000000000  -0.833333333333333  1.198527187098616
0.166666666666667  -0.833333333333333  -0.833333333333333  1.198527187098616
-0.833333333333333  -0.833333333333333  -0.166666666666667  1.198527187098616
-0.833333333333333  -0.500000000000000  -0.500000000000000  1.198527187098616
-0.833333333333333  -0.166666666666667  -0.833333333333333  1.198527187098616
-0.500000000000000  -0.833333333333333  -0.500000000000000  1.198527187098616
-0.500000000000000  -0.500000000000000  -0.833333333333333  1.198527187098616
-0.166666666666667  -0.833333333333333  -0.833333333333333  1.198527187098616
-0.833333333333333  -0.833333333333333  -0.500000000000000  1.198527187098616
-0.833333333333333  -0.500000000000000  -0.833333333333333  1.198527187098616
-0.500000000000000  -0.833333333333333  -0.833333333333333  1.198527187098616
-0.833333333333333  -0.833333333333333  -0.833333333333333  1.198527187098616
-0.800000000000000  -0.800000000000000  0.400000000000000  -0.522755333229870
-0.800000000000000  -0.400000000000000  0.000000000000000  -0.522755333229870
-0.800000000000000  0.000000000000000  -0.400000000000000  -0.522755333229870
-0.800000000000000  0.400000000000000  -0.800000000000000  -0.522755333229870
-0.400000000000000  -0.800000000000000  0.000000000000000  -0.522755333229870
-0.400000000000000  -0.400000000000000  -0.400000000000000  -0.522755333229870
-0.400000000000000  0.000000000000000  -0.800000000000000  -0.522755333229870
0.000000000000000  -0.800000000000000  -0.400000000000000  -0.522755333229870
0.000000000000000  -0.400000000000000  -0.800000000000000  -0.522755333229870
0.400000000000000  -0.800000000000000  -0.800000000000000  -0.522755333229870
-0.800000000000000  -0.800000000000000  0.000000000000000  -0.522755333229870
-0.800000000000000  -0.400000000000000  -0.400000000000000  -0.522755333229870
-0.800000000000000  0.000000000000000  -0.800000000000000  -0.522755333229870
-0.400000000000000  -0.800000000000000  -0.400000000000000  -0.522755333229870
-0.400000000000000  -0.400000000000000  -0.800000000000000  -0.522755333229870
0.000000000000000  -0.800000000000000  -0.800000000000000  -0.522755333229870
-0.800000000000000  -0.800000000000000  -0.400000000000000  -0.522755333229870
-0.800000000000000  -0.400000000000000  -0.800000000000000  -0.522755333229870
-0.400000000000000  -0.800000000000000  -0.800000000000000  -0.522755333229870
-0.800000000000000  -0.800000000000000  -0.800000000000000  -0.522755333229870
-0.750000000000000  -0.750000000000000  0.250000000000000  0.093401029697326
-0.750000000000000  -0.250000000000000  -0.250000000000000  0.093401029697326
-0.750000000000000  0.250000000000000  -0.750000000000000  0.093401029697326
-0.250000000000000  -0.750000000000000  -0.250000000000000  0.093401029697326
-0.250000000000000  -0.250000000000000  -0.750000000000000  0.093401029697326
0.250000000000000  -0.750000000000000  -0.750000000000000  0.093401029697326
-0.750000000000000  -0.750000000000000  -0.250000000000000  0.093401029697326
-0.750000000000000  -0.250000000000000  -0.750000000000000  0.093401029697326
-0.250000000000000  -0.750000000000000  -0.750000000000000  0.093401029697326
-0.750000000000000  -0.750000000000000  -0.750000000000000  0.093401029697326
-0.666666666666667  -0.666666666666667  0.000000000000000  -0.005325487012987
-0.666666666666667  0.000000000000000  -0.666666666666667  -0.005325487012987
0.000000000000000  -0.666666666666667  -0.666666666666667  -0.005325487012987
-0.666666666666667  -0.666666666666667  -0.666666666666667  -0.005325487012987
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.000050166568685
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=13
*/
template<typename T>
struct IMTetrahedra<13,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 13;
    static const uint16_type nPoints = 210;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.875000000000000,  -0.875000000000000,  0.625000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  0.375000000000000,  0.420407272132140,
-0.875000000000000,  -0.375000000000000,  0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.125000000000000,  -0.125000000000000,  0.420407272132140,
-0.875000000000000,  0.125000000000000,  -0.375000000000000,  0.420407272132140,
-0.875000000000000,  0.375000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  0.625000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  0.375000000000000,  0.420407272132140,
-0.625000000000000,  -0.625000000000000,  0.125000000000000,  0.420407272132140,
-0.625000000000000,  -0.375000000000000,  -0.125000000000000,  0.420407272132140,
-0.625000000000000,  -0.125000000000000,  -0.375000000000000,  0.420407272132140,
-0.625000000000000,  0.125000000000000,  -0.625000000000000,  0.420407272132140,
-0.625000000000000,  0.375000000000000,  -0.875000000000000,  0.420407272132140,
-0.375000000000000,  -0.875000000000000,  0.125000000000000,  0.420407272132140,
-0.375000000000000,  -0.625000000000000,  -0.125000000000000,  0.420407272132140,
-0.375000000000000,  -0.375000000000000,  -0.375000000000000,  0.420407272132140,
-0.375000000000000,  -0.125000000000000,  -0.625000000000000,  0.420407272132140,
-0.375000000000000,  0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.125000000000000,  -0.875000000000000,  -0.125000000000000,  0.420407272132140,
-0.125000000000000,  -0.625000000000000,  -0.375000000000000,  0.420407272132140,
-0.125000000000000,  -0.375000000000000,  -0.625000000000000,  0.420407272132140,
-0.125000000000000,  -0.125000000000000,  -0.875000000000000,  0.420407272132140,
0.125000000000000,  -0.875000000000000,  -0.375000000000000,  0.420407272132140,
0.125000000000000,  -0.625000000000000,  -0.625000000000000,  0.420407272132140,
0.125000000000000,  -0.375000000000000,  -0.875000000000000,  0.420407272132140,
0.375000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
0.375000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
0.625000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  0.375000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.375000000000000,  -0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.125000000000000,  -0.375000000000000,  0.420407272132140,
-0.875000000000000,  0.125000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  0.375000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  0.125000000000000,  0.420407272132140,
-0.625000000000000,  -0.625000000000000,  -0.125000000000000,  0.420407272132140,
-0.625000000000000,  -0.375000000000000,  -0.375000000000000,  0.420407272132140,
-0.625000000000000,  -0.125000000000000,  -0.625000000000000,  0.420407272132140,
-0.625000000000000,  0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.375000000000000,  -0.875000000000000,  -0.125000000000000,  0.420407272132140,
-0.375000000000000,  -0.625000000000000,  -0.375000000000000,  0.420407272132140,
-0.375000000000000,  -0.375000000000000,  -0.625000000000000,  0.420407272132140,
-0.375000000000000,  -0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.125000000000000,  -0.875000000000000,  -0.375000000000000,  0.420407272132140,
-0.125000000000000,  -0.625000000000000,  -0.625000000000000,  0.420407272132140,
-0.125000000000000,  -0.375000000000000,  -0.875000000000000,  0.420407272132140,
0.125000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
0.125000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
0.375000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  -0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.375000000000000,  -0.375000000000000,  0.420407272132140,
-0.875000000000000,  -0.125000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  -0.125000000000000,  0.420407272132140,
-0.625000000000000,  -0.625000000000000,  -0.375000000000000,  0.420407272132140,
-0.625000000000000,  -0.375000000000000,  -0.625000000000000,  0.420407272132140,
-0.625000000000000,  -0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.375000000000000,  -0.875000000000000,  -0.375000000000000,  0.420407272132140,
-0.375000000000000,  -0.625000000000000,  -0.625000000000000,  0.420407272132140,
-0.375000000000000,  -0.375000000000000,  -0.875000000000000,  0.420407272132140,
-0.125000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
-0.125000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
0.125000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  -0.125000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  -0.375000000000000,  0.420407272132140,
-0.875000000000000,  -0.375000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  -0.125000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  -0.375000000000000,  0.420407272132140,
-0.625000000000000,  -0.625000000000000,  -0.625000000000000,  0.420407272132140,
-0.625000000000000,  -0.375000000000000,  -0.875000000000000,  0.420407272132140,
-0.375000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
-0.375000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
-0.125000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  -0.375000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  -0.375000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
-0.625000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
-0.375000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  -0.625000000000000,  0.420407272132140,
-0.875000000000000,  -0.625000000000000,  -0.875000000000000,  0.420407272132140,
-0.625000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.875000000000000,  -0.875000000000000,  -0.875000000000000,  0.420407272132140,
-0.857142857142857,  -0.857142857142857,  0.571428571428571,  -1.185481802234117,
-0.857142857142857,  -0.571428571428571,  0.285714285714286,  -1.185481802234117,
-0.857142857142857,  -0.285714285714286,  0.000000000000000,  -1.185481802234117,
-0.857142857142857,  0.000000000000000,  -0.285714285714286,  -1.185481802234117,
-0.857142857142857,  0.285714285714286,  -0.571428571428571,  -1.185481802234117,
-0.857142857142857,  0.571428571428571,  -0.857142857142857,  -1.185481802234117,
-0.571428571428571,  -0.857142857142857,  0.285714285714286,  -1.185481802234117,
-0.571428571428571,  -0.571428571428571,  0.000000000000000,  -1.185481802234117,
-0.571428571428571,  -0.285714285714286,  -0.285714285714286,  -1.185481802234117,
-0.571428571428571,  0.000000000000000,  -0.571428571428571,  -1.185481802234117,
-0.571428571428571,  0.285714285714286,  -0.857142857142857,  -1.185481802234117,
-0.285714285714286,  -0.857142857142857,  0.000000000000000,  -1.185481802234117,
-0.285714285714286,  -0.571428571428571,  -0.285714285714286,  -1.185481802234117,
-0.285714285714286,  -0.285714285714286,  -0.571428571428571,  -1.185481802234117,
-0.285714285714286,  0.000000000000000,  -0.857142857142857,  -1.185481802234117,
0.000000000000000,  -0.857142857142857,  -0.285714285714286,  -1.185481802234117,
0.000000000000000,  -0.571428571428571,  -0.571428571428571,  -1.185481802234117,
0.000000000000000,  -0.285714285714286,  -0.857142857142857,  -1.185481802234117,
0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -1.185481802234117,
0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -1.185481802234117,
0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.857142857142857,  -0.857142857142857,  0.285714285714286,  -1.185481802234117,
-0.857142857142857,  -0.571428571428571,  0.000000000000000,  -1.185481802234117,
-0.857142857142857,  -0.285714285714286,  -0.285714285714286,  -1.185481802234117,
-0.857142857142857,  0.000000000000000,  -0.571428571428571,  -1.185481802234117,
-0.857142857142857,  0.285714285714286,  -0.857142857142857,  -1.185481802234117,
-0.571428571428571,  -0.857142857142857,  0.000000000000000,  -1.185481802234117,
-0.571428571428571,  -0.571428571428571,  -0.285714285714286,  -1.185481802234117,
-0.571428571428571,  -0.285714285714286,  -0.571428571428571,  -1.185481802234117,
-0.571428571428571,  0.000000000000000,  -0.857142857142857,  -1.185481802234117,
-0.285714285714286,  -0.857142857142857,  -0.285714285714286,  -1.185481802234117,
-0.285714285714286,  -0.571428571428571,  -0.571428571428571,  -1.185481802234117,
-0.285714285714286,  -0.285714285714286,  -0.857142857142857,  -1.185481802234117,
0.000000000000000,  -0.857142857142857,  -0.571428571428571,  -1.185481802234117,
0.000000000000000,  -0.571428571428571,  -0.857142857142857,  -1.185481802234117,
0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.857142857142857,  -0.857142857142857,  0.000000000000000,  -1.185481802234117,
-0.857142857142857,  -0.571428571428571,  -0.285714285714286,  -1.185481802234117,
-0.857142857142857,  -0.285714285714286,  -0.571428571428571,  -1.185481802234117,
-0.857142857142857,  0.000000000000000,  -0.857142857142857,  -1.185481802234117,
-0.571428571428571,  -0.857142857142857,  -0.285714285714286,  -1.185481802234117,
-0.571428571428571,  -0.571428571428571,  -0.571428571428571,  -1.185481802234117,
-0.571428571428571,  -0.285714285714286,  -0.857142857142857,  -1.185481802234117,
-0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -1.185481802234117,
-0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -1.185481802234117,
0.000000000000000,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.857142857142857,  -0.857142857142857,  -0.285714285714286,  -1.185481802234117,
-0.857142857142857,  -0.571428571428571,  -0.571428571428571,  -1.185481802234117,
-0.857142857142857,  -0.285714285714286,  -0.857142857142857,  -1.185481802234117,
-0.571428571428571,  -0.857142857142857,  -0.571428571428571,  -1.185481802234117,
-0.571428571428571,  -0.571428571428571,  -0.857142857142857,  -1.185481802234117,
-0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.857142857142857,  -0.857142857142857,  -0.571428571428571,  -1.185481802234117,
-0.857142857142857,  -0.571428571428571,  -0.857142857142857,  -1.185481802234117,
-0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.857142857142857,  -0.857142857142857,  -0.857142857142857,  -1.185481802234117,
-0.833333333333333,  -0.833333333333333,  0.500000000000000,  1.198527187098616,
-0.833333333333333,  -0.500000000000000,  0.166666666666667,  1.198527187098616,
-0.833333333333333,  -0.166666666666667,  -0.166666666666667,  1.198527187098616,
-0.833333333333333,  0.166666666666667,  -0.500000000000000,  1.198527187098616,
-0.833333333333333,  0.500000000000000,  -0.833333333333333,  1.198527187098616,
-0.500000000000000,  -0.833333333333333,  0.166666666666667,  1.198527187098616,
-0.500000000000000,  -0.500000000000000,  -0.166666666666667,  1.198527187098616,
-0.500000000000000,  -0.166666666666667,  -0.500000000000000,  1.198527187098616,
-0.500000000000000,  0.166666666666667,  -0.833333333333333,  1.198527187098616,
-0.166666666666667,  -0.833333333333333,  -0.166666666666667,  1.198527187098616,
-0.166666666666667,  -0.500000000000000,  -0.500000000000000,  1.198527187098616,
-0.166666666666667,  -0.166666666666667,  -0.833333333333333,  1.198527187098616,
0.166666666666667,  -0.833333333333333,  -0.500000000000000,  1.198527187098616,
0.166666666666667,  -0.500000000000000,  -0.833333333333333,  1.198527187098616,
0.500000000000000,  -0.833333333333333,  -0.833333333333333,  1.198527187098616,
-0.833333333333333,  -0.833333333333333,  0.166666666666667,  1.198527187098616,
-0.833333333333333,  -0.500000000000000,  -0.166666666666667,  1.198527187098616,
-0.833333333333333,  -0.166666666666667,  -0.500000000000000,  1.198527187098616,
-0.833333333333333,  0.166666666666667,  -0.833333333333333,  1.198527187098616,
-0.500000000000000,  -0.833333333333333,  -0.166666666666667,  1.198527187098616,
-0.500000000000000,  -0.500000000000000,  -0.500000000000000,  1.198527187098616,
-0.500000000000000,  -0.166666666666667,  -0.833333333333333,  1.198527187098616,
-0.166666666666667,  -0.833333333333333,  -0.500000000000000,  1.198527187098616,
-0.166666666666667,  -0.500000000000000,  -0.833333333333333,  1.198527187098616,
0.166666666666667,  -0.833333333333333,  -0.833333333333333,  1.198527187098616,
-0.833333333333333,  -0.833333333333333,  -0.166666666666667,  1.198527187098616,
-0.833333333333333,  -0.500000000000000,  -0.500000000000000,  1.198527187098616,
-0.833333333333333,  -0.166666666666667,  -0.833333333333333,  1.198527187098616,
-0.500000000000000,  -0.833333333333333,  -0.500000000000000,  1.198527187098616,
-0.500000000000000,  -0.500000000000000,  -0.833333333333333,  1.198527187098616,
-0.166666666666667,  -0.833333333333333,  -0.833333333333333,  1.198527187098616,
-0.833333333333333,  -0.833333333333333,  -0.500000000000000,  1.198527187098616,
-0.833333333333333,  -0.500000000000000,  -0.833333333333333,  1.198527187098616,
-0.500000000000000,  -0.833333333333333,  -0.833333333333333,  1.198527187098616,
-0.833333333333333,  -0.833333333333333,  -0.833333333333333,  1.198527187098616,
-0.800000000000000,  -0.800000000000000,  0.400000000000000,  -0.522755333229870,
-0.800000000000000,  -0.400000000000000,  0.000000000000000,  -0.522755333229870,
-0.800000000000000,  0.000000000000000,  -0.400000000000000,  -0.522755333229870,
-0.800000000000000,  0.400000000000000,  -0.800000000000000,  -0.522755333229870,
-0.400000000000000,  -0.800000000000000,  0.000000000000000,  -0.522755333229870,
-0.400000000000000,  -0.400000000000000,  -0.400000000000000,  -0.522755333229870,
-0.400000000000000,  0.000000000000000,  -0.800000000000000,  -0.522755333229870,
0.000000000000000,  -0.800000000000000,  -0.400000000000000,  -0.522755333229870,
0.000000000000000,  -0.400000000000000,  -0.800000000000000,  -0.522755333229870,
0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.522755333229870,
-0.800000000000000,  -0.800000000000000,  0.000000000000000,  -0.522755333229870,
-0.800000000000000,  -0.400000000000000,  -0.400000000000000,  -0.522755333229870,
-0.800000000000000,  0.000000000000000,  -0.800000000000000,  -0.522755333229870,
-0.400000000000000,  -0.800000000000000,  -0.400000000000000,  -0.522755333229870,
-0.400000000000000,  -0.400000000000000,  -0.800000000000000,  -0.522755333229870,
0.000000000000000,  -0.800000000000000,  -0.800000000000000,  -0.522755333229870,
-0.800000000000000,  -0.800000000000000,  -0.400000000000000,  -0.522755333229870,
-0.800000000000000,  -0.400000000000000,  -0.800000000000000,  -0.522755333229870,
-0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.522755333229870,
-0.800000000000000,  -0.800000000000000,  -0.800000000000000,  -0.522755333229870,
-0.750000000000000,  -0.750000000000000,  0.250000000000000,  0.093401029697326,
-0.750000000000000,  -0.250000000000000,  -0.250000000000000,  0.093401029697326,
-0.750000000000000,  0.250000000000000,  -0.750000000000000,  0.093401029697326,
-0.250000000000000,  -0.750000000000000,  -0.250000000000000,  0.093401029697326,
-0.250000000000000,  -0.250000000000000,  -0.750000000000000,  0.093401029697326,
0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.093401029697326,
-0.750000000000000,  -0.750000000000000,  -0.250000000000000,  0.093401029697326,
-0.750000000000000,  -0.250000000000000,  -0.750000000000000,  0.093401029697326,
-0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.093401029697326,
-0.750000000000000,  -0.750000000000000,  -0.750000000000000,  0.093401029697326,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  -0.005325487012987,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  -0.005325487012987,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  -0.005325487012987,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  -0.005325487012987,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.000050166568685;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<12,T>: public IMTetrahedra<13,T> {};
/*
330
-0.888888888888889  -0.888888888888889  0.666666666666667  0.514536992829256
-0.888888888888889  -0.666666666666667  0.444444444444444  0.514536992829256
-0.888888888888889  -0.444444444444444  0.222222222222222  0.514536992829256
-0.888888888888889  -0.222222222222222  0.000000000000000  0.514536992829256
-0.888888888888889  0.000000000000000  -0.222222222222222  0.514536992829256
-0.888888888888889  0.222222222222222  -0.444444444444444  0.514536992829256
-0.888888888888889  0.444444444444444  -0.666666666666667  0.514536992829256
-0.888888888888889  0.666666666666667  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  0.444444444444444  0.514536992829256
-0.666666666666667  -0.666666666666667  0.222222222222222  0.514536992829256
-0.666666666666667  -0.444444444444444  0.000000000000000  0.514536992829256
-0.666666666666667  -0.222222222222222  -0.222222222222222  0.514536992829256
-0.666666666666667  0.000000000000000  -0.444444444444444  0.514536992829256
-0.666666666666667  0.222222222222222  -0.666666666666667  0.514536992829256
-0.666666666666667  0.444444444444444  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  0.222222222222222  0.514536992829256
-0.444444444444444  -0.666666666666667  0.000000000000000  0.514536992829256
-0.444444444444444  -0.444444444444444  -0.222222222222222  0.514536992829256
-0.444444444444444  -0.222222222222222  -0.444444444444444  0.514536992829256
-0.444444444444444  0.000000000000000  -0.666666666666667  0.514536992829256
-0.444444444444444  0.222222222222222  -0.888888888888889  0.514536992829256
-0.222222222222222  -0.888888888888889  0.000000000000000  0.514536992829256
-0.222222222222222  -0.666666666666667  -0.222222222222222  0.514536992829256
-0.222222222222222  -0.444444444444444  -0.444444444444444  0.514536992829256
-0.222222222222222  -0.222222222222222  -0.666666666666667  0.514536992829256
-0.222222222222222  0.000000000000000  -0.888888888888889  0.514536992829256
0.000000000000000  -0.888888888888889  -0.222222222222222  0.514536992829256
0.000000000000000  -0.666666666666667  -0.444444444444444  0.514536992829256
0.000000000000000  -0.444444444444444  -0.666666666666667  0.514536992829256
0.000000000000000  -0.222222222222222  -0.888888888888889  0.514536992829256
0.222222222222222  -0.888888888888889  -0.444444444444444  0.514536992829256
0.222222222222222  -0.666666666666667  -0.666666666666667  0.514536992829256
0.222222222222222  -0.444444444444444  -0.888888888888889  0.514536992829256
0.444444444444444  -0.888888888888889  -0.666666666666667  0.514536992829256
0.444444444444444  -0.666666666666667  -0.888888888888889  0.514536992829256
0.666666666666667  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  0.444444444444444  0.514536992829256
-0.888888888888889  -0.666666666666667  0.222222222222222  0.514536992829256
-0.888888888888889  -0.444444444444444  0.000000000000000  0.514536992829256
-0.888888888888889  -0.222222222222222  -0.222222222222222  0.514536992829256
-0.888888888888889  0.000000000000000  -0.444444444444444  0.514536992829256
-0.888888888888889  0.222222222222222  -0.666666666666667  0.514536992829256
-0.888888888888889  0.444444444444444  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  0.222222222222222  0.514536992829256
-0.666666666666667  -0.666666666666667  0.000000000000000  0.514536992829256
-0.666666666666667  -0.444444444444444  -0.222222222222222  0.514536992829256
-0.666666666666667  -0.222222222222222  -0.444444444444444  0.514536992829256
-0.666666666666667  0.000000000000000  -0.666666666666667  0.514536992829256
-0.666666666666667  0.222222222222222  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  0.000000000000000  0.514536992829256
-0.444444444444444  -0.666666666666667  -0.222222222222222  0.514536992829256
-0.444444444444444  -0.444444444444444  -0.444444444444444  0.514536992829256
-0.444444444444444  -0.222222222222222  -0.666666666666667  0.514536992829256
-0.444444444444444  0.000000000000000  -0.888888888888889  0.514536992829256
-0.222222222222222  -0.888888888888889  -0.222222222222222  0.514536992829256
-0.222222222222222  -0.666666666666667  -0.444444444444444  0.514536992829256
-0.222222222222222  -0.444444444444444  -0.666666666666667  0.514536992829256
-0.222222222222222  -0.222222222222222  -0.888888888888889  0.514536992829256
0.000000000000000  -0.888888888888889  -0.444444444444444  0.514536992829256
0.000000000000000  -0.666666666666667  -0.666666666666667  0.514536992829256
0.000000000000000  -0.444444444444444  -0.888888888888889  0.514536992829256
0.222222222222222  -0.888888888888889  -0.666666666666667  0.514536992829256
0.222222222222222  -0.666666666666667  -0.888888888888889  0.514536992829256
0.444444444444444  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  0.222222222222222  0.514536992829256
-0.888888888888889  -0.666666666666667  0.000000000000000  0.514536992829256
-0.888888888888889  -0.444444444444444  -0.222222222222222  0.514536992829256
-0.888888888888889  -0.222222222222222  -0.444444444444444  0.514536992829256
-0.888888888888889  0.000000000000000  -0.666666666666667  0.514536992829256
-0.888888888888889  0.222222222222222  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  0.000000000000000  0.514536992829256
-0.666666666666667  -0.666666666666667  -0.222222222222222  0.514536992829256
-0.666666666666667  -0.444444444444444  -0.444444444444444  0.514536992829256
-0.666666666666667  -0.222222222222222  -0.666666666666667  0.514536992829256
-0.666666666666667  0.000000000000000  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  -0.222222222222222  0.514536992829256
-0.444444444444444  -0.666666666666667  -0.444444444444444  0.514536992829256
-0.444444444444444  -0.444444444444444  -0.666666666666667  0.514536992829256
-0.444444444444444  -0.222222222222222  -0.888888888888889  0.514536992829256
-0.222222222222222  -0.888888888888889  -0.444444444444444  0.514536992829256
-0.222222222222222  -0.666666666666667  -0.666666666666667  0.514536992829256
-0.222222222222222  -0.444444444444444  -0.888888888888889  0.514536992829256
0.000000000000000  -0.888888888888889  -0.666666666666667  0.514536992829256
0.000000000000000  -0.666666666666667  -0.888888888888889  0.514536992829256
0.222222222222222  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  0.000000000000000  0.514536992829256
-0.888888888888889  -0.666666666666667  -0.222222222222222  0.514536992829256
-0.888888888888889  -0.444444444444444  -0.444444444444444  0.514536992829256
-0.888888888888889  -0.222222222222222  -0.666666666666667  0.514536992829256
-0.888888888888889  0.000000000000000  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  -0.222222222222222  0.514536992829256
-0.666666666666667  -0.666666666666667  -0.444444444444444  0.514536992829256
-0.666666666666667  -0.444444444444444  -0.666666666666667  0.514536992829256
-0.666666666666667  -0.222222222222222  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  -0.444444444444444  0.514536992829256
-0.444444444444444  -0.666666666666667  -0.666666666666667  0.514536992829256
-0.444444444444444  -0.444444444444444  -0.888888888888889  0.514536992829256
-0.222222222222222  -0.888888888888889  -0.666666666666667  0.514536992829256
-0.222222222222222  -0.666666666666667  -0.888888888888889  0.514536992829256
0.000000000000000  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  -0.222222222222222  0.514536992829256
-0.888888888888889  -0.666666666666667  -0.444444444444444  0.514536992829256
-0.888888888888889  -0.444444444444444  -0.666666666666667  0.514536992829256
-0.888888888888889  -0.222222222222222  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  -0.444444444444444  0.514536992829256
-0.666666666666667  -0.666666666666667  -0.666666666666667  0.514536992829256
-0.666666666666667  -0.444444444444444  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  -0.666666666666667  0.514536992829256
-0.444444444444444  -0.666666666666667  -0.888888888888889  0.514536992829256
-0.222222222222222  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  -0.444444444444444  0.514536992829256
-0.888888888888889  -0.666666666666667  -0.666666666666667  0.514536992829256
-0.888888888888889  -0.444444444444444  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  -0.666666666666667  0.514536992829256
-0.666666666666667  -0.666666666666667  -0.888888888888889  0.514536992829256
-0.444444444444444  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  -0.666666666666667  0.514536992829256
-0.888888888888889  -0.666666666666667  -0.888888888888889  0.514536992829256
-0.666666666666667  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.888888888888889  -0.888888888888889  -0.888888888888889  0.514536992829256
-0.875000000000000  -0.875000000000000  0.625000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  0.375000000000000  -1.582709730379821
-0.875000000000000  -0.375000000000000  0.125000000000000  -1.582709730379821
-0.875000000000000  -0.125000000000000  -0.125000000000000  -1.582709730379821
-0.875000000000000  0.125000000000000  -0.375000000000000  -1.582709730379821
-0.875000000000000  0.375000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  0.625000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  0.375000000000000  -1.582709730379821
-0.625000000000000  -0.625000000000000  0.125000000000000  -1.582709730379821
-0.625000000000000  -0.375000000000000  -0.125000000000000  -1.582709730379821
-0.625000000000000  -0.125000000000000  -0.375000000000000  -1.582709730379821
-0.625000000000000  0.125000000000000  -0.625000000000000  -1.582709730379821
-0.625000000000000  0.375000000000000  -0.875000000000000  -1.582709730379821
-0.375000000000000  -0.875000000000000  0.125000000000000  -1.582709730379821
-0.375000000000000  -0.625000000000000  -0.125000000000000  -1.582709730379821
-0.375000000000000  -0.375000000000000  -0.375000000000000  -1.582709730379821
-0.375000000000000  -0.125000000000000  -0.625000000000000  -1.582709730379821
-0.375000000000000  0.125000000000000  -0.875000000000000  -1.582709730379821
-0.125000000000000  -0.875000000000000  -0.125000000000000  -1.582709730379821
-0.125000000000000  -0.625000000000000  -0.375000000000000  -1.582709730379821
-0.125000000000000  -0.375000000000000  -0.625000000000000  -1.582709730379821
-0.125000000000000  -0.125000000000000  -0.875000000000000  -1.582709730379821
0.125000000000000  -0.875000000000000  -0.375000000000000  -1.582709730379821
0.125000000000000  -0.625000000000000  -0.625000000000000  -1.582709730379821
0.125000000000000  -0.375000000000000  -0.875000000000000  -1.582709730379821
0.375000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
0.375000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
0.625000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  0.375000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  0.125000000000000  -1.582709730379821
-0.875000000000000  -0.375000000000000  -0.125000000000000  -1.582709730379821
-0.875000000000000  -0.125000000000000  -0.375000000000000  -1.582709730379821
-0.875000000000000  0.125000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  0.375000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  0.125000000000000  -1.582709730379821
-0.625000000000000  -0.625000000000000  -0.125000000000000  -1.582709730379821
-0.625000000000000  -0.375000000000000  -0.375000000000000  -1.582709730379821
-0.625000000000000  -0.125000000000000  -0.625000000000000  -1.582709730379821
-0.625000000000000  0.125000000000000  -0.875000000000000  -1.582709730379821
-0.375000000000000  -0.875000000000000  -0.125000000000000  -1.582709730379821
-0.375000000000000  -0.625000000000000  -0.375000000000000  -1.582709730379821
-0.375000000000000  -0.375000000000000  -0.625000000000000  -1.582709730379821
-0.375000000000000  -0.125000000000000  -0.875000000000000  -1.582709730379821
-0.125000000000000  -0.875000000000000  -0.375000000000000  -1.582709730379821
-0.125000000000000  -0.625000000000000  -0.625000000000000  -1.582709730379821
-0.125000000000000  -0.375000000000000  -0.875000000000000  -1.582709730379821
0.125000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
0.125000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
0.375000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  0.125000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  -0.125000000000000  -1.582709730379821
-0.875000000000000  -0.375000000000000  -0.375000000000000  -1.582709730379821
-0.875000000000000  -0.125000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  0.125000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  -0.125000000000000  -1.582709730379821
-0.625000000000000  -0.625000000000000  -0.375000000000000  -1.582709730379821
-0.625000000000000  -0.375000000000000  -0.625000000000000  -1.582709730379821
-0.625000000000000  -0.125000000000000  -0.875000000000000  -1.582709730379821
-0.375000000000000  -0.875000000000000  -0.375000000000000  -1.582709730379821
-0.375000000000000  -0.625000000000000  -0.625000000000000  -1.582709730379821
-0.375000000000000  -0.375000000000000  -0.875000000000000  -1.582709730379821
-0.125000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
-0.125000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
0.125000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  -0.125000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  -0.375000000000000  -1.582709730379821
-0.875000000000000  -0.375000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  -0.125000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  -0.375000000000000  -1.582709730379821
-0.625000000000000  -0.625000000000000  -0.625000000000000  -1.582709730379821
-0.625000000000000  -0.375000000000000  -0.875000000000000  -1.582709730379821
-0.375000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
-0.375000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
-0.125000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  -0.375000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  -0.375000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
-0.625000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
-0.375000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  -0.625000000000000  -1.582709730379821
-0.875000000000000  -0.625000000000000  -0.875000000000000  -1.582709730379821
-0.625000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.875000000000000  -0.875000000000000  -0.875000000000000  -1.582709730379821
-0.857142857142857  -0.857142857142857  0.571428571428571  1.815269009670992
-0.857142857142857  -0.571428571428571  0.285714285714286  1.815269009670992
-0.857142857142857  -0.285714285714286  0.000000000000000  1.815269009670992
-0.857142857142857  0.000000000000000  -0.285714285714286  1.815269009670992
-0.857142857142857  0.285714285714286  -0.571428571428571  1.815269009670992
-0.857142857142857  0.571428571428571  -0.857142857142857  1.815269009670992
-0.571428571428571  -0.857142857142857  0.285714285714286  1.815269009670992
-0.571428571428571  -0.571428571428571  0.000000000000000  1.815269009670992
-0.571428571428571  -0.285714285714286  -0.285714285714286  1.815269009670992
-0.571428571428571  0.000000000000000  -0.571428571428571  1.815269009670992
-0.571428571428571  0.285714285714286  -0.857142857142857  1.815269009670992
-0.285714285714286  -0.857142857142857  0.000000000000000  1.815269009670992
-0.285714285714286  -0.571428571428571  -0.285714285714286  1.815269009670992
-0.285714285714286  -0.285714285714286  -0.571428571428571  1.815269009670992
-0.285714285714286  0.000000000000000  -0.857142857142857  1.815269009670992
0.000000000000000  -0.857142857142857  -0.285714285714286  1.815269009670992
0.000000000000000  -0.571428571428571  -0.571428571428571  1.815269009670992
0.000000000000000  -0.285714285714286  -0.857142857142857  1.815269009670992
0.285714285714286  -0.857142857142857  -0.571428571428571  1.815269009670992
0.285714285714286  -0.571428571428571  -0.857142857142857  1.815269009670992
0.571428571428571  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.857142857142857  -0.857142857142857  0.285714285714286  1.815269009670992
-0.857142857142857  -0.571428571428571  0.000000000000000  1.815269009670992
-0.857142857142857  -0.285714285714286  -0.285714285714286  1.815269009670992
-0.857142857142857  0.000000000000000  -0.571428571428571  1.815269009670992
-0.857142857142857  0.285714285714286  -0.857142857142857  1.815269009670992
-0.571428571428571  -0.857142857142857  0.000000000000000  1.815269009670992
-0.571428571428571  -0.571428571428571  -0.285714285714286  1.815269009670992
-0.571428571428571  -0.285714285714286  -0.571428571428571  1.815269009670992
-0.571428571428571  0.000000000000000  -0.857142857142857  1.815269009670992
-0.285714285714286  -0.857142857142857  -0.285714285714286  1.815269009670992
-0.285714285714286  -0.571428571428571  -0.571428571428571  1.815269009670992
-0.285714285714286  -0.285714285714286  -0.857142857142857  1.815269009670992
0.000000000000000  -0.857142857142857  -0.571428571428571  1.815269009670992
0.000000000000000  -0.571428571428571  -0.857142857142857  1.815269009670992
0.285714285714286  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.857142857142857  -0.857142857142857  0.000000000000000  1.815269009670992
-0.857142857142857  -0.571428571428571  -0.285714285714286  1.815269009670992
-0.857142857142857  -0.285714285714286  -0.571428571428571  1.815269009670992
-0.857142857142857  0.000000000000000  -0.857142857142857  1.815269009670992
-0.571428571428571  -0.857142857142857  -0.285714285714286  1.815269009670992
-0.571428571428571  -0.571428571428571  -0.571428571428571  1.815269009670992
-0.571428571428571  -0.285714285714286  -0.857142857142857  1.815269009670992
-0.285714285714286  -0.857142857142857  -0.571428571428571  1.815269009670992
-0.285714285714286  -0.571428571428571  -0.857142857142857  1.815269009670992
0.000000000000000  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.857142857142857  -0.857142857142857  -0.285714285714286  1.815269009670992
-0.857142857142857  -0.571428571428571  -0.571428571428571  1.815269009670992
-0.857142857142857  -0.285714285714286  -0.857142857142857  1.815269009670992
-0.571428571428571  -0.857142857142857  -0.571428571428571  1.815269009670992
-0.571428571428571  -0.571428571428571  -0.857142857142857  1.815269009670992
-0.285714285714286  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.857142857142857  -0.857142857142857  -0.571428571428571  1.815269009670992
-0.857142857142857  -0.571428571428571  -0.857142857142857  1.815269009670992
-0.571428571428571  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.857142857142857  -0.857142857142857  -0.857142857142857  1.815269009670992
-0.833333333333333  -0.833333333333333  0.500000000000000  -0.958821749678893
-0.833333333333333  -0.500000000000000  0.166666666666667  -0.958821749678893
-0.833333333333333  -0.166666666666667  -0.166666666666667  -0.958821749678893
-0.833333333333333  0.166666666666667  -0.500000000000000  -0.958821749678893
-0.833333333333333  0.500000000000000  -0.833333333333333  -0.958821749678893
-0.500000000000000  -0.833333333333333  0.166666666666667  -0.958821749678893
-0.500000000000000  -0.500000000000000  -0.166666666666667  -0.958821749678893
-0.500000000000000  -0.166666666666667  -0.500000000000000  -0.958821749678893
-0.500000000000000  0.166666666666667  -0.833333333333333  -0.958821749678893
-0.166666666666667  -0.833333333333333  -0.166666666666667  -0.958821749678893
-0.166666666666667  -0.500000000000000  -0.500000000000000  -0.958821749678893
-0.166666666666667  -0.166666666666667  -0.833333333333333  -0.958821749678893
0.166666666666667  -0.833333333333333  -0.500000000000000  -0.958821749678893
0.166666666666667  -0.500000000000000  -0.833333333333333  -0.958821749678893
0.500000000000000  -0.833333333333333  -0.833333333333333  -0.958821749678893
-0.833333333333333  -0.833333333333333  0.166666666666667  -0.958821749678893
-0.833333333333333  -0.500000000000000  -0.166666666666667  -0.958821749678893
-0.833333333333333  -0.166666666666667  -0.500000000000000  -0.958821749678893
-0.833333333333333  0.166666666666667  -0.833333333333333  -0.958821749678893
-0.500000000000000  -0.833333333333333  -0.166666666666667  -0.958821749678893
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.958821749678893
-0.500000000000000  -0.166666666666667  -0.833333333333333  -0.958821749678893
-0.166666666666667  -0.833333333333333  -0.500000000000000  -0.958821749678893
-0.166666666666667  -0.500000000000000  -0.833333333333333  -0.958821749678893
0.166666666666667  -0.833333333333333  -0.833333333333333  -0.958821749678893
-0.833333333333333  -0.833333333333333  -0.166666666666667  -0.958821749678893
-0.833333333333333  -0.500000000000000  -0.500000000000000  -0.958821749678893
-0.833333333333333  -0.166666666666667  -0.833333333333333  -0.958821749678893
-0.500000000000000  -0.833333333333333  -0.500000000000000  -0.958821749678893
-0.500000000000000  -0.500000000000000  -0.833333333333333  -0.958821749678893
-0.166666666666667  -0.833333333333333  -0.833333333333333  -0.958821749678893
-0.833333333333333  -0.833333333333333  -0.500000000000000  -0.958821749678893
-0.833333333333333  -0.500000000000000  -0.833333333333333  -0.958821749678893
-0.500000000000000  -0.833333333333333  -0.833333333333333  -0.958821749678893
-0.833333333333333  -0.833333333333333  -0.833333333333333  -0.958821749678893
-0.800000000000000  -0.800000000000000  0.400000000000000  0.233372916620478
-0.800000000000000  -0.400000000000000  0.000000000000000  0.233372916620478
-0.800000000000000  0.000000000000000  -0.400000000000000  0.233372916620478
-0.800000000000000  0.400000000000000  -0.800000000000000  0.233372916620478
-0.400000000000000  -0.800000000000000  0.000000000000000  0.233372916620478
-0.400000000000000  -0.400000000000000  -0.400000000000000  0.233372916620478
-0.400000000000000  0.000000000000000  -0.800000000000000  0.233372916620478
0.000000000000000  -0.800000000000000  -0.400000000000000  0.233372916620478
0.000000000000000  -0.400000000000000  -0.800000000000000  0.233372916620478
0.400000000000000  -0.800000000000000  -0.800000000000000  0.233372916620478
-0.800000000000000  -0.800000000000000  0.000000000000000  0.233372916620478
-0.800000000000000  -0.400000000000000  -0.400000000000000  0.233372916620478
-0.800000000000000  0.000000000000000  -0.800000000000000  0.233372916620478
-0.400000000000000  -0.800000000000000  -0.400000000000000  0.233372916620478
-0.400000000000000  -0.400000000000000  -0.800000000000000  0.233372916620478
0.000000000000000  -0.800000000000000  -0.800000000000000  0.233372916620478
-0.800000000000000  -0.800000000000000  -0.400000000000000  0.233372916620478
-0.800000000000000  -0.400000000000000  -0.800000000000000  0.233372916620478
-0.400000000000000  -0.800000000000000  -0.800000000000000  0.233372916620478
-0.800000000000000  -0.800000000000000  -0.800000000000000  0.233372916620478
-0.750000000000000  -0.750000000000000  0.250000000000000  -0.022991022694726
-0.750000000000000  -0.250000000000000  -0.250000000000000  -0.022991022694726
-0.750000000000000  0.250000000000000  -0.750000000000000  -0.022991022694726
-0.250000000000000  -0.750000000000000  -0.250000000000000  -0.022991022694726
-0.250000000000000  -0.250000000000000  -0.750000000000000  -0.022991022694726
0.250000000000000  -0.750000000000000  -0.750000000000000  -0.022991022694726
-0.750000000000000  -0.750000000000000  -0.250000000000000  -0.022991022694726
-0.750000000000000  -0.250000000000000  -0.750000000000000  -0.022991022694726
-0.250000000000000  -0.750000000000000  -0.750000000000000  -0.022991022694726
-0.750000000000000  -0.750000000000000  -0.750000000000000  -0.022991022694726
-0.666666666666667  -0.666666666666667  0.000000000000000  0.000665685876623
-0.666666666666667  0.000000000000000  -0.666666666666667  0.000665685876623
0.000000000000000  -0.666666666666667  -0.666666666666667  0.000665685876623
-0.666666666666667  -0.666666666666667  -0.666666666666667  0.000665685876623
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.000002606055516
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=15
*/
template<typename T>
struct IMTetrahedra<15,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 15;
    static const uint16_type nPoints = 330;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.888888888888889,  -0.888888888888889,  0.666666666666667,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  0.444444444444444,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.222222222222222,  0.000000000000000,  0.514536992829256,
-0.888888888888889,  0.000000000000000,  -0.222222222222222,  0.514536992829256,
-0.888888888888889,  0.222222222222222,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  0.444444444444444,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  0.666666666666667,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  0.444444444444444,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  0.222222222222222,  0.514536992829256,
-0.666666666666667,  -0.444444444444444,  0.000000000000000,  0.514536992829256,
-0.666666666666667,  -0.222222222222222,  -0.222222222222222,  0.514536992829256,
-0.666666666666667,  0.000000000000000,  -0.444444444444444,  0.514536992829256,
-0.666666666666667,  0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  0.444444444444444,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  0.222222222222222,  0.514536992829256,
-0.444444444444444,  -0.666666666666667,  0.000000000000000,  0.514536992829256,
-0.444444444444444,  -0.444444444444444,  -0.222222222222222,  0.514536992829256,
-0.444444444444444,  -0.222222222222222,  -0.444444444444444,  0.514536992829256,
-0.444444444444444,  0.000000000000000,  -0.666666666666667,  0.514536992829256,
-0.444444444444444,  0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.222222222222222,  -0.888888888888889,  0.000000000000000,  0.514536992829256,
-0.222222222222222,  -0.666666666666667,  -0.222222222222222,  0.514536992829256,
-0.222222222222222,  -0.444444444444444,  -0.444444444444444,  0.514536992829256,
-0.222222222222222,  -0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.222222222222222,  0.000000000000000,  -0.888888888888889,  0.514536992829256,
0.000000000000000,  -0.888888888888889,  -0.222222222222222,  0.514536992829256,
0.000000000000000,  -0.666666666666667,  -0.444444444444444,  0.514536992829256,
0.000000000000000,  -0.444444444444444,  -0.666666666666667,  0.514536992829256,
0.000000000000000,  -0.222222222222222,  -0.888888888888889,  0.514536992829256,
0.222222222222222,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
0.222222222222222,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
0.222222222222222,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
0.444444444444444,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
0.444444444444444,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
0.666666666666667,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  0.444444444444444,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  0.000000000000000,  0.514536992829256,
-0.888888888888889,  -0.222222222222222,  -0.222222222222222,  0.514536992829256,
-0.888888888888889,  0.000000000000000,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  0.444444444444444,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  0.222222222222222,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  0.514536992829256,
-0.666666666666667,  -0.444444444444444,  -0.222222222222222,  0.514536992829256,
-0.666666666666667,  -0.222222222222222,  -0.444444444444444,  0.514536992829256,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  0.000000000000000,  0.514536992829256,
-0.444444444444444,  -0.666666666666667,  -0.222222222222222,  0.514536992829256,
-0.444444444444444,  -0.444444444444444,  -0.444444444444444,  0.514536992829256,
-0.444444444444444,  -0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.444444444444444,  0.000000000000000,  -0.888888888888889,  0.514536992829256,
-0.222222222222222,  -0.888888888888889,  -0.222222222222222,  0.514536992829256,
-0.222222222222222,  -0.666666666666667,  -0.444444444444444,  0.514536992829256,
-0.222222222222222,  -0.444444444444444,  -0.666666666666667,  0.514536992829256,
-0.222222222222222,  -0.222222222222222,  -0.888888888888889,  0.514536992829256,
0.000000000000000,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
0.000000000000000,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
0.222222222222222,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
0.222222222222222,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
0.444444444444444,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  0.000000000000000,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  -0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.222222222222222,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  0.000000000000000,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  0.000000000000000,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  -0.222222222222222,  0.514536992829256,
-0.666666666666667,  -0.444444444444444,  -0.444444444444444,  0.514536992829256,
-0.666666666666667,  -0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  0.000000000000000,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  -0.222222222222222,  0.514536992829256,
-0.444444444444444,  -0.666666666666667,  -0.444444444444444,  0.514536992829256,
-0.444444444444444,  -0.444444444444444,  -0.666666666666667,  0.514536992829256,
-0.444444444444444,  -0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.222222222222222,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
-0.222222222222222,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
-0.222222222222222,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
0.000000000000000,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
0.000000000000000,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
0.222222222222222,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  0.000000000000000,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  -0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  -0.222222222222222,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  0.000000000000000,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  -0.222222222222222,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  -0.444444444444444,  0.514536992829256,
-0.666666666666667,  -0.444444444444444,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  -0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
-0.444444444444444,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
-0.444444444444444,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
-0.222222222222222,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
-0.222222222222222,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
0.000000000000000,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  -0.222222222222222,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  -0.222222222222222,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
-0.444444444444444,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
-0.222222222222222,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  -0.444444444444444,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  -0.444444444444444,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
-0.666666666666667,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
-0.444444444444444,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  -0.666666666666667,  0.514536992829256,
-0.888888888888889,  -0.666666666666667,  -0.888888888888889,  0.514536992829256,
-0.666666666666667,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.888888888888889,  -0.888888888888889,  -0.888888888888889,  0.514536992829256,
-0.875000000000000,  -0.875000000000000,  0.625000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  0.375000000000000,  -1.582709730379821,
-0.875000000000000,  -0.375000000000000,  0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.125000000000000,  -0.125000000000000,  -1.582709730379821,
-0.875000000000000,  0.125000000000000,  -0.375000000000000,  -1.582709730379821,
-0.875000000000000,  0.375000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  0.625000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  0.375000000000000,  -1.582709730379821,
-0.625000000000000,  -0.625000000000000,  0.125000000000000,  -1.582709730379821,
-0.625000000000000,  -0.375000000000000,  -0.125000000000000,  -1.582709730379821,
-0.625000000000000,  -0.125000000000000,  -0.375000000000000,  -1.582709730379821,
-0.625000000000000,  0.125000000000000,  -0.625000000000000,  -1.582709730379821,
-0.625000000000000,  0.375000000000000,  -0.875000000000000,  -1.582709730379821,
-0.375000000000000,  -0.875000000000000,  0.125000000000000,  -1.582709730379821,
-0.375000000000000,  -0.625000000000000,  -0.125000000000000,  -1.582709730379821,
-0.375000000000000,  -0.375000000000000,  -0.375000000000000,  -1.582709730379821,
-0.375000000000000,  -0.125000000000000,  -0.625000000000000,  -1.582709730379821,
-0.375000000000000,  0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.125000000000000,  -0.875000000000000,  -0.125000000000000,  -1.582709730379821,
-0.125000000000000,  -0.625000000000000,  -0.375000000000000,  -1.582709730379821,
-0.125000000000000,  -0.375000000000000,  -0.625000000000000,  -1.582709730379821,
-0.125000000000000,  -0.125000000000000,  -0.875000000000000,  -1.582709730379821,
0.125000000000000,  -0.875000000000000,  -0.375000000000000,  -1.582709730379821,
0.125000000000000,  -0.625000000000000,  -0.625000000000000,  -1.582709730379821,
0.125000000000000,  -0.375000000000000,  -0.875000000000000,  -1.582709730379821,
0.375000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
0.375000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
0.625000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  0.375000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.375000000000000,  -0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.125000000000000,  -0.375000000000000,  -1.582709730379821,
-0.875000000000000,  0.125000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  0.375000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  0.125000000000000,  -1.582709730379821,
-0.625000000000000,  -0.625000000000000,  -0.125000000000000,  -1.582709730379821,
-0.625000000000000,  -0.375000000000000,  -0.375000000000000,  -1.582709730379821,
-0.625000000000000,  -0.125000000000000,  -0.625000000000000,  -1.582709730379821,
-0.625000000000000,  0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.375000000000000,  -0.875000000000000,  -0.125000000000000,  -1.582709730379821,
-0.375000000000000,  -0.625000000000000,  -0.375000000000000,  -1.582709730379821,
-0.375000000000000,  -0.375000000000000,  -0.625000000000000,  -1.582709730379821,
-0.375000000000000,  -0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.125000000000000,  -0.875000000000000,  -0.375000000000000,  -1.582709730379821,
-0.125000000000000,  -0.625000000000000,  -0.625000000000000,  -1.582709730379821,
-0.125000000000000,  -0.375000000000000,  -0.875000000000000,  -1.582709730379821,
0.125000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
0.125000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
0.375000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  -0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.375000000000000,  -0.375000000000000,  -1.582709730379821,
-0.875000000000000,  -0.125000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  -0.125000000000000,  -1.582709730379821,
-0.625000000000000,  -0.625000000000000,  -0.375000000000000,  -1.582709730379821,
-0.625000000000000,  -0.375000000000000,  -0.625000000000000,  -1.582709730379821,
-0.625000000000000,  -0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.375000000000000,  -0.875000000000000,  -0.375000000000000,  -1.582709730379821,
-0.375000000000000,  -0.625000000000000,  -0.625000000000000,  -1.582709730379821,
-0.375000000000000,  -0.375000000000000,  -0.875000000000000,  -1.582709730379821,
-0.125000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
-0.125000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
0.125000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  -0.125000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  -0.375000000000000,  -1.582709730379821,
-0.875000000000000,  -0.375000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  -0.125000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  -0.375000000000000,  -1.582709730379821,
-0.625000000000000,  -0.625000000000000,  -0.625000000000000,  -1.582709730379821,
-0.625000000000000,  -0.375000000000000,  -0.875000000000000,  -1.582709730379821,
-0.375000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
-0.375000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
-0.125000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  -0.375000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  -0.375000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
-0.625000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
-0.375000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  -0.625000000000000,  -1.582709730379821,
-0.875000000000000,  -0.625000000000000,  -0.875000000000000,  -1.582709730379821,
-0.625000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.875000000000000,  -0.875000000000000,  -0.875000000000000,  -1.582709730379821,
-0.857142857142857,  -0.857142857142857,  0.571428571428571,  1.815269009670992,
-0.857142857142857,  -0.571428571428571,  0.285714285714286,  1.815269009670992,
-0.857142857142857,  -0.285714285714286,  0.000000000000000,  1.815269009670992,
-0.857142857142857,  0.000000000000000,  -0.285714285714286,  1.815269009670992,
-0.857142857142857,  0.285714285714286,  -0.571428571428571,  1.815269009670992,
-0.857142857142857,  0.571428571428571,  -0.857142857142857,  1.815269009670992,
-0.571428571428571,  -0.857142857142857,  0.285714285714286,  1.815269009670992,
-0.571428571428571,  -0.571428571428571,  0.000000000000000,  1.815269009670992,
-0.571428571428571,  -0.285714285714286,  -0.285714285714286,  1.815269009670992,
-0.571428571428571,  0.000000000000000,  -0.571428571428571,  1.815269009670992,
-0.571428571428571,  0.285714285714286,  -0.857142857142857,  1.815269009670992,
-0.285714285714286,  -0.857142857142857,  0.000000000000000,  1.815269009670992,
-0.285714285714286,  -0.571428571428571,  -0.285714285714286,  1.815269009670992,
-0.285714285714286,  -0.285714285714286,  -0.571428571428571,  1.815269009670992,
-0.285714285714286,  0.000000000000000,  -0.857142857142857,  1.815269009670992,
0.000000000000000,  -0.857142857142857,  -0.285714285714286,  1.815269009670992,
0.000000000000000,  -0.571428571428571,  -0.571428571428571,  1.815269009670992,
0.000000000000000,  -0.285714285714286,  -0.857142857142857,  1.815269009670992,
0.285714285714286,  -0.857142857142857,  -0.571428571428571,  1.815269009670992,
0.285714285714286,  -0.571428571428571,  -0.857142857142857,  1.815269009670992,
0.571428571428571,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.857142857142857,  -0.857142857142857,  0.285714285714286,  1.815269009670992,
-0.857142857142857,  -0.571428571428571,  0.000000000000000,  1.815269009670992,
-0.857142857142857,  -0.285714285714286,  -0.285714285714286,  1.815269009670992,
-0.857142857142857,  0.000000000000000,  -0.571428571428571,  1.815269009670992,
-0.857142857142857,  0.285714285714286,  -0.857142857142857,  1.815269009670992,
-0.571428571428571,  -0.857142857142857,  0.000000000000000,  1.815269009670992,
-0.571428571428571,  -0.571428571428571,  -0.285714285714286,  1.815269009670992,
-0.571428571428571,  -0.285714285714286,  -0.571428571428571,  1.815269009670992,
-0.571428571428571,  0.000000000000000,  -0.857142857142857,  1.815269009670992,
-0.285714285714286,  -0.857142857142857,  -0.285714285714286,  1.815269009670992,
-0.285714285714286,  -0.571428571428571,  -0.571428571428571,  1.815269009670992,
-0.285714285714286,  -0.285714285714286,  -0.857142857142857,  1.815269009670992,
0.000000000000000,  -0.857142857142857,  -0.571428571428571,  1.815269009670992,
0.000000000000000,  -0.571428571428571,  -0.857142857142857,  1.815269009670992,
0.285714285714286,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.857142857142857,  -0.857142857142857,  0.000000000000000,  1.815269009670992,
-0.857142857142857,  -0.571428571428571,  -0.285714285714286,  1.815269009670992,
-0.857142857142857,  -0.285714285714286,  -0.571428571428571,  1.815269009670992,
-0.857142857142857,  0.000000000000000,  -0.857142857142857,  1.815269009670992,
-0.571428571428571,  -0.857142857142857,  -0.285714285714286,  1.815269009670992,
-0.571428571428571,  -0.571428571428571,  -0.571428571428571,  1.815269009670992,
-0.571428571428571,  -0.285714285714286,  -0.857142857142857,  1.815269009670992,
-0.285714285714286,  -0.857142857142857,  -0.571428571428571,  1.815269009670992,
-0.285714285714286,  -0.571428571428571,  -0.857142857142857,  1.815269009670992,
0.000000000000000,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.857142857142857,  -0.857142857142857,  -0.285714285714286,  1.815269009670992,
-0.857142857142857,  -0.571428571428571,  -0.571428571428571,  1.815269009670992,
-0.857142857142857,  -0.285714285714286,  -0.857142857142857,  1.815269009670992,
-0.571428571428571,  -0.857142857142857,  -0.571428571428571,  1.815269009670992,
-0.571428571428571,  -0.571428571428571,  -0.857142857142857,  1.815269009670992,
-0.285714285714286,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.857142857142857,  -0.857142857142857,  -0.571428571428571,  1.815269009670992,
-0.857142857142857,  -0.571428571428571,  -0.857142857142857,  1.815269009670992,
-0.571428571428571,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.857142857142857,  -0.857142857142857,  -0.857142857142857,  1.815269009670992,
-0.833333333333333,  -0.833333333333333,  0.500000000000000,  -0.958821749678893,
-0.833333333333333,  -0.500000000000000,  0.166666666666667,  -0.958821749678893,
-0.833333333333333,  -0.166666666666667,  -0.166666666666667,  -0.958821749678893,
-0.833333333333333,  0.166666666666667,  -0.500000000000000,  -0.958821749678893,
-0.833333333333333,  0.500000000000000,  -0.833333333333333,  -0.958821749678893,
-0.500000000000000,  -0.833333333333333,  0.166666666666667,  -0.958821749678893,
-0.500000000000000,  -0.500000000000000,  -0.166666666666667,  -0.958821749678893,
-0.500000000000000,  -0.166666666666667,  -0.500000000000000,  -0.958821749678893,
-0.500000000000000,  0.166666666666667,  -0.833333333333333,  -0.958821749678893,
-0.166666666666667,  -0.833333333333333,  -0.166666666666667,  -0.958821749678893,
-0.166666666666667,  -0.500000000000000,  -0.500000000000000,  -0.958821749678893,
-0.166666666666667,  -0.166666666666667,  -0.833333333333333,  -0.958821749678893,
0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.958821749678893,
0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.958821749678893,
0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.958821749678893,
-0.833333333333333,  -0.833333333333333,  0.166666666666667,  -0.958821749678893,
-0.833333333333333,  -0.500000000000000,  -0.166666666666667,  -0.958821749678893,
-0.833333333333333,  -0.166666666666667,  -0.500000000000000,  -0.958821749678893,
-0.833333333333333,  0.166666666666667,  -0.833333333333333,  -0.958821749678893,
-0.500000000000000,  -0.833333333333333,  -0.166666666666667,  -0.958821749678893,
-0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.958821749678893,
-0.500000000000000,  -0.166666666666667,  -0.833333333333333,  -0.958821749678893,
-0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.958821749678893,
-0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.958821749678893,
0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.958821749678893,
-0.833333333333333,  -0.833333333333333,  -0.166666666666667,  -0.958821749678893,
-0.833333333333333,  -0.500000000000000,  -0.500000000000000,  -0.958821749678893,
-0.833333333333333,  -0.166666666666667,  -0.833333333333333,  -0.958821749678893,
-0.500000000000000,  -0.833333333333333,  -0.500000000000000,  -0.958821749678893,
-0.500000000000000,  -0.500000000000000,  -0.833333333333333,  -0.958821749678893,
-0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.958821749678893,
-0.833333333333333,  -0.833333333333333,  -0.500000000000000,  -0.958821749678893,
-0.833333333333333,  -0.500000000000000,  -0.833333333333333,  -0.958821749678893,
-0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.958821749678893,
-0.833333333333333,  -0.833333333333333,  -0.833333333333333,  -0.958821749678893,
-0.800000000000000,  -0.800000000000000,  0.400000000000000,  0.233372916620478,
-0.800000000000000,  -0.400000000000000,  0.000000000000000,  0.233372916620478,
-0.800000000000000,  0.000000000000000,  -0.400000000000000,  0.233372916620478,
-0.800000000000000,  0.400000000000000,  -0.800000000000000,  0.233372916620478,
-0.400000000000000,  -0.800000000000000,  0.000000000000000,  0.233372916620478,
-0.400000000000000,  -0.400000000000000,  -0.400000000000000,  0.233372916620478,
-0.400000000000000,  0.000000000000000,  -0.800000000000000,  0.233372916620478,
0.000000000000000,  -0.800000000000000,  -0.400000000000000,  0.233372916620478,
0.000000000000000,  -0.400000000000000,  -0.800000000000000,  0.233372916620478,
0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.233372916620478,
-0.800000000000000,  -0.800000000000000,  0.000000000000000,  0.233372916620478,
-0.800000000000000,  -0.400000000000000,  -0.400000000000000,  0.233372916620478,
-0.800000000000000,  0.000000000000000,  -0.800000000000000,  0.233372916620478,
-0.400000000000000,  -0.800000000000000,  -0.400000000000000,  0.233372916620478,
-0.400000000000000,  -0.400000000000000,  -0.800000000000000,  0.233372916620478,
0.000000000000000,  -0.800000000000000,  -0.800000000000000,  0.233372916620478,
-0.800000000000000,  -0.800000000000000,  -0.400000000000000,  0.233372916620478,
-0.800000000000000,  -0.400000000000000,  -0.800000000000000,  0.233372916620478,
-0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.233372916620478,
-0.800000000000000,  -0.800000000000000,  -0.800000000000000,  0.233372916620478,
-0.750000000000000,  -0.750000000000000,  0.250000000000000,  -0.022991022694726,
-0.750000000000000,  -0.250000000000000,  -0.250000000000000,  -0.022991022694726,
-0.750000000000000,  0.250000000000000,  -0.750000000000000,  -0.022991022694726,
-0.250000000000000,  -0.750000000000000,  -0.250000000000000,  -0.022991022694726,
-0.250000000000000,  -0.250000000000000,  -0.750000000000000,  -0.022991022694726,
0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.022991022694726,
-0.750000000000000,  -0.750000000000000,  -0.250000000000000,  -0.022991022694726,
-0.750000000000000,  -0.250000000000000,  -0.750000000000000,  -0.022991022694726,
-0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.022991022694726,
-0.750000000000000,  -0.750000000000000,  -0.750000000000000,  -0.022991022694726,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  0.000665685876623,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  0.000665685876623,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  0.000665685876623,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  0.000665685876623,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.000002606055516;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<14,T>: public IMTetrahedra<15,T> {};
/*
495
-0.900000000000000  -0.900000000000000  0.700000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  0.500000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  0.300000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  0.100000000000000  0.657650819729946
-0.900000000000000  -0.100000000000000  -0.100000000000000  0.657650819729946
-0.900000000000000  0.100000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  0.300000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  0.500000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  0.700000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  0.500000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  0.300000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  0.100000000000000  0.657650819729946
-0.700000000000000  -0.300000000000000  -0.100000000000000  0.657650819729946
-0.700000000000000  -0.100000000000000  -0.300000000000000  0.657650819729946
-0.700000000000000  0.100000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  0.300000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  0.500000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  0.300000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  0.100000000000000  0.657650819729946
-0.500000000000000  -0.500000000000000  -0.100000000000000  0.657650819729946
-0.500000000000000  -0.300000000000000  -0.300000000000000  0.657650819729946
-0.500000000000000  -0.100000000000000  -0.500000000000000  0.657650819729946
-0.500000000000000  0.100000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  0.300000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  0.100000000000000  0.657650819729946
-0.300000000000000  -0.700000000000000  -0.100000000000000  0.657650819729946
-0.300000000000000  -0.500000000000000  -0.300000000000000  0.657650819729946
-0.300000000000000  -0.300000000000000  -0.500000000000000  0.657650819729946
-0.300000000000000  -0.100000000000000  -0.700000000000000  0.657650819729946
-0.300000000000000  0.100000000000000  -0.900000000000000  0.657650819729946
-0.100000000000000  -0.900000000000000  -0.100000000000000  0.657650819729946
-0.100000000000000  -0.700000000000000  -0.300000000000000  0.657650819729946
-0.100000000000000  -0.500000000000000  -0.500000000000000  0.657650819729946
-0.100000000000000  -0.300000000000000  -0.700000000000000  0.657650819729946
-0.100000000000000  -0.100000000000000  -0.900000000000000  0.657650819729946
0.100000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
0.100000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
0.100000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
0.100000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
0.300000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
0.300000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
0.300000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
0.500000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
0.500000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
0.700000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  0.500000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  0.300000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  0.100000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  -0.100000000000000  0.657650819729946
-0.900000000000000  -0.100000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  0.100000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  0.300000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  0.500000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  0.300000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  0.100000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  -0.100000000000000  0.657650819729946
-0.700000000000000  -0.300000000000000  -0.300000000000000  0.657650819729946
-0.700000000000000  -0.100000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  0.100000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  0.300000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  0.100000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  -0.100000000000000  0.657650819729946
-0.500000000000000  -0.500000000000000  -0.300000000000000  0.657650819729946
-0.500000000000000  -0.300000000000000  -0.500000000000000  0.657650819729946
-0.500000000000000  -0.100000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  0.100000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  -0.100000000000000  0.657650819729946
-0.300000000000000  -0.700000000000000  -0.300000000000000  0.657650819729946
-0.300000000000000  -0.500000000000000  -0.500000000000000  0.657650819729946
-0.300000000000000  -0.300000000000000  -0.700000000000000  0.657650819729946
-0.300000000000000  -0.100000000000000  -0.900000000000000  0.657650819729946
-0.100000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
-0.100000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
-0.100000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
-0.100000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
0.100000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
0.100000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
0.100000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
0.300000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
0.300000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
0.500000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  0.300000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  0.100000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  -0.100000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  -0.100000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  0.100000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  0.300000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  0.100000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  -0.100000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  -0.300000000000000  0.657650819729946
-0.700000000000000  -0.300000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  -0.100000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  0.100000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  -0.100000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  -0.300000000000000  0.657650819729946
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.657650819729946
-0.500000000000000  -0.300000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  -0.100000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
-0.300000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
-0.300000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
-0.300000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
-0.100000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
-0.100000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
-0.100000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
0.100000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
0.100000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
0.300000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  0.100000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  -0.100000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  -0.100000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  0.100000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  -0.100000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  -0.300000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  -0.300000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  -0.100000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
-0.500000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
-0.300000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
-0.300000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
-0.100000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
-0.100000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
0.100000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  -0.100000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  -0.100000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
-0.300000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
-0.100000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  -0.300000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  -0.300000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
-0.500000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
-0.300000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  -0.500000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  -0.500000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
-0.700000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
-0.500000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  -0.700000000000000  0.657650819729946
-0.900000000000000  -0.700000000000000  -0.900000000000000  0.657650819729946
-0.700000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.900000000000000  -0.900000000000000  -0.900000000000000  0.657650819729946
-0.888888888888889  -0.888888888888889  0.666666666666667  -2.193552443114196
-0.888888888888889  -0.666666666666667  0.444444444444444  -2.193552443114196
-0.888888888888889  -0.444444444444444  0.222222222222222  -2.193552443114196
-0.888888888888889  -0.222222222222222  0.000000000000000  -2.193552443114196
-0.888888888888889  0.000000000000000  -0.222222222222222  -2.193552443114196
-0.888888888888889  0.222222222222222  -0.444444444444444  -2.193552443114196
-0.888888888888889  0.444444444444444  -0.666666666666667  -2.193552443114196
-0.888888888888889  0.666666666666667  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  0.444444444444444  -2.193552443114196
-0.666666666666667  -0.666666666666667  0.222222222222222  -2.193552443114196
-0.666666666666667  -0.444444444444444  0.000000000000000  -2.193552443114196
-0.666666666666667  -0.222222222222222  -0.222222222222222  -2.193552443114196
-0.666666666666667  0.000000000000000  -0.444444444444444  -2.193552443114196
-0.666666666666667  0.222222222222222  -0.666666666666667  -2.193552443114196
-0.666666666666667  0.444444444444444  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  0.222222222222222  -2.193552443114196
-0.444444444444444  -0.666666666666667  0.000000000000000  -2.193552443114196
-0.444444444444444  -0.444444444444444  -0.222222222222222  -2.193552443114196
-0.444444444444444  -0.222222222222222  -0.444444444444444  -2.193552443114196
-0.444444444444444  0.000000000000000  -0.666666666666667  -2.193552443114196
-0.444444444444444  0.222222222222222  -0.888888888888889  -2.193552443114196
-0.222222222222222  -0.888888888888889  0.000000000000000  -2.193552443114196
-0.222222222222222  -0.666666666666667  -0.222222222222222  -2.193552443114196
-0.222222222222222  -0.444444444444444  -0.444444444444444  -2.193552443114196
-0.222222222222222  -0.222222222222222  -0.666666666666667  -2.193552443114196
-0.222222222222222  0.000000000000000  -0.888888888888889  -2.193552443114196
0.000000000000000  -0.888888888888889  -0.222222222222222  -2.193552443114196
0.000000000000000  -0.666666666666667  -0.444444444444444  -2.193552443114196
0.000000000000000  -0.444444444444444  -0.666666666666667  -2.193552443114196
0.000000000000000  -0.222222222222222  -0.888888888888889  -2.193552443114196
0.222222222222222  -0.888888888888889  -0.444444444444444  -2.193552443114196
0.222222222222222  -0.666666666666667  -0.666666666666667  -2.193552443114196
0.222222222222222  -0.444444444444444  -0.888888888888889  -2.193552443114196
0.444444444444444  -0.888888888888889  -0.666666666666667  -2.193552443114196
0.444444444444444  -0.666666666666667  -0.888888888888889  -2.193552443114196
0.666666666666667  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  0.444444444444444  -2.193552443114196
-0.888888888888889  -0.666666666666667  0.222222222222222  -2.193552443114196
-0.888888888888889  -0.444444444444444  0.000000000000000  -2.193552443114196
-0.888888888888889  -0.222222222222222  -0.222222222222222  -2.193552443114196
-0.888888888888889  0.000000000000000  -0.444444444444444  -2.193552443114196
-0.888888888888889  0.222222222222222  -0.666666666666667  -2.193552443114196
-0.888888888888889  0.444444444444444  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  0.222222222222222  -2.193552443114196
-0.666666666666667  -0.666666666666667  0.000000000000000  -2.193552443114196
-0.666666666666667  -0.444444444444444  -0.222222222222222  -2.193552443114196
-0.666666666666667  -0.222222222222222  -0.444444444444444  -2.193552443114196
-0.666666666666667  0.000000000000000  -0.666666666666667  -2.193552443114196
-0.666666666666667  0.222222222222222  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  0.000000000000000  -2.193552443114196
-0.444444444444444  -0.666666666666667  -0.222222222222222  -2.193552443114196
-0.444444444444444  -0.444444444444444  -0.444444444444444  -2.193552443114196
-0.444444444444444  -0.222222222222222  -0.666666666666667  -2.193552443114196
-0.444444444444444  0.000000000000000  -0.888888888888889  -2.193552443114196
-0.222222222222222  -0.888888888888889  -0.222222222222222  -2.193552443114196
-0.222222222222222  -0.666666666666667  -0.444444444444444  -2.193552443114196
-0.222222222222222  -0.444444444444444  -0.666666666666667  -2.193552443114196
-0.222222222222222  -0.222222222222222  -0.888888888888889  -2.193552443114196
0.000000000000000  -0.888888888888889  -0.444444444444444  -2.193552443114196
0.000000000000000  -0.666666666666667  -0.666666666666667  -2.193552443114196
0.000000000000000  -0.444444444444444  -0.888888888888889  -2.193552443114196
0.222222222222222  -0.888888888888889  -0.666666666666667  -2.193552443114196
0.222222222222222  -0.666666666666667  -0.888888888888889  -2.193552443114196
0.444444444444444  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  0.222222222222222  -2.193552443114196
-0.888888888888889  -0.666666666666667  0.000000000000000  -2.193552443114196
-0.888888888888889  -0.444444444444444  -0.222222222222222  -2.193552443114196
-0.888888888888889  -0.222222222222222  -0.444444444444444  -2.193552443114196
-0.888888888888889  0.000000000000000  -0.666666666666667  -2.193552443114196
-0.888888888888889  0.222222222222222  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  0.000000000000000  -2.193552443114196
-0.666666666666667  -0.666666666666667  -0.222222222222222  -2.193552443114196
-0.666666666666667  -0.444444444444444  -0.444444444444444  -2.193552443114196
-0.666666666666667  -0.222222222222222  -0.666666666666667  -2.193552443114196
-0.666666666666667  0.000000000000000  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  -0.222222222222222  -2.193552443114196
-0.444444444444444  -0.666666666666667  -0.444444444444444  -2.193552443114196
-0.444444444444444  -0.444444444444444  -0.666666666666667  -2.193552443114196
-0.444444444444444  -0.222222222222222  -0.888888888888889  -2.193552443114196
-0.222222222222222  -0.888888888888889  -0.444444444444444  -2.193552443114196
-0.222222222222222  -0.666666666666667  -0.666666666666667  -2.193552443114196
-0.222222222222222  -0.444444444444444  -0.888888888888889  -2.193552443114196
0.000000000000000  -0.888888888888889  -0.666666666666667  -2.193552443114196
0.000000000000000  -0.666666666666667  -0.888888888888889  -2.193552443114196
0.222222222222222  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  0.000000000000000  -2.193552443114196
-0.888888888888889  -0.666666666666667  -0.222222222222222  -2.193552443114196
-0.888888888888889  -0.444444444444444  -0.444444444444444  -2.193552443114196
-0.888888888888889  -0.222222222222222  -0.666666666666667  -2.193552443114196
-0.888888888888889  0.000000000000000  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  -0.222222222222222  -2.193552443114196
-0.666666666666667  -0.666666666666667  -0.444444444444444  -2.193552443114196
-0.666666666666667  -0.444444444444444  -0.666666666666667  -2.193552443114196
-0.666666666666667  -0.222222222222222  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  -0.444444444444444  -2.193552443114196
-0.444444444444444  -0.666666666666667  -0.666666666666667  -2.193552443114196
-0.444444444444444  -0.444444444444444  -0.888888888888889  -2.193552443114196
-0.222222222222222  -0.888888888888889  -0.666666666666667  -2.193552443114196
-0.222222222222222  -0.666666666666667  -0.888888888888889  -2.193552443114196
0.000000000000000  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  -0.222222222222222  -2.193552443114196
-0.888888888888889  -0.666666666666667  -0.444444444444444  -2.193552443114196
-0.888888888888889  -0.444444444444444  -0.666666666666667  -2.193552443114196
-0.888888888888889  -0.222222222222222  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  -0.444444444444444  -2.193552443114196
-0.666666666666667  -0.666666666666667  -0.666666666666667  -2.193552443114196
-0.666666666666667  -0.444444444444444  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  -0.666666666666667  -2.193552443114196
-0.444444444444444  -0.666666666666667  -0.888888888888889  -2.193552443114196
-0.222222222222222  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  -0.444444444444444  -2.193552443114196
-0.888888888888889  -0.666666666666667  -0.666666666666667  -2.193552443114196
-0.888888888888889  -0.444444444444444  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  -0.666666666666667  -2.193552443114196
-0.666666666666667  -0.666666666666667  -0.888888888888889  -2.193552443114196
-0.444444444444444  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  -0.666666666666667  -2.193552443114196
-0.888888888888889  -0.666666666666667  -0.888888888888889  -2.193552443114196
-0.666666666666667  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.888888888888889  -0.888888888888889  -0.888888888888889  -2.193552443114196
-0.875000000000000  -0.875000000000000  0.625000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  0.375000000000000  2.813706187341903
-0.875000000000000  -0.375000000000000  0.125000000000000  2.813706187341903
-0.875000000000000  -0.125000000000000  -0.125000000000000  2.813706187341903
-0.875000000000000  0.125000000000000  -0.375000000000000  2.813706187341903
-0.875000000000000  0.375000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  0.625000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  0.375000000000000  2.813706187341903
-0.625000000000000  -0.625000000000000  0.125000000000000  2.813706187341903
-0.625000000000000  -0.375000000000000  -0.125000000000000  2.813706187341903
-0.625000000000000  -0.125000000000000  -0.375000000000000  2.813706187341903
-0.625000000000000  0.125000000000000  -0.625000000000000  2.813706187341903
-0.625000000000000  0.375000000000000  -0.875000000000000  2.813706187341903
-0.375000000000000  -0.875000000000000  0.125000000000000  2.813706187341903
-0.375000000000000  -0.625000000000000  -0.125000000000000  2.813706187341903
-0.375000000000000  -0.375000000000000  -0.375000000000000  2.813706187341903
-0.375000000000000  -0.125000000000000  -0.625000000000000  2.813706187341903
-0.375000000000000  0.125000000000000  -0.875000000000000  2.813706187341903
-0.125000000000000  -0.875000000000000  -0.125000000000000  2.813706187341903
-0.125000000000000  -0.625000000000000  -0.375000000000000  2.813706187341903
-0.125000000000000  -0.375000000000000  -0.625000000000000  2.813706187341903
-0.125000000000000  -0.125000000000000  -0.875000000000000  2.813706187341903
0.125000000000000  -0.875000000000000  -0.375000000000000  2.813706187341903
0.125000000000000  -0.625000000000000  -0.625000000000000  2.813706187341903
0.125000000000000  -0.375000000000000  -0.875000000000000  2.813706187341903
0.375000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
0.375000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
0.625000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  0.375000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  0.125000000000000  2.813706187341903
-0.875000000000000  -0.375000000000000  -0.125000000000000  2.813706187341903
-0.875000000000000  -0.125000000000000  -0.375000000000000  2.813706187341903
-0.875000000000000  0.125000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  0.375000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  0.125000000000000  2.813706187341903
-0.625000000000000  -0.625000000000000  -0.125000000000000  2.813706187341903
-0.625000000000000  -0.375000000000000  -0.375000000000000  2.813706187341903
-0.625000000000000  -0.125000000000000  -0.625000000000000  2.813706187341903
-0.625000000000000  0.125000000000000  -0.875000000000000  2.813706187341903
-0.375000000000000  -0.875000000000000  -0.125000000000000  2.813706187341903
-0.375000000000000  -0.625000000000000  -0.375000000000000  2.813706187341903
-0.375000000000000  -0.375000000000000  -0.625000000000000  2.813706187341903
-0.375000000000000  -0.125000000000000  -0.875000000000000  2.813706187341903
-0.125000000000000  -0.875000000000000  -0.375000000000000  2.813706187341903
-0.125000000000000  -0.625000000000000  -0.625000000000000  2.813706187341903
-0.125000000000000  -0.375000000000000  -0.875000000000000  2.813706187341903
0.125000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
0.125000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
0.375000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  0.125000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  -0.125000000000000  2.813706187341903
-0.875000000000000  -0.375000000000000  -0.375000000000000  2.813706187341903
-0.875000000000000  -0.125000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  0.125000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  -0.125000000000000  2.813706187341903
-0.625000000000000  -0.625000000000000  -0.375000000000000  2.813706187341903
-0.625000000000000  -0.375000000000000  -0.625000000000000  2.813706187341903
-0.625000000000000  -0.125000000000000  -0.875000000000000  2.813706187341903
-0.375000000000000  -0.875000000000000  -0.375000000000000  2.813706187341903
-0.375000000000000  -0.625000000000000  -0.625000000000000  2.813706187341903
-0.375000000000000  -0.375000000000000  -0.875000000000000  2.813706187341903
-0.125000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
-0.125000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
0.125000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  -0.125000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  -0.375000000000000  2.813706187341903
-0.875000000000000  -0.375000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  -0.125000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  -0.375000000000000  2.813706187341903
-0.625000000000000  -0.625000000000000  -0.625000000000000  2.813706187341903
-0.625000000000000  -0.375000000000000  -0.875000000000000  2.813706187341903
-0.375000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
-0.375000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
-0.125000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  -0.375000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  -0.375000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
-0.625000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
-0.375000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  -0.625000000000000  2.813706187341903
-0.875000000000000  -0.625000000000000  -0.875000000000000  2.813706187341903
-0.625000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.875000000000000  -0.875000000000000  -0.875000000000000  2.813706187341903
-0.857142857142857  -0.857142857142857  0.571428571428571  -1.744081989683894
-0.857142857142857  -0.571428571428571  0.285714285714286  -1.744081989683894
-0.857142857142857  -0.285714285714286  0.000000000000000  -1.744081989683894
-0.857142857142857  0.000000000000000  -0.285714285714286  -1.744081989683894
-0.857142857142857  0.285714285714286  -0.571428571428571  -1.744081989683894
-0.857142857142857  0.571428571428571  -0.857142857142857  -1.744081989683894
-0.571428571428571  -0.857142857142857  0.285714285714286  -1.744081989683894
-0.571428571428571  -0.571428571428571  0.000000000000000  -1.744081989683894
-0.571428571428571  -0.285714285714286  -0.285714285714286  -1.744081989683894
-0.571428571428571  0.000000000000000  -0.571428571428571  -1.744081989683894
-0.571428571428571  0.285714285714286  -0.857142857142857  -1.744081989683894
-0.285714285714286  -0.857142857142857  0.000000000000000  -1.744081989683894
-0.285714285714286  -0.571428571428571  -0.285714285714286  -1.744081989683894
-0.285714285714286  -0.285714285714286  -0.571428571428571  -1.744081989683894
-0.285714285714286  0.000000000000000  -0.857142857142857  -1.744081989683894
0.000000000000000  -0.857142857142857  -0.285714285714286  -1.744081989683894
0.000000000000000  -0.571428571428571  -0.571428571428571  -1.744081989683894
0.000000000000000  -0.285714285714286  -0.857142857142857  -1.744081989683894
0.285714285714286  -0.857142857142857  -0.571428571428571  -1.744081989683894
0.285714285714286  -0.571428571428571  -0.857142857142857  -1.744081989683894
0.571428571428571  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.857142857142857  -0.857142857142857  0.285714285714286  -1.744081989683894
-0.857142857142857  -0.571428571428571  0.000000000000000  -1.744081989683894
-0.857142857142857  -0.285714285714286  -0.285714285714286  -1.744081989683894
-0.857142857142857  0.000000000000000  -0.571428571428571  -1.744081989683894
-0.857142857142857  0.285714285714286  -0.857142857142857  -1.744081989683894
-0.571428571428571  -0.857142857142857  0.000000000000000  -1.744081989683894
-0.571428571428571  -0.571428571428571  -0.285714285714286  -1.744081989683894
-0.571428571428571  -0.285714285714286  -0.571428571428571  -1.744081989683894
-0.571428571428571  0.000000000000000  -0.857142857142857  -1.744081989683894
-0.285714285714286  -0.857142857142857  -0.285714285714286  -1.744081989683894
-0.285714285714286  -0.571428571428571  -0.571428571428571  -1.744081989683894
-0.285714285714286  -0.285714285714286  -0.857142857142857  -1.744081989683894
0.000000000000000  -0.857142857142857  -0.571428571428571  -1.744081989683894
0.000000000000000  -0.571428571428571  -0.857142857142857  -1.744081989683894
0.285714285714286  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.857142857142857  -0.857142857142857  0.000000000000000  -1.744081989683894
-0.857142857142857  -0.571428571428571  -0.285714285714286  -1.744081989683894
-0.857142857142857  -0.285714285714286  -0.571428571428571  -1.744081989683894
-0.857142857142857  0.000000000000000  -0.857142857142857  -1.744081989683894
-0.571428571428571  -0.857142857142857  -0.285714285714286  -1.744081989683894
-0.571428571428571  -0.571428571428571  -0.571428571428571  -1.744081989683894
-0.571428571428571  -0.285714285714286  -0.857142857142857  -1.744081989683894
-0.285714285714286  -0.857142857142857  -0.571428571428571  -1.744081989683894
-0.285714285714286  -0.571428571428571  -0.857142857142857  -1.744081989683894
0.000000000000000  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.857142857142857  -0.857142857142857  -0.285714285714286  -1.744081989683894
-0.857142857142857  -0.571428571428571  -0.571428571428571  -1.744081989683894
-0.857142857142857  -0.285714285714286  -0.857142857142857  -1.744081989683894
-0.571428571428571  -0.857142857142857  -0.571428571428571  -1.744081989683894
-0.571428571428571  -0.571428571428571  -0.857142857142857  -1.744081989683894
-0.285714285714286  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.857142857142857  -0.857142857142857  -0.571428571428571  -1.744081989683894
-0.857142857142857  -0.571428571428571  -0.857142857142857  -1.744081989683894
-0.571428571428571  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.857142857142857  -0.857142857142857  -0.857142857142857  -1.744081989683894
-0.833333333333333  -0.833333333333333  0.500000000000000  0.539337234194377
-0.833333333333333  -0.500000000000000  0.166666666666667  0.539337234194377
-0.833333333333333  -0.166666666666667  -0.166666666666667  0.539337234194377
-0.833333333333333  0.166666666666667  -0.500000000000000  0.539337234194377
-0.833333333333333  0.500000000000000  -0.833333333333333  0.539337234194377
-0.500000000000000  -0.833333333333333  0.166666666666667  0.539337234194377
-0.500000000000000  -0.500000000000000  -0.166666666666667  0.539337234194377
-0.500000000000000  -0.166666666666667  -0.500000000000000  0.539337234194377
-0.500000000000000  0.166666666666667  -0.833333333333333  0.539337234194377
-0.166666666666667  -0.833333333333333  -0.166666666666667  0.539337234194377
-0.166666666666667  -0.500000000000000  -0.500000000000000  0.539337234194377
-0.166666666666667  -0.166666666666667  -0.833333333333333  0.539337234194377
0.166666666666667  -0.833333333333333  -0.500000000000000  0.539337234194377
0.166666666666667  -0.500000000000000  -0.833333333333333  0.539337234194377
0.500000000000000  -0.833333333333333  -0.833333333333333  0.539337234194377
-0.833333333333333  -0.833333333333333  0.166666666666667  0.539337234194377
-0.833333333333333  -0.500000000000000  -0.166666666666667  0.539337234194377
-0.833333333333333  -0.166666666666667  -0.500000000000000  0.539337234194377
-0.833333333333333  0.166666666666667  -0.833333333333333  0.539337234194377
-0.500000000000000  -0.833333333333333  -0.166666666666667  0.539337234194377
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.539337234194377
-0.500000000000000  -0.166666666666667  -0.833333333333333  0.539337234194377
-0.166666666666667  -0.833333333333333  -0.500000000000000  0.539337234194377
-0.166666666666667  -0.500000000000000  -0.833333333333333  0.539337234194377
0.166666666666667  -0.833333333333333  -0.833333333333333  0.539337234194377
-0.833333333333333  -0.833333333333333  -0.166666666666667  0.539337234194377
-0.833333333333333  -0.500000000000000  -0.500000000000000  0.539337234194377
-0.833333333333333  -0.166666666666667  -0.833333333333333  0.539337234194377
-0.500000000000000  -0.833333333333333  -0.500000000000000  0.539337234194377
-0.500000000000000  -0.500000000000000  -0.833333333333333  0.539337234194377
-0.166666666666667  -0.833333333333333  -0.833333333333333  0.539337234194377
-0.833333333333333  -0.833333333333333  -0.500000000000000  0.539337234194377
-0.833333333333333  -0.500000000000000  -0.833333333333333  0.539337234194377
-0.500000000000000  -0.833333333333333  -0.833333333333333  0.539337234194377
-0.833333333333333  -0.833333333333333  -0.833333333333333  0.539337234194377
-0.800000000000000  -0.800000000000000  0.400000000000000  -0.077790972206826
-0.800000000000000  -0.400000000000000  0.000000000000000  -0.077790972206826
-0.800000000000000  0.000000000000000  -0.400000000000000  -0.077790972206826
-0.800000000000000  0.400000000000000  -0.800000000000000  -0.077790972206826
-0.400000000000000  -0.800000000000000  0.000000000000000  -0.077790972206826
-0.400000000000000  -0.400000000000000  -0.400000000000000  -0.077790972206826
-0.400000000000000  0.000000000000000  -0.800000000000000  -0.077790972206826
0.000000000000000  -0.800000000000000  -0.400000000000000  -0.077790972206826
0.000000000000000  -0.400000000000000  -0.800000000000000  -0.077790972206826
0.400000000000000  -0.800000000000000  -0.800000000000000  -0.077790972206826
-0.800000000000000  -0.800000000000000  0.000000000000000  -0.077790972206826
-0.800000000000000  -0.400000000000000  -0.400000000000000  -0.077790972206826
-0.800000000000000  0.000000000000000  -0.800000000000000  -0.077790972206826
-0.400000000000000  -0.800000000000000  -0.400000000000000  -0.077790972206826
-0.400000000000000  -0.400000000000000  -0.800000000000000  -0.077790972206826
0.000000000000000  -0.800000000000000  -0.800000000000000  -0.077790972206826
-0.800000000000000  -0.800000000000000  -0.400000000000000  -0.077790972206826
-0.800000000000000  -0.400000000000000  -0.800000000000000  -0.077790972206826
-0.400000000000000  -0.800000000000000  -0.800000000000000  -0.077790972206826
-0.800000000000000  -0.800000000000000  -0.800000000000000  -0.077790972206826
-0.750000000000000  -0.750000000000000  0.250000000000000  0.004379242418043
-0.750000000000000  -0.250000000000000  -0.250000000000000  0.004379242418043
-0.750000000000000  0.250000000000000  -0.750000000000000  0.004379242418043
-0.250000000000000  -0.750000000000000  -0.250000000000000  0.004379242418043
-0.250000000000000  -0.250000000000000  -0.750000000000000  0.004379242418043
0.250000000000000  -0.750000000000000  -0.750000000000000  0.004379242418043
-0.750000000000000  -0.750000000000000  -0.250000000000000  0.004379242418043
-0.750000000000000  -0.250000000000000  -0.750000000000000  0.004379242418043
-0.250000000000000  -0.750000000000000  -0.750000000000000  0.004379242418043
-0.750000000000000  -0.750000000000000  -0.750000000000000  0.004379242418043
-0.666666666666667  -0.666666666666667  0.000000000000000  -0.000065837064721
-0.666666666666667  0.000000000000000  -0.666666666666667  -0.000065837064721
0.000000000000000  -0.666666666666667  -0.666666666666667  -0.000065837064721
-0.666666666666667  -0.666666666666667  -0.666666666666667  -0.000065837064721
-0.500000000000000  -0.500000000000000  -0.500000000000000   0.000000108585647
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=17
*/
template<typename T>
struct IMTetrahedra<17,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 17;
    static const uint16_type nPoints = 495;
    IMTetrahedra()
        :
        q()
    {
        q+=
-0.900000000000000,  -0.900000000000000,  0.700000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.100000000000000,  -0.100000000000000,  0.657650819729946,
-0.900000000000000,  0.100000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  0.300000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  0.700000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  0.500000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.300000000000000,  -0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.100000000000000,  -0.300000000000000,  0.657650819729946,
-0.700000000000000,  0.100000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  0.300000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  0.100000000000000,  0.657650819729946,
-0.500000000000000,  -0.500000000000000,  -0.100000000000000,  0.657650819729946,
-0.500000000000000,  -0.300000000000000,  -0.300000000000000,  0.657650819729946,
-0.500000000000000,  -0.100000000000000,  -0.500000000000000,  0.657650819729946,
-0.500000000000000,  0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  0.100000000000000,  0.657650819729946,
-0.300000000000000,  -0.700000000000000,  -0.100000000000000,  0.657650819729946,
-0.300000000000000,  -0.500000000000000,  -0.300000000000000,  0.657650819729946,
-0.300000000000000,  -0.300000000000000,  -0.500000000000000,  0.657650819729946,
-0.300000000000000,  -0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.300000000000000,  0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.100000000000000,  -0.900000000000000,  -0.100000000000000,  0.657650819729946,
-0.100000000000000,  -0.700000000000000,  -0.300000000000000,  0.657650819729946,
-0.100000000000000,  -0.500000000000000,  -0.500000000000000,  0.657650819729946,
-0.100000000000000,  -0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.100000000000000,  -0.100000000000000,  -0.900000000000000,  0.657650819729946,
0.100000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
0.100000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
0.100000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
0.100000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
0.300000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
0.300000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
0.300000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
0.500000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
0.500000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
0.700000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  -0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.100000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  0.100000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  -0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.300000000000000,  -0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.100000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  0.100000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  -0.100000000000000,  0.657650819729946,
-0.500000000000000,  -0.500000000000000,  -0.300000000000000,  0.657650819729946,
-0.500000000000000,  -0.300000000000000,  -0.500000000000000,  0.657650819729946,
-0.500000000000000,  -0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  -0.100000000000000,  0.657650819729946,
-0.300000000000000,  -0.700000000000000,  -0.300000000000000,  0.657650819729946,
-0.300000000000000,  -0.500000000000000,  -0.500000000000000,  0.657650819729946,
-0.300000000000000,  -0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.300000000000000,  -0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.100000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
-0.100000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
-0.100000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.100000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
0.100000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
0.100000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
0.100000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
0.300000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
0.300000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
0.500000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  -0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.100000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  -0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  -0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.300000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  -0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  -0.100000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  -0.300000000000000,  0.657650819729946,
-0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.657650819729946,
-0.500000000000000,  -0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  -0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
-0.300000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
-0.300000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.300000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.100000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
-0.100000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
-0.100000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
0.100000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
0.100000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
0.300000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  -0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.100000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  -0.100000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  -0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  -0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  -0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
-0.500000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
-0.300000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
-0.300000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.100000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
-0.100000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
0.100000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  -0.100000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  -0.100000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
-0.300000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
-0.100000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  -0.300000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  -0.300000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
-0.500000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
-0.300000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  -0.500000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  -0.500000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
-0.700000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
-0.500000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  -0.700000000000000,  0.657650819729946,
-0.900000000000000,  -0.700000000000000,  -0.900000000000000,  0.657650819729946,
-0.700000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.900000000000000,  -0.900000000000000,  -0.900000000000000,  0.657650819729946,
-0.888888888888889,  -0.888888888888889,  0.666666666666667,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  0.444444444444444,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.222222222222222,  0.000000000000000,  -2.193552443114196,
-0.888888888888889,  0.000000000000000,  -0.222222222222222,  -2.193552443114196,
-0.888888888888889,  0.222222222222222,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  0.444444444444444,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  0.666666666666667,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  0.444444444444444,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  0.222222222222222,  -2.193552443114196,
-0.666666666666667,  -0.444444444444444,  0.000000000000000,  -2.193552443114196,
-0.666666666666667,  -0.222222222222222,  -0.222222222222222,  -2.193552443114196,
-0.666666666666667,  0.000000000000000,  -0.444444444444444,  -2.193552443114196,
-0.666666666666667,  0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  0.444444444444444,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  0.222222222222222,  -2.193552443114196,
-0.444444444444444,  -0.666666666666667,  0.000000000000000,  -2.193552443114196,
-0.444444444444444,  -0.444444444444444,  -0.222222222222222,  -2.193552443114196,
-0.444444444444444,  -0.222222222222222,  -0.444444444444444,  -2.193552443114196,
-0.444444444444444,  0.000000000000000,  -0.666666666666667,  -2.193552443114196,
-0.444444444444444,  0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.222222222222222,  -0.888888888888889,  0.000000000000000,  -2.193552443114196,
-0.222222222222222,  -0.666666666666667,  -0.222222222222222,  -2.193552443114196,
-0.222222222222222,  -0.444444444444444,  -0.444444444444444,  -2.193552443114196,
-0.222222222222222,  -0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.222222222222222,  0.000000000000000,  -0.888888888888889,  -2.193552443114196,
0.000000000000000,  -0.888888888888889,  -0.222222222222222,  -2.193552443114196,
0.000000000000000,  -0.666666666666667,  -0.444444444444444,  -2.193552443114196,
0.000000000000000,  -0.444444444444444,  -0.666666666666667,  -2.193552443114196,
0.000000000000000,  -0.222222222222222,  -0.888888888888889,  -2.193552443114196,
0.222222222222222,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
0.222222222222222,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
0.222222222222222,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
0.444444444444444,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
0.444444444444444,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
0.666666666666667,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  0.444444444444444,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  0.000000000000000,  -2.193552443114196,
-0.888888888888889,  -0.222222222222222,  -0.222222222222222,  -2.193552443114196,
-0.888888888888889,  0.000000000000000,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  0.444444444444444,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  0.222222222222222,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  -2.193552443114196,
-0.666666666666667,  -0.444444444444444,  -0.222222222222222,  -2.193552443114196,
-0.666666666666667,  -0.222222222222222,  -0.444444444444444,  -2.193552443114196,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  0.000000000000000,  -2.193552443114196,
-0.444444444444444,  -0.666666666666667,  -0.222222222222222,  -2.193552443114196,
-0.444444444444444,  -0.444444444444444,  -0.444444444444444,  -2.193552443114196,
-0.444444444444444,  -0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.444444444444444,  0.000000000000000,  -0.888888888888889,  -2.193552443114196,
-0.222222222222222,  -0.888888888888889,  -0.222222222222222,  -2.193552443114196,
-0.222222222222222,  -0.666666666666667,  -0.444444444444444,  -2.193552443114196,
-0.222222222222222,  -0.444444444444444,  -0.666666666666667,  -2.193552443114196,
-0.222222222222222,  -0.222222222222222,  -0.888888888888889,  -2.193552443114196,
0.000000000000000,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
0.000000000000000,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
0.222222222222222,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
0.222222222222222,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
0.444444444444444,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  0.000000000000000,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  -0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.222222222222222,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  0.000000000000000,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  0.000000000000000,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  -0.222222222222222,  -2.193552443114196,
-0.666666666666667,  -0.444444444444444,  -0.444444444444444,  -2.193552443114196,
-0.666666666666667,  -0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  0.000000000000000,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  -0.222222222222222,  -2.193552443114196,
-0.444444444444444,  -0.666666666666667,  -0.444444444444444,  -2.193552443114196,
-0.444444444444444,  -0.444444444444444,  -0.666666666666667,  -2.193552443114196,
-0.444444444444444,  -0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.222222222222222,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
-0.222222222222222,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
-0.222222222222222,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
0.000000000000000,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
0.000000000000000,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
0.222222222222222,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  0.000000000000000,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  -0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  -0.222222222222222,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  0.000000000000000,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  -0.222222222222222,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  -0.444444444444444,  -2.193552443114196,
-0.666666666666667,  -0.444444444444444,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  -0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
-0.444444444444444,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
-0.444444444444444,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
-0.222222222222222,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
-0.222222222222222,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
0.000000000000000,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  -0.222222222222222,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  -0.222222222222222,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
-0.444444444444444,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
-0.222222222222222,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  -0.444444444444444,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  -0.444444444444444,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
-0.666666666666667,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
-0.444444444444444,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  -0.666666666666667,  -2.193552443114196,
-0.888888888888889,  -0.666666666666667,  -0.888888888888889,  -2.193552443114196,
-0.666666666666667,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.888888888888889,  -0.888888888888889,  -0.888888888888889,  -2.193552443114196,
-0.875000000000000,  -0.875000000000000,  0.625000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  0.375000000000000,  2.813706187341903,
-0.875000000000000,  -0.375000000000000,  0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.125000000000000,  -0.125000000000000,  2.813706187341903,
-0.875000000000000,  0.125000000000000,  -0.375000000000000,  2.813706187341903,
-0.875000000000000,  0.375000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  0.625000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  0.375000000000000,  2.813706187341903,
-0.625000000000000,  -0.625000000000000,  0.125000000000000,  2.813706187341903,
-0.625000000000000,  -0.375000000000000,  -0.125000000000000,  2.813706187341903,
-0.625000000000000,  -0.125000000000000,  -0.375000000000000,  2.813706187341903,
-0.625000000000000,  0.125000000000000,  -0.625000000000000,  2.813706187341903,
-0.625000000000000,  0.375000000000000,  -0.875000000000000,  2.813706187341903,
-0.375000000000000,  -0.875000000000000,  0.125000000000000,  2.813706187341903,
-0.375000000000000,  -0.625000000000000,  -0.125000000000000,  2.813706187341903,
-0.375000000000000,  -0.375000000000000,  -0.375000000000000,  2.813706187341903,
-0.375000000000000,  -0.125000000000000,  -0.625000000000000,  2.813706187341903,
-0.375000000000000,  0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.125000000000000,  -0.875000000000000,  -0.125000000000000,  2.813706187341903,
-0.125000000000000,  -0.625000000000000,  -0.375000000000000,  2.813706187341903,
-0.125000000000000,  -0.375000000000000,  -0.625000000000000,  2.813706187341903,
-0.125000000000000,  -0.125000000000000,  -0.875000000000000,  2.813706187341903,
0.125000000000000,  -0.875000000000000,  -0.375000000000000,  2.813706187341903,
0.125000000000000,  -0.625000000000000,  -0.625000000000000,  2.813706187341903,
0.125000000000000,  -0.375000000000000,  -0.875000000000000,  2.813706187341903,
0.375000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
0.375000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
0.625000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  0.375000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.375000000000000,  -0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.125000000000000,  -0.375000000000000,  2.813706187341903,
-0.875000000000000,  0.125000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  0.375000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  0.125000000000000,  2.813706187341903,
-0.625000000000000,  -0.625000000000000,  -0.125000000000000,  2.813706187341903,
-0.625000000000000,  -0.375000000000000,  -0.375000000000000,  2.813706187341903,
-0.625000000000000,  -0.125000000000000,  -0.625000000000000,  2.813706187341903,
-0.625000000000000,  0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.375000000000000,  -0.875000000000000,  -0.125000000000000,  2.813706187341903,
-0.375000000000000,  -0.625000000000000,  -0.375000000000000,  2.813706187341903,
-0.375000000000000,  -0.375000000000000,  -0.625000000000000,  2.813706187341903,
-0.375000000000000,  -0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.125000000000000,  -0.875000000000000,  -0.375000000000000,  2.813706187341903,
-0.125000000000000,  -0.625000000000000,  -0.625000000000000,  2.813706187341903,
-0.125000000000000,  -0.375000000000000,  -0.875000000000000,  2.813706187341903,
0.125000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
0.125000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
0.375000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  -0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.375000000000000,  -0.375000000000000,  2.813706187341903,
-0.875000000000000,  -0.125000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  -0.125000000000000,  2.813706187341903,
-0.625000000000000,  -0.625000000000000,  -0.375000000000000,  2.813706187341903,
-0.625000000000000,  -0.375000000000000,  -0.625000000000000,  2.813706187341903,
-0.625000000000000,  -0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.375000000000000,  -0.875000000000000,  -0.375000000000000,  2.813706187341903,
-0.375000000000000,  -0.625000000000000,  -0.625000000000000,  2.813706187341903,
-0.375000000000000,  -0.375000000000000,  -0.875000000000000,  2.813706187341903,
-0.125000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
-0.125000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
0.125000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  -0.125000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  -0.375000000000000,  2.813706187341903,
-0.875000000000000,  -0.375000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  -0.125000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  -0.375000000000000,  2.813706187341903,
-0.625000000000000,  -0.625000000000000,  -0.625000000000000,  2.813706187341903,
-0.625000000000000,  -0.375000000000000,  -0.875000000000000,  2.813706187341903,
-0.375000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
-0.375000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
-0.125000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  -0.375000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  -0.375000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
-0.625000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
-0.375000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  -0.625000000000000,  2.813706187341903,
-0.875000000000000,  -0.625000000000000,  -0.875000000000000,  2.813706187341903,
-0.625000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.875000000000000,  -0.875000000000000,  -0.875000000000000,  2.813706187341903,
-0.857142857142857,  -0.857142857142857,  0.571428571428571,  -1.744081989683894,
-0.857142857142857,  -0.571428571428571,  0.285714285714286,  -1.744081989683894,
-0.857142857142857,  -0.285714285714286,  0.000000000000000,  -1.744081989683894,
-0.857142857142857,  0.000000000000000,  -0.285714285714286,  -1.744081989683894,
-0.857142857142857,  0.285714285714286,  -0.571428571428571,  -1.744081989683894,
-0.857142857142857,  0.571428571428571,  -0.857142857142857,  -1.744081989683894,
-0.571428571428571,  -0.857142857142857,  0.285714285714286,  -1.744081989683894,
-0.571428571428571,  -0.571428571428571,  0.000000000000000,  -1.744081989683894,
-0.571428571428571,  -0.285714285714286,  -0.285714285714286,  -1.744081989683894,
-0.571428571428571,  0.000000000000000,  -0.571428571428571,  -1.744081989683894,
-0.571428571428571,  0.285714285714286,  -0.857142857142857,  -1.744081989683894,
-0.285714285714286,  -0.857142857142857,  0.000000000000000,  -1.744081989683894,
-0.285714285714286,  -0.571428571428571,  -0.285714285714286,  -1.744081989683894,
-0.285714285714286,  -0.285714285714286,  -0.571428571428571,  -1.744081989683894,
-0.285714285714286,  0.000000000000000,  -0.857142857142857,  -1.744081989683894,
0.000000000000000,  -0.857142857142857,  -0.285714285714286,  -1.744081989683894,
0.000000000000000,  -0.571428571428571,  -0.571428571428571,  -1.744081989683894,
0.000000000000000,  -0.285714285714286,  -0.857142857142857,  -1.744081989683894,
0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -1.744081989683894,
0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -1.744081989683894,
0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.857142857142857,  -0.857142857142857,  0.285714285714286,  -1.744081989683894,
-0.857142857142857,  -0.571428571428571,  0.000000000000000,  -1.744081989683894,
-0.857142857142857,  -0.285714285714286,  -0.285714285714286,  -1.744081989683894,
-0.857142857142857,  0.000000000000000,  -0.571428571428571,  -1.744081989683894,
-0.857142857142857,  0.285714285714286,  -0.857142857142857,  -1.744081989683894,
-0.571428571428571,  -0.857142857142857,  0.000000000000000,  -1.744081989683894,
-0.571428571428571,  -0.571428571428571,  -0.285714285714286,  -1.744081989683894,
-0.571428571428571,  -0.285714285714286,  -0.571428571428571,  -1.744081989683894,
-0.571428571428571,  0.000000000000000,  -0.857142857142857,  -1.744081989683894,
-0.285714285714286,  -0.857142857142857,  -0.285714285714286,  -1.744081989683894,
-0.285714285714286,  -0.571428571428571,  -0.571428571428571,  -1.744081989683894,
-0.285714285714286,  -0.285714285714286,  -0.857142857142857,  -1.744081989683894,
0.000000000000000,  -0.857142857142857,  -0.571428571428571,  -1.744081989683894,
0.000000000000000,  -0.571428571428571,  -0.857142857142857,  -1.744081989683894,
0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.857142857142857,  -0.857142857142857,  0.000000000000000,  -1.744081989683894,
-0.857142857142857,  -0.571428571428571,  -0.285714285714286,  -1.744081989683894,
-0.857142857142857,  -0.285714285714286,  -0.571428571428571,  -1.744081989683894,
-0.857142857142857,  0.000000000000000,  -0.857142857142857,  -1.744081989683894,
-0.571428571428571,  -0.857142857142857,  -0.285714285714286,  -1.744081989683894,
-0.571428571428571,  -0.571428571428571,  -0.571428571428571,  -1.744081989683894,
-0.571428571428571,  -0.285714285714286,  -0.857142857142857,  -1.744081989683894,
-0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -1.744081989683894,
-0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -1.744081989683894,
0.000000000000000,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.857142857142857,  -0.857142857142857,  -0.285714285714286,  -1.744081989683894,
-0.857142857142857,  -0.571428571428571,  -0.571428571428571,  -1.744081989683894,
-0.857142857142857,  -0.285714285714286,  -0.857142857142857,  -1.744081989683894,
-0.571428571428571,  -0.857142857142857,  -0.571428571428571,  -1.744081989683894,
-0.571428571428571,  -0.571428571428571,  -0.857142857142857,  -1.744081989683894,
-0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.857142857142857,  -0.857142857142857,  -0.571428571428571,  -1.744081989683894,
-0.857142857142857,  -0.571428571428571,  -0.857142857142857,  -1.744081989683894,
-0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.857142857142857,  -0.857142857142857,  -0.857142857142857,  -1.744081989683894,
-0.833333333333333,  -0.833333333333333,  0.500000000000000,  0.539337234194377,
-0.833333333333333,  -0.500000000000000,  0.166666666666667,  0.539337234194377,
-0.833333333333333,  -0.166666666666667,  -0.166666666666667,  0.539337234194377,
-0.833333333333333,  0.166666666666667,  -0.500000000000000,  0.539337234194377,
-0.833333333333333,  0.500000000000000,  -0.833333333333333,  0.539337234194377,
-0.500000000000000,  -0.833333333333333,  0.166666666666667,  0.539337234194377,
-0.500000000000000,  -0.500000000000000,  -0.166666666666667,  0.539337234194377,
-0.500000000000000,  -0.166666666666667,  -0.500000000000000,  0.539337234194377,
-0.500000000000000,  0.166666666666667,  -0.833333333333333,  0.539337234194377,
-0.166666666666667,  -0.833333333333333,  -0.166666666666667,  0.539337234194377,
-0.166666666666667,  -0.500000000000000,  -0.500000000000000,  0.539337234194377,
-0.166666666666667,  -0.166666666666667,  -0.833333333333333,  0.539337234194377,
0.166666666666667,  -0.833333333333333,  -0.500000000000000,  0.539337234194377,
0.166666666666667,  -0.500000000000000,  -0.833333333333333,  0.539337234194377,
0.500000000000000,  -0.833333333333333,  -0.833333333333333,  0.539337234194377,
-0.833333333333333,  -0.833333333333333,  0.166666666666667,  0.539337234194377,
-0.833333333333333,  -0.500000000000000,  -0.166666666666667,  0.539337234194377,
-0.833333333333333,  -0.166666666666667,  -0.500000000000000,  0.539337234194377,
-0.833333333333333,  0.166666666666667,  -0.833333333333333,  0.539337234194377,
-0.500000000000000,  -0.833333333333333,  -0.166666666666667,  0.539337234194377,
-0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.539337234194377,
-0.500000000000000,  -0.166666666666667,  -0.833333333333333,  0.539337234194377,
-0.166666666666667,  -0.833333333333333,  -0.500000000000000,  0.539337234194377,
-0.166666666666667,  -0.500000000000000,  -0.833333333333333,  0.539337234194377,
0.166666666666667,  -0.833333333333333,  -0.833333333333333,  0.539337234194377,
-0.833333333333333,  -0.833333333333333,  -0.166666666666667,  0.539337234194377,
-0.833333333333333,  -0.500000000000000,  -0.500000000000000,  0.539337234194377,
-0.833333333333333,  -0.166666666666667,  -0.833333333333333,  0.539337234194377,
-0.500000000000000,  -0.833333333333333,  -0.500000000000000,  0.539337234194377,
-0.500000000000000,  -0.500000000000000,  -0.833333333333333,  0.539337234194377,
-0.166666666666667,  -0.833333333333333,  -0.833333333333333,  0.539337234194377,
-0.833333333333333,  -0.833333333333333,  -0.500000000000000,  0.539337234194377,
-0.833333333333333,  -0.500000000000000,  -0.833333333333333,  0.539337234194377,
-0.500000000000000,  -0.833333333333333,  -0.833333333333333,  0.539337234194377,
-0.833333333333333,  -0.833333333333333,  -0.833333333333333,  0.539337234194377,
-0.800000000000000,  -0.800000000000000,  0.400000000000000,  -0.077790972206826,
-0.800000000000000,  -0.400000000000000,  0.000000000000000,  -0.077790972206826,
-0.800000000000000,  0.000000000000000,  -0.400000000000000,  -0.077790972206826,
-0.800000000000000,  0.400000000000000,  -0.800000000000000,  -0.077790972206826,
-0.400000000000000,  -0.800000000000000,  0.000000000000000,  -0.077790972206826,
-0.400000000000000,  -0.400000000000000,  -0.400000000000000,  -0.077790972206826,
-0.400000000000000,  0.000000000000000,  -0.800000000000000,  -0.077790972206826,
0.000000000000000,  -0.800000000000000,  -0.400000000000000,  -0.077790972206826,
0.000000000000000,  -0.400000000000000,  -0.800000000000000,  -0.077790972206826,
0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.077790972206826,
-0.800000000000000,  -0.800000000000000,  0.000000000000000,  -0.077790972206826,
-0.800000000000000,  -0.400000000000000,  -0.400000000000000,  -0.077790972206826,
-0.800000000000000,  0.000000000000000,  -0.800000000000000,  -0.077790972206826,
-0.400000000000000,  -0.800000000000000,  -0.400000000000000,  -0.077790972206826,
-0.400000000000000,  -0.400000000000000,  -0.800000000000000,  -0.077790972206826,
0.000000000000000,  -0.800000000000000,  -0.800000000000000,  -0.077790972206826,
-0.800000000000000,  -0.800000000000000,  -0.400000000000000,  -0.077790972206826,
-0.800000000000000,  -0.400000000000000,  -0.800000000000000,  -0.077790972206826,
-0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.077790972206826,
-0.800000000000000,  -0.800000000000000,  -0.800000000000000,  -0.077790972206826,
-0.750000000000000,  -0.750000000000000,  0.250000000000000,  0.004379242418043,
-0.750000000000000,  -0.250000000000000,  -0.250000000000000,  0.004379242418043,
-0.750000000000000,  0.250000000000000,  -0.750000000000000,  0.004379242418043,
-0.250000000000000,  -0.750000000000000,  -0.250000000000000,  0.004379242418043,
-0.250000000000000,  -0.250000000000000,  -0.750000000000000,  0.004379242418043,
0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.004379242418043,
-0.750000000000000,  -0.750000000000000,  -0.250000000000000,  0.004379242418043,
-0.750000000000000,  -0.250000000000000,  -0.750000000000000,  0.004379242418043,
-0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.004379242418043,
-0.750000000000000,  -0.750000000000000,  -0.750000000000000,  0.004379242418043,
-0.666666666666667,  -0.666666666666667,  0.000000000000000,  -0.000065837064721,
-0.666666666666667,  0.000000000000000,  -0.666666666666667,  -0.000065837064721,
0.000000000000000,  -0.666666666666667,  -0.666666666666667,  -0.000065837064721,
-0.666666666666667,  -0.666666666666667,  -0.666666666666667,  -0.000065837064721,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,   0.000000108585647;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<16,T>: public IMTetrahedra<17,T> {};
/*
715
-0.909090909090909  -0.909090909090909  0.727272727272727  0.870591471154497
-0.909090909090909  -0.727272727272727  0.545454545454545  0.870591471154497
-0.909090909090909  -0.545454545454545  0.363636363636364  0.870591471154497
-0.909090909090909  -0.363636363636364  0.181818181818182  0.870591471154497
-0.909090909090909  -0.181818181818182  0.000000000000000  0.870591471154497
-0.909090909090909  0.000000000000000  -0.181818181818182  0.870591471154497
-0.909090909090909  0.181818181818182  -0.363636363636364  0.870591471154497
-0.909090909090909  0.363636363636364  -0.545454545454545  0.870591471154497
-0.909090909090909  0.545454545454545  -0.727272727272727  0.870591471154497
-0.909090909090909  0.727272727272727  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  0.545454545454545  0.870591471154497
-0.727272727272727  -0.727272727272727  0.363636363636364  0.870591471154497
-0.727272727272727  -0.545454545454545  0.181818181818182  0.870591471154497
-0.727272727272727  -0.363636363636364  0.000000000000000  0.870591471154497
-0.727272727272727  -0.181818181818182  -0.181818181818182  0.870591471154497
-0.727272727272727  0.000000000000000  -0.363636363636364  0.870591471154497
-0.727272727272727  0.181818181818182  -0.545454545454545  0.870591471154497
-0.727272727272727  0.363636363636364  -0.727272727272727  0.870591471154497
-0.727272727272727  0.545454545454545  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  0.363636363636364  0.870591471154497
-0.545454545454545  -0.727272727272727  0.181818181818182  0.870591471154497
-0.545454545454545  -0.545454545454545  0.000000000000000  0.870591471154497
-0.545454545454545  -0.363636363636364  -0.181818181818182  0.870591471154497
-0.545454545454545  -0.181818181818182  -0.363636363636364  0.870591471154497
-0.545454545454545  0.000000000000000  -0.545454545454545  0.870591471154497
-0.545454545454545  0.181818181818182  -0.727272727272727  0.870591471154497
-0.545454545454545  0.363636363636364  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  0.181818181818182  0.870591471154497
-0.363636363636364  -0.727272727272727  0.000000000000000  0.870591471154497
-0.363636363636364  -0.545454545454545  -0.181818181818182  0.870591471154497
-0.363636363636364  -0.363636363636364  -0.363636363636364  0.870591471154497
-0.363636363636364  -0.181818181818182  -0.545454545454545  0.870591471154497
-0.363636363636364  0.000000000000000  -0.727272727272727  0.870591471154497
-0.363636363636364  0.181818181818182  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  0.000000000000000  0.870591471154497
-0.181818181818182  -0.727272727272727  -0.181818181818182  0.870591471154497
-0.181818181818182  -0.545454545454545  -0.363636363636364  0.870591471154497
-0.181818181818182  -0.363636363636364  -0.545454545454545  0.870591471154497
-0.181818181818182  -0.181818181818182  -0.727272727272727  0.870591471154497
-0.181818181818182  0.000000000000000  -0.909090909090909  0.870591471154497
0.000000000000000  -0.909090909090909  -0.181818181818182  0.870591471154497
0.000000000000000  -0.727272727272727  -0.363636363636364  0.870591471154497
0.000000000000000  -0.545454545454545  -0.545454545454545  0.870591471154497
0.000000000000000  -0.363636363636364  -0.727272727272727  0.870591471154497
0.000000000000000  -0.181818181818182  -0.909090909090909  0.870591471154497
0.181818181818182  -0.909090909090909  -0.363636363636364  0.870591471154497
0.181818181818182  -0.727272727272727  -0.545454545454545  0.870591471154497
0.181818181818182  -0.545454545454545  -0.727272727272727  0.870591471154497
0.181818181818182  -0.363636363636364  -0.909090909090909  0.870591471154497
0.363636363636364  -0.909090909090909  -0.545454545454545  0.870591471154497
0.363636363636364  -0.727272727272727  -0.727272727272727  0.870591471154497
0.363636363636364  -0.545454545454545  -0.909090909090909  0.870591471154497
0.545454545454545  -0.909090909090909  -0.727272727272727  0.870591471154497
0.545454545454545  -0.727272727272727  -0.909090909090909  0.870591471154497
0.727272727272727  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  0.545454545454545  0.870591471154497
-0.909090909090909  -0.727272727272727  0.363636363636364  0.870591471154497
-0.909090909090909  -0.545454545454545  0.181818181818182  0.870591471154497
-0.909090909090909  -0.363636363636364  0.000000000000000  0.870591471154497
-0.909090909090909  -0.181818181818182  -0.181818181818182  0.870591471154497
-0.909090909090909  0.000000000000000  -0.363636363636364  0.870591471154497
-0.909090909090909  0.181818181818182  -0.545454545454545  0.870591471154497
-0.909090909090909  0.363636363636364  -0.727272727272727  0.870591471154497
-0.909090909090909  0.545454545454545  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  0.363636363636364  0.870591471154497
-0.727272727272727  -0.727272727272727  0.181818181818182  0.870591471154497
-0.727272727272727  -0.545454545454545  0.000000000000000  0.870591471154497
-0.727272727272727  -0.363636363636364  -0.181818181818182  0.870591471154497
-0.727272727272727  -0.181818181818182  -0.363636363636364  0.870591471154497
-0.727272727272727  0.000000000000000  -0.545454545454545  0.870591471154497
-0.727272727272727  0.181818181818182  -0.727272727272727  0.870591471154497
-0.727272727272727  0.363636363636364  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  0.181818181818182  0.870591471154497
-0.545454545454545  -0.727272727272727  0.000000000000000  0.870591471154497
-0.545454545454545  -0.545454545454545  -0.181818181818182  0.870591471154497
-0.545454545454545  -0.363636363636364  -0.363636363636364  0.870591471154497
-0.545454545454545  -0.181818181818182  -0.545454545454545  0.870591471154497
-0.545454545454545  0.000000000000000  -0.727272727272727  0.870591471154497
-0.545454545454545  0.181818181818182  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  0.000000000000000  0.870591471154497
-0.363636363636364  -0.727272727272727  -0.181818181818182  0.870591471154497
-0.363636363636364  -0.545454545454545  -0.363636363636364  0.870591471154497
-0.363636363636364  -0.363636363636364  -0.545454545454545  0.870591471154497
-0.363636363636364  -0.181818181818182  -0.727272727272727  0.870591471154497
-0.363636363636364  0.000000000000000  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  -0.181818181818182  0.870591471154497
-0.181818181818182  -0.727272727272727  -0.363636363636364  0.870591471154497
-0.181818181818182  -0.545454545454545  -0.545454545454545  0.870591471154497
-0.181818181818182  -0.363636363636364  -0.727272727272727  0.870591471154497
-0.181818181818182  -0.181818181818182  -0.909090909090909  0.870591471154497
0.000000000000000  -0.909090909090909  -0.363636363636364  0.870591471154497
0.000000000000000  -0.727272727272727  -0.545454545454545  0.870591471154497
0.000000000000000  -0.545454545454545  -0.727272727272727  0.870591471154497
0.000000000000000  -0.363636363636364  -0.909090909090909  0.870591471154497
0.181818181818182  -0.909090909090909  -0.545454545454545  0.870591471154497
0.181818181818182  -0.727272727272727  -0.727272727272727  0.870591471154497
0.181818181818182  -0.545454545454545  -0.909090909090909  0.870591471154497
0.363636363636364  -0.909090909090909  -0.727272727272727  0.870591471154497
0.363636363636364  -0.727272727272727  -0.909090909090909  0.870591471154497
0.545454545454545  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  0.363636363636364  0.870591471154497
-0.909090909090909  -0.727272727272727  0.181818181818182  0.870591471154497
-0.909090909090909  -0.545454545454545  0.000000000000000  0.870591471154497
-0.909090909090909  -0.363636363636364  -0.181818181818182  0.870591471154497
-0.909090909090909  -0.181818181818182  -0.363636363636364  0.870591471154497
-0.909090909090909  0.000000000000000  -0.545454545454545  0.870591471154497
-0.909090909090909  0.181818181818182  -0.727272727272727  0.870591471154497
-0.909090909090909  0.363636363636364  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  0.181818181818182  0.870591471154497
-0.727272727272727  -0.727272727272727  0.000000000000000  0.870591471154497
-0.727272727272727  -0.545454545454545  -0.181818181818182  0.870591471154497
-0.727272727272727  -0.363636363636364  -0.363636363636364  0.870591471154497
-0.727272727272727  -0.181818181818182  -0.545454545454545  0.870591471154497
-0.727272727272727  0.000000000000000  -0.727272727272727  0.870591471154497
-0.727272727272727  0.181818181818182  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  0.000000000000000  0.870591471154497
-0.545454545454545  -0.727272727272727  -0.181818181818182  0.870591471154497
-0.545454545454545  -0.545454545454545  -0.363636363636364  0.870591471154497
-0.545454545454545  -0.363636363636364  -0.545454545454545  0.870591471154497
-0.545454545454545  -0.181818181818182  -0.727272727272727  0.870591471154497
-0.545454545454545  0.000000000000000  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  -0.181818181818182  0.870591471154497
-0.363636363636364  -0.727272727272727  -0.363636363636364  0.870591471154497
-0.363636363636364  -0.545454545454545  -0.545454545454545  0.870591471154497
-0.363636363636364  -0.363636363636364  -0.727272727272727  0.870591471154497
-0.363636363636364  -0.181818181818182  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  -0.363636363636364  0.870591471154497
-0.181818181818182  -0.727272727272727  -0.545454545454545  0.870591471154497
-0.181818181818182  -0.545454545454545  -0.727272727272727  0.870591471154497
-0.181818181818182  -0.363636363636364  -0.909090909090909  0.870591471154497
0.000000000000000  -0.909090909090909  -0.545454545454545  0.870591471154497
0.000000000000000  -0.727272727272727  -0.727272727272727  0.870591471154497
0.000000000000000  -0.545454545454545  -0.909090909090909  0.870591471154497
0.181818181818182  -0.909090909090909  -0.727272727272727  0.870591471154497
0.181818181818182  -0.727272727272727  -0.909090909090909  0.870591471154497
0.363636363636364  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  0.181818181818182  0.870591471154497
-0.909090909090909  -0.727272727272727  0.000000000000000  0.870591471154497
-0.909090909090909  -0.545454545454545  -0.181818181818182  0.870591471154497
-0.909090909090909  -0.363636363636364  -0.363636363636364  0.870591471154497
-0.909090909090909  -0.181818181818182  -0.545454545454545  0.870591471154497
-0.909090909090909  0.000000000000000  -0.727272727272727  0.870591471154497
-0.909090909090909  0.181818181818182  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  0.000000000000000  0.870591471154497
-0.727272727272727  -0.727272727272727  -0.181818181818182  0.870591471154497
-0.727272727272727  -0.545454545454545  -0.363636363636364  0.870591471154497
-0.727272727272727  -0.363636363636364  -0.545454545454545  0.870591471154497
-0.727272727272727  -0.181818181818182  -0.727272727272727  0.870591471154497
-0.727272727272727  0.000000000000000  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  -0.181818181818182  0.870591471154497
-0.545454545454545  -0.727272727272727  -0.363636363636364  0.870591471154497
-0.545454545454545  -0.545454545454545  -0.545454545454545  0.870591471154497
-0.545454545454545  -0.363636363636364  -0.727272727272727  0.870591471154497
-0.545454545454545  -0.181818181818182  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  -0.363636363636364  0.870591471154497
-0.363636363636364  -0.727272727272727  -0.545454545454545  0.870591471154497
-0.363636363636364  -0.545454545454545  -0.727272727272727  0.870591471154497
-0.363636363636364  -0.363636363636364  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  -0.545454545454545  0.870591471154497
-0.181818181818182  -0.727272727272727  -0.727272727272727  0.870591471154497
-0.181818181818182  -0.545454545454545  -0.909090909090909  0.870591471154497
0.000000000000000  -0.909090909090909  -0.727272727272727  0.870591471154497
0.000000000000000  -0.727272727272727  -0.909090909090909  0.870591471154497
0.181818181818182  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  0.000000000000000  0.870591471154497
-0.909090909090909  -0.727272727272727  -0.181818181818182  0.870591471154497
-0.909090909090909  -0.545454545454545  -0.363636363636364  0.870591471154497
-0.909090909090909  -0.363636363636364  -0.545454545454545  0.870591471154497
-0.909090909090909  -0.181818181818182  -0.727272727272727  0.870591471154497
-0.909090909090909  0.000000000000000  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  -0.181818181818182  0.870591471154497
-0.727272727272727  -0.727272727272727  -0.363636363636364  0.870591471154497
-0.727272727272727  -0.545454545454545  -0.545454545454545  0.870591471154497
-0.727272727272727  -0.363636363636364  -0.727272727272727  0.870591471154497
-0.727272727272727  -0.181818181818182  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  -0.363636363636364  0.870591471154497
-0.545454545454545  -0.727272727272727  -0.545454545454545  0.870591471154497
-0.545454545454545  -0.545454545454545  -0.727272727272727  0.870591471154497
-0.545454545454545  -0.363636363636364  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  -0.545454545454545  0.870591471154497
-0.363636363636364  -0.727272727272727  -0.727272727272727  0.870591471154497
-0.363636363636364  -0.545454545454545  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  -0.727272727272727  0.870591471154497
-0.181818181818182  -0.727272727272727  -0.909090909090909  0.870591471154497
0.000000000000000  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  -0.181818181818182  0.870591471154497
-0.909090909090909  -0.727272727272727  -0.363636363636364  0.870591471154497
-0.909090909090909  -0.545454545454545  -0.545454545454545  0.870591471154497
-0.909090909090909  -0.363636363636364  -0.727272727272727  0.870591471154497
-0.909090909090909  -0.181818181818182  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  -0.363636363636364  0.870591471154497
-0.727272727272727  -0.727272727272727  -0.545454545454545  0.870591471154497
-0.727272727272727  -0.545454545454545  -0.727272727272727  0.870591471154497
-0.727272727272727  -0.363636363636364  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  -0.545454545454545  0.870591471154497
-0.545454545454545  -0.727272727272727  -0.727272727272727  0.870591471154497
-0.545454545454545  -0.545454545454545  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  -0.727272727272727  0.870591471154497
-0.363636363636364  -0.727272727272727  -0.909090909090909  0.870591471154497
-0.181818181818182  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  -0.363636363636364  0.870591471154497
-0.909090909090909  -0.727272727272727  -0.545454545454545  0.870591471154497
-0.909090909090909  -0.545454545454545  -0.727272727272727  0.870591471154497
-0.909090909090909  -0.363636363636364  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  -0.545454545454545  0.870591471154497
-0.727272727272727  -0.727272727272727  -0.727272727272727  0.870591471154497
-0.727272727272727  -0.545454545454545  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  -0.727272727272727  0.870591471154497
-0.545454545454545  -0.727272727272727  -0.909090909090909  0.870591471154497
-0.363636363636364  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  -0.545454545454545  0.870591471154497
-0.909090909090909  -0.727272727272727  -0.727272727272727  0.870591471154497
-0.909090909090909  -0.545454545454545  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  -0.727272727272727  0.870591471154497
-0.727272727272727  -0.727272727272727  -0.909090909090909  0.870591471154497
-0.545454545454545  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  -0.727272727272727  0.870591471154497
-0.909090909090909  -0.727272727272727  -0.909090909090909  0.870591471154497
-0.727272727272727  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.909090909090909  -0.909090909090909  -0.909090909090909  0.870591471154497
-0.900000000000000  -0.900000000000000  0.700000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  0.500000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  0.300000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  0.100000000000000  -3.131670570142602
-0.900000000000000  -0.100000000000000  -0.100000000000000  -3.131670570142602
-0.900000000000000  0.100000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  0.300000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  0.500000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  0.700000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  0.500000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  0.300000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  0.100000000000000  -3.131670570142602
-0.700000000000000  -0.300000000000000  -0.100000000000000  -3.131670570142602
-0.700000000000000  -0.100000000000000  -0.300000000000000  -3.131670570142602
-0.700000000000000  0.100000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  0.300000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  0.500000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  0.300000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  0.100000000000000  -3.131670570142602
-0.500000000000000  -0.500000000000000  -0.100000000000000  -3.131670570142602
-0.500000000000000  -0.300000000000000  -0.300000000000000  -3.131670570142602
-0.500000000000000  -0.100000000000000  -0.500000000000000  -3.131670570142602
-0.500000000000000  0.100000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  0.300000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  0.100000000000000  -3.131670570142602
-0.300000000000000  -0.700000000000000  -0.100000000000000  -3.131670570142602
-0.300000000000000  -0.500000000000000  -0.300000000000000  -3.131670570142602
-0.300000000000000  -0.300000000000000  -0.500000000000000  -3.131670570142602
-0.300000000000000  -0.100000000000000  -0.700000000000000  -3.131670570142602
-0.300000000000000  0.100000000000000  -0.900000000000000  -3.131670570142602
-0.100000000000000  -0.900000000000000  -0.100000000000000  -3.131670570142602
-0.100000000000000  -0.700000000000000  -0.300000000000000  -3.131670570142602
-0.100000000000000  -0.500000000000000  -0.500000000000000  -3.131670570142602
-0.100000000000000  -0.300000000000000  -0.700000000000000  -3.131670570142602
-0.100000000000000  -0.100000000000000  -0.900000000000000  -3.131670570142602
0.100000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
0.100000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
0.100000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
0.100000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
0.300000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
0.300000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
0.300000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
0.500000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
0.500000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
0.700000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  0.500000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  0.300000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  0.100000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  -0.100000000000000  -3.131670570142602
-0.900000000000000  -0.100000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  0.100000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  0.300000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  0.500000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  0.300000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  0.100000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  -0.100000000000000  -3.131670570142602
-0.700000000000000  -0.300000000000000  -0.300000000000000  -3.131670570142602
-0.700000000000000  -0.100000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  0.100000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  0.300000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  0.100000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  -0.100000000000000  -3.131670570142602
-0.500000000000000  -0.500000000000000  -0.300000000000000  -3.131670570142602
-0.500000000000000  -0.300000000000000  -0.500000000000000  -3.131670570142602
-0.500000000000000  -0.100000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  0.100000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  -0.100000000000000  -3.131670570142602
-0.300000000000000  -0.700000000000000  -0.300000000000000  -3.131670570142602
-0.300000000000000  -0.500000000000000  -0.500000000000000  -3.131670570142602
-0.300000000000000  -0.300000000000000  -0.700000000000000  -3.131670570142602
-0.300000000000000  -0.100000000000000  -0.900000000000000  -3.131670570142602
-0.100000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
-0.100000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
-0.100000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
-0.100000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
0.100000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
0.100000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
0.100000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
0.300000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
0.300000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
0.500000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  0.300000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  0.100000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  -0.100000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  -0.100000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  0.100000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  0.300000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  0.100000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  -0.100000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  -0.300000000000000  -3.131670570142602
-0.700000000000000  -0.300000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  -0.100000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  0.100000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  -0.100000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  -0.300000000000000  -3.131670570142602
-0.500000000000000  -0.500000000000000  -0.500000000000000  -3.131670570142602
-0.500000000000000  -0.300000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  -0.100000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
-0.300000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
-0.300000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
-0.300000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
-0.100000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
-0.100000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
-0.100000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
0.100000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
0.100000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
0.300000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  0.100000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  -0.100000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  -0.100000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  0.100000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  -0.100000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  -0.300000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  -0.300000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  -0.100000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
-0.500000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
-0.300000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
-0.300000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
-0.100000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
-0.100000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
0.100000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  -0.100000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  -0.100000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
-0.300000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
-0.100000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  -0.300000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  -0.300000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
-0.500000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
-0.300000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  -0.500000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  -0.500000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
-0.700000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
-0.500000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  -0.700000000000000  -3.131670570142602
-0.900000000000000  -0.700000000000000  -0.900000000000000  -3.131670570142602
-0.700000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.900000000000000  -0.900000000000000  -0.900000000000000  -3.131670570142602
-0.888888888888889  -0.888888888888889  0.666666666666667  4.441943697306247
-0.888888888888889  -0.666666666666667  0.444444444444444  4.441943697306247
-0.888888888888889  -0.444444444444444  0.222222222222222  4.441943697306247
-0.888888888888889  -0.222222222222222  0.000000000000000  4.441943697306247
-0.888888888888889  0.000000000000000  -0.222222222222222  4.441943697306247
-0.888888888888889  0.222222222222222  -0.444444444444444  4.441943697306247
-0.888888888888889  0.444444444444444  -0.666666666666667  4.441943697306247
-0.888888888888889  0.666666666666667  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  0.444444444444444  4.441943697306247
-0.666666666666667  -0.666666666666667  0.222222222222222  4.441943697306247
-0.666666666666667  -0.444444444444444  0.000000000000000  4.441943697306247
-0.666666666666667  -0.222222222222222  -0.222222222222222  4.441943697306247
-0.666666666666667  0.000000000000000  -0.444444444444444  4.441943697306247
-0.666666666666667  0.222222222222222  -0.666666666666667  4.441943697306247
-0.666666666666667  0.444444444444444  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  0.222222222222222  4.441943697306247
-0.444444444444444  -0.666666666666667  0.000000000000000  4.441943697306247
-0.444444444444444  -0.444444444444444  -0.222222222222222  4.441943697306247
-0.444444444444444  -0.222222222222222  -0.444444444444444  4.441943697306247
-0.444444444444444  0.000000000000000  -0.666666666666667  4.441943697306247
-0.444444444444444  0.222222222222222  -0.888888888888889  4.441943697306247
-0.222222222222222  -0.888888888888889  0.000000000000000  4.441943697306247
-0.222222222222222  -0.666666666666667  -0.222222222222222  4.441943697306247
-0.222222222222222  -0.444444444444444  -0.444444444444444  4.441943697306247
-0.222222222222222  -0.222222222222222  -0.666666666666667  4.441943697306247
-0.222222222222222  0.000000000000000  -0.888888888888889  4.441943697306247
0.000000000000000  -0.888888888888889  -0.222222222222222  4.441943697306247
0.000000000000000  -0.666666666666667  -0.444444444444444  4.441943697306247
0.000000000000000  -0.444444444444444  -0.666666666666667  4.441943697306247
0.000000000000000  -0.222222222222222  -0.888888888888889  4.441943697306247
0.222222222222222  -0.888888888888889  -0.444444444444444  4.441943697306247
0.222222222222222  -0.666666666666667  -0.666666666666667  4.441943697306247
0.222222222222222  -0.444444444444444  -0.888888888888889  4.441943697306247
0.444444444444444  -0.888888888888889  -0.666666666666667  4.441943697306247
0.444444444444444  -0.666666666666667  -0.888888888888889  4.441943697306247
0.666666666666667  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  0.444444444444444  4.441943697306247
-0.888888888888889  -0.666666666666667  0.222222222222222  4.441943697306247
-0.888888888888889  -0.444444444444444  0.000000000000000  4.441943697306247
-0.888888888888889  -0.222222222222222  -0.222222222222222  4.441943697306247
-0.888888888888889  0.000000000000000  -0.444444444444444  4.441943697306247
-0.888888888888889  0.222222222222222  -0.666666666666667  4.441943697306247
-0.888888888888889  0.444444444444444  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  0.222222222222222  4.441943697306247
-0.666666666666667  -0.666666666666667  0.000000000000000  4.441943697306247
-0.666666666666667  -0.444444444444444  -0.222222222222222  4.441943697306247
-0.666666666666667  -0.222222222222222  -0.444444444444444  4.441943697306247
-0.666666666666667  0.000000000000000  -0.666666666666667  4.441943697306247
-0.666666666666667  0.222222222222222  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  0.000000000000000  4.441943697306247
-0.444444444444444  -0.666666666666667  -0.222222222222222  4.441943697306247
-0.444444444444444  -0.444444444444444  -0.444444444444444  4.441943697306247
-0.444444444444444  -0.222222222222222  -0.666666666666667  4.441943697306247
-0.444444444444444  0.000000000000000  -0.888888888888889  4.441943697306247
-0.222222222222222  -0.888888888888889  -0.222222222222222  4.441943697306247
-0.222222222222222  -0.666666666666667  -0.444444444444444  4.441943697306247
-0.222222222222222  -0.444444444444444  -0.666666666666667  4.441943697306247
-0.222222222222222  -0.222222222222222  -0.888888888888889  4.441943697306247
0.000000000000000  -0.888888888888889  -0.444444444444444  4.441943697306247
0.000000000000000  -0.666666666666667  -0.666666666666667  4.441943697306247
0.000000000000000  -0.444444444444444  -0.888888888888889  4.441943697306247
0.222222222222222  -0.888888888888889  -0.666666666666667  4.441943697306247
0.222222222222222  -0.666666666666667  -0.888888888888889  4.441943697306247
0.444444444444444  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  0.222222222222222  4.441943697306247
-0.888888888888889  -0.666666666666667  0.000000000000000  4.441943697306247
-0.888888888888889  -0.444444444444444  -0.222222222222222  4.441943697306247
-0.888888888888889  -0.222222222222222  -0.444444444444444  4.441943697306247
-0.888888888888889  0.000000000000000  -0.666666666666667  4.441943697306247
-0.888888888888889  0.222222222222222  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  0.000000000000000  4.441943697306247
-0.666666666666667  -0.666666666666667  -0.222222222222222  4.441943697306247
-0.666666666666667  -0.444444444444444  -0.444444444444444  4.441943697306247
-0.666666666666667  -0.222222222222222  -0.666666666666667  4.441943697306247
-0.666666666666667  0.000000000000000  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  -0.222222222222222  4.441943697306247
-0.444444444444444  -0.666666666666667  -0.444444444444444  4.441943697306247
-0.444444444444444  -0.444444444444444  -0.666666666666667  4.441943697306247
-0.444444444444444  -0.222222222222222  -0.888888888888889  4.441943697306247
-0.222222222222222  -0.888888888888889  -0.444444444444444  4.441943697306247
-0.222222222222222  -0.666666666666667  -0.666666666666667  4.441943697306247
-0.222222222222222  -0.444444444444444  -0.888888888888889  4.441943697306247
0.000000000000000  -0.888888888888889  -0.666666666666667  4.441943697306247
0.000000000000000  -0.666666666666667  -0.888888888888889  4.441943697306247
0.222222222222222  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  0.000000000000000  4.441943697306247
-0.888888888888889  -0.666666666666667  -0.222222222222222  4.441943697306247
-0.888888888888889  -0.444444444444444  -0.444444444444444  4.441943697306247
-0.888888888888889  -0.222222222222222  -0.666666666666667  4.441943697306247
-0.888888888888889  0.000000000000000  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  -0.222222222222222  4.441943697306247
-0.666666666666667  -0.666666666666667  -0.444444444444444  4.441943697306247
-0.666666666666667  -0.444444444444444  -0.666666666666667  4.441943697306247
-0.666666666666667  -0.222222222222222  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  -0.444444444444444  4.441943697306247
-0.444444444444444  -0.666666666666667  -0.666666666666667  4.441943697306247
-0.444444444444444  -0.444444444444444  -0.888888888888889  4.441943697306247
-0.222222222222222  -0.888888888888889  -0.666666666666667  4.441943697306247
-0.222222222222222  -0.666666666666667  -0.888888888888889  4.441943697306247
0.000000000000000  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  -0.222222222222222  4.441943697306247
-0.888888888888889  -0.666666666666667  -0.444444444444444  4.441943697306247
-0.888888888888889  -0.444444444444444  -0.666666666666667  4.441943697306247
-0.888888888888889  -0.222222222222222  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  -0.444444444444444  4.441943697306247
-0.666666666666667  -0.666666666666667  -0.666666666666667  4.441943697306247
-0.666666666666667  -0.444444444444444  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  -0.666666666666667  4.441943697306247
-0.444444444444444  -0.666666666666667  -0.888888888888889  4.441943697306247
-0.222222222222222  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  -0.444444444444444  4.441943697306247
-0.888888888888889  -0.666666666666667  -0.666666666666667  4.441943697306247
-0.888888888888889  -0.444444444444444  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  -0.666666666666667  4.441943697306247
-0.666666666666667  -0.666666666666667  -0.888888888888889  4.441943697306247
-0.444444444444444  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  -0.666666666666667  4.441943697306247
-0.888888888888889  -0.666666666666667  -0.888888888888889  4.441943697306247
-0.666666666666667  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.888888888888889  -0.888888888888889  -0.888888888888889  4.441943697306247
-0.875000000000000  -0.875000000000000  0.625000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  0.375000000000000  -3.159249052454067
-0.875000000000000  -0.375000000000000  0.125000000000000  -3.159249052454067
-0.875000000000000  -0.125000000000000  -0.125000000000000  -3.159249052454067
-0.875000000000000  0.125000000000000  -0.375000000000000  -3.159249052454067
-0.875000000000000  0.375000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  0.625000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  0.375000000000000  -3.159249052454067
-0.625000000000000  -0.625000000000000  0.125000000000000  -3.159249052454067
-0.625000000000000  -0.375000000000000  -0.125000000000000  -3.159249052454067
-0.625000000000000  -0.125000000000000  -0.375000000000000  -3.159249052454067
-0.625000000000000  0.125000000000000  -0.625000000000000  -3.159249052454067
-0.625000000000000  0.375000000000000  -0.875000000000000  -3.159249052454067
-0.375000000000000  -0.875000000000000  0.125000000000000  -3.159249052454067
-0.375000000000000  -0.625000000000000  -0.125000000000000  -3.159249052454067
-0.375000000000000  -0.375000000000000  -0.375000000000000  -3.159249052454067
-0.375000000000000  -0.125000000000000  -0.625000000000000  -3.159249052454067
-0.375000000000000  0.125000000000000  -0.875000000000000  -3.159249052454067
-0.125000000000000  -0.875000000000000  -0.125000000000000  -3.159249052454067
-0.125000000000000  -0.625000000000000  -0.375000000000000  -3.159249052454067
-0.125000000000000  -0.375000000000000  -0.625000000000000  -3.159249052454067
-0.125000000000000  -0.125000000000000  -0.875000000000000  -3.159249052454067
0.125000000000000  -0.875000000000000  -0.375000000000000  -3.159249052454067
0.125000000000000  -0.625000000000000  -0.625000000000000  -3.159249052454067
0.125000000000000  -0.375000000000000  -0.875000000000000  -3.159249052454067
0.375000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
0.375000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
0.625000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  0.375000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  0.125000000000000  -3.159249052454067
-0.875000000000000  -0.375000000000000  -0.125000000000000  -3.159249052454067
-0.875000000000000  -0.125000000000000  -0.375000000000000  -3.159249052454067
-0.875000000000000  0.125000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  0.375000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  0.125000000000000  -3.159249052454067
-0.625000000000000  -0.625000000000000  -0.125000000000000  -3.159249052454067
-0.625000000000000  -0.375000000000000  -0.375000000000000  -3.159249052454067
-0.625000000000000  -0.125000000000000  -0.625000000000000  -3.159249052454067
-0.625000000000000  0.125000000000000  -0.875000000000000  -3.159249052454067
-0.375000000000000  -0.875000000000000  -0.125000000000000  -3.159249052454067
-0.375000000000000  -0.625000000000000  -0.375000000000000  -3.159249052454067
-0.375000000000000  -0.375000000000000  -0.625000000000000  -3.159249052454067
-0.375000000000000  -0.125000000000000  -0.875000000000000  -3.159249052454067
-0.125000000000000  -0.875000000000000  -0.375000000000000  -3.159249052454067
-0.125000000000000  -0.625000000000000  -0.625000000000000  -3.159249052454067
-0.125000000000000  -0.375000000000000  -0.875000000000000  -3.159249052454067
0.125000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
0.125000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
0.375000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  0.125000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  -0.125000000000000  -3.159249052454067
-0.875000000000000  -0.375000000000000  -0.375000000000000  -3.159249052454067
-0.875000000000000  -0.125000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  0.125000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  -0.125000000000000  -3.159249052454067
-0.625000000000000  -0.625000000000000  -0.375000000000000  -3.159249052454067
-0.625000000000000  -0.375000000000000  -0.625000000000000  -3.159249052454067
-0.625000000000000  -0.125000000000000  -0.875000000000000  -3.159249052454067
-0.375000000000000  -0.875000000000000  -0.375000000000000  -3.159249052454067
-0.375000000000000  -0.625000000000000  -0.625000000000000  -3.159249052454067
-0.375000000000000  -0.375000000000000  -0.875000000000000  -3.159249052454067
-0.125000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
-0.125000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
0.125000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  -0.125000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  -0.375000000000000  -3.159249052454067
-0.875000000000000  -0.375000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  -0.125000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  -0.375000000000000  -3.159249052454067
-0.625000000000000  -0.625000000000000  -0.625000000000000  -3.159249052454067
-0.625000000000000  -0.375000000000000  -0.875000000000000  -3.159249052454067
-0.375000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
-0.375000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
-0.125000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  -0.375000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  -0.375000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
-0.625000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
-0.375000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  -0.625000000000000  -3.159249052454067
-0.875000000000000  -0.625000000000000  -0.875000000000000  -3.159249052454067
-0.625000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.875000000000000  -0.875000000000000  -0.875000000000000  -3.159249052454067
-0.857142857142857  -0.857142857142857  0.571428571428571  1.186944687423761
-0.857142857142857  -0.571428571428571  0.285714285714286  1.186944687423761
-0.857142857142857  -0.285714285714286  0.000000000000000  1.186944687423761
-0.857142857142857  0.000000000000000  -0.285714285714286  1.186944687423761
-0.857142857142857  0.285714285714286  -0.571428571428571  1.186944687423761
-0.857142857142857  0.571428571428571  -0.857142857142857  1.186944687423761
-0.571428571428571  -0.857142857142857  0.285714285714286  1.186944687423761
-0.571428571428571  -0.571428571428571  0.000000000000000  1.186944687423761
-0.571428571428571  -0.285714285714286  -0.285714285714286  1.186944687423761
-0.571428571428571  0.000000000000000  -0.571428571428571  1.186944687423761
-0.571428571428571  0.285714285714286  -0.857142857142857  1.186944687423761
-0.285714285714286  -0.857142857142857  0.000000000000000  1.186944687423761
-0.285714285714286  -0.571428571428571  -0.285714285714286  1.186944687423761
-0.285714285714286  -0.285714285714286  -0.571428571428571  1.186944687423761
-0.285714285714286  0.000000000000000  -0.857142857142857  1.186944687423761
0.000000000000000  -0.857142857142857  -0.285714285714286  1.186944687423761
0.000000000000000  -0.571428571428571  -0.571428571428571  1.186944687423761
0.000000000000000  -0.285714285714286  -0.857142857142857  1.186944687423761
0.285714285714286  -0.857142857142857  -0.571428571428571  1.186944687423761
0.285714285714286  -0.571428571428571  -0.857142857142857  1.186944687423761
0.571428571428571  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.857142857142857  -0.857142857142857  0.285714285714286  1.186944687423761
-0.857142857142857  -0.571428571428571  0.000000000000000  1.186944687423761
-0.857142857142857  -0.285714285714286  -0.285714285714286  1.186944687423761
-0.857142857142857  0.000000000000000  -0.571428571428571  1.186944687423761
-0.857142857142857  0.285714285714286  -0.857142857142857  1.186944687423761
-0.571428571428571  -0.857142857142857  0.000000000000000  1.186944687423761
-0.571428571428571  -0.571428571428571  -0.285714285714286  1.186944687423761
-0.571428571428571  -0.285714285714286  -0.571428571428571  1.186944687423761
-0.571428571428571  0.000000000000000  -0.857142857142857  1.186944687423761
-0.285714285714286  -0.857142857142857  -0.285714285714286  1.186944687423761
-0.285714285714286  -0.571428571428571  -0.571428571428571  1.186944687423761
-0.285714285714286  -0.285714285714286  -0.857142857142857  1.186944687423761
0.000000000000000  -0.857142857142857  -0.571428571428571  1.186944687423761
0.000000000000000  -0.571428571428571  -0.857142857142857  1.186944687423761
0.285714285714286  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.857142857142857  -0.857142857142857  0.000000000000000  1.186944687423761
-0.857142857142857  -0.571428571428571  -0.285714285714286  1.186944687423761
-0.857142857142857  -0.285714285714286  -0.571428571428571  1.186944687423761
-0.857142857142857  0.000000000000000  -0.857142857142857  1.186944687423761
-0.571428571428571  -0.857142857142857  -0.285714285714286  1.186944687423761
-0.571428571428571  -0.571428571428571  -0.571428571428571  1.186944687423761
-0.571428571428571  -0.285714285714286  -0.857142857142857  1.186944687423761
-0.285714285714286  -0.857142857142857  -0.571428571428571  1.186944687423761
-0.285714285714286  -0.571428571428571  -0.857142857142857  1.186944687423761
0.000000000000000  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.857142857142857  -0.857142857142857  -0.285714285714286  1.186944687423761
-0.857142857142857  -0.571428571428571  -0.571428571428571  1.186944687423761
-0.857142857142857  -0.285714285714286  -0.857142857142857  1.186944687423761
-0.571428571428571  -0.857142857142857  -0.571428571428571  1.186944687423761
-0.571428571428571  -0.571428571428571  -0.857142857142857  1.186944687423761
-0.285714285714286  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.857142857142857  -0.857142857142857  -0.571428571428571  1.186944687423761
-0.857142857142857  -0.571428571428571  -0.857142857142857  1.186944687423761
-0.571428571428571  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.857142857142857  -0.857142857142857  -0.857142857142857  1.186944687423761
-0.833333333333333  -0.833333333333333  0.500000000000000  -0.228425181541148
-0.833333333333333  -0.500000000000000  0.166666666666667  -0.228425181541148
-0.833333333333333  -0.166666666666667  -0.166666666666667  -0.228425181541148
-0.833333333333333  0.166666666666667  -0.500000000000000  -0.228425181541148
-0.833333333333333  0.500000000000000  -0.833333333333333  -0.228425181541148
-0.500000000000000  -0.833333333333333  0.166666666666667  -0.228425181541148
-0.500000000000000  -0.500000000000000  -0.166666666666667  -0.228425181541148
-0.500000000000000  -0.166666666666667  -0.500000000000000  -0.228425181541148
-0.500000000000000  0.166666666666667  -0.833333333333333  -0.228425181541148
-0.166666666666667  -0.833333333333333  -0.166666666666667  -0.228425181541148
-0.166666666666667  -0.500000000000000  -0.500000000000000  -0.228425181541148
-0.166666666666667  -0.166666666666667  -0.833333333333333  -0.228425181541148
0.166666666666667  -0.833333333333333  -0.500000000000000  -0.228425181541148
0.166666666666667  -0.500000000000000  -0.833333333333333  -0.228425181541148
0.500000000000000  -0.833333333333333  -0.833333333333333  -0.228425181541148
-0.833333333333333  -0.833333333333333  0.166666666666667  -0.228425181541148
-0.833333333333333  -0.500000000000000  -0.166666666666667  -0.228425181541148
-0.833333333333333  -0.166666666666667  -0.500000000000000  -0.228425181541148
-0.833333333333333  0.166666666666667  -0.833333333333333  -0.228425181541148
-0.500000000000000  -0.833333333333333  -0.166666666666667  -0.228425181541148
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.228425181541148
-0.500000000000000  -0.166666666666667  -0.833333333333333  -0.228425181541148
-0.166666666666667  -0.833333333333333  -0.500000000000000  -0.228425181541148
-0.166666666666667  -0.500000000000000  -0.833333333333333  -0.228425181541148
0.166666666666667  -0.833333333333333  -0.833333333333333  -0.228425181541148
-0.833333333333333  -0.833333333333333  -0.166666666666667  -0.228425181541148
-0.833333333333333  -0.500000000000000  -0.500000000000000  -0.228425181541148
-0.833333333333333  -0.166666666666667  -0.833333333333333  -0.228425181541148
-0.500000000000000  -0.833333333333333  -0.500000000000000  -0.228425181541148
-0.500000000000000  -0.500000000000000  -0.833333333333333  -0.228425181541148
-0.166666666666667  -0.833333333333333  -0.833333333333333  -0.228425181541148
-0.833333333333333  -0.833333333333333  -0.500000000000000  -0.228425181541148
-0.833333333333333  -0.500000000000000  -0.833333333333333  -0.228425181541148
-0.500000000000000  -0.833333333333333  -0.833333333333333  -0.228425181541148
-0.833333333333333  -0.833333333333333  -0.833333333333333  -0.228425181541148
-0.800000000000000  -0.800000000000000  0.400000000000000  0.020258065678861
-0.800000000000000  -0.400000000000000  0.000000000000000  0.020258065678861
-0.800000000000000  0.000000000000000  -0.400000000000000  0.020258065678861
-0.800000000000000  0.400000000000000  -0.800000000000000  0.020258065678861
-0.400000000000000  -0.800000000000000  0.000000000000000  0.020258065678861
-0.400000000000000  -0.400000000000000  -0.400000000000000  0.020258065678861
-0.400000000000000  0.000000000000000  -0.800000000000000  0.020258065678861
0.000000000000000  -0.800000000000000  -0.400000000000000  0.020258065678861
0.000000000000000  -0.400000000000000  -0.800000000000000  0.020258065678861
0.400000000000000  -0.800000000000000  -0.800000000000000  0.020258065678861
-0.800000000000000  -0.800000000000000  0.000000000000000  0.020258065678861
-0.800000000000000  -0.400000000000000  -0.400000000000000  0.020258065678861
-0.800000000000000  0.000000000000000  -0.800000000000000  0.020258065678861
-0.400000000000000  -0.800000000000000  -0.400000000000000  0.020258065678861
-0.400000000000000  -0.400000000000000  -0.800000000000000  0.020258065678861
0.000000000000000  -0.800000000000000  -0.800000000000000  0.020258065678861
-0.800000000000000  -0.800000000000000  -0.400000000000000  0.020258065678861
-0.800000000000000  -0.400000000000000  -0.800000000000000  0.020258065678861
-0.400000000000000  -0.800000000000000  -0.800000000000000  0.020258065678861
-0.800000000000000  -0.800000000000000  -0.800000000000000  0.020258065678861
-0.750000000000000  -0.750000000000000  0.250000000000000  -0.000667313130368
-0.750000000000000  -0.250000000000000  -0.250000000000000  -0.000667313130368
-0.750000000000000  0.250000000000000  -0.750000000000000  -0.000667313130368
-0.250000000000000  -0.750000000000000  -0.250000000000000  -0.000667313130368
-0.250000000000000  -0.250000000000000  -0.750000000000000  -0.000667313130368
0.250000000000000  -0.750000000000000  -0.750000000000000  -0.000667313130368
-0.750000000000000  -0.750000000000000  -0.250000000000000  -0.000667313130368
-0.750000000000000  -0.250000000000000  -0.750000000000000  -0.000667313130368
-0.250000000000000  -0.750000000000000  -0.750000000000000  -0.000667313130368
-0.750000000000000  -0.750000000000000  -0.750000000000000  -0.000667313130368
-0.666666666666667  -0.666666666666667  0.000000000000000  0.000005290478415
-0.666666666666667  0.000000000000000  -0.666666666666667  0.000005290478415
0.000000000000000  -0.666666666666667  -0.666666666666667  0.000005290478415
-0.666666666666667  -0.666666666666667  -0.666666666666667  0.000005290478415
-0.500000000000000  -0.500000000000000  -0.500000000000000  -0.000000003712330
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=19
*/
template<typename T>
struct IMTetrahedra<19,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 19;
    static const uint16_type nPoints = 715;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.909090909090909,  -0.909090909090909,  0.727272727272727,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  0.000000000000000,  0.870591471154497,
            -0.909090909090909,  0.000000000000000,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  0.181818181818182,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  0.727272727272727,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  0.545454545454545,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  0.000000000000000,  0.870591471154497,
            -0.727272727272727,  -0.181818181818182,  -0.181818181818182,  0.870591471154497,
            -0.727272727272727,  0.000000000000000,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  0.363636363636364,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  0.000000000000000,  0.870591471154497,
            -0.545454545454545,  -0.363636363636364,  -0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.181818181818182,  -0.363636363636364,  0.870591471154497,
            -0.545454545454545,  0.000000000000000,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  0.181818181818182,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  0.000000000000000,  0.870591471154497,
            -0.363636363636364,  -0.545454545454545,  -0.181818181818182,  0.870591471154497,
            -0.363636363636364,  -0.363636363636364,  -0.363636363636364,  0.870591471154497,
            -0.363636363636364,  -0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.363636363636364,  0.000000000000000,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  0.000000000000000,  0.870591471154497,
            -0.181818181818182,  -0.727272727272727,  -0.181818181818182,  0.870591471154497,
            -0.181818181818182,  -0.545454545454545,  -0.363636363636364,  0.870591471154497,
            -0.181818181818182,  -0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.181818181818182,  -0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.181818181818182,  0.000000000000000,  -0.909090909090909,  0.870591471154497,
            0.000000000000000,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            0.000000000000000,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            0.000000000000000,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            0.000000000000000,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            0.000000000000000,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            0.181818181818182,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            0.181818181818182,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            0.181818181818182,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            0.181818181818182,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            0.363636363636364,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            0.363636363636364,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            0.363636363636364,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            0.545454545454545,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            0.545454545454545,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            0.727272727272727,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  0.000000000000000,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  0.000000000000000,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  0.000000000000000,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  -0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.181818181818182,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  0.000000000000000,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  0.000000000000000,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  -0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.363636363636364,  -0.363636363636364,  0.870591471154497,
            -0.545454545454545,  -0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  0.000000000000000,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  0.000000000000000,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  -0.181818181818182,  0.870591471154497,
            -0.363636363636364,  -0.545454545454545,  -0.363636363636364,  0.870591471154497,
            -0.363636363636364,  -0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.363636363636364,  -0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  0.000000000000000,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            -0.181818181818182,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            -0.181818181818182,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            -0.181818181818182,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.181818181818182,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            0.000000000000000,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            0.000000000000000,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            0.000000000000000,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            0.000000000000000,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            0.181818181818182,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            0.181818181818182,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            0.181818181818182,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            0.363636363636364,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            0.363636363636364,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            0.545454545454545,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  0.000000000000000,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  0.000000000000000,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  0.000000000000000,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  -0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  0.000000000000000,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  0.000000000000000,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  -0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  -0.363636363636364,  0.870591471154497,
            -0.545454545454545,  -0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  -0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  0.000000000000000,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            -0.363636363636364,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            -0.363636363636364,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            -0.181818181818182,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            -0.181818181818182,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.181818181818182,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            0.000000000000000,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            0.000000000000000,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            0.000000000000000,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            0.181818181818182,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            0.181818181818182,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            0.363636363636364,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  0.000000000000000,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  0.000000000000000,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  0.000000000000000,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  -0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  -0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  0.000000000000000,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            -0.363636363636364,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            -0.181818181818182,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            -0.181818181818182,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            0.000000000000000,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            0.000000000000000,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            0.181818181818182,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  0.000000000000000,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  0.000000000000000,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            -0.181818181818182,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            0.000000000000000,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  -0.181818181818182,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  -0.181818181818182,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            -0.363636363636364,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            -0.181818181818182,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  -0.363636363636364,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  -0.363636363636364,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            -0.545454545454545,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            -0.363636363636364,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  -0.545454545454545,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  -0.545454545454545,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            -0.727272727272727,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            -0.545454545454545,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  -0.727272727272727,  0.870591471154497,
            -0.909090909090909,  -0.727272727272727,  -0.909090909090909,  0.870591471154497,
            -0.727272727272727,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.909090909090909,  -0.909090909090909,  -0.909090909090909,  0.870591471154497,
            -0.900000000000000,  -0.900000000000000,  0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.100000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  0.100000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  0.300000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.300000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.100000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  0.100000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  0.300000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  0.100000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.500000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.300000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.100000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.500000000000000,  0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  0.100000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.700000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.500000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.300000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.300000000000000,  0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.900000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.700000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.500000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            0.100000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            0.100000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            0.100000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            0.100000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            0.300000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            0.300000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            0.300000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            0.500000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            0.500000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            0.700000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.100000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  0.100000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.300000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.100000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  0.100000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.500000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.300000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.700000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.500000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            0.100000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            0.100000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            0.100000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            0.300000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            0.300000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            0.500000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.100000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.300000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            0.100000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            0.100000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            0.300000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.100000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            0.100000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  -0.100000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.100000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.100000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  -0.300000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.300000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.300000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  -0.500000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.500000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.500000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  -0.700000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.700000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.700000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.900000000000000,  -0.900000000000000,  -0.900000000000000,  -3.131670570142602,
            -0.888888888888889,  -0.888888888888889,  0.666666666666667,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  0.444444444444444,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.222222222222222,  0.000000000000000,  4.441943697306247,
            -0.888888888888889,  0.000000000000000,  -0.222222222222222,  4.441943697306247,
            -0.888888888888889,  0.222222222222222,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  0.444444444444444,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  0.666666666666667,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  0.444444444444444,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  0.222222222222222,  4.441943697306247,
            -0.666666666666667,  -0.444444444444444,  0.000000000000000,  4.441943697306247,
            -0.666666666666667,  -0.222222222222222,  -0.222222222222222,  4.441943697306247,
            -0.666666666666667,  0.000000000000000,  -0.444444444444444,  4.441943697306247,
            -0.666666666666667,  0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  0.444444444444444,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  0.222222222222222,  4.441943697306247,
            -0.444444444444444,  -0.666666666666667,  0.000000000000000,  4.441943697306247,
            -0.444444444444444,  -0.444444444444444,  -0.222222222222222,  4.441943697306247,
            -0.444444444444444,  -0.222222222222222,  -0.444444444444444,  4.441943697306247,
            -0.444444444444444,  0.000000000000000,  -0.666666666666667,  4.441943697306247,
            -0.444444444444444,  0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.222222222222222,  -0.888888888888889,  0.000000000000000,  4.441943697306247,
            -0.222222222222222,  -0.666666666666667,  -0.222222222222222,  4.441943697306247,
            -0.222222222222222,  -0.444444444444444,  -0.444444444444444,  4.441943697306247,
            -0.222222222222222,  -0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.222222222222222,  0.000000000000000,  -0.888888888888889,  4.441943697306247,
            0.000000000000000,  -0.888888888888889,  -0.222222222222222,  4.441943697306247,
            0.000000000000000,  -0.666666666666667,  -0.444444444444444,  4.441943697306247,
            0.000000000000000,  -0.444444444444444,  -0.666666666666667,  4.441943697306247,
            0.000000000000000,  -0.222222222222222,  -0.888888888888889,  4.441943697306247,
            0.222222222222222,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            0.222222222222222,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            0.222222222222222,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            0.444444444444444,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            0.444444444444444,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            0.666666666666667,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  0.444444444444444,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  0.000000000000000,  4.441943697306247,
            -0.888888888888889,  -0.222222222222222,  -0.222222222222222,  4.441943697306247,
            -0.888888888888889,  0.000000000000000,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  0.444444444444444,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  0.222222222222222,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  0.000000000000000,  4.441943697306247,
            -0.666666666666667,  -0.444444444444444,  -0.222222222222222,  4.441943697306247,
            -0.666666666666667,  -0.222222222222222,  -0.444444444444444,  4.441943697306247,
            -0.666666666666667,  0.000000000000000,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  0.000000000000000,  4.441943697306247,
            -0.444444444444444,  -0.666666666666667,  -0.222222222222222,  4.441943697306247,
            -0.444444444444444,  -0.444444444444444,  -0.444444444444444,  4.441943697306247,
            -0.444444444444444,  -0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.444444444444444,  0.000000000000000,  -0.888888888888889,  4.441943697306247,
            -0.222222222222222,  -0.888888888888889,  -0.222222222222222,  4.441943697306247,
            -0.222222222222222,  -0.666666666666667,  -0.444444444444444,  4.441943697306247,
            -0.222222222222222,  -0.444444444444444,  -0.666666666666667,  4.441943697306247,
            -0.222222222222222,  -0.222222222222222,  -0.888888888888889,  4.441943697306247,
            0.000000000000000,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            0.000000000000000,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            0.000000000000000,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            0.222222222222222,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            0.222222222222222,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            0.444444444444444,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  0.000000000000000,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  -0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.222222222222222,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  0.000000000000000,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  0.000000000000000,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  -0.222222222222222,  4.441943697306247,
            -0.666666666666667,  -0.444444444444444,  -0.444444444444444,  4.441943697306247,
            -0.666666666666667,  -0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  0.000000000000000,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  -0.222222222222222,  4.441943697306247,
            -0.444444444444444,  -0.666666666666667,  -0.444444444444444,  4.441943697306247,
            -0.444444444444444,  -0.444444444444444,  -0.666666666666667,  4.441943697306247,
            -0.444444444444444,  -0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.222222222222222,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            -0.222222222222222,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            -0.222222222222222,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            0.000000000000000,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            0.000000000000000,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            0.222222222222222,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  0.000000000000000,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  -0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  -0.222222222222222,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  0.000000000000000,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  -0.222222222222222,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  -0.444444444444444,  4.441943697306247,
            -0.666666666666667,  -0.444444444444444,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  -0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            -0.444444444444444,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            -0.444444444444444,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            -0.222222222222222,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            -0.222222222222222,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            0.000000000000000,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  -0.222222222222222,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  -0.222222222222222,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            -0.444444444444444,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            -0.222222222222222,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  -0.444444444444444,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  -0.444444444444444,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            -0.666666666666667,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            -0.444444444444444,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  -0.666666666666667,  4.441943697306247,
            -0.888888888888889,  -0.666666666666667,  -0.888888888888889,  4.441943697306247,
            -0.666666666666667,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.888888888888889,  -0.888888888888889,  -0.888888888888889,  4.441943697306247,
            -0.875000000000000,  -0.875000000000000,  0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.375000000000000,  0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.125000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  0.125000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  0.375000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  0.375000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.625000000000000,  0.125000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.375000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.125000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.625000000000000,  0.125000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.625000000000000,  0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.875000000000000,  0.125000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.625000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.375000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.125000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.375000000000000,  0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.875000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.625000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.375000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            0.125000000000000,  -0.875000000000000,  -0.375000000000000,  -3.159249052454067,
            0.125000000000000,  -0.625000000000000,  -0.625000000000000,  -3.159249052454067,
            0.125000000000000,  -0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            0.375000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            0.375000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            0.625000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.375000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.125000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  0.125000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  0.125000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.625000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.375000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.125000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.625000000000000,  0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.875000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.625000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.375000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.875000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.625000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            0.125000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            0.125000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            0.375000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.375000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.125000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.625000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.375000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.875000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.625000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            0.125000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  -0.125000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.375000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.125000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.625000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.125000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  -0.375000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.375000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.375000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  -0.625000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.625000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.625000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.875000000000000,  -0.875000000000000,  -0.875000000000000,  -3.159249052454067,
            -0.857142857142857,  -0.857142857142857,  0.571428571428571,  1.186944687423761,
            -0.857142857142857,  -0.571428571428571,  0.285714285714286,  1.186944687423761,
            -0.857142857142857,  -0.285714285714286,  0.000000000000000,  1.186944687423761,
            -0.857142857142857,  0.000000000000000,  -0.285714285714286,  1.186944687423761,
            -0.857142857142857,  0.285714285714286,  -0.571428571428571,  1.186944687423761,
            -0.857142857142857,  0.571428571428571,  -0.857142857142857,  1.186944687423761,
            -0.571428571428571,  -0.857142857142857,  0.285714285714286,  1.186944687423761,
            -0.571428571428571,  -0.571428571428571,  0.000000000000000,  1.186944687423761,
            -0.571428571428571,  -0.285714285714286,  -0.285714285714286,  1.186944687423761,
            -0.571428571428571,  0.000000000000000,  -0.571428571428571,  1.186944687423761,
            -0.571428571428571,  0.285714285714286,  -0.857142857142857,  1.186944687423761,
            -0.285714285714286,  -0.857142857142857,  0.000000000000000,  1.186944687423761,
            -0.285714285714286,  -0.571428571428571,  -0.285714285714286,  1.186944687423761,
            -0.285714285714286,  -0.285714285714286,  -0.571428571428571,  1.186944687423761,
            -0.285714285714286,  0.000000000000000,  -0.857142857142857,  1.186944687423761,
            0.000000000000000,  -0.857142857142857,  -0.285714285714286,  1.186944687423761,
            0.000000000000000,  -0.571428571428571,  -0.571428571428571,  1.186944687423761,
            0.000000000000000,  -0.285714285714286,  -0.857142857142857,  1.186944687423761,
            0.285714285714286,  -0.857142857142857,  -0.571428571428571,  1.186944687423761,
            0.285714285714286,  -0.571428571428571,  -0.857142857142857,  1.186944687423761,
            0.571428571428571,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.857142857142857,  -0.857142857142857,  0.285714285714286,  1.186944687423761,
            -0.857142857142857,  -0.571428571428571,  0.000000000000000,  1.186944687423761,
            -0.857142857142857,  -0.285714285714286,  -0.285714285714286,  1.186944687423761,
            -0.857142857142857,  0.000000000000000,  -0.571428571428571,  1.186944687423761,
            -0.857142857142857,  0.285714285714286,  -0.857142857142857,  1.186944687423761,
            -0.571428571428571,  -0.857142857142857,  0.000000000000000,  1.186944687423761,
            -0.571428571428571,  -0.571428571428571,  -0.285714285714286,  1.186944687423761,
            -0.571428571428571,  -0.285714285714286,  -0.571428571428571,  1.186944687423761,
            -0.571428571428571,  0.000000000000000,  -0.857142857142857,  1.186944687423761,
            -0.285714285714286,  -0.857142857142857,  -0.285714285714286,  1.186944687423761,
            -0.285714285714286,  -0.571428571428571,  -0.571428571428571,  1.186944687423761,
            -0.285714285714286,  -0.285714285714286,  -0.857142857142857,  1.186944687423761,
            0.000000000000000,  -0.857142857142857,  -0.571428571428571,  1.186944687423761,
            0.000000000000000,  -0.571428571428571,  -0.857142857142857,  1.186944687423761,
            0.285714285714286,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.857142857142857,  -0.857142857142857,  0.000000000000000,  1.186944687423761,
            -0.857142857142857,  -0.571428571428571,  -0.285714285714286,  1.186944687423761,
            -0.857142857142857,  -0.285714285714286,  -0.571428571428571,  1.186944687423761,
            -0.857142857142857,  0.000000000000000,  -0.857142857142857,  1.186944687423761,
            -0.571428571428571,  -0.857142857142857,  -0.285714285714286,  1.186944687423761,
            -0.571428571428571,  -0.571428571428571,  -0.571428571428571,  1.186944687423761,
            -0.571428571428571,  -0.285714285714286,  -0.857142857142857,  1.186944687423761,
            -0.285714285714286,  -0.857142857142857,  -0.571428571428571,  1.186944687423761,
            -0.285714285714286,  -0.571428571428571,  -0.857142857142857,  1.186944687423761,
            0.000000000000000,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.857142857142857,  -0.857142857142857,  -0.285714285714286,  1.186944687423761,
            -0.857142857142857,  -0.571428571428571,  -0.571428571428571,  1.186944687423761,
            -0.857142857142857,  -0.285714285714286,  -0.857142857142857,  1.186944687423761,
            -0.571428571428571,  -0.857142857142857,  -0.571428571428571,  1.186944687423761,
            -0.571428571428571,  -0.571428571428571,  -0.857142857142857,  1.186944687423761,
            -0.285714285714286,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.857142857142857,  -0.857142857142857,  -0.571428571428571,  1.186944687423761,
            -0.857142857142857,  -0.571428571428571,  -0.857142857142857,  1.186944687423761,
            -0.571428571428571,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.857142857142857,  -0.857142857142857,  -0.857142857142857,  1.186944687423761,
            -0.833333333333333,  -0.833333333333333,  0.500000000000000,  -0.228425181541148,
            -0.833333333333333,  -0.500000000000000,  0.166666666666667,  -0.228425181541148,
            -0.833333333333333,  -0.166666666666667,  -0.166666666666667,  -0.228425181541148,
            -0.833333333333333,  0.166666666666667,  -0.500000000000000,  -0.228425181541148,
            -0.833333333333333,  0.500000000000000,  -0.833333333333333,  -0.228425181541148,
            -0.500000000000000,  -0.833333333333333,  0.166666666666667,  -0.228425181541148,
            -0.500000000000000,  -0.500000000000000,  -0.166666666666667,  -0.228425181541148,
            -0.500000000000000,  -0.166666666666667,  -0.500000000000000,  -0.228425181541148,
            -0.500000000000000,  0.166666666666667,  -0.833333333333333,  -0.228425181541148,
            -0.166666666666667,  -0.833333333333333,  -0.166666666666667,  -0.228425181541148,
            -0.166666666666667,  -0.500000000000000,  -0.500000000000000,  -0.228425181541148,
            -0.166666666666667,  -0.166666666666667,  -0.833333333333333,  -0.228425181541148,
            0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.228425181541148,
            0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.228425181541148,
            0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.228425181541148,
            -0.833333333333333,  -0.833333333333333,  0.166666666666667,  -0.228425181541148,
            -0.833333333333333,  -0.500000000000000,  -0.166666666666667,  -0.228425181541148,
            -0.833333333333333,  -0.166666666666667,  -0.500000000000000,  -0.228425181541148,
            -0.833333333333333,  0.166666666666667,  -0.833333333333333,  -0.228425181541148,
            -0.500000000000000,  -0.833333333333333,  -0.166666666666667,  -0.228425181541148,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.228425181541148,
            -0.500000000000000,  -0.166666666666667,  -0.833333333333333,  -0.228425181541148,
            -0.166666666666667,  -0.833333333333333,  -0.500000000000000,  -0.228425181541148,
            -0.166666666666667,  -0.500000000000000,  -0.833333333333333,  -0.228425181541148,
            0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.228425181541148,
            -0.833333333333333,  -0.833333333333333,  -0.166666666666667,  -0.228425181541148,
            -0.833333333333333,  -0.500000000000000,  -0.500000000000000,  -0.228425181541148,
            -0.833333333333333,  -0.166666666666667,  -0.833333333333333,  -0.228425181541148,
            -0.500000000000000,  -0.833333333333333,  -0.500000000000000,  -0.228425181541148,
            -0.500000000000000,  -0.500000000000000,  -0.833333333333333,  -0.228425181541148,
            -0.166666666666667,  -0.833333333333333,  -0.833333333333333,  -0.228425181541148,
            -0.833333333333333,  -0.833333333333333,  -0.500000000000000,  -0.228425181541148,
            -0.833333333333333,  -0.500000000000000,  -0.833333333333333,  -0.228425181541148,
            -0.500000000000000,  -0.833333333333333,  -0.833333333333333,  -0.228425181541148,
            -0.833333333333333,  -0.833333333333333,  -0.833333333333333,  -0.228425181541148,
            -0.800000000000000,  -0.800000000000000,  0.400000000000000,  0.020258065678861,
            -0.800000000000000,  -0.400000000000000,  0.000000000000000,  0.020258065678861,
            -0.800000000000000,  0.000000000000000,  -0.400000000000000,  0.020258065678861,
            -0.800000000000000,  0.400000000000000,  -0.800000000000000,  0.020258065678861,
            -0.400000000000000,  -0.800000000000000,  0.000000000000000,  0.020258065678861,
            -0.400000000000000,  -0.400000000000000,  -0.400000000000000,  0.020258065678861,
            -0.400000000000000,  0.000000000000000,  -0.800000000000000,  0.020258065678861,
            0.000000000000000,  -0.800000000000000,  -0.400000000000000,  0.020258065678861,
            0.000000000000000,  -0.400000000000000,  -0.800000000000000,  0.020258065678861,
            0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.020258065678861,
            -0.800000000000000,  -0.800000000000000,  0.000000000000000,  0.020258065678861,
            -0.800000000000000,  -0.400000000000000,  -0.400000000000000,  0.020258065678861,
            -0.800000000000000,  0.000000000000000,  -0.800000000000000,  0.020258065678861,
            -0.400000000000000,  -0.800000000000000,  -0.400000000000000,  0.020258065678861,
            -0.400000000000000,  -0.400000000000000,  -0.800000000000000,  0.020258065678861,
            0.000000000000000,  -0.800000000000000,  -0.800000000000000,  0.020258065678861,
            -0.800000000000000,  -0.800000000000000,  -0.400000000000000,  0.020258065678861,
            -0.800000000000000,  -0.400000000000000,  -0.800000000000000,  0.020258065678861,
            -0.400000000000000,  -0.800000000000000,  -0.800000000000000,  0.020258065678861,
            -0.800000000000000,  -0.800000000000000,  -0.800000000000000,  0.020258065678861,
            -0.750000000000000,  -0.750000000000000,  0.250000000000000,  -0.000667313130368,
            -0.750000000000000,  -0.250000000000000,  -0.250000000000000,  -0.000667313130368,
            -0.750000000000000,  0.250000000000000,  -0.750000000000000,  -0.000667313130368,
            -0.250000000000000,  -0.750000000000000,  -0.250000000000000,  -0.000667313130368,
            -0.250000000000000,  -0.250000000000000,  -0.750000000000000,  -0.000667313130368,
            0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.000667313130368,
            -0.750000000000000,  -0.750000000000000,  -0.250000000000000,  -0.000667313130368,
            -0.750000000000000,  -0.250000000000000,  -0.750000000000000,  -0.000667313130368,
            -0.250000000000000,  -0.750000000000000,  -0.750000000000000,  -0.000667313130368,
            -0.750000000000000,  -0.750000000000000,  -0.750000000000000,  -0.000667313130368,
            -0.666666666666667,  -0.666666666666667,  0.000000000000000,  0.000005290478415,
            -0.666666666666667,  0.000000000000000,  -0.666666666666667,  0.000005290478415,
            0.000000000000000,  -0.666666666666667,  -0.666666666666667,  0.000005290478415,
            -0.666666666666667,  -0.666666666666667,  -0.666666666666667,  0.000005290478415,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  -0.000000003712330;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<18,T>: public IMTetrahedra<19,T> {};
/*
1001
-0.916666666666667  -0.916666666666667  0.750000000000000  1.186370883531411
-0.916666666666667  -0.750000000000000  0.583333333333333  1.186370883531411
-0.916666666666667  -0.583333333333333  0.416666666666667  1.186370883531411
-0.916666666666667  -0.416666666666667  0.250000000000000  1.186370883531411
-0.916666666666667  -0.250000000000000  0.083333333333333  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.083333333333333  1.186370883531411
-0.916666666666667  0.083333333333333  -0.250000000000000  1.186370883531411
-0.916666666666667  0.250000000000000  -0.416666666666667  1.186370883531411
-0.916666666666667  0.416666666666667  -0.583333333333333  1.186370883531411
-0.916666666666667  0.583333333333333  -0.750000000000000  1.186370883531411
-0.916666666666667  0.750000000000000  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  0.583333333333333  1.186370883531411
-0.750000000000000  -0.750000000000000  0.416666666666667  1.186370883531411
-0.750000000000000  -0.583333333333333  0.250000000000000  1.186370883531411
-0.750000000000000  -0.416666666666667  0.083333333333333  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.083333333333333  1.186370883531411
-0.750000000000000  -0.083333333333333  -0.250000000000000  1.186370883531411
-0.750000000000000  0.083333333333333  -0.416666666666667  1.186370883531411
-0.750000000000000  0.250000000000000  -0.583333333333333  1.186370883531411
-0.750000000000000  0.416666666666667  -0.750000000000000  1.186370883531411
-0.750000000000000  0.583333333333333  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  0.416666666666667  1.186370883531411
-0.583333333333333  -0.750000000000000  0.250000000000000  1.186370883531411
-0.583333333333333  -0.583333333333333  0.083333333333333  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.083333333333333  1.186370883531411
-0.583333333333333  -0.250000000000000  -0.250000000000000  1.186370883531411
-0.583333333333333  -0.083333333333333  -0.416666666666667  1.186370883531411
-0.583333333333333  0.083333333333333  -0.583333333333333  1.186370883531411
-0.583333333333333  0.250000000000000  -0.750000000000000  1.186370883531411
-0.583333333333333  0.416666666666667  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  0.250000000000000  1.186370883531411
-0.416666666666667  -0.750000000000000  0.083333333333333  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.083333333333333  1.186370883531411
-0.416666666666667  -0.416666666666667  -0.250000000000000  1.186370883531411
-0.416666666666667  -0.250000000000000  -0.416666666666667  1.186370883531411
-0.416666666666667  -0.083333333333333  -0.583333333333333  1.186370883531411
-0.416666666666667  0.083333333333333  -0.750000000000000  1.186370883531411
-0.416666666666667  0.250000000000000  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  0.083333333333333  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.083333333333333  1.186370883531411
-0.250000000000000  -0.583333333333333  -0.250000000000000  1.186370883531411
-0.250000000000000  -0.416666666666667  -0.416666666666667  1.186370883531411
-0.250000000000000  -0.250000000000000  -0.583333333333333  1.186370883531411
-0.250000000000000  -0.083333333333333  -0.750000000000000  1.186370883531411
-0.250000000000000  0.083333333333333  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.083333333333333  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.083333333333333  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.083333333333333  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.083333333333333  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.083333333333333  -0.083333333333333  -0.916666666666667  1.186370883531411
0.083333333333333  -0.916666666666667  -0.250000000000000  1.186370883531411
0.083333333333333  -0.750000000000000  -0.416666666666667  1.186370883531411
0.083333333333333  -0.583333333333333  -0.583333333333333  1.186370883531411
0.083333333333333  -0.416666666666667  -0.750000000000000  1.186370883531411
0.083333333333333  -0.250000000000000  -0.916666666666667  1.186370883531411
0.250000000000000  -0.916666666666667  -0.416666666666667  1.186370883531411
0.250000000000000  -0.750000000000000  -0.583333333333333  1.186370883531411
0.250000000000000  -0.583333333333333  -0.750000000000000  1.186370883531411
0.250000000000000  -0.416666666666667  -0.916666666666667  1.186370883531411
0.416666666666667  -0.916666666666667  -0.583333333333333  1.186370883531411
0.416666666666667  -0.750000000000000  -0.750000000000000  1.186370883531411
0.416666666666667  -0.583333333333333  -0.916666666666667  1.186370883531411
0.583333333333333  -0.916666666666667  -0.750000000000000  1.186370883531411
0.583333333333333  -0.750000000000000  -0.916666666666667  1.186370883531411
0.750000000000000  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  0.583333333333333  1.186370883531411
-0.916666666666667  -0.750000000000000  0.416666666666667  1.186370883531411
-0.916666666666667  -0.583333333333333  0.250000000000000  1.186370883531411
-0.916666666666667  -0.416666666666667  0.083333333333333  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.083333333333333  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.250000000000000  1.186370883531411
-0.916666666666667  0.083333333333333  -0.416666666666667  1.186370883531411
-0.916666666666667  0.250000000000000  -0.583333333333333  1.186370883531411
-0.916666666666667  0.416666666666667  -0.750000000000000  1.186370883531411
-0.916666666666667  0.583333333333333  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  0.416666666666667  1.186370883531411
-0.750000000000000  -0.750000000000000  0.250000000000000  1.186370883531411
-0.750000000000000  -0.583333333333333  0.083333333333333  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.083333333333333  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.250000000000000  1.186370883531411
-0.750000000000000  -0.083333333333333  -0.416666666666667  1.186370883531411
-0.750000000000000  0.083333333333333  -0.583333333333333  1.186370883531411
-0.750000000000000  0.250000000000000  -0.750000000000000  1.186370883531411
-0.750000000000000  0.416666666666667  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  0.250000000000000  1.186370883531411
-0.583333333333333  -0.750000000000000  0.083333333333333  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.083333333333333  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.250000000000000  1.186370883531411
-0.583333333333333  -0.250000000000000  -0.416666666666667  1.186370883531411
-0.583333333333333  -0.083333333333333  -0.583333333333333  1.186370883531411
-0.583333333333333  0.083333333333333  -0.750000000000000  1.186370883531411
-0.583333333333333  0.250000000000000  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  0.083333333333333  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.083333333333333  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.250000000000000  1.186370883531411
-0.416666666666667  -0.416666666666667  -0.416666666666667  1.186370883531411
-0.416666666666667  -0.250000000000000  -0.583333333333333  1.186370883531411
-0.416666666666667  -0.083333333333333  -0.750000000000000  1.186370883531411
-0.416666666666667  0.083333333333333  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.250000000000000  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.250000000000000  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.250000000000000  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.250000000000000  -0.083333333333333  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.083333333333333  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.083333333333333  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.083333333333333  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.083333333333333  -0.250000000000000  -0.916666666666667  1.186370883531411
0.083333333333333  -0.916666666666667  -0.416666666666667  1.186370883531411
0.083333333333333  -0.750000000000000  -0.583333333333333  1.186370883531411
0.083333333333333  -0.583333333333333  -0.750000000000000  1.186370883531411
0.083333333333333  -0.416666666666667  -0.916666666666667  1.186370883531411
0.250000000000000  -0.916666666666667  -0.583333333333333  1.186370883531411
0.250000000000000  -0.750000000000000  -0.750000000000000  1.186370883531411
0.250000000000000  -0.583333333333333  -0.916666666666667  1.186370883531411
0.416666666666667  -0.916666666666667  -0.750000000000000  1.186370883531411
0.416666666666667  -0.750000000000000  -0.916666666666667  1.186370883531411
0.583333333333333  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  0.416666666666667  1.186370883531411
-0.916666666666667  -0.750000000000000  0.250000000000000  1.186370883531411
-0.916666666666667  -0.583333333333333  0.083333333333333  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.083333333333333  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.250000000000000  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.416666666666667  1.186370883531411
-0.916666666666667  0.083333333333333  -0.583333333333333  1.186370883531411
-0.916666666666667  0.250000000000000  -0.750000000000000  1.186370883531411
-0.916666666666667  0.416666666666667  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  0.250000000000000  1.186370883531411
-0.750000000000000  -0.750000000000000  0.083333333333333  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.083333333333333  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.250000000000000  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.416666666666667  1.186370883531411
-0.750000000000000  -0.083333333333333  -0.583333333333333  1.186370883531411
-0.750000000000000  0.083333333333333  -0.750000000000000  1.186370883531411
-0.750000000000000  0.250000000000000  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  0.083333333333333  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.083333333333333  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.250000000000000  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.416666666666667  1.186370883531411
-0.583333333333333  -0.250000000000000  -0.583333333333333  1.186370883531411
-0.583333333333333  -0.083333333333333  -0.750000000000000  1.186370883531411
-0.583333333333333  0.083333333333333  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.416666666666667  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.416666666666667  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.416666666666667  -0.083333333333333  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.250000000000000  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.250000000000000  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.250000000000000  -0.250000000000000  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.083333333333333  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.083333333333333  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.083333333333333  -0.416666666666667  -0.916666666666667  1.186370883531411
0.083333333333333  -0.916666666666667  -0.583333333333333  1.186370883531411
0.083333333333333  -0.750000000000000  -0.750000000000000  1.186370883531411
0.083333333333333  -0.583333333333333  -0.916666666666667  1.186370883531411
0.250000000000000  -0.916666666666667  -0.750000000000000  1.186370883531411
0.250000000000000  -0.750000000000000  -0.916666666666667  1.186370883531411
0.416666666666667  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  0.250000000000000  1.186370883531411
-0.916666666666667  -0.750000000000000  0.083333333333333  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.083333333333333  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.250000000000000  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.416666666666667  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.583333333333333  1.186370883531411
-0.916666666666667  0.083333333333333  -0.750000000000000  1.186370883531411
-0.916666666666667  0.250000000000000  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  0.083333333333333  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.083333333333333  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.250000000000000  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.416666666666667  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.583333333333333  1.186370883531411
-0.750000000000000  -0.083333333333333  -0.750000000000000  1.186370883531411
-0.750000000000000  0.083333333333333  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.583333333333333  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.583333333333333  -0.083333333333333  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.416666666666667  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.416666666666667  -0.250000000000000  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.250000000000000  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.250000000000000  -0.416666666666667  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.083333333333333  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.083333333333333  -0.583333333333333  -0.916666666666667  1.186370883531411
0.083333333333333  -0.916666666666667  -0.750000000000000  1.186370883531411
0.083333333333333  -0.750000000000000  -0.916666666666667  1.186370883531411
0.250000000000000  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  0.083333333333333  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.083333333333333  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.250000000000000  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.416666666666667  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.583333333333333  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.750000000000000  1.186370883531411
-0.916666666666667  0.083333333333333  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.750000000000000  -0.083333333333333  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.583333333333333  -0.250000000000000  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.416666666666667  -0.416666666666667  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.250000000000000  -0.583333333333333  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.083333333333333  -0.750000000000000  -0.916666666666667  1.186370883531411
0.083333333333333  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.083333333333333  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.250000000000000  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.416666666666667  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.583333333333333  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.750000000000000  1.186370883531411
-0.916666666666667  -0.083333333333333  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.750000000000000  -0.250000000000000  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.583333333333333  -0.416666666666667  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.416666666666667  -0.583333333333333  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.250000000000000  -0.750000000000000  -0.916666666666667  1.186370883531411
-0.083333333333333  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.250000000000000  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.416666666666667  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.583333333333333  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.750000000000000  1.186370883531411
-0.916666666666667  -0.250000000000000  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.750000000000000  -0.416666666666667  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.583333333333333  -0.583333333333333  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.416666666666667  -0.750000000000000  -0.916666666666667  1.186370883531411
-0.250000000000000  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.416666666666667  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.583333333333333  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.750000000000000  1.186370883531411
-0.916666666666667  -0.416666666666667  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.750000000000000  -0.583333333333333  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.583333333333333  -0.750000000000000  -0.916666666666667  1.186370883531411
-0.416666666666667  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.583333333333333  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.750000000000000  1.186370883531411
-0.916666666666667  -0.583333333333333  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.750000000000000  -0.750000000000000  -0.916666666666667  1.186370883531411
-0.583333333333333  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.750000000000000  1.186370883531411
-0.916666666666667  -0.750000000000000  -0.916666666666667  1.186370883531411
-0.750000000000000  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.916666666666667  -0.916666666666667  -0.916666666666667  1.186370883531411
-0.909090909090909  -0.909090909090909  0.727272727272727  -4.580068174334528
-0.909090909090909  -0.727272727272727  0.545454545454545  -4.580068174334528
-0.909090909090909  -0.545454545454545  0.363636363636364  -4.580068174334528
-0.909090909090909  -0.363636363636364  0.181818181818182  -4.580068174334528
-0.909090909090909  -0.181818181818182  0.000000000000000  -4.580068174334528
-0.909090909090909  0.000000000000000  -0.181818181818182  -4.580068174334528
-0.909090909090909  0.181818181818182  -0.363636363636364  -4.580068174334528
-0.909090909090909  0.363636363636364  -0.545454545454545  -4.580068174334528
-0.909090909090909  0.545454545454545  -0.727272727272727  -4.580068174334528
-0.909090909090909  0.727272727272727  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  0.545454545454545  -4.580068174334528
-0.727272727272727  -0.727272727272727  0.363636363636364  -4.580068174334528
-0.727272727272727  -0.545454545454545  0.181818181818182  -4.580068174334528
-0.727272727272727  -0.363636363636364  0.000000000000000  -4.580068174334528
-0.727272727272727  -0.181818181818182  -0.181818181818182  -4.580068174334528
-0.727272727272727  0.000000000000000  -0.363636363636364  -4.580068174334528
-0.727272727272727  0.181818181818182  -0.545454545454545  -4.580068174334528
-0.727272727272727  0.363636363636364  -0.727272727272727  -4.580068174334528
-0.727272727272727  0.545454545454545  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  0.363636363636364  -4.580068174334528
-0.545454545454545  -0.727272727272727  0.181818181818182  -4.580068174334528
-0.545454545454545  -0.545454545454545  0.000000000000000  -4.580068174334528
-0.545454545454545  -0.363636363636364  -0.181818181818182  -4.580068174334528
-0.545454545454545  -0.181818181818182  -0.363636363636364  -4.580068174334528
-0.545454545454545  0.000000000000000  -0.545454545454545  -4.580068174334528
-0.545454545454545  0.181818181818182  -0.727272727272727  -4.580068174334528
-0.545454545454545  0.363636363636364  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  0.181818181818182  -4.580068174334528
-0.363636363636364  -0.727272727272727  0.000000000000000  -4.580068174334528
-0.363636363636364  -0.545454545454545  -0.181818181818182  -4.580068174334528
-0.363636363636364  -0.363636363636364  -0.363636363636364  -4.580068174334528
-0.363636363636364  -0.181818181818182  -0.545454545454545  -4.580068174334528
-0.363636363636364  0.000000000000000  -0.727272727272727  -4.580068174334528
-0.363636363636364  0.181818181818182  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  0.000000000000000  -4.580068174334528
-0.181818181818182  -0.727272727272727  -0.181818181818182  -4.580068174334528
-0.181818181818182  -0.545454545454545  -0.363636363636364  -4.580068174334528
-0.181818181818182  -0.363636363636364  -0.545454545454545  -4.580068174334528
-0.181818181818182  -0.181818181818182  -0.727272727272727  -4.580068174334528
-0.181818181818182  0.000000000000000  -0.909090909090909  -4.580068174334528
0.000000000000000  -0.909090909090909  -0.181818181818182  -4.580068174334528
0.000000000000000  -0.727272727272727  -0.363636363636364  -4.580068174334528
0.000000000000000  -0.545454545454545  -0.545454545454545  -4.580068174334528
0.000000000000000  -0.363636363636364  -0.727272727272727  -4.580068174334528
0.000000000000000  -0.181818181818182  -0.909090909090909  -4.580068174334528
0.181818181818182  -0.909090909090909  -0.363636363636364  -4.580068174334528
0.181818181818182  -0.727272727272727  -0.545454545454545  -4.580068174334528
0.181818181818182  -0.545454545454545  -0.727272727272727  -4.580068174334528
0.181818181818182  -0.363636363636364  -0.909090909090909  -4.580068174334528
0.363636363636364  -0.909090909090909  -0.545454545454545  -4.580068174334528
0.363636363636364  -0.727272727272727  -0.727272727272727  -4.580068174334528
0.363636363636364  -0.545454545454545  -0.909090909090909  -4.580068174334528
0.545454545454545  -0.909090909090909  -0.727272727272727  -4.580068174334528
0.545454545454545  -0.727272727272727  -0.909090909090909  -4.580068174334528
0.727272727272727  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  0.545454545454545  -4.580068174334528
-0.909090909090909  -0.727272727272727  0.363636363636364  -4.580068174334528
-0.909090909090909  -0.545454545454545  0.181818181818182  -4.580068174334528
-0.909090909090909  -0.363636363636364  0.000000000000000  -4.580068174334528
-0.909090909090909  -0.181818181818182  -0.181818181818182  -4.580068174334528
-0.909090909090909  0.000000000000000  -0.363636363636364  -4.580068174334528
-0.909090909090909  0.181818181818182  -0.545454545454545  -4.580068174334528
-0.909090909090909  0.363636363636364  -0.727272727272727  -4.580068174334528
-0.909090909090909  0.545454545454545  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  0.363636363636364  -4.580068174334528
-0.727272727272727  -0.727272727272727  0.181818181818182  -4.580068174334528
-0.727272727272727  -0.545454545454545  0.000000000000000  -4.580068174334528
-0.727272727272727  -0.363636363636364  -0.181818181818182  -4.580068174334528
-0.727272727272727  -0.181818181818182  -0.363636363636364  -4.580068174334528
-0.727272727272727  0.000000000000000  -0.545454545454545  -4.580068174334528
-0.727272727272727  0.181818181818182  -0.727272727272727  -4.580068174334528
-0.727272727272727  0.363636363636364  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  0.181818181818182  -4.580068174334528
-0.545454545454545  -0.727272727272727  0.000000000000000  -4.580068174334528
-0.545454545454545  -0.545454545454545  -0.181818181818182  -4.580068174334528
-0.545454545454545  -0.363636363636364  -0.363636363636364  -4.580068174334528
-0.545454545454545  -0.181818181818182  -0.545454545454545  -4.580068174334528
-0.545454545454545  0.000000000000000  -0.727272727272727  -4.580068174334528
-0.545454545454545  0.181818181818182  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  0.000000000000000  -4.580068174334528
-0.363636363636364  -0.727272727272727  -0.181818181818182  -4.580068174334528
-0.363636363636364  -0.545454545454545  -0.363636363636364  -4.580068174334528
-0.363636363636364  -0.363636363636364  -0.545454545454545  -4.580068174334528
-0.363636363636364  -0.181818181818182  -0.727272727272727  -4.580068174334528
-0.363636363636364  0.000000000000000  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  -0.181818181818182  -4.580068174334528
-0.181818181818182  -0.727272727272727  -0.363636363636364  -4.580068174334528
-0.181818181818182  -0.545454545454545  -0.545454545454545  -4.580068174334528
-0.181818181818182  -0.363636363636364  -0.727272727272727  -4.580068174334528
-0.181818181818182  -0.181818181818182  -0.909090909090909  -4.580068174334528
0.000000000000000  -0.909090909090909  -0.363636363636364  -4.580068174334528
0.000000000000000  -0.727272727272727  -0.545454545454545  -4.580068174334528
0.000000000000000  -0.545454545454545  -0.727272727272727  -4.580068174334528
0.000000000000000  -0.363636363636364  -0.909090909090909  -4.580068174334528
0.181818181818182  -0.909090909090909  -0.545454545454545  -4.580068174334528
0.181818181818182  -0.727272727272727  -0.727272727272727  -4.580068174334528
0.181818181818182  -0.545454545454545  -0.909090909090909  -4.580068174334528
0.363636363636364  -0.909090909090909  -0.727272727272727  -4.580068174334528
0.363636363636364  -0.727272727272727  -0.909090909090909  -4.580068174334528
0.545454545454545  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  0.363636363636364  -4.580068174334528
-0.909090909090909  -0.727272727272727  0.181818181818182  -4.580068174334528
-0.909090909090909  -0.545454545454545  0.000000000000000  -4.580068174334528
-0.909090909090909  -0.363636363636364  -0.181818181818182  -4.580068174334528
-0.909090909090909  -0.181818181818182  -0.363636363636364  -4.580068174334528
-0.909090909090909  0.000000000000000  -0.545454545454545  -4.580068174334528
-0.909090909090909  0.181818181818182  -0.727272727272727  -4.580068174334528
-0.909090909090909  0.363636363636364  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  0.181818181818182  -4.580068174334528
-0.727272727272727  -0.727272727272727  0.000000000000000  -4.580068174334528
-0.727272727272727  -0.545454545454545  -0.181818181818182  -4.580068174334528
-0.727272727272727  -0.363636363636364  -0.363636363636364  -4.580068174334528
-0.727272727272727  -0.181818181818182  -0.545454545454545  -4.580068174334528
-0.727272727272727  0.000000000000000  -0.727272727272727  -4.580068174334528
-0.727272727272727  0.181818181818182  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  0.000000000000000  -4.580068174334528
-0.545454545454545  -0.727272727272727  -0.181818181818182  -4.580068174334528
-0.545454545454545  -0.545454545454545  -0.363636363636364  -4.580068174334528
-0.545454545454545  -0.363636363636364  -0.545454545454545  -4.580068174334528
-0.545454545454545  -0.181818181818182  -0.727272727272727  -4.580068174334528
-0.545454545454545  0.000000000000000  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  -0.181818181818182  -4.580068174334528
-0.363636363636364  -0.727272727272727  -0.363636363636364  -4.580068174334528
-0.363636363636364  -0.545454545454545  -0.545454545454545  -4.580068174334528
-0.363636363636364  -0.363636363636364  -0.727272727272727  -4.580068174334528
-0.363636363636364  -0.181818181818182  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  -0.363636363636364  -4.580068174334528
-0.181818181818182  -0.727272727272727  -0.545454545454545  -4.580068174334528
-0.181818181818182  -0.545454545454545  -0.727272727272727  -4.580068174334528
-0.181818181818182  -0.363636363636364  -0.909090909090909  -4.580068174334528
0.000000000000000  -0.909090909090909  -0.545454545454545  -4.580068174334528
0.000000000000000  -0.727272727272727  -0.727272727272727  -4.580068174334528
0.000000000000000  -0.545454545454545  -0.909090909090909  -4.580068174334528
0.181818181818182  -0.909090909090909  -0.727272727272727  -4.580068174334528
0.181818181818182  -0.727272727272727  -0.909090909090909  -4.580068174334528
0.363636363636364  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  0.181818181818182  -4.580068174334528
-0.909090909090909  -0.727272727272727  0.000000000000000  -4.580068174334528
-0.909090909090909  -0.545454545454545  -0.181818181818182  -4.580068174334528
-0.909090909090909  -0.363636363636364  -0.363636363636364  -4.580068174334528
-0.909090909090909  -0.181818181818182  -0.545454545454545  -4.580068174334528
-0.909090909090909  0.000000000000000  -0.727272727272727  -4.580068174334528
-0.909090909090909  0.181818181818182  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  0.000000000000000  -4.580068174334528
-0.727272727272727  -0.727272727272727  -0.181818181818182  -4.580068174334528
-0.727272727272727  -0.545454545454545  -0.363636363636364  -4.580068174334528
-0.727272727272727  -0.363636363636364  -0.545454545454545  -4.580068174334528
-0.727272727272727  -0.181818181818182  -0.727272727272727  -4.580068174334528
-0.727272727272727  0.000000000000000  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  -0.181818181818182  -4.580068174334528
-0.545454545454545  -0.727272727272727  -0.363636363636364  -4.580068174334528
-0.545454545454545  -0.545454545454545  -0.545454545454545  -4.580068174334528
-0.545454545454545  -0.363636363636364  -0.727272727272727  -4.580068174334528
-0.545454545454545  -0.181818181818182  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  -0.363636363636364  -4.580068174334528
-0.363636363636364  -0.727272727272727  -0.545454545454545  -4.580068174334528
-0.363636363636364  -0.545454545454545  -0.727272727272727  -4.580068174334528
-0.363636363636364  -0.363636363636364  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  -0.545454545454545  -4.580068174334528
-0.181818181818182  -0.727272727272727  -0.727272727272727  -4.580068174334528
-0.181818181818182  -0.545454545454545  -0.909090909090909  -4.580068174334528
0.000000000000000  -0.909090909090909  -0.727272727272727  -4.580068174334528
0.000000000000000  -0.727272727272727  -0.909090909090909  -4.580068174334528
0.181818181818182  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  0.000000000000000  -4.580068174334528
-0.909090909090909  -0.727272727272727  -0.181818181818182  -4.580068174334528
-0.909090909090909  -0.545454545454545  -0.363636363636364  -4.580068174334528
-0.909090909090909  -0.363636363636364  -0.545454545454545  -4.580068174334528
-0.909090909090909  -0.181818181818182  -0.727272727272727  -4.580068174334528
-0.909090909090909  0.000000000000000  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  -0.181818181818182  -4.580068174334528
-0.727272727272727  -0.727272727272727  -0.363636363636364  -4.580068174334528
-0.727272727272727  -0.545454545454545  -0.545454545454545  -4.580068174334528
-0.727272727272727  -0.363636363636364  -0.727272727272727  -4.580068174334528
-0.727272727272727  -0.181818181818182  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  -0.363636363636364  -4.580068174334528
-0.545454545454545  -0.727272727272727  -0.545454545454545  -4.580068174334528
-0.545454545454545  -0.545454545454545  -0.727272727272727  -4.580068174334528
-0.545454545454545  -0.363636363636364  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  -0.545454545454545  -4.580068174334528
-0.363636363636364  -0.727272727272727  -0.727272727272727  -4.580068174334528
-0.363636363636364  -0.545454545454545  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  -0.727272727272727  -4.580068174334528
-0.181818181818182  -0.727272727272727  -0.909090909090909  -4.580068174334528
0.000000000000000  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  -0.181818181818182  -4.580068174334528
-0.909090909090909  -0.727272727272727  -0.363636363636364  -4.580068174334528
-0.909090909090909  -0.545454545454545  -0.545454545454545  -4.580068174334528
-0.909090909090909  -0.363636363636364  -0.727272727272727  -4.580068174334528
-0.909090909090909  -0.181818181818182  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  -0.363636363636364  -4.580068174334528
-0.727272727272727  -0.727272727272727  -0.545454545454545  -4.580068174334528
-0.727272727272727  -0.545454545454545  -0.727272727272727  -4.580068174334528
-0.727272727272727  -0.363636363636364  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  -0.545454545454545  -4.580068174334528
-0.545454545454545  -0.727272727272727  -0.727272727272727  -4.580068174334528
-0.545454545454545  -0.545454545454545  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  -0.727272727272727  -4.580068174334528
-0.363636363636364  -0.727272727272727  -0.909090909090909  -4.580068174334528
-0.181818181818182  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  -0.363636363636364  -4.580068174334528
-0.909090909090909  -0.727272727272727  -0.545454545454545  -4.580068174334528
-0.909090909090909  -0.545454545454545  -0.727272727272727  -4.580068174334528
-0.909090909090909  -0.363636363636364  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  -0.545454545454545  -4.580068174334528
-0.727272727272727  -0.727272727272727  -0.727272727272727  -4.580068174334528
-0.727272727272727  -0.545454545454545  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  -0.727272727272727  -4.580068174334528
-0.545454545454545  -0.727272727272727  -0.909090909090909  -4.580068174334528
-0.363636363636364  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  -0.545454545454545  -4.580068174334528
-0.909090909090909  -0.727272727272727  -0.727272727272727  -4.580068174334528
-0.909090909090909  -0.545454545454545  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  -0.727272727272727  -4.580068174334528
-0.727272727272727  -0.727272727272727  -0.909090909090909  -4.580068174334528
-0.545454545454545  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  -0.727272727272727  -4.580068174334528
-0.909090909090909  -0.727272727272727  -0.909090909090909  -4.580068174334528
-0.727272727272727  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.909090909090909  -0.909090909090909  -0.909090909090909  -4.580068174334528
-0.900000000000000  -0.900000000000000  0.700000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  0.500000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  0.300000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  0.100000000000000  7.117433113960459
-0.900000000000000  -0.100000000000000  -0.100000000000000  7.117433113960459
-0.900000000000000  0.100000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  0.300000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  0.500000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  0.700000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  0.500000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  0.300000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  0.100000000000000  7.117433113960459
-0.700000000000000  -0.300000000000000  -0.100000000000000  7.117433113960459
-0.700000000000000  -0.100000000000000  -0.300000000000000  7.117433113960459
-0.700000000000000  0.100000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  0.300000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  0.500000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  0.300000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  0.100000000000000  7.117433113960459
-0.500000000000000  -0.500000000000000  -0.100000000000000  7.117433113960459
-0.500000000000000  -0.300000000000000  -0.300000000000000  7.117433113960459
-0.500000000000000  -0.100000000000000  -0.500000000000000  7.117433113960459
-0.500000000000000  0.100000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  0.300000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  0.100000000000000  7.117433113960459
-0.300000000000000  -0.700000000000000  -0.100000000000000  7.117433113960459
-0.300000000000000  -0.500000000000000  -0.300000000000000  7.117433113960459
-0.300000000000000  -0.300000000000000  -0.500000000000000  7.117433113960459
-0.300000000000000  -0.100000000000000  -0.700000000000000  7.117433113960459
-0.300000000000000  0.100000000000000  -0.900000000000000  7.117433113960459
-0.100000000000000  -0.900000000000000  -0.100000000000000  7.117433113960459
-0.100000000000000  -0.700000000000000  -0.300000000000000  7.117433113960459
-0.100000000000000  -0.500000000000000  -0.500000000000000  7.117433113960459
-0.100000000000000  -0.300000000000000  -0.700000000000000  7.117433113960459
-0.100000000000000  -0.100000000000000  -0.900000000000000  7.117433113960459
0.100000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
0.100000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
0.100000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
0.100000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
0.300000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
0.300000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
0.300000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
0.500000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
0.500000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
0.700000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  0.500000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  0.300000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  0.100000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  -0.100000000000000  7.117433113960459
-0.900000000000000  -0.100000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  0.100000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  0.300000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  0.500000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  0.300000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  0.100000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  -0.100000000000000  7.117433113960459
-0.700000000000000  -0.300000000000000  -0.300000000000000  7.117433113960459
-0.700000000000000  -0.100000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  0.100000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  0.300000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  0.100000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  -0.100000000000000  7.117433113960459
-0.500000000000000  -0.500000000000000  -0.300000000000000  7.117433113960459
-0.500000000000000  -0.300000000000000  -0.500000000000000  7.117433113960459
-0.500000000000000  -0.100000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  0.100000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  -0.100000000000000  7.117433113960459
-0.300000000000000  -0.700000000000000  -0.300000000000000  7.117433113960459
-0.300000000000000  -0.500000000000000  -0.500000000000000  7.117433113960459
-0.300000000000000  -0.300000000000000  -0.700000000000000  7.117433113960459
-0.300000000000000  -0.100000000000000  -0.900000000000000  7.117433113960459
-0.100000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
-0.100000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
-0.100000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
-0.100000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
0.100000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
0.100000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
0.100000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
0.300000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
0.300000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
0.500000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  0.300000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  0.100000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  -0.100000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  -0.100000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  0.100000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  0.300000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  0.100000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  -0.100000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  -0.300000000000000  7.117433113960459
-0.700000000000000  -0.300000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  -0.100000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  0.100000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  -0.100000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  -0.300000000000000  7.117433113960459
-0.500000000000000  -0.500000000000000  -0.500000000000000  7.117433113960459
-0.500000000000000  -0.300000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  -0.100000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
-0.300000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
-0.300000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
-0.300000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
-0.100000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
-0.100000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
-0.100000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
0.100000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
0.100000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
0.300000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  0.100000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  -0.100000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  -0.100000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  0.100000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  -0.100000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  -0.300000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  -0.300000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  -0.100000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
-0.500000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
-0.300000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
-0.300000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
-0.100000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
-0.100000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
0.100000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  -0.100000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  -0.100000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
-0.300000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
-0.100000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  -0.300000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  -0.300000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
-0.500000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
-0.300000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  -0.500000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  -0.500000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
-0.700000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
-0.500000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  -0.700000000000000  7.117433113960459
-0.900000000000000  -0.700000000000000  -0.900000000000000  7.117433113960459
-0.700000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.900000000000000  -0.900000000000000  -0.900000000000000  7.117433113960459
-0.888888888888889  -0.888888888888889  0.666666666666667  -5.711070467965174
-0.888888888888889  -0.666666666666667  0.444444444444444  -5.711070467965174
-0.888888888888889  -0.444444444444444  0.222222222222222  -5.711070467965174
-0.888888888888889  -0.222222222222222  0.000000000000000  -5.711070467965174
-0.888888888888889  0.000000000000000  -0.222222222222222  -5.711070467965174
-0.888888888888889  0.222222222222222  -0.444444444444444  -5.711070467965174
-0.888888888888889  0.444444444444444  -0.666666666666667  -5.711070467965174
-0.888888888888889  0.666666666666667  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  0.444444444444444  -5.711070467965174
-0.666666666666667  -0.666666666666667  0.222222222222222  -5.711070467965174
-0.666666666666667  -0.444444444444444  0.000000000000000  -5.711070467965174
-0.666666666666667  -0.222222222222222  -0.222222222222222  -5.711070467965174
-0.666666666666667  0.000000000000000  -0.444444444444444  -5.711070467965174
-0.666666666666667  0.222222222222222  -0.666666666666667  -5.711070467965174
-0.666666666666667  0.444444444444444  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  0.222222222222222  -5.711070467965174
-0.444444444444444  -0.666666666666667  0.000000000000000  -5.711070467965174
-0.444444444444444  -0.444444444444444  -0.222222222222222  -5.711070467965174
-0.444444444444444  -0.222222222222222  -0.444444444444444  -5.711070467965174
-0.444444444444444  0.000000000000000  -0.666666666666667  -5.711070467965174
-0.444444444444444  0.222222222222222  -0.888888888888889  -5.711070467965174
-0.222222222222222  -0.888888888888889  0.000000000000000  -5.711070467965174
-0.222222222222222  -0.666666666666667  -0.222222222222222  -5.711070467965174
-0.222222222222222  -0.444444444444444  -0.444444444444444  -5.711070467965174
-0.222222222222222  -0.222222222222222  -0.666666666666667  -5.711070467965174
-0.222222222222222  0.000000000000000  -0.888888888888889  -5.711070467965174
0.000000000000000  -0.888888888888889  -0.222222222222222  -5.711070467965174
0.000000000000000  -0.666666666666667  -0.444444444444444  -5.711070467965174
0.000000000000000  -0.444444444444444  -0.666666666666667  -5.711070467965174
0.000000000000000  -0.222222222222222  -0.888888888888889  -5.711070467965174
0.222222222222222  -0.888888888888889  -0.444444444444444  -5.711070467965174
0.222222222222222  -0.666666666666667  -0.666666666666667  -5.711070467965174
0.222222222222222  -0.444444444444444  -0.888888888888889  -5.711070467965174
0.444444444444444  -0.888888888888889  -0.666666666666667  -5.711070467965174
0.444444444444444  -0.666666666666667  -0.888888888888889  -5.711070467965174
0.666666666666667  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  0.444444444444444  -5.711070467965174
-0.888888888888889  -0.666666666666667  0.222222222222222  -5.711070467965174
-0.888888888888889  -0.444444444444444  0.000000000000000  -5.711070467965174
-0.888888888888889  -0.222222222222222  -0.222222222222222  -5.711070467965174
-0.888888888888889  0.000000000000000  -0.444444444444444  -5.711070467965174
-0.888888888888889  0.222222222222222  -0.666666666666667  -5.711070467965174
-0.888888888888889  0.444444444444444  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  0.222222222222222  -5.711070467965174
-0.666666666666667  -0.666666666666667  0.000000000000000  -5.711070467965174
-0.666666666666667  -0.444444444444444  -0.222222222222222  -5.711070467965174
-0.666666666666667  -0.222222222222222  -0.444444444444444  -5.711070467965174
-0.666666666666667  0.000000000000000  -0.666666666666667  -5.711070467965174
-0.666666666666667  0.222222222222222  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  0.000000000000000  -5.711070467965174
-0.444444444444444  -0.666666666666667  -0.222222222222222  -5.711070467965174
-0.444444444444444  -0.444444444444444  -0.444444444444444  -5.711070467965174
-0.444444444444444  -0.222222222222222  -0.666666666666667  -5.711070467965174
-0.444444444444444  0.000000000000000  -0.888888888888889  -5.711070467965174
-0.222222222222222  -0.888888888888889  -0.222222222222222  -5.711070467965174
-0.222222222222222  -0.666666666666667  -0.444444444444444  -5.711070467965174
-0.222222222222222  -0.444444444444444  -0.666666666666667  -5.711070467965174
-0.222222222222222  -0.222222222222222  -0.888888888888889  -5.711070467965174
0.000000000000000  -0.888888888888889  -0.444444444444444  -5.711070467965174
0.000000000000000  -0.666666666666667  -0.666666666666667  -5.711070467965174
0.000000000000000  -0.444444444444444  -0.888888888888889  -5.711070467965174
0.222222222222222  -0.888888888888889  -0.666666666666667  -5.711070467965174
0.222222222222222  -0.666666666666667  -0.888888888888889  -5.711070467965174
0.444444444444444  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  0.222222222222222  -5.711070467965174
-0.888888888888889  -0.666666666666667  0.000000000000000  -5.711070467965174
-0.888888888888889  -0.444444444444444  -0.222222222222222  -5.711070467965174
-0.888888888888889  -0.222222222222222  -0.444444444444444  -5.711070467965174
-0.888888888888889  0.000000000000000  -0.666666666666667  -5.711070467965174
-0.888888888888889  0.222222222222222  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  0.000000000000000  -5.711070467965174
-0.666666666666667  -0.666666666666667  -0.222222222222222  -5.711070467965174
-0.666666666666667  -0.444444444444444  -0.444444444444444  -5.711070467965174
-0.666666666666667  -0.222222222222222  -0.666666666666667  -5.711070467965174
-0.666666666666667  0.000000000000000  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  -0.222222222222222  -5.711070467965174
-0.444444444444444  -0.666666666666667  -0.444444444444444  -5.711070467965174
-0.444444444444444  -0.444444444444444  -0.666666666666667  -5.711070467965174
-0.444444444444444  -0.222222222222222  -0.888888888888889  -5.711070467965174
-0.222222222222222  -0.888888888888889  -0.444444444444444  -5.711070467965174
-0.222222222222222  -0.666666666666667  -0.666666666666667  -5.711070467965174
-0.222222222222222  -0.444444444444444  -0.888888888888889  -5.711070467965174
0.000000000000000  -0.888888888888889  -0.666666666666667  -5.711070467965174
0.000000000000000  -0.666666666666667  -0.888888888888889  -5.711070467965174
0.222222222222222  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  0.000000000000000  -5.711070467965174
-0.888888888888889  -0.666666666666667  -0.222222222222222  -5.711070467965174
-0.888888888888889  -0.444444444444444  -0.444444444444444  -5.711070467965174
-0.888888888888889  -0.222222222222222  -0.666666666666667  -5.711070467965174
-0.888888888888889  0.000000000000000  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  -0.222222222222222  -5.711070467965174
-0.666666666666667  -0.666666666666667  -0.444444444444444  -5.711070467965174
-0.666666666666667  -0.444444444444444  -0.666666666666667  -5.711070467965174
-0.666666666666667  -0.222222222222222  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  -0.444444444444444  -5.711070467965174
-0.444444444444444  -0.666666666666667  -0.666666666666667  -5.711070467965174
-0.444444444444444  -0.444444444444444  -0.888888888888889  -5.711070467965174
-0.222222222222222  -0.888888888888889  -0.666666666666667  -5.711070467965174
-0.222222222222222  -0.666666666666667  -0.888888888888889  -5.711070467965174
0.000000000000000  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  -0.222222222222222  -5.711070467965174
-0.888888888888889  -0.666666666666667  -0.444444444444444  -5.711070467965174
-0.888888888888889  -0.444444444444444  -0.666666666666667  -5.711070467965174
-0.888888888888889  -0.222222222222222  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  -0.444444444444444  -5.711070467965174
-0.666666666666667  -0.666666666666667  -0.666666666666667  -5.711070467965174
-0.666666666666667  -0.444444444444444  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  -0.666666666666667  -5.711070467965174
-0.444444444444444  -0.666666666666667  -0.888888888888889  -5.711070467965174
-0.222222222222222  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  -0.444444444444444  -5.711070467965174
-0.888888888888889  -0.666666666666667  -0.666666666666667  -5.711070467965174
-0.888888888888889  -0.444444444444444  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  -0.666666666666667  -5.711070467965174
-0.666666666666667  -0.666666666666667  -0.888888888888889  -5.711070467965174
-0.444444444444444  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  -0.666666666666667  -5.711070467965174
-0.888888888888889  -0.666666666666667  -0.888888888888889  -5.711070467965174
-0.666666666666667  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.888888888888889  -0.888888888888889  -0.888888888888889  -5.711070467965174
-0.875000000000000  -0.875000000000000  0.625000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  0.375000000000000  2.527399241963254
-0.875000000000000  -0.375000000000000  0.125000000000000  2.527399241963254
-0.875000000000000  -0.125000000000000  -0.125000000000000  2.527399241963254
-0.875000000000000  0.125000000000000  -0.375000000000000  2.527399241963254
-0.875000000000000  0.375000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  0.625000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  0.375000000000000  2.527399241963254
-0.625000000000000  -0.625000000000000  0.125000000000000  2.527399241963254
-0.625000000000000  -0.375000000000000  -0.125000000000000  2.527399241963254
-0.625000000000000  -0.125000000000000  -0.375000000000000  2.527399241963254
-0.625000000000000  0.125000000000000  -0.625000000000000  2.527399241963254
-0.625000000000000  0.375000000000000  -0.875000000000000  2.527399241963254
-0.375000000000000  -0.875000000000000  0.125000000000000  2.527399241963254
-0.375000000000000  -0.625000000000000  -0.125000000000000  2.527399241963254
-0.375000000000000  -0.375000000000000  -0.375000000000000  2.527399241963254
-0.375000000000000  -0.125000000000000  -0.625000000000000  2.527399241963254
-0.375000000000000  0.125000000000000  -0.875000000000000  2.527399241963254
-0.125000000000000  -0.875000000000000  -0.125000000000000  2.527399241963254
-0.125000000000000  -0.625000000000000  -0.375000000000000  2.527399241963254
-0.125000000000000  -0.375000000000000  -0.625000000000000  2.527399241963254
-0.125000000000000  -0.125000000000000  -0.875000000000000  2.527399241963254
0.125000000000000  -0.875000000000000  -0.375000000000000  2.527399241963254
0.125000000000000  -0.625000000000000  -0.625000000000000  2.527399241963254
0.125000000000000  -0.375000000000000  -0.875000000000000  2.527399241963254
0.375000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
0.375000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
0.625000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  0.375000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  0.125000000000000  2.527399241963254
-0.875000000000000  -0.375000000000000  -0.125000000000000  2.527399241963254
-0.875000000000000  -0.125000000000000  -0.375000000000000  2.527399241963254
-0.875000000000000  0.125000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  0.375000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  0.125000000000000  2.527399241963254
-0.625000000000000  -0.625000000000000  -0.125000000000000  2.527399241963254
-0.625000000000000  -0.375000000000000  -0.375000000000000  2.527399241963254
-0.625000000000000  -0.125000000000000  -0.625000000000000  2.527399241963254
-0.625000000000000  0.125000000000000  -0.875000000000000  2.527399241963254
-0.375000000000000  -0.875000000000000  -0.125000000000000  2.527399241963254
-0.375000000000000  -0.625000000000000  -0.375000000000000  2.527399241963254
-0.375000000000000  -0.375000000000000  -0.625000000000000  2.527399241963254
-0.375000000000000  -0.125000000000000  -0.875000000000000  2.527399241963254
-0.125000000000000  -0.875000000000000  -0.375000000000000  2.527399241963254
-0.125000000000000  -0.625000000000000  -0.625000000000000  2.527399241963254
-0.125000000000000  -0.375000000000000  -0.875000000000000  2.527399241963254
0.125000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
0.125000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
0.375000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  0.125000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  -0.125000000000000  2.527399241963254
-0.875000000000000  -0.375000000000000  -0.375000000000000  2.527399241963254
-0.875000000000000  -0.125000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  0.125000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  -0.125000000000000  2.527399241963254
-0.625000000000000  -0.625000000000000  -0.375000000000000  2.527399241963254
-0.625000000000000  -0.375000000000000  -0.625000000000000  2.527399241963254
-0.625000000000000  -0.125000000000000  -0.875000000000000  2.527399241963254
-0.375000000000000  -0.875000000000000  -0.375000000000000  2.527399241963254
-0.375000000000000  -0.625000000000000  -0.625000000000000  2.527399241963254
-0.375000000000000  -0.375000000000000  -0.875000000000000  2.527399241963254
-0.125000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
-0.125000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
0.125000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  -0.125000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  -0.375000000000000  2.527399241963254
-0.875000000000000  -0.375000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  -0.125000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  -0.375000000000000  2.527399241963254
-0.625000000000000  -0.625000000000000  -0.625000000000000  2.527399241963254
-0.625000000000000  -0.375000000000000  -0.875000000000000  2.527399241963254
-0.375000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
-0.375000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
-0.125000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  -0.375000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  -0.375000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
-0.625000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
-0.375000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  -0.625000000000000  2.527399241963254
-0.875000000000000  -0.625000000000000  -0.875000000000000  2.527399241963254
-0.625000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.875000000000000  -0.875000000000000  -0.875000000000000  2.527399241963254
-0.857142857142857  -0.857142857142857  0.571428571428571  -0.612213575618572
-0.857142857142857  -0.571428571428571  0.285714285714286  -0.612213575618572
-0.857142857142857  -0.285714285714286  0.000000000000000  -0.612213575618572
-0.857142857142857  0.000000000000000  -0.285714285714286  -0.612213575618572
-0.857142857142857  0.285714285714286  -0.571428571428571  -0.612213575618572
-0.857142857142857  0.571428571428571  -0.857142857142857  -0.612213575618572
-0.571428571428571  -0.857142857142857  0.285714285714286  -0.612213575618572
-0.571428571428571  -0.571428571428571  0.000000000000000  -0.612213575618572
-0.571428571428571  -0.285714285714286  -0.285714285714286  -0.612213575618572
-0.571428571428571  0.000000000000000  -0.571428571428571  -0.612213575618572
-0.571428571428571  0.285714285714286  -0.857142857142857  -0.612213575618572
-0.285714285714286  -0.857142857142857  0.000000000000000  -0.612213575618572
-0.285714285714286  -0.571428571428571  -0.285714285714286  -0.612213575618572
-0.285714285714286  -0.285714285714286  -0.571428571428571  -0.612213575618572
-0.285714285714286  0.000000000000000  -0.857142857142857  -0.612213575618572
0.000000000000000  -0.857142857142857  -0.285714285714286  -0.612213575618572
0.000000000000000  -0.571428571428571  -0.571428571428571  -0.612213575618572
0.000000000000000  -0.285714285714286  -0.857142857142857  -0.612213575618572
0.285714285714286  -0.857142857142857  -0.571428571428571  -0.612213575618572
0.285714285714286  -0.571428571428571  -0.857142857142857  -0.612213575618572
0.571428571428571  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.857142857142857  -0.857142857142857  0.285714285714286  -0.612213575618572
-0.857142857142857  -0.571428571428571  0.000000000000000  -0.612213575618572
-0.857142857142857  -0.285714285714286  -0.285714285714286  -0.612213575618572
-0.857142857142857  0.000000000000000  -0.571428571428571  -0.612213575618572
-0.857142857142857  0.285714285714286  -0.857142857142857  -0.612213575618572
-0.571428571428571  -0.857142857142857  0.000000000000000  -0.612213575618572
-0.571428571428571  -0.571428571428571  -0.285714285714286  -0.612213575618572
-0.571428571428571  -0.285714285714286  -0.571428571428571  -0.612213575618572
-0.571428571428571  0.000000000000000  -0.857142857142857  -0.612213575618572
-0.285714285714286  -0.857142857142857  -0.285714285714286  -0.612213575618572
-0.285714285714286  -0.571428571428571  -0.571428571428571  -0.612213575618572
-0.285714285714286  -0.285714285714286  -0.857142857142857  -0.612213575618572
0.000000000000000  -0.857142857142857  -0.571428571428571  -0.612213575618572
0.000000000000000  -0.571428571428571  -0.857142857142857  -0.612213575618572
0.285714285714286  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.857142857142857  -0.857142857142857  0.000000000000000  -0.612213575618572
-0.857142857142857  -0.571428571428571  -0.285714285714286  -0.612213575618572
-0.857142857142857  -0.285714285714286  -0.571428571428571  -0.612213575618572
-0.857142857142857  0.000000000000000  -0.857142857142857  -0.612213575618572
-0.571428571428571  -0.857142857142857  -0.285714285714286  -0.612213575618572
-0.571428571428571  -0.571428571428571  -0.571428571428571  -0.612213575618572
-0.571428571428571  -0.285714285714286  -0.857142857142857  -0.612213575618572
-0.285714285714286  -0.857142857142857  -0.571428571428571  -0.612213575618572
-0.285714285714286  -0.571428571428571  -0.857142857142857  -0.612213575618572
0.000000000000000  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.857142857142857  -0.857142857142857  -0.285714285714286  -0.612213575618572
-0.857142857142857  -0.571428571428571  -0.571428571428571  -0.612213575618572
-0.857142857142857  -0.285714285714286  -0.857142857142857  -0.612213575618572
-0.571428571428571  -0.857142857142857  -0.571428571428571  -0.612213575618572
-0.571428571428571  -0.571428571428571  -0.857142857142857  -0.612213575618572
-0.285714285714286  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.857142857142857  -0.857142857142857  -0.571428571428571  -0.612213575618572
-0.857142857142857  -0.571428571428571  -0.857142857142857  -0.612213575618572
-0.571428571428571  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.857142857142857  -0.857142857142857  -0.857142857142857  -0.612213575618572
-0.833333333333333  -0.833333333333333  0.500000000000000  0.076141727180383
-0.833333333333333  -0.500000000000000  0.166666666666667  0.076141727180383
-0.833333333333333  -0.166666666666667  -0.166666666666667  0.076141727180383
-0.833333333333333  0.166666666666667  -0.500000000000000  0.076141727180383
-0.833333333333333  0.500000000000000  -0.833333333333333  0.076141727180383
-0.500000000000000  -0.833333333333333  0.166666666666667  0.076141727180383
-0.500000000000000  -0.500000000000000  -0.166666666666667  0.076141727180383
-0.500000000000000  -0.166666666666667  -0.500000000000000  0.076141727180383
-0.500000000000000  0.166666666666667  -0.833333333333333  0.076141727180383
-0.166666666666667  -0.833333333333333  -0.166666666666667  0.076141727180383
-0.166666666666667  -0.500000000000000  -0.500000000000000  0.076141727180383
-0.166666666666667  -0.166666666666667  -0.833333333333333  0.076141727180383
0.166666666666667  -0.833333333333333  -0.500000000000000  0.076141727180383
0.166666666666667  -0.500000000000000  -0.833333333333333  0.076141727180383
0.500000000000000  -0.833333333333333  -0.833333333333333  0.076141727180383
-0.833333333333333  -0.833333333333333  0.166666666666667  0.076141727180383
-0.833333333333333  -0.500000000000000  -0.166666666666667  0.076141727180383
-0.833333333333333  -0.166666666666667  -0.500000000000000  0.076141727180383
-0.833333333333333  0.166666666666667  -0.833333333333333  0.076141727180383
-0.500000000000000  -0.833333333333333  -0.166666666666667  0.076141727180383
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.076141727180383
-0.500000000000000  -0.166666666666667  -0.833333333333333  0.076141727180383
-0.166666666666667  -0.833333333333333  -0.500000000000000  0.076141727180383
-0.166666666666667  -0.500000000000000  -0.833333333333333  0.076141727180383
0.166666666666667  -0.833333333333333  -0.833333333333333  0.076141727180383
-0.833333333333333  -0.833333333333333  -0.166666666666667  0.076141727180383
-0.833333333333333  -0.500000000000000  -0.500000000000000  0.076141727180383
-0.833333333333333  -0.166666666666667  -0.833333333333333  0.076141727180383
-0.500000000000000  -0.833333333333333  -0.500000000000000  0.076141727180383
-0.500000000000000  -0.500000000000000  -0.833333333333333  0.076141727180383
-0.166666666666667  -0.833333333333333  -0.833333333333333  0.076141727180383
-0.833333333333333  -0.833333333333333  -0.500000000000000  0.076141727180383
-0.833333333333333  -0.500000000000000  -0.833333333333333  0.076141727180383
-0.500000000000000  -0.833333333333333  -0.833333333333333  0.076141727180383
-0.833333333333333  -0.833333333333333  -0.833333333333333  0.076141727180383
-0.800000000000000  -0.800000000000000  0.400000000000000  -0.004255896151021
-0.800000000000000  -0.400000000000000  0.000000000000000  -0.004255896151021
-0.800000000000000  0.000000000000000  -0.400000000000000  -0.004255896151021
-0.800000000000000  0.400000000000000  -0.800000000000000  -0.004255896151021
-0.400000000000000  -0.800000000000000  0.000000000000000  -0.004255896151021
-0.400000000000000  -0.400000000000000  -0.400000000000000  -0.004255896151021
-0.400000000000000  0.000000000000000  -0.800000000000000  -0.004255896151021
0.000000000000000  -0.800000000000000  -0.400000000000000  -0.004255896151021
0.000000000000000  -0.400000000000000  -0.800000000000000  -0.004255896151021
0.400000000000000  -0.800000000000000  -0.800000000000000  -0.004255896151021
-0.800000000000000  -0.800000000000000  0.000000000000000  -0.004255896151021
-0.800000000000000  -0.400000000000000  -0.400000000000000  -0.004255896151021
-0.800000000000000  0.000000000000000  -0.800000000000000  -0.004255896151021
-0.400000000000000  -0.800000000000000  -0.400000000000000  -0.004255896151021
-0.400000000000000  -0.400000000000000  -0.800000000000000  -0.004255896151021
0.000000000000000  -0.800000000000000  -0.800000000000000  -0.004255896151021
-0.800000000000000  -0.800000000000000  -0.400000000000000  -0.004255896151021
-0.800000000000000  -0.400000000000000  -0.800000000000000  -0.004255896151021
-0.400000000000000  -0.800000000000000  -0.800000000000000  -0.004255896151021
-0.800000000000000  -0.800000000000000  -0.800000000000000  -0.004255896151021
-0.750000000000000  -0.750000000000000  0.250000000000000  0.000083414141296
-0.750000000000000  -0.250000000000000  -0.250000000000000  0.000083414141296
-0.750000000000000  0.250000000000000  -0.750000000000000  0.000083414141296
-0.250000000000000  -0.750000000000000  -0.250000000000000  0.000083414141296
-0.250000000000000  -0.250000000000000  -0.750000000000000  0.000083414141296
0.250000000000000  -0.750000000000000  -0.750000000000000  0.000083414141296
-0.750000000000000  -0.750000000000000  -0.250000000000000  0.000083414141296
-0.750000000000000  -0.250000000000000  -0.750000000000000  0.000083414141296
-0.250000000000000  -0.750000000000000  -0.750000000000000  0.000083414141296
-0.750000000000000  -0.750000000000000  -0.750000000000000  0.000083414141296
-0.666666666666667  -0.666666666666667  0.000000000000000  -0.000000352698561
-0.666666666666667  0.000000000000000  -0.666666666666667  -0.000000352698561
0.000000000000000  -0.666666666666667  -0.666666666666667  -0.000000352698561
-0.666666666666667  -0.666666666666667  -0.666666666666667  -0.000000352698561
-0.500000000000000  -0.500000000000000  -0.500000000000000  0.000000000106067
  Gauss  quadrature  constants  for  the  reference  tetrahedron  order  p=21
*/
template<typename T>
struct IMTetrahedra<21,T>
{
    typedef T value_type;
    static const uint16_type nDim = 3;
    static const uint16_type nOrder = 21;
    static const uint16_type nPoints = 1001;
    IMTetrahedra()
        :
        q()
    {
        q+=
            -0.916666666666667,  -0.916666666666667,  0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  0.083333333333333,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  0.250000000000000,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.083333333333333,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  0.083333333333333,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.250000000000000,  -0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.083333333333333,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  0.250000000000000,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  0.083333333333333,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.083333333333333,  1.186370883531411,
            -0.416666666666667,  -0.416666666666667,  -0.250000000000000,  1.186370883531411,
            -0.416666666666667,  -0.250000000000000,  -0.416666666666667,  1.186370883531411,
            -0.416666666666667,  -0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  0.083333333333333,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.083333333333333,  1.186370883531411,
            -0.250000000000000,  -0.583333333333333,  -0.250000000000000,  1.186370883531411,
            -0.250000000000000,  -0.416666666666667,  -0.416666666666667,  1.186370883531411,
            -0.250000000000000,  -0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.250000000000000,  -0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.083333333333333,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.083333333333333,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.083333333333333,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.083333333333333,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.083333333333333,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            0.083333333333333,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            0.083333333333333,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            0.083333333333333,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            0.083333333333333,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            0.083333333333333,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            0.250000000000000,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            0.250000000000000,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            0.250000000000000,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            0.250000000000000,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            0.416666666666667,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            0.416666666666667,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            0.416666666666667,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            0.583333333333333,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            0.583333333333333,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            0.750000000000000,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  0.083333333333333,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.083333333333333,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.250000000000000,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  0.083333333333333,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.083333333333333,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.250000000000000,  1.186370883531411,
            -0.416666666666667,  -0.416666666666667,  -0.416666666666667,  1.186370883531411,
            -0.416666666666667,  -0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  -0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.250000000000000,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.250000000000000,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.250000000000000,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.083333333333333,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.083333333333333,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.083333333333333,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.083333333333333,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            0.083333333333333,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            0.083333333333333,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            0.083333333333333,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            0.083333333333333,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            0.250000000000000,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            0.250000000000000,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            0.250000000000000,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            0.416666666666667,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            0.416666666666667,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            0.583333333333333,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  -0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.416666666666667,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.250000000000000,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.250000000000000,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.083333333333333,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.083333333333333,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.083333333333333,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            0.083333333333333,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            0.083333333333333,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            0.083333333333333,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            0.250000000000000,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            0.250000000000000,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            0.416666666666667,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.250000000000000,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.083333333333333,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.083333333333333,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            0.083333333333333,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            0.083333333333333,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            0.250000000000000,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.083333333333333,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            0.083333333333333,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.083333333333333,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.083333333333333,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.250000000000000,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.083333333333333,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.250000000000000,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.250000000000000,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.416666666666667,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.250000000000000,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.416666666666667,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.416666666666667,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.583333333333333,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.416666666666667,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.583333333333333,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.583333333333333,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.750000000000000,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.583333333333333,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.750000000000000,  1.186370883531411,
            -0.916666666666667,  -0.750000000000000,  -0.916666666666667,  1.186370883531411,
            -0.750000000000000,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.916666666666667,  -0.916666666666667,  -0.916666666666667,  1.186370883531411,
            -0.909090909090909,  -0.909090909090909,  0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  0.000000000000000,  -4.580068174334528,
            -0.909090909090909,  0.000000000000000,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  0.181818181818182,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  0.000000000000000,  -4.580068174334528,
            -0.727272727272727,  -0.181818181818182,  -0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  0.000000000000000,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  0.000000000000000,  -4.580068174334528,
            -0.545454545454545,  -0.363636363636364,  -0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.181818181818182,  -0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  0.000000000000000,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  0.181818181818182,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  0.000000000000000,  -4.580068174334528,
            -0.363636363636364,  -0.545454545454545,  -0.181818181818182,  -4.580068174334528,
            -0.363636363636364,  -0.363636363636364,  -0.363636363636364,  -4.580068174334528,
            -0.363636363636364,  -0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.363636363636364,  0.000000000000000,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  0.000000000000000,  -4.580068174334528,
            -0.181818181818182,  -0.727272727272727,  -0.181818181818182,  -4.580068174334528,
            -0.181818181818182,  -0.545454545454545,  -0.363636363636364,  -4.580068174334528,
            -0.181818181818182,  -0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.181818181818182,  -0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.181818181818182,  0.000000000000000,  -0.909090909090909,  -4.580068174334528,
            0.000000000000000,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            0.000000000000000,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            0.000000000000000,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            0.000000000000000,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            0.000000000000000,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            0.181818181818182,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            0.181818181818182,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            0.181818181818182,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            0.181818181818182,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            0.363636363636364,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            0.363636363636364,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            0.363636363636364,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            0.545454545454545,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            0.545454545454545,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            0.727272727272727,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  0.000000000000000,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  0.000000000000000,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  0.000000000000000,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  -0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.181818181818182,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  0.000000000000000,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  0.000000000000000,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  -0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.363636363636364,  -0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  -0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  0.000000000000000,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  0.000000000000000,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  -0.181818181818182,  -4.580068174334528,
            -0.363636363636364,  -0.545454545454545,  -0.363636363636364,  -4.580068174334528,
            -0.363636363636364,  -0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.363636363636364,  -0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  0.000000000000000,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            -0.181818181818182,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            -0.181818181818182,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            -0.181818181818182,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.181818181818182,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            0.000000000000000,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            0.000000000000000,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            0.000000000000000,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            0.000000000000000,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            0.181818181818182,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            0.181818181818182,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            0.181818181818182,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            0.363636363636364,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            0.363636363636364,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            0.545454545454545,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  0.000000000000000,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  0.000000000000000,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  0.000000000000000,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  -0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  0.000000000000000,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  0.000000000000000,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  -0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  -0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  -0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  -0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  0.000000000000000,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            -0.363636363636364,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            -0.363636363636364,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            -0.181818181818182,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            -0.181818181818182,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.181818181818182,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            0.000000000000000,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            0.000000000000000,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            0.000000000000000,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            0.181818181818182,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            0.181818181818182,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            0.363636363636364,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  0.000000000000000,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  0.000000000000000,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  0.000000000000000,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  -0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  -0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  0.000000000000000,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            -0.363636363636364,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            -0.181818181818182,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            -0.181818181818182,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            0.000000000000000,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            0.000000000000000,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            0.181818181818182,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  0.000000000000000,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  0.000000000000000,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            -0.181818181818182,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            0.000000000000000,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  -0.181818181818182,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  -0.181818181818182,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            -0.363636363636364,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            -0.181818181818182,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  -0.363636363636364,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  -0.363636363636364,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            -0.545454545454545,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            -0.363636363636364,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  -0.545454545454545,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  -0.545454545454545,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            -0.727272727272727,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            -0.545454545454545,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  -0.727272727272727,  -4.580068174334528,
            -0.909090909090909,  -0.727272727272727,  -0.909090909090909,  -4.580068174334528,
            -0.727272727272727,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.909090909090909,  -0.909090909090909,  -0.909090909090909,  -4.580068174334528,
            -0.900000000000000,  -0.900000000000000,  0.700000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.100000000000000,  -0.100000000000000,  7.117433113960459,
            -0.900000000000000,  0.100000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  0.300000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  0.700000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  0.500000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.300000000000000,  -0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.100000000000000,  -0.300000000000000,  7.117433113960459,
            -0.700000000000000,  0.100000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  0.300000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  0.100000000000000,  7.117433113960459,
            -0.500000000000000,  -0.500000000000000,  -0.100000000000000,  7.117433113960459,
            -0.500000000000000,  -0.300000000000000,  -0.300000000000000,  7.117433113960459,
            -0.500000000000000,  -0.100000000000000,  -0.500000000000000,  7.117433113960459,
            -0.500000000000000,  0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  0.100000000000000,  7.117433113960459,
            -0.300000000000000,  -0.700000000000000,  -0.100000000000000,  7.117433113960459,
            -0.300000000000000,  -0.500000000000000,  -0.300000000000000,  7.117433113960459,
            -0.300000000000000,  -0.300000000000000,  -0.500000000000000,  7.117433113960459,
            -0.300000000000000,  -0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.300000000000000,  0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.100000000000000,  -0.900000000000000,  -0.100000000000000,  7.117433113960459,
            -0.100000000000000,  -0.700000000000000,  -0.300000000000000,  7.117433113960459,
            -0.100000000000000,  -0.500000000000000,  -0.500000000000000,  7.117433113960459,
            -0.100000000000000,  -0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.100000000000000,  -0.100000000000000,  -0.900000000000000,  7.117433113960459,
            0.100000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            0.100000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            0.100000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            0.100000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            0.300000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            0.300000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            0.300000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            0.500000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            0.500000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            0.700000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  -0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.100000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  0.100000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  -0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.300000000000000,  -0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.100000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  0.100000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  -0.100000000000000,  7.117433113960459,
            -0.500000000000000,  -0.500000000000000,  -0.300000000000000,  7.117433113960459,
            -0.500000000000000,  -0.300000000000000,  -0.500000000000000,  7.117433113960459,
            -0.500000000000000,  -0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  -0.100000000000000,  7.117433113960459,
            -0.300000000000000,  -0.700000000000000,  -0.300000000000000,  7.117433113960459,
            -0.300000000000000,  -0.500000000000000,  -0.500000000000000,  7.117433113960459,
            -0.300000000000000,  -0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.300000000000000,  -0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.100000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            -0.100000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            -0.100000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.100000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            0.100000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            0.100000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            0.100000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            0.300000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            0.300000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            0.500000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  -0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.100000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  -0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  -0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.300000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  -0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  -0.100000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  -0.300000000000000,  7.117433113960459,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  7.117433113960459,
            -0.500000000000000,  -0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  -0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            -0.300000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            -0.300000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.300000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.100000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            -0.100000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            -0.100000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            0.100000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            0.100000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            0.300000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  -0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.100000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  -0.100000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  -0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  -0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  -0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            -0.500000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            -0.300000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            -0.300000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.100000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            -0.100000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            0.100000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  -0.100000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  -0.100000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            -0.300000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            -0.100000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  -0.300000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  -0.300000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            -0.500000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            -0.300000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  -0.500000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  -0.500000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            -0.700000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            -0.500000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  -0.700000000000000,  7.117433113960459,
            -0.900000000000000,  -0.700000000000000,  -0.900000000000000,  7.117433113960459,
            -0.700000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.900000000000000,  -0.900000000000000,  -0.900000000000000,  7.117433113960459,
            -0.888888888888889,  -0.888888888888889,  0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.222222222222222,  0.000000000000000,  -5.711070467965174,
            -0.888888888888889,  0.000000000000000,  -0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  0.222222222222222,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  -0.444444444444444,  0.000000000000000,  -5.711070467965174,
            -0.666666666666667,  -0.222222222222222,  -0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  0.000000000000000,  -0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  0.222222222222222,  -5.711070467965174,
            -0.444444444444444,  -0.666666666666667,  0.000000000000000,  -5.711070467965174,
            -0.444444444444444,  -0.444444444444444,  -0.222222222222222,  -5.711070467965174,
            -0.444444444444444,  -0.222222222222222,  -0.444444444444444,  -5.711070467965174,
            -0.444444444444444,  0.000000000000000,  -0.666666666666667,  -5.711070467965174,
            -0.444444444444444,  0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.222222222222222,  -0.888888888888889,  0.000000000000000,  -5.711070467965174,
            -0.222222222222222,  -0.666666666666667,  -0.222222222222222,  -5.711070467965174,
            -0.222222222222222,  -0.444444444444444,  -0.444444444444444,  -5.711070467965174,
            -0.222222222222222,  -0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.222222222222222,  0.000000000000000,  -0.888888888888889,  -5.711070467965174,
            0.000000000000000,  -0.888888888888889,  -0.222222222222222,  -5.711070467965174,
            0.000000000000000,  -0.666666666666667,  -0.444444444444444,  -5.711070467965174,
            0.000000000000000,  -0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            0.000000000000000,  -0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            0.222222222222222,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            0.222222222222222,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            0.222222222222222,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            0.444444444444444,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            0.444444444444444,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            0.666666666666667,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  0.000000000000000,  -5.711070467965174,
            -0.888888888888889,  -0.222222222222222,  -0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  0.000000000000000,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  0.000000000000000,  -5.711070467965174,
            -0.666666666666667,  -0.444444444444444,  -0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  -0.222222222222222,  -0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  0.000000000000000,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  0.000000000000000,  -5.711070467965174,
            -0.444444444444444,  -0.666666666666667,  -0.222222222222222,  -5.711070467965174,
            -0.444444444444444,  -0.444444444444444,  -0.444444444444444,  -5.711070467965174,
            -0.444444444444444,  -0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.444444444444444,  0.000000000000000,  -0.888888888888889,  -5.711070467965174,
            -0.222222222222222,  -0.888888888888889,  -0.222222222222222,  -5.711070467965174,
            -0.222222222222222,  -0.666666666666667,  -0.444444444444444,  -5.711070467965174,
            -0.222222222222222,  -0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            -0.222222222222222,  -0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            0.000000000000000,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            0.000000000000000,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            0.000000000000000,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            0.222222222222222,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            0.222222222222222,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            0.444444444444444,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  0.000000000000000,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  -0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.222222222222222,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  0.000000000000000,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  0.000000000000000,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  -0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  -0.444444444444444,  -0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  -0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  0.000000000000000,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  -0.222222222222222,  -5.711070467965174,
            -0.444444444444444,  -0.666666666666667,  -0.444444444444444,  -5.711070467965174,
            -0.444444444444444,  -0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            -0.444444444444444,  -0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.222222222222222,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            -0.222222222222222,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            -0.222222222222222,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            0.000000000000000,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            0.000000000000000,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            0.222222222222222,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  0.000000000000000,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  -0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  -0.222222222222222,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  0.000000000000000,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  -0.222222222222222,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  -0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  -0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  -0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            -0.444444444444444,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            -0.444444444444444,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            -0.222222222222222,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            -0.222222222222222,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            0.000000000000000,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  -0.222222222222222,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  -0.222222222222222,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            -0.444444444444444,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            -0.222222222222222,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  -0.444444444444444,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  -0.444444444444444,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            -0.666666666666667,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            -0.444444444444444,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  -0.666666666666667,  -5.711070467965174,
            -0.888888888888889,  -0.666666666666667,  -0.888888888888889,  -5.711070467965174,
            -0.666666666666667,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.888888888888889,  -0.888888888888889,  -0.888888888888889,  -5.711070467965174,
            -0.875000000000000,  -0.875000000000000,  0.625000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  0.375000000000000,  2.527399241963254,
            -0.875000000000000,  -0.375000000000000,  0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.125000000000000,  -0.125000000000000,  2.527399241963254,
            -0.875000000000000,  0.125000000000000,  -0.375000000000000,  2.527399241963254,
            -0.875000000000000,  0.375000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  0.625000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  0.375000000000000,  2.527399241963254,
            -0.625000000000000,  -0.625000000000000,  0.125000000000000,  2.527399241963254,
            -0.625000000000000,  -0.375000000000000,  -0.125000000000000,  2.527399241963254,
            -0.625000000000000,  -0.125000000000000,  -0.375000000000000,  2.527399241963254,
            -0.625000000000000,  0.125000000000000,  -0.625000000000000,  2.527399241963254,
            -0.625000000000000,  0.375000000000000,  -0.875000000000000,  2.527399241963254,
            -0.375000000000000,  -0.875000000000000,  0.125000000000000,  2.527399241963254,
            -0.375000000000000,  -0.625000000000000,  -0.125000000000000,  2.527399241963254,
            -0.375000000000000,  -0.375000000000000,  -0.375000000000000,  2.527399241963254,
            -0.375000000000000,  -0.125000000000000,  -0.625000000000000,  2.527399241963254,
            -0.375000000000000,  0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.125000000000000,  -0.875000000000000,  -0.125000000000000,  2.527399241963254,
            -0.125000000000000,  -0.625000000000000,  -0.375000000000000,  2.527399241963254,
            -0.125000000000000,  -0.375000000000000,  -0.625000000000000,  2.527399241963254,
            -0.125000000000000,  -0.125000000000000,  -0.875000000000000,  2.527399241963254,
            0.125000000000000,  -0.875000000000000,  -0.375000000000000,  2.527399241963254,
            0.125000000000000,  -0.625000000000000,  -0.625000000000000,  2.527399241963254,
            0.125000000000000,  -0.375000000000000,  -0.875000000000000,  2.527399241963254,
            0.375000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            0.375000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            0.625000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  0.375000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.375000000000000,  -0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.125000000000000,  -0.375000000000000,  2.527399241963254,
            -0.875000000000000,  0.125000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  0.375000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  0.125000000000000,  2.527399241963254,
            -0.625000000000000,  -0.625000000000000,  -0.125000000000000,  2.527399241963254,
            -0.625000000000000,  -0.375000000000000,  -0.375000000000000,  2.527399241963254,
            -0.625000000000000,  -0.125000000000000,  -0.625000000000000,  2.527399241963254,
            -0.625000000000000,  0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.375000000000000,  -0.875000000000000,  -0.125000000000000,  2.527399241963254,
            -0.375000000000000,  -0.625000000000000,  -0.375000000000000,  2.527399241963254,
            -0.375000000000000,  -0.375000000000000,  -0.625000000000000,  2.527399241963254,
            -0.375000000000000,  -0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.125000000000000,  -0.875000000000000,  -0.375000000000000,  2.527399241963254,
            -0.125000000000000,  -0.625000000000000,  -0.625000000000000,  2.527399241963254,
            -0.125000000000000,  -0.375000000000000,  -0.875000000000000,  2.527399241963254,
            0.125000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            0.125000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            0.375000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  -0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.375000000000000,  -0.375000000000000,  2.527399241963254,
            -0.875000000000000,  -0.125000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  -0.125000000000000,  2.527399241963254,
            -0.625000000000000,  -0.625000000000000,  -0.375000000000000,  2.527399241963254,
            -0.625000000000000,  -0.375000000000000,  -0.625000000000000,  2.527399241963254,
            -0.625000000000000,  -0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.375000000000000,  -0.875000000000000,  -0.375000000000000,  2.527399241963254,
            -0.375000000000000,  -0.625000000000000,  -0.625000000000000,  2.527399241963254,
            -0.375000000000000,  -0.375000000000000,  -0.875000000000000,  2.527399241963254,
            -0.125000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            -0.125000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            0.125000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  -0.125000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  -0.375000000000000,  2.527399241963254,
            -0.875000000000000,  -0.375000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  -0.125000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  -0.375000000000000,  2.527399241963254,
            -0.625000000000000,  -0.625000000000000,  -0.625000000000000,  2.527399241963254,
            -0.625000000000000,  -0.375000000000000,  -0.875000000000000,  2.527399241963254,
            -0.375000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            -0.375000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            -0.125000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  -0.375000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  -0.375000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            -0.625000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            -0.375000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  -0.625000000000000,  2.527399241963254,
            -0.875000000000000,  -0.625000000000000,  -0.875000000000000,  2.527399241963254,
            -0.625000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.875000000000000,  -0.875000000000000,  -0.875000000000000,  2.527399241963254,
            -0.857142857142857,  -0.857142857142857,  0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  -0.571428571428571,  0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  -0.285714285714286,  0.000000000000000,  -0.612213575618572,
            -0.857142857142857,  0.000000000000000,  -0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  0.285714285714286,  -0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            -0.571428571428571,  -0.857142857142857,  0.285714285714286,  -0.612213575618572,
            -0.571428571428571,  -0.571428571428571,  0.000000000000000,  -0.612213575618572,
            -0.571428571428571,  -0.285714285714286,  -0.285714285714286,  -0.612213575618572,
            -0.571428571428571,  0.000000000000000,  -0.571428571428571,  -0.612213575618572,
            -0.571428571428571,  0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            -0.285714285714286,  -0.857142857142857,  0.000000000000000,  -0.612213575618572,
            -0.285714285714286,  -0.571428571428571,  -0.285714285714286,  -0.612213575618572,
            -0.285714285714286,  -0.285714285714286,  -0.571428571428571,  -0.612213575618572,
            -0.285714285714286,  0.000000000000000,  -0.857142857142857,  -0.612213575618572,
            0.000000000000000,  -0.857142857142857,  -0.285714285714286,  -0.612213575618572,
            0.000000000000000,  -0.571428571428571,  -0.571428571428571,  -0.612213575618572,
            0.000000000000000,  -0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -0.612213575618572,
            0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.857142857142857,  -0.857142857142857,  0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  -0.571428571428571,  0.000000000000000,  -0.612213575618572,
            -0.857142857142857,  -0.285714285714286,  -0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  0.000000000000000,  -0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            -0.571428571428571,  -0.857142857142857,  0.000000000000000,  -0.612213575618572,
            -0.571428571428571,  -0.571428571428571,  -0.285714285714286,  -0.612213575618572,
            -0.571428571428571,  -0.285714285714286,  -0.571428571428571,  -0.612213575618572,
            -0.571428571428571,  0.000000000000000,  -0.857142857142857,  -0.612213575618572,
            -0.285714285714286,  -0.857142857142857,  -0.285714285714286,  -0.612213575618572,
            -0.285714285714286,  -0.571428571428571,  -0.571428571428571,  -0.612213575618572,
            -0.285714285714286,  -0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            0.000000000000000,  -0.857142857142857,  -0.571428571428571,  -0.612213575618572,
            0.000000000000000,  -0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.857142857142857,  -0.857142857142857,  0.000000000000000,  -0.612213575618572,
            -0.857142857142857,  -0.571428571428571,  -0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  -0.285714285714286,  -0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  0.000000000000000,  -0.857142857142857,  -0.612213575618572,
            -0.571428571428571,  -0.857142857142857,  -0.285714285714286,  -0.612213575618572,
            -0.571428571428571,  -0.571428571428571,  -0.571428571428571,  -0.612213575618572,
            -0.571428571428571,  -0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            -0.285714285714286,  -0.857142857142857,  -0.571428571428571,  -0.612213575618572,
            -0.285714285714286,  -0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            0.000000000000000,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.857142857142857,  -0.857142857142857,  -0.285714285714286,  -0.612213575618572,
            -0.857142857142857,  -0.571428571428571,  -0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  -0.285714285714286,  -0.857142857142857,  -0.612213575618572,
            -0.571428571428571,  -0.857142857142857,  -0.571428571428571,  -0.612213575618572,
            -0.571428571428571,  -0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            -0.285714285714286,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.857142857142857,  -0.857142857142857,  -0.571428571428571,  -0.612213575618572,
            -0.857142857142857,  -0.571428571428571,  -0.857142857142857,  -0.612213575618572,
            -0.571428571428571,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.857142857142857,  -0.857142857142857,  -0.857142857142857,  -0.612213575618572,
            -0.833333333333333,  -0.833333333333333,  0.500000000000000,  0.076141727180383,
            -0.833333333333333,  -0.500000000000000,  0.166666666666667,  0.076141727180383,
            -0.833333333333333,  -0.166666666666667,  -0.166666666666667,  0.076141727180383,
            -0.833333333333333,  0.166666666666667,  -0.500000000000000,  0.076141727180383,
            -0.833333333333333,  0.500000000000000,  -0.833333333333333,  0.076141727180383,
            -0.500000000000000,  -0.833333333333333,  0.166666666666667,  0.076141727180383,
            -0.500000000000000,  -0.500000000000000,  -0.166666666666667,  0.076141727180383,
            -0.500000000000000,  -0.166666666666667,  -0.500000000000000,  0.076141727180383,
            -0.500000000000000,  0.166666666666667,  -0.833333333333333,  0.076141727180383,
            -0.166666666666667,  -0.833333333333333,  -0.166666666666667,  0.076141727180383,
            -0.166666666666667,  -0.500000000000000,  -0.500000000000000,  0.076141727180383,
            -0.166666666666667,  -0.166666666666667,  -0.833333333333333,  0.076141727180383,
            0.166666666666667,  -0.833333333333333,  -0.500000000000000,  0.076141727180383,
            0.166666666666667,  -0.500000000000000,  -0.833333333333333,  0.076141727180383,
            0.500000000000000,  -0.833333333333333,  -0.833333333333333,  0.076141727180383,
            -0.833333333333333,  -0.833333333333333,  0.166666666666667,  0.076141727180383,
            -0.833333333333333,  -0.500000000000000,  -0.166666666666667,  0.076141727180383,
            -0.833333333333333,  -0.166666666666667,  -0.500000000000000,  0.076141727180383,
            -0.833333333333333,  0.166666666666667,  -0.833333333333333,  0.076141727180383,
            -0.500000000000000,  -0.833333333333333,  -0.166666666666667,  0.076141727180383,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.076141727180383,
            -0.500000000000000,  -0.166666666666667,  -0.833333333333333,  0.076141727180383,
            -0.166666666666667,  -0.833333333333333,  -0.500000000000000,  0.076141727180383,
            -0.166666666666667,  -0.500000000000000,  -0.833333333333333,  0.076141727180383,
            0.166666666666667,  -0.833333333333333,  -0.833333333333333,  0.076141727180383,
            -0.833333333333333,  -0.833333333333333,  -0.166666666666667,  0.076141727180383,
            -0.833333333333333,  -0.500000000000000,  -0.500000000000000,  0.076141727180383,
            -0.833333333333333,  -0.166666666666667,  -0.833333333333333,  0.076141727180383,
            -0.500000000000000,  -0.833333333333333,  -0.500000000000000,  0.076141727180383,
            -0.500000000000000,  -0.500000000000000,  -0.833333333333333,  0.076141727180383,
            -0.166666666666667,  -0.833333333333333,  -0.833333333333333,  0.076141727180383,
            -0.833333333333333,  -0.833333333333333,  -0.500000000000000,  0.076141727180383,
            -0.833333333333333,  -0.500000000000000,  -0.833333333333333,  0.076141727180383,
            -0.500000000000000,  -0.833333333333333,  -0.833333333333333,  0.076141727180383,
            -0.833333333333333,  -0.833333333333333,  -0.833333333333333,  0.076141727180383,
            -0.800000000000000,  -0.800000000000000,  0.400000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.400000000000000,  0.000000000000000,  -0.004255896151021,
            -0.800000000000000,  0.000000000000000,  -0.400000000000000,  -0.004255896151021,
            -0.800000000000000,  0.400000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.400000000000000,  -0.800000000000000,  0.000000000000000,  -0.004255896151021,
            -0.400000000000000,  -0.400000000000000,  -0.400000000000000,  -0.004255896151021,
            -0.400000000000000,  0.000000000000000,  -0.800000000000000,  -0.004255896151021,
            0.000000000000000,  -0.800000000000000,  -0.400000000000000,  -0.004255896151021,
            0.000000000000000,  -0.400000000000000,  -0.800000000000000,  -0.004255896151021,
            0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.800000000000000,  0.000000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.400000000000000,  -0.400000000000000,  -0.004255896151021,
            -0.800000000000000,  0.000000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.400000000000000,  -0.800000000000000,  -0.400000000000000,  -0.004255896151021,
            -0.400000000000000,  -0.400000000000000,  -0.800000000000000,  -0.004255896151021,
            0.000000000000000,  -0.800000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.800000000000000,  -0.400000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.400000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.400000000000000,  -0.800000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.800000000000000,  -0.800000000000000,  -0.800000000000000,  -0.004255896151021,
            -0.750000000000000,  -0.750000000000000,  0.250000000000000,  0.000083414141296,
            -0.750000000000000,  -0.250000000000000,  -0.250000000000000,  0.000083414141296,
            -0.750000000000000,  0.250000000000000,  -0.750000000000000,  0.000083414141296,
            -0.250000000000000,  -0.750000000000000,  -0.250000000000000,  0.000083414141296,
            -0.250000000000000,  -0.250000000000000,  -0.750000000000000,  0.000083414141296,
            0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.000083414141296,
            -0.750000000000000,  -0.750000000000000,  -0.250000000000000,  0.000083414141296,
            -0.750000000000000,  -0.250000000000000,  -0.750000000000000,  0.000083414141296,
            -0.250000000000000,  -0.750000000000000,  -0.750000000000000,  0.000083414141296,
            -0.750000000000000,  -0.750000000000000,  -0.750000000000000,  0.000083414141296,
            -0.666666666666667,  -0.666666666666667,  0.000000000000000,  -0.000000352698561,
            -0.666666666666667,  0.000000000000000,  -0.666666666666667,  -0.000000352698561,
            0.000000000000000,  -0.666666666666667,  -0.666666666666667,  -0.000000352698561,
            -0.666666666666667,  -0.666666666666667,  -0.666666666666667,  -0.000000352698561,
            -0.500000000000000,  -0.500000000000000,  -0.500000000000000,  0.000000000106067;
    }

    std::vector<value_type> q;
};
template<typename T> struct IMTetrahedra<20,T>: public IMTetrahedra<21,T> {};
} // detail


/**
 * \class IMSimplex
 * \brief brief description
 *
 * \ingroup Polynomial
 * @author Christophe Prud'homme
 * @see
 */
template<int Dim,int Order, typename T>
class IMSimplex
    :
    public PointSetQuadrature<Simplex<Dim,1> , Order, T>
{
    typedef PointSetQuadrature<Simplex<Dim,1> , Order, T> super;
public:

    /** @name Typedefs
     */
    //@{
    typedef T value_type;
    typedef ublas::matrix<value_type,ublas::column_major> matrix_type;
    typedef ublas::vector<value_type> vector_type;
    typedef typename mpl::if_<mpl::equal_to<mpl::int_<Dim>,mpl::int_<2> >,
                              mpl::identity<detail::IMTriangle<Order,T> >,
                              mpl::identity<detail::IMTetrahedra<Order,T> > >::type::type quad_type;

#if 1
#if 0
    typedef typename mpl::if_<mpl::equal_to<mpl::int_<Dim>,mpl::int_<2> >,
                              mpl::identity<Gauss<Simplex<Dim-1,1>,Order,T> >,
                              mpl::identity<Gauss<Simplex<Dim-1,1>,Order,T> > >::type::type face_quad_type;
                              //mpl::identity<IMSimplex<Dim-1,Order,T> > >::type::type face_quad_type;
#else
    typedef Gauss<Simplex<Dim-1,1>,Order,T> face_quad_type;
#endif
#else
    typedef IMSimplex<Dim-1,Order,T> face_quad_type;
#endif
    typedef IMSimplex<Dim,Order,T> parent_quadrature_type;
    static const uint16_type nDim = Dim;
    static const uint16_type nOrder = Order;

    static const T factor = (Dim==2)?T(1)/T(2):T(1)/T(6);
    //@}

    /** @name Constructors, destructor
     */
    //@{
    IMSimplex(  )
        :
        super( quad_type::nPoints ),
        _M_quad()
    {
        for (size_type i=0; i< quad_type::nPoints; i++)
            {

                for( int j = 0; j < Dim; ++j )
                    {
                        this->_M_points( j, i ) = _M_quad.q[(Dim+1)*i+j];
                    }
                this->_M_w( i ) = _M_quad.q[(Dim+1)*i+Dim];
            }

        boost::shared_ptr<GT_Lagrange<Dim,1,Simplex,T> > gm( new GT_Lagrange<Dim, 1, Simplex, T> );
        boost::shared_ptr<face_quad_type> face_qr( new face_quad_type );
        // construct face quadratures
        this->constructQROnFace( Reference<Simplex<Dim, 1>, Dim, 1>(), gm, face_qr );
    }

    ~IMSimplex()
    {}

    //@}

    /** @name  Methods
     */
    //@{
    IMSimplex& operator=( IMSimplex const & i)
    {
        if ( this != &i )
            {
                _M_quad = i._M_quad;
            }
        return *this;
    }
    //@}


private:
    quad_type _M_quad;
};

}

#endif /* __IMSimplex_H */
