/* $Id: list.c 4799 2009-10-02 13:22:19Z potyra $
 *
 * Generic list structures.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "list.h"
#include <assert.h>
#include <stdlib.h>

struct slist *
slist_create(void *(*allocator)(size_t))
{
	struct slist *ret = allocator(sizeof(struct slist));
	assert(ret != NULL);

	ret->first = NULL;
	ret->tail = NULL;

	return ret;
}

void
slist_destroy(struct slist *l, void (*deallocator)(void *))
{
	struct slist_entry *i = l->first;
	struct slist_entry *tmp;

	while (i != NULL) {
		tmp = i;
		i = i->next;
		deallocator(tmp);
	}

	deallocator(l);
}

void
slist_add(struct slist *l, void *data, void *(*allocator)(size_t))
{
	struct slist_entry *entry = allocator(sizeof(struct slist_entry));
	assert(entry != NULL);
	assert(l != NULL);

	entry->data = data;
	entry->next = NULL;

	if (l->tail == NULL) {
		l->first = entry;
		l->tail = entry;
	} else {
		l->tail->next = entry;
		l->tail = entry;
	}
}
