/* $Id: arch_i286_gen.h,v 1.20 2009-01-27 15:40:21 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ARCH_I286_GEN_H_INCLUDED
#define __ARCH_I286_GEN_H_INCLUDED

#define _DEBUG 0
#define _DEBUG_MOV 0

#define _DEBUG_VAR_TYPE 1
#define _DEBUG_STMT_TYPE 2

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "declaration.h"
#include "scope.h"
#include "expr.h"
#include "stmt.h"

extern void
arch_i286_align_size(
	struct scope *scope,
	struct type *type,
	unsigned int *alignp,
	unsigned int *sizep);

extern void
arch_i286_gen_class_and_type_get(
        const char *name, unsigned int *classp, enum type_type *typep);
extern unsigned int
arch_i286_gen_class_or(unsigned int a, unsigned int b);
extern unsigned int
arch_i286_gen_class_and(unsigned int a, unsigned int b);

extern void
arch_i286_color_init(unsigned int *count);
extern void
arch_i286_color_add(unsigned int *count, unsigned int set, enum type_type type);
extern void
arch_i286_color_sub(unsigned int *count, unsigned int set, enum type_type type);
extern int
arch_i286_color_check(unsigned int *count, unsigned int set, enum type_type type);

extern void
arch_i286_gen_reg_init(uint32_t *conflicts);
extern void
arch_i286_gen_reg_add(uint32_t *conflicts, unsigned int reg);
extern int
arch_i286_gen_reg_get(uint32_t *conflicts, unsigned int class, enum type_type type);

extern void
arch_i286_gen(FILE *fp, struct scope *s);

#endif /* __ARCH_I286_GEN_H_INCLUDED */
 
