/*
 * lj-transmitter.h - Headers for libjingle transmitter plugin
 *
 * Farsight Voice+Video library
 * Copyright (C) 2007 Collabora Ltd.
 * Copyright (C) 2007 Nokia Corporation
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LJ_TRANSMITTER_H__
#define __LJ_TRANSMITTER_H__

#include "farsight-transmitter.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_LJ_TRANSMITTER \
  (farsight_lj_transmitter_get_type())
#define FARSIGHT_LJ_TRANSMITTER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_LJ_TRANSMITTER, FarsightLJTransmitter))
#define FARSIGHT_LJ_TRANSMITTER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_LJ_TRANSMITTER, FarsightLJTransmitterClass))
#define FARSIGHT_IS_LJ_TRANSMITTER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_LJ_TRANSMITTER))
#define FARSIGHT_IS_LJ_TRANSMITTER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_LJ_TRANSMITTER))
#define FARSIGHT_LJ_TRANSMITTER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_LJ_TRANSMITTER, FarsightLJTransmitterClass))

typedef struct _FarsightLJTransmitter FarsightLJTransmitter;
typedef struct _FarsightLJTransmitterClass FarsightLJTransmitterClass;
typedef struct _FarsightLJTransmitterPrivate FarsightLJTransmitterPrivate;

struct _FarsightLJTransmitterClass
{
  FarsightTransmitterClass parent_class;
};

struct _FarsightLJTransmitter
{
  FarsightTransmitter parent;

  FarsightLJTransmitterPrivate *priv;
};

GType farsight_lj_transmitter_get_type (void);

G_END_DECLS

#endif
