// Source file for evolvotron
// Copyright (C) 2002,2003 Tim Day
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*! \file
  \brief Implementation of class Random and derived classes.
*/

#include "libfunction_precompiled.h"

#include "random.h"

Random01::Random01(uint seed)
  :Random()
   ,_rng(seed)
   ,_dist(0.0,1.0)
   ,_gen(_rng,_dist)
{}

Random01::~Random01()
{}

const double Random01::operator()()
{
  return _gen();
}
