/****************************************************************************
 * Support for Solarflare Solarstorm network controllers and boards
 * Copyright 2010 Solarflare Communications Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#include <stdio.h>
#include <string.h>
#include "ethtool-util.h"

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))
#endif

/* Register definitions (from linux-2.6/drivers/net/sfc/regs.h) */

/* ADR_REGION_REG: Address region register */
#define	FR_AZ_ADR_REGION 0x00000000
#define	FRF_AZ_ADR_REGION3_LBN 96
#define	FRF_AZ_ADR_REGION3_WIDTH 18
#define	FRF_AZ_ADR_REGION2_LBN 64
#define	FRF_AZ_ADR_REGION2_WIDTH 18
#define	FRF_AZ_ADR_REGION1_LBN 32
#define	FRF_AZ_ADR_REGION1_WIDTH 18
#define	FRF_AZ_ADR_REGION0_LBN 0
#define	FRF_AZ_ADR_REGION0_WIDTH 18

/* INT_EN_REG_KER: Kernel driver Interrupt enable register */
#define	FR_AZ_INT_EN_KER 0x00000010
#define	FRF_AZ_KER_INT_LEVE_SEL_LBN 8
#define	FRF_AZ_KER_INT_LEVE_SEL_WIDTH 6
#define	FRF_AZ_KER_INT_CHAR_LBN 4
#define	FRF_AZ_KER_INT_CHAR_WIDTH 1
#define	FRF_AZ_KER_INT_KER_LBN 3
#define	FRF_AZ_KER_INT_KER_WIDTH 1
#define	FRF_AZ_DRV_INT_EN_KER_LBN 0
#define	FRF_AZ_DRV_INT_EN_KER_WIDTH 1

/* INT_EN_REG_CHAR: Char Driver interrupt enable register */
#define	FR_BZ_INT_EN_CHAR 0x00000020
#define	FRF_BZ_CHAR_INT_LEVE_SEL_LBN 8
#define	FRF_BZ_CHAR_INT_LEVE_SEL_WIDTH 6
#define	FRF_BZ_CHAR_INT_CHAR_LBN 4
#define	FRF_BZ_CHAR_INT_CHAR_WIDTH 1
#define	FRF_BZ_CHAR_INT_KER_LBN 3
#define	FRF_BZ_CHAR_INT_KER_WIDTH 1
#define	FRF_BZ_DRV_INT_EN_CHAR_LBN 0
#define	FRF_BZ_DRV_INT_EN_CHAR_WIDTH 1

/* INT_ADR_REG_KER: Interrupt host address for Kernel driver */
#define	FR_AZ_INT_ADR_KER 0x00000030
#define	FRF_AZ_NORM_INT_VEC_DIS_KER_LBN 64
#define	FRF_AZ_NORM_INT_VEC_DIS_KER_WIDTH 1
#define	FRF_AZ_INT_ADR_KER_LBN 0
#define	FRF_AZ_INT_ADR_KER_WIDTH 64

/* INT_ADR_REG_CHAR: Interrupt host address for Char driver */
#define	FR_BZ_INT_ADR_CHAR 0x00000040
#define	FRF_BZ_NORM_INT_VEC_DIS_CHAR_LBN 64
#define	FRF_BZ_NORM_INT_VEC_DIS_CHAR_WIDTH 1
#define	FRF_BZ_INT_ADR_CHAR_LBN 0
#define	FRF_BZ_INT_ADR_CHAR_WIDTH 64

/* INT_ACK_KER: Kernel interrupt acknowledge register */
#define	FR_AA_INT_ACK_KER 0x00000050
#define	FRF_AA_INT_ACK_KER_FIELD_LBN 0
#define	FRF_AA_INT_ACK_KER_FIELD_WIDTH 32

/* INT_ISR0_REG: Function 0 Interrupt Acknowledge Status register */
#define	FR_BZ_INT_ISR0 0x00000090
#define	FRF_BZ_INT_ISR_REG_LBN 0
#define	FRF_BZ_INT_ISR_REG_WIDTH 64

/* HW_INIT_REG: Hardware initialization register */
#define	FR_AZ_HW_INIT 0x000000c0
#define	FRF_BB_BDMRD_CPLF_FULL_LBN 124
#define	FRF_BB_BDMRD_CPLF_FULL_WIDTH 1
#define	FRF_BB_PCIE_CPL_TIMEOUT_CTRL_LBN 121
#define	FRF_BB_PCIE_CPL_TIMEOUT_CTRL_WIDTH 3
#define	FRF_CZ_TX_MRG_TAGS_LBN 120
#define	FRF_CZ_TX_MRG_TAGS_WIDTH 1
#define	FRF_AB_TRGT_MASK_ALL_LBN 100
#define	FRF_AB_TRGT_MASK_ALL_WIDTH 1
#define	FRF_AZ_DOORBELL_DROP_LBN 92
#define	FRF_AZ_DOORBELL_DROP_WIDTH 8
#define	FRF_AB_TX_RREQ_MASK_EN_LBN 76
#define	FRF_AB_TX_RREQ_MASK_EN_WIDTH 1
#define	FRF_AB_PE_EIDLE_DIS_LBN 75
#define	FRF_AB_PE_EIDLE_DIS_WIDTH 1
#define	FRF_AA_FC_BLOCKING_EN_LBN 45
#define	FRF_AA_FC_BLOCKING_EN_WIDTH 1
#define	FRF_BZ_B2B_REQ_EN_LBN 45
#define	FRF_BZ_B2B_REQ_EN_WIDTH 1
#define	FRF_AA_B2B_REQ_EN_LBN 44
#define	FRF_AA_B2B_REQ_EN_WIDTH 1
#define	FRF_BB_FC_BLOCKING_EN_LBN 44
#define	FRF_BB_FC_BLOCKING_EN_WIDTH 1
#define	FRF_AZ_POST_WR_MASK_LBN 40
#define	FRF_AZ_POST_WR_MASK_WIDTH 4
#define	FRF_AZ_TLP_TC_LBN 34
#define	FRF_AZ_TLP_TC_WIDTH 3
#define	FRF_AZ_TLP_ATTR_LBN 32
#define	FRF_AZ_TLP_ATTR_WIDTH 2
#define	FRF_AB_INTB_VEC_LBN 24
#define	FRF_AB_INTB_VEC_WIDTH 5
#define	FRF_AB_INTA_VEC_LBN 16
#define	FRF_AB_INTA_VEC_WIDTH 5
#define	FRF_AZ_WD_TIMER_LBN 8
#define	FRF_AZ_WD_TIMER_WIDTH 8
#define	FRF_AZ_US_DISABLE_LBN 5
#define	FRF_AZ_US_DISABLE_WIDTH 1
#define	FRF_AZ_TLP_EP_LBN 4
#define	FRF_AZ_TLP_EP_WIDTH 1
#define	FRF_AZ_ATTR_SEL_LBN 3
#define	FRF_AZ_ATTR_SEL_WIDTH 1
#define	FRF_AZ_TD_SEL_LBN 1
#define	FRF_AZ_TD_SEL_WIDTH 1
#define	FRF_AZ_TLP_TD_LBN 0
#define	FRF_AZ_TLP_TD_WIDTH 1

/* EE_SPI_HCMD_REG: SPI host command register */
#define	FR_AB_EE_SPI_HCMD 0x00000100
#define	FRF_AB_EE_SPI_HCMD_CMD_EN_LBN 31
#define	FRF_AB_EE_SPI_HCMD_CMD_EN_WIDTH 1
#define	FRF_AB_EE_WR_TIMER_ACTIVE_LBN 28
#define	FRF_AB_EE_WR_TIMER_ACTIVE_WIDTH 1
#define	FRF_AB_EE_SPI_HCMD_SF_SEL_LBN 24
#define	FRF_AB_EE_SPI_HCMD_SF_SEL_WIDTH 1
#define	FRF_AB_EE_SPI_HCMD_DABCNT_LBN 16
#define	FRF_AB_EE_SPI_HCMD_DABCNT_WIDTH 5
#define	FRF_AB_EE_SPI_HCMD_READ_LBN 15
#define	FRF_AB_EE_SPI_HCMD_READ_WIDTH 1
#define	FRF_AB_EE_SPI_HCMD_DUBCNT_LBN 12
#define	FRF_AB_EE_SPI_HCMD_DUBCNT_WIDTH 2
#define	FRF_AB_EE_SPI_HCMD_ADBCNT_LBN 8
#define	FRF_AB_EE_SPI_HCMD_ADBCNT_WIDTH 2
#define	FRF_AB_EE_SPI_HCMD_ENC_LBN 0
#define	FRF_AB_EE_SPI_HCMD_ENC_WIDTH 8

/* USR_EV_CFG: User Level Event Configuration register */
#define	FR_CZ_USR_EV_CFG 0x00000100
#define	FRF_CZ_USREV_DIS_LBN 16
#define	FRF_CZ_USREV_DIS_WIDTH 1
#define	FRF_CZ_DFLT_EVQ_LBN 0
#define	FRF_CZ_DFLT_EVQ_WIDTH 10

/* EE_SPI_HADR_REG: SPI host address register */
#define	FR_AB_EE_SPI_HADR 0x00000110
#define	FRF_AB_EE_SPI_HADR_DUBYTE_LBN 24
#define	FRF_AB_EE_SPI_HADR_DUBYTE_WIDTH 8
#define	FRF_AB_EE_SPI_HADR_ADR_LBN 0
#define	FRF_AB_EE_SPI_HADR_ADR_WIDTH 24

/* EE_SPI_HDATA_REG: SPI host data register */
#define	FR_AB_EE_SPI_HDATA 0x00000120
#define	FRF_AB_EE_SPI_HDATA3_LBN 96
#define	FRF_AB_EE_SPI_HDATA3_WIDTH 32
#define	FRF_AB_EE_SPI_HDATA2_LBN 64
#define	FRF_AB_EE_SPI_HDATA2_WIDTH 32
#define	FRF_AB_EE_SPI_HDATA1_LBN 32
#define	FRF_AB_EE_SPI_HDATA1_WIDTH 32
#define	FRF_AB_EE_SPI_HDATA0_LBN 0
#define	FRF_AB_EE_SPI_HDATA0_WIDTH 32

/* EE_BASE_PAGE_REG: Expansion ROM base mirror register */
#define	FR_AB_EE_BASE_PAGE 0x00000130
#define	FRF_AB_EE_EXPROM_MASK_LBN 16
#define	FRF_AB_EE_EXPROM_MASK_WIDTH 13
#define	FRF_AB_EE_EXP_ROM_WINDOW_BASE_LBN 0
#define	FRF_AB_EE_EXP_ROM_WINDOW_BASE_WIDTH 13

/* EE_VPD_CFG0_REG: SPI/VPD configuration register 0 */
#define	FR_AB_EE_VPD_CFG0 0x00000140
#define	FRF_AB_EE_SF_FASTRD_EN_LBN 127
#define	FRF_AB_EE_SF_FASTRD_EN_WIDTH 1
#define	FRF_AB_EE_SF_CLOCK_DIV_LBN 120
#define	FRF_AB_EE_SF_CLOCK_DIV_WIDTH 7
#define	FRF_AB_EE_VPD_WIP_POLL_LBN 119
#define	FRF_AB_EE_VPD_WIP_POLL_WIDTH 1
#define	FRF_AB_EE_EE_CLOCK_DIV_LBN 112
#define	FRF_AB_EE_EE_CLOCK_DIV_WIDTH 7
#define	FRF_AB_EE_EE_WR_TMR_VALUE_LBN 96
#define	FRF_AB_EE_EE_WR_TMR_VALUE_WIDTH 16
#define	FRF_AB_EE_VPDW_LENGTH_LBN 80
#define	FRF_AB_EE_VPDW_LENGTH_WIDTH 15
#define	FRF_AB_EE_VPDW_BASE_LBN 64
#define	FRF_AB_EE_VPDW_BASE_WIDTH 15
#define	FRF_AB_EE_VPD_WR_CMD_EN_LBN 56
#define	FRF_AB_EE_VPD_WR_CMD_EN_WIDTH 8
#define	FRF_AB_EE_VPD_BASE_LBN 32
#define	FRF_AB_EE_VPD_BASE_WIDTH 24
#define	FRF_AB_EE_VPD_LENGTH_LBN 16
#define	FRF_AB_EE_VPD_LENGTH_WIDTH 15
#define	FRF_AB_EE_VPD_AD_SIZE_LBN 8
#define	FRF_AB_EE_VPD_AD_SIZE_WIDTH 5
#define	FRF_AB_EE_VPD_ACCESS_ON_LBN 5
#define	FRF_AB_EE_VPD_ACCESS_ON_WIDTH 1
#define	FRF_AB_EE_VPD_ACCESS_BLOCK_LBN 4
#define	FRF_AB_EE_VPD_ACCESS_BLOCK_WIDTH 1
#define	FRF_AB_EE_VPD_DEV_SF_SEL_LBN 2
#define	FRF_AB_EE_VPD_DEV_SF_SEL_WIDTH 1
#define	FRF_AB_EE_VPD_EN_AD9_MODE_LBN 1
#define	FRF_AB_EE_VPD_EN_AD9_MODE_WIDTH 1
#define	FRF_AB_EE_VPD_EN_LBN 0
#define	FRF_AB_EE_VPD_EN_WIDTH 1

/* EE_VPD_SW_CNTL_REG: VPD access SW control register */
#define	FR_AB_EE_VPD_SW_CNTL 0x00000150
#define	FRF_AB_EE_VPD_CYCLE_PENDING_LBN 31
#define	FRF_AB_EE_VPD_CYCLE_PENDING_WIDTH 1
#define	FRF_AB_EE_VPD_CYC_WRITE_LBN 28
#define	FRF_AB_EE_VPD_CYC_WRITE_WIDTH 1
#define	FRF_AB_EE_VPD_CYC_ADR_LBN 0
#define	FRF_AB_EE_VPD_CYC_ADR_WIDTH 15

/* EE_VPD_SW_DATA_REG: VPD access SW data register */
#define	FR_AB_EE_VPD_SW_DATA 0x00000160
#define	FRF_AB_EE_VPD_CYC_DAT_LBN 0
#define	FRF_AB_EE_VPD_CYC_DAT_WIDTH 32

/* PBMX_DBG_IADDR_REG: Capture Module address register */
#define	FR_CZ_PBMX_DBG_IADDR 0x000001f0
#define	FRF_CZ_PBMX_DBG_IADDR_LBN 0
#define	FRF_CZ_PBMX_DBG_IADDR_WIDTH 32

/* PCIE_CORE_INDIRECT_REG: Indirect Access to PCIE Core registers */
#define	FR_BB_PCIE_CORE_INDIRECT 0x000001f0
#define	FRF_BB_PCIE_CORE_TARGET_DATA_LBN 32
#define	FRF_BB_PCIE_CORE_TARGET_DATA_WIDTH 32
#define	FRF_BB_PCIE_CORE_INDIRECT_ACCESS_DIR_LBN 15
#define	FRF_BB_PCIE_CORE_INDIRECT_ACCESS_DIR_WIDTH 1
#define	FRF_BB_PCIE_CORE_TARGET_REG_ADRS_LBN 0
#define	FRF_BB_PCIE_CORE_TARGET_REG_ADRS_WIDTH 12

/* PBMX_DBG_IDATA_REG: Capture Module data register */
#define	FR_CZ_PBMX_DBG_IDATA 0x000001f8
#define	FRF_CZ_PBMX_DBG_IDATA_LBN 0
#define	FRF_CZ_PBMX_DBG_IDATA_WIDTH 64

/* NIC_STAT_REG: NIC status register */
#define	FR_AB_NIC_STAT 0x00000200
#define	FRF_BB_AER_DIS_LBN 34
#define	FRF_BB_AER_DIS_WIDTH 1
#define	FRF_BB_EE_STRAP_EN_LBN 31
#define	FRF_BB_EE_STRAP_EN_WIDTH 1
#define	FRF_BB_EE_STRAP_LBN 24
#define	FRF_BB_EE_STRAP_WIDTH 4
#define	FRF_BB_REVISION_ID_LBN 17
#define	FRF_BB_REVISION_ID_WIDTH 7
#define	FRF_AB_ONCHIP_SRAM_LBN 16
#define	FRF_AB_ONCHIP_SRAM_WIDTH 1
#define	FRF_AB_SF_PRST_LBN 9
#define	FRF_AB_SF_PRST_WIDTH 1
#define	FRF_AB_EE_PRST_LBN 8
#define	FRF_AB_EE_PRST_WIDTH 1
#define	FRF_AB_ATE_MODE_LBN 3
#define	FRF_AB_ATE_MODE_WIDTH 1
#define	FRF_AB_STRAP_PINS_LBN 0
#define	FRF_AB_STRAP_PINS_WIDTH 3

/* GPIO_CTL_REG: GPIO control register */
#define	FR_AB_GPIO_CTL 0x00000210
#define	FRF_AB_GPIO_OUT3_LBN 112
#define	FRF_AB_GPIO_OUT3_WIDTH 16
#define	FRF_AB_GPIO_IN3_LBN 104
#define	FRF_AB_GPIO_IN3_WIDTH 8
#define	FRF_AB_GPIO_PWRUP_VALUE3_LBN 96
#define	FRF_AB_GPIO_PWRUP_VALUE3_WIDTH 8
#define	FRF_AB_GPIO_OUT2_LBN 80
#define	FRF_AB_GPIO_OUT2_WIDTH 16
#define	FRF_AB_GPIO_IN2_LBN 72
#define	FRF_AB_GPIO_IN2_WIDTH 8
#define	FRF_AB_GPIO_PWRUP_VALUE2_LBN 64
#define	FRF_AB_GPIO_PWRUP_VALUE2_WIDTH 8
#define	FRF_AB_GPIO15_OEN_LBN 63
#define	FRF_AB_GPIO15_OEN_WIDTH 1
#define	FRF_AB_GPIO14_OEN_LBN 62
#define	FRF_AB_GPIO14_OEN_WIDTH 1
#define	FRF_AB_GPIO13_OEN_LBN 61
#define	FRF_AB_GPIO13_OEN_WIDTH 1
#define	FRF_AB_GPIO12_OEN_LBN 60
#define	FRF_AB_GPIO12_OEN_WIDTH 1
#define	FRF_AB_GPIO11_OEN_LBN 59
#define	FRF_AB_GPIO11_OEN_WIDTH 1
#define	FRF_AB_GPIO10_OEN_LBN 58
#define	FRF_AB_GPIO10_OEN_WIDTH 1
#define	FRF_AB_GPIO9_OEN_LBN 57
#define	FRF_AB_GPIO9_OEN_WIDTH 1
#define	FRF_AB_GPIO8_OEN_LBN 56
#define	FRF_AB_GPIO8_OEN_WIDTH 1
#define	FRF_AB_GPIO15_OUT_LBN 55
#define	FRF_AB_GPIO15_OUT_WIDTH 1
#define	FRF_AB_GPIO14_OUT_LBN 54
#define	FRF_AB_GPIO14_OUT_WIDTH 1
#define	FRF_AB_GPIO13_OUT_LBN 53
#define	FRF_AB_GPIO13_OUT_WIDTH 1
#define	FRF_AB_GPIO12_OUT_LBN 52
#define	FRF_AB_GPIO12_OUT_WIDTH 1
#define	FRF_AB_GPIO11_OUT_LBN 51
#define	FRF_AB_GPIO11_OUT_WIDTH 1
#define	FRF_AB_GPIO10_OUT_LBN 50
#define	FRF_AB_GPIO10_OUT_WIDTH 1
#define	FRF_AB_GPIO9_OUT_LBN 49
#define	FRF_AB_GPIO9_OUT_WIDTH 1
#define	FRF_AB_GPIO8_OUT_LBN 48
#define	FRF_AB_GPIO8_OUT_WIDTH 1
#define	FRF_AB_GPIO15_IN_LBN 47
#define	FRF_AB_GPIO15_IN_WIDTH 1
#define	FRF_AB_GPIO14_IN_LBN 46
#define	FRF_AB_GPIO14_IN_WIDTH 1
#define	FRF_AB_GPIO13_IN_LBN 45
#define	FRF_AB_GPIO13_IN_WIDTH 1
#define	FRF_AB_GPIO12_IN_LBN 44
#define	FRF_AB_GPIO12_IN_WIDTH 1
#define	FRF_AB_GPIO11_IN_LBN 43
#define	FRF_AB_GPIO11_IN_WIDTH 1
#define	FRF_AB_GPIO10_IN_LBN 42
#define	FRF_AB_GPIO10_IN_WIDTH 1
#define	FRF_AB_GPIO9_IN_LBN 41
#define	FRF_AB_GPIO9_IN_WIDTH 1
#define	FRF_AB_GPIO8_IN_LBN 40
#define	FRF_AB_GPIO8_IN_WIDTH 1
#define	FRF_AB_GPIO15_PWRUP_VALUE_LBN 39
#define	FRF_AB_GPIO15_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO14_PWRUP_VALUE_LBN 38
#define	FRF_AB_GPIO14_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO13_PWRUP_VALUE_LBN 37
#define	FRF_AB_GPIO13_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO12_PWRUP_VALUE_LBN 36
#define	FRF_AB_GPIO12_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO11_PWRUP_VALUE_LBN 35
#define	FRF_AB_GPIO11_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO10_PWRUP_VALUE_LBN 34
#define	FRF_AB_GPIO10_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO9_PWRUP_VALUE_LBN 33
#define	FRF_AB_GPIO9_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO8_PWRUP_VALUE_LBN 32
#define	FRF_AB_GPIO8_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_CLK156_OUT_EN_LBN 31
#define	FRF_AB_CLK156_OUT_EN_WIDTH 1
#define	FRF_AB_USE_NIC_CLK_LBN 30
#define	FRF_AB_USE_NIC_CLK_WIDTH 1
#define	FRF_AB_GPIO5_OEN_LBN 29
#define	FRF_AB_GPIO5_OEN_WIDTH 1
#define	FRF_AB_GPIO4_OEN_LBN 28
#define	FRF_AB_GPIO4_OEN_WIDTH 1
#define	FRF_AB_GPIO3_OEN_LBN 27
#define	FRF_AB_GPIO3_OEN_WIDTH 1
#define	FRF_AB_GPIO2_OEN_LBN 26
#define	FRF_AB_GPIO2_OEN_WIDTH 1
#define	FRF_AB_GPIO1_OEN_LBN 25
#define	FRF_AB_GPIO1_OEN_WIDTH 1
#define	FRF_AB_GPIO0_OEN_LBN 24
#define	FRF_AB_GPIO0_OEN_WIDTH 1
#define	FRF_AB_GPIO7_OUT_LBN 23
#define	FRF_AB_GPIO7_OUT_WIDTH 1
#define	FRF_AB_GPIO6_OUT_LBN 22
#define	FRF_AB_GPIO6_OUT_WIDTH 1
#define	FRF_AB_GPIO5_OUT_LBN 21
#define	FRF_AB_GPIO5_OUT_WIDTH 1
#define	FRF_AB_GPIO4_OUT_LBN 20
#define	FRF_AB_GPIO4_OUT_WIDTH 1
#define	FRF_AB_GPIO3_OUT_LBN 19
#define	FRF_AB_GPIO3_OUT_WIDTH 1
#define	FRF_AB_GPIO2_OUT_LBN 18
#define	FRF_AB_GPIO2_OUT_WIDTH 1
#define	FRF_AB_GPIO1_OUT_LBN 17
#define	FRF_AB_GPIO1_OUT_WIDTH 1
#define	FRF_AB_GPIO0_OUT_LBN 16
#define	FRF_AB_GPIO0_OUT_WIDTH 1
#define	FRF_AB_GPIO7_IN_LBN 15
#define	FRF_AB_GPIO7_IN_WIDTH 1
#define	FRF_AB_GPIO6_IN_LBN 14
#define	FRF_AB_GPIO6_IN_WIDTH 1
#define	FRF_AB_GPIO5_IN_LBN 13
#define	FRF_AB_GPIO5_IN_WIDTH 1
#define	FRF_AB_GPIO4_IN_LBN 12
#define	FRF_AB_GPIO4_IN_WIDTH 1
#define	FRF_AB_GPIO3_IN_LBN 11
#define	FRF_AB_GPIO3_IN_WIDTH 1
#define	FRF_AB_GPIO2_IN_LBN 10
#define	FRF_AB_GPIO2_IN_WIDTH 1
#define	FRF_AB_GPIO1_IN_LBN 9
#define	FRF_AB_GPIO1_IN_WIDTH 1
#define	FRF_AB_GPIO0_IN_LBN 8
#define	FRF_AB_GPIO0_IN_WIDTH 1
#define	FRF_AB_GPIO7_PWRUP_VALUE_LBN 7
#define	FRF_AB_GPIO7_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO6_PWRUP_VALUE_LBN 6
#define	FRF_AB_GPIO6_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO5_PWRUP_VALUE_LBN 5
#define	FRF_AB_GPIO5_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO4_PWRUP_VALUE_LBN 4
#define	FRF_AB_GPIO4_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO3_PWRUP_VALUE_LBN 3
#define	FRF_AB_GPIO3_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO2_PWRUP_VALUE_LBN 2
#define	FRF_AB_GPIO2_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO1_PWRUP_VALUE_LBN 1
#define	FRF_AB_GPIO1_PWRUP_VALUE_WIDTH 1
#define	FRF_AB_GPIO0_PWRUP_VALUE_LBN 0
#define	FRF_AB_GPIO0_PWRUP_VALUE_WIDTH 1

/* GLB_CTL_REG: Global control register */
#define	FR_AB_GLB_CTL 0x00000220
#define	FRF_AB_EXT_PHY_RST_CTL_LBN 63
#define	FRF_AB_EXT_PHY_RST_CTL_WIDTH 1
#define	FRF_AB_XAUI_SD_RST_CTL_LBN 62
#define	FRF_AB_XAUI_SD_RST_CTL_WIDTH 1
#define	FRF_AB_PCIE_SD_RST_CTL_LBN 61
#define	FRF_AB_PCIE_SD_RST_CTL_WIDTH 1
#define	FRF_AA_PCIX_RST_CTL_LBN 60
#define	FRF_AA_PCIX_RST_CTL_WIDTH 1
#define	FRF_BB_BIU_RST_CTL_LBN 60
#define	FRF_BB_BIU_RST_CTL_WIDTH 1
#define	FRF_AB_PCIE_STKY_RST_CTL_LBN 59
#define	FRF_AB_PCIE_STKY_RST_CTL_WIDTH 1
#define	FRF_AB_PCIE_NSTKY_RST_CTL_LBN 58
#define	FRF_AB_PCIE_NSTKY_RST_CTL_WIDTH 1
#define	FRF_AB_PCIE_CORE_RST_CTL_LBN 57
#define	FRF_AB_PCIE_CORE_RST_CTL_WIDTH 1
#define	FRF_AB_XGRX_RST_CTL_LBN 56
#define	FRF_AB_XGRX_RST_CTL_WIDTH 1
#define	FRF_AB_XGTX_RST_CTL_LBN 55
#define	FRF_AB_XGTX_RST_CTL_WIDTH 1
#define	FRF_AB_EM_RST_CTL_LBN 54
#define	FRF_AB_EM_RST_CTL_WIDTH 1
#define	FRF_AB_EV_RST_CTL_LBN 53
#define	FRF_AB_EV_RST_CTL_WIDTH 1
#define	FRF_AB_SR_RST_CTL_LBN 52
#define	FRF_AB_SR_RST_CTL_WIDTH 1
#define	FRF_AB_RX_RST_CTL_LBN 51
#define	FRF_AB_RX_RST_CTL_WIDTH 1
#define	FRF_AB_TX_RST_CTL_LBN 50
#define	FRF_AB_TX_RST_CTL_WIDTH 1
#define	FRF_AB_EE_RST_CTL_LBN 49
#define	FRF_AB_EE_RST_CTL_WIDTH 1
#define	FRF_AB_CS_RST_CTL_LBN 48
#define	FRF_AB_CS_RST_CTL_WIDTH 1
#define	FRF_AB_HOT_RST_CTL_LBN 40
#define	FRF_AB_HOT_RST_CTL_WIDTH 2
#define	FRF_AB_RST_EXT_PHY_LBN 31
#define	FRF_AB_RST_EXT_PHY_WIDTH 1
#define	FRF_AB_RST_XAUI_SD_LBN 30
#define	FRF_AB_RST_XAUI_SD_WIDTH 1
#define	FRF_AB_RST_PCIE_SD_LBN 29
#define	FRF_AB_RST_PCIE_SD_WIDTH 1
#define	FRF_AA_RST_PCIX_LBN 28
#define	FRF_AA_RST_PCIX_WIDTH 1
#define	FRF_BB_RST_BIU_LBN 28
#define	FRF_BB_RST_BIU_WIDTH 1
#define	FRF_AB_RST_PCIE_STKY_LBN 27
#define	FRF_AB_RST_PCIE_STKY_WIDTH 1
#define	FRF_AB_RST_PCIE_NSTKY_LBN 26
#define	FRF_AB_RST_PCIE_NSTKY_WIDTH 1
#define	FRF_AB_RST_PCIE_CORE_LBN 25
#define	FRF_AB_RST_PCIE_CORE_WIDTH 1
#define	FRF_AB_RST_XGRX_LBN 24
#define	FRF_AB_RST_XGRX_WIDTH 1
#define	FRF_AB_RST_XGTX_LBN 23
#define	FRF_AB_RST_XGTX_WIDTH 1
#define	FRF_AB_RST_EM_LBN 22
#define	FRF_AB_RST_EM_WIDTH 1
#define	FRF_AB_RST_EV_LBN 21
#define	FRF_AB_RST_EV_WIDTH 1
#define	FRF_AB_RST_SR_LBN 20
#define	FRF_AB_RST_SR_WIDTH 1
#define	FRF_AB_RST_RX_LBN 19
#define	FRF_AB_RST_RX_WIDTH 1
#define	FRF_AB_RST_TX_LBN 18
#define	FRF_AB_RST_TX_WIDTH 1
#define	FRF_AB_RST_SF_LBN 17
#define	FRF_AB_RST_SF_WIDTH 1
#define	FRF_AB_RST_CS_LBN 16
#define	FRF_AB_RST_CS_WIDTH 1
#define	FRF_AB_INT_RST_DUR_LBN 4
#define	FRF_AB_INT_RST_DUR_WIDTH 3
#define	FRF_AB_EXT_PHY_RST_DUR_LBN 1
#define	FRF_AB_EXT_PHY_RST_DUR_WIDTH 3
#define	FFE_AB_EXT_PHY_RST_DUR_10240US 7
#define	FFE_AB_EXT_PHY_RST_DUR_5120US 6
#define	FFE_AB_EXT_PHY_RST_DUR_2560US 5
#define	FFE_AB_EXT_PHY_RST_DUR_1280US 4
#define	FFE_AB_EXT_PHY_RST_DUR_640US 3
#define	FFE_AB_EXT_PHY_RST_DUR_320US 2
#define	FFE_AB_EXT_PHY_RST_DUR_160US 1
#define	FFE_AB_EXT_PHY_RST_DUR_80US 0
#define	FRF_AB_SWRST_LBN 0
#define	FRF_AB_SWRST_WIDTH 1

/* FATAL_INTR_REG_KER: Fatal interrupt register for Kernel */
#define	FR_AZ_FATAL_INTR_KER 0x00000230
#define	FRF_CZ_SRAM_PERR_INT_P_KER_EN_LBN 44
#define	FRF_CZ_SRAM_PERR_INT_P_KER_EN_WIDTH 1
#define	FRF_AB_PCI_BUSERR_INT_KER_EN_LBN 43
#define	FRF_AB_PCI_BUSERR_INT_KER_EN_WIDTH 1
#define	FRF_CZ_MBU_PERR_INT_KER_EN_LBN 43
#define	FRF_CZ_MBU_PERR_INT_KER_EN_WIDTH 1
#define	FRF_AZ_SRAM_OOB_INT_KER_EN_LBN 42
#define	FRF_AZ_SRAM_OOB_INT_KER_EN_WIDTH 1
#define	FRF_AZ_BUFID_OOB_INT_KER_EN_LBN 41
#define	FRF_AZ_BUFID_OOB_INT_KER_EN_WIDTH 1
#define	FRF_AZ_MEM_PERR_INT_KER_EN_LBN 40
#define	FRF_AZ_MEM_PERR_INT_KER_EN_WIDTH 1
#define	FRF_AZ_RBUF_OWN_INT_KER_EN_LBN 39
#define	FRF_AZ_RBUF_OWN_INT_KER_EN_WIDTH 1
#define	FRF_AZ_TBUF_OWN_INT_KER_EN_LBN 38
#define	FRF_AZ_TBUF_OWN_INT_KER_EN_WIDTH 1
#define	FRF_AZ_RDESCQ_OWN_INT_KER_EN_LBN 37
#define	FRF_AZ_RDESCQ_OWN_INT_KER_EN_WIDTH 1
#define	FRF_AZ_TDESCQ_OWN_INT_KER_EN_LBN 36
#define	FRF_AZ_TDESCQ_OWN_INT_KER_EN_WIDTH 1
#define	FRF_AZ_EVQ_OWN_INT_KER_EN_LBN 35
#define	FRF_AZ_EVQ_OWN_INT_KER_EN_WIDTH 1
#define	FRF_AZ_EVF_OFLO_INT_KER_EN_LBN 34
#define	FRF_AZ_EVF_OFLO_INT_KER_EN_WIDTH 1
#define	FRF_AZ_ILL_ADR_INT_KER_EN_LBN 33
#define	FRF_AZ_ILL_ADR_INT_KER_EN_WIDTH 1
#define	FRF_AZ_SRM_PERR_INT_KER_EN_LBN 32
#define	FRF_AZ_SRM_PERR_INT_KER_EN_WIDTH 1
#define	FRF_CZ_SRAM_PERR_INT_P_KER_LBN 12
#define	FRF_CZ_SRAM_PERR_INT_P_KER_WIDTH 1
#define	FRF_AB_PCI_BUSERR_INT_KER_LBN 11
#define	FRF_AB_PCI_BUSERR_INT_KER_WIDTH 1
#define	FRF_CZ_MBU_PERR_INT_KER_LBN 11
#define	FRF_CZ_MBU_PERR_INT_KER_WIDTH 1
#define	FRF_AZ_SRAM_OOB_INT_KER_LBN 10
#define	FRF_AZ_SRAM_OOB_INT_KER_WIDTH 1
#define	FRF_AZ_BUFID_DC_OOB_INT_KER_LBN 9
#define	FRF_AZ_BUFID_DC_OOB_INT_KER_WIDTH 1
#define	FRF_AZ_MEM_PERR_INT_KER_LBN 8
#define	FRF_AZ_MEM_PERR_INT_KER_WIDTH 1
#define	FRF_AZ_RBUF_OWN_INT_KER_LBN 7
#define	FRF_AZ_RBUF_OWN_INT_KER_WIDTH 1
#define	FRF_AZ_TBUF_OWN_INT_KER_LBN 6
#define	FRF_AZ_TBUF_OWN_INT_KER_WIDTH 1
#define	FRF_AZ_RDESCQ_OWN_INT_KER_LBN 5
#define	FRF_AZ_RDESCQ_OWN_INT_KER_WIDTH 1
#define	FRF_AZ_TDESCQ_OWN_INT_KER_LBN 4
#define	FRF_AZ_TDESCQ_OWN_INT_KER_WIDTH 1
#define	FRF_AZ_EVQ_OWN_INT_KER_LBN 3
#define	FRF_AZ_EVQ_OWN_INT_KER_WIDTH 1
#define	FRF_AZ_EVF_OFLO_INT_KER_LBN 2
#define	FRF_AZ_EVF_OFLO_INT_KER_WIDTH 1
#define	FRF_AZ_ILL_ADR_INT_KER_LBN 1
#define	FRF_AZ_ILL_ADR_INT_KER_WIDTH 1
#define	FRF_AZ_SRM_PERR_INT_KER_LBN 0
#define	FRF_AZ_SRM_PERR_INT_KER_WIDTH 1

/* FATAL_INTR_REG_CHAR: Fatal interrupt register for Char */
#define	FR_BZ_FATAL_INTR_CHAR 0x00000240
#define	FRF_CZ_SRAM_PERR_INT_P_CHAR_EN_LBN 44
#define	FRF_CZ_SRAM_PERR_INT_P_CHAR_EN_WIDTH 1
#define	FRF_BB_PCI_BUSERR_INT_CHAR_EN_LBN 43
#define	FRF_BB_PCI_BUSERR_INT_CHAR_EN_WIDTH 1
#define	FRF_CZ_MBU_PERR_INT_CHAR_EN_LBN 43
#define	FRF_CZ_MBU_PERR_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_SRAM_OOB_INT_CHAR_EN_LBN 42
#define	FRF_BZ_SRAM_OOB_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_BUFID_OOB_INT_CHAR_EN_LBN 41
#define	FRF_BZ_BUFID_OOB_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_MEM_PERR_INT_CHAR_EN_LBN 40
#define	FRF_BZ_MEM_PERR_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_RBUF_OWN_INT_CHAR_EN_LBN 39
#define	FRF_BZ_RBUF_OWN_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_TBUF_OWN_INT_CHAR_EN_LBN 38
#define	FRF_BZ_TBUF_OWN_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_RDESCQ_OWN_INT_CHAR_EN_LBN 37
#define	FRF_BZ_RDESCQ_OWN_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_TDESCQ_OWN_INT_CHAR_EN_LBN 36
#define	FRF_BZ_TDESCQ_OWN_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_EVQ_OWN_INT_CHAR_EN_LBN 35
#define	FRF_BZ_EVQ_OWN_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_EVF_OFLO_INT_CHAR_EN_LBN 34
#define	FRF_BZ_EVF_OFLO_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_ILL_ADR_INT_CHAR_EN_LBN 33
#define	FRF_BZ_ILL_ADR_INT_CHAR_EN_WIDTH 1
#define	FRF_BZ_SRM_PERR_INT_CHAR_EN_LBN 32
#define	FRF_BZ_SRM_PERR_INT_CHAR_EN_WIDTH 1
#define	FRF_CZ_SRAM_PERR_INT_P_CHAR_LBN 12
#define	FRF_CZ_SRAM_PERR_INT_P_CHAR_WIDTH 1
#define	FRF_BB_PCI_BUSERR_INT_CHAR_LBN 11
#define	FRF_BB_PCI_BUSERR_INT_CHAR_WIDTH 1
#define	FRF_CZ_MBU_PERR_INT_CHAR_LBN 11
#define	FRF_CZ_MBU_PERR_INT_CHAR_WIDTH 1
#define	FRF_BZ_SRAM_OOB_INT_CHAR_LBN 10
#define	FRF_BZ_SRAM_OOB_INT_CHAR_WIDTH 1
#define	FRF_BZ_BUFID_DC_OOB_INT_CHAR_LBN 9
#define	FRF_BZ_BUFID_DC_OOB_INT_CHAR_WIDTH 1
#define	FRF_BZ_MEM_PERR_INT_CHAR_LBN 8
#define	FRF_BZ_MEM_PERR_INT_CHAR_WIDTH 1
#define	FRF_BZ_RBUF_OWN_INT_CHAR_LBN 7
#define	FRF_BZ_RBUF_OWN_INT_CHAR_WIDTH 1
#define	FRF_BZ_TBUF_OWN_INT_CHAR_LBN 6
#define	FRF_BZ_TBUF_OWN_INT_CHAR_WIDTH 1
#define	FRF_BZ_RDESCQ_OWN_INT_CHAR_LBN 5
#define	FRF_BZ_RDESCQ_OWN_INT_CHAR_WIDTH 1
#define	FRF_BZ_TDESCQ_OWN_INT_CHAR_LBN 4
#define	FRF_BZ_TDESCQ_OWN_INT_CHAR_WIDTH 1
#define	FRF_BZ_EVQ_OWN_INT_CHAR_LBN 3
#define	FRF_BZ_EVQ_OWN_INT_CHAR_WIDTH 1
#define	FRF_BZ_EVF_OFLO_INT_CHAR_LBN 2
#define	FRF_BZ_EVF_OFLO_INT_CHAR_WIDTH 1
#define	FRF_BZ_ILL_ADR_INT_CHAR_LBN 1
#define	FRF_BZ_ILL_ADR_INT_CHAR_WIDTH 1
#define	FRF_BZ_SRM_PERR_INT_CHAR_LBN 0
#define	FRF_BZ_SRM_PERR_INT_CHAR_WIDTH 1

/* DP_CTRL_REG: Datapath control register */
#define	FR_BZ_DP_CTRL 0x00000250
#define	FRF_BZ_FLS_EVQ_ID_LBN 0
#define	FRF_BZ_FLS_EVQ_ID_WIDTH 12

/* MEM_STAT_REG: Memory status register */
#define	FR_AZ_MEM_STAT 0x00000260
#define	FRF_AB_MEM_PERR_VEC_LBN 53
#define	FRF_AB_MEM_PERR_VEC_WIDTH 38
#define	FRF_AB_MBIST_CORR_LBN 38
#define	FRF_AB_MBIST_CORR_WIDTH 15
#define	FRF_AB_MBIST_ERR_LBN 0
#define	FRF_AB_MBIST_ERR_WIDTH 40
#define	FRF_CZ_MEM_PERR_VEC_LBN 0
#define	FRF_CZ_MEM_PERR_VEC_WIDTH 35

/* CS_DEBUG_REG: Debug register */
#define	FR_AZ_CS_DEBUG 0x00000270
#define	FRF_AB_GLB_DEBUG2_SEL_LBN 50
#define	FRF_AB_GLB_DEBUG2_SEL_WIDTH 3
#define	FRF_AB_DEBUG_BLK_SEL2_LBN 47
#define	FRF_AB_DEBUG_BLK_SEL2_WIDTH 3
#define	FRF_AB_DEBUG_BLK_SEL1_LBN 44
#define	FRF_AB_DEBUG_BLK_SEL1_WIDTH 3
#define	FRF_AB_DEBUG_BLK_SEL0_LBN 41
#define	FRF_AB_DEBUG_BLK_SEL0_WIDTH 3
#define	FRF_CZ_CS_PORT_NUM_LBN 40
#define	FRF_CZ_CS_PORT_NUM_WIDTH 2
#define	FRF_AB_MISC_DEBUG_ADDR_LBN 36
#define	FRF_AB_MISC_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_SERDES_DEBUG_ADDR_LBN 31
#define	FRF_AB_SERDES_DEBUG_ADDR_WIDTH 5
#define	FRF_CZ_CS_PORT_FPE_LBN 1
#define	FRF_CZ_CS_PORT_FPE_WIDTH 35
#define	FRF_AB_EM_DEBUG_ADDR_LBN 26
#define	FRF_AB_EM_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_SR_DEBUG_ADDR_LBN 21
#define	FRF_AB_SR_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_EV_DEBUG_ADDR_LBN 16
#define	FRF_AB_EV_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_RX_DEBUG_ADDR_LBN 11
#define	FRF_AB_RX_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_TX_DEBUG_ADDR_LBN 6
#define	FRF_AB_TX_DEBUG_ADDR_WIDTH 5
#define	FRF_AB_CS_BIU_DEBUG_ADDR_LBN 1
#define	FRF_AB_CS_BIU_DEBUG_ADDR_WIDTH 5
#define	FRF_AZ_CS_DEBUG_EN_LBN 0
#define	FRF_AZ_CS_DEBUG_EN_WIDTH 1

/* DRIVER_REG: Driver scratch register [0-7] */
#define	FR_AZ_DRIVER 0x00000280
#define	FR_AZ_DRIVER_STEP 16
#define	FR_AZ_DRIVER_ROWS 8
#define	FRF_AZ_DRIVER_DW0_LBN 0
#define	FRF_AZ_DRIVER_DW0_WIDTH 32

/* ALTERA_BUILD_REG: Altera build register */
#define	FR_AZ_ALTERA_BUILD 0x00000300
#define	FRF_AZ_ALTERA_BUILD_VER_LBN 0
#define	FRF_AZ_ALTERA_BUILD_VER_WIDTH 32

/* CSR_SPARE_REG: Spare register */
#define	FR_AZ_CSR_SPARE 0x00000310
#define	FRF_AB_MEM_PERR_EN_LBN 64
#define	FRF_AB_MEM_PERR_EN_WIDTH 38
#define	FRF_CZ_MEM_PERR_EN_LBN 64
#define	FRF_CZ_MEM_PERR_EN_WIDTH 35
#define	FRF_AB_MEM_PERR_EN_TX_DATA_LBN 72
#define	FRF_AB_MEM_PERR_EN_TX_DATA_WIDTH 2
#define	FRF_AZ_CSR_SPARE_BITS_LBN 0
#define	FRF_AZ_CSR_SPARE_BITS_WIDTH 32

/* PCIE_SD_CTL0123_REG: PCIE SerDes control register 0 to 3 */
#define	FR_AB_PCIE_SD_CTL0123 0x00000320
#define	FRF_AB_PCIE_TESTSIG_H_LBN 96
#define	FRF_AB_PCIE_TESTSIG_H_WIDTH 19
#define	FRF_AB_PCIE_TESTSIG_L_LBN 64
#define	FRF_AB_PCIE_TESTSIG_L_WIDTH 19
#define	FRF_AB_PCIE_OFFSET_LBN 56
#define	FRF_AB_PCIE_OFFSET_WIDTH 8
#define	FRF_AB_PCIE_OFFSETEN_H_LBN 55
#define	FRF_AB_PCIE_OFFSETEN_H_WIDTH 1
#define	FRF_AB_PCIE_OFFSETEN_L_LBN 54
#define	FRF_AB_PCIE_OFFSETEN_L_WIDTH 1
#define	FRF_AB_PCIE_HIVMODE_H_LBN 53
#define	FRF_AB_PCIE_HIVMODE_H_WIDTH 1
#define	FRF_AB_PCIE_HIVMODE_L_LBN 52
#define	FRF_AB_PCIE_HIVMODE_L_WIDTH 1
#define	FRF_AB_PCIE_PARRESET_H_LBN 51
#define	FRF_AB_PCIE_PARRESET_H_WIDTH 1
#define	FRF_AB_PCIE_PARRESET_L_LBN 50
#define	FRF_AB_PCIE_PARRESET_L_WIDTH 1
#define	FRF_AB_PCIE_LPBKWDRV_H_LBN 49
#define	FRF_AB_PCIE_LPBKWDRV_H_WIDTH 1
#define	FRF_AB_PCIE_LPBKWDRV_L_LBN 48
#define	FRF_AB_PCIE_LPBKWDRV_L_WIDTH 1
#define	FRF_AB_PCIE_LPBK_LBN 40
#define	FRF_AB_PCIE_LPBK_WIDTH 8
#define	FRF_AB_PCIE_PARLPBK_LBN 32
#define	FRF_AB_PCIE_PARLPBK_WIDTH 8
#define	FRF_AB_PCIE_RXTERMADJ_H_LBN 30
#define	FRF_AB_PCIE_RXTERMADJ_H_WIDTH 2
#define	FRF_AB_PCIE_RXTERMADJ_L_LBN 28
#define	FRF_AB_PCIE_RXTERMADJ_L_WIDTH 2
#define	FFE_AB_PCIE_RXTERMADJ_MIN15PCNT 3
#define	FFE_AB_PCIE_RXTERMADJ_PL10PCNT 2
#define	FFE_AB_PCIE_RXTERMADJ_MIN17PCNT 1
#define	FFE_AB_PCIE_RXTERMADJ_NOMNL 0
#define	FRF_AB_PCIE_TXTERMADJ_H_LBN 26
#define	FRF_AB_PCIE_TXTERMADJ_H_WIDTH 2
#define	FRF_AB_PCIE_TXTERMADJ_L_LBN 24
#define	FRF_AB_PCIE_TXTERMADJ_L_WIDTH 2
#define	FFE_AB_PCIE_TXTERMADJ_MIN15PCNT 3
#define	FFE_AB_PCIE_TXTERMADJ_PL10PCNT 2
#define	FFE_AB_PCIE_TXTERMADJ_MIN17PCNT 1
#define	FFE_AB_PCIE_TXTERMADJ_NOMNL 0
#define	FRF_AB_PCIE_RXEQCTL_H_LBN 18
#define	FRF_AB_PCIE_RXEQCTL_H_WIDTH 2
#define	FRF_AB_PCIE_RXEQCTL_L_LBN 16
#define	FRF_AB_PCIE_RXEQCTL_L_WIDTH 2
#define	FFE_AB_PCIE_RXEQCTL_OFF_ALT 3
#define	FFE_AB_PCIE_RXEQCTL_OFF 2
#define	FFE_AB_PCIE_RXEQCTL_MIN 1
#define	FFE_AB_PCIE_RXEQCTL_MAX 0
#define	FRF_AB_PCIE_HIDRV_LBN 8
#define	FRF_AB_PCIE_HIDRV_WIDTH 8
#define	FRF_AB_PCIE_LODRV_LBN 0
#define	FRF_AB_PCIE_LODRV_WIDTH 8

/* PCIE_SD_CTL45_REG: PCIE SerDes control register 4 and 5 */
#define	FR_AB_PCIE_SD_CTL45 0x00000330
#define	FRF_AB_PCIE_DTX7_LBN 60
#define	FRF_AB_PCIE_DTX7_WIDTH 4
#define	FRF_AB_PCIE_DTX6_LBN 56
#define	FRF_AB_PCIE_DTX6_WIDTH 4
#define	FRF_AB_PCIE_DTX5_LBN 52
#define	FRF_AB_PCIE_DTX5_WIDTH 4
#define	FRF_AB_PCIE_DTX4_LBN 48
#define	FRF_AB_PCIE_DTX4_WIDTH 4
#define	FRF_AB_PCIE_DTX3_LBN 44
#define	FRF_AB_PCIE_DTX3_WIDTH 4
#define	FRF_AB_PCIE_DTX2_LBN 40
#define	FRF_AB_PCIE_DTX2_WIDTH 4
#define	FRF_AB_PCIE_DTX1_LBN 36
#define	FRF_AB_PCIE_DTX1_WIDTH 4
#define	FRF_AB_PCIE_DTX0_LBN 32
#define	FRF_AB_PCIE_DTX0_WIDTH 4
#define	FRF_AB_PCIE_DEQ7_LBN 28
#define	FRF_AB_PCIE_DEQ7_WIDTH 4
#define	FRF_AB_PCIE_DEQ6_LBN 24
#define	FRF_AB_PCIE_DEQ6_WIDTH 4
#define	FRF_AB_PCIE_DEQ5_LBN 20
#define	FRF_AB_PCIE_DEQ5_WIDTH 4
#define	FRF_AB_PCIE_DEQ4_LBN 16
#define	FRF_AB_PCIE_DEQ4_WIDTH 4
#define	FRF_AB_PCIE_DEQ3_LBN 12
#define	FRF_AB_PCIE_DEQ3_WIDTH 4
#define	FRF_AB_PCIE_DEQ2_LBN 8
#define	FRF_AB_PCIE_DEQ2_WIDTH 4
#define	FRF_AB_PCIE_DEQ1_LBN 4
#define	FRF_AB_PCIE_DEQ1_WIDTH 4
#define	FRF_AB_PCIE_DEQ0_LBN 0
#define	FRF_AB_PCIE_DEQ0_WIDTH 4

/* PCIE_PCS_CTL_STAT_REG: PCIE PCS control and status register */
#define	FR_AB_PCIE_PCS_CTL_STAT 0x00000340
#define	FRF_AB_PCIE_PRBSERRCOUNT0_H_LBN 52
#define	FRF_AB_PCIE_PRBSERRCOUNT0_H_WIDTH 4
#define	FRF_AB_PCIE_PRBSERRCOUNT0_L_LBN 48
#define	FRF_AB_PCIE_PRBSERRCOUNT0_L_WIDTH 4
#define	FRF_AB_PCIE_PRBSERR_LBN 40
#define	FRF_AB_PCIE_PRBSERR_WIDTH 8
#define	FRF_AB_PCIE_PRBSERRH0_LBN 32
#define	FRF_AB_PCIE_PRBSERRH0_WIDTH 8
#define	FRF_AB_PCIE_FASTINIT_H_LBN 15
#define	FRF_AB_PCIE_FASTINIT_H_WIDTH 1
#define	FRF_AB_PCIE_FASTINIT_L_LBN 14
#define	FRF_AB_PCIE_FASTINIT_L_WIDTH 1
#define	FRF_AB_PCIE_CTCDISABLE_H_LBN 13
#define	FRF_AB_PCIE_CTCDISABLE_H_WIDTH 1
#define	FRF_AB_PCIE_CTCDISABLE_L_LBN 12
#define	FRF_AB_PCIE_CTCDISABLE_L_WIDTH 1
#define	FRF_AB_PCIE_PRBSSYNC_H_LBN 11
#define	FRF_AB_PCIE_PRBSSYNC_H_WIDTH 1
#define	FRF_AB_PCIE_PRBSSYNC_L_LBN 10
#define	FRF_AB_PCIE_PRBSSYNC_L_WIDTH 1
#define	FRF_AB_PCIE_PRBSERRACK_H_LBN 9
#define	FRF_AB_PCIE_PRBSERRACK_H_WIDTH 1
#define	FRF_AB_PCIE_PRBSERRACK_L_LBN 8
#define	FRF_AB_PCIE_PRBSERRACK_L_WIDTH 1
#define	FRF_AB_PCIE_PRBSSEL_LBN 0
#define	FRF_AB_PCIE_PRBSSEL_WIDTH 8

/* DEBUG_DATA_OUT_REG: Live Debug and Debug 2 out ports */
#define	FR_BB_DEBUG_DATA_OUT 0x00000350
#define	FRF_BB_DEBUG2_PORT_LBN 25
#define	FRF_BB_DEBUG2_PORT_WIDTH 15
#define	FRF_BB_DEBUG1_PORT_LBN 0
#define	FRF_BB_DEBUG1_PORT_WIDTH 25

/* EVQ_RPTR_REGP0: Event queue read pointer register */
#define	FR_BZ_EVQ_RPTR_P0 0x00000400
#define	FR_BZ_EVQ_RPTR_P0_STEP 8192
#define	FR_BZ_EVQ_RPTR_P0_ROWS 1024
/* EVQ_RPTR_REG_KER: Event queue read pointer register */
#define	FR_AA_EVQ_RPTR_KER 0x00011b00
#define	FR_AA_EVQ_RPTR_KER_STEP 4
#define	FR_AA_EVQ_RPTR_KER_ROWS 4
/* EVQ_RPTR_REG: Event queue read pointer register */
#define	FR_BZ_EVQ_RPTR 0x00fa0000
#define	FR_BZ_EVQ_RPTR_STEP 16
#define	FR_BB_EVQ_RPTR_ROWS 4096
#define	FR_CZ_EVQ_RPTR_ROWS 1024
/* EVQ_RPTR_REGP123: Event queue read pointer register */
#define	FR_BB_EVQ_RPTR_P123 0x01000400
#define	FR_BB_EVQ_RPTR_P123_STEP 8192
#define	FR_BB_EVQ_RPTR_P123_ROWS 3072
#define	FRF_AZ_EVQ_RPTR_VLD_LBN 15
#define	FRF_AZ_EVQ_RPTR_VLD_WIDTH 1
#define	FRF_AZ_EVQ_RPTR_LBN 0
#define	FRF_AZ_EVQ_RPTR_WIDTH 15

/* TIMER_COMMAND_REGP0: Timer Command Registers */
#define	FR_BZ_TIMER_COMMAND_P0 0x00000420
#define	FR_BZ_TIMER_COMMAND_P0_STEP 8192
#define	FR_BZ_TIMER_COMMAND_P0_ROWS 1024
/* TIMER_COMMAND_REG_KER: Timer Command Registers */
#define	FR_AA_TIMER_COMMAND_KER 0x00000420
#define	FR_AA_TIMER_COMMAND_KER_STEP 8192
#define	FR_AA_TIMER_COMMAND_KER_ROWS 4
/* TIMER_COMMAND_REGP123: Timer Command Registers */
#define	FR_BB_TIMER_COMMAND_P123 0x01000420
#define	FR_BB_TIMER_COMMAND_P123_STEP 8192
#define	FR_BB_TIMER_COMMAND_P123_ROWS 3072
#define	FRF_CZ_TC_TIMER_MODE_LBN 14
#define	FRF_CZ_TC_TIMER_MODE_WIDTH 2
#define	FRF_AB_TC_TIMER_MODE_LBN 12
#define	FRF_AB_TC_TIMER_MODE_WIDTH 2
#define	FRF_CZ_TC_TIMER_VAL_LBN 0
#define	FRF_CZ_TC_TIMER_VAL_WIDTH 14
#define	FRF_AB_TC_TIMER_VAL_LBN 0
#define	FRF_AB_TC_TIMER_VAL_WIDTH 12

/* DRV_EV_REG: Driver generated event register */
#define	FR_AZ_DRV_EV 0x00000440
#define	FRF_AZ_DRV_EV_QID_LBN 64
#define	FRF_AZ_DRV_EV_QID_WIDTH 12
#define	FRF_AZ_DRV_EV_DATA_LBN 0
#define	FRF_AZ_DRV_EV_DATA_WIDTH 64

/* EVQ_CTL_REG: Event queue control register */
#define	FR_AZ_EVQ_CTL 0x00000450
#define	FRF_CZ_RX_EVQ_WAKEUP_MASK_LBN 15
#define	FRF_CZ_RX_EVQ_WAKEUP_MASK_WIDTH 10
#define	FRF_BB_RX_EVQ_WAKEUP_MASK_LBN 15
#define	FRF_BB_RX_EVQ_WAKEUP_MASK_WIDTH 6
#define	FRF_AZ_EVQ_OWNERR_CTL_LBN 14
#define	FRF_AZ_EVQ_OWNERR_CTL_WIDTH 1
#define	FRF_AZ_EVQ_FIFO_AF_TH_LBN 7
#define	FRF_AZ_EVQ_FIFO_AF_TH_WIDTH 7
#define	FRF_AZ_EVQ_FIFO_NOTAF_TH_LBN 0
#define	FRF_AZ_EVQ_FIFO_NOTAF_TH_WIDTH 7

/* EVQ_CNT1_REG: Event counter 1 register */
#define	FR_AZ_EVQ_CNT1 0x00000460
#define	FRF_AZ_EVQ_CNT_PRE_FIFO_LBN 120
#define	FRF_AZ_EVQ_CNT_PRE_FIFO_WIDTH 7
#define	FRF_AZ_EVQ_CNT_TOBIU_LBN 100
#define	FRF_AZ_EVQ_CNT_TOBIU_WIDTH 20
#define	FRF_AZ_EVQ_TX_REQ_CNT_LBN 80
#define	FRF_AZ_EVQ_TX_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_RX_REQ_CNT_LBN 60
#define	FRF_AZ_EVQ_RX_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_EM_REQ_CNT_LBN 40
#define	FRF_AZ_EVQ_EM_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_CSR_REQ_CNT_LBN 20
#define	FRF_AZ_EVQ_CSR_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_ERR_REQ_CNT_LBN 0
#define	FRF_AZ_EVQ_ERR_REQ_CNT_WIDTH 20

/* EVQ_CNT2_REG: Event counter 2 register */
#define	FR_AZ_EVQ_CNT2 0x00000470
#define	FRF_AZ_EVQ_UPD_REQ_CNT_LBN 104
#define	FRF_AZ_EVQ_UPD_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_CLR_REQ_CNT_LBN 84
#define	FRF_AZ_EVQ_CLR_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_RDY_CNT_LBN 80
#define	FRF_AZ_EVQ_RDY_CNT_WIDTH 4
#define	FRF_AZ_EVQ_WU_REQ_CNT_LBN 60
#define	FRF_AZ_EVQ_WU_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_WET_REQ_CNT_LBN 40
#define	FRF_AZ_EVQ_WET_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_INIT_REQ_CNT_LBN 20
#define	FRF_AZ_EVQ_INIT_REQ_CNT_WIDTH 20
#define	FRF_AZ_EVQ_TM_REQ_CNT_LBN 0
#define	FRF_AZ_EVQ_TM_REQ_CNT_WIDTH 20

/* USR_EV_REG: Event mailbox register */
#define	FR_CZ_USR_EV 0x00000540
#define	FR_CZ_USR_EV_STEP 8192
#define	FR_CZ_USR_EV_ROWS 1024
#define	FRF_CZ_USR_EV_DATA_LBN 0
#define	FRF_CZ_USR_EV_DATA_WIDTH 32

/* BUF_TBL_CFG_REG: Buffer table configuration register */
#define	FR_AZ_BUF_TBL_CFG 0x00000600
#define	FRF_AZ_BUF_TBL_MODE_LBN 3
#define	FRF_AZ_BUF_TBL_MODE_WIDTH 1

/* SRM_RX_DC_CFG_REG: SRAM receive descriptor cache configuration register */
#define	FR_AZ_SRM_RX_DC_CFG 0x00000610
#define	FRF_AZ_SRM_CLK_TMP_EN_LBN 21
#define	FRF_AZ_SRM_CLK_TMP_EN_WIDTH 1
#define	FRF_AZ_SRM_RX_DC_BASE_ADR_LBN 0
#define	FRF_AZ_SRM_RX_DC_BASE_ADR_WIDTH 21

/* SRM_TX_DC_CFG_REG: SRAM transmit descriptor cache configuration register */
#define	FR_AZ_SRM_TX_DC_CFG 0x00000620
#define	FRF_AZ_SRM_TX_DC_BASE_ADR_LBN 0
#define	FRF_AZ_SRM_TX_DC_BASE_ADR_WIDTH 21

/* SRM_CFG_REG: SRAM configuration register */
#define	FR_AZ_SRM_CFG 0x00000630
#define	FRF_AZ_SRM_OOB_ADR_INTEN_LBN 5
#define	FRF_AZ_SRM_OOB_ADR_INTEN_WIDTH 1
#define	FRF_AZ_SRM_OOB_BUF_INTEN_LBN 4
#define	FRF_AZ_SRM_OOB_BUF_INTEN_WIDTH 1
#define	FRF_AZ_SRM_INIT_EN_LBN 3
#define	FRF_AZ_SRM_INIT_EN_WIDTH 1
#define	FRF_AZ_SRM_NUM_BANK_LBN 2
#define	FRF_AZ_SRM_NUM_BANK_WIDTH 1
#define	FRF_AZ_SRM_BANK_SIZE_LBN 0
#define	FRF_AZ_SRM_BANK_SIZE_WIDTH 2

/* BUF_TBL_UPD_REG: Buffer table update register */
#define	FR_AZ_BUF_TBL_UPD 0x00000650
#define	FRF_AZ_BUF_UPD_CMD_LBN 63
#define	FRF_AZ_BUF_UPD_CMD_WIDTH 1
#define	FRF_AZ_BUF_CLR_CMD_LBN 62
#define	FRF_AZ_BUF_CLR_CMD_WIDTH 1
#define	FRF_AZ_BUF_CLR_END_ID_LBN 32
#define	FRF_AZ_BUF_CLR_END_ID_WIDTH 20
#define	FRF_AZ_BUF_CLR_START_ID_LBN 0
#define	FRF_AZ_BUF_CLR_START_ID_WIDTH 20

/* SRM_UPD_EVQ_REG: Buffer table update register */
#define	FR_AZ_SRM_UPD_EVQ 0x00000660
#define	FRF_AZ_SRM_UPD_EVQ_ID_LBN 0
#define	FRF_AZ_SRM_UPD_EVQ_ID_WIDTH 12

/* SRAM_PARITY_REG: SRAM parity register. */
#define	FR_AZ_SRAM_PARITY 0x00000670
#define	FRF_CZ_BYPASS_ECC_LBN 3
#define	FRF_CZ_BYPASS_ECC_WIDTH 1
#define	FRF_CZ_SEC_INT_LBN 2
#define	FRF_CZ_SEC_INT_WIDTH 1
#define	FRF_CZ_FORCE_SRAM_DOUBLE_ERR_LBN 1
#define	FRF_CZ_FORCE_SRAM_DOUBLE_ERR_WIDTH 1
#define	FRF_AB_FORCE_SRAM_PERR_LBN 0
#define	FRF_AB_FORCE_SRAM_PERR_WIDTH 1
#define	FRF_CZ_FORCE_SRAM_SINGLE_ERR_LBN 0
#define	FRF_CZ_FORCE_SRAM_SINGLE_ERR_WIDTH 1

/* RX_CFG_REG: Receive configuration register */
#define	FR_AZ_RX_CFG 0x00000800
#define	FRF_CZ_RX_MIN_KBUF_SIZE_LBN 72
#define	FRF_CZ_RX_MIN_KBUF_SIZE_WIDTH 14
#define	FRF_CZ_RX_HDR_SPLIT_EN_LBN 71
#define	FRF_CZ_RX_HDR_SPLIT_EN_WIDTH 1
#define	FRF_CZ_RX_HDR_SPLIT_PLD_BUF_SIZE_LBN 62
#define	FRF_CZ_RX_HDR_SPLIT_PLD_BUF_SIZE_WIDTH 9
#define	FRF_CZ_RX_HDR_SPLIT_HDR_BUF_SIZE_LBN 53
#define	FRF_CZ_RX_HDR_SPLIT_HDR_BUF_SIZE_WIDTH 9
#define	FRF_CZ_RX_PRE_RFF_IPG_LBN 49
#define	FRF_CZ_RX_PRE_RFF_IPG_WIDTH 4
#define	FRF_BZ_RX_TCP_SUP_LBN 48
#define	FRF_BZ_RX_TCP_SUP_WIDTH 1
#define	FRF_BZ_RX_INGR_EN_LBN 47
#define	FRF_BZ_RX_INGR_EN_WIDTH 1
#define	FRF_BZ_RX_IP_HASH_LBN 46
#define	FRF_BZ_RX_IP_HASH_WIDTH 1
#define	FRF_BZ_RX_HASH_ALG_LBN 45
#define	FRF_BZ_RX_HASH_ALG_WIDTH 1
#define	FRF_BZ_RX_HASH_INSRT_HDR_LBN 44
#define	FRF_BZ_RX_HASH_INSRT_HDR_WIDTH 1
#define	FRF_BZ_RX_DESC_PUSH_EN_LBN 43
#define	FRF_BZ_RX_DESC_PUSH_EN_WIDTH 1
#define	FRF_BZ_RX_RDW_PATCH_EN_LBN 42
#define	FRF_BZ_RX_RDW_PATCH_EN_WIDTH 1
#define	FRF_BB_RX_PCI_BURST_SIZE_LBN 39
#define	FRF_BB_RX_PCI_BURST_SIZE_WIDTH 3
#define	FRF_BZ_RX_OWNERR_CTL_LBN 38
#define	FRF_BZ_RX_OWNERR_CTL_WIDTH 1
#define	FRF_BZ_RX_XON_TX_TH_LBN 33
#define	FRF_BZ_RX_XON_TX_TH_WIDTH 5
#define	FRF_AA_RX_DESC_PUSH_EN_LBN 35
#define	FRF_AA_RX_DESC_PUSH_EN_WIDTH 1
#define	FRF_AA_RX_RDW_PATCH_EN_LBN 34
#define	FRF_AA_RX_RDW_PATCH_EN_WIDTH 1
#define	FRF_AA_RX_PCI_BURST_SIZE_LBN 31
#define	FRF_AA_RX_PCI_BURST_SIZE_WIDTH 3
#define	FRF_BZ_RX_XOFF_TX_TH_LBN 28
#define	FRF_BZ_RX_XOFF_TX_TH_WIDTH 5
#define	FRF_AA_RX_OWNERR_CTL_LBN 30
#define	FRF_AA_RX_OWNERR_CTL_WIDTH 1
#define	FRF_AA_RX_XON_TX_TH_LBN 25
#define	FRF_AA_RX_XON_TX_TH_WIDTH 5
#define	FRF_BZ_RX_USR_BUF_SIZE_LBN 19
#define	FRF_BZ_RX_USR_BUF_SIZE_WIDTH 9
#define	FRF_AA_RX_XOFF_TX_TH_LBN 20
#define	FRF_AA_RX_XOFF_TX_TH_WIDTH 5
#define	FRF_AA_RX_USR_BUF_SIZE_LBN 11
#define	FRF_AA_RX_USR_BUF_SIZE_WIDTH 9
#define	FRF_BZ_RX_XON_MAC_TH_LBN 10
#define	FRF_BZ_RX_XON_MAC_TH_WIDTH 9
#define	FRF_AA_RX_XON_MAC_TH_LBN 6
#define	FRF_AA_RX_XON_MAC_TH_WIDTH 5
#define	FRF_BZ_RX_XOFF_MAC_TH_LBN 1
#define	FRF_BZ_RX_XOFF_MAC_TH_WIDTH 9
#define	FRF_AA_RX_XOFF_MAC_TH_LBN 1
#define	FRF_AA_RX_XOFF_MAC_TH_WIDTH 5
#define	FRF_AZ_RX_XOFF_MAC_EN_LBN 0
#define	FRF_AZ_RX_XOFF_MAC_EN_WIDTH 1

/* RX_FILTER_CTL_REG: Receive filter control registers */
#define	FR_BZ_RX_FILTER_CTL 0x00000810
#define	FRF_CZ_ETHERNET_WILDCARD_SEARCH_LIMIT_LBN 94
#define	FRF_CZ_ETHERNET_WILDCARD_SEARCH_LIMIT_WIDTH 8
#define	FRF_CZ_ETHERNET_FULL_SEARCH_LIMIT_LBN 86
#define	FRF_CZ_ETHERNET_FULL_SEARCH_LIMIT_WIDTH 8
#define	FRF_CZ_RX_FILTER_ALL_VLAN_ETHERTYPES_LBN 85
#define	FRF_CZ_RX_FILTER_ALL_VLAN_ETHERTYPES_WIDTH 1
#define	FRF_CZ_RX_VLAN_MATCH_ETHERTYPE_LBN 69
#define	FRF_CZ_RX_VLAN_MATCH_ETHERTYPE_WIDTH 16
#define	FRF_CZ_MULTICAST_NOMATCH_Q_ID_LBN 57
#define	FRF_CZ_MULTICAST_NOMATCH_Q_ID_WIDTH 12
#define	FRF_CZ_MULTICAST_NOMATCH_RSS_ENABLED_LBN 56
#define	FRF_CZ_MULTICAST_NOMATCH_RSS_ENABLED_WIDTH 1
#define	FRF_CZ_MULTICAST_NOMATCH_IP_OVERRIDE_LBN 55
#define	FRF_CZ_MULTICAST_NOMATCH_IP_OVERRIDE_WIDTH 1
#define	FRF_CZ_UNICAST_NOMATCH_Q_ID_LBN 43
#define	FRF_CZ_UNICAST_NOMATCH_Q_ID_WIDTH 12
#define	FRF_CZ_UNICAST_NOMATCH_RSS_ENABLED_LBN 42
#define	FRF_CZ_UNICAST_NOMATCH_RSS_ENABLED_WIDTH 1
#define	FRF_CZ_UNICAST_NOMATCH_IP_OVERRIDE_LBN 41
#define	FRF_CZ_UNICAST_NOMATCH_IP_OVERRIDE_WIDTH 1
#define	FRF_BZ_SCATTER_ENBL_NO_MATCH_Q_LBN 40
#define	FRF_BZ_SCATTER_ENBL_NO_MATCH_Q_WIDTH 1
#define	FRF_BZ_UDP_FULL_SRCH_LIMIT_LBN 32
#define	FRF_BZ_UDP_FULL_SRCH_LIMIT_WIDTH 8
#define	FRF_BZ_NUM_KER_LBN 24
#define	FRF_BZ_NUM_KER_WIDTH 2
#define	FRF_BZ_UDP_WILD_SRCH_LIMIT_LBN 16
#define	FRF_BZ_UDP_WILD_SRCH_LIMIT_WIDTH 8
#define	FRF_BZ_TCP_WILD_SRCH_LIMIT_LBN 8
#define	FRF_BZ_TCP_WILD_SRCH_LIMIT_WIDTH 8
#define	FRF_BZ_TCP_FULL_SRCH_LIMIT_LBN 0
#define	FRF_BZ_TCP_FULL_SRCH_LIMIT_WIDTH 8

/* RX_FLUSH_DESCQ_REG: Receive flush descriptor queue register */
#define	FR_AZ_RX_FLUSH_DESCQ 0x00000820
#define	FRF_AZ_RX_FLUSH_DESCQ_CMD_LBN 24
#define	FRF_AZ_RX_FLUSH_DESCQ_CMD_WIDTH 1
#define	FRF_AZ_RX_FLUSH_DESCQ_LBN 0
#define	FRF_AZ_RX_FLUSH_DESCQ_WIDTH 12

/* RX_DESC_UPD_REGP0: Receive descriptor update register. */
#define	FR_BZ_RX_DESC_UPD_P0 0x00000830
#define	FR_BZ_RX_DESC_UPD_P0_STEP 8192
#define	FR_BZ_RX_DESC_UPD_P0_ROWS 1024
/* RX_DESC_UPD_REG_KER: Receive descriptor update register. */
#define	FR_AA_RX_DESC_UPD_KER 0x00000830
#define	FR_AA_RX_DESC_UPD_KER_STEP 8192
#define	FR_AA_RX_DESC_UPD_KER_ROWS 4
/* RX_DESC_UPD_REGP123: Receive descriptor update register. */
#define	FR_BB_RX_DESC_UPD_P123 0x01000830
#define	FR_BB_RX_DESC_UPD_P123_STEP 8192
#define	FR_BB_RX_DESC_UPD_P123_ROWS 3072
#define	FRF_AZ_RX_DESC_WPTR_LBN 96
#define	FRF_AZ_RX_DESC_WPTR_WIDTH 12
#define	FRF_AZ_RX_DESC_PUSH_CMD_LBN 95
#define	FRF_AZ_RX_DESC_PUSH_CMD_WIDTH 1
#define	FRF_AZ_RX_DESC_LBN 0
#define	FRF_AZ_RX_DESC_WIDTH 64

/* RX_DC_CFG_REG: Receive descriptor cache configuration register */
#define	FR_AZ_RX_DC_CFG 0x00000840
#define	FRF_AB_RX_MAX_PF_LBN 2
#define	FRF_AB_RX_MAX_PF_WIDTH 2
#define	FRF_AZ_RX_DC_SIZE_LBN 0
#define	FRF_AZ_RX_DC_SIZE_WIDTH 2
#define	FFE_AZ_RX_DC_SIZE_64 3
#define	FFE_AZ_RX_DC_SIZE_32 2
#define	FFE_AZ_RX_DC_SIZE_16 1
#define	FFE_AZ_RX_DC_SIZE_8 0

/* RX_DC_PF_WM_REG: Receive descriptor cache pre-fetch watermark register */
#define	FR_AZ_RX_DC_PF_WM 0x00000850
#define	FRF_AZ_RX_DC_PF_HWM_LBN 6
#define	FRF_AZ_RX_DC_PF_HWM_WIDTH 6
#define	FRF_AZ_RX_DC_PF_LWM_LBN 0
#define	FRF_AZ_RX_DC_PF_LWM_WIDTH 6

/* RX_RSS_TKEY_REG: RSS Toeplitz hash key */
#define	FR_BZ_RX_RSS_TKEY 0x00000860
#define	FRF_BZ_RX_RSS_TKEY_HI_LBN 64
#define	FRF_BZ_RX_RSS_TKEY_HI_WIDTH 64
#define	FRF_BZ_RX_RSS_TKEY_LO_LBN 0
#define	FRF_BZ_RX_RSS_TKEY_LO_WIDTH 64

/* RX_NODESC_DROP_REG: Receive dropped packet counter register */
#define	FR_AZ_RX_NODESC_DROP 0x00000880
#define	FRF_CZ_RX_NODESC_DROP_CNT_LBN 0
#define	FRF_CZ_RX_NODESC_DROP_CNT_WIDTH 32
#define	FRF_AB_RX_NODESC_DROP_CNT_LBN 0
#define	FRF_AB_RX_NODESC_DROP_CNT_WIDTH 16

/* RX_SELF_RST_REG: Receive self reset register */
#define	FR_AA_RX_SELF_RST 0x00000890
#define	FRF_AA_RX_ISCSI_DIS_LBN 17
#define	FRF_AA_RX_ISCSI_DIS_WIDTH 1
#define	FRF_AA_RX_SW_RST_REG_LBN 16
#define	FRF_AA_RX_SW_RST_REG_WIDTH 1
#define FRF_AA_RX_NODESC_WAIT_DIS_LBN 9
#define FRF_AA_RX_NODESC_WAIT_DIS_WIDTH 1
#define	FRF_AA_RX_SELF_RST_EN_LBN 8
#define	FRF_AA_RX_SELF_RST_EN_WIDTH 1
#define	FRF_AA_RX_MAX_PF_LAT_LBN 4
#define	FRF_AA_RX_MAX_PF_LAT_WIDTH 4
#define	FRF_AA_RX_MAX_LU_LAT_LBN 0
#define	FRF_AA_RX_MAX_LU_LAT_WIDTH 4

/* RX_DEBUG_REG: undocumented register */
#define	FR_AZ_RX_DEBUG 0x000008a0
#define	FRF_AZ_RX_DEBUG_LBN 0
#define	FRF_AZ_RX_DEBUG_WIDTH 64

/* RX_PUSH_DROP_REG: Receive descriptor push dropped counter register */
#define	FR_AZ_RX_PUSH_DROP 0x000008b0
#define	FRF_AZ_RX_PUSH_DROP_CNT_LBN 0
#define	FRF_AZ_RX_PUSH_DROP_CNT_WIDTH 32

/* RX_RSS_IPV6_REG1: IPv6 RSS Toeplitz hash key low bytes */
#define	FR_CZ_RX_RSS_IPV6_REG1 0x000008d0
#define	FRF_CZ_RX_RSS_IPV6_TKEY_LO_LBN 0
#define	FRF_CZ_RX_RSS_IPV6_TKEY_LO_WIDTH 128

/* RX_RSS_IPV6_REG2: IPv6 RSS Toeplitz hash key middle bytes */
#define	FR_CZ_RX_RSS_IPV6_REG2 0x000008e0
#define	FRF_CZ_RX_RSS_IPV6_TKEY_MID_LBN 0
#define	FRF_CZ_RX_RSS_IPV6_TKEY_MID_WIDTH 128

/* RX_RSS_IPV6_REG3: IPv6 RSS Toeplitz hash key upper bytes and IPv6 RSS settings */
#define	FR_CZ_RX_RSS_IPV6_REG3 0x000008f0
#define	FRF_CZ_RX_RSS_IPV6_THASH_ENABLE_LBN 66
#define	FRF_CZ_RX_RSS_IPV6_THASH_ENABLE_WIDTH 1
#define	FRF_CZ_RX_RSS_IPV6_IP_THASH_ENABLE_LBN 65
#define	FRF_CZ_RX_RSS_IPV6_IP_THASH_ENABLE_WIDTH 1
#define	FRF_CZ_RX_RSS_IPV6_TCP_SUPPRESS_LBN 64
#define	FRF_CZ_RX_RSS_IPV6_TCP_SUPPRESS_WIDTH 1
#define	FRF_CZ_RX_RSS_IPV6_TKEY_HI_LBN 0
#define	FRF_CZ_RX_RSS_IPV6_TKEY_HI_WIDTH 64

/* TX_FLUSH_DESCQ_REG: Transmit flush descriptor queue register */
#define	FR_AZ_TX_FLUSH_DESCQ 0x00000a00
#define	FRF_AZ_TX_FLUSH_DESCQ_CMD_LBN 12
#define	FRF_AZ_TX_FLUSH_DESCQ_CMD_WIDTH 1
#define	FRF_AZ_TX_FLUSH_DESCQ_LBN 0
#define	FRF_AZ_TX_FLUSH_DESCQ_WIDTH 12

/* TX_DESC_UPD_REGP0: Transmit descriptor update register. */
#define	FR_BZ_TX_DESC_UPD_P0 0x00000a10
#define	FR_BZ_TX_DESC_UPD_P0_STEP 8192
#define	FR_BZ_TX_DESC_UPD_P0_ROWS 1024
/* TX_DESC_UPD_REG_KER: Transmit descriptor update register. */
#define	FR_AA_TX_DESC_UPD_KER 0x00000a10
#define	FR_AA_TX_DESC_UPD_KER_STEP 8192
#define	FR_AA_TX_DESC_UPD_KER_ROWS 8
/* TX_DESC_UPD_REGP123: Transmit descriptor update register. */
#define	FR_BB_TX_DESC_UPD_P123 0x01000a10
#define	FR_BB_TX_DESC_UPD_P123_STEP 8192
#define	FR_BB_TX_DESC_UPD_P123_ROWS 3072
#define	FRF_AZ_TX_DESC_WPTR_LBN 96
#define	FRF_AZ_TX_DESC_WPTR_WIDTH 12
#define	FRF_AZ_TX_DESC_PUSH_CMD_LBN 95
#define	FRF_AZ_TX_DESC_PUSH_CMD_WIDTH 1
#define	FRF_AZ_TX_DESC_LBN 0
#define	FRF_AZ_TX_DESC_WIDTH 95

/* TX_DC_CFG_REG: Transmit descriptor cache configuration register */
#define	FR_AZ_TX_DC_CFG 0x00000a20
#define	FRF_AZ_TX_DC_SIZE_LBN 0
#define	FRF_AZ_TX_DC_SIZE_WIDTH 2
#define	FFE_AZ_TX_DC_SIZE_32 2
#define	FFE_AZ_TX_DC_SIZE_16 1
#define	FFE_AZ_TX_DC_SIZE_8 0

/* TX_CHKSM_CFG_REG: Transmit checksum configuration register */
#define	FR_AA_TX_CHKSM_CFG 0x00000a30
#define	FRF_AA_TX_Q_CHKSM_DIS_96_127_LBN 96
#define	FRF_AA_TX_Q_CHKSM_DIS_96_127_WIDTH 32
#define	FRF_AA_TX_Q_CHKSM_DIS_64_95_LBN 64
#define	FRF_AA_TX_Q_CHKSM_DIS_64_95_WIDTH 32
#define	FRF_AA_TX_Q_CHKSM_DIS_32_63_LBN 32
#define	FRF_AA_TX_Q_CHKSM_DIS_32_63_WIDTH 32
#define	FRF_AA_TX_Q_CHKSM_DIS_0_31_LBN 0
#define	FRF_AA_TX_Q_CHKSM_DIS_0_31_WIDTH 32

/* TX_CFG_REG: Transmit configuration register */
#define	FR_AZ_TX_CFG 0x00000a50
#define	FRF_CZ_TX_CONT_LOOKUP_THRESH_RANGE_LBN 114
#define	FRF_CZ_TX_CONT_LOOKUP_THRESH_RANGE_WIDTH 8
#define	FRF_CZ_TX_FILTER_TEST_MODE_BIT_LBN 113
#define	FRF_CZ_TX_FILTER_TEST_MODE_BIT_WIDTH 1
#define	FRF_CZ_TX_ETH_FILTER_WILD_SEARCH_RANGE_LBN 105
#define	FRF_CZ_TX_ETH_FILTER_WILD_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_ETH_FILTER_FULL_SEARCH_RANGE_LBN 97
#define	FRF_CZ_TX_ETH_FILTER_FULL_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_UDPIP_FILTER_WILD_SEARCH_RANGE_LBN 89
#define	FRF_CZ_TX_UDPIP_FILTER_WILD_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_UDPIP_FILTER_FULL_SEARCH_RANGE_LBN 81
#define	FRF_CZ_TX_UDPIP_FILTER_FULL_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_TCPIP_FILTER_WILD_SEARCH_RANGE_LBN 73
#define	FRF_CZ_TX_TCPIP_FILTER_WILD_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_TCPIP_FILTER_FULL_SEARCH_RANGE_LBN 65
#define	FRF_CZ_TX_TCPIP_FILTER_FULL_SEARCH_RANGE_WIDTH 8
#define	FRF_CZ_TX_FILTER_ALL_VLAN_ETHERTYPES_BIT_LBN 64
#define	FRF_CZ_TX_FILTER_ALL_VLAN_ETHERTYPES_BIT_WIDTH 1
#define	FRF_CZ_TX_VLAN_MATCH_ETHERTYPE_RANGE_LBN 48
#define	FRF_CZ_TX_VLAN_MATCH_ETHERTYPE_RANGE_WIDTH 16
#define	FRF_CZ_TX_FILTER_EN_BIT_LBN 47
#define	FRF_CZ_TX_FILTER_EN_BIT_WIDTH 1
#define	FRF_AZ_TX_IP_ID_P0_OFS_LBN 16
#define	FRF_AZ_TX_IP_ID_P0_OFS_WIDTH 15
#define	FRF_AZ_TX_NO_EOP_DISC_EN_LBN 5
#define	FRF_AZ_TX_NO_EOP_DISC_EN_WIDTH 1
#define	FRF_AZ_TX_P1_PRI_EN_LBN 4
#define	FRF_AZ_TX_P1_PRI_EN_WIDTH 1
#define	FRF_AZ_TX_OWNERR_CTL_LBN 2
#define	FRF_AZ_TX_OWNERR_CTL_WIDTH 1
#define	FRF_AA_TX_NON_IP_DROP_DIS_LBN 1
#define	FRF_AA_TX_NON_IP_DROP_DIS_WIDTH 1
#define	FRF_AZ_TX_IP_ID_REP_EN_LBN 0
#define	FRF_AZ_TX_IP_ID_REP_EN_WIDTH 1

/* TX_PUSH_DROP_REG: Transmit push dropped register */
#define	FR_AZ_TX_PUSH_DROP 0x00000a60
#define	FRF_AZ_TX_PUSH_DROP_CNT_LBN 0
#define	FRF_AZ_TX_PUSH_DROP_CNT_WIDTH 32

/* TX_RESERVED_REG: Transmit configuration register */
#define	FR_AZ_TX_RESERVED 0x00000a80
#define	FRF_AZ_TX_EVT_CNT_LBN 121
#define	FRF_AZ_TX_EVT_CNT_WIDTH 7
#define	FRF_AZ_TX_PREF_AGE_CNT_LBN 119
#define	FRF_AZ_TX_PREF_AGE_CNT_WIDTH 2
#define	FRF_AZ_TX_RD_COMP_TMR_LBN 96
#define	FRF_AZ_TX_RD_COMP_TMR_WIDTH 23
#define	FRF_AZ_TX_PUSH_EN_LBN 89
#define	FRF_AZ_TX_PUSH_EN_WIDTH 1
#define	FRF_AZ_TX_PUSH_CHK_DIS_LBN 88
#define	FRF_AZ_TX_PUSH_CHK_DIS_WIDTH 1
#define	FRF_AZ_TX_D_FF_FULL_P0_LBN 85
#define	FRF_AZ_TX_D_FF_FULL_P0_WIDTH 1
#define	FRF_AZ_TX_DMAR_ST_P0_LBN 81
#define	FRF_AZ_TX_DMAR_ST_P0_WIDTH 1
#define	FRF_AZ_TX_DMAQ_ST_LBN 78
#define	FRF_AZ_TX_DMAQ_ST_WIDTH 1
#define	FRF_AZ_TX_RX_SPACER_LBN 64
#define	FRF_AZ_TX_RX_SPACER_WIDTH 8
#define	FRF_AZ_TX_DROP_ABORT_EN_LBN 60
#define	FRF_AZ_TX_DROP_ABORT_EN_WIDTH 1
#define	FRF_AZ_TX_SOFT_EVT_EN_LBN 59
#define	FRF_AZ_TX_SOFT_EVT_EN_WIDTH 1
#define	FRF_AZ_TX_PS_EVT_DIS_LBN 58
#define	FRF_AZ_TX_PS_EVT_DIS_WIDTH 1
#define	FRF_AZ_TX_RX_SPACER_EN_LBN 57
#define	FRF_AZ_TX_RX_SPACER_EN_WIDTH 1
#define	FRF_AZ_TX_XP_TIMER_LBN 52
#define	FRF_AZ_TX_XP_TIMER_WIDTH 5
#define	FRF_AZ_TX_PREF_SPACER_LBN 44
#define	FRF_AZ_TX_PREF_SPACER_WIDTH 8
#define	FRF_AZ_TX_PREF_WD_TMR_LBN 22
#define	FRF_AZ_TX_PREF_WD_TMR_WIDTH 22
#define	FRF_AZ_TX_ONLY1TAG_LBN 21
#define	FRF_AZ_TX_ONLY1TAG_WIDTH 1
#define	FRF_AZ_TX_PREF_THRESHOLD_LBN 19
#define	FRF_AZ_TX_PREF_THRESHOLD_WIDTH 2
#define	FRF_AZ_TX_ONE_PKT_PER_Q_LBN 18
#define	FRF_AZ_TX_ONE_PKT_PER_Q_WIDTH 1
#define	FRF_AZ_TX_DIS_NON_IP_EV_LBN 17
#define	FRF_AZ_TX_DIS_NON_IP_EV_WIDTH 1
#define	FRF_AA_TX_DMA_FF_THR_LBN 16
#define	FRF_AA_TX_DMA_FF_THR_WIDTH 1
#define	FRF_AZ_TX_DMA_SPACER_LBN 8
#define	FRF_AZ_TX_DMA_SPACER_WIDTH 8
#define	FRF_AA_TX_TCP_DIS_LBN 7
#define	FRF_AA_TX_TCP_DIS_WIDTH 1
#define	FRF_BZ_TX_FLUSH_MIN_LEN_EN_LBN 7
#define	FRF_BZ_TX_FLUSH_MIN_LEN_EN_WIDTH 1
#define	FRF_AA_TX_IP_DIS_LBN 6
#define	FRF_AA_TX_IP_DIS_WIDTH 1
#define	FRF_AZ_TX_MAX_CPL_LBN 2
#define	FRF_AZ_TX_MAX_CPL_WIDTH 2
#define	FFE_AZ_TX_MAX_CPL_16 3
#define	FFE_AZ_TX_MAX_CPL_8 2
#define	FFE_AZ_TX_MAX_CPL_4 1
#define	FFE_AZ_TX_MAX_CPL_NOLIMIT 0
#define	FRF_AZ_TX_MAX_PREF_LBN 0
#define	FRF_AZ_TX_MAX_PREF_WIDTH 2
#define	FFE_AZ_TX_MAX_PREF_32 3
#define	FFE_AZ_TX_MAX_PREF_16 2
#define	FFE_AZ_TX_MAX_PREF_8 1
#define	FFE_AZ_TX_MAX_PREF_OFF 0

/* TX_PACE_REG: Transmit pace control register */
#define	FR_BZ_TX_PACE 0x00000a90
#define	FRF_BZ_TX_PACE_SB_NOT_AF_LBN 19
#define	FRF_BZ_TX_PACE_SB_NOT_AF_WIDTH 10
#define	FRF_BZ_TX_PACE_SB_AF_LBN 9
#define	FRF_BZ_TX_PACE_SB_AF_WIDTH 10
#define	FRF_BZ_TX_PACE_FB_BASE_LBN 5
#define	FRF_BZ_TX_PACE_FB_BASE_WIDTH 4
#define	FRF_BZ_TX_PACE_BIN_TH_LBN 0
#define	FRF_BZ_TX_PACE_BIN_TH_WIDTH 5

/* TX_PACE_DROP_QID_REG: PACE Drop QID Counter */
#define	FR_BZ_TX_PACE_DROP_QID 0x00000aa0
#define	FRF_BZ_TX_PACE_QID_DRP_CNT_LBN 0
#define	FRF_BZ_TX_PACE_QID_DRP_CNT_WIDTH 16

/* TX_VLAN_REG: Transmit VLAN tag register */
#define	FR_BB_TX_VLAN 0x00000ae0
#define	FRF_BB_TX_VLAN_EN_LBN 127
#define	FRF_BB_TX_VLAN_EN_WIDTH 1
#define	FRF_BB_TX_VLAN7_PORT1_EN_LBN 125
#define	FRF_BB_TX_VLAN7_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN7_PORT0_EN_LBN 124
#define	FRF_BB_TX_VLAN7_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN7_LBN 112
#define	FRF_BB_TX_VLAN7_WIDTH 12
#define	FRF_BB_TX_VLAN6_PORT1_EN_LBN 109
#define	FRF_BB_TX_VLAN6_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN6_PORT0_EN_LBN 108
#define	FRF_BB_TX_VLAN6_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN6_LBN 96
#define	FRF_BB_TX_VLAN6_WIDTH 12
#define	FRF_BB_TX_VLAN5_PORT1_EN_LBN 93
#define	FRF_BB_TX_VLAN5_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN5_PORT0_EN_LBN 92
#define	FRF_BB_TX_VLAN5_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN5_LBN 80
#define	FRF_BB_TX_VLAN5_WIDTH 12
#define	FRF_BB_TX_VLAN4_PORT1_EN_LBN 77
#define	FRF_BB_TX_VLAN4_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN4_PORT0_EN_LBN 76
#define	FRF_BB_TX_VLAN4_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN4_LBN 64
#define	FRF_BB_TX_VLAN4_WIDTH 12
#define	FRF_BB_TX_VLAN3_PORT1_EN_LBN 61
#define	FRF_BB_TX_VLAN3_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN3_PORT0_EN_LBN 60
#define	FRF_BB_TX_VLAN3_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN3_LBN 48
#define	FRF_BB_TX_VLAN3_WIDTH 12
#define	FRF_BB_TX_VLAN2_PORT1_EN_LBN 45
#define	FRF_BB_TX_VLAN2_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN2_PORT0_EN_LBN 44
#define	FRF_BB_TX_VLAN2_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN2_LBN 32
#define	FRF_BB_TX_VLAN2_WIDTH 12
#define	FRF_BB_TX_VLAN1_PORT1_EN_LBN 29
#define	FRF_BB_TX_VLAN1_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN1_PORT0_EN_LBN 28
#define	FRF_BB_TX_VLAN1_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN1_LBN 16
#define	FRF_BB_TX_VLAN1_WIDTH 12
#define	FRF_BB_TX_VLAN0_PORT1_EN_LBN 13
#define	FRF_BB_TX_VLAN0_PORT1_EN_WIDTH 1
#define	FRF_BB_TX_VLAN0_PORT0_EN_LBN 12
#define	FRF_BB_TX_VLAN0_PORT0_EN_WIDTH 1
#define	FRF_BB_TX_VLAN0_LBN 0
#define	FRF_BB_TX_VLAN0_WIDTH 12

/* TX_IPFIL_PORTEN_REG: Transmit filter control register */
#define	FR_BZ_TX_IPFIL_PORTEN 0x00000af0
#define	FRF_BZ_TX_MADR0_FIL_EN_LBN 64
#define	FRF_BZ_TX_MADR0_FIL_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL31_PORT_EN_LBN 62
#define	FRF_BB_TX_IPFIL31_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL30_PORT_EN_LBN 60
#define	FRF_BB_TX_IPFIL30_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL29_PORT_EN_LBN 58
#define	FRF_BB_TX_IPFIL29_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL28_PORT_EN_LBN 56
#define	FRF_BB_TX_IPFIL28_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL27_PORT_EN_LBN 54
#define	FRF_BB_TX_IPFIL27_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL26_PORT_EN_LBN 52
#define	FRF_BB_TX_IPFIL26_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL25_PORT_EN_LBN 50
#define	FRF_BB_TX_IPFIL25_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL24_PORT_EN_LBN 48
#define	FRF_BB_TX_IPFIL24_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL23_PORT_EN_LBN 46
#define	FRF_BB_TX_IPFIL23_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL22_PORT_EN_LBN 44
#define	FRF_BB_TX_IPFIL22_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL21_PORT_EN_LBN 42
#define	FRF_BB_TX_IPFIL21_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL20_PORT_EN_LBN 40
#define	FRF_BB_TX_IPFIL20_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL19_PORT_EN_LBN 38
#define	FRF_BB_TX_IPFIL19_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL18_PORT_EN_LBN 36
#define	FRF_BB_TX_IPFIL18_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL17_PORT_EN_LBN 34
#define	FRF_BB_TX_IPFIL17_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL16_PORT_EN_LBN 32
#define	FRF_BB_TX_IPFIL16_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL15_PORT_EN_LBN 30
#define	FRF_BB_TX_IPFIL15_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL14_PORT_EN_LBN 28
#define	FRF_BB_TX_IPFIL14_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL13_PORT_EN_LBN 26
#define	FRF_BB_TX_IPFIL13_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL12_PORT_EN_LBN 24
#define	FRF_BB_TX_IPFIL12_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL11_PORT_EN_LBN 22
#define	FRF_BB_TX_IPFIL11_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL10_PORT_EN_LBN 20
#define	FRF_BB_TX_IPFIL10_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL9_PORT_EN_LBN 18
#define	FRF_BB_TX_IPFIL9_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL8_PORT_EN_LBN 16
#define	FRF_BB_TX_IPFIL8_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL7_PORT_EN_LBN 14
#define	FRF_BB_TX_IPFIL7_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL6_PORT_EN_LBN 12
#define	FRF_BB_TX_IPFIL6_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL5_PORT_EN_LBN 10
#define	FRF_BB_TX_IPFIL5_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL4_PORT_EN_LBN 8
#define	FRF_BB_TX_IPFIL4_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL3_PORT_EN_LBN 6
#define	FRF_BB_TX_IPFIL3_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL2_PORT_EN_LBN 4
#define	FRF_BB_TX_IPFIL2_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL1_PORT_EN_LBN 2
#define	FRF_BB_TX_IPFIL1_PORT_EN_WIDTH 1
#define	FRF_BB_TX_IPFIL0_PORT_EN_LBN 0
#define	FRF_BB_TX_IPFIL0_PORT_EN_WIDTH 1

/* TX_IPFIL_TBL: Transmit IP source address filter table */
#define	FR_BB_TX_IPFIL_TBL 0x00000b00
#define	FR_BB_TX_IPFIL_TBL_STEP 16
#define	FR_BB_TX_IPFIL_TBL_ROWS 16
#define	FRF_BB_TX_IPFIL_MASK_1_LBN 96
#define	FRF_BB_TX_IPFIL_MASK_1_WIDTH 32
#define	FRF_BB_TX_IP_SRC_ADR_1_LBN 64
#define	FRF_BB_TX_IP_SRC_ADR_1_WIDTH 32
#define	FRF_BB_TX_IPFIL_MASK_0_LBN 32
#define	FRF_BB_TX_IPFIL_MASK_0_WIDTH 32
#define	FRF_BB_TX_IP_SRC_ADR_0_LBN 0
#define	FRF_BB_TX_IP_SRC_ADR_0_WIDTH 32

/* MD_TXD_REG: PHY management transmit data register */
#define	FR_AB_MD_TXD 0x00000c00
#define	FRF_AB_MD_TXD_LBN 0
#define	FRF_AB_MD_TXD_WIDTH 16

/* MD_RXD_REG: PHY management receive data register */
#define	FR_AB_MD_RXD 0x00000c10
#define	FRF_AB_MD_RXD_LBN 0
#define	FRF_AB_MD_RXD_WIDTH 16

/* MD_CS_REG: PHY management configuration & status register */
#define	FR_AB_MD_CS 0x00000c20
#define	FRF_AB_MD_RD_EN_CMD_LBN 15
#define	FRF_AB_MD_RD_EN_CMD_WIDTH 1
#define	FRF_AB_MD_WR_EN_CMD_LBN 14
#define	FRF_AB_MD_WR_EN_CMD_WIDTH 1
#define	FRF_AB_MD_ADDR_CMD_LBN 13
#define	FRF_AB_MD_ADDR_CMD_WIDTH 1
#define	FRF_AB_MD_PT_LBN 7
#define	FRF_AB_MD_PT_WIDTH 3
#define	FRF_AB_MD_PL_LBN 6
#define	FRF_AB_MD_PL_WIDTH 1
#define	FRF_AB_MD_INT_CLR_LBN 5
#define	FRF_AB_MD_INT_CLR_WIDTH 1
#define	FRF_AB_MD_GC_LBN 4
#define	FRF_AB_MD_GC_WIDTH 1
#define	FRF_AB_MD_PRSP_LBN 3
#define	FRF_AB_MD_PRSP_WIDTH 1
#define	FRF_AB_MD_RIC_LBN 2
#define	FRF_AB_MD_RIC_WIDTH 1
#define	FRF_AB_MD_RDC_LBN 1
#define	FRF_AB_MD_RDC_WIDTH 1
#define	FRF_AB_MD_WRC_LBN 0
#define	FRF_AB_MD_WRC_WIDTH 1

/* MD_PHY_ADR_REG: PHY management PHY address register */
#define	FR_AB_MD_PHY_ADR 0x00000c30
#define	FRF_AB_MD_PHY_ADR_LBN 0
#define	FRF_AB_MD_PHY_ADR_WIDTH 16

/* MD_ID_REG: PHY management ID register */
#define	FR_AB_MD_ID 0x00000c40
#define	FRF_AB_MD_PRT_ADR_LBN 11
#define	FRF_AB_MD_PRT_ADR_WIDTH 5
#define	FRF_AB_MD_DEV_ADR_LBN 6
#define	FRF_AB_MD_DEV_ADR_WIDTH 5

/* MD_STAT_REG: PHY management status & mask register */
#define	FR_AB_MD_STAT 0x00000c50
#define	FRF_AB_MD_PINT_LBN 4
#define	FRF_AB_MD_PINT_WIDTH 1
#define	FRF_AB_MD_DONE_LBN 3
#define	FRF_AB_MD_DONE_WIDTH 1
#define	FRF_AB_MD_BSERR_LBN 2
#define	FRF_AB_MD_BSERR_WIDTH 1
#define	FRF_AB_MD_LNFL_LBN 1
#define	FRF_AB_MD_LNFL_WIDTH 1
#define	FRF_AB_MD_BSY_LBN 0
#define	FRF_AB_MD_BSY_WIDTH 1

/* MAC_STAT_DMA_REG: Port MAC statistical counter DMA register */
#define	FR_AB_MAC_STAT_DMA 0x00000c60
#define	FRF_AB_MAC_STAT_DMA_CMD_LBN 48
#define	FRF_AB_MAC_STAT_DMA_CMD_WIDTH 1
#define	FRF_AB_MAC_STAT_DMA_ADR_LBN 0
#define	FRF_AB_MAC_STAT_DMA_ADR_WIDTH 48

/* MAC_CTRL_REG: Port MAC control register */
#define	FR_AB_MAC_CTRL 0x00000c80
#define	FRF_AB_MAC_XOFF_VAL_LBN 16
#define	FRF_AB_MAC_XOFF_VAL_WIDTH 16
#define	FRF_BB_TXFIFO_DRAIN_EN_LBN 7
#define	FRF_BB_TXFIFO_DRAIN_EN_WIDTH 1
#define	FRF_AB_MAC_XG_DISTXCRC_LBN 5
#define	FRF_AB_MAC_XG_DISTXCRC_WIDTH 1
#define	FRF_AB_MAC_BCAD_ACPT_LBN 4
#define	FRF_AB_MAC_BCAD_ACPT_WIDTH 1
#define	FRF_AB_MAC_UC_PROM_LBN 3
#define	FRF_AB_MAC_UC_PROM_WIDTH 1
#define	FRF_AB_MAC_LINK_STATUS_LBN 2
#define	FRF_AB_MAC_LINK_STATUS_WIDTH 1
#define	FRF_AB_MAC_SPEED_LBN 0
#define	FRF_AB_MAC_SPEED_WIDTH 2
#define	FFE_AB_MAC_SPEED_10G 3
#define	FFE_AB_MAC_SPEED_1G 2
#define	FFE_AB_MAC_SPEED_100M 1
#define	FFE_AB_MAC_SPEED_10M 0

/* GEN_MODE_REG: General Purpose mode register (external interrupt mask) */
#define	FR_BB_GEN_MODE 0x00000c90
#define	FRF_BB_XFP_PHY_INT_POL_SEL_LBN 3
#define	FRF_BB_XFP_PHY_INT_POL_SEL_WIDTH 1
#define	FRF_BB_XG_PHY_INT_POL_SEL_LBN 2
#define	FRF_BB_XG_PHY_INT_POL_SEL_WIDTH 1
#define	FRF_BB_XFP_PHY_INT_MASK_LBN 1
#define	FRF_BB_XFP_PHY_INT_MASK_WIDTH 1
#define	FRF_BB_XG_PHY_INT_MASK_LBN 0
#define	FRF_BB_XG_PHY_INT_MASK_WIDTH 1

/* MAC_MC_HASH_REG0: Multicast address hash table */
#define	FR_AB_MAC_MC_HASH_REG0 0x00000ca0
#define	FRF_AB_MAC_MCAST_HASH0_LBN 0
#define	FRF_AB_MAC_MCAST_HASH0_WIDTH 128

/* MAC_MC_HASH_REG1: Multicast address hash table */
#define	FR_AB_MAC_MC_HASH_REG1 0x00000cb0
#define	FRF_AB_MAC_MCAST_HASH1_LBN 0
#define	FRF_AB_MAC_MCAST_HASH1_WIDTH 128

/* GM_CFG1_REG: GMAC configuration register 1 */
#define	FR_AB_GM_CFG1 0x00000e00
#define	FRF_AB_GM_SW_RST_LBN 31
#define	FRF_AB_GM_SW_RST_WIDTH 1
#define	FRF_AB_GM_SIM_RST_LBN 30
#define	FRF_AB_GM_SIM_RST_WIDTH 1
#define	FRF_AB_GM_RST_RX_MAC_CTL_LBN 19
#define	FRF_AB_GM_RST_RX_MAC_CTL_WIDTH 1
#define	FRF_AB_GM_RST_TX_MAC_CTL_LBN 18
#define	FRF_AB_GM_RST_TX_MAC_CTL_WIDTH 1
#define	FRF_AB_GM_RST_RX_FUNC_LBN 17
#define	FRF_AB_GM_RST_RX_FUNC_WIDTH 1
#define	FRF_AB_GM_RST_TX_FUNC_LBN 16
#define	FRF_AB_GM_RST_TX_FUNC_WIDTH 1
#define	FRF_AB_GM_LOOP_LBN 8
#define	FRF_AB_GM_LOOP_WIDTH 1
#define	FRF_AB_GM_RX_FC_EN_LBN 5
#define	FRF_AB_GM_RX_FC_EN_WIDTH 1
#define	FRF_AB_GM_TX_FC_EN_LBN 4
#define	FRF_AB_GM_TX_FC_EN_WIDTH 1
#define	FRF_AB_GM_SYNC_RXEN_LBN 3
#define	FRF_AB_GM_SYNC_RXEN_WIDTH 1
#define	FRF_AB_GM_RX_EN_LBN 2
#define	FRF_AB_GM_RX_EN_WIDTH 1
#define	FRF_AB_GM_SYNC_TXEN_LBN 1
#define	FRF_AB_GM_SYNC_TXEN_WIDTH 1
#define	FRF_AB_GM_TX_EN_LBN 0
#define	FRF_AB_GM_TX_EN_WIDTH 1

/* GM_CFG2_REG: GMAC configuration register 2 */
#define	FR_AB_GM_CFG2 0x00000e10
#define	FRF_AB_GM_PAMBL_LEN_LBN 12
#define	FRF_AB_GM_PAMBL_LEN_WIDTH 4
#define	FRF_AB_GM_IF_MODE_LBN 8
#define	FRF_AB_GM_IF_MODE_WIDTH 2
#define	FFE_AB_IF_MODE_BYTE_MODE 2
#define	FFE_AB_IF_MODE_NIBBLE_MODE 1
#define	FRF_AB_GM_HUGE_FRM_EN_LBN 5
#define	FRF_AB_GM_HUGE_FRM_EN_WIDTH 1
#define	FRF_AB_GM_LEN_CHK_LBN 4
#define	FRF_AB_GM_LEN_CHK_WIDTH 1
#define	FRF_AB_GM_PAD_CRC_EN_LBN 2
#define	FRF_AB_GM_PAD_CRC_EN_WIDTH 1
#define	FRF_AB_GM_CRC_EN_LBN 1
#define	FRF_AB_GM_CRC_EN_WIDTH 1
#define	FRF_AB_GM_FD_LBN 0
#define	FRF_AB_GM_FD_WIDTH 1

/* GM_IPG_REG: GMAC IPG register */
#define	FR_AB_GM_IPG 0x00000e20
#define	FRF_AB_GM_NONB2B_IPG1_LBN 24
#define	FRF_AB_GM_NONB2B_IPG1_WIDTH 7
#define	FRF_AB_GM_NONB2B_IPG2_LBN 16
#define	FRF_AB_GM_NONB2B_IPG2_WIDTH 7
#define	FRF_AB_GM_MIN_IPG_ENF_LBN 8
#define	FRF_AB_GM_MIN_IPG_ENF_WIDTH 8
#define	FRF_AB_GM_B2B_IPG_LBN 0
#define	FRF_AB_GM_B2B_IPG_WIDTH 7

/* GM_HD_REG: GMAC half duplex register */
#define	FR_AB_GM_HD 0x00000e30
#define	FRF_AB_GM_ALT_BOFF_VAL_LBN 20
#define	FRF_AB_GM_ALT_BOFF_VAL_WIDTH 4
#define	FRF_AB_GM_ALT_BOFF_EN_LBN 19
#define	FRF_AB_GM_ALT_BOFF_EN_WIDTH 1
#define	FRF_AB_GM_BP_NO_BOFF_LBN 18
#define	FRF_AB_GM_BP_NO_BOFF_WIDTH 1
#define	FRF_AB_GM_DIS_BOFF_LBN 17
#define	FRF_AB_GM_DIS_BOFF_WIDTH 1
#define	FRF_AB_GM_EXDEF_TX_EN_LBN 16
#define	FRF_AB_GM_EXDEF_TX_EN_WIDTH 1
#define	FRF_AB_GM_RTRY_LIMIT_LBN 12
#define	FRF_AB_GM_RTRY_LIMIT_WIDTH 4
#define	FRF_AB_GM_COL_WIN_LBN 0
#define	FRF_AB_GM_COL_WIN_WIDTH 10

/* GM_MAX_FLEN_REG: GMAC maximum frame length register */
#define	FR_AB_GM_MAX_FLEN 0x00000e40
#define	FRF_AB_GM_MAX_FLEN_LBN 0
#define	FRF_AB_GM_MAX_FLEN_WIDTH 16

/* GM_TEST_REG: GMAC test register */
#define	FR_AB_GM_TEST 0x00000e70
#define	FRF_AB_GM_MAX_BOFF_LBN 3
#define	FRF_AB_GM_MAX_BOFF_WIDTH 1
#define	FRF_AB_GM_REG_TX_FLOW_EN_LBN 2
#define	FRF_AB_GM_REG_TX_FLOW_EN_WIDTH 1
#define	FRF_AB_GM_TEST_PAUSE_LBN 1
#define	FRF_AB_GM_TEST_PAUSE_WIDTH 1
#define	FRF_AB_GM_SHORT_SLOT_LBN 0
#define	FRF_AB_GM_SHORT_SLOT_WIDTH 1

/* GM_ADR1_REG: GMAC station address register 1 */
#define	FR_AB_GM_ADR1 0x00000f00
#define	FRF_AB_GM_ADR_B0_LBN 24
#define	FRF_AB_GM_ADR_B0_WIDTH 8
#define	FRF_AB_GM_ADR_B1_LBN 16
#define	FRF_AB_GM_ADR_B1_WIDTH 8
#define	FRF_AB_GM_ADR_B2_LBN 8
#define	FRF_AB_GM_ADR_B2_WIDTH 8
#define	FRF_AB_GM_ADR_B3_LBN 0
#define	FRF_AB_GM_ADR_B3_WIDTH 8

/* GM_ADR2_REG: GMAC station address register 2 */
#define	FR_AB_GM_ADR2 0x00000f10
#define	FRF_AB_GM_ADR_B4_LBN 24
#define	FRF_AB_GM_ADR_B4_WIDTH 8
#define	FRF_AB_GM_ADR_B5_LBN 16
#define	FRF_AB_GM_ADR_B5_WIDTH 8

/* GMF_CFG0_REG: GMAC FIFO configuration register 0 */
#define	FR_AB_GMF_CFG0 0x00000f20
#define	FRF_AB_GMF_FTFENRPLY_LBN 20
#define	FRF_AB_GMF_FTFENRPLY_WIDTH 1
#define	FRF_AB_GMF_STFENRPLY_LBN 19
#define	FRF_AB_GMF_STFENRPLY_WIDTH 1
#define	FRF_AB_GMF_FRFENRPLY_LBN 18
#define	FRF_AB_GMF_FRFENRPLY_WIDTH 1
#define	FRF_AB_GMF_SRFENRPLY_LBN 17
#define	FRF_AB_GMF_SRFENRPLY_WIDTH 1
#define	FRF_AB_GMF_WTMENRPLY_LBN 16
#define	FRF_AB_GMF_WTMENRPLY_WIDTH 1
#define	FRF_AB_GMF_FTFENREQ_LBN 12
#define	FRF_AB_GMF_FTFENREQ_WIDTH 1
#define	FRF_AB_GMF_STFENREQ_LBN 11
#define	FRF_AB_GMF_STFENREQ_WIDTH 1
#define	FRF_AB_GMF_FRFENREQ_LBN 10
#define	FRF_AB_GMF_FRFENREQ_WIDTH 1
#define	FRF_AB_GMF_SRFENREQ_LBN 9
#define	FRF_AB_GMF_SRFENREQ_WIDTH 1
#define	FRF_AB_GMF_WTMENREQ_LBN 8
#define	FRF_AB_GMF_WTMENREQ_WIDTH 1
#define	FRF_AB_GMF_HSTRSTFT_LBN 4
#define	FRF_AB_GMF_HSTRSTFT_WIDTH 1
#define	FRF_AB_GMF_HSTRSTST_LBN 3
#define	FRF_AB_GMF_HSTRSTST_WIDTH 1
#define	FRF_AB_GMF_HSTRSTFR_LBN 2
#define	FRF_AB_GMF_HSTRSTFR_WIDTH 1
#define	FRF_AB_GMF_HSTRSTSR_LBN 1
#define	FRF_AB_GMF_HSTRSTSR_WIDTH 1
#define	FRF_AB_GMF_HSTRSTWT_LBN 0
#define	FRF_AB_GMF_HSTRSTWT_WIDTH 1

/* GMF_CFG1_REG: GMAC FIFO configuration register 1 */
#define	FR_AB_GMF_CFG1 0x00000f30
#define	FRF_AB_GMF_CFGFRTH_LBN 16
#define	FRF_AB_GMF_CFGFRTH_WIDTH 5
#define	FRF_AB_GMF_CFGXOFFRTX_LBN 0
#define	FRF_AB_GMF_CFGXOFFRTX_WIDTH 16

/* GMF_CFG2_REG: GMAC FIFO configuration register 2 */
#define	FR_AB_GMF_CFG2 0x00000f40
#define	FRF_AB_GMF_CFGHWM_LBN 16
#define	FRF_AB_GMF_CFGHWM_WIDTH 6
#define	FRF_AB_GMF_CFGLWM_LBN 0
#define	FRF_AB_GMF_CFGLWM_WIDTH 6

/* GMF_CFG3_REG: GMAC FIFO configuration register 3 */
#define	FR_AB_GMF_CFG3 0x00000f50
#define	FRF_AB_GMF_CFGHWMFT_LBN 16
#define	FRF_AB_GMF_CFGHWMFT_WIDTH 6
#define	FRF_AB_GMF_CFGFTTH_LBN 0
#define	FRF_AB_GMF_CFGFTTH_WIDTH 6

/* GMF_CFG4_REG: GMAC FIFO configuration register 4 */
#define	FR_AB_GMF_CFG4 0x00000f60
#define	FRF_AB_GMF_HSTFLTRFRM_LBN 0
#define	FRF_AB_GMF_HSTFLTRFRM_WIDTH 18

/* GMF_CFG5_REG: GMAC FIFO configuration register 5 */
#define	FR_AB_GMF_CFG5 0x00000f70
#define	FRF_AB_GMF_CFGHDPLX_LBN 22
#define	FRF_AB_GMF_CFGHDPLX_WIDTH 1
#define	FRF_AB_GMF_SRFULL_LBN 21
#define	FRF_AB_GMF_SRFULL_WIDTH 1
#define	FRF_AB_GMF_HSTSRFULLCLR_LBN 20
#define	FRF_AB_GMF_HSTSRFULLCLR_WIDTH 1
#define	FRF_AB_GMF_CFGBYTMODE_LBN 19
#define	FRF_AB_GMF_CFGBYTMODE_WIDTH 1
#define	FRF_AB_GMF_HSTDRPLT64_LBN 18
#define	FRF_AB_GMF_HSTDRPLT64_WIDTH 1
#define	FRF_AB_GMF_HSTFLTRFRMDC_LBN 0
#define	FRF_AB_GMF_HSTFLTRFRMDC_WIDTH 18

/* TX_SRC_MAC_TBL: Transmit IP source address filter table */
#define	FR_BB_TX_SRC_MAC_TBL 0x00001000
#define	FR_BB_TX_SRC_MAC_TBL_STEP 16
#define	FR_BB_TX_SRC_MAC_TBL_ROWS 16
#define	FRF_BB_TX_SRC_MAC_ADR_1_LBN 64
#define	FRF_BB_TX_SRC_MAC_ADR_1_WIDTH 48
#define	FRF_BB_TX_SRC_MAC_ADR_0_LBN 0
#define	FRF_BB_TX_SRC_MAC_ADR_0_WIDTH 48

/* TX_SRC_MAC_CTL_REG: Transmit MAC source address filter control */
#define	FR_BB_TX_SRC_MAC_CTL 0x00001100
#define	FRF_BB_TX_SRC_DROP_CTR_LBN 16
#define	FRF_BB_TX_SRC_DROP_CTR_WIDTH 16
#define	FRF_BB_TX_SRC_FLTR_EN_LBN 15
#define	FRF_BB_TX_SRC_FLTR_EN_WIDTH 1
#define	FRF_BB_TX_DROP_CTR_CLR_LBN 12
#define	FRF_BB_TX_DROP_CTR_CLR_WIDTH 1
#define	FRF_BB_TX_MAC_QID_SEL_LBN 0
#define	FRF_BB_TX_MAC_QID_SEL_WIDTH 3

/* XM_ADR_LO_REG: XGMAC address register low */
#define	FR_AB_XM_ADR_LO 0x00001200
#define	FRF_AB_XM_ADR_LO_LBN 0
#define	FRF_AB_XM_ADR_LO_WIDTH 32

/* XM_ADR_HI_REG: XGMAC address register high */
#define	FR_AB_XM_ADR_HI 0x00001210
#define	FRF_AB_XM_ADR_HI_LBN 0
#define	FRF_AB_XM_ADR_HI_WIDTH 16

/* XM_GLB_CFG_REG: XGMAC global configuration */
#define	FR_AB_XM_GLB_CFG 0x00001220
#define	FRF_AB_XM_RMTFLT_GEN_LBN 17
#define	FRF_AB_XM_RMTFLT_GEN_WIDTH 1
#define	FRF_AB_XM_DEBUG_MODE_LBN 16
#define	FRF_AB_XM_DEBUG_MODE_WIDTH 1
#define	FRF_AB_XM_RX_STAT_EN_LBN 11
#define	FRF_AB_XM_RX_STAT_EN_WIDTH 1
#define	FRF_AB_XM_TX_STAT_EN_LBN 10
#define	FRF_AB_XM_TX_STAT_EN_WIDTH 1
#define	FRF_AB_XM_RX_JUMBO_MODE_LBN 6
#define	FRF_AB_XM_RX_JUMBO_MODE_WIDTH 1
#define	FRF_AB_XM_WAN_MODE_LBN 5
#define	FRF_AB_XM_WAN_MODE_WIDTH 1
#define	FRF_AB_XM_INTCLR_MODE_LBN 3
#define	FRF_AB_XM_INTCLR_MODE_WIDTH 1
#define	FRF_AB_XM_CORE_RST_LBN 0
#define	FRF_AB_XM_CORE_RST_WIDTH 1

/* XM_TX_CFG_REG: XGMAC transmit configuration */
#define	FR_AB_XM_TX_CFG 0x00001230
#define	FRF_AB_XM_TX_PROG_LBN 24
#define	FRF_AB_XM_TX_PROG_WIDTH 1
#define	FRF_AB_XM_IPG_LBN 16
#define	FRF_AB_XM_IPG_WIDTH 4
#define	FRF_AB_XM_FCNTL_LBN 10
#define	FRF_AB_XM_FCNTL_WIDTH 1
#define	FRF_AB_XM_TXCRC_LBN 8
#define	FRF_AB_XM_TXCRC_WIDTH 1
#define	FRF_AB_XM_EDRC_LBN 6
#define	FRF_AB_XM_EDRC_WIDTH 1
#define	FRF_AB_XM_AUTO_PAD_LBN 5
#define	FRF_AB_XM_AUTO_PAD_WIDTH 1
#define	FRF_AB_XM_TX_PRMBL_LBN 2
#define	FRF_AB_XM_TX_PRMBL_WIDTH 1
#define	FRF_AB_XM_TXEN_LBN 1
#define	FRF_AB_XM_TXEN_WIDTH 1
#define	FRF_AB_XM_TX_RST_LBN 0
#define	FRF_AB_XM_TX_RST_WIDTH 1

/* XM_RX_CFG_REG: XGMAC receive configuration */
#define	FR_AB_XM_RX_CFG 0x00001240
#define	FRF_AB_XM_PASS_LENERR_LBN 26
#define	FRF_AB_XM_PASS_LENERR_WIDTH 1
#define	FRF_AB_XM_PASS_CRC_ERR_LBN 25
#define	FRF_AB_XM_PASS_CRC_ERR_WIDTH 1
#define	FRF_AB_XM_PASS_PRMBLE_ERR_LBN 24
#define	FRF_AB_XM_PASS_PRMBLE_ERR_WIDTH 1
#define	FRF_AB_XM_REJ_BCAST_LBN 20
#define	FRF_AB_XM_REJ_BCAST_WIDTH 1
#define	FRF_AB_XM_ACPT_ALL_MCAST_LBN 11
#define	FRF_AB_XM_ACPT_ALL_MCAST_WIDTH 1
#define	FRF_AB_XM_ACPT_ALL_UCAST_LBN 9
#define	FRF_AB_XM_ACPT_ALL_UCAST_WIDTH 1
#define	FRF_AB_XM_AUTO_DEPAD_LBN 8
#define	FRF_AB_XM_AUTO_DEPAD_WIDTH 1
#define	FRF_AB_XM_RXCRC_LBN 3
#define	FRF_AB_XM_RXCRC_WIDTH 1
#define	FRF_AB_XM_RX_PRMBL_LBN 2
#define	FRF_AB_XM_RX_PRMBL_WIDTH 1
#define	FRF_AB_XM_RXEN_LBN 1
#define	FRF_AB_XM_RXEN_WIDTH 1
#define	FRF_AB_XM_RX_RST_LBN 0
#define	FRF_AB_XM_RX_RST_WIDTH 1

/* XM_MGT_INT_MASK: documentation to be written for sum_XM_MGT_INT_MASK */
#define	FR_AB_XM_MGT_INT_MASK 0x00001250
#define	FRF_AB_XM_MSK_STA_INTR_LBN 16
#define	FRF_AB_XM_MSK_STA_INTR_WIDTH 1
#define	FRF_AB_XM_MSK_STAT_CNTR_HF_LBN 9
#define	FRF_AB_XM_MSK_STAT_CNTR_HF_WIDTH 1
#define	FRF_AB_XM_MSK_STAT_CNTR_OF_LBN 8
#define	FRF_AB_XM_MSK_STAT_CNTR_OF_WIDTH 1
#define	FRF_AB_XM_MSK_PRMBLE_ERR_LBN 2
#define	FRF_AB_XM_MSK_PRMBLE_ERR_WIDTH 1
#define	FRF_AB_XM_MSK_RMTFLT_LBN 1
#define	FRF_AB_XM_MSK_RMTFLT_WIDTH 1
#define	FRF_AB_XM_MSK_LCLFLT_LBN 0
#define	FRF_AB_XM_MSK_LCLFLT_WIDTH 1

/* XM_FC_REG: XGMAC flow control register */
#define	FR_AB_XM_FC 0x00001270
#define	FRF_AB_XM_PAUSE_TIME_LBN 16
#define	FRF_AB_XM_PAUSE_TIME_WIDTH 16
#define	FRF_AB_XM_RX_MAC_STAT_LBN 11
#define	FRF_AB_XM_RX_MAC_STAT_WIDTH 1
#define	FRF_AB_XM_TX_MAC_STAT_LBN 10
#define	FRF_AB_XM_TX_MAC_STAT_WIDTH 1
#define	FRF_AB_XM_MCNTL_PASS_LBN 8
#define	FRF_AB_XM_MCNTL_PASS_WIDTH 2
#define	FRF_AB_XM_REJ_CNTL_UCAST_LBN 6
#define	FRF_AB_XM_REJ_CNTL_UCAST_WIDTH 1
#define	FRF_AB_XM_REJ_CNTL_MCAST_LBN 5
#define	FRF_AB_XM_REJ_CNTL_MCAST_WIDTH 1
#define	FRF_AB_XM_ZPAUSE_LBN 2
#define	FRF_AB_XM_ZPAUSE_WIDTH 1
#define	FRF_AB_XM_XMIT_PAUSE_LBN 1
#define	FRF_AB_XM_XMIT_PAUSE_WIDTH 1
#define	FRF_AB_XM_DIS_FCNTL_LBN 0
#define	FRF_AB_XM_DIS_FCNTL_WIDTH 1

/* XM_PAUSE_TIME_REG: XGMAC pause time register */
#define	FR_AB_XM_PAUSE_TIME 0x00001290
#define	FRF_AB_XM_TX_PAUSE_CNT_LBN 16
#define	FRF_AB_XM_TX_PAUSE_CNT_WIDTH 16
#define	FRF_AB_XM_RX_PAUSE_CNT_LBN 0
#define	FRF_AB_XM_RX_PAUSE_CNT_WIDTH 16

/* XM_TX_PARAM_REG: XGMAC transmit parameter register */
#define	FR_AB_XM_TX_PARAM 0x000012d0
#define	FRF_AB_XM_TX_JUMBO_MODE_LBN 31
#define	FRF_AB_XM_TX_JUMBO_MODE_WIDTH 1
#define	FRF_AB_XM_MAX_TX_FRM_SIZE_HI_LBN 19
#define	FRF_AB_XM_MAX_TX_FRM_SIZE_HI_WIDTH 11
#define	FRF_AB_XM_MAX_TX_FRM_SIZE_LO_LBN 16
#define	FRF_AB_XM_MAX_TX_FRM_SIZE_LO_WIDTH 3
#define	FRF_AB_XM_PAD_CHAR_LBN 0
#define	FRF_AB_XM_PAD_CHAR_WIDTH 8

/* XM_RX_PARAM_REG: XGMAC receive parameter register */
#define	FR_AB_XM_RX_PARAM 0x000012e0
#define	FRF_AB_XM_MAX_RX_FRM_SIZE_HI_LBN 3
#define	FRF_AB_XM_MAX_RX_FRM_SIZE_HI_WIDTH 11
#define	FRF_AB_XM_MAX_RX_FRM_SIZE_LO_LBN 0
#define	FRF_AB_XM_MAX_RX_FRM_SIZE_LO_WIDTH 3

/* XM_MGT_INT_MSK_REG: XGMAC management interrupt mask register */
#define	FR_AB_XM_MGT_INT_MSK 0x000012f0
#define	FRF_AB_XM_STAT_CNTR_OF_LBN 9
#define	FRF_AB_XM_STAT_CNTR_OF_WIDTH 1
#define	FRF_AB_XM_STAT_CNTR_HF_LBN 8
#define	FRF_AB_XM_STAT_CNTR_HF_WIDTH 1
#define	FRF_AB_XM_PRMBLE_ERR_LBN 2
#define	FRF_AB_XM_PRMBLE_ERR_WIDTH 1
#define	FRF_AB_XM_RMTFLT_LBN 1
#define	FRF_AB_XM_RMTFLT_WIDTH 1
#define	FRF_AB_XM_LCLFLT_LBN 0
#define	FRF_AB_XM_LCLFLT_WIDTH 1

/* XX_PWR_RST_REG: XGXS/XAUI powerdown/reset register */
#define	FR_AB_XX_PWR_RST 0x00001300
#define	FRF_AB_XX_PWRDND_SIG_LBN 31
#define	FRF_AB_XX_PWRDND_SIG_WIDTH 1
#define	FRF_AB_XX_PWRDNC_SIG_LBN 30
#define	FRF_AB_XX_PWRDNC_SIG_WIDTH 1
#define	FRF_AB_XX_PWRDNB_SIG_LBN 29
#define	FRF_AB_XX_PWRDNB_SIG_WIDTH 1
#define	FRF_AB_XX_PWRDNA_SIG_LBN 28
#define	FRF_AB_XX_PWRDNA_SIG_WIDTH 1
#define	FRF_AB_XX_SIM_MODE_LBN 27
#define	FRF_AB_XX_SIM_MODE_WIDTH 1
#define	FRF_AB_XX_RSTPLLCD_SIG_LBN 25
#define	FRF_AB_XX_RSTPLLCD_SIG_WIDTH 1
#define	FRF_AB_XX_RSTPLLAB_SIG_LBN 24
#define	FRF_AB_XX_RSTPLLAB_SIG_WIDTH 1
#define	FRF_AB_XX_RESETD_SIG_LBN 23
#define	FRF_AB_XX_RESETD_SIG_WIDTH 1
#define	FRF_AB_XX_RESETC_SIG_LBN 22
#define	FRF_AB_XX_RESETC_SIG_WIDTH 1
#define	FRF_AB_XX_RESETB_SIG_LBN 21
#define	FRF_AB_XX_RESETB_SIG_WIDTH 1
#define	FRF_AB_XX_RESETA_SIG_LBN 20
#define	FRF_AB_XX_RESETA_SIG_WIDTH 1
#define	FRF_AB_XX_RSTXGXSRX_SIG_LBN 18
#define	FRF_AB_XX_RSTXGXSRX_SIG_WIDTH 1
#define	FRF_AB_XX_RSTXGXSTX_SIG_LBN 17
#define	FRF_AB_XX_RSTXGXSTX_SIG_WIDTH 1
#define	FRF_AB_XX_SD_RST_ACT_LBN 16
#define	FRF_AB_XX_SD_RST_ACT_WIDTH 1
#define	FRF_AB_XX_PWRDND_EN_LBN 15
#define	FRF_AB_XX_PWRDND_EN_WIDTH 1
#define	FRF_AB_XX_PWRDNC_EN_LBN 14
#define	FRF_AB_XX_PWRDNC_EN_WIDTH 1
#define	FRF_AB_XX_PWRDNB_EN_LBN 13
#define	FRF_AB_XX_PWRDNB_EN_WIDTH 1
#define	FRF_AB_XX_PWRDNA_EN_LBN 12
#define	FRF_AB_XX_PWRDNA_EN_WIDTH 1
#define	FRF_AB_XX_RSTPLLCD_EN_LBN 9
#define	FRF_AB_XX_RSTPLLCD_EN_WIDTH 1
#define	FRF_AB_XX_RSTPLLAB_EN_LBN 8
#define	FRF_AB_XX_RSTPLLAB_EN_WIDTH 1
#define	FRF_AB_XX_RESETD_EN_LBN 7
#define	FRF_AB_XX_RESETD_EN_WIDTH 1
#define	FRF_AB_XX_RESETC_EN_LBN 6
#define	FRF_AB_XX_RESETC_EN_WIDTH 1
#define	FRF_AB_XX_RESETB_EN_LBN 5
#define	FRF_AB_XX_RESETB_EN_WIDTH 1
#define	FRF_AB_XX_RESETA_EN_LBN 4
#define	FRF_AB_XX_RESETA_EN_WIDTH 1
#define	FRF_AB_XX_RSTXGXSRX_EN_LBN 2
#define	FRF_AB_XX_RSTXGXSRX_EN_WIDTH 1
#define	FRF_AB_XX_RSTXGXSTX_EN_LBN 1
#define	FRF_AB_XX_RSTXGXSTX_EN_WIDTH 1
#define	FRF_AB_XX_RST_XX_EN_LBN 0
#define	FRF_AB_XX_RST_XX_EN_WIDTH 1

/* XX_SD_CTL_REG: XGXS/XAUI powerdown/reset control register */
#define	FR_AB_XX_SD_CTL 0x00001310
#define	FRF_AB_XX_TERMADJ1_LBN 17
#define	FRF_AB_XX_TERMADJ1_WIDTH 1
#define	FRF_AB_XX_TERMADJ0_LBN 16
#define	FRF_AB_XX_TERMADJ0_WIDTH 1
#define	FRF_AB_XX_HIDRVD_LBN 15
#define	FRF_AB_XX_HIDRVD_WIDTH 1
#define	FRF_AB_XX_LODRVD_LBN 14
#define	FRF_AB_XX_LODRVD_WIDTH 1
#define	FRF_AB_XX_HIDRVC_LBN 13
#define	FRF_AB_XX_HIDRVC_WIDTH 1
#define	FRF_AB_XX_LODRVC_LBN 12
#define	FRF_AB_XX_LODRVC_WIDTH 1
#define	FRF_AB_XX_HIDRVB_LBN 11
#define	FRF_AB_XX_HIDRVB_WIDTH 1
#define	FRF_AB_XX_LODRVB_LBN 10
#define	FRF_AB_XX_LODRVB_WIDTH 1
#define	FRF_AB_XX_HIDRVA_LBN 9
#define	FRF_AB_XX_HIDRVA_WIDTH 1
#define	FRF_AB_XX_LODRVA_LBN 8
#define	FRF_AB_XX_LODRVA_WIDTH 1
#define	FRF_AB_XX_LPBKD_LBN 3
#define	FRF_AB_XX_LPBKD_WIDTH 1
#define	FRF_AB_XX_LPBKC_LBN 2
#define	FRF_AB_XX_LPBKC_WIDTH 1
#define	FRF_AB_XX_LPBKB_LBN 1
#define	FRF_AB_XX_LPBKB_WIDTH 1
#define	FRF_AB_XX_LPBKA_LBN 0
#define	FRF_AB_XX_LPBKA_WIDTH 1

/* XX_TXDRV_CTL_REG: XAUI SerDes transmit drive control register */
#define	FR_AB_XX_TXDRV_CTL 0x00001320
#define	FRF_AB_XX_DEQD_LBN 28
#define	FRF_AB_XX_DEQD_WIDTH 4
#define	FRF_AB_XX_DEQC_LBN 24
#define	FRF_AB_XX_DEQC_WIDTH 4
#define	FRF_AB_XX_DEQB_LBN 20
#define	FRF_AB_XX_DEQB_WIDTH 4
#define	FRF_AB_XX_DEQA_LBN 16
#define	FRF_AB_XX_DEQA_WIDTH 4
#define	FRF_AB_XX_DTXD_LBN 12
#define	FRF_AB_XX_DTXD_WIDTH 4
#define	FRF_AB_XX_DTXC_LBN 8
#define	FRF_AB_XX_DTXC_WIDTH 4
#define	FRF_AB_XX_DTXB_LBN 4
#define	FRF_AB_XX_DTXB_WIDTH 4
#define	FRF_AB_XX_DTXA_LBN 0
#define	FRF_AB_XX_DTXA_WIDTH 4

/* XX_PRBS_CTL_REG: documentation to be written for sum_XX_PRBS_CTL_REG */
#define	FR_AB_XX_PRBS_CTL 0x00001330
#define	FRF_AB_XX_CH3_RX_PRBS_SEL_LBN 30
#define	FRF_AB_XX_CH3_RX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH3_RX_PRBS_INV_LBN 29
#define	FRF_AB_XX_CH3_RX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH3_RX_PRBS_CHKEN_LBN 28
#define	FRF_AB_XX_CH3_RX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH2_RX_PRBS_SEL_LBN 26
#define	FRF_AB_XX_CH2_RX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH2_RX_PRBS_INV_LBN 25
#define	FRF_AB_XX_CH2_RX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH2_RX_PRBS_CHKEN_LBN 24
#define	FRF_AB_XX_CH2_RX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH1_RX_PRBS_SEL_LBN 22
#define	FRF_AB_XX_CH1_RX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH1_RX_PRBS_INV_LBN 21
#define	FRF_AB_XX_CH1_RX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH1_RX_PRBS_CHKEN_LBN 20
#define	FRF_AB_XX_CH1_RX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH0_RX_PRBS_SEL_LBN 18
#define	FRF_AB_XX_CH0_RX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH0_RX_PRBS_INV_LBN 17
#define	FRF_AB_XX_CH0_RX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH0_RX_PRBS_CHKEN_LBN 16
#define	FRF_AB_XX_CH0_RX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH3_TX_PRBS_SEL_LBN 14
#define	FRF_AB_XX_CH3_TX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH3_TX_PRBS_INV_LBN 13
#define	FRF_AB_XX_CH3_TX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH3_TX_PRBS_CHKEN_LBN 12
#define	FRF_AB_XX_CH3_TX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH2_TX_PRBS_SEL_LBN 10
#define	FRF_AB_XX_CH2_TX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH2_TX_PRBS_INV_LBN 9
#define	FRF_AB_XX_CH2_TX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH2_TX_PRBS_CHKEN_LBN 8
#define	FRF_AB_XX_CH2_TX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH1_TX_PRBS_SEL_LBN 6
#define	FRF_AB_XX_CH1_TX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH1_TX_PRBS_INV_LBN 5
#define	FRF_AB_XX_CH1_TX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH1_TX_PRBS_CHKEN_LBN 4
#define	FRF_AB_XX_CH1_TX_PRBS_CHKEN_WIDTH 1
#define	FRF_AB_XX_CH0_TX_PRBS_SEL_LBN 2
#define	FRF_AB_XX_CH0_TX_PRBS_SEL_WIDTH 2
#define	FRF_AB_XX_CH0_TX_PRBS_INV_LBN 1
#define	FRF_AB_XX_CH0_TX_PRBS_INV_WIDTH 1
#define	FRF_AB_XX_CH0_TX_PRBS_CHKEN_LBN 0
#define	FRF_AB_XX_CH0_TX_PRBS_CHKEN_WIDTH 1

/* XX_PRBS_CHK_REG: documentation to be written for sum_XX_PRBS_CHK_REG */
#define	FR_AB_XX_PRBS_CHK 0x00001340
#define	FRF_AB_XX_REV_LB_EN_LBN 16
#define	FRF_AB_XX_REV_LB_EN_WIDTH 1
#define	FRF_AB_XX_CH3_DEG_DET_LBN 15
#define	FRF_AB_XX_CH3_DEG_DET_WIDTH 1
#define	FRF_AB_XX_CH3_LFSR_LOCK_IND_LBN 14
#define	FRF_AB_XX_CH3_LFSR_LOCK_IND_WIDTH 1
#define	FRF_AB_XX_CH3_PRBS_FRUN_LBN 13
#define	FRF_AB_XX_CH3_PRBS_FRUN_WIDTH 1
#define	FRF_AB_XX_CH3_ERR_CHK_LBN 12
#define	FRF_AB_XX_CH3_ERR_CHK_WIDTH 1
#define	FRF_AB_XX_CH2_DEG_DET_LBN 11
#define	FRF_AB_XX_CH2_DEG_DET_WIDTH 1
#define	FRF_AB_XX_CH2_LFSR_LOCK_IND_LBN 10
#define	FRF_AB_XX_CH2_LFSR_LOCK_IND_WIDTH 1
#define	FRF_AB_XX_CH2_PRBS_FRUN_LBN 9
#define	FRF_AB_XX_CH2_PRBS_FRUN_WIDTH 1
#define	FRF_AB_XX_CH2_ERR_CHK_LBN 8
#define	FRF_AB_XX_CH2_ERR_CHK_WIDTH 1
#define	FRF_AB_XX_CH1_DEG_DET_LBN 7
#define	FRF_AB_XX_CH1_DEG_DET_WIDTH 1
#define	FRF_AB_XX_CH1_LFSR_LOCK_IND_LBN 6
#define	FRF_AB_XX_CH1_LFSR_LOCK_IND_WIDTH 1
#define	FRF_AB_XX_CH1_PRBS_FRUN_LBN 5
#define	FRF_AB_XX_CH1_PRBS_FRUN_WIDTH 1
#define	FRF_AB_XX_CH1_ERR_CHK_LBN 4
#define	FRF_AB_XX_CH1_ERR_CHK_WIDTH 1
#define	FRF_AB_XX_CH0_DEG_DET_LBN 3
#define	FRF_AB_XX_CH0_DEG_DET_WIDTH 1
#define	FRF_AB_XX_CH0_LFSR_LOCK_IND_LBN 2
#define	FRF_AB_XX_CH0_LFSR_LOCK_IND_WIDTH 1
#define	FRF_AB_XX_CH0_PRBS_FRUN_LBN 1
#define	FRF_AB_XX_CH0_PRBS_FRUN_WIDTH 1
#define	FRF_AB_XX_CH0_ERR_CHK_LBN 0
#define	FRF_AB_XX_CH0_ERR_CHK_WIDTH 1

/* XX_PRBS_ERR_REG: documentation to be written for sum_XX_PRBS_ERR_REG */
#define	FR_AB_XX_PRBS_ERR 0x00001350
#define	FRF_AB_XX_CH3_PRBS_ERR_CNT_LBN 24
#define	FRF_AB_XX_CH3_PRBS_ERR_CNT_WIDTH 8
#define	FRF_AB_XX_CH2_PRBS_ERR_CNT_LBN 16
#define	FRF_AB_XX_CH2_PRBS_ERR_CNT_WIDTH 8
#define	FRF_AB_XX_CH1_PRBS_ERR_CNT_LBN 8
#define	FRF_AB_XX_CH1_PRBS_ERR_CNT_WIDTH 8
#define	FRF_AB_XX_CH0_PRBS_ERR_CNT_LBN 0
#define	FRF_AB_XX_CH0_PRBS_ERR_CNT_WIDTH 8

/* XX_CORE_STAT_REG: XAUI XGXS core status register */
#define	FR_AB_XX_CORE_STAT 0x00001360
#define	FRF_AB_XX_FORCE_SIG3_LBN 31
#define	FRF_AB_XX_FORCE_SIG3_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG3_VAL_LBN 30
#define	FRF_AB_XX_FORCE_SIG3_VAL_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG2_LBN 29
#define	FRF_AB_XX_FORCE_SIG2_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG2_VAL_LBN 28
#define	FRF_AB_XX_FORCE_SIG2_VAL_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG1_LBN 27
#define	FRF_AB_XX_FORCE_SIG1_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG1_VAL_LBN 26
#define	FRF_AB_XX_FORCE_SIG1_VAL_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG0_LBN 25
#define	FRF_AB_XX_FORCE_SIG0_WIDTH 1
#define	FRF_AB_XX_FORCE_SIG0_VAL_LBN 24
#define	FRF_AB_XX_FORCE_SIG0_VAL_WIDTH 1
#define	FRF_AB_XX_XGXS_LB_EN_LBN 23
#define	FRF_AB_XX_XGXS_LB_EN_WIDTH 1
#define	FRF_AB_XX_XGMII_LB_EN_LBN 22
#define	FRF_AB_XX_XGMII_LB_EN_WIDTH 1
#define	FRF_AB_XX_MATCH_FAULT_LBN 21
#define	FRF_AB_XX_MATCH_FAULT_WIDTH 1
#define	FRF_AB_XX_ALIGN_DONE_LBN 20
#define	FRF_AB_XX_ALIGN_DONE_WIDTH 1
#define	FRF_AB_XX_SYNC_STAT3_LBN 19
#define	FRF_AB_XX_SYNC_STAT3_WIDTH 1
#define	FRF_AB_XX_SYNC_STAT2_LBN 18
#define	FRF_AB_XX_SYNC_STAT2_WIDTH 1
#define	FRF_AB_XX_SYNC_STAT1_LBN 17
#define	FRF_AB_XX_SYNC_STAT1_WIDTH 1
#define	FRF_AB_XX_SYNC_STAT0_LBN 16
#define	FRF_AB_XX_SYNC_STAT0_WIDTH 1
#define	FRF_AB_XX_COMMA_DET_CH3_LBN 15
#define	FRF_AB_XX_COMMA_DET_CH3_WIDTH 1
#define	FRF_AB_XX_COMMA_DET_CH2_LBN 14
#define	FRF_AB_XX_COMMA_DET_CH2_WIDTH 1
#define	FRF_AB_XX_COMMA_DET_CH1_LBN 13
#define	FRF_AB_XX_COMMA_DET_CH1_WIDTH 1
#define	FRF_AB_XX_COMMA_DET_CH0_LBN 12
#define	FRF_AB_XX_COMMA_DET_CH0_WIDTH 1
#define	FRF_AB_XX_CGRP_ALIGN_CH3_LBN 11
#define	FRF_AB_XX_CGRP_ALIGN_CH3_WIDTH 1
#define	FRF_AB_XX_CGRP_ALIGN_CH2_LBN 10
#define	FRF_AB_XX_CGRP_ALIGN_CH2_WIDTH 1
#define	FRF_AB_XX_CGRP_ALIGN_CH1_LBN 9
#define	FRF_AB_XX_CGRP_ALIGN_CH1_WIDTH 1
#define	FRF_AB_XX_CGRP_ALIGN_CH0_LBN 8
#define	FRF_AB_XX_CGRP_ALIGN_CH0_WIDTH 1
#define	FRF_AB_XX_CHAR_ERR_CH3_LBN 7
#define	FRF_AB_XX_CHAR_ERR_CH3_WIDTH 1
#define	FRF_AB_XX_CHAR_ERR_CH2_LBN 6
#define	FRF_AB_XX_CHAR_ERR_CH2_WIDTH 1
#define	FRF_AB_XX_CHAR_ERR_CH1_LBN 5
#define	FRF_AB_XX_CHAR_ERR_CH1_WIDTH 1
#define	FRF_AB_XX_CHAR_ERR_CH0_LBN 4
#define	FRF_AB_XX_CHAR_ERR_CH0_WIDTH 1
#define	FRF_AB_XX_DISPERR_CH3_LBN 3
#define	FRF_AB_XX_DISPERR_CH3_WIDTH 1
#define	FRF_AB_XX_DISPERR_CH2_LBN 2
#define	FRF_AB_XX_DISPERR_CH2_WIDTH 1
#define	FRF_AB_XX_DISPERR_CH1_LBN 1
#define	FRF_AB_XX_DISPERR_CH1_WIDTH 1
#define	FRF_AB_XX_DISPERR_CH0_LBN 0
#define	FRF_AB_XX_DISPERR_CH0_WIDTH 1

/* RX_DESC_PTR_TBL_KER: Receive descriptor pointer table */
#define	FR_AA_RX_DESC_PTR_TBL_KER 0x00011800
#define	FR_AA_RX_DESC_PTR_TBL_KER_STEP 16
#define	FR_AA_RX_DESC_PTR_TBL_KER_ROWS 4
/* RX_DESC_PTR_TBL: Receive descriptor pointer table */
#define	FR_BZ_RX_DESC_PTR_TBL 0x00f40000
#define	FR_BZ_RX_DESC_PTR_TBL_STEP 16
#define	FR_BB_RX_DESC_PTR_TBL_ROWS 4096
#define	FR_CZ_RX_DESC_PTR_TBL_ROWS 1024
#define	FRF_CZ_RX_HDR_SPLIT_LBN 90
#define	FRF_CZ_RX_HDR_SPLIT_WIDTH 1
#define	FRF_AA_RX_RESET_LBN 89
#define	FRF_AA_RX_RESET_WIDTH 1
#define	FRF_AZ_RX_ISCSI_DDIG_EN_LBN 88
#define	FRF_AZ_RX_ISCSI_DDIG_EN_WIDTH 1
#define	FRF_AZ_RX_ISCSI_HDIG_EN_LBN 87
#define	FRF_AZ_RX_ISCSI_HDIG_EN_WIDTH 1
#define	FRF_AZ_RX_DESC_PREF_ACT_LBN 86
#define	FRF_AZ_RX_DESC_PREF_ACT_WIDTH 1
#define	FRF_AZ_RX_DC_HW_RPTR_LBN 80
#define	FRF_AZ_RX_DC_HW_RPTR_WIDTH 6
#define	FRF_AZ_RX_DESCQ_HW_RPTR_LBN 68
#define	FRF_AZ_RX_DESCQ_HW_RPTR_WIDTH 12
#define	FRF_AZ_RX_DESCQ_SW_WPTR_LBN 56
#define	FRF_AZ_RX_DESCQ_SW_WPTR_WIDTH 12
#define	FRF_AZ_RX_DESCQ_BUF_BASE_ID_LBN 36
#define	FRF_AZ_RX_DESCQ_BUF_BASE_ID_WIDTH 20
#define	FRF_AZ_RX_DESCQ_EVQ_ID_LBN 24
#define	FRF_AZ_RX_DESCQ_EVQ_ID_WIDTH 12
#define	FRF_AZ_RX_DESCQ_OWNER_ID_LBN 10
#define	FRF_AZ_RX_DESCQ_OWNER_ID_WIDTH 14
#define	FRF_AZ_RX_DESCQ_LABEL_LBN 5
#define	FRF_AZ_RX_DESCQ_LABEL_WIDTH 5
#define	FRF_AZ_RX_DESCQ_SIZE_LBN 3
#define	FRF_AZ_RX_DESCQ_SIZE_WIDTH 2
#define	FFE_AZ_RX_DESCQ_SIZE_4K 3
#define	FFE_AZ_RX_DESCQ_SIZE_2K 2
#define	FFE_AZ_RX_DESCQ_SIZE_1K 1
#define	FFE_AZ_RX_DESCQ_SIZE_512 0
#define	FRF_AZ_RX_DESCQ_TYPE_LBN 2
#define	FRF_AZ_RX_DESCQ_TYPE_WIDTH 1
#define	FRF_AZ_RX_DESCQ_JUMBO_LBN 1
#define	FRF_AZ_RX_DESCQ_JUMBO_WIDTH 1
#define	FRF_AZ_RX_DESCQ_EN_LBN 0
#define	FRF_AZ_RX_DESCQ_EN_WIDTH 1

/* TX_DESC_PTR_TBL_KER: Transmit descriptor pointer */
#define	FR_AA_TX_DESC_PTR_TBL_KER 0x00011900
#define	FR_AA_TX_DESC_PTR_TBL_KER_STEP 16
#define	FR_AA_TX_DESC_PTR_TBL_KER_ROWS 8
/* TX_DESC_PTR_TBL: Transmit descriptor pointer */
#define	FR_BZ_TX_DESC_PTR_TBL 0x00f50000
#define	FR_BZ_TX_DESC_PTR_TBL_STEP 16
#define	FR_BB_TX_DESC_PTR_TBL_ROWS 4096
#define	FR_CZ_TX_DESC_PTR_TBL_ROWS 1024
#define	FRF_CZ_TX_DPT_Q_MASK_WIDTH_LBN 94
#define	FRF_CZ_TX_DPT_Q_MASK_WIDTH_WIDTH 2
#define	FRF_CZ_TX_DPT_ETH_FILT_EN_LBN 93
#define	FRF_CZ_TX_DPT_ETH_FILT_EN_WIDTH 1
#define	FRF_CZ_TX_DPT_IP_FILT_EN_LBN 92
#define	FRF_CZ_TX_DPT_IP_FILT_EN_WIDTH 1
#define	FRF_BZ_TX_NON_IP_DROP_DIS_LBN 91
#define	FRF_BZ_TX_NON_IP_DROP_DIS_WIDTH 1
#define	FRF_BZ_TX_IP_CHKSM_DIS_LBN 90
#define	FRF_BZ_TX_IP_CHKSM_DIS_WIDTH 1
#define	FRF_BZ_TX_TCP_CHKSM_DIS_LBN 89
#define	FRF_BZ_TX_TCP_CHKSM_DIS_WIDTH 1
#define	FRF_AZ_TX_DESCQ_EN_LBN 88
#define	FRF_AZ_TX_DESCQ_EN_WIDTH 1
#define	FRF_AZ_TX_ISCSI_DDIG_EN_LBN 87
#define	FRF_AZ_TX_ISCSI_DDIG_EN_WIDTH 1
#define	FRF_AZ_TX_ISCSI_HDIG_EN_LBN 86
#define	FRF_AZ_TX_ISCSI_HDIG_EN_WIDTH 1
#define	FRF_AZ_TX_DC_HW_RPTR_LBN 80
#define	FRF_AZ_TX_DC_HW_RPTR_WIDTH 6
#define	FRF_AZ_TX_DESCQ_HW_RPTR_LBN 68
#define	FRF_AZ_TX_DESCQ_HW_RPTR_WIDTH 12
#define	FRF_AZ_TX_DESCQ_SW_WPTR_LBN 56
#define	FRF_AZ_TX_DESCQ_SW_WPTR_WIDTH 12
#define	FRF_AZ_TX_DESCQ_BUF_BASE_ID_LBN 36
#define	FRF_AZ_TX_DESCQ_BUF_BASE_ID_WIDTH 20
#define	FRF_AZ_TX_DESCQ_EVQ_ID_LBN 24
#define	FRF_AZ_TX_DESCQ_EVQ_ID_WIDTH 12
#define	FRF_AZ_TX_DESCQ_OWNER_ID_LBN 10
#define	FRF_AZ_TX_DESCQ_OWNER_ID_WIDTH 14
#define	FRF_AZ_TX_DESCQ_LABEL_LBN 5
#define	FRF_AZ_TX_DESCQ_LABEL_WIDTH 5
#define	FRF_AZ_TX_DESCQ_SIZE_LBN 3
#define	FRF_AZ_TX_DESCQ_SIZE_WIDTH 2
#define	FFE_AZ_TX_DESCQ_SIZE_4K 3
#define	FFE_AZ_TX_DESCQ_SIZE_2K 2
#define	FFE_AZ_TX_DESCQ_SIZE_1K 1
#define	FFE_AZ_TX_DESCQ_SIZE_512 0
#define	FRF_AZ_TX_DESCQ_TYPE_LBN 1
#define	FRF_AZ_TX_DESCQ_TYPE_WIDTH 2
#define	FRF_AZ_TX_DESCQ_FLUSH_LBN 0
#define	FRF_AZ_TX_DESCQ_FLUSH_WIDTH 1

/* EVQ_PTR_TBL_KER: Event queue pointer table */
#define	FR_AA_EVQ_PTR_TBL_KER 0x00011a00
#define	FR_AA_EVQ_PTR_TBL_KER_STEP 16
#define	FR_AA_EVQ_PTR_TBL_KER_ROWS 4
/* EVQ_PTR_TBL: Event queue pointer table */
#define	FR_BZ_EVQ_PTR_TBL 0x00f60000
#define	FR_BZ_EVQ_PTR_TBL_STEP 16
#define	FR_CZ_EVQ_PTR_TBL_ROWS 1024
#define	FR_BB_EVQ_PTR_TBL_ROWS 4096
#define	FRF_BZ_EVQ_RPTR_IGN_LBN 40
#define	FRF_BZ_EVQ_RPTR_IGN_WIDTH 1
#define	FRF_AB_EVQ_WKUP_OR_INT_EN_LBN 39
#define	FRF_AB_EVQ_WKUP_OR_INT_EN_WIDTH 1
#define	FRF_CZ_EVQ_DOS_PROTECT_EN_LBN 39
#define	FRF_CZ_EVQ_DOS_PROTECT_EN_WIDTH 1
#define	FRF_AZ_EVQ_NXT_WPTR_LBN 24
#define	FRF_AZ_EVQ_NXT_WPTR_WIDTH 15
#define	FRF_AZ_EVQ_EN_LBN 23
#define	FRF_AZ_EVQ_EN_WIDTH 1
#define	FRF_AZ_EVQ_SIZE_LBN 20
#define	FRF_AZ_EVQ_SIZE_WIDTH 3
#define	FFE_AZ_EVQ_SIZE_32K 6
#define	FFE_AZ_EVQ_SIZE_16K 5
#define	FFE_AZ_EVQ_SIZE_8K 4
#define	FFE_AZ_EVQ_SIZE_4K 3
#define	FFE_AZ_EVQ_SIZE_2K 2
#define	FFE_AZ_EVQ_SIZE_1K 1
#define	FFE_AZ_EVQ_SIZE_512 0
#define	FRF_AZ_EVQ_BUF_BASE_ID_LBN 0
#define	FRF_AZ_EVQ_BUF_BASE_ID_WIDTH 20

/* BUF_HALF_TBL_KER: Buffer table in half buffer table mode direct access by driver */
#define	FR_AA_BUF_HALF_TBL_KER 0x00018000
#define	FR_AA_BUF_HALF_TBL_KER_STEP 8
#define	FR_AA_BUF_HALF_TBL_KER_ROWS 4096
/* BUF_HALF_TBL: Buffer table in half buffer table mode direct access by driver */
#define	FR_BZ_BUF_HALF_TBL 0x00800000
#define	FR_BZ_BUF_HALF_TBL_STEP 8
#define	FR_CZ_BUF_HALF_TBL_ROWS 147456
#define	FR_BB_BUF_HALF_TBL_ROWS 524288
#define	FRF_AZ_BUF_ADR_HBUF_ODD_LBN 44
#define	FRF_AZ_BUF_ADR_HBUF_ODD_WIDTH 20
#define	FRF_AZ_BUF_OWNER_ID_HBUF_ODD_LBN 32
#define	FRF_AZ_BUF_OWNER_ID_HBUF_ODD_WIDTH 12
#define	FRF_AZ_BUF_ADR_HBUF_EVEN_LBN 12
#define	FRF_AZ_BUF_ADR_HBUF_EVEN_WIDTH 20
#define	FRF_AZ_BUF_OWNER_ID_HBUF_EVEN_LBN 0
#define	FRF_AZ_BUF_OWNER_ID_HBUF_EVEN_WIDTH 12

/* BUF_FULL_TBL_KER: Buffer table in full buffer table mode direct access by driver */
#define	FR_AA_BUF_FULL_TBL_KER 0x00018000
#define	FR_AA_BUF_FULL_TBL_KER_STEP 8
#define	FR_AA_BUF_FULL_TBL_KER_ROWS 4096
/* BUF_FULL_TBL: Buffer table in full buffer table mode direct access by driver */
#define	FR_BZ_BUF_FULL_TBL 0x00800000
#define	FR_BZ_BUF_FULL_TBL_STEP 8
#define	FR_CZ_BUF_FULL_TBL_ROWS 147456
#define	FR_BB_BUF_FULL_TBL_ROWS 917504
#define	FRF_AZ_BUF_FULL_UNUSED_LBN 51
#define	FRF_AZ_BUF_FULL_UNUSED_WIDTH 13
#define	FRF_AZ_IP_DAT_BUF_SIZE_LBN 50
#define	FRF_AZ_IP_DAT_BUF_SIZE_WIDTH 1
#define	FRF_AZ_BUF_ADR_REGION_LBN 48
#define	FRF_AZ_BUF_ADR_REGION_WIDTH 2
#define	FFE_AZ_BUF_ADR_REGN3 3
#define	FFE_AZ_BUF_ADR_REGN2 2
#define	FFE_AZ_BUF_ADR_REGN1 1
#define	FFE_AZ_BUF_ADR_REGN0 0
#define	FRF_AZ_BUF_ADR_FBUF_LBN 14
#define	FRF_AZ_BUF_ADR_FBUF_WIDTH 34
#define	FRF_AZ_BUF_OWNER_ID_FBUF_LBN 0
#define	FRF_AZ_BUF_OWNER_ID_FBUF_WIDTH 14

/* RX_FILTER_TBL0: TCP/IPv4 Receive filter table */
#define	FR_BZ_RX_FILTER_TBL0 0x00f00000
#define	FR_BZ_RX_FILTER_TBL0_STEP 32
#define	FR_BZ_RX_FILTER_TBL0_ROWS 8192
/* RX_FILTER_TBL1: TCP/IPv4 Receive filter table */
#define	FR_BB_RX_FILTER_TBL1 0x00f00010
#define	FR_BB_RX_FILTER_TBL1_STEP 32
#define	FR_BB_RX_FILTER_TBL1_ROWS 8192
#define	FRF_BZ_RSS_EN_LBN 110
#define	FRF_BZ_RSS_EN_WIDTH 1
#define	FRF_BZ_SCATTER_EN_LBN 109
#define	FRF_BZ_SCATTER_EN_WIDTH 1
#define	FRF_BZ_TCP_UDP_LBN 108
#define	FRF_BZ_TCP_UDP_WIDTH 1
#define	FRF_BZ_RXQ_ID_LBN 96
#define	FRF_BZ_RXQ_ID_WIDTH 12
#define	FRF_BZ_DEST_IP_LBN 64
#define	FRF_BZ_DEST_IP_WIDTH 32
#define	FRF_BZ_DEST_PORT_TCP_LBN 48
#define	FRF_BZ_DEST_PORT_TCP_WIDTH 16
#define	FRF_BZ_SRC_IP_LBN 16
#define	FRF_BZ_SRC_IP_WIDTH 32
#define	FRF_BZ_SRC_TCP_DEST_UDP_LBN 0
#define	FRF_BZ_SRC_TCP_DEST_UDP_WIDTH 16

/* RX_MAC_FILTER_TBL0: Receive Ethernet filter table */
#define	FR_CZ_RX_MAC_FILTER_TBL0 0x00f00010
#define	FR_CZ_RX_MAC_FILTER_TBL0_STEP 32
#define	FR_CZ_RX_MAC_FILTER_TBL0_ROWS 512
#define	FRF_CZ_RMFT_RSS_EN_LBN 75
#define	FRF_CZ_RMFT_RSS_EN_WIDTH 1
#define	FRF_CZ_RMFT_SCATTER_EN_LBN 74
#define	FRF_CZ_RMFT_SCATTER_EN_WIDTH 1
#define	FRF_CZ_RMFT_IP_OVERRIDE_LBN 73
#define	FRF_CZ_RMFT_IP_OVERRIDE_WIDTH 1
#define	FRF_CZ_RMFT_RXQ_ID_LBN 61
#define	FRF_CZ_RMFT_RXQ_ID_WIDTH 12
#define	FRF_CZ_RMFT_WILDCARD_MATCH_LBN 60
#define	FRF_CZ_RMFT_WILDCARD_MATCH_WIDTH 1
#define	FRF_CZ_RMFT_DEST_MAC_LBN 12
#define	FRF_CZ_RMFT_DEST_MAC_WIDTH 48
#define	FRF_CZ_RMFT_VLAN_ID_LBN 0
#define	FRF_CZ_RMFT_VLAN_ID_WIDTH 12

/* TIMER_TBL: Timer table */
#define	FR_BZ_TIMER_TBL 0x00f70000
#define	FR_BZ_TIMER_TBL_STEP 16
#define	FR_CZ_TIMER_TBL_ROWS 1024
#define	FR_BB_TIMER_TBL_ROWS 4096
#define	FRF_CZ_TIMER_Q_EN_LBN 33
#define	FRF_CZ_TIMER_Q_EN_WIDTH 1
#define	FRF_CZ_INT_ARMD_LBN 32
#define	FRF_CZ_INT_ARMD_WIDTH 1
#define	FRF_CZ_INT_PEND_LBN 31
#define	FRF_CZ_INT_PEND_WIDTH 1
#define	FRF_CZ_HOST_NOTIFY_MODE_LBN 30
#define	FRF_CZ_HOST_NOTIFY_MODE_WIDTH 1
#define	FRF_CZ_RELOAD_TIMER_VAL_LBN 16
#define	FRF_CZ_RELOAD_TIMER_VAL_WIDTH 14
#define	FRF_CZ_TIMER_MODE_LBN 14
#define	FRF_CZ_TIMER_MODE_WIDTH 2
#define	FFE_CZ_TIMER_MODE_INT_HLDOFF 3
#define	FFE_CZ_TIMER_MODE_TRIG_START 2
#define	FFE_CZ_TIMER_MODE_IMMED_START 1
#define	FFE_CZ_TIMER_MODE_DIS 0
#define	FRF_BB_TIMER_MODE_LBN 12
#define	FRF_BB_TIMER_MODE_WIDTH 2
#define	FFE_BB_TIMER_MODE_INT_HLDOFF 2
#define	FFE_BB_TIMER_MODE_TRIG_START 2
#define	FFE_BB_TIMER_MODE_IMMED_START 1
#define	FFE_BB_TIMER_MODE_DIS 0
#define	FRF_CZ_TIMER_VAL_LBN 0
#define	FRF_CZ_TIMER_VAL_WIDTH 14
#define	FRF_BB_TIMER_VAL_LBN 0
#define	FRF_BB_TIMER_VAL_WIDTH 12

/* TX_PACE_TBL: Transmit pacing table */
#define	FR_BZ_TX_PACE_TBL 0x00f80000
#define	FR_BZ_TX_PACE_TBL_STEP 16
#define	FR_CZ_TX_PACE_TBL_ROWS 1024
#define	FR_BB_TX_PACE_TBL_ROWS 4096
#define	FRF_BZ_TX_PACE_LBN 0
#define	FRF_BZ_TX_PACE_WIDTH 5

/* RX_INDIRECTION_TBL: RX Indirection Table */
#define	FR_BZ_RX_INDIRECTION_TBL 0x00fb0000
#define	FR_BZ_RX_INDIRECTION_TBL_STEP 16
#define	FR_BZ_RX_INDIRECTION_TBL_ROWS 128
#define	FRF_BZ_IT_QUEUE_LBN 0
#define	FRF_BZ_IT_QUEUE_WIDTH 6

/* TX_FILTER_TBL0: TCP/IPv4 Transmit filter table */
#define	FR_CZ_TX_FILTER_TBL0 0x00fc0000
#define	FR_CZ_TX_FILTER_TBL0_STEP 16
#define	FR_CZ_TX_FILTER_TBL0_ROWS 8192
#define	FRF_CZ_TIFT_TCP_UDP_LBN 108
#define	FRF_CZ_TIFT_TCP_UDP_WIDTH 1
#define	FRF_CZ_TIFT_TXQ_ID_LBN 96
#define	FRF_CZ_TIFT_TXQ_ID_WIDTH 12
#define	FRF_CZ_TIFT_DEST_IP_LBN 64
#define	FRF_CZ_TIFT_DEST_IP_WIDTH 32
#define	FRF_CZ_TIFT_DEST_PORT_TCP_LBN 48
#define	FRF_CZ_TIFT_DEST_PORT_TCP_WIDTH 16
#define	FRF_CZ_TIFT_SRC_IP_LBN 16
#define	FRF_CZ_TIFT_SRC_IP_WIDTH 32
#define	FRF_CZ_TIFT_SRC_TCP_DEST_UDP_LBN 0
#define	FRF_CZ_TIFT_SRC_TCP_DEST_UDP_WIDTH 16

/* TX_MAC_FILTER_TBL0: Transmit Ethernet filter table */
#define	FR_CZ_TX_MAC_FILTER_TBL0 0x00fe0000
#define	FR_CZ_TX_MAC_FILTER_TBL0_STEP 16
#define	FR_CZ_TX_MAC_FILTER_TBL0_ROWS 512
#define	FRF_CZ_TMFT_TXQ_ID_LBN 61
#define	FRF_CZ_TMFT_TXQ_ID_WIDTH 12
#define	FRF_CZ_TMFT_WILDCARD_MATCH_LBN 60
#define	FRF_CZ_TMFT_WILDCARD_MATCH_WIDTH 1
#define	FRF_CZ_TMFT_SRC_MAC_LBN 12
#define	FRF_CZ_TMFT_SRC_MAC_WIDTH 48
#define	FRF_CZ_TMFT_VLAN_ID_LBN 0
#define	FRF_CZ_TMFT_VLAN_ID_WIDTH 12

/* MC_TREG_SMEM: MC Shared Memory */
#define	FR_CZ_MC_TREG_SMEM 0x00ff0000
#define	FR_CZ_MC_TREG_SMEM_STEP 4
#define	FR_CZ_MC_TREG_SMEM_ROWS 512
#define	FRF_CZ_MC_TREG_SMEM_ROW_LBN 0
#define	FRF_CZ_MC_TREG_SMEM_ROW_WIDTH 32

/*
 * Register dump definition.  This is mostly taken from
 * linux-2.6/drivers/net/sfc/nic.c but has names and bitfield
 * definitions added.
 *
 * The definitions of efx_nic_regs and efx_nic_reg_tables should be
 * textually identical to those in the driver, though the structure
 * definitions and the macros REGISTER and REGISTER_TABLE_DIMENSIONS
 * are defined differently.
 */

#define REGISTER_REVISION_A	1
#define REGISTER_REVISION_B	2
#define REGISTER_REVISION_C	3
#define REGISTER_REVISION_Z	3	/* latest revision */

struct efx_nic_reg_field {
	const char *name;
	u32 lbn:7, width:8;
	u32 min_revision:2, max_revision:2;
};

#define REGISTER_FIELD_RENAME(name, display_name, min_rev, max_rev) {	\
	display_name,							\
	FRF_ ## min_rev ## max_rev ## _ ## name ## _LBN,		\
	FRF_ ## min_rev ## max_rev ## _ ## name ## _WIDTH,		\
	REGISTER_REVISION_ ## min_rev, REGISTER_REVISION_ ## max_rev	\
}
#define REGISTER_FIELD(name, min_rev, max_rev)			\
	REGISTER_FIELD_RENAME(name, #name, min_rev, max_rev)
#define REGISTER_FIELD_AA(name) REGISTER_FIELD(name, A, A)
#define REGISTER_FIELD_AB(name) REGISTER_FIELD(name, A, B)
#define REGISTER_FIELD_AZ(name) REGISTER_FIELD(name, A, Z)
#define REGISTER_FIELD_BB(name) REGISTER_FIELD(name, B, B)
#define REGISTER_FIELD_BZ(name) REGISTER_FIELD(name, B, Z)
#define REGISTER_FIELD_CZ(name) REGISTER_FIELD(name, C, Z)
#define REGISTER_FIELD_AZ_RENAME(name, display_name)	\
	REGISTER_FIELD_RENAME(name, display_name, A, Z)
#define REGISTER_FIELD_BZ_RENAME(name, display_name)	\
	REGISTER_FIELD_RENAME(name, display_name, B, Z)
#define REGISTER_FIELD_CZ_RENAME(name, display_name)	\
	REGISTER_FIELD_RENAME(name, display_name, C, Z)

static const struct efx_nic_reg_field efx_nic_reg_fields_ADR_REGION[] = {
	REGISTER_FIELD_AZ(ADR_REGION0),
	REGISTER_FIELD_AZ(ADR_REGION1),
	REGISTER_FIELD_AZ(ADR_REGION2),
	REGISTER_FIELD_AZ(ADR_REGION3),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_INT_EN_KER[] = {
	REGISTER_FIELD_AZ(DRV_INT_EN_KER),
	REGISTER_FIELD_AZ(KER_INT_KER),
	REGISTER_FIELD_AZ(KER_INT_CHAR),
	REGISTER_FIELD_AZ(KER_INT_LEVE_SEL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_INT_EN_CHAR[] = {
	REGISTER_FIELD_BZ(DRV_INT_EN_CHAR),
	REGISTER_FIELD_BZ(CHAR_INT_KER),
	REGISTER_FIELD_BZ(CHAR_INT_CHAR),
	REGISTER_FIELD_BZ(CHAR_INT_LEVE_SEL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_INT_ADR_KER[] = {
	REGISTER_FIELD_AZ(INT_ADR_KER),
	REGISTER_FIELD_AZ(NORM_INT_VEC_DIS_KER),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_INT_ADR_CHAR[] = {
	REGISTER_FIELD_BZ(INT_ADR_CHAR),
	REGISTER_FIELD_BZ(NORM_INT_VEC_DIS_CHAR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_HW_INIT[] = {
	REGISTER_FIELD_AZ(TLP_TD),
	REGISTER_FIELD_AZ(TD_SEL),
	REGISTER_FIELD_AZ(ATTR_SEL),
	REGISTER_FIELD_AZ(TLP_EP),
	REGISTER_FIELD_AZ(US_DISABLE),
	REGISTER_FIELD_AZ(WD_TIMER),
	REGISTER_FIELD_AB(INTA_VEC),
	REGISTER_FIELD_AB(INTB_VEC),
	REGISTER_FIELD_AZ(TLP_ATTR),
	REGISTER_FIELD_AZ(TLP_TC),
	REGISTER_FIELD_AZ(POST_WR_MASK),
	REGISTER_FIELD_BB(FC_BLOCKING_EN),
	REGISTER_FIELD_AA(B2B_REQ_EN),
	REGISTER_FIELD_BZ(B2B_REQ_EN),
	REGISTER_FIELD_AA(FC_BLOCKING_EN),
	REGISTER_FIELD_AB(PE_EIDLE_DIS),
	REGISTER_FIELD_AB(TX_RREQ_MASK_EN),
	REGISTER_FIELD_AZ(DOORBELL_DROP),
	REGISTER_FIELD_AB(TRGT_MASK_ALL),
	REGISTER_FIELD_CZ(TX_MRG_TAGS),
	REGISTER_FIELD_BB(PCIE_CPL_TIMEOUT_CTRL),
	REGISTER_FIELD_BB(BDMRD_CPLF_FULL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_USR_EV_CFG[] = {
	REGISTER_FIELD_CZ(DFLT_EVQ),
	REGISTER_FIELD_CZ(USREV_DIS),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EE_SPI_HCMD[] = {
	REGISTER_FIELD_AB(EE_SPI_HCMD_ENC),
	REGISTER_FIELD_AB(EE_SPI_HCMD_ADBCNT),
	REGISTER_FIELD_AB(EE_SPI_HCMD_DUBCNT),
	REGISTER_FIELD_AB(EE_SPI_HCMD_READ),
	REGISTER_FIELD_AB(EE_SPI_HCMD_DABCNT),
	REGISTER_FIELD_AB(EE_SPI_HCMD_SF_SEL),
	REGISTER_FIELD_AB(EE_WR_TIMER_ACTIVE),
	REGISTER_FIELD_AB(EE_SPI_HCMD_CMD_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EE_SPI_HADR[] = {
	REGISTER_FIELD_AB(EE_SPI_HADR_ADR),
	REGISTER_FIELD_AB(EE_SPI_HADR_DUBYTE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EE_SPI_HDATA[] = {
	REGISTER_FIELD_AB(EE_SPI_HDATA0),
	REGISTER_FIELD_AB(EE_SPI_HDATA1),
	REGISTER_FIELD_AB(EE_SPI_HDATA2),
	REGISTER_FIELD_AB(EE_SPI_HDATA3),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EE_BASE_PAGE[] = {
	REGISTER_FIELD_AB(EE_EXP_ROM_WINDOW_BASE),
	REGISTER_FIELD_AB(EE_EXPROM_MASK),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EE_VPD_CFG0[] = {
	REGISTER_FIELD_AB(EE_VPD_EN),
	REGISTER_FIELD_AB(EE_VPD_EN_AD9_MODE),
	REGISTER_FIELD_AB(EE_VPD_DEV_SF_SEL),
	REGISTER_FIELD_AB(EE_VPD_ACCESS_BLOCK),
	REGISTER_FIELD_AB(EE_VPD_ACCESS_ON),
	REGISTER_FIELD_AB(EE_VPD_AD_SIZE),
	REGISTER_FIELD_AB(EE_VPD_LENGTH),
	REGISTER_FIELD_AB(EE_VPD_BASE),
	REGISTER_FIELD_AB(EE_VPD_WR_CMD_EN),
	REGISTER_FIELD_AB(EE_VPDW_BASE),
	REGISTER_FIELD_AB(EE_VPDW_LENGTH),
	REGISTER_FIELD_AB(EE_EE_WR_TMR_VALUE),
	REGISTER_FIELD_AB(EE_EE_CLOCK_DIV),
	REGISTER_FIELD_AB(EE_VPD_WIP_POLL),
	REGISTER_FIELD_AB(EE_SF_CLOCK_DIV),
	REGISTER_FIELD_AB(EE_SF_FASTRD_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_NIC_STAT[] = {
	REGISTER_FIELD_AB(STRAP_PINS),
	REGISTER_FIELD_AB(ATE_MODE),
	REGISTER_FIELD_AB(EE_PRST),
	REGISTER_FIELD_AB(SF_PRST),
	REGISTER_FIELD_AB(ONCHIP_SRAM),
	REGISTER_FIELD_BB(REVISION_ID),
	REGISTER_FIELD_BB(EE_STRAP),
	REGISTER_FIELD_BB(EE_STRAP_EN),
	REGISTER_FIELD_BB(AER_DIS),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GPIO_CTL[] = {
	REGISTER_FIELD_AB(GPIO0_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO1_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO2_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO3_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO4_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO5_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO6_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO7_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO0_IN),
	REGISTER_FIELD_AB(GPIO1_IN),
	REGISTER_FIELD_AB(GPIO2_IN),
	REGISTER_FIELD_AB(GPIO3_IN),
	REGISTER_FIELD_AB(GPIO4_IN),
	REGISTER_FIELD_AB(GPIO5_IN),
	REGISTER_FIELD_AB(GPIO6_IN),
	REGISTER_FIELD_AB(GPIO7_IN),
	REGISTER_FIELD_AB(GPIO0_OUT),
	REGISTER_FIELD_AB(GPIO1_OUT),
	REGISTER_FIELD_AB(GPIO2_OUT),
	REGISTER_FIELD_AB(GPIO3_OUT),
	REGISTER_FIELD_AB(GPIO4_OUT),
	REGISTER_FIELD_AB(GPIO5_OUT),
	REGISTER_FIELD_AB(GPIO6_OUT),
	REGISTER_FIELD_AB(GPIO7_OUT),
	REGISTER_FIELD_AB(GPIO0_OEN),
	REGISTER_FIELD_AB(GPIO1_OEN),
	REGISTER_FIELD_AB(GPIO2_OEN),
	REGISTER_FIELD_AB(GPIO3_OEN),
	REGISTER_FIELD_AB(GPIO4_OEN),
	REGISTER_FIELD_AB(GPIO5_OEN),
	REGISTER_FIELD_AB(USE_NIC_CLK),
	REGISTER_FIELD_AB(CLK156_OUT_EN),
	REGISTER_FIELD_AB(GPIO8_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO9_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO10_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO11_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO12_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO13_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO14_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO15_PWRUP_VALUE),
	REGISTER_FIELD_AB(GPIO8_IN),
	REGISTER_FIELD_AB(GPIO9_IN),
	REGISTER_FIELD_AB(GPIO10_IN),
	REGISTER_FIELD_AB(GPIO11_IN),
	REGISTER_FIELD_AB(GPIO12_IN),
	REGISTER_FIELD_AB(GPIO13_IN),
	REGISTER_FIELD_AB(GPIO14_IN),
	REGISTER_FIELD_AB(GPIO15_IN),
	REGISTER_FIELD_AB(GPIO8_OUT),
	REGISTER_FIELD_AB(GPIO9_OUT),
	REGISTER_FIELD_AB(GPIO10_OUT),
	REGISTER_FIELD_AB(GPIO11_OUT),
	REGISTER_FIELD_AB(GPIO12_OUT),
	REGISTER_FIELD_AB(GPIO13_OUT),
	REGISTER_FIELD_AB(GPIO14_OUT),
	REGISTER_FIELD_AB(GPIO15_OUT),
	REGISTER_FIELD_AB(GPIO8_OEN),
	REGISTER_FIELD_AB(GPIO9_OEN),
	REGISTER_FIELD_AB(GPIO10_OEN),
	REGISTER_FIELD_AB(GPIO11_OEN),
	REGISTER_FIELD_AB(GPIO12_OEN),
	REGISTER_FIELD_AB(GPIO13_OEN),
	REGISTER_FIELD_AB(GPIO14_OEN),
	REGISTER_FIELD_AB(GPIO15_OEN),
	REGISTER_FIELD_AB(GPIO_PWRUP_VALUE2),
	REGISTER_FIELD_AB(GPIO_IN2),
	REGISTER_FIELD_AB(GPIO_OUT2),
	REGISTER_FIELD_AB(GPIO_PWRUP_VALUE3),
	REGISTER_FIELD_AB(GPIO_IN3),
	REGISTER_FIELD_AB(GPIO_OUT3),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GLB_CTL[] = {
	REGISTER_FIELD_AB(SWRST),
	REGISTER_FIELD_AB(EXT_PHY_RST_DUR),
	REGISTER_FIELD_AB(INT_RST_DUR),
	REGISTER_FIELD_AB(RST_CS),
	REGISTER_FIELD_AB(RST_SF),
	REGISTER_FIELD_AB(RST_TX),
	REGISTER_FIELD_AB(RST_RX),
	REGISTER_FIELD_AB(RST_SR),
	REGISTER_FIELD_AB(RST_EV),
	REGISTER_FIELD_AB(RST_EM),
	REGISTER_FIELD_AB(RST_XGTX),
	REGISTER_FIELD_AB(RST_XGRX),
	REGISTER_FIELD_AB(RST_PCIE_CORE),
	REGISTER_FIELD_AB(RST_PCIE_NSTKY),
	REGISTER_FIELD_AB(RST_PCIE_STKY),
	REGISTER_FIELD_BB(RST_BIU),
	REGISTER_FIELD_AA(RST_PCIX),
	REGISTER_FIELD_AB(RST_PCIE_SD),
	REGISTER_FIELD_AB(RST_XAUI_SD),
	REGISTER_FIELD_AB(RST_EXT_PHY),
	REGISTER_FIELD_AB(HOT_RST_CTL),
	REGISTER_FIELD_AB(CS_RST_CTL),
	REGISTER_FIELD_AB(EE_RST_CTL),
	REGISTER_FIELD_AB(TX_RST_CTL),
	REGISTER_FIELD_AB(RX_RST_CTL),
	REGISTER_FIELD_AB(SR_RST_CTL),
	REGISTER_FIELD_AB(EV_RST_CTL),
	REGISTER_FIELD_AB(EM_RST_CTL),
	REGISTER_FIELD_AB(XGTX_RST_CTL),
	REGISTER_FIELD_AB(XGRX_RST_CTL),
	REGISTER_FIELD_AB(PCIE_CORE_RST_CTL),
	REGISTER_FIELD_AB(PCIE_NSTKY_RST_CTL),
	REGISTER_FIELD_AB(PCIE_STKY_RST_CTL),
	REGISTER_FIELD_BB(BIU_RST_CTL),
	REGISTER_FIELD_AA(PCIX_RST_CTL),
	REGISTER_FIELD_AB(PCIE_SD_RST_CTL),
	REGISTER_FIELD_AB(XAUI_SD_RST_CTL),
	REGISTER_FIELD_AB(EXT_PHY_RST_CTL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_DP_CTRL[] = {
	REGISTER_FIELD_BZ(FLS_EVQ_ID),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MEM_STAT[] = {
	REGISTER_FIELD_CZ(MEM_PERR_VEC),
	REGISTER_FIELD_AB(MBIST_ERR),
	REGISTER_FIELD_AB(MBIST_CORR),
	REGISTER_FIELD_AB(MEM_PERR_VEC),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_CS_DEBUG[] = {
	/* This is not a complete list of fields */
	REGISTER_FIELD_AZ(CS_DEBUG_EN),
	REGISTER_FIELD_CZ(CS_PORT_NUM),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_ALTERA_BUILD[] = {
	REGISTER_FIELD_AZ(ALTERA_BUILD_VER),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_CSR_SPARE[] = {
	REGISTER_FIELD_AZ(CSR_SPARE_BITS),
	REGISTER_FIELD_AB(MEM_PERR_EN_TX_DATA),
	REGISTER_FIELD_CZ(MEM_PERR_EN),
	REGISTER_FIELD_AB(MEM_PERR_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_PCIE_SD_CTL0123[] = {
	REGISTER_FIELD_AB(PCIE_LODRV),
	REGISTER_FIELD_AB(PCIE_HIDRV),
	REGISTER_FIELD_AB(PCIE_RXEQCTL_L),
	REGISTER_FIELD_AB(PCIE_RXEQCTL_H),
	REGISTER_FIELD_AB(PCIE_TXTERMADJ_L),
	REGISTER_FIELD_AB(PCIE_TXTERMADJ_H),
	REGISTER_FIELD_AB(PCIE_RXTERMADJ_L),
	REGISTER_FIELD_AB(PCIE_RXTERMADJ_H),
	REGISTER_FIELD_AB(PCIE_PARLPBK),
	REGISTER_FIELD_AB(PCIE_LPBK),
	REGISTER_FIELD_AB(PCIE_LPBKWDRV_L),
	REGISTER_FIELD_AB(PCIE_LPBKWDRV_H),
	REGISTER_FIELD_AB(PCIE_PARRESET_L),
	REGISTER_FIELD_AB(PCIE_PARRESET_H),
	REGISTER_FIELD_AB(PCIE_HIVMODE_L),
	REGISTER_FIELD_AB(PCIE_HIVMODE_H),
	REGISTER_FIELD_AB(PCIE_OFFSETEN_L),
	REGISTER_FIELD_AB(PCIE_OFFSETEN_H),
	REGISTER_FIELD_AB(PCIE_OFFSET),
	REGISTER_FIELD_AB(PCIE_TESTSIG_L),
	REGISTER_FIELD_AB(PCIE_TESTSIG_H),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_PCIE_SD_CTL45[] = {
	REGISTER_FIELD_AB(PCIE_DEQ0),
	REGISTER_FIELD_AB(PCIE_DEQ1),
	REGISTER_FIELD_AB(PCIE_DEQ2),
	REGISTER_FIELD_AB(PCIE_DEQ3),
	REGISTER_FIELD_AB(PCIE_DEQ4),
	REGISTER_FIELD_AB(PCIE_DEQ5),
	REGISTER_FIELD_AB(PCIE_DEQ6),
	REGISTER_FIELD_AB(PCIE_DEQ7),
	REGISTER_FIELD_AB(PCIE_DTX0),
	REGISTER_FIELD_AB(PCIE_DTX1),
	REGISTER_FIELD_AB(PCIE_DTX2),
	REGISTER_FIELD_AB(PCIE_DTX3),
	REGISTER_FIELD_AB(PCIE_DTX4),
	REGISTER_FIELD_AB(PCIE_DTX5),
	REGISTER_FIELD_AB(PCIE_DTX6),
	REGISTER_FIELD_AB(PCIE_DTX7),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_PCIE_PCS_CTL_STAT[] = {
	REGISTER_FIELD_AB(PCIE_PRBSSEL),
	REGISTER_FIELD_AB(PCIE_PRBSERRACK_L),
	REGISTER_FIELD_AB(PCIE_PRBSERRACK_H),
	REGISTER_FIELD_AB(PCIE_PRBSSYNC_L),
	REGISTER_FIELD_AB(PCIE_PRBSSYNC_H),
	REGISTER_FIELD_AB(PCIE_CTCDISABLE_L),
	REGISTER_FIELD_AB(PCIE_CTCDISABLE_H),
	REGISTER_FIELD_AB(PCIE_FASTINIT_L),
	REGISTER_FIELD_AB(PCIE_FASTINIT_H),
	REGISTER_FIELD_AB(PCIE_PRBSERRH0),
	REGISTER_FIELD_AB(PCIE_PRBSERR),
	REGISTER_FIELD_AB(PCIE_PRBSERRCOUNT0_L),
	REGISTER_FIELD_AB(PCIE_PRBSERRCOUNT0_H),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EVQ_CTL[] = {
	REGISTER_FIELD_AZ(EVQ_FIFO_NOTAF_TH),
	REGISTER_FIELD_AZ(EVQ_FIFO_AF_TH),
	REGISTER_FIELD_AZ(EVQ_OWNERR_CTL),
	REGISTER_FIELD_BB(RX_EVQ_WAKEUP_MASK),
	REGISTER_FIELD_CZ(RX_EVQ_WAKEUP_MASK),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EVQ_CNT1[] = {
	REGISTER_FIELD_AZ(EVQ_ERR_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_CSR_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_EM_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_RX_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_TX_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_CNT_TOBIU),
	REGISTER_FIELD_AZ(EVQ_CNT_PRE_FIFO),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_EVQ_CNT2[] = {
	REGISTER_FIELD_AZ(EVQ_TM_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_INIT_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_WET_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_WU_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_RDY_CNT),
	REGISTER_FIELD_AZ(EVQ_CLR_REQ_CNT),
	REGISTER_FIELD_AZ(EVQ_UPD_REQ_CNT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_BUF_TBL_CFG[] = {
	REGISTER_FIELD_AZ(BUF_TBL_MODE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_SRM_RX_DC_CFG[] = {
	REGISTER_FIELD_AZ(SRM_RX_DC_BASE_ADR),
	REGISTER_FIELD_AZ(SRM_CLK_TMP_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_SRM_TX_DC_CFG[] = {
	REGISTER_FIELD_AZ(SRM_TX_DC_BASE_ADR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_SRM_CFG[] = {
	REGISTER_FIELD_AZ(SRM_BANK_SIZE),
	REGISTER_FIELD_AZ(SRM_NUM_BANK),
	REGISTER_FIELD_AZ(SRM_INIT_EN),
	REGISTER_FIELD_AZ(SRM_OOB_BUF_INTEN),
	REGISTER_FIELD_AZ(SRM_OOB_ADR_INTEN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_SRM_UPD_EVQ[] = {
	REGISTER_FIELD_AZ(SRM_UPD_EVQ_ID),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_SRAM_PARITY[] = {
	REGISTER_FIELD_CZ(FORCE_SRAM_SINGLE_ERR),
	REGISTER_FIELD_AB(FORCE_SRAM_PERR),
	REGISTER_FIELD_CZ(FORCE_SRAM_DOUBLE_ERR),
	REGISTER_FIELD_CZ(SEC_INT),
	REGISTER_FIELD_CZ(BYPASS_ECC),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_CFG[] = {
	REGISTER_FIELD_AZ(RX_XOFF_MAC_EN),
	REGISTER_FIELD_AA(RX_XOFF_MAC_TH),
	REGISTER_FIELD_BZ(RX_XOFF_MAC_TH),
	REGISTER_FIELD_AA(RX_XON_MAC_TH),
	REGISTER_FIELD_BZ(RX_XON_MAC_TH),
	REGISTER_FIELD_AA(RX_USR_BUF_SIZE),
	REGISTER_FIELD_AA(RX_XOFF_TX_TH),
	REGISTER_FIELD_BZ(RX_USR_BUF_SIZE),
	REGISTER_FIELD_AA(RX_XON_TX_TH),
	REGISTER_FIELD_AA(RX_OWNERR_CTL),
	REGISTER_FIELD_BZ(RX_XOFF_TX_TH),
	REGISTER_FIELD_AA(RX_PCI_BURST_SIZE),
	REGISTER_FIELD_AA(RX_RDW_PATCH_EN),
	REGISTER_FIELD_AA(RX_DESC_PUSH_EN),
	REGISTER_FIELD_BZ(RX_XON_TX_TH),
	REGISTER_FIELD_BZ(RX_OWNERR_CTL),
	REGISTER_FIELD_BB(RX_PCI_BURST_SIZE),
	REGISTER_FIELD_BZ(RX_RDW_PATCH_EN),
	REGISTER_FIELD_BZ(RX_DESC_PUSH_EN),
	REGISTER_FIELD_BZ(RX_HASH_INSRT_HDR),
	REGISTER_FIELD_BZ(RX_HASH_ALG),
	REGISTER_FIELD_BZ(RX_IP_HASH),
	REGISTER_FIELD_BZ(RX_INGR_EN),
	REGISTER_FIELD_BZ(RX_TCP_SUP),
	REGISTER_FIELD_CZ(RX_PRE_RFF_IPG),
	REGISTER_FIELD_CZ(RX_HDR_SPLIT_HDR_BUF_SIZE),
	REGISTER_FIELD_CZ(RX_HDR_SPLIT_PLD_BUF_SIZE),
	REGISTER_FIELD_CZ(RX_HDR_SPLIT_EN),
	REGISTER_FIELD_CZ(RX_MIN_KBUF_SIZE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_FILTER_CTL[] = {
	REGISTER_FIELD_BZ(TCP_FULL_SRCH_LIMIT),
	REGISTER_FIELD_BZ(TCP_WILD_SRCH_LIMIT),
	REGISTER_FIELD_BZ(UDP_WILD_SRCH_LIMIT),
	REGISTER_FIELD_BZ(NUM_KER),
	REGISTER_FIELD_BZ(UDP_FULL_SRCH_LIMIT),
	REGISTER_FIELD_BZ(SCATTER_ENBL_NO_MATCH_Q),
	REGISTER_FIELD_CZ(UNICAST_NOMATCH_IP_OVERRIDE),
	REGISTER_FIELD_CZ(UNICAST_NOMATCH_RSS_ENABLED),
	REGISTER_FIELD_CZ(UNICAST_NOMATCH_Q_ID),
	REGISTER_FIELD_CZ(MULTICAST_NOMATCH_IP_OVERRIDE),
	REGISTER_FIELD_CZ(MULTICAST_NOMATCH_RSS_ENABLED),
	REGISTER_FIELD_CZ(MULTICAST_NOMATCH_Q_ID),
	REGISTER_FIELD_CZ(RX_VLAN_MATCH_ETHERTYPE),
	REGISTER_FIELD_CZ(RX_FILTER_ALL_VLAN_ETHERTYPES),
	REGISTER_FIELD_CZ(ETHERNET_FULL_SEARCH_LIMIT),
	REGISTER_FIELD_CZ(ETHERNET_WILDCARD_SEARCH_LIMIT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_DC_CFG[] = {
	REGISTER_FIELD_AZ(RX_DC_SIZE),
	REGISTER_FIELD_AB(RX_MAX_PF),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_DC_PF_WM[] = {
	REGISTER_FIELD_AZ(RX_DC_PF_LWM),
	REGISTER_FIELD_AZ(RX_DC_PF_HWM),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_RSS_TKEY[] = {
	REGISTER_FIELD_BZ(RX_RSS_TKEY_LO),
	REGISTER_FIELD_BZ(RX_RSS_TKEY_HI),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_SELF_RST[] = {
	REGISTER_FIELD_AA(RX_MAX_LU_LAT),
	REGISTER_FIELD_AA(RX_MAX_PF_LAT),
	REGISTER_FIELD_AA(RX_SELF_RST_EN),
	REGISTER_FIELD_AA(RX_NODESC_WAIT_DIS),
	REGISTER_FIELD_AA(RX_SW_RST_REG),
	REGISTER_FIELD_AA(RX_ISCSI_DIS),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_RSS_IPV6_REG1[] = {
	REGISTER_FIELD_CZ(RX_RSS_IPV6_TKEY_LO),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_RSS_IPV6_REG2[] = {
	REGISTER_FIELD_CZ(RX_RSS_IPV6_TKEY_MID),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_RSS_IPV6_REG3[] = {
	REGISTER_FIELD_CZ(RX_RSS_IPV6_TKEY_HI),
	REGISTER_FIELD_CZ(RX_RSS_IPV6_TCP_SUPPRESS),
	REGISTER_FIELD_CZ(RX_RSS_IPV6_IP_THASH_ENABLE),
	REGISTER_FIELD_CZ(RX_RSS_IPV6_THASH_ENABLE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_DC_CFG[] = {
	REGISTER_FIELD_AZ(TX_DC_SIZE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_CHKSM_CFG[] = {
	REGISTER_FIELD_AA(TX_Q_CHKSM_DIS_0_31),
	REGISTER_FIELD_AA(TX_Q_CHKSM_DIS_32_63),
	REGISTER_FIELD_AA(TX_Q_CHKSM_DIS_64_95),
	REGISTER_FIELD_AA(TX_Q_CHKSM_DIS_96_127),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_CFG[] = {
	REGISTER_FIELD_AZ(TX_IP_ID_REP_EN),
	REGISTER_FIELD_AA(TX_NON_IP_DROP_DIS),
	REGISTER_FIELD_AZ(TX_OWNERR_CTL),
	REGISTER_FIELD_AZ(TX_P1_PRI_EN),
	REGISTER_FIELD_AZ(TX_NO_EOP_DISC_EN),
	REGISTER_FIELD_AZ(TX_IP_ID_P0_OFS),
	REGISTER_FIELD_CZ(TX_FILTER_EN_BIT),
	REGISTER_FIELD_CZ(TX_VLAN_MATCH_ETHERTYPE_RANGE),
	REGISTER_FIELD_CZ(TX_FILTER_ALL_VLAN_ETHERTYPES_BIT),
	REGISTER_FIELD_CZ(TX_TCPIP_FILTER_FULL_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_TCPIP_FILTER_WILD_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_UDPIP_FILTER_FULL_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_UDPIP_FILTER_WILD_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_ETH_FILTER_FULL_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_ETH_FILTER_WILD_SEARCH_RANGE),
	REGISTER_FIELD_CZ(TX_FILTER_TEST_MODE_BIT),
	REGISTER_FIELD_CZ(TX_CONT_LOOKUP_THRESH_RANGE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_RESERVED[] = {
	REGISTER_FIELD_AZ(TX_MAX_PREF),
	REGISTER_FIELD_AZ(TX_MAX_CPL),
	REGISTER_FIELD_AA(TX_IP_DIS),
	REGISTER_FIELD_BZ(TX_FLUSH_MIN_LEN_EN),
	REGISTER_FIELD_AA(TX_TCP_DIS),
	REGISTER_FIELD_AZ(TX_DMA_SPACER),
	REGISTER_FIELD_AA(TX_DMA_FF_THR),
	REGISTER_FIELD_AZ(TX_DIS_NON_IP_EV),
	REGISTER_FIELD_AZ(TX_ONE_PKT_PER_Q),
	REGISTER_FIELD_AZ(TX_PREF_THRESHOLD),
	REGISTER_FIELD_AZ(TX_ONLY1TAG),
	REGISTER_FIELD_AZ(TX_PREF_WD_TMR),
	REGISTER_FIELD_AZ(TX_PREF_SPACER),
	REGISTER_FIELD_AZ(TX_XP_TIMER),
	REGISTER_FIELD_AZ(TX_RX_SPACER_EN),
	REGISTER_FIELD_AZ(TX_PS_EVT_DIS),
	REGISTER_FIELD_AZ(TX_SOFT_EVT_EN),
	REGISTER_FIELD_AZ(TX_DROP_ABORT_EN),
	REGISTER_FIELD_AZ(TX_RX_SPACER),
	REGISTER_FIELD_AZ(TX_DMAQ_ST),
	REGISTER_FIELD_AZ(TX_DMAR_ST_P0),
	REGISTER_FIELD_AZ(TX_D_FF_FULL_P0),
	REGISTER_FIELD_AZ(TX_PUSH_CHK_DIS),
	REGISTER_FIELD_AZ(TX_PUSH_EN),
	REGISTER_FIELD_AZ(TX_RD_COMP_TMR),
	REGISTER_FIELD_AZ(TX_PREF_AGE_CNT),
	REGISTER_FIELD_AZ(TX_EVT_CNT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_PACE[] = {
	REGISTER_FIELD_BZ(TX_PACE_BIN_TH),
	REGISTER_FIELD_BZ(TX_PACE_FB_BASE),
	REGISTER_FIELD_BZ(TX_PACE_SB_AF),
	REGISTER_FIELD_BZ(TX_PACE_SB_NOT_AF),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_PACE_DROP_QID[] = {
	REGISTER_FIELD_BZ(TX_PACE_QID_DRP_CNT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_VLAN[] = {
	REGISTER_FIELD_BB(TX_VLAN0),
	REGISTER_FIELD_BB(TX_VLAN0_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN0_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN1),
	REGISTER_FIELD_BB(TX_VLAN1_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN1_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN2),
	REGISTER_FIELD_BB(TX_VLAN2_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN2_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN3),
	REGISTER_FIELD_BB(TX_VLAN3_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN3_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN4),
	REGISTER_FIELD_BB(TX_VLAN4_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN4_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN5),
	REGISTER_FIELD_BB(TX_VLAN5_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN5_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN6),
	REGISTER_FIELD_BB(TX_VLAN6_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN6_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN7),
	REGISTER_FIELD_BB(TX_VLAN7_PORT0_EN),
	REGISTER_FIELD_BB(TX_VLAN7_PORT1_EN),
	REGISTER_FIELD_BB(TX_VLAN_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_IPFIL_PORTEN[] = {
	REGISTER_FIELD_BB(TX_IPFIL0_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL1_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL2_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL3_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL4_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL5_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL6_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL7_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL8_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL9_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL10_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL11_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL12_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL13_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL14_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL15_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL16_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL17_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL18_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL19_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL20_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL21_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL22_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL23_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL24_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL25_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL26_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL27_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL28_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL29_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL30_PORT_EN),
	REGISTER_FIELD_BB(TX_IPFIL31_PORT_EN),
	REGISTER_FIELD_BZ(TX_MADR0_FIL_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_IPFIL_TBL[] = {
	REGISTER_FIELD_BB(TX_IP_SRC_ADR_0),
	REGISTER_FIELD_BB(TX_IPFIL_MASK_0),
	REGISTER_FIELD_BB(TX_IP_SRC_ADR_1),
	REGISTER_FIELD_BB(TX_IPFIL_MASK_1),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MD_TXD[] = {
	REGISTER_FIELD_AB(MD_TXD),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MD_RXD[] = {
	REGISTER_FIELD_AB(MD_RXD),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MD_CS[] = {
	REGISTER_FIELD_AB(MD_WRC),
	REGISTER_FIELD_AB(MD_RDC),
	REGISTER_FIELD_AB(MD_RIC),
	REGISTER_FIELD_AB(MD_PRSP),
	REGISTER_FIELD_AB(MD_GC),
	REGISTER_FIELD_AB(MD_INT_CLR),
	REGISTER_FIELD_AB(MD_PL),
	REGISTER_FIELD_AB(MD_PT),
	REGISTER_FIELD_AB(MD_ADDR_CMD),
	REGISTER_FIELD_AB(MD_WR_EN_CMD),
	REGISTER_FIELD_AB(MD_RD_EN_CMD),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MD_PHY_ADR[] = {
	REGISTER_FIELD_AB(MD_PHY_ADR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MD_ID[] = {
	REGISTER_FIELD_AB(MD_DEV_ADR),
	REGISTER_FIELD_AB(MD_PRT_ADR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MAC_STAT_DMA[] = {
	REGISTER_FIELD_AB(MAC_STAT_DMA_ADR),
	REGISTER_FIELD_AB(MAC_STAT_DMA_CMD),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MAC_CTRL[] = {
	REGISTER_FIELD_AB(MAC_SPEED),
	REGISTER_FIELD_AB(MAC_LINK_STATUS),
	REGISTER_FIELD_AB(MAC_UC_PROM),
	REGISTER_FIELD_AB(MAC_BCAD_ACPT),
	REGISTER_FIELD_AB(MAC_XG_DISTXCRC),
	REGISTER_FIELD_BB(TXFIFO_DRAIN_EN),
	REGISTER_FIELD_AB(MAC_XOFF_VAL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GEN_MODE[] = {
	REGISTER_FIELD_BB(XG_PHY_INT_MASK),
	REGISTER_FIELD_BB(XFP_PHY_INT_MASK),
	REGISTER_FIELD_BB(XG_PHY_INT_POL_SEL),
	REGISTER_FIELD_BB(XFP_PHY_INT_POL_SEL),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MAC_MC_HASH_REG0[] = {
	REGISTER_FIELD_AB(MAC_MCAST_HASH0),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MAC_MC_HASH_REG1[] = {
	REGISTER_FIELD_AB(MAC_MCAST_HASH1),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GM_CFG1[] = {
	REGISTER_FIELD_AB(GM_TX_EN),
	REGISTER_FIELD_AB(GM_SYNC_TXEN),
	REGISTER_FIELD_AB(GM_RX_EN),
	REGISTER_FIELD_AB(GM_SYNC_RXEN),
	REGISTER_FIELD_AB(GM_TX_FC_EN),
	REGISTER_FIELD_AB(GM_RX_FC_EN),
	REGISTER_FIELD_AB(GM_LOOP),
	REGISTER_FIELD_AB(GM_RST_TX_FUNC),
	REGISTER_FIELD_AB(GM_RST_RX_FUNC),
	REGISTER_FIELD_AB(GM_RST_TX_MAC_CTL),
	REGISTER_FIELD_AB(GM_RST_RX_MAC_CTL),
	REGISTER_FIELD_AB(GM_SIM_RST),
	REGISTER_FIELD_AB(GM_SW_RST),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GM_CFG2[] = {
	REGISTER_FIELD_AB(GM_FD),
	REGISTER_FIELD_AB(GM_CRC_EN),
	REGISTER_FIELD_AB(GM_PAD_CRC_EN),
	REGISTER_FIELD_AB(GM_LEN_CHK),
	REGISTER_FIELD_AB(GM_HUGE_FRM_EN),
	REGISTER_FIELD_AB(GM_IF_MODE),
	REGISTER_FIELD_AB(GM_PAMBL_LEN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GM_MAX_FLEN[] = {
	REGISTER_FIELD_AB(GM_MAX_FLEN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GM_ADR1[] = {
	REGISTER_FIELD_AB(GM_ADR_B3),
	REGISTER_FIELD_AB(GM_ADR_B2),
	REGISTER_FIELD_AB(GM_ADR_B1),
	REGISTER_FIELD_AB(GM_ADR_B0),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GM_ADR2[] = {
	REGISTER_FIELD_AB(GM_ADR_B5),
	REGISTER_FIELD_AB(GM_ADR_B4),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG0[] = {
	REGISTER_FIELD_AB(GMF_HSTRSTWT),
	REGISTER_FIELD_AB(GMF_HSTRSTSR),
	REGISTER_FIELD_AB(GMF_HSTRSTFR),
	REGISTER_FIELD_AB(GMF_HSTRSTST),
	REGISTER_FIELD_AB(GMF_HSTRSTFT),
	REGISTER_FIELD_AB(GMF_WTMENREQ),
	REGISTER_FIELD_AB(GMF_SRFENREQ),
	REGISTER_FIELD_AB(GMF_FRFENREQ),
	REGISTER_FIELD_AB(GMF_STFENREQ),
	REGISTER_FIELD_AB(GMF_FTFENREQ),
	REGISTER_FIELD_AB(GMF_WTMENRPLY),
	REGISTER_FIELD_AB(GMF_SRFENRPLY),
	REGISTER_FIELD_AB(GMF_FRFENRPLY),
	REGISTER_FIELD_AB(GMF_STFENRPLY),
	REGISTER_FIELD_AB(GMF_FTFENRPLY),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG1[] = {
	REGISTER_FIELD_AB(GMF_CFGXOFFRTX),
	REGISTER_FIELD_AB(GMF_CFGFRTH),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG2[] = {
	REGISTER_FIELD_AB(GMF_CFGLWM),
	REGISTER_FIELD_AB(GMF_CFGHWM),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG3[] = {
	REGISTER_FIELD_AB(GMF_CFGFTTH),
	REGISTER_FIELD_AB(GMF_CFGHWMFT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG4[] = {
	REGISTER_FIELD_AB(GMF_HSTFLTRFRM),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_GMF_CFG5[] = {
	REGISTER_FIELD_AB(GMF_HSTFLTRFRMDC),
	REGISTER_FIELD_AB(GMF_HSTDRPLT64),
	REGISTER_FIELD_AB(GMF_CFGBYTMODE),
	REGISTER_FIELD_AB(GMF_HSTSRFULLCLR),
	REGISTER_FIELD_AB(GMF_SRFULL),
	REGISTER_FIELD_AB(GMF_CFGHDPLX),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_SRC_MAC_TBL[] = {
	REGISTER_FIELD_BB(TX_SRC_MAC_ADR_0),
	REGISTER_FIELD_BB(TX_SRC_MAC_ADR_1),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_SRC_MAC_CTL[] = {
	REGISTER_FIELD_BB(TX_MAC_QID_SEL),
	REGISTER_FIELD_BB(TX_DROP_CTR_CLR),
	REGISTER_FIELD_BB(TX_SRC_FLTR_EN),
	REGISTER_FIELD_BB(TX_SRC_DROP_CTR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_ADR_LO[] = {
	REGISTER_FIELD_AB(XM_ADR_LO),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_ADR_HI[] = {
	REGISTER_FIELD_AB(XM_ADR_HI),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_GLB_CFG[] = {
	REGISTER_FIELD_AB(XM_CORE_RST),
	REGISTER_FIELD_AB(XM_INTCLR_MODE),
	REGISTER_FIELD_AB(XM_WAN_MODE),
	REGISTER_FIELD_AB(XM_RX_JUMBO_MODE),
	REGISTER_FIELD_AB(XM_TX_STAT_EN),
	REGISTER_FIELD_AB(XM_RX_STAT_EN),
	REGISTER_FIELD_AB(XM_DEBUG_MODE),
	REGISTER_FIELD_AB(XM_RMTFLT_GEN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_TX_CFG[] = {
	REGISTER_FIELD_AB(XM_TX_RST),
	REGISTER_FIELD_AB(XM_TXEN),
	REGISTER_FIELD_AB(XM_TX_PRMBL),
	REGISTER_FIELD_AB(XM_AUTO_PAD),
	REGISTER_FIELD_AB(XM_EDRC),
	REGISTER_FIELD_AB(XM_TXCRC),
	REGISTER_FIELD_AB(XM_FCNTL),
	REGISTER_FIELD_AB(XM_IPG),
	REGISTER_FIELD_AB(XM_TX_PROG),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_RX_CFG[] = {
	REGISTER_FIELD_AB(XM_RX_RST),
	REGISTER_FIELD_AB(XM_RXEN),
	REGISTER_FIELD_AB(XM_RX_PRMBL),
	REGISTER_FIELD_AB(XM_RXCRC),
	REGISTER_FIELD_AB(XM_AUTO_DEPAD),
	REGISTER_FIELD_AB(XM_ACPT_ALL_UCAST),
	REGISTER_FIELD_AB(XM_ACPT_ALL_MCAST),
	REGISTER_FIELD_AB(XM_REJ_BCAST),
	REGISTER_FIELD_AB(XM_PASS_PRMBLE_ERR),
	REGISTER_FIELD_AB(XM_PASS_CRC_ERR),
	REGISTER_FIELD_AB(XM_PASS_LENERR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_MGT_INT_MASK[] = {
	REGISTER_FIELD_AB(XM_MSK_LCLFLT),
	REGISTER_FIELD_AB(XM_MSK_RMTFLT),
	REGISTER_FIELD_AB(XM_MSK_PRMBLE_ERR),
	REGISTER_FIELD_AB(XM_MSK_STAT_CNTR_OF),
	REGISTER_FIELD_AB(XM_MSK_STAT_CNTR_HF),
	REGISTER_FIELD_AB(XM_MSK_STA_INTR),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_FC[] = {
	REGISTER_FIELD_AB(XM_DIS_FCNTL),
	REGISTER_FIELD_AB(XM_XMIT_PAUSE),
	REGISTER_FIELD_AB(XM_ZPAUSE),
	REGISTER_FIELD_AB(XM_REJ_CNTL_MCAST),
	REGISTER_FIELD_AB(XM_REJ_CNTL_UCAST),
	REGISTER_FIELD_AB(XM_MCNTL_PASS),
	REGISTER_FIELD_AB(XM_TX_MAC_STAT),
	REGISTER_FIELD_AB(XM_RX_MAC_STAT),
	REGISTER_FIELD_AB(XM_PAUSE_TIME),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_PAUSE_TIME[] = {
	REGISTER_FIELD_AB(XM_RX_PAUSE_CNT),
	REGISTER_FIELD_AB(XM_TX_PAUSE_CNT),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_TX_PARAM[] = {
	REGISTER_FIELD_AB(XM_PAD_CHAR),
	REGISTER_FIELD_AB(XM_MAX_TX_FRM_SIZE_LO),
	REGISTER_FIELD_AB(XM_MAX_TX_FRM_SIZE_HI),
	REGISTER_FIELD_AB(XM_TX_JUMBO_MODE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XM_RX_PARAM[] = {
	REGISTER_FIELD_AB(XM_MAX_RX_FRM_SIZE_LO),
	REGISTER_FIELD_AB(XM_MAX_RX_FRM_SIZE_HI),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XX_PWR_RST[] = {
	REGISTER_FIELD_AB(XX_RST_XX_EN),
	REGISTER_FIELD_AB(XX_RSTXGXSTX_EN),
	REGISTER_FIELD_AB(XX_RSTXGXSRX_EN),
	REGISTER_FIELD_AB(XX_RESETA_EN),
	REGISTER_FIELD_AB(XX_RESETB_EN),
	REGISTER_FIELD_AB(XX_RESETC_EN),
	REGISTER_FIELD_AB(XX_RESETD_EN),
	REGISTER_FIELD_AB(XX_RSTPLLAB_EN),
	REGISTER_FIELD_AB(XX_RSTPLLCD_EN),
	REGISTER_FIELD_AB(XX_PWRDNA_EN),
	REGISTER_FIELD_AB(XX_PWRDNB_EN),
	REGISTER_FIELD_AB(XX_PWRDNC_EN),
	REGISTER_FIELD_AB(XX_PWRDND_EN),
	REGISTER_FIELD_AB(XX_SD_RST_ACT),
	REGISTER_FIELD_AB(XX_RSTXGXSTX_SIG),
	REGISTER_FIELD_AB(XX_RSTXGXSRX_SIG),
	REGISTER_FIELD_AB(XX_RESETA_SIG),
	REGISTER_FIELD_AB(XX_RESETB_SIG),
	REGISTER_FIELD_AB(XX_RESETC_SIG),
	REGISTER_FIELD_AB(XX_RESETD_SIG),
	REGISTER_FIELD_AB(XX_RSTPLLAB_SIG),
	REGISTER_FIELD_AB(XX_RSTPLLCD_SIG),
	REGISTER_FIELD_AB(XX_SIM_MODE),
	REGISTER_FIELD_AB(XX_PWRDNA_SIG),
	REGISTER_FIELD_AB(XX_PWRDNB_SIG),
	REGISTER_FIELD_AB(XX_PWRDNC_SIG),
	REGISTER_FIELD_AB(XX_PWRDND_SIG),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XX_SD_CTL[] = {
	REGISTER_FIELD_AB(XX_LPBKA),
	REGISTER_FIELD_AB(XX_LPBKB),
	REGISTER_FIELD_AB(XX_LPBKC),
	REGISTER_FIELD_AB(XX_LPBKD),
	REGISTER_FIELD_AB(XX_LODRVA),
	REGISTER_FIELD_AB(XX_HIDRVA),
	REGISTER_FIELD_AB(XX_LODRVB),
	REGISTER_FIELD_AB(XX_HIDRVB),
	REGISTER_FIELD_AB(XX_LODRVC),
	REGISTER_FIELD_AB(XX_HIDRVC),
	REGISTER_FIELD_AB(XX_LODRVD),
	REGISTER_FIELD_AB(XX_HIDRVD),
	REGISTER_FIELD_AB(XX_TERMADJ0),
	REGISTER_FIELD_AB(XX_TERMADJ1),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_XX_TXDRV_CTL[] = {
	REGISTER_FIELD_AB(XX_DTXA),
	REGISTER_FIELD_AB(XX_DTXB),
	REGISTER_FIELD_AB(XX_DTXC),
	REGISTER_FIELD_AB(XX_DTXD),
	REGISTER_FIELD_AB(XX_DEQA),
	REGISTER_FIELD_AB(XX_DEQB),
	REGISTER_FIELD_AB(XX_DEQC),
	REGISTER_FIELD_AB(XX_DEQD),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_DESC_PTR_TBL[] = {
	/* Abbreviate field names to reduce the table width */
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_EN, "EN"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_JUMBO, "JUMBO"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_TYPE, "TYPE"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_SIZE, "SIZE"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_LABEL, "LABEL"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_OWNER_ID, "OWNER"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_EVQ_ID, "EVQ"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_BUF_BASE_ID, "BUF_BASE"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_SW_WPTR, "SW_WPTR"),
	REGISTER_FIELD_AZ_RENAME(RX_DESCQ_HW_RPTR, "HW_RPTR"),
	REGISTER_FIELD_AZ_RENAME(RX_DC_HW_RPTR, "DC_HW_RPTR"),
	REGISTER_FIELD_AZ_RENAME(RX_DESC_PREF_ACT, "PREF_ACT"),
	REGISTER_FIELD_AZ_RENAME(RX_ISCSI_HDIG_EN, "HDIG"),
	REGISTER_FIELD_AZ_RENAME(RX_ISCSI_DDIG_EN, "DDIG"),
	REGISTER_FIELD_AA(RX_RESET),
	REGISTER_FIELD_CZ_RENAME(RX_HDR_SPLIT, "HDR_SPLIT"),
};
#define efx_nic_reg_fields_RX_DESC_PTR_TBL_KER efx_nic_reg_fields_RX_DESC_PTR_TBL
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_DESC_PTR_TBL[] = {
	/* Abbreviate field names to reduce the table width */
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_FLUSH, "FLUSH"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_TYPE, "TYPE"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_SIZE, "SIZE"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_LABEL, "LABEL"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_OWNER_ID, "OWNER"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_EVQ_ID, "EVQ"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_BUF_BASE_ID, "BUF_BASE"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_SW_WPTR, "SW_WPTR"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_HW_RPTR, "HW_RPTR"),
	REGISTER_FIELD_AZ_RENAME(TX_DC_HW_RPTR, "DC_HW_RPTR"),
	REGISTER_FIELD_AZ_RENAME(TX_ISCSI_HDIG_EN, "HDIG"),
	REGISTER_FIELD_AZ_RENAME(TX_ISCSI_DDIG_EN, "DDIG"),
	REGISTER_FIELD_AZ_RENAME(TX_DESCQ_EN, "EN"),
	REGISTER_FIELD_BZ_RENAME(TX_TCP_CHKSM_DIS, "!TCP_CHKSM"),
	REGISTER_FIELD_BZ_RENAME(TX_IP_CHKSM_DIS, "!IP_CHKSM"),
	REGISTER_FIELD_BZ_RENAME(TX_NON_IP_DROP_DIS, "!NON_IP_DROP"),
	REGISTER_FIELD_CZ_RENAME(TX_DPT_IP_FILT_EN, "IP_FILT"),
	REGISTER_FIELD_CZ_RENAME(TX_DPT_ETH_FILT_EN, "ETH_FILT"),
	REGISTER_FIELD_CZ_RENAME(TX_DPT_Q_MASK_WIDTH, "Q_MASK_WIDTH"),
};
#define efx_nic_reg_fields_TX_DESC_PTR_TBL_KER efx_nic_reg_fields_TX_DESC_PTR_TBL
static const struct efx_nic_reg_field efx_nic_reg_fields_EVQ_PTR_TBL[] = {
	REGISTER_FIELD_AZ(EVQ_BUF_BASE_ID),
	REGISTER_FIELD_AZ(EVQ_SIZE),
	REGISTER_FIELD_AZ(EVQ_EN),
	REGISTER_FIELD_AZ(EVQ_NXT_WPTR),
	REGISTER_FIELD_CZ(EVQ_DOS_PROTECT_EN),
	REGISTER_FIELD_AB(EVQ_WKUP_OR_INT_EN),
	REGISTER_FIELD_BZ(EVQ_RPTR_IGN),
};
#define efx_nic_reg_fields_EVQ_PTR_TBL_KER efx_nic_reg_fields_EVQ_PTR_TBL
static const struct efx_nic_reg_field efx_nic_reg_fields_BUF_FULL_TBL[] = {
	REGISTER_FIELD_AZ(BUF_OWNER_ID_FBUF),
	REGISTER_FIELD_AZ(BUF_ADR_FBUF),
	REGISTER_FIELD_AZ(BUF_ADR_REGION),
	REGISTER_FIELD_AZ(IP_DAT_BUF_SIZE),
	REGISTER_FIELD_AZ(BUF_FULL_UNUSED),
};
#define efx_nic_reg_fields_BUF_FULL_TBL_KER efx_nic_reg_fields_BUF_FULL_TBL
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_FILTER_TBL0[] = {
	/* Source port for full match; destination port for UDP wild match */
	REGISTER_FIELD_BZ_RENAME(SRC_TCP_DEST_UDP, "SRC_PORT"),
	REGISTER_FIELD_BZ(SRC_IP),
	/* Destination port for full match or TCP wild match */
	REGISTER_FIELD_BZ_RENAME(DEST_PORT_TCP, "DEST_PORT"),
	REGISTER_FIELD_BZ(DEST_IP),
	REGISTER_FIELD_BZ(RXQ_ID),
	REGISTER_FIELD_BZ(TCP_UDP),
	REGISTER_FIELD_BZ(SCATTER_EN),
	REGISTER_FIELD_BZ(RSS_EN),
};
#define efx_nic_reg_fields_RX_FILTER_TBL1 efx_nic_reg_fields_RX_FILTER_TBL0
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_MAC_FILTER_TBL0[] = {
	REGISTER_FIELD_CZ(RMFT_VLAN_ID),
	REGISTER_FIELD_CZ(RMFT_DEST_MAC),
	REGISTER_FIELD_CZ(RMFT_WILDCARD_MATCH),
	REGISTER_FIELD_CZ(RMFT_RXQ_ID),
	REGISTER_FIELD_CZ(RMFT_IP_OVERRIDE),
	REGISTER_FIELD_CZ(RMFT_SCATTER_EN),
	REGISTER_FIELD_CZ(RMFT_RSS_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TIMER_TBL[] = {
	REGISTER_FIELD_BB(TIMER_VAL),
	REGISTER_FIELD_CZ(TIMER_VAL),
	REGISTER_FIELD_BB(TIMER_MODE),
	REGISTER_FIELD_CZ(TIMER_MODE),
	REGISTER_FIELD_CZ(RELOAD_TIMER_VAL),
	REGISTER_FIELD_CZ(HOST_NOTIFY_MODE),
	REGISTER_FIELD_CZ(INT_PEND),
	REGISTER_FIELD_CZ(INT_ARMD),
	REGISTER_FIELD_CZ(TIMER_Q_EN),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_PACE_TBL[] = {
	REGISTER_FIELD_BZ(TX_PACE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_RX_INDIRECTION_TBL[] = {
	REGISTER_FIELD_BZ(IT_QUEUE),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_TX_MAC_FILTER_TBL0[] = {
	REGISTER_FIELD_CZ(TMFT_VLAN_ID),
	REGISTER_FIELD_CZ(TMFT_SRC_MAC),
	REGISTER_FIELD_CZ(TMFT_WILDCARD_MATCH),
	REGISTER_FIELD_CZ(TMFT_TXQ_ID),
};
static const struct efx_nic_reg_field efx_nic_reg_fields_MC_TREG_SMEM[] = {
	REGISTER_FIELD_CZ(MC_TREG_SMEM_ROW),
};

struct efx_nic_reg {
	const char *name;
	const struct efx_nic_reg_field *fields;
	u32 field_count:7;
	u32 min_revision:2, max_revision:2;
};

#define REGISTER(name, min_rev, max_rev) {				\
	#name,								\
	efx_nic_reg_fields_ ## name,					\
	ARRAY_SIZE(efx_nic_reg_fields_ ## name),			\
	REGISTER_REVISION_ ## min_rev, REGISTER_REVISION_ ## max_rev	\
}
#define REGISTER_AA(name) REGISTER(name, A, A)
#define REGISTER_AB(name) REGISTER(name, A, B)
#define REGISTER_AZ(name) REGISTER(name, A, Z)
#define REGISTER_BB(name) REGISTER(name, B, B)
#define REGISTER_BZ(name) REGISTER(name, B, Z)
#define REGISTER_CZ(name) REGISTER(name, C, Z)

static const struct efx_nic_reg efx_nic_regs[] = {
	REGISTER_AZ(ADR_REGION),
	REGISTER_AZ(INT_EN_KER),
	REGISTER_BZ(INT_EN_CHAR),
	REGISTER_AZ(INT_ADR_KER),
	REGISTER_BZ(INT_ADR_CHAR),
	/* INT_ACK_KER is WO */
	/* INT_ISR0 is RC */
	REGISTER_AZ(HW_INIT),
	REGISTER_CZ(USR_EV_CFG),
	REGISTER_AB(EE_SPI_HCMD),
	REGISTER_AB(EE_SPI_HADR),
	REGISTER_AB(EE_SPI_HDATA),
	REGISTER_AB(EE_BASE_PAGE),
	REGISTER_AB(EE_VPD_CFG0),
	/* EE_VPD_SW_CNTL and EE_VPD_SW_DATA are not used */
	/* PMBX_DBG_IADDR and PBMX_DBG_IDATA are indirect */
	/* PCIE_CORE_INDIRECT is indirect */
	REGISTER_AB(NIC_STAT),
	REGISTER_AB(GPIO_CTL),
	REGISTER_AB(GLB_CTL),
	/* FATAL_INTR_KER and FATAL_INTR_CHAR are partly RC */
	REGISTER_BZ(DP_CTRL),
	REGISTER_AZ(MEM_STAT),
	REGISTER_AZ(CS_DEBUG),
	REGISTER_AZ(ALTERA_BUILD),
	REGISTER_AZ(CSR_SPARE),
	REGISTER_AB(PCIE_SD_CTL0123),
	REGISTER_AB(PCIE_SD_CTL45),
	REGISTER_AB(PCIE_PCS_CTL_STAT),
	/* DEBUG_DATA_OUT is not used */
	/* DRV_EV is WO */
	REGISTER_AZ(EVQ_CTL),
	REGISTER_AZ(EVQ_CNT1),
	REGISTER_AZ(EVQ_CNT2),
	REGISTER_AZ(BUF_TBL_CFG),
	REGISTER_AZ(SRM_RX_DC_CFG),
	REGISTER_AZ(SRM_TX_DC_CFG),
	REGISTER_AZ(SRM_CFG),
	/* BUF_TBL_UPD is WO */
	REGISTER_AZ(SRM_UPD_EVQ),
	REGISTER_AZ(SRAM_PARITY),
	REGISTER_AZ(RX_CFG),
	REGISTER_BZ(RX_FILTER_CTL),
	/* RX_FLUSH_DESCQ is WO */
	REGISTER_AZ(RX_DC_CFG),
	REGISTER_AZ(RX_DC_PF_WM),
	REGISTER_BZ(RX_RSS_TKEY),
	/* RX_NODESC_DROP is RC */
	REGISTER_AA(RX_SELF_RST),
	/* RX_DEBUG, RX_PUSH_DROP are not used */
	REGISTER_CZ(RX_RSS_IPV6_REG1),
	REGISTER_CZ(RX_RSS_IPV6_REG2),
	REGISTER_CZ(RX_RSS_IPV6_REG3),
	/* TX_FLUSH_DESCQ is WO */
	REGISTER_AZ(TX_DC_CFG),
	REGISTER_AA(TX_CHKSM_CFG),
	REGISTER_AZ(TX_CFG),
	/* TX_PUSH_DROP is not used */
	REGISTER_AZ(TX_RESERVED),
	REGISTER_BZ(TX_PACE),
	/* TX_PACE_DROP_QID is RC */
	REGISTER_BB(TX_VLAN),
	REGISTER_BZ(TX_IPFIL_PORTEN),
	REGISTER_AB(MD_TXD),
	REGISTER_AB(MD_RXD),
	REGISTER_AB(MD_CS),
	REGISTER_AB(MD_PHY_ADR),
	REGISTER_AB(MD_ID),
	/* MD_STAT is RC */
	REGISTER_AB(MAC_STAT_DMA),
	REGISTER_AB(MAC_CTRL),
	REGISTER_BB(GEN_MODE),
	REGISTER_AB(MAC_MC_HASH_REG0),
	REGISTER_AB(MAC_MC_HASH_REG1),
	REGISTER_AB(GM_CFG1),
	REGISTER_AB(GM_CFG2),
	/* GM_IPG and GM_HD are not used */
	REGISTER_AB(GM_MAX_FLEN),
	/* GM_TEST is not used */
	REGISTER_AB(GM_ADR1),
	REGISTER_AB(GM_ADR2),
	REGISTER_AB(GMF_CFG0),
	REGISTER_AB(GMF_CFG1),
	REGISTER_AB(GMF_CFG2),
	REGISTER_AB(GMF_CFG3),
	REGISTER_AB(GMF_CFG4),
	REGISTER_AB(GMF_CFG5),
	REGISTER_BB(TX_SRC_MAC_CTL),
	REGISTER_AB(XM_ADR_LO),
	REGISTER_AB(XM_ADR_HI),
	REGISTER_AB(XM_GLB_CFG),
	REGISTER_AB(XM_TX_CFG),
	REGISTER_AB(XM_RX_CFG),
	REGISTER_AB(XM_MGT_INT_MASK),
	REGISTER_AB(XM_FC),
	REGISTER_AB(XM_PAUSE_TIME),
	REGISTER_AB(XM_TX_PARAM),
	REGISTER_AB(XM_RX_PARAM),
	/* XM_MGT_INT_MSK (note no 'A') is RC */
	REGISTER_AB(XX_PWR_RST),
	REGISTER_AB(XX_SD_CTL),
	REGISTER_AB(XX_TXDRV_CTL),
	/* XX_PRBS_CTL, XX_PRBS_CHK and XX_PRBS_ERR are not used */
	/* XX_CORE_STAT is partly RC */
};

struct efx_nic_reg_table {
	const char *name;
	const struct efx_nic_reg_field *fields;
	u32 field_count:7;
	u32 min_revision:2, max_revision:2;
	u32 step:6, rows:21;
};

#define REGISTER_TABLE_DIMENSIONS(name, _, min_rev, max_rev, step, rows) { \
	#name,								\
	efx_nic_reg_fields_ ## name,					\
	ARRAY_SIZE(efx_nic_reg_fields_ ## name),			\
	REGISTER_REVISION_ ## min_rev, REGISTER_REVISION_ ## max_rev,	\
	step, rows							\
}
#define REGISTER_TABLE(name, min_rev, max_rev) 				\
	REGISTER_TABLE_DIMENSIONS(					\
		name, FR_ ## min_rev ## max_rev ## _ ## name,		\
		min_rev, max_rev,					\
		FR_ ## min_rev ## max_rev ## _ ## name ## _STEP,	\
		FR_ ## min_rev ## max_rev ## _ ## name ## _ROWS)
#define REGISTER_TABLE_AA(name) REGISTER_TABLE(name, A, A)
#define REGISTER_TABLE_AZ(name) REGISTER_TABLE(name, A, Z)
#define REGISTER_TABLE_BB(name) REGISTER_TABLE(name, B, B)
#define REGISTER_TABLE_BZ(name) REGISTER_TABLE(name, B, Z)
#define REGISTER_TABLE_BB_CZ(name)					\
	REGISTER_TABLE_DIMENSIONS(name, FR_BZ_ ## name, B, B,		\
				  FR_BZ_ ## name ## _STEP,		\
				  FR_BB_ ## name ## _ROWS),		\
	REGISTER_TABLE_DIMENSIONS(name, FR_BZ_ ## name, C, Z,		\
				  FR_BZ_ ## name ## _STEP,		\
				  FR_CZ_ ## name ## _ROWS)
#define REGISTER_TABLE_CZ(name) REGISTER_TABLE(name, C, Z)

static const struct efx_nic_reg_table efx_nic_reg_tables[] = {
	/* DRIVER is not used */
	/* EVQ_RPTR, TIMER_COMMAND, USR_EV and {RX,TX}_DESC_UPD are WO */
	REGISTER_TABLE_BB(TX_IPFIL_TBL),
	REGISTER_TABLE_BB(TX_SRC_MAC_TBL),
	REGISTER_TABLE_AA(RX_DESC_PTR_TBL_KER),
	REGISTER_TABLE_BB_CZ(RX_DESC_PTR_TBL),
	REGISTER_TABLE_AA(TX_DESC_PTR_TBL_KER),
	REGISTER_TABLE_BB_CZ(TX_DESC_PTR_TBL),
	REGISTER_TABLE_AA(EVQ_PTR_TBL_KER),
	REGISTER_TABLE_BB_CZ(EVQ_PTR_TBL),
	/* We can't reasonably read all of the buffer table (up to 8MB!).
	 * However this driver will only use a few entries.  Reading
	 * 1K entries allows for some expansion of queue count and
	 * size before we need to change the version. */
	REGISTER_TABLE_DIMENSIONS(BUF_FULL_TBL_KER, FR_AA_BUF_FULL_TBL_KER,
				  A, A, 8, 1024),
	REGISTER_TABLE_DIMENSIONS(BUF_FULL_TBL, FR_BZ_BUF_FULL_TBL,
				  B, Z, 8, 1024),
	REGISTER_TABLE_CZ(RX_MAC_FILTER_TBL0),
	REGISTER_TABLE_BB_CZ(TIMER_TBL),
	REGISTER_TABLE_BB_CZ(TX_PACE_TBL),
	REGISTER_TABLE_BZ(RX_INDIRECTION_TBL),
	/* TX_FILTER_TBL0 is huge and not used by this driver */
	REGISTER_TABLE_CZ(TX_MAC_FILTER_TBL0),
	REGISTER_TABLE_CZ(MC_TREG_SMEM),
	/* MSIX_PBA_TABLE is not mapped */
	/* SRM_DBG is not mapped (and is redundant with BUF_FLL_TBL) */
	REGISTER_TABLE_BZ(RX_FILTER_TBL0),
};

static size_t column_width(const struct efx_nic_reg_field *field)
{
	size_t name_width, value_width;

	name_width = strlen(field->name);
	value_width = (field->width + 3) >> 2;

	return name_width > value_width ? name_width : value_width;
}

static size_t column_padding(const struct efx_nic_reg_field *field)
{
	size_t name_width, value_width;

	name_width = strlen(field->name);
	value_width = (field->width + 3) >> 2;

	return name_width > value_width ? name_width - value_width : 0;
}

static void
print_field_value(const struct efx_nic_reg_field *field, const u8 *buf)
{
	unsigned left, right, sig_bits, digit;

	right = field->lbn;
	left = right + ((field->width + 3) & ~3);

	/* How many bits are valid for the most significant hex digit? */
	sig_bits = (field->width & 3) ? (field->width & 3) : 4;

	while (left > right) {
		left -= 4;
		digit = buf[left >> 3];
		if ((left & 7) + sig_bits > 8)
			digit |= buf[(left >> 3) + 1] << 8;
		digit = (digit >> (left & 7)) & ((1 << sig_bits) - 1);
		printf("%x", digit);
		sig_bits = 4; /* for all subsequent digits */
	}
}

static const void *
print_single_register(unsigned revision, const struct efx_nic_reg *reg,
		      const void *buf)
{
	const struct efx_nic_reg_field *field;
	int indent = 0;
	size_t i;

	for (i = 0; i < reg->field_count; i++) {
		field = &reg->fields[i];
		if (revision >= field->min_revision &&
		    revision <= field->max_revision) {
			if (indent == 0)
				indent = printf("%s: ", reg->name);
			else
				printf("%*s", indent, "");
			printf("%s = ", field->name);
			print_field_value(field, buf);
			fputc('\n', stdout);
		}
	}
				
	return (const u8 *)buf + 16;
}

static const void *
print_simple_table(unsigned revision, const struct efx_nic_reg_table *table,
		   const void *buf)
{
	const struct efx_nic_reg_field *field = &table->fields[0];
	size_t value_width = (field->width + 3) >> 2;
	size_t column_count = 72 / (value_width + 1);
	size_t size = table->step > 16 ? 16 : table->step;
	size_t i;

	for (i = 0; i < table->rows; i++) {
		if (i % column_count == 0) {
			if (i != 0)
				fputc('\n', stdout);
			printf("%4zu ", i);
		}
		fputc(' ', stdout);
		print_field_value(field, buf);
		buf = (const u8 *)buf + size;
	}
	fputc('\n', stdout);

	return buf;
}

static const void *
print_complex_table(unsigned revision, const struct efx_nic_reg_table *table,
		    const void *buf)
{
	const struct efx_nic_reg_field *field;
	size_t size = table->step > 16 ? 16 : table->step;
	size_t i, j;

	/* Column headings */
	fputs("Row ", stdout);
	for (i = 0; i < table->field_count; i++) {
		field = &table->fields[i];
		if (revision >= field->min_revision &&
		    revision <= field->max_revision)
			printf(" %-*s", (int)column_width(field),
			       field->name);
	}
	fputc('\n', stdout);
	fputs("----", stdout);
	for (i = 0; i < table->field_count; i++) {
		field = &table->fields[i];
		if (revision >= field->min_revision &&
		    revision <= field->max_revision) {
			fputc(' ', stdout);
			for (j = column_width(field); j > 0; j--)
				fputc('-', stdout);
		}
	}
	fputc('\n', stdout);

	for (j = 0; j < table->rows; j++) {
		printf("%4zu", j);
		for (i = 0; i < table->field_count; i++) {
			field = &table->fields[i];
			if (!(revision >= field->min_revision &&
			      revision <= field->max_revision))
				continue;
			printf(" %*s", (int)column_padding(field), "");
			print_field_value(field, buf);
		}
		fputc('\n', stdout);
		buf = (const u8 *)buf + size;
	}

	return buf;
}

int
sfc_dump_regs(struct ethtool_drvinfo *info, struct ethtool_regs *regs)
{
	const struct efx_nic_reg *reg;
	const struct efx_nic_reg_table *table;
	unsigned revision = regs->version;
	const void *buf = regs->data;
	const void *end = regs->data + regs->len;

	if (revision > REGISTER_REVISION_Z)
		return -1;

	for (reg = efx_nic_regs;	
	     reg < efx_nic_regs + ARRAY_SIZE(efx_nic_regs) && buf < end;
	     reg++) {
		if (revision >= reg->min_revision &&
		    revision <= reg->max_revision)
			buf = print_single_register(revision, reg, buf);
	}

	for (table = efx_nic_reg_tables;
	     table < efx_nic_reg_tables + ARRAY_SIZE(efx_nic_reg_tables) &&
		     buf < end;
	     table++) {
		if (revision >= table->min_revision &&
		    revision <= table->max_revision) {
			printf("\n%s:\n", table->name);
			if (table->field_count == 1)
				buf = print_simple_table(revision, table, buf);
			else
				buf = print_complex_table(revision, table, buf);
		}
	}

	return 0;
}
