/* progress-plugin.h */

#ifndef __PROGRESS_PLUGIN_H__
#define __PROGRESS_PLUGIN_H__

#include <glib-object.h>
#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>

G_BEGIN_DECLS

#define PROGRESS_TYPE_PLUGIN            (progress_plugin_get_type())          
#define PROGRESS_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), PROGRESS_TYPE_PLUGIN, ProgressPlugin))     
#define PROGRESS_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  PROGRESS_TYPE_PLUGIN, ProgressPluginClass))
#define PROGRESS_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PROGRESS_TYPE_PLUGIN))                  
#define PROGRESS_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  PROGRESS_TYPE_PLUGIN))                  
#define PROGRESS_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  PROGRESS_TYPE_PLUGIN, ProgressPluginClass))

typedef struct _ProgressPlugin        ProgressPlugin;
typedef struct _ProgressPluginClass   ProgressPluginClass;
typedef struct _ProgressPluginPrivate ProgressPluginPrivate;

struct _ProgressPlugin
{
	EthosPlugin parent;

	/*< private >*/
	ProgressPluginPrivate *priv;
};

struct _ProgressPluginClass
{
	EthosPluginClass parent_class;
};

GType        progress_plugin_get_type (void);
EthosPlugin* progress_plugin_new      (void);

G_END_DECLS

#endif /* __PROGRESS_PLUGIN_H__ */


/* progress-plugin.c */
#include "sample.h"

G_DEFINE_TYPE (ProgressPlugin, progress_plugin, ETHOS_TYPE_PLUGIN)

struct _ProgressPluginPrivate
{
	GtkWidget *progress;
};

static void
activated (EthosPlugin *plugin)
{
	GtkWidget *progress;

	PROGRESS_PLUGIN (plugin)->priv->progress = progress = gtk_progress_bar_new ();
	sample_add_widget (progress);
	gtk_widget_show (progress);
}

static void
deactivated (EthosPlugin *plugin)
{
	sample_remove_widget (PROGRESS_PLUGIN (plugin)->priv->progress);
}

static void
progress_plugin_class_init (ProgressPluginClass *klass)
{
	EthosPluginClass *plugin_class;

	g_type_class_add_private (klass, sizeof (ProgressPluginPrivate));

	plugin_class = ETHOS_PLUGIN_CLASS (klass);
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;
}

static void
progress_plugin_init (ProgressPlugin *plugin)
{
	plugin->priv = G_TYPE_INSTANCE_GET_PRIVATE (plugin,
	                                            PROGRESS_TYPE_PLUGIN,
	                                            ProgressPluginPrivate);
}

EthosPlugin*
progress_plugin_new (void)
{
	return g_object_new (PROGRESS_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return progress_plugin_new ();
}
