#-------------------------------------------------------------------------------
#  
#  Useful trait definitions.
#  
#  Written by: David C. Morrill
#  
#  Date: 07/21/2006
#  
#  (c) Copyright 2006 by David C. Morrill
#  
#-------------------------------------------------------------------------------

""" Copyright 2006 by David C. Morrill """

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------
    
from enthought.traits.api \
    import Trait, TraitHandler, TraitError
    
from enthought.traits.ui.value_tree \
    import SingleValueTreeNodeObject, TraitsNode

#-------------------------------------------------------------------------------
#  Trait definitions:
#-------------------------------------------------------------------------------

class TraitValueHandler ( TraitHandler ):
    
    #---------------------------------------------------------------------------
    #  Validates that the value is a valid trait 'node':  
    #---------------------------------------------------------------------------

    def validate ( self, object, name, value ):
        """ Validates that the value is a valid trait 'node'.
        """
        if (isinstance( value, SingleValueTreeNodeObject ) and
            isinstance( value.parent, TraitsNode )):
            return ( value.parent.value, value.name[1:] )
            
        raise TraitError
        
# Define the trait:
TraitValue = Trait( None, TraitValueHandler() )

