#include "SDL_opengl.h"
#include "plane2.h"


#include <iostream>

namespace models {

static GLuint plane2_dl=0;

void plane2::draw() {
	dldraw();
}
void plane2::dldraw() {
	if (plane2_dl==0) { sdraw(); return; }
	glCallList(plane2_dl);
}

void plane2::gen_dl() {
	plane2_dl=glGenLists(1);
	glNewList(plane2_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded plane2 " << plane2_dl << std::endl;
}
namespace mtl_plane2 {
typedef enum MTL {
m_deco,
m_engine,
m_hull,
m_klappen,
m_window,
m_last
};
} //namespace
void plane2::material (int id) {
	switch (id) {
		case mtl_plane2::m_deco:
static const GLfloat m_deco_diffuse[] = {0.200800,0.200800,0.200800};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_deco_diffuse);
static const GLfloat m_deco_ambient[] = {0.214120,0.214120,0.214120};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_deco_ambient);
static const GLfloat m_deco_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_deco_emissive);
			break;
		case mtl_plane2::m_engine:
static const GLfloat m_engine_diffuse[] = {0.00000e+0,1.00000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_engine_diffuse);
static const GLfloat m_engine_ambient[] = {0.00000e+0,1.00000,0.453333};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_engine_ambient);
static const GLfloat m_engine_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_engine_emissive);
			break;
		case mtl_plane2::m_hull:
static const GLfloat m_hull_diffuse[] = {0.880000,1.00000,0.973333};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_hull_diffuse);
static const GLfloat m_hull_ambient[] = {0.813333,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_hull_ambient);
static const GLfloat m_hull_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_hull_emissive);
			break;
		case mtl_plane2::m_klappen:
static const GLfloat m_klappen_diffuse[] = {0.800000,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_klappen_diffuse);
static const GLfloat m_klappen_ambient[] = {0.766667,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_klappen_ambient);
static const GLfloat m_klappen_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_klappen_emissive);
			break;
		case mtl_plane2::m_window:
static const GLfloat m_window_diffuse[] = {0.886667,0.886667,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_window_diffuse);
static const GLfloat m_window_ambient[] = {0.840000,0.840000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_window_ambient);
static const GLfloat m_window_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_window_emissive);
			break;
	}
}
float plane2::minx() { return -1.76483 ; }
float plane2::miny() { return -0.430481 ; }
float plane2::minz() { return -1.95994 ; }
float plane2::maxx() { return 1.76483; }
float plane2::maxy() { return 0.430481; }
float plane2::maxz() { return 1.95994; }
float plane2::radius() { return 2.67233; }
void plane2::sdraw() {
const float vertices[314][3]={
	{2.9296093e-16,0.19039928,-0.98060382},
	{-0.27450000,-0.33898066,1.52576418},
	{-0.27450000,0.21001934,1.52576418},
	{-0.25986000,-0.21820066,-0.98060382},
	{-0.25986000,8.9239336e-2,-0.98060382},
	{-0.36600000,5.7519336e-2,1.02449058},
	{-0.36600000,5.7519336e-2,0.52321698},
	{-0.42568599,5.7519336e-2,2.1943378e-2},
	{-0.36600000,5.7519336e-2,-0.47933022},
	{-0.36600000,-0.18648066,1.02449058},
	{-0.36600000,-0.18648066,0.52321698},
	{-0.42568599,-0.18648066,2.1943378e-2},
	{-0.36600000,-0.18648066,-0.47933022},
	{-0.48572267,-2.6416664e-2,0.52321698},
	{-0.48572267,-0.10254466,0.52321698},
	{-0.48572267,-0.10254466,1.02449058},
	{-0.48572267,-2.6416664e-2,1.02449058},
	{-0.74243071,-2.6416664e-2,0.52321698},
	{-0.74243071,-0.10254466,0.52321698},
	{-0.74243071,-0.10254466,1.02449058},
	{-0.74243071,-2.6416664e-2,1.02449058},
	{-0.80396751,3.9206420e-2,0.33624193},
	{-0.80396751,-0.16931909,0.33624193},
	{-0.81943711,-0.16931909,1.21146563},
	{-0.81943711,3.9206420e-2,1.21146563},
	{-1.02054191,3.9206420e-2,0.33624193},
	{-1.02054191,-0.16931909,0.33624193},
	{-1.00507231,-0.16931909,1.21146563},
	{-1.00507231,3.9206420e-2,1.21146563},
	{-1.14779604,-4.3479385e-2,0.63556843},
	{-1.14779604,-8.5481943e-2,0.63556843},
	{-1.14779604,-8.5481943e-2,0.91213912},
	{-1.14779604,-4.3479385e-2,0.91213912},
	{-1.70997204,-1.9033896e-2,0.48571851},
	{-1.70997204,-0.10992743,0.48571851},
	{-1.70997204,-8.5481943e-2,0.76228920},
	{-1.70997204,-4.3479385e-2,0.76228920},
	{-0.78849791,-6.5056333e-2,1.21146563},
	{-1.03601151,-6.5056333e-2,1.21146563},
	{-0.91225471,-0.20407334,1.21146563},
	{-0.74243071,-6.4480664e-2,1.02449058},
	{-0.91225471,-0.20407334,0.33624193},
	{-1.14779604,-6.4480664e-2,0.91213912},
	{-0.78849791,-6.5056333e-2,0.33624193},
	{-1.03601151,-6.5056333e-2,0.33624193},
	{-0.85037631,-0.20407334,0.33624193},
	{-0.97413311,-0.20407334,0.33624193},
	{-0.74243071,-6.4480664e-2,0.52321698},
	{-0.95866351,-0.18669621,1.21146563},
	{-1.14779604,-6.4480664e-2,0.63556843},
	{-0.86584591,-0.18669621,1.21146563},
	{-0.14782333,-0.21230400,1.86346000},
	{-0.14782333,8.3342669e-2,1.86346000},
	{-0.36600000,-6.4480664e-2,1.52576418},
	{-3.2090190e-16,0.40267928,1.52576418},
	{-3.2090190e-16,-0.43048066,1.52576418},
	{-4.1394940e-16,-0.24976816,1.90567198},
	{-0.18528750,-6.4480664e-2,1.90567198},
	{-0.22097250,-0.28545316,1.74285435},
	{-4.1394940e-16,0.12080684,1.90567198},
	{-0.22097250,0.15649184,1.74285435},
	{-4.2724190e-16,-6.4480664e-2,1.95994452},
	{-3.7407190e-16,-0.35911066,1.74285435},
	{-0.29463000,-6.4480664e-2,1.74285435},
	{-3.7407190e-16,0.23014934,1.74285435},
	{-0.36600000,-6.4480664e-2,1.02449058},
	{-0.20466106,-0.18560649,-1.13242026},
	{3.3014401e-16,0.17416092,-1.13242026},
	{-0.20466106,7.3000970e-2,-1.13242026},
	{-0.11518393,-0.19034537,-1.40231615},
	{3.9624725e-16,0.17889980,-1.40231615},
	{-0.11518393,7.7739850e-2,-1.40231615},
	{-7.7714380e-2,-0.16913324,-1.95994452},
	{5.3282230e-16,5.6527720e-2,-1.95994452},
	{-0.10528696,5.6527720e-2,-1.95994452},
	{-0.17168131,-0.13844335,-1.88410706},
	{-0.20727500,2.5837829e-2,-1.88410706},
	{-0.20727500,2.5837829e-2,-1.47815361},
	{-0.20727500,-0.13844335,-1.47815361},
	{-0.54277964,-8.5709091e-2,-1.88410706},
	{-0.54063508,-5.9273896e-3,-1.88410706},
	{-0.54277964,-2.6896429e-2,-1.47815361},
	{-0.54277964,-8.5709091e-2,-1.47815361},
	{-0.58853027,-8.5709091e-2,-1.88410706},
	{-0.57494805,-5.9273896e-3,-1.88410706},
	{-0.58853027,-2.6896429e-2,-1.47815361},
	{-0.58853027,-8.5709091e-2,-1.47815361},
	{2.9296093e-16,-0.28250694,-0.98060382},
	{3.3014401e-16,-0.24991277,-1.13242026},
	{3.9624725e-16,-0.25465165,-1.40231615},
	{5.3282230e-16,-0.16913324,-1.95994452},
	{-0.48773591,0.11988685,-1.83336288},
	{-0.48559135,0.14085589,-1.52889779},
	{-0.51990432,0.14085589,-1.52889779},
	{-0.53348654,0.11988685,-1.83336288},
	{-0.47987252,-0.25346141,-1.54560546},
	{-0.47987252,-0.25346141,-1.88410706},
	{-0.50506905,-0.25346141,-1.88410706},
	{-0.52562315,-0.25346141,-1.54560546},
	{-3.5634857e-16,0.28765932,1.67049096},
	{-0.13725000,0.35977660,1.52576418},
	{-2.0514503e-16,0.43048066,1.05313527},
	{8.8339988e-17,0.26115928,-0.14514782},
	{-0.26474000,0.12949934,-0.14514782},
	{-0.26962000,0.16975934,0.69030818},
	{-5.8402521e-17,0.29653928,0.45399372},
	{-0.27206000,0.18988934,1.10803618},
	{-0.13603000,0.31018500,1.08058572},
	{-0.13725000,0.24883933,1.59812757},
	{-1.00928004,-6.5056333e-2,1.21146563},
	{-0.98413466,1.9681692e-2,1.21146563},
	{-0.84037476,1.9681692e-2,1.21146563},
	{-0.81522937,-6.5056333e-2,1.21146563},
	{-0.84037476,-0.14979436,1.21146563},
	{-0.87483227,-0.16269649,1.21146563},
	{-0.91225471,-0.17670880,1.21146563},
	{-0.94967715,-0.16269649,1.21146563},
	{-0.98413466,-0.14979436,1.21146563},
	{-0.96560107,-0.17844637,0.33624193},
	{-0.91225471,-0.17844637,0.33624193},
	{-0.85890834,-0.17844637,0.33624193},
	{-0.82776935,-0.15512725,0.33624193},
	{-0.81440541,-6.5056333e-2,0.33624193},
	{-0.82776935,2.5014585e-2,0.33624193},
	{-0.99674006,2.5014585e-2,0.33624193},
	{-1.01010400,-6.5056333e-2,0.33624193},
	{-0.99674006,-0.15512725,0.33624193},
	{-1.00928004,-6.5056333e-2,1.08535606},
	{-0.98413466,1.9681692e-2,1.08535606},
	{-0.94967715,3.2583824e-2,1.08535606},
	{-0.91225471,1.7123266e-2,1.08535606},
	{-0.87483227,3.2583824e-2,1.08535606},
	{-0.84037476,1.9681692e-2,1.08535606},
	{-0.81522937,-6.5056333e-2,1.08535606},
	{-0.84037476,-0.14979436,1.08535606},
	{-0.87483227,-0.16269649,1.08535606},
	{-0.91225471,-0.17670880,1.08535606},
	{-0.94967715,-0.16269649,1.08535606},
	{-0.98413466,-0.14979436,1.08535606},
	{-0.26397384,-0.25213984,-0.27631441},
	{-0.27040887,-0.25063142,0.82536298},
	{1.5259096e-16,-0.31634360,-0.40748101},
	{-1.0508983e-16,-0.33402920,0.64461542},
	{-1.76483235,-0.10992743,0.48571851},
	{-1.76483235,-1.9033896e-2,0.48571851},
	{-1.76483235,-4.3479385e-2,0.76228920},
	{-1.76483235,-8.5481943e-2,0.76228920},
	{-1.46196214,1.7004299e-2,-0.80140796},
	{-1.46196214,-0.14596563,-0.80140796},
	{-1.40710183,-0.14596563,-0.80140796},
	{-1.40710183,1.7004299e-2,-0.80140796},
	{-0.47987252,0.14085589,-1.68113033},
	{-0.51132608,5.6979729e-2,-1.88410706},
	{-0.52562315,0.14085589,-1.68113033},
	{-0.55707671,5.6979729e-2,-1.88410706},
	{-0.56565495,-8.5709091e-2,-1.88410706},
	{-0.56565495,-2.6896429e-2,-1.47815361},
	{-3.5049987e-16,0.30663761,1.64661104},
	{-0.25185375,0.23472928,1.52576418},
	{-0.13725000,0.26714398,1.58618761},
	{-0.26230000,-0.23833066,-0.56287582},
	{-0.26810232,-0.25381698,0.43048136},
	{-0.22274452,-0.26297412,-0.24941044},
	{-0.22665199,-0.26433933,0.43075157},
	{-0.22742799,-0.25740457,0.74716061},
	{-4.1082581e-2,-0.32175962,0.62125268},
	{-4.0617446e-2,-0.30398222,-0.33950535},
	{-0.13481000,0.23314931,0.57215095},
	{0.27450000,-0.33898066,1.52576418},
	{0.27450000,0.21001934,1.52576418},
	{0.25986000,-0.21820066,-0.98060382},
	{0.25986000,8.9239336e-2,-0.98060382},
	{0.36600000,5.7519336e-2,1.02449058},
	{0.36600000,5.7519336e-2,0.52321698},
	{0.42568599,5.7519336e-2,2.1943378e-2},
	{0.36600000,5.7519336e-2,-0.47933022},
	{0.36600000,-0.18648066,1.02449058},
	{0.36600000,-0.18648066,0.52321698},
	{0.42568599,-0.18648066,2.1943378e-2},
	{0.36600000,-0.18648066,-0.47933022},
	{0.48572267,-2.6416664e-2,0.52321698},
	{0.48572267,-0.10254466,0.52321698},
	{0.48572267,-0.10254466,1.02449058},
	{0.48572267,-2.6416664e-2,1.02449058},
	{0.74243071,-2.6416664e-2,0.52321698},
	{0.74243071,-0.10254466,0.52321698},
	{0.74243071,-0.10254466,1.02449058},
	{0.74243071,-2.6416664e-2,1.02449058},
	{0.80396751,3.9206420e-2,0.33624193},
	{0.80396751,-0.16931909,0.33624193},
	{0.81943711,-0.16931909,1.21146563},
	{0.81943711,3.9206420e-2,1.21146563},
	{1.02054191,3.9206420e-2,0.33624193},
	{1.02054191,-0.16931909,0.33624193},
	{1.00507231,-0.16931909,1.21146563},
	{1.00507231,3.9206420e-2,1.21146563},
	{1.14779604,-4.3479385e-2,0.63556843},
	{1.14779604,-8.5481943e-2,0.63556843},
	{1.14779604,-8.5481943e-2,0.91213912},
	{1.14779604,-4.3479385e-2,0.91213912},
	{1.70997204,-1.9033896e-2,0.48571851},
	{1.70997204,-0.10992743,0.48571851},
	{1.70997204,-8.5481943e-2,0.76228920},
	{1.70997204,-4.3479385e-2,0.76228920},
	{0.78849791,-6.5056333e-2,1.21146563},
	{1.03601151,-6.5056333e-2,1.21146563},
	{0.91225471,-0.20407334,1.21146563},
	{0.74243071,-6.4480664e-2,1.02449058},
	{0.91225471,-0.20407334,0.33624193},
	{1.14779604,-6.4480664e-2,0.91213912},
	{0.78849791,-6.5056333e-2,0.33624193},
	{1.03601151,-6.5056333e-2,0.33624193},
	{0.85037631,-0.20407334,0.33624193},
	{0.97413311,-0.20407334,0.33624193},
	{0.74243071,-6.4480664e-2,0.52321698},
	{0.95866351,-0.18669621,1.21146563},
	{1.14779604,-6.4480664e-2,0.63556843},
	{0.86584591,-0.18669621,1.21146563},
	{0.14782333,-0.21230400,1.86346000},
	{0.14782333,8.3342669e-2,1.86346000},
	{0.36600000,-6.4480664e-2,1.52576418},
	{0.18528750,-6.4480664e-2,1.90567198},
	{0.22097250,-0.28545316,1.74285435},
	{0.22097250,0.15649184,1.74285435},
	{0.29463000,-6.4480664e-2,1.74285435},
	{0.36600000,-6.4480664e-2,1.02449058},
	{0.20466106,-0.18560649,-1.13242026},
	{0.20466106,7.3000970e-2,-1.13242026},
	{0.11518393,-0.19034537,-1.40231615},
	{0.11518393,7.7739850e-2,-1.40231615},
	{7.7714380e-2,-0.16913324,-1.95994452},
	{0.10528696,5.6527720e-2,-1.95994452},
	{0.17168131,-0.13844335,-1.88410706},
	{0.20727500,2.5837829e-2,-1.88410706},
	{0.20727500,2.5837829e-2,-1.47815361},
	{0.20727500,-0.13844335,-1.47815361},
	{0.54277964,-8.5709091e-2,-1.88410706},
	{0.54063508,-5.9273896e-3,-1.88410706},
	{0.54277964,-2.6896429e-2,-1.47815361},
	{0.54277964,-8.5709091e-2,-1.47815361},
	{0.58853027,-8.5709091e-2,-1.88410706},
	{0.57494805,-5.9273896e-3,-1.88410706},
	{0.58853027,-2.6896429e-2,-1.47815361},
	{0.58853027,-8.5709091e-2,-1.47815361},
	{0.48773591,0.11988685,-1.83336288},
	{0.48559135,0.14085589,-1.52889779},
	{0.51990432,0.14085589,-1.52889779},
	{0.53348654,0.11988685,-1.83336288},
	{0.47987252,-0.25346141,-1.54560546},
	{0.47987252,-0.25346141,-1.88410706},
	{0.50506905,-0.25346141,-1.88410706},
	{0.52562315,-0.25346141,-1.54560546},
	{0.13725000,0.35977660,1.52576418},
	{0.26474000,0.12949934,-0.14514782},
	{0.26962000,0.16975934,0.69030818},
	{0.27206000,0.18988934,1.10803618},
	{0.13603000,0.31018500,1.08058572},
	{0.13725000,0.24883933,1.59812757},
	{1.00928004,-6.5056333e-2,1.21146563},
	{0.98413466,1.9681692e-2,1.21146563},
	{0.84037476,1.9681692e-2,1.21146563},
	{0.81522937,-6.5056333e-2,1.21146563},
	{0.84037476,-0.14979436,1.21146563},
	{0.87483227,-0.16269649,1.21146563},
	{0.91225471,-0.17670880,1.21146563},
	{0.94967715,-0.16269649,1.21146563},
	{0.98413466,-0.14979436,1.21146563},
	{0.96560107,-0.17844637,0.33624193},
	{0.91225471,-0.17844637,0.33624193},
	{0.85890834,-0.17844637,0.33624193},
	{0.82776935,-0.15512725,0.33624193},
	{0.81440541,-6.5056333e-2,0.33624193},
	{0.82776935,2.5014585e-2,0.33624193},
	{0.99674006,2.5014585e-2,0.33624193},
	{1.01010400,-6.5056333e-2,0.33624193},
	{0.99674006,-0.15512725,0.33624193},
	{1.00928004,-6.5056333e-2,1.08535606},
	{0.98413466,1.9681692e-2,1.08535606},
	{0.94967715,3.2583824e-2,1.08535606},
	{0.91225471,1.7123266e-2,1.08535606},
	{0.87483227,3.2583824e-2,1.08535606},
	{0.84037476,1.9681692e-2,1.08535606},
	{0.81522937,-6.5056333e-2,1.08535606},
	{0.84037476,-0.14979436,1.08535606},
	{0.87483227,-0.16269649,1.08535606},
	{0.91225471,-0.17670880,1.08535606},
	{0.94967715,-0.16269649,1.08535606},
	{0.98413466,-0.14979436,1.08535606},
	{0.26397384,-0.25213984,-0.27631441},
	{0.27040887,-0.25063142,0.82536298},
	{1.76483235,-0.10992743,0.48571851},
	{1.76483235,-1.9033896e-2,0.48571851},
	{1.76483235,-4.3479385e-2,0.76228920},
	{1.76483235,-8.5481943e-2,0.76228920},
	{1.46196214,1.7004299e-2,-0.80140796},
	{1.46196214,-0.14596563,-0.80140796},
	{1.40710183,-0.14596563,-0.80140796},
	{1.40710183,1.7004299e-2,-0.80140796},
	{0.47987252,0.14085589,-1.68113033},
	{0.51132608,5.6979729e-2,-1.88410706},
	{0.52562315,0.14085589,-1.68113033},
	{0.55707671,5.6979729e-2,-1.88410706},
	{0.56565495,-8.5709091e-2,-1.88410706},
	{0.56565495,-2.6896429e-2,-1.47815361},
	{0.25185375,0.23472928,1.52576418},
	{0.13725000,0.26714398,1.58618761},
	{0.26230000,-0.23833066,-0.56287582},
	{0.26810232,-0.25381698,0.43048136},
	{0.22274452,-0.26297412,-0.24941044},
	{0.22665199,-0.26433933,0.43075157},
	{0.22742799,-0.25740457,0.74716061},
	{4.1082581e-2,-0.32175962,0.62125268},
	{4.0617446e-2,-0.30398222,-0.33950535},
	{0.13481000,0.23314931,0.57215095},
};
const float normals[314][3]={
	{-6.0650046e-17,0.99207368,-0.12565756},
	{-0.71583951,-0.69114542,9.9457538e-2},
	{-0.77703595,0.57667112,0.25232034},
	{-0.70507531,-0.67509507,-0.21706095},
	{-0.74802759,0.63449288,-0.19461120},
	{-0.76720553,0.54427931,0.33934601},
	{-0.77177886,0.58991814,-0.23738993},
	{-0.87271876,0.48801361,-1.4306397e-2},
	{-0.93048077,0.33728890,-0.14297462},
	{-0.71019089,-0.66019657,0.24447779},
	{-0.68956853,-0.68605861,-0.23198886},
	{-0.85041964,-0.52601467,-9.7469915e-3},
	{-0.84910116,-0.51368639,-0.12309963},
	{-0.20771970,0.65812587,-0.72368700},
	{-0.20771970,-0.65812587,-0.72368700},
	{-0.20771970,-0.65812587,0.72368700},
	{-0.20771970,0.65812587,0.72368700},
	{0.59666018,0.66261731,-0.45269738},
	{0.59908091,-0.66054952,-0.45252226},
	{0.57729494,-0.67980003,0.45233006},
	{0.57481417,0.68171991,0.45259986},
	{0.49399763,0.54860604,-0.67453521},
	{0.60748398,-0.48053129,-0.63249735},
	{0.58867183,-0.49783822,0.63688506},
	{0.47827670,0.56722809,0.67045036},
	{-0.42791689,0.58049477,-0.69275750},
	{-0.54837682,-0.51753449,-0.65684162},
	{-0.53087812,-0.53650898,0.65599279},
	{-0.41384998,0.60111003,0.68366287},
	{-0.45097914,0.74976546,-0.48422058},
	{-0.45307320,-0.74859107,-0.48408272},
	{-0.56068185,-0.69049028,0.45701098},
	{-0.55894791,0.69168459,0.45732883},
	{0.37688559,0.90952966,-0.17525141},
	{0.37688559,-0.90952966,-0.17525141},
	{-8.5204157e-2,-0.68652681,0.72209500},
	{-8.5204157e-2,0.68652681,0.72209500},
	{0.59395956,-2.2192119e-5,0.80449490},
	{-0.55663300,-2.1027117e-5,0.83075851},
	{-1.6607610e-15,-0.69860216,0.71551032},
	{0.77230200,-2.8855531e-5,0.63525555},
	{9.9317376e-17,-0.70657241,-0.70764075},
	{-0.77768865,-2.5727508e-5,0.62864964},
	{0.60688579,-5.4682118e-6,-0.79478905},
	{-0.56515790,-5.4546694e-6,-0.82498276},
	{0.23259781,-0.66724169,-0.70759224},
	{-0.23259781,-0.66724169,-0.70759224},
	{0.78503928,-7.0734249e-6,-0.61944599},
	{-0.22925438,-0.65765055,0.71759193},
	{-0.69026931,-7.7357277e-6,-0.72355254},
	{0.22925438,-0.65765055,0.71759193},
	{-0.48388296,-0.48388296,0.72918760},
	{-0.48388296,0.48388296,0.72918760},
	{-0.98285797,5.8085589e-17,0.18436433},
	{-6.7514999e-17,0.91698499,0.39892170},
	{-7.5001104e-17,-0.99484711,0.10138653},
	{6.0989530e-17,-0.58382373,0.81188044},
	{-0.58382373,-2.8970027e-16,0.81188044},
	{-0.62204916,-0.62204916,0.47550992},
	{6.0989530e-17,0.58382373,0.81188044},
	{-0.63239695,0.59634000,0.49442159},
	{-1.5284540e-17,-2.4455264e-16,1.00000000},
	{-1.4733581e-17,-0.88760967,0.46059642},
	{-0.88760967,-1.4733581e-17,0.46059642},
	{-2.2218659e-16,0.85829125,0.51316287},
	{-0.86874983,4.9566813e-17,0.49525117},
	{-0.76992771,-0.56841328,-0.29003047},
	{-3.1482614e-17,0.99055249,-0.13713411},
	{-0.82019458,0.50875406,-0.26162982},
	{-0.69167744,-0.71907548,6.7177213e-2},
	{-1.5807467e-17,0.99391407,-0.11015818},
	{-0.73766933,0.67245076,6.0447755e-2},
	{-0.43466696,-0.63953472,-0.63408199},
	{0.0000000e+0,0.62743174,-0.77867157},
	{-0.47957441,0.58431653,-0.65466219},
	{-0.39273127,-0.67616877,-0.62334416},
	{-0.40457714,0.65150086,-0.64176629},
	{-0.40428224,0.67061771,0.62195479},
	{-0.42100661,-0.67368258,0.60737568},
	{0.24856905,-0.20104058,-0.94752103},
	{0.25698084,0.20094054,-0.94529559},
	{0.25013648,0.28527866,0.92522853},
	{0.24721669,-0.31688192,0.91567994},
	{-0.68033049,-0.10593952,-0.72520841},
	{-0.68513304,0.15553807,-0.71161832},
	{-0.68122360,0.25658771,0.68563632},
	{-0.69054388,-0.24217722,0.68154189},
	{-1.4425856e-17,-0.98780392,-0.15570299},
	{0.0000000e+0,-0.98782838,-0.15554769},
	{-2.9583993e-17,-0.99695160,-7.8022485e-2},
	{-3.8280898e-17,-0.65087353,-0.75918617},
	{0.51389420,0.69558239,-0.50207359},
	{0.57214782,0.56991071,0.58978695},
	{-0.44455760,0.77166307,0.45486772},
	{-0.39592070,0.83283968,-0.38681372},
	{0.56138141,-0.61270975,0.55627123},
	{0.61769897,-0.42806567,-0.65970279},
	{-0.46843669,-0.71196531,-0.52313714},
	{-0.41972411,-0.80847335,0.41255608},
	{-4.6906127e-17,0.81669203,0.57707376},
	{-0.57028177,0.73764537,0.36146648},
	{1.0120314e-16,0.99463962,-0.10340226},
	{-7.6831707e-17,0.99813400,-6.1061518e-2},
	{-0.47774856,0.87757951,-4.0131335e-2},
	{-0.61145776,0.79027719,-3.9766481e-2},
	{4.9518223e-17,0.99307097,-0.11751613},
	{-0.69943447,0.71247021,-5.6370358e-2},
	{-0.60748412,0.79033556,-7.9578547e-2},
	{-0.46529160,0.65509121,0.59528080},
	{0.69203636,-1.2021428e-16,0.72186265},
	{0.27302414,-0.83619177,0.47564813},
	{-0.38146042,-0.69071964,0.61432428},
	{-0.69203636,-2.8049999e-16,0.72186265},
	{-0.48778749,0.45487044,0.74508808},
	{-0.24795430,0.66220742,0.70710678},
	{-2.2892447e-15,0.68355362,0.72990030},
	{0.24795430,0.66220742,0.70710678},
	{0.48778749,0.45487044,0.74508808},
	{3.2070867e-17,0.0000000e+0,-1.00000000},
	{3.2070867e-17,0.0000000e+0,-1.00000000},
	{3.2070867e-17,0.0000000e+0,-1.00000000},
	{3.2070867e-17,0.0000000e+0,-1.00000000},
	{3.2070867e-17,-2.8712788e-17,-1.00000000},
	{3.2070867e-17,-2.8712788e-17,-1.00000000},
	{3.2070867e-17,0.0000000e+0,-1.00000000},
	{3.2070867e-17,2.8712788e-17,-1.00000000},
	{3.2070867e-17,2.8712788e-17,-1.00000000},
	{0.88665373,-7.7010723e-17,0.46243395},
	{0.63849986,-0.59541239,0.48764948},
	{-1.1852363e-2,-0.91634295,0.40021883},
	{-0.13950977,-0.91676251,0.37427733},
	{-0.12190621,-0.88674042,0.44590392},
	{-0.63849986,-0.59541239,0.48764948},
	{-0.88665373,-5.1340482e-17,0.46243395},
	{-0.63849986,0.59541239,0.48764948},
	{-0.31364013,0.83763349,0.44721360},
	{-1.0196373e-15,0.88214482,0.47097825},
	{0.31364013,0.83763349,0.44721360},
	{0.63849986,0.59541239,0.48764948},
	{-0.32610502,-0.94522359,-1.4418120e-2},
	{-0.43162597,-0.90062884,-5.0662843e-2},
	{8.1437340e-17,-0.99983971,-1.7904270e-2},
	{-1.4691258e-16,-0.99788572,-6.4992990e-2},
	{-0.70255166,-0.71049437,-4.0235645e-2},
	{-0.70255166,0.71049437,-4.0235645e-2},
	{-0.56111729,0.55893821,0.61052064},
	{-0.56111729,-0.55893821,0.61052064},
	{-0.52874024,0.54296830,-0.65239496},
	{-0.52874024,-0.54296830,-0.65239496},
	{0.61579616,-0.63236684,-0.47000774},
	{0.61579616,0.63236684,-0.47000774},
	{0.82385490,0.56380327,-5.8214893e-2},
	{0.72494788,-3.2452685e-2,-0.68803881},
	{-0.57251662,0.81890238,-4.0294072e-2},
	{-0.64690173,0.45539347,-0.61166571},
	{0.0000000e+0,0.0000000e+0,-1.00000000},
	{0.0000000e+0,0.14634449,0.98923369},
	{1.3752629e-16,0.69281615,0.72111427},
	{-0.62719511,0.59700345,0.50021313},
	{-0.46494168,0.55276601,0.69157716},
	{-0.39963649,-0.91531091,-4.9966073e-2},
	{-0.36265812,-0.93189176,7.5390557e-3},
	{-0.24532188,-0.96943896,2.2984966e-3},
	{-0.23458566,-0.97209496,9.7521721e-4},
	{-0.26605961,-0.96380789,-1.6930250e-2},
	{-0.30163617,-0.95304294,-2.6921766e-2},
	{-0.26144455,-0.96521612,-2.1439902e-3},
	{-0.55296521,0.82775599,-9.5128811e-2},
	{0.71583951,-0.69114542,9.9457538e-2},
	{0.77703595,0.57667112,0.25232034},
	{0.70507531,-0.67509507,-0.21706095},
	{0.74802759,0.63449288,-0.19461120},
	{0.76720553,0.54427931,0.33934601},
	{0.77177886,0.58991814,-0.23738993},
	{0.87271876,0.48801361,-1.4306397e-2},
	{0.93048077,0.33728890,-0.14297462},
	{0.71019089,-0.66019657,0.24447779},
	{0.68956853,-0.68605861,-0.23198886},
	{0.85041964,-0.52601467,-9.7469915e-3},
	{0.84910116,-0.51368639,-0.12309963},
	{0.20771970,0.65812587,-0.72368700},
	{0.20771970,-0.65812587,-0.72368700},
	{0.20771970,-0.65812587,0.72368700},
	{0.20771970,0.65812587,0.72368700},
	{-0.59666018,0.66261731,-0.45269738},
	{-0.59908091,-0.66054952,-0.45252226},
	{-0.57729494,-0.67980003,0.45233006},
	{-0.57481417,0.68171991,0.45259986},
	{-0.49399763,0.54860604,-0.67453521},
	{-0.60748398,-0.48053129,-0.63249735},
	{-0.58867183,-0.49783822,0.63688506},
	{-0.47827670,0.56722809,0.67045036},
	{0.42791689,0.58049477,-0.69275750},
	{0.54837682,-0.51753449,-0.65684162},
	{0.53087812,-0.53650898,0.65599279},
	{0.41384998,0.60111003,0.68366287},
	{0.45097914,0.74976546,-0.48422058},
	{0.45307320,-0.74859107,-0.48408272},
	{0.56068185,-0.69049028,0.45701098},
	{0.55894791,0.69168459,0.45732883},
	{-0.37688559,0.90952966,-0.17525141},
	{-0.37688559,-0.90952966,-0.17525141},
	{8.5204157e-2,-0.68652681,0.72209500},
	{8.5204157e-2,0.68652681,0.72209500},
	{-0.59395956,-2.2192119e-5,0.80449490},
	{0.55663300,-2.1027117e-5,0.83075851},
	{1.6509413e-15,-0.69860216,0.71551032},
	{-0.77230200,-2.8855531e-5,0.63525555},
	{2.3552878e-16,-0.70657241,-0.70764075},
	{0.77768865,-2.5727508e-5,0.62864964},
	{-0.60688579,-5.4682118e-6,-0.79478905},
	{0.56515790,-5.4546694e-6,-0.82498276},
	{-0.23259781,-0.66724169,-0.70759224},
	{0.23259781,-0.66724169,-0.70759224},
	{-0.78503928,-7.0734249e-6,-0.61944599},
	{0.22925438,-0.65765055,0.71759193},
	{0.69026931,-7.7357277e-6,-0.72355254},
	{-0.22925438,-0.65765055,0.71759193},
	{0.48388296,-0.48388296,0.72918760},
	{0.48388296,0.48388296,0.72918760},
	{0.98285797,8.7128384e-17,0.18436433},
	{0.58382373,1.5247383e-17,0.81188044},
	{0.62204916,-0.62204916,0.47550992},
	{0.63239695,0.59634000,0.49442159},
	{0.88760967,8.8401484e-17,0.46059642},
	{0.86874983,2.4783406e-17,0.49525117},
	{0.76992771,-0.56841328,-0.29003047},
	{0.82019458,0.50875406,-0.26162982},
	{0.69167744,-0.71907548,6.7177213e-2},
	{0.73766933,0.67245076,6.0447755e-2},
	{0.43466696,-0.63953472,-0.63408199},
	{0.47957441,0.58431653,-0.65466219},
	{0.39273127,-0.67616877,-0.62334416},
	{0.40457714,0.65150086,-0.64176629},
	{0.40428224,0.67061771,0.62195479},
	{0.42100661,-0.67368258,0.60737568},
	{-0.24856905,-0.20104058,-0.94752103},
	{-0.25698084,0.20094054,-0.94529559},
	{-0.25013648,0.28527866,0.92522853},
	{-0.24721669,-0.31688192,0.91567994},
	{0.68033049,-0.10593952,-0.72520841},
	{0.68513304,0.15553807,-0.71161832},
	{0.68122360,0.25658771,0.68563632},
	{0.69054388,-0.24217722,0.68154189},
	{-0.51389420,0.69558239,-0.50207359},
	{-0.57214782,0.56991071,0.58978695},
	{0.44455760,0.77166307,0.45486772},
	{0.39592070,0.83283968,-0.38681372},
	{-0.56138141,-0.61270975,0.55627123},
	{-0.61769897,-0.42806567,-0.65970279},
	{0.46843669,-0.71196531,-0.52313714},
	{0.41972411,-0.80847335,0.41255608},
	{0.57028177,0.73764537,0.36146648},
	{0.47774856,0.87757951,-4.0131335e-2},
	{0.61145776,0.79027719,-3.9766481e-2},
	{0.69943447,0.71247021,-5.6370358e-2},
	{0.60748412,0.79033556,-7.9578547e-2},
	{0.46529160,0.65509121,0.59528080},
	{-0.69203636,1.2021428e-16,0.72186265},
	{-0.27302414,-0.83619177,0.47564813},
	{0.38146042,-0.69071964,0.61432428},
	{0.69203636,1.0017857e-16,0.72186265},
	{0.48778749,0.45487044,0.74508808},
	{0.24795430,0.66220742,0.70710678},
	{2.3905388e-15,0.68355362,0.72990030},
	{-0.24795430,0.66220742,0.70710678},
	{-0.48778749,0.45487044,0.74508808},
	{4.8153039e-16,-2.1676149e-17,-1.00000000},
	{4.8153039e-16,3.6997194e-16,-1.00000000},
	{4.5711450e-16,1.3707303e-16,-1.00000000},
	{4.5711450e-16,-2.8328785e-16,-1.00000000},
	{1.6035434e-16,-5.0388937e-17,-1.00000000},
	{3.5232894e-16,-8.6712093e-16,-1.00000000},
	{3.5232894e-16,-8.9583371e-16,-1.00000000},
	{1.6035434e-16,-5.0388937e-17,-1.00000000},
	{1.6035434e-16,-2.1676149e-17,-1.00000000},
	{-0.88665373,-7.7010723e-17,0.46243395},
	{-0.63849986,-0.59541239,0.48764948},
	{1.1852363e-2,-0.91634295,0.40021883},
	{0.13950977,-0.91676251,0.37427733},
	{0.12190621,-0.88674042,0.44590392},
	{0.63849986,-0.59541239,0.48764948},
	{0.88665373,-2.5670241e-17,0.46243395},
	{0.63849986,0.59541239,0.48764948},
	{0.31364013,0.83763349,0.44721360},
	{1.1503600e-15,0.88214482,0.47097825},
	{-0.31364013,0.83763349,0.44721360},
	{-0.63849986,0.59541239,0.48764948},
	{0.32610502,-0.94522359,-1.4418120e-2},
	{0.43162597,-0.90062884,-5.0662843e-2},
	{0.70255166,-0.71049437,-4.0235645e-2},
	{0.70255166,0.71049437,-4.0235645e-2},
	{0.56111729,0.55893821,0.61052064},
	{0.56111729,-0.55893821,0.61052064},
	{0.52874024,0.54296830,-0.65239496},
	{0.52874024,-0.54296830,-0.65239496},
	{-0.61579616,-0.63236684,-0.47000774},
	{-0.61579616,0.63236684,-0.47000774},
	{-0.82385490,0.56380327,-5.8214893e-2},
	{-0.72494788,-3.2452685e-2,-0.68803881},
	{0.57251662,0.81890238,-4.0294072e-2},
	{0.64690173,0.45539347,-0.61166571},
	{0.0000000e+0,0.0000000e+0,-1.00000000},
	{0.0000000e+0,0.14634449,0.98923369},
	{0.62719511,0.59700345,0.50021313},
	{0.46494168,0.55276601,0.69157716},
	{0.39963649,-0.91531091,-4.9966073e-2},
	{0.36265812,-0.93189176,7.5390557e-3},
	{0.24532188,-0.96943896,2.2984966e-3},
	{0.23458566,-0.97209496,9.7521721e-4},
	{0.26605961,-0.96380789,-1.6930250e-2},
	{0.30163617,-0.95304294,-2.6921766e-2},
	{0.26144455,-0.96521612,-2.1439902e-3},
	{0.55296521,0.82775599,-9.5128811e-2},
};
//o cube1
material(mtl_plane2::m_deco);
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[306]);
	glVertex3fv(vertices[306]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[313]);
	glVertex3fv(vertices[313]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
glEnd();
material(mtl_plane2::m_engine);
glBegin(GL_POLYGON);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[277]);
	glVertex3fv(vertices[277]);
	glNormal3fv(normals[278]);
	glVertex3fv(vertices[278]);
	glNormal3fv(normals[279]);
	glVertex3fv(vertices[279]);
	glNormal3fv(normals[280]);
	glVertex3fv(vertices[280]);
	glNormal3fv(normals[281]);
	glVertex3fv(vertices[281]);
	glNormal3fv(normals[282]);
	glVertex3fv(vertices[282]);
	glNormal3fv(normals[283]);
	glVertex3fv(vertices[283]);
	glNormal3fv(normals[284]);
	glVertex3fv(vertices[284]);
	glNormal3fv(normals[285]);
	glVertex3fv(vertices[285]);
	glNormal3fv(normals[286]);
	glVertex3fv(vertices[286]);
	glNormal3fv(normals[287]);
	glVertex3fv(vertices[287]);
	glNormal3fv(normals[276]);
	glVertex3fv(vertices[276]);
glEnd();
material(mtl_plane2::m_hull);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[306]);
	glVertex3fv(vertices[306]);
	glNormal3fv(normals[288]);
	glVertex3fv(vertices[288]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[305]);
	glVertex3fv(vertices[305]);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[313]);
	glVertex3fv(vertices[313]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[313]);
	glVertex3fv(vertices[313]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[312]);
	glVertex3fv(vertices[312]);
	glNormal3fv(normals[311]);
	glVertex3fv(vertices[311]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[289]);
	glVertex3fv(vertices[289]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[311]);
	glVertex3fv(vertices[311]);
	glNormal3fv(normals[310]);
	glVertex3fv(vertices[310]);
	glNormal3fv(normals[289]);
	glVertex3fv(vertices[289]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
	glNormal3fv(normals[289]);
	glVertex3fv(vertices[289]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[304]);
	glVertex3fv(vertices[304]);
	glNormal3fv(normals[305]);
	glVertex3fv(vertices[305]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
	glNormal3fv(normals[289]);
	glVertex3fv(vertices[289]);
	glNormal3fv(normals[307]);
	glVertex3fv(vertices[307]);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[307]);
	glVertex3fv(vertices[307]);
	glNormal3fv(normals[288]);
	glVertex3fv(vertices[288]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[288]);
	glVertex3fv(vertices[288]);
	glNormal3fv(normals[306]);
	glVertex3fv(vertices[306]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
	glNormal3fv(normals[273]);
	glVertex3fv(vertices[273]);
	glNormal3fv(normals[272]);
	glVertex3fv(vertices[272]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[272]);
	glVertex3fv(vertices[272]);
	glNormal3fv(normals[271]);
	glVertex3fv(vertices[271]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[270]);
	glVertex3fv(vertices[270]);
	glNormal3fv(normals[269]);
	glVertex3fv(vertices[269]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
	glNormal3fv(normals[275]);
	glVertex3fv(vertices[275]);
	glNormal3fv(normals[274]);
	glVertex3fv(vertices[274]);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[297]);
	glVertex3fv(vertices[297]);
	glNormal3fv(normals[296]);
	glVertex3fv(vertices[296]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[290]);
	glVertex3fv(vertices[290]);
	glNormal3fv(normals[293]);
	glVertex3fv(vertices[293]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[296]);
	glVertex3fv(vertices[296]);
	glNormal3fv(normals[295]);
	glVertex3fv(vertices[295]);
	glNormal3fv(normals[290]);
	glVertex3fv(vertices[290]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[293]);
	glVertex3fv(vertices[293]);
	glNormal3fv(normals[292]);
	glVertex3fv(vertices[292]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[292]);
	glVertex3fv(vertices[292]);
	glNormal3fv(normals[291]);
	glVertex3fv(vertices[291]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[271]);
	glVertex3fv(vertices[271]);
	glNormal3fv(normals[270]);
	glVertex3fv(vertices[270]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[274]);
	glVertex3fv(vertices[274]);
	glNormal3fv(normals[273]);
	glVertex3fv(vertices[273]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[269]);
	glVertex3fv(vertices[269]);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
	glNormal3fv(normals[275]);
	glVertex3fv(vertices[275]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[302]);
	glVertex3fv(vertices[302]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[298]);
	glVertex3fv(vertices[298]);
	glNormal3fv(normals[299]);
	glVertex3fv(vertices[299]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[303]);
	glVertex3fv(vertices[303]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[301]);
	glVertex3fv(vertices[301]);
	glNormal3fv(normals[300]);
	glVertex3fv(vertices[300]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
	glNormal3fv(normals[301]);
	glVertex3fv(vertices[301]);
	glNormal3fv(normals[299]);
	glVertex3fv(vertices[299]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[299]);
	glVertex3fv(vertices[299]);
	glNormal3fv(normals[298]);
	glVertex3fv(vertices[298]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[300]);
	glVertex3fv(vertices[300]);
	glNormal3fv(normals[298]);
	glVertex3fv(vertices[298]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[298]);
	glVertex3fv(vertices[298]);
	glNormal3fv(normals[300]);
	glVertex3fv(vertices[300]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[276]);
	glVertex3fv(vertices[276]);
	glNormal3fv(normals[287]);
	glVertex3fv(vertices[287]);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[277]);
	glVertex3fv(vertices[277]);
	glNormal3fv(normals[276]);
	glVertex3fv(vertices[276]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[282]);
	glVertex3fv(vertices[282]);
	glNormal3fv(normals[281]);
	glVertex3fv(vertices[281]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[283]);
	glVertex3fv(vertices[283]);
	glNormal3fv(normals[282]);
	glVertex3fv(vertices[282]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[284]);
	glVertex3fv(vertices[284]);
	glNormal3fv(normals[283]);
	glVertex3fv(vertices[283]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[285]);
	glVertex3fv(vertices[285]);
	glNormal3fv(normals[284]);
	glVertex3fv(vertices[284]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
	glNormal3fv(normals[286]);
	glVertex3fv(vertices[286]);
	glNormal3fv(normals[285]);
	glVertex3fv(vertices[285]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[287]);
	glVertex3fv(vertices[287]);
	glNormal3fv(normals[286]);
	glVertex3fv(vertices[286]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[269]);
	glVertex3fv(vertices[269]);
	glNormal3fv(normals[270]);
	glVertex3fv(vertices[270]);
	glNormal3fv(normals[271]);
	glVertex3fv(vertices[271]);
	glNormal3fv(normals[272]);
	glVertex3fv(vertices[272]);
	glNormal3fv(normals[273]);
	glVertex3fv(vertices[273]);
	glNormal3fv(normals[274]);
	glVertex3fv(vertices[274]);
	glNormal3fv(normals[275]);
	glVertex3fv(vertices[275]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[277]);
	glVertex3fv(vertices[277]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[278]);
	glVertex3fv(vertices[278]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[278]);
	glVertex3fv(vertices[278]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[279]);
	glVertex3fv(vertices[279]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[279]);
	glVertex3fv(vertices[279]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[280]);
	glVertex3fv(vertices[280]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[280]);
	glVertex3fv(vertices[280]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[281]);
	glVertex3fv(vertices[281]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[288]);
	glVertex3fv(vertices[288]);
	glNormal3fv(normals[308]);
	glVertex3fv(vertices[308]);
	glNormal3fv(normals[312]);
	glVertex3fv(vertices[312]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[289]);
	glVertex3fv(vertices[289]);
	glNormal3fv(normals[310]);
	glVertex3fv(vertices[310]);
	glNormal3fv(normals[309]);
	glVertex3fv(vertices[309]);
	glNormal3fv(normals[307]);
	glVertex3fv(vertices[307]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[290]);
	glVertex3fv(vertices[290]);
	glNormal3fv(normals[295]);
	glVertex3fv(vertices[295]);
	glNormal3fv(normals[294]);
	glVertex3fv(vertices[294]);
	glNormal3fv(normals[291]);
	glVertex3fv(vertices[291]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[291]);
	glVertex3fv(vertices[291]);
	glNormal3fv(normals[292]);
	glVertex3fv(vertices[292]);
	glNormal3fv(normals[293]);
	glVertex3fv(vertices[293]);
	glNormal3fv(normals[290]);
	glVertex3fv(vertices[290]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[291]);
	glVertex3fv(vertices[291]);
	glNormal3fv(normals[294]);
	glVertex3fv(vertices[294]);
	glNormal3fv(normals[297]);
	glVertex3fv(vertices[297]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[295]);
	glVertex3fv(vertices[295]);
	glNormal3fv(normals[296]);
	glVertex3fv(vertices[296]);
	glNormal3fv(normals[297]);
	glVertex3fv(vertices[297]);
	glNormal3fv(normals[294]);
	glVertex3fv(vertices[294]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[299]);
	glVertex3fv(vertices[299]);
	glNormal3fv(normals[301]);
	glVertex3fv(vertices[301]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[300]);
	glVertex3fv(vertices[300]);
	glNormal3fv(normals[301]);
	glVertex3fv(vertices[301]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[302]);
	glVertex3fv(vertices[302]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[303]);
	glVertex3fv(vertices[303]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[304]);
	glVertex3fv(vertices[304]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[307]);
	glVertex3fv(vertices[307]);
	glNormal3fv(normals[309]);
	glVertex3fv(vertices[309]);
	glNormal3fv(normals[308]);
	glVertex3fv(vertices[308]);
	glNormal3fv(normals[288]);
	glVertex3fv(vertices[288]);
glEnd();
material(mtl_plane2::m_klappen);
glBegin(GL_POLYGON);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[309]);
	glVertex3fv(vertices[309]);
	glNormal3fv(normals[310]);
	glVertex3fv(vertices[310]);
	glNormal3fv(normals[311]);
	glVertex3fv(vertices[311]);
	glNormal3fv(normals[312]);
	glVertex3fv(vertices[312]);
	glNormal3fv(normals[308]);
	glVertex3fv(vertices[308]);
glEnd();
material(mtl_plane2::m_window);
glBegin(GL_POLYGON);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[305]);
	glVertex3fv(vertices[305]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[305]);
	glVertex3fv(vertices[305]);
	glNormal3fv(normals[304]);
	glVertex3fv(vertices[304]);
glEnd();
}
} //namespace
