# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Contains locale helper functions
"""

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

import locale, platform


"""
This is a dictionary pointing the locales to their three letter language
codes. The key could be the a locale (like 'DE_de') or a two-letter code (like
'de'). If the first thing is found it is used, the two-letter code is a
fallback.

For more informations about the 2- and 3-letter language codes, take a look
at this:
    http://en.wikipedia.org/wiki/ISO-639#Alpha-2_code_space
    http://www.sil.org/iso639-3/codes.asp
"""
locales_to_iso = {
    'de' : 'deu',
    'fr' : 'fra',
    'es' : 'spa',
    'ca' : 'cat',
    'pl' : 'pol',
    'it' : 'ita',
     }



def get_from_system_locale():
    """
    Get the system locale and look it up as a elisa-locale. If the locale
    could not be wrapped, nothing is returned

    @rtype: string or None
    @return: a three letter language code
    """

    loc = locale.getdefaultlocale()[0]

    if loc is None:
        return None

    if locales_to_iso.has_key(loc):
        return locales_to_iso[loc]

    splitter = loc.rfind('_')
    if splitter != -1:
        two_letter = loc[:splitter]

        if locales_to_iso.has_key(two_letter):
            return locales_to_iso[two_letter]

    return None

def system_encoding():
    """
    Get the encoding used by the system

    @rtype: string
    @return: the encoding used by the system
    """
    
    if platform.system() == 'Windows':
        #FIXME : must be dynamic
        return 'iso8859-1'
    
    return 'utf8'

#if __name__ == '__main__':
#    print "Reading your locale...."
#    three = get_from_system_locale()
#    if three:
#        print "In elisa it would be: '%s'" % three
#    else:
#        print "Your localisation '%s' could not be found. Please add it..." % \
#                        ( locale.getdefaultlocale()[0])
