# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
i18n related functions
"""

__maintainer__ = 'Philippe Normand <philippe@fluendo.com>'

from elisa.extern import msgfmt
from elisa.core import log
import os

log_category = "po_compile"

def compile_po_files(domain, directory, dest_directory):    
    log.info(log_category, "Compiling %s for %s to %s", directory, domain,
             dest_directory)

    package_path = os.path.dirname(dest_directory).replace(os.path.sep, '.')
    basename = os.path.basename(dest_directory)
    mo_files = {package_path: [os.path.join(basename, '*',
                                           'LC_MESSAGES', '*.mo')]}
    
    for filename in os.listdir(directory):
        lang, ext = os.path.splitext(filename)
        ext = ext[1:].lower()
        if ext == 'po':
            src = os.path.join(directory, filename)
            destdir = os.path.join(dest_directory, lang, 'LC_MESSAGES')
            dest = os.path.join(destdir, "%s.mo" % domain)
            if not os.path.exists(dest):
                if not os.path.exists(destdir):
                    try:
                        os.makedirs(destdir)
                    except OSError, e:
                        log.warning(log_category,
                                    "Could not make directory %r: %r. " \
                                    "Skipped %s." % (destdir,e,dst))
                else:
                    log.info(log_category, "Compiling %s to %s", src, dest)
                    msgfmt.make(src, dest)
                        
            else:
                src_mtime = os.stat(src)[8]
                dest_mtime = os.stat(dest)[8]
                if src_mtime > dest_mtime:
                    log.info(log_category, "Compiling %s to %s", src, dest)
                    msgfmt.make(src, dest)
                else:
                    log.info(log_category, "Skipping already compiled %r", dest)
    return mo_files

def compile_translations_from_file(translations_file):
    mo_files = {}

    log.debug(log_category, "Compiling translations listed in %r",
              translations_file)
    
    for line in open(translations_file):
        line = line.split()
        if len(line) == 2:
            domain = line[0]
            directory = line[1]
            output_directory = directory
        elif len(line) == 3:
            domain = line[0]
            directory = line[1]
            output_directory = line[2]
        else:
            continue
        mo_files.update(compile_po_files(domain, directory, output_directory))
        
    return mo_files

def compile_translations_from_files(files):
    mo_files = {}
    for filename in files:
        mo_files.update(compile_translations_from_file(filename))
    return mo_files
