# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
The main player view that creates the osd and the playback views
"""

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.core import common, player

from pgm.graph.image import Image
from pgm.graph.group import Group
from pgm.graph.text import Text
import pgm, gst, math

from elisa.plugins.pigment.pigment_view import PigmentView

from elisa.plugins.player.player_osd import PlayerOSD
from elisa.plugins.player.playback_view import PlaybackView

from elisa.extern.translation import gettexter, N_, Translatable
T_ = gettexter('elisa-player')

class PlayerView(PigmentView):

    supported_controllers = ('player:player_controller',)

    def create_widgets(self):
        super(PlayerView, self).create_widgets()

        plugin_registry = common.application.plugin_registry
        self.playback = plugin_registry.create_component('player:playback_view')
        self.osd = plugin_registry.create_component('player:player_osd')

        self.playback.frontend = self.frontend
        self.osd.frontend = self.frontend

    def clean(self):
        super(PlayerView, self).clean()
        self.playback.clean()
        self.osd.clean()
       
    def controller__set(self, controller):
        super(PlayerView, self).controller__set(controller)
        self.playback.controller = controller
        self.osd.controller = controller

        # set the x_id of the viewport to the player
        embedding_id = self.frontend.context.viewport_handle.embedding_id
        self.controller.player.embedding_id = embedding_id

    def element_attribute_set(self, position, key, old_value, new_value):
        # we need to have it?
        pass
