/*******************************************************************************
 *  Copyright (c) 2006, 2009 IBM Corporation and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *  *     IBM Corporation - initial API and implementation
 *******************************************************************************/

// This file was generated by LPG

package org.eclipse.cdt.internal.core.dom.lrparser.cpp;

import lpg.lpgjavaruntime.*;

import java.util.*;
import org.eclipse.cdt.core.dom.ast.*;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ITokenCollector;
import org.eclipse.cdt.core.dom.lrparser.CPreprocessorAdapter;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.FixedBacktrackingParser;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.index.IIndex;

import org.eclipse.cdt.core.dom.ast.cpp.*;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPSecondaryParserFactory;

public class CPPParser extends PrsStream implements RuleAction, ITokenStream, 
                                                       ITokenCollector, IParser< IASTTranslationUnit  > 
                                                           
{
    private static ParseTable prs = new CPPParserprs();
    private FixedBacktrackingParser btParser;

    public FixedBacktrackingParser getParser() { return btParser; }
    private void setResult(Object object) { btParser.setSym1(object); }
    public Object getRhsSym(int i) { return btParser.getSym(i); }

    public int getRhsTokenIndex(int i) { return btParser.getToken(i); }
    public IToken getRhsIToken(int i) { return super.getIToken(getRhsTokenIndex(i)); }
    
    public int getRhsFirstTokenIndex(int i) { return btParser.getFirstToken(i); }
    public IToken getRhsFirstIToken(int i) { return super.getIToken(getRhsFirstTokenIndex(i)); }

    public int getRhsLastTokenIndex(int i) { return btParser.getLastToken(i); }
    public IToken getRhsLastIToken(int i) { return super.getIToken(getRhsLastTokenIndex(i)); }

    public int getLeftSpan() { return btParser.getFirstToken(); }
    public IToken getLeftIToken()  { return super.getIToken(getLeftSpan()); }

    public int getRightSpan() { return btParser.getLastToken(); }
    public IToken getRightIToken() { return super.getIToken(getRightSpan()); }

    public int getRhsErrorTokenIndex(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (err instanceof ErrorToken ? index : 0);
    }
    public ErrorToken getRhsErrorIToken(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (ErrorToken) (err instanceof ErrorToken ? err : null);
    }

    public CPPParser(LexStream lexStream)
    {
        super(lexStream);

        try
        {
            super.remapTerminalSymbols(orderedTerminalSymbols(), CPPParserprs.EOFT_SYMBOL);
        }
        catch(NullExportedSymbolsException e) {
        }
        catch(NullTerminalSymbolsException e) {
        }
        catch(UnimplementedTerminalsException e)
        {
            java.util.ArrayList unimplemented_symbols = e.getSymbols();
            System.out.println("The Lexer will not scan the following token(s):");
            for (int i = 0; i < unimplemented_symbols.size(); i++)
            {
                Integer id = (Integer) unimplemented_symbols.get(i);
                System.out.println("    " + CPPParsersym.orderedTerminalSymbols[id.intValue()]);               
            }
            System.out.println();                        
        }
        catch(UndefinedEofSymbolException e)
        {
            throw new Error(new UndefinedEofSymbolException
                                ("The Lexer does not implement the Eof symbol " +
                                 CPPParsersym.orderedTerminalSymbols[CPPParserprs.EOFT_SYMBOL]));
        } 
    }

    public String[] orderedTerminalSymbols() { return CPPParsersym.orderedTerminalSymbols; }
    public String getTokenKindName(int kind) { return CPPParsersym.orderedTerminalSymbols[kind]; }
    public int getEOFTokenKind() { return CPPParserprs.EOFT_SYMBOL; }
    public PrsStream getParseStream() { return (PrsStream) this; }
    
    //
    // Report error message for given error_token.
    //
    public final void reportErrorTokenMessage(int error_token, String msg)
    {
        int firsttok = super.getFirstErrorToken(error_token),
            lasttok = super.getLastErrorToken(error_token);
        String location = super.getFileName() + ':' +
                          (firsttok > lasttok
                                    ? (super.getEndLine(lasttok) + ":" + super.getEndColumn(lasttok))
                                    : (super.getLine(error_token) + ":" +
                                       super.getColumn(error_token) + ":" +
                                       super.getEndLine(error_token) + ":" +
                                       super.getEndColumn(error_token)))
                          + ": ";
        super.reportError((firsttok > lasttok ? ParseErrorCodes.INSERTION_CODE : ParseErrorCodes.SUBSTITUTION_CODE), location, msg);
    }

    public void parser()
    {
        parser(null, 0);
    }
    
    public void parser(Monitor monitor)
    {
        parser(monitor, 0);
    }
    
    public void parser(int error_repair_count)
    {
        parser(null, error_repair_count);
    }

    public void parser(Monitor monitor, int error_repair_count)
    {
        try
        {
            btParser = new FixedBacktrackingParser(monitor, (TokenStream) this, prs, (RuleAction) this);
        }
        catch (NotBacktrackParseTableException e)
        {
            throw new Error(new NotBacktrackParseTableException
                                ("Regenerate CPPParserprs.java with -BACKTRACK option"));
        }
        catch (BadParseSymFileException e)
        {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- CPPParsersym.java"));
        }

        try
        {
            btParser.parse(error_repair_count);
        }
        catch (BadParseException e)
        {
            reset(e.error_token); // point to error token
            DiagnoseParser diagnoseParser = new DiagnoseParser(this, prs);
            diagnoseParser.diagnose(e.error_token);
        }
    }


private  CPPBuildASTParserAction  action;
private IASTCompletionNode compNode;


public CPPParser(IScanner scanner, IDOMTokenMap tokenMap, IBuiltinBindingsProvider builtinBindingsProvider, IIndex index, Map<String,String> properties) {
	initActions(properties);
	action.initializeTranslationUnit(scanner, builtinBindingsProvider, index);
	CPreprocessorAdapter.runCPreprocessor(scanner, this, tokenMap);
}

private void initActions(Map<String,String> properties) {
	ScopedStack<Object> astStack = new ScopedStack<Object>();
	
	action = new  CPPBuildASTParserAction (this, astStack,  CPPNodeFactory.getDefault() ,  CPPSecondaryParserFactory.getDefault() );
	action.setParserProperties(properties);
	
	 
}


public void addToken(IToken token) {
	token.setKind(mapKind(token.getKind())); // TODO does mapKind need to be called?
	super.addToken(token);
}


public  IASTTranslationUnit   parse() {
	// this has to be done, or... kaboom!
	setStreamLength(getSize());
	
	final int errorRepairCount = -1;  // -1 means full error handling
	parser(null, errorRepairCount); // do the actual parse
	super.resetTokenStream(); // allow tokens to be garbage collected

	compNode = action.getASTCompletionNode(); // the completion node may be null
	return ( IASTTranslationUnit  ) action.getParseResult();
}


public IASTCompletionNode getCompletionNode() {
	return compNode;
}

// uncomment this method to use with backtracking parser
public List<IToken> getRuleTokens() {
    return getTokens().subList(getLeftSpan(), getRightSpan() + 1);
}

public String[] getOrderedTerminalSymbols() {
	return CPPParsersym.orderedTerminalSymbols;
}

@SuppressWarnings("nls")
public String getName() {
	return "CPPParser";
}


    public void ruleAction(int ruleNumber)
    {
        switch (ruleNumber)
        {
  
            //
            // Rule 1:  <openscope-ast> ::= $Empty
            //
            case 1: { action.   openASTScope();             break;
            }  
  
            //
            // Rule 2:  <empty> ::= $Empty
            //
            case 2: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 13:  translation_unit ::= declaration_seq_opt
            //
            case 13: { action.   consumeTranslationUnit();            break;
            }  
  
            //
            // Rule 16:  literal ::= integer
            //
            case 16: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_integer_constant);            break;
            }  
  
            //
            // Rule 17:  literal ::= floating
            //
            case 17: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_float_constant);            break;
            }  
  
            //
            // Rule 18:  literal ::= charconst
            //
            case 18: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_char_constant);            break;
            }  
  
            //
            // Rule 19:  literal ::= stringlit
            //
            case 19: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_string_literal);            break;
            }  
  
            //
            // Rule 20:  literal ::= true
            //
            case 20: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_true);            break;
            }  
  
            //
            // Rule 21:  literal ::= false
            //
            case 21: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_false);            break;
            }  
  
            //
            // Rule 22:  literal ::= this
            //
            case 22: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_this);            break;
            }  
  
            //
            // Rule 24:  primary_expression ::= ( expression )
            //
            case 24: { action.   consumeExpressionBracketed();             break;
            }  
  
            //
            // Rule 26:  id_expression ::= qualified_or_unqualified_name
            //
            case 26: { action.   consumeExpressionName();             break;
            }  
  
            //
            // Rule 33:  unqualified_id_name ::= ~ identifier_token
            //
            case 33: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 34:  unqualified_id_name ::= ~ template_id_name
            //
            case 34: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 35:  identifier_name ::= identifier_token
            //
            case 35: { action.   consumeIdentifierName();             break;
            }  
  
            //
            // Rule 36:  template_opt ::= template
            //
            case 36: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 37:  template_opt ::= $Empty
            //
            case 37: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 38:  dcolon_opt ::= ::
            //
            case 38: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 39:  dcolon_opt ::= $Empty
            //
            case 39: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 40:  qualified_id_name ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name
            //
            case 40: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 41:  qualified_id_name ::= :: unqualified_id_name
            //
            case 41: { action.   consumeGlobalQualifiedId();             break;
            }  
  
            //
            // Rule 42:  nested_name_specifier ::= class_or_namespace_name :: nested_name_specifier_with_template
            //
            case 42: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 43:  nested_name_specifier ::= class_or_namespace_name ::
            //
            case 43: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 44:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template :: nested_name_specifier_with_template
            //
            case 44: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 45:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template ::
            //
            case 45: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 46:  class_or_namespace_name_with_template ::= template_opt class_or_namespace_name
            //
            case 46: { action.   consumeNameWithTemplateKeyword();             break;
            }  
  
            //
            // Rule 48:  nested_name_specifier_opt ::= $Empty
            //
            case 48: { action.   consumeNestedNameSpecifierEmpty();             break;
            }  
  
            //
            // Rule 51:  postfix_expression ::= postfix_expression [ expression ]
            //
            case 51: { action.   consumeExpressionArraySubscript();             break;
            }  
  
            //
            // Rule 52:  postfix_expression ::= postfix_expression ( expression_list_opt )
            //
            case 52: { action.   consumeExpressionFunctionCall();             break;
            }  
  
            //
            // Rule 53:  postfix_expression ::= simple_type_specifier ( expression_list_opt )
            //
            case 53: { action.   consumeExpressionSimpleTypeConstructor();            break;
            }  
  
            //
            // Rule 54:  postfix_expression ::= typename dcolon_opt nested_name_specifier <empty> identifier_name ( expression_list_opt )
            //
            case 54: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 55:  postfix_expression ::= typename dcolon_opt nested_name_specifier template_opt template_id_name ( expression_list_opt )
            //
            case 55: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 56:  postfix_expression ::= postfix_expression . qualified_or_unqualified_name
            //
            case 56: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 57:  postfix_expression ::= postfix_expression -> qualified_or_unqualified_name
            //
            case 57: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 58:  postfix_expression ::= postfix_expression . template qualified_or_unqualified_name
            //
            case 58: { action.   consumeExpressionFieldReference(false, true);             break;
            }  
  
            //
            // Rule 59:  postfix_expression ::= postfix_expression -> template qualified_or_unqualified_name
            //
            case 59: { action.   consumeExpressionFieldReference(true, true);             break;
            }  
  
            //
            // Rule 60:  postfix_expression ::= postfix_expression . pseudo_destructor_name
            //
            case 60: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 61:  postfix_expression ::= postfix_expression -> pseudo_destructor_name
            //
            case 61: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 62:  postfix_expression ::= postfix_expression ++
            //
            case 62: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixIncr);             break;
            }  
  
            //
            // Rule 63:  postfix_expression ::= postfix_expression --
            //
            case 63: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixDecr);             break;
            }  
  
            //
            // Rule 64:  postfix_expression ::= dynamic_cast < type_id > ( expression )
            //
            case 64: { action.   consumeExpressionCast(ICPPASTCastExpression.op_dynamic_cast);             break;
            }  
  
            //
            // Rule 65:  postfix_expression ::= static_cast < type_id > ( expression )
            //
            case 65: { action.   consumeExpressionCast(ICPPASTCastExpression.op_static_cast);             break;
            }  
  
            //
            // Rule 66:  postfix_expression ::= reinterpret_cast < type_id > ( expression )
            //
            case 66: { action.   consumeExpressionCast(ICPPASTCastExpression.op_reinterpret_cast);             break;
            }  
  
            //
            // Rule 67:  postfix_expression ::= const_cast < type_id > ( expression )
            //
            case 67: { action.   consumeExpressionCast(ICPPASTCastExpression.op_const_cast);             break;
            }  
  
            //
            // Rule 68:  postfix_expression ::= typeid ( expression )
            //
            case 68: { action.   consumeExpressionUnaryOperator(ICPPASTUnaryExpression.op_typeid);             break;
            }  
  
            //
            // Rule 69:  postfix_expression ::= typeid ( type_id )
            //
            case 69: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_typeid);            break;
            }  
  
            //
            // Rule 70:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt type_name :: destructor_type_name
            //
            case 70: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 71:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier template template_id_name :: destructor_type_name
            //
            case 71: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 72:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt destructor_type_name
            //
            case 72: { action.   consumePsudoDestructorName(false);             break;
            }  
  
            //
            // Rule 73:  destructor_type_name ::= ~ identifier_token
            //
            case 73: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 74:  destructor_type_name ::= ~ template_id_name
            //
            case 74: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 78:  unary_expression ::= ++ cast_expression
            //
            case 78: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixIncr);             break;
            }  
  
            //
            // Rule 79:  unary_expression ::= -- cast_expression
            //
            case 79: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixDecr);             break;
            }  
  
            //
            // Rule 80:  unary_expression ::= & cast_expression
            //
            case 80: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_amper);             break;
            }  
  
            //
            // Rule 81:  unary_expression ::= * cast_expression
            //
            case 81: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_star);             break;
            }  
  
            //
            // Rule 82:  unary_expression ::= + cast_expression
            //
            case 82: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 83:  unary_expression ::= - cast_expression
            //
            case 83: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 84:  unary_expression ::= ~ cast_expression
            //
            case 84: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_tilde);             break;
            }  
  
            //
            // Rule 85:  unary_expression ::= ! cast_expression
            //
            case 85: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_not);             break;
            }  
  
            //
            // Rule 86:  unary_expression ::= sizeof unary_expression
            //
            case 86: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_sizeof);             break;
            }  
  
            //
            // Rule 87:  unary_expression ::= sizeof ( type_id )
            //
            case 87: { action.   consumeExpressionTypeId(ICPPASTTypeIdExpression.op_sizeof);            break;
            }  
  
            //
            // Rule 88:  new_expression ::= dcolon_opt new new_placement_opt new_type_id <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 88: { action.   consumeExpressionNew(true);             break;
            }  
  
            //
            // Rule 89:  new_expression ::= dcolon_opt new new_placement_opt ( type_id ) <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 89: { action.   consumeExpressionNew(false);             break;
            }  
  
            //
            // Rule 91:  new_placement_opt ::= $Empty
            //
            case 91: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 92:  new_type_id ::= type_specifier_seq
            //
            case 92: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 93:  new_type_id ::= type_specifier_seq new_declarator
            //
            case 93: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 94:  new_declarator ::= <openscope-ast> new_pointer_operators
            //
            case 94: { action.   consumeNewDeclarator();            break;
            }  
  
            //
            // Rule 101:  new_initializer ::= ( expression_list_opt )
            //
            case 101: { action.   consumeNewInitializer();             break;
            }  
  
            //
            // Rule 103:  new_initializer_opt ::= $Empty
            //
            case 103: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 104:  delete_expression ::= dcolon_opt delete cast_expression
            //
            case 104: { action.   consumeExpressionDelete(false);             break;
            }  
  
            //
            // Rule 105:  delete_expression ::= dcolon_opt delete [ ] cast_expression
            //
            case 105: { action.   consumeExpressionDelete(true);             break;
            }  
  
            //
            // Rule 107:  cast_expression ::= ( type_id ) cast_expression
            //
            case 107: { action.   consumeExpressionCast(ICPPASTCastExpression.op_cast);             break;
            }  
  
            //
            // Rule 109:  pm_expression ::= pm_expression .* cast_expression
            //
            case 109: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmdot);             break;
            }  
  
            //
            // Rule 110:  pm_expression ::= pm_expression ->* cast_expression
            //
            case 110: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmarrow);             break;
            }  
  
            //
            // Rule 112:  multiplicative_expression ::= multiplicative_expression * pm_expression
            //
            case 112: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiply);             break;
            }  
  
            //
            // Rule 113:  multiplicative_expression ::= multiplicative_expression / pm_expression
            //
            case 113: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divide);             break;
            }  
  
            //
            // Rule 114:  multiplicative_expression ::= multiplicative_expression % pm_expression
            //
            case 114: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_modulo);             break;
            }  
  
            //
            // Rule 116:  additive_expression ::= additive_expression + multiplicative_expression
            //
            case 116: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 117:  additive_expression ::= additive_expression - multiplicative_expression
            //
            case 117: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 119:  shift_expression ::= shift_expression << additive_expression
            //
            case 119: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeft);             break;
            }  
  
            //
            // Rule 120:  shift_expression ::= shift_expression >> additive_expression
            //
            case 120: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRight);             break;
            }  
  
            //
            // Rule 122:  relational_expression ::= relational_expression < shift_expression
            //
            case 122: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessThan);             break;
            }  
  
            //
            // Rule 123:  relational_expression ::= relational_expression > shift_expression
            //
            case 123: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterThan);             break;
            }  
  
            //
            // Rule 124:  relational_expression ::= relational_expression <= shift_expression
            //
            case 124: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessEqual);             break;
            }  
  
            //
            // Rule 125:  relational_expression ::= relational_expression >= shift_expression
            //
            case 125: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterEqual);             break;
            }  
  
            //
            // Rule 127:  equality_expression ::= equality_expression == relational_expression
            //
            case 127: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_equals);             break;
            }  
  
            //
            // Rule 128:  equality_expression ::= equality_expression != relational_expression
            //
            case 128: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_notequals);             break;
            }  
  
            //
            // Rule 130:  and_expression ::= and_expression & equality_expression
            //
            case 130: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAnd);             break;
            }  
  
            //
            // Rule 132:  exclusive_or_expression ::= exclusive_or_expression ^ and_expression
            //
            case 132: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXor);             break;
            }  
  
            //
            // Rule 134:  inclusive_or_expression ::= inclusive_or_expression | exclusive_or_expression
            //
            case 134: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOr);             break;
            }  
  
            //
            // Rule 136:  logical_and_expression ::= logical_and_expression && inclusive_or_expression
            //
            case 136: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalAnd);             break;
            }  
  
            //
            // Rule 138:  logical_or_expression ::= logical_or_expression || logical_and_expression
            //
            case 138: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalOr);             break;
            }  
  
            //
            // Rule 140:  conditional_expression ::= logical_or_expression ? expression : assignment_expression
            //
            case 140: { action.   consumeExpressionConditional();             break;
            }  
  
            //
            // Rule 141:  throw_expression ::= throw
            //
            case 141: { action.   consumeExpressionThrow(false);             break;
            }  
  
            //
            // Rule 142:  throw_expression ::= throw assignment_expression
            //
            case 142: { action.   consumeExpressionThrow(true);             break;
            }  
  
            //
            // Rule 145:  assignment_expression ::= logical_or_expression = assignment_expression
            //
            case 145: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 146:  assignment_expression ::= logical_or_expression *= assignment_expression
            //
            case 146: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiplyAssign);             break;
            }  
  
            //
            // Rule 147:  assignment_expression ::= logical_or_expression /= assignment_expression
            //
            case 147: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divideAssign);             break;
            }  
  
            //
            // Rule 148:  assignment_expression ::= logical_or_expression %= assignment_expression
            //
            case 148: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_moduloAssign);             break;
            }  
  
            //
            // Rule 149:  assignment_expression ::= logical_or_expression += assignment_expression
            //
            case 149: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plusAssign);             break;
            }  
  
            //
            // Rule 150:  assignment_expression ::= logical_or_expression -= assignment_expression
            //
            case 150: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minusAssign);             break;
            }  
  
            //
            // Rule 151:  assignment_expression ::= logical_or_expression >>= assignment_expression
            //
            case 151: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRightAssign);             break;
            }  
  
            //
            // Rule 152:  assignment_expression ::= logical_or_expression <<= assignment_expression
            //
            case 152: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeftAssign);             break;
            }  
  
            //
            // Rule 153:  assignment_expression ::= logical_or_expression &= assignment_expression
            //
            case 153: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAndAssign);             break;
            }  
  
            //
            // Rule 154:  assignment_expression ::= logical_or_expression ^= assignment_expression
            //
            case 154: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXorAssign);             break;
            }  
  
            //
            // Rule 155:  assignment_expression ::= logical_or_expression |= assignment_expression
            //
            case 155: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOrAssign);             break;
            }  
  
            //
            // Rule 157:  expression_list ::= <openscope-ast> expression_list_actual
            //
            case 157: { action.   consumeExpressionList();             break;
            }  
  
            //
            // Rule 161:  expression_list_opt ::= $Empty
            //
            case 161: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 163:  expression_opt ::= $Empty
            //
            case 163: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 166:  constant_expression_opt ::= $Empty
            //
            case 166: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 175:  statement ::= ERROR_TOKEN
            //
            case 175: { action.   consumeStatementProblem();             break;
            }  
  
            //
            // Rule 176:  labeled_statement ::= identifier : statement
            //
            case 176: { action.   consumeStatementLabeled();             break;
            }  
  
            //
            // Rule 177:  labeled_statement ::= case constant_expression : statement
            //
            case 177: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 178:  labeled_statement ::= default : statement
            //
            case 178: { action.   consumeStatementDefault();             break;
            }  
  
            //
            // Rule 179:  expression_statement ::= expression ;
            //
            case 179: { action.   consumeStatementExpression();             break;
            }  
  
            //
            // Rule 180:  expression_statement ::= ;
            //
            case 180: { action.   consumeStatementNull();             break;
            }  
  
            //
            // Rule 181:  compound_statement ::= { <openscope-ast> statement_seq }
            //
            case 181: { action.   consumeStatementCompoundStatement(true);             break;
            }  
  
            //
            // Rule 182:  compound_statement ::= { }
            //
            case 182: { action.   consumeStatementCompoundStatement(false);             break;
            }  
  
            //
            // Rule 185:  selection_statement ::= if ( condition ) statement
            //
            case 185: { action.   consumeStatementIf(false);             break;
            }  
  
            //
            // Rule 186:  selection_statement ::= if ( condition ) statement else statement
            //
            case 186: { action.   consumeStatementIf(true);             break;
            }  
  
            //
            // Rule 187:  selection_statement ::= switch ( condition ) statement
            //
            case 187: { action.   consumeStatementSwitch();             break;
            }  
  
            //
            // Rule 189:  condition ::= type_specifier_seq declarator = assignment_expression
            //
            case 189: { action.   consumeConditionDeclaration();             break;
            }  
  
            //
            // Rule 191:  condition_opt ::= $Empty
            //
            case 191: { action.   consumeEmpty();            break;
            }  
  
            //
            // Rule 192:  iteration_statement ::= while ( condition ) statement
            //
            case 192: { action.   consumeStatementWhileLoop();             break;
            }  
  
            //
            // Rule 193:  iteration_statement ::= do statement while ( expression ) ;
            //
            case 193: { action.   consumeStatementDoLoop();             break;
            }  
  
            //
            // Rule 194:  iteration_statement ::= for ( for_init_statement condition_opt ; expression_opt ) statement
            //
            case 194: { action.  consumeStatementForLoop();            break;
            }  
  
            //
            // Rule 196:  for_init_statement ::= simple_declaration_with_declspec
            //
            case 196: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 197:  jump_statement ::= break ;
            //
            case 197: { action.   consumeStatementBreak();             break;
            }  
  
            //
            // Rule 198:  jump_statement ::= continue ;
            //
            case 198: { action.   consumeStatementContinue();             break;
            }  
  
            //
            // Rule 199:  jump_statement ::= return expression ;
            //
            case 199: { action.   consumeStatementReturn(true);             break;
            }  
  
            //
            // Rule 200:  jump_statement ::= return ;
            //
            case 200: { action.   consumeStatementReturn(false);             break;
            }  
  
            //
            // Rule 201:  jump_statement ::= goto identifier_token ;
            //
            case 201: { action.   consumeStatementGoto();             break;
            }  
  
            //
            // Rule 202:  declaration_statement ::= block_declaration
            //
            case 202: { action.   consumeStatementDeclarationWithDisambiguation();             break;
            }  
  
            //
            // Rule 203:  declaration_statement ::= function_definition
            //
            case 203: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 211:  declaration ::= ERROR_TOKEN
            //
            case 211: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 221:  simple_declaration ::= declaration_specifiers_opt <openscope-ast> init_declarator_list_opt ;
            //
            case 221: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 222:  simple_declaration_with_declspec ::= declaration_specifiers <openscope-ast> init_declarator_list_opt ;
            //
            case 222: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 223:  declaration_specifiers ::= <openscope-ast> simple_declaration_specifiers
            //
            case 223: { action.   consumeDeclarationSpecifiersSimple();             break;
            }  
  
            //
            // Rule 224:  declaration_specifiers ::= <openscope-ast> class_declaration_specifiers
            //
            case 224: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 225:  declaration_specifiers ::= <openscope-ast> elaborated_declaration_specifiers
            //
            case 225: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 226:  declaration_specifiers ::= <openscope-ast> enum_declaration_specifiers
            //
            case 226: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 227:  declaration_specifiers ::= <openscope-ast> type_name_declaration_specifiers
            //
            case 227: { action.   consumeDeclarationSpecifiersTypeName();             break;
            }  
  
            //
            // Rule 229:  declaration_specifiers_opt ::= $Empty
            //
            case 229: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 233:  no_type_declaration_specifier ::= friend
            //
            case 233: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 234:  no_type_declaration_specifier ::= typedef
            //
            case 234: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 254:  storage_class_specifier ::= auto
            //
            case 254: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 255:  storage_class_specifier ::= register
            //
            case 255: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 256:  storage_class_specifier ::= static
            //
            case 256: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 257:  storage_class_specifier ::= extern
            //
            case 257: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 258:  storage_class_specifier ::= mutable
            //
            case 258: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 259:  function_specifier ::= inline
            //
            case 259: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 260:  function_specifier ::= virtual
            //
            case 260: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 261:  function_specifier ::= explicit
            //
            case 261: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 262:  simple_type_specifier ::= char
            //
            case 262: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 263:  simple_type_specifier ::= wchar_t
            //
            case 263: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 264:  simple_type_specifier ::= bool
            //
            case 264: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 265:  simple_type_specifier ::= short
            //
            case 265: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 266:  simple_type_specifier ::= int
            //
            case 266: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 267:  simple_type_specifier ::= long
            //
            case 267: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 268:  simple_type_specifier ::= signed
            //
            case 268: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 269:  simple_type_specifier ::= unsigned
            //
            case 269: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 270:  simple_type_specifier ::= float
            //
            case 270: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 271:  simple_type_specifier ::= double
            //
            case 271: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 272:  simple_type_specifier ::= void
            //
            case 272: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 275:  type_name_specifier ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 275: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 276:  type_name_specifier ::= dcolon_opt nested_name_specifier template template_id_name
            //
            case 276: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 277:  type_name_specifier ::= typename dcolon_opt nested_name_specifier identifier_name
            //
            case 277: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 278:  type_name_specifier ::= typename dcolon_opt nested_name_specifier template_opt template_id_name
            //
            case 278: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 280:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 280: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 281:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt template_opt template_id_name
            //
            case 281: { action.   consumeTypeSpecifierElaborated(true);              break;
            }  
  
            //
            // Rule 282:  elaborated_type_specifier ::= enum elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 282: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 284:  enum_specifier ::= enum enum_specifier_hook { <openscope-ast> enumerator_list_opt }
            //
            case 284: { action.   consumeTypeSpecifierEnumeration(false);            break;
            }  
  
            //
            // Rule 285:  enum_specifier ::= enum enum_specifier_hook identifier_token { <openscope-ast> enumerator_list_opt }
            //
            case 285: { action.   consumeTypeSpecifierEnumeration(true);            break;
            }  
  
            //
            // Rule 291:  enumerator_definition ::= identifier_token
            //
            case 291: { action.   consumeEnumerator(false);            break;
            }  
  
            //
            // Rule 292:  enumerator_definition ::= identifier_token = constant_expression
            //
            case 292: { action.   consumeEnumerator(true);            break;
            }  
  
            //
            // Rule 294:  namespace_definition ::= namespace namespace_name namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 294: { action.   consumeNamespaceDefinition(true);             break;
            }  
  
            //
            // Rule 295:  namespace_definition ::= namespace namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 295: { action.   consumeNamespaceDefinition(false);             break;
            }  
  
            //
            // Rule 297:  namespace_alias_definition ::= namespace identifier_token = dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 297: { action.   consumeNamespaceAliasDefinition();            break;
            }  
  
            //
            // Rule 298:  using_declaration ::= using typename_opt dcolon_opt nested_name_specifier_opt unqualified_id_name ;
            //
            case 298: { action.   consumeUsingDeclaration();             break;
            }  
  
            //
            // Rule 299:  typename_opt ::= typename
            //
            case 299: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 300:  typename_opt ::= $Empty
            //
            case 300: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 301:  using_directive ::= using namespace dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 301: { action.   consumeUsingDirective();             break;
            }  
  
            //
            // Rule 302:  asm_definition ::= asm ( stringlit ) ;
            //
            case 302: { action.   consumeDeclarationASM();            break;
            }  
  
            //
            // Rule 303:  linkage_specification ::= extern stringlit { <openscope-ast> declaration_seq_opt }
            //
            case 303: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 304:  linkage_specification ::= extern stringlit <openscope-ast> declaration
            //
            case 304: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 309:  init_declarator_complete ::= init_declarator
            //
            case 309: { action.   consumeInitDeclaratorComplete();             break;
            }  
  
            //
            // Rule 311:  init_declarator ::= complete_declarator initializer
            //
            case 311: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 314:  declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 314: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 316:  function_declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 316: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 320:  basic_direct_declarator ::= declarator_id_name
            //
            case 320: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 321:  basic_direct_declarator ::= ( declarator )
            //
            case 321: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 322:  function_direct_declarator ::= basic_direct_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 322: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 323:  array_direct_declarator ::= array_direct_declarator array_modifier
            //
            case 323: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 324:  array_direct_declarator ::= basic_direct_declarator array_modifier
            //
            case 324: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 325:  array_modifier ::= [ constant_expression ]
            //
            case 325: { action.   consumeDirectDeclaratorArrayModifier(true);             break;
            }  
  
            //
            // Rule 326:  array_modifier ::= [ ]
            //
            case 326: { action.   consumeDirectDeclaratorArrayModifier(false);             break;
            }  
  
            //
            // Rule 327:  ptr_operator ::= pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 327: { action.   consumePointer();             break;
            }  
  
            //
            // Rule 328:  ptr_operator ::= pointer_hook & pointer_hook
            //
            case 328: { action.   consumeReferenceOperator();             break;
            }  
  
            //
            // Rule 329:  ptr_operator ::= dcolon_opt nested_name_specifier pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 329: { action.   consumePointerToMember();             break;
            }  
  
            //
            // Rule 336:  cv_qualifier ::= const
            //
            case 336: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 337:  cv_qualifier ::= volatile
            //
            case 337: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 339:  declarator_id_name ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 339: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 340:  type_id ::= type_specifier_seq
            //
            case 340: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 341:  type_id ::= type_specifier_seq abstract_declarator
            //
            case 341: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 344:  abstract_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 344: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 345:  abstract_declarator ::= <openscope-ast> ptr_operator_seq direct_abstract_declarator
            //
            case 345: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 349:  basic_direct_abstract_declarator ::= ( abstract_declarator )
            //
            case 349: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 350:  basic_direct_abstract_declarator ::= ( )
            //
            case 350: { action.   consumeAbstractDeclaratorEmpty();             break;
            }  
  
            //
            // Rule 351:  array_direct_abstract_declarator ::= array_modifier
            //
            case 351: { action.   consumeDirectDeclaratorArrayDeclarator(false);             break;
            }  
  
            //
            // Rule 352:  array_direct_abstract_declarator ::= array_direct_abstract_declarator array_modifier
            //
            case 352: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 353:  array_direct_abstract_declarator ::= basic_direct_abstract_declarator array_modifier
            //
            case 353: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 354:  function_direct_abstract_declarator ::= basic_direct_abstract_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 354: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 355:  function_direct_abstract_declarator ::= ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 355: { action.   consumeDirectDeclaratorFunctionDeclarator(false);             break;
            }  
  
            //
            // Rule 356:  parameter_declaration_clause ::= parameter_declaration_list_opt ...
            //
            case 356: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 357:  parameter_declaration_clause ::= parameter_declaration_list_opt
            //
            case 357: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 358:  parameter_declaration_clause ::= parameter_declaration_list , ...
            //
            case 358: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 364:  abstract_declarator_opt ::= $Empty
            //
            case 364: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 365:  parameter_declaration ::= declaration_specifiers parameter_init_declarator
            //
            case 365: { action.   consumeParameterDeclaration();             break;
            }  
  
            //
            // Rule 366:  parameter_declaration ::= declaration_specifiers
            //
            case 366: { action.   consumeParameterDeclarationWithoutDeclarator();             break;
            }  
  
            //
            // Rule 368:  parameter_init_declarator ::= declarator = parameter_initializer
            //
            case 368: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 370:  parameter_init_declarator ::= abstract_declarator = parameter_initializer
            //
            case 370: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 371:  parameter_init_declarator ::= = parameter_initializer
            //
            case 371: { action.   consumeDeclaratorWithInitializer(false);             break;
            }  
  
            //
            // Rule 372:  parameter_initializer ::= assignment_expression
            //
            case 372: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 373:  function_definition ::= declaration_specifiers_opt function_declarator <openscope-ast> ctor_initializer_list_opt function_body
            //
            case 373: { action.   consumeFunctionDefinition(false);             break;
            }  
  
            //
            // Rule 374:  function_definition ::= declaration_specifiers_opt function_declarator try <openscope-ast> ctor_initializer_list_opt function_body <openscope-ast> handler_seq
            //
            case 374: { action.   consumeFunctionDefinition(true);             break;
            }  
  
            //
            // Rule 377:  initializer ::= ( expression_list )
            //
            case 377: { action.   consumeInitializerConstructor();             break;
            }  
  
            //
            // Rule 378:  initializer_clause ::= assignment_expression
            //
            case 378: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 380:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq , } end_initializer_list
            //
            case 380: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 381:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq } end_initializer_list
            //
            case 381: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 382:  initializer_list ::= { <openscope-ast> }
            //
            case 382: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 383:  start_initializer_list ::= $Empty
            //
            case 383: { action.   initializerListStart();            break;
            }  
  
            //
            // Rule 384:  end_initializer_list ::= $Empty
            //
            case 384: { action.   initializerListEnd();            break;
            }  
  
            //
            // Rule 389:  class_specifier ::= class_head { <openscope-ast> member_declaration_list_opt }
            //
            case 389: { action.   consumeClassSpecifier();             break;
            }  
  
            //
            // Rule 390:  class_head ::= class_keyword composite_specifier_hook identifier_name_opt class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 390: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 391:  class_head ::= class_keyword composite_specifier_hook template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 391: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 392:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier identifier_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 392: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 393:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 393: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 397:  identifier_name_opt ::= $Empty
            //
            case 397: { action.   consumeEmpty();             break;
            } 
  
            //
            // Rule 401:  visibility_label ::= access_specifier_keyword :
            //
            case 401: { action.   consumeVisibilityLabel();             break;
            }  
  
            //
            // Rule 402:  member_declaration ::= declaration_specifiers_opt <openscope-ast> member_declarator_list ;
            //
            case 402: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 403:  member_declaration ::= declaration_specifiers_opt ;
            //
            case 403: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 406:  member_declaration ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name ;
            //
            case 406: { action.   consumeMemberDeclarationQualifiedId();             break;
            }  
  
            //
            // Rule 412:  member_declaration ::= ERROR_TOKEN
            //
            case 412: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 421:  member_declarator ::= declarator constant_initializer
            //
            case 421: { action.   consumeMemberDeclaratorWithInitializer();             break;
            }  
  
            //
            // Rule 422:  member_declarator ::= bit_field_declarator : constant_expression
            //
            case 422: { action.   consumeBitField(true);             break;
            }  
  
            //
            // Rule 423:  member_declarator ::= : constant_expression
            //
            case 423: { action.   consumeBitField(false);             break;
            }  
  
            //
            // Rule 424:  bit_field_declarator ::= identifier_name
            //
            case 424: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 425:  constant_initializer ::= = constant_expression
            //
            case 425: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 431:  base_specifier ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 431: { action.   consumeBaseSpecifier(false, false);             break;
            }  
  
            //
            // Rule 432:  base_specifier ::= virtual access_specifier_keyword_opt dcolon_opt nested_name_specifier_opt class_name
            //
            case 432: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 433:  base_specifier ::= access_specifier_keyword virtual dcolon_opt nested_name_specifier_opt class_name
            //
            case 433: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 434:  base_specifier ::= access_specifier_keyword dcolon_opt nested_name_specifier_opt class_name
            //
            case 434: { action.   consumeBaseSpecifier(true, false);             break;
            }  
  
            //
            // Rule 435:  access_specifier_keyword ::= private
            //
            case 435: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 436:  access_specifier_keyword ::= protected
            //
            case 436: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 437:  access_specifier_keyword ::= public
            //
            case 437: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 439:  access_specifier_keyword_opt ::= $Empty
            //
            case 439: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 441:  conversion_function_id_name ::= conversion_function_id < <openscope-ast> template_argument_list_opt >
            //
            case 441: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 442:  conversion_function_id ::= operator conversion_type_id
            //
            case 442: { action.   consumeConversionName();            break;
            }  
  
            //
            // Rule 443:  conversion_type_id ::= type_specifier_seq conversion_declarator
            //
            case 443: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 444:  conversion_type_id ::= type_specifier_seq
            //
            case 444: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 445:  conversion_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 445: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 451:  mem_initializer ::= mem_initializer_name ( expression_list_opt )
            //
            case 451: { action.   consumeConstructorChainInitializer();             break;
            }  
  
            //
            // Rule 452:  mem_initializer_name ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 452: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 455:  operator_function_id_name ::= operator_id_name < <openscope-ast> template_argument_list_opt >
            //
            case 455: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 456:  operator_id_name ::= operator overloadable_operator
            //
            case 456: { action.   consumeOperatorName();             break;
            }  
  
            //
            // Rule 499:  template_declaration ::= export_opt template < <openscope-ast> template_parameter_list > declaration
            //
            case 499: { action.   consumeTemplateDeclaration();             break;
            }  
  
            //
            // Rule 500:  export_opt ::= export
            //
            case 500: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 501:  export_opt ::= $Empty
            //
            case 501: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 505:  template_parameter ::= parameter_declaration
            //
            case 505: { action.   consumeTemplateParamterDeclaration();             break;
            }  
  
            //
            // Rule 506:  type_parameter ::= class identifier_name_opt
            //
            case 506: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 507:  type_parameter ::= class identifier_name_opt = type_id
            //
            case 507: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 508:  type_parameter ::= typename identifier_name_opt
            //
            case 508: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 509:  type_parameter ::= typename identifier_name_opt = type_id
            //
            case 509: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 510:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt
            //
            case 510: { action.   consumeTemplatedTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 511:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt = id_expression
            //
            case 511: { action.   consumeTemplatedTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 512:  template_id_name ::= identifier_name < <openscope-ast> template_argument_list_opt >
            //
            case 512: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 517:  template_argument ::= assignment_expression
            //
            case 517: { action.   consumeTemplateArgumentExpression();             break;
            }  
  
            //
            // Rule 518:  template_argument ::= type_id
            //
            case 518: { action.   consumeTemplateArgumentTypeId();             break;
            }  
  
            //
            // Rule 519:  explicit_instantiation ::= template declaration
            //
            case 519: { action.   consumeTemplateExplicitInstantiation();             break;
            }  
  
            //
            // Rule 520:  explicit_specialization ::= template < > declaration
            //
            case 520: { action.   consumeTemplateExplicitSpecialization();             break;
            }  
  
            //
            // Rule 521:  try_block ::= try compound_statement <openscope-ast> handler_seq
            //
            case 521: { action.   consumeStatementTryBlock();             break;
            }  
  
            //
            // Rule 524:  handler ::= catch ( exception_declaration ) compound_statement
            //
            case 524: { action.   consumeStatementCatchHandler(false);             break;
            }  
  
            //
            // Rule 525:  handler ::= catch ( ... ) compound_statement
            //
            case 525: { action.   consumeStatementCatchHandler(true);             break;
            }  
  
            //
            // Rule 526:  exception_declaration ::= type_specifier_seq <openscope-ast> declarator
            //
            case 526: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 527:  exception_declaration ::= type_specifier_seq <openscope-ast> abstract_declarator
            //
            case 527: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 528:  exception_declaration ::= type_specifier_seq
            //
            case 528: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 530:  exception_specification ::= throw ( )
            //
            case 530: { action.   consumePlaceHolder();             break;
            }  

    
            default:
                break;
        }
        return;
    }
}

