.TH "Ecamegapedal" "1" "18\&.04\&.2004" "" "Multimedia software" 
.PP 
.SH "NAME" 
ecamegapedal \- real-time effect processor
.PP 
.SH "SYNOPSIS" 
\fBecamegapedal\fP [options] [<input> <output>]
.PP 
.SH "DESCRIPTION" 
.PP 
Ecamegapedal is a real-time effect processor software with
a graphical user interface for controlling the effect 
parameters\&. It is meant to be used as a virtual guitar-fx 
or studio effect box\&. In addition to real-time operation, 
Ecamegapedal also supports reading from and writing to audio 
files\&. All audio object and effect plugin types provided by the 
Ecasound libraries are supported\&. This includes ALSA, JACK, 
OSS, aRts, over 20 file formats, over 30 effect types, LADSPA 
plugins and multi-operator effect presets\&. Ecamegapedal\'s 
implementation is based on Ecasound and Qt libraries\&.
.PP 
.SH "INPUT/OUTPUT SYNTAX" 
.PP 
First argument, \fI<input>\fP, sets the device or file, from which 
Ecamegapedal will read audio data\&. The syntax is identical 
to the one used by Ecasound (see ecasound(1))\&. Some examples:
.PP 
.IP "foo\&.wav" 
Read from RIFF WAVE audio file \'foo\&.wav\'\&.
.IP 
.IP "alsa,default" 
Record from ALSA soundcard \'default\'\&.
.IP 
.IP "/dev/dsp" 
Record from OSS soundcard \'/dev/dsp\'\&.
.IP 
.IP "jack" 
Connect to a JACK server and register a JACK input port for 
Ecamegapedal\&.
.IP 
.IP "foo\&.mp3" 
Read from MP3 audio file \'foo\&.mp3\'\&.
.IP 
.IP "\&.\&.\&." 
And so on, see ecasound(1) and the online documentation 
at http://www\&.eca\&.cx/ecasound 
for more info about object types\&.
.IP 
.PP 
The second argument, \fI<output>\fP, sets the output device or file 
to which Ecamegapedal should write audio data\&. Syntax is the 
same as for <input>\&.
.PP 
\fINote!\fP These instructions also apply when modifying the input
and output objects using from the user-interface\&.
.PP 
.SH "OPTIONS" 
.PP 
.IP "--help" 
Show a small usage help screen\&.
.PP 
.IP "--version" 
Print the version info\&.
.PP 
.SH "USER INTERFACE" 
.PP 
One design goal has been that Ecamegapedal can be used without 
a mouse\&. In practise this means that shortcuts work everywhere,
and all pushbuttons and other controls have a textual 
description\&. 
.PP 
Ecamegapedal makes use of both accelerator keys and shortcut keys\&.
These are defined as follows:
.PP 
An accelerator key is an alphanumeric key that can be pressed together
with a Meta-key, usually Alt, to select an item which is visible on
the screen\&. If an item has an accelerator key, this is shown by
underlining that character\&.
.PP 
A shortcut key is a combination of Ctrl and another key\&. When pressed
together they start an action from any of the menus\&. In the menu, the
shortcut is printed after each item so that the user can learn about
the shortcuts by using the application\&.
.PP 
In Ecamegapedal, transport controls (start, stop) play can 
be accessed using shortcuts (ie\&. ctrl-t, ctrl-s, \&.\&. instead of 
alt-t, alt-s)\&.
.PP 
.IP 
.SH "FILES" 
.IP 
\fI~/\&.ecasound/ecasoundrc\fP
User-specific setting that control ecasound operation\&. 
These settings also affect ecamegapedal sessions\&. See
ecasoundrc(5) for more information\&.
.IP 
.SH "SEE ALSO" 
.IP 
ecasound (1), ecasoundrc (5)
.IP 
.SH "AUTHOR" 
.IP 
Kai Vehmanen, <kai\&.vehmanen |at| wakkanet\&.fi>
