/*1:*/
#line 6 "./journal.cweb"

#include "journal.h"
#include "kord_exception.h"

#if !defined(__MINGW32__) && !defined(_MSC_VER)
# include <sys/resource.h> 
# include <sys/utsname.h> 
#endif
#include <cstdlib> 
#ifndef _MSC_VER
# include <unistd.h> 
#endif
#include <ctime> 

SystemResources _sysres;
#if defined(__MINGW32__) || defined(_MSC_VER)
/*16:*/
#line 302 "./journal.cweb"

#include <Windows.h> 

#define _SC_PAGESIZE 1
#define _SC_PHYS_PAGES 2
#define _SC_AVPHYS_PAGES 3
#define _SC_NPROCESSORS_ONLN 4

long sysconf(int name)
{
switch(name){
case _SC_PAGESIZE:
return 1024;
case _SC_PHYS_PAGES:
{
MEMORYSTATUS memstat;
GlobalMemoryStatus(&memstat);
return memstat.dwTotalPhys/1024;
}
case _SC_AVPHYS_PAGES:
{
MEMORYSTATUS memstat;
GlobalMemoryStatus(&memstat);
return memstat.dwAvailPhys/1024;
}
case _SC_NPROCESSORS_ONLN:
return-1;
default:
KORD_RAISE("Not implemented in Win32 sysconf.");
return-1;
}
}

/*:16*/
#line 22 "./journal.cweb"
;
#endif

#if defined(__APPLE__)
#define _SC_PHYS_PAGES 2
#define _SC_AVPHYS_PAGES 3
#endif

#ifdef _MSC_VER

struct timezone
{
int tz_minuteswest;
int tz_dsttime;
};

int gettimeofday(struct timeval*tv,struct timezone*tz)
{
FILETIME ft;
unsigned __int64 tmpres= 0;
static int tzflag= 0;

if(NULL!=tv)
{
GetSystemTimeAsFileTime(&ft);

tmpres|= ft.dwHighDateTime;
tmpres<<= 32;
tmpres|= ft.dwLowDateTime;

tmpres/= 10;

tmpres-= 11644473600000000ULL;
tv->tv_sec= (long)(tmpres/1000000UL);
tv->tv_usec= (long)(tmpres%1000000UL);
}

if(NULL!=tz)
{
if(!tzflag)
{
_tzset();
tzflag++;
}
tz->tz_minuteswest= _timezone/60;
tz->tz_dsttime= _daylight;
}

return 0;
}
#endif

/*2:*/
#line 90 "./journal.cweb"

SystemResources::SystemResources()
{
gettimeofday(&start,NULL);
}


/*:2*/
#line 74 "./journal.cweb"
;
/*3:*/
#line 98 "./journal.cweb"

long int SystemResources::pageSize()
{
return sysconf(_SC_PAGESIZE);
}

/*:3*/
#line 75 "./journal.cweb"
;
/*4:*/
#line 105 "./journal.cweb"

long int SystemResources::physicalPages()
{
return sysconf(_SC_PHYS_PAGES);
}

/*:4*/
#line 76 "./journal.cweb"
;
/*5:*/
#line 112 "./journal.cweb"

long int SystemResources::onlineProcessors()
{
return sysconf(_SC_NPROCESSORS_ONLN);
}

/*:5*/
#line 77 "./journal.cweb"
;
/*6:*/
#line 119 "./journal.cweb"

long int SystemResources::availableMemory()
{
return pageSize()*sysconf(_SC_AVPHYS_PAGES);
}

/*:6*/
#line 78 "./journal.cweb"
;
/*7:*/
#line 128 "./journal.cweb"

void SystemResources::getRUS(double&load_avg,long int&pg_avail,
double&utime,double&stime,double&elapsed,
long int&idrss,long int&majflt)
{
struct timeval now;
gettimeofday(&now,NULL);
elapsed= now.tv_sec-start.tv_sec+(now.tv_usec-start.tv_usec)*1.0e-6;

#if !defined(__MINGW32__) && !defined(_MSC_VER)
struct rusage rus;
getrusage(RUSAGE_SELF,&rus);
utime= rus.ru_utime.tv_sec+rus.ru_utime.tv_usec*1.0e-6;
stime= rus.ru_stime.tv_sec+rus.ru_stime.tv_usec*1.0e-6;
idrss= rus.ru_idrss;
majflt= rus.ru_majflt;
#else
utime= -1.0;
stime= -1.0;
idrss= -1;
majflt= -1;
#endif

#if !defined(__MINGW32__) && !defined(_MSC_VER) && !defined(__CYGWIN32__)
getloadavg(&load_avg,1);
#else
load_avg= -1.0;
#endif

pg_avail= sysconf(_SC_AVPHYS_PAGES);
}

/*:7*/
#line 79 "./journal.cweb"
;
/*8:*/
#line 161 "./journal.cweb"

SystemResourcesFlash::SystemResourcesFlash()
{
_sysres.getRUS(load_avg,pg_avail,utime,stime,
elapsed,idrss,majflt);
}

/*:8*/
#line 80 "./journal.cweb"
;
/*9:*/
#line 169 "./journal.cweb"

void SystemResourcesFlash::diff(const SystemResourcesFlash&pre)
{
utime-= pre.utime;
stime-= pre.stime;
elapsed-= pre.elapsed;
idrss-= pre.idrss;
majflt-= pre.majflt;
}

/*:9*/
#line 81 "./journal.cweb"
;
/*10:*/
#line 180 "./journal.cweb"

JournalRecord&JournalRecord::operator<<(const IntSequence&s)
{
operator<<("[");
for(int i= 0;i<s.size();i++){
operator<<(s[i]);
if(i<s.size()-1)
operator<<(",");
}
operator<<("]");
return*this;
}

/*:10*/
#line 82 "./journal.cweb"
;
/*11:*/
#line 194 "./journal.cweb"

void JournalRecord::writePrefix(const SystemResourcesFlash&f)
{
for(int i= 0;i<MAXLEN;i++)
prefix[i]= ' ';
double mb= 1024*1024;
sprintf(prefix,"%07.6g",f.elapsed);
sprintf(prefix+7,":%c%05d",recChar,ord);
sprintf(prefix+14,":%1.1f",f.load_avg);
sprintf(prefix+18,":%05.4g",f.pg_avail*_sysres.pageSize()/mb);
sprintf(prefix+24,"%s",":      : ");
for(int i= 0;i<2*journal.getDepth();i++)
prefix[i+33]= ' ';
prefix[2*journal.getDepth()+33]= '\0';
}

/*:11*/
#line 83 "./journal.cweb"
;
/*12:*/
#line 211 "./journal.cweb"

void JournalRecordPair::writePrefixForEnd(const SystemResourcesFlash&f)
{
for(int i= 0;i<MAXLEN;i++)
prefix_end[i]= ' ';
double mb= 1024*1024;
SystemResourcesFlash difnow;
difnow.diff(f);
sprintf(prefix_end,"%07.6g",f.elapsed+difnow.elapsed);
sprintf(prefix_end+7,":E%05d",ord);
sprintf(prefix_end+14,":%1.1f",difnow.load_avg);
sprintf(prefix_end+18,":%05.4g",difnow.pg_avail*_sysres.pageSize()/mb);
sprintf(prefix_end+24,":%06.5g",difnow.majflt*_sysres.pageSize()/mb);
sprintf(prefix_end+31,"%s",": ");
for(int i= 0;i<2*journal.getDepth();i++)
prefix_end[i+33]= ' ';
prefix_end[2*journal.getDepth()+33]= '\0';
}

/*:12*/
#line 84 "./journal.cweb"
;
/*13:*/
#line 231 "./journal.cweb"

JournalRecordPair::~JournalRecordPair()
{
journal.decrementDepth();
writePrefixForEnd(flash);
journal<<prefix_end;
journal<<mes;
journal<<endl;
journal.flush();
}

/*:13*/
#line 85 "./journal.cweb"
;
/*14:*/
#line 243 "./journal.cweb"

JournalRecord&endrec(JournalRecord&rec)
{
rec.journal<<rec.prefix;
rec.journal<<rec.mes;
rec.journal<<endl;
rec.journal.flush();
rec.journal.incrementOrd();
return rec;
}

/*:14*/
#line 86 "./journal.cweb"
;
/*15:*/
#line 255 "./journal.cweb"

void Journal::printHeader()
{
(*this)<<"This is Dynare++, Copyright (C) 2004,2005 Michel Juillard, Ondra Kamenik\n";
(*this)<<"Dynare++ comes with ABSOLUTELY NO WARRANTY and is distributed under\n";
(*this)<<"General Public License, see http://www.gnu.org/license/gpl.html\n";
(*this)<<"\n\n";

#if !defined(__MINGW32__) && !defined(_MSC_VER)
utsname info;
uname(&info);
(*this)<<"System info: ";
(*this)<<info.sysname<<" "<<info.release<<" "<<info.version<<" ";
(*this)<<info.machine<<", processors online: "<<_sysres.onlineProcessors();

(*this)<<"\n\nStart time: ";
char ts[100];
time_t curtime= time(NULL);
tm loctime;
localtime_r(&curtime,&loctime);
asctime_r(&loctime,ts);
(*this)<<ts<<"\n";
#else
(*this)<<"System info: (not implemented for MINGW)\n";
(*this)<<"Start time:  (not implemented for MINGW)\n\n";
#endif

(*this)<<"  ------ elapsed time (seconds)                     \n";
(*this)<<"  |       ------ record unique identifier           \n";
(*this)<<"  |       |     ------ load average                 \n";
(*this)<<"  |       |     |    ------ available memory (MB)   \n";
(*this)<<"  |       |     |    |     ------  major faults (MB)\n";
(*this)<<"  |       |     |    |     |                        \n";
(*this)<<"  V       V     V    V     V                        \n";
(*this)<<"\n";
}


/*:15*/
#line 87 "./journal.cweb"
;

/*:1*/
