/*  dvdisaster: Additional error correction for optical media.
 *  Copyright (C) 2004-2011 Carsten Gnoerlich.
 *  Project home page: http://www.dvdisaster.com
 *  Email: carsten@dvdisaster.com  -or-  cgnoerlich@fsfe.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 *  or direct your browser at http://www.gnu.org.
 */

#include "dvdisaster.h"

/***
 *** A simple bitmap structure
 ***/

/*
 * Allocate the bitmap
 */

Bitmap* CreateBitmap0(int size)
{  Bitmap *bm = g_malloc(sizeof(Bitmap));

   bm->size   = size;
   bm->words  = (size>>5)+1;
   bm->bitmap = g_malloc0(bm->words*sizeof(guint32));

   return bm;
}

/* 
 * Free it
 */

void FreeBitmap(Bitmap *bm)
{  if(bm->bitmap)
     g_free(bm->bitmap);

   g_free(bm);
}

/*
 * Count the '1' bits in the bitmap 
 */

int CountBits(Bitmap *bm)
{ int i;
  int sum = 0;

  for(i=0; i<bm->size; i++)
    if(GetBit(bm, i))
      sum++;

  return sum;
}
