/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*-
 *  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  Copyright (C) 2008 Sun Microsystems
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DRIZZLED_FUNCTION_STR_USER_H
#define DRIZZLED_FUNCTION_STR_USER_H

#include <drizzled/function/str/strfunc.h>
#include "drizzled/global_charset_info.h"

namespace drizzled
{

class Item_func_user :public Item_str_func
{
protected:
  bool init (const char *user, const char *host);

public:
  Item_func_user()
  {
    str_value.set("", 0, system_charset_info);
  }
  String *val_str(String *)
  {
    assert(fixed == 1);
    return (null_value ? 0 : &str_value);
  }
  bool fix_fields(Session *session, Item **ref);
  void fix_length_and_dec()
  {
    max_length= (USERNAME_CHAR_LENGTH + HOSTNAME_LENGTH + 1) *
                system_charset_info->mbmaxlen;
  }
  const char *func_name() const { return "user"; }
  const char *fully_qualified_func_name() const { return "user()"; }
  int save_in_field(Field *field,
                    bool )
  {
    return save_str_value_in_field(field, &str_value);
  }
};

class Item_func_current_user :public Item_func_user
{
  Name_resolution_context *context;

public:
  Item_func_current_user(Name_resolution_context *context_arg)
    : context(context_arg) {}
  bool fix_fields(Session *session, Item **ref);
  const char *func_name() const { return "current_user"; }
  const char *fully_qualified_func_name() const { return "current_user()"; }
};

} /* namespace drizzled */

#endif /* DRIZZLED_FUNCTION_STR_USER_H */
