/* You may find the license in the LICENSE file */

addEventListener('load', function() {
	removeEventListener('load', arguments.callee, true);

	function $() {
		if (arguments.length == 1) {
			return document.getElementById(arguments[0]);
		}
		let elements = [];
		for (let i = 0, e = arguments.length; i < e; ++i) {
			let id = arguments[i];
			let element = document.getElementById(id);
			if (element) {
				elements.push(element);
			}
			else {
				debug("requested a non-existing element: " + id);
			}
		}
		return elements;
	}	
	
	function revertUI() {
		['open'].forEach(
			function(e) {
				e = $(e);
				e.parentNode.collapsed = true;		
				e.disabled = true;
			}
		);
		$('normalBox').collapsed = false;
		var nodes = $('normalBox')
			.getElementsByTagName('separator');
		
		for (var i = 0; i < nodes.length; ++i) {
			nodes[i].collapsed = true;
		} 

		$('basicBox').collapsed = true;
		$('normalBox').collapsed = false;
		
		// take care of FlashGot... for now.
		// need to negotiate with the author (and possible other extension authors)
		try {
			gFlashGotDMDialog.init();
			$("flashgot-basic").collapsed = true;
		}
		catch (ex) {
			// no op
		}
		
		// Workaround for bug 371508
		try {
			window.sizeToContent();	
		}
		catch (ex) {
			DTA.Debug.log("sizeToContent Bug: 371508", ex);
			try {
				var btn = document.documentElement.getButton('accept');
				window.innerHeight = btn.boxObject.y + 10; 
			}
			catch (ex) {
				DTA.Debug.log("setting height failed", ex);
			}		
		}				
	}
	
	function download(turbo) {
		ddDirectory.save();
		DTA.saveSingleLink(window, turbo, url, referrer, "");
		let de = document.documentElement;
		try {
			de.removeAttribute('ondialogaccept');
		}
		catch (ex) {
			// no op
		}
		try {
			const NS_BINDING_ABORTED = 0x804b0002;
			dialog.mLauncher.cancel(NS_BINDING_ABORTED);
		}
		catch (ex) {}		
		de.cancelDialog();
	}

	let basicBox = $('basicBox');
	let normalBox = $('normalBox');
	const doRevert = basicBox && (!basicBox.collapsed || (normalBox && normalBox.collapsed));
	const doOverlay = DTA.Preferences.getExt("downloadWin", true);
	if (
		!doOverlay
		&& typeof(gFlashGotDMDialog) == 'undefined'
	) {
		// we do not actually overlay!
		return;
	}
	if (doRevert) {
		revertUI();
	}
	
	if (!doOverlay) {
		// we do not actually overlay!
		// but we revert to help FlashGot ;)
		return;
	}
	
	const normal = $('downthemall');
	const turbo = $('turbodta');
	const turboExec = $('turbodtaexec');
	const mode = $('mode');
	const remember = $("rememberChoice");
	const settingsChange = $("settingsChange");
	
	$('downthemallcontainer').collapsed = false;
	normal.disabled = false;
	
	let url = dialog.mLauncher.source;
	let referrer;
	try {
		referrer = dialog.mContext.QueryInterface(Components.interfaces.nsIWebNavigation).currentURI.spec;
	}
	catch(ex) {
		referrer = url.spec;
	}
	
	let ml = DTA.getLinkPrintMetalink(url);
	url = new DTA.URL(ml ? ml : url);

	const ddDirectory = $('tdtalist');
	let mask = DTA.getDropDownValue('renaming');
	if (!($("tdta").hidden = (DTA.getDropDownValue('directory') == '' || !mask))) {
		turbo.disabled = false;
		turboExec.disabled = false;
	}
	
	try {
		switch (DTA.Preferences.getExt('saveasmode', 0)) {
			case 1:
				mode.selectedItem = normal;
				break;
			case 2:
				mode.selectedItem = turbo.disabled ? normal : turbo;
				break;
		}
		if (DTA.Preferences.getExt('saveasmode', 0)) {
			remember.checked = true;
			remember.disabled = false;
		}
	}
	catch (ex) {
		// no op
	}

	mode.addEventListener(
		'select',
		function() {
			let selMode = mode.selectedItem;
			remember.checked = false;
			if (normal == selMode || turbo == selMode) {
				remember.disabled = false;
			}
		},
		false
	);
	ddDirectory.addEventListener('command', function() {
		mode.selectedItem = turbo;
	}, true);

	turboExec.addEventListener('command', function() {
		download(true);
	}, true);

	addEventListener('dialogaccept', function(evt) {
		let selMode = mode.selectedItem;
		if (selMode == normal || selMode == turbo) {
			if (remember.checked) {
				DTA.Preferences.setExt("saveasmode", selMode == normal ? 1 : 2);
			}
			else {
				DTA.Preferences.setExt("saveasmode", 0);
			}
			download(selMode == turbo);			
			evt.stopPropagation();
			evt.preventDefault();
			return;
		}
		DTA.Preferences.setExt("saveasmode", 0);
	}, false); // dialogaccept
	
}, true); // load

(function() {
	let _loader = {};
	Components.utils.import("resource://dta/_apiloader.jsm", _loader);
	_loader.inject(window);
})();