from re import compile, IGNORECASE

from dosage.helpers import BasicScraper


def keenSpot(comics):
    class KeenSpotScraper(BasicScraper):
        imageUrl = property(lambda self: self.baseUrl + 'd/%s.html')
        imageSearch = compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', IGNORECASE)
        prevSearch = compile(r'<a href="([^"]*?d/\d{8}\.html)"[^>]*>(?:<img[^>]+?(?:name="previous_day"|alt="Previous"|src="[^"]*back[^"]*")|Previous comic)', IGNORECASE)
        help = 'Index format: yyyymmdd'

    for name, urls in keenspotComics.iteritems():
        if not isinstance(urls, tuple):
            baseUrl = latestUrl = urls
        else:
            baseUrl, latestUrl = urls

        comics[name] = KeenSpotScraper.make('KeenSpot/' + name, latestUrl=latestUrl or baseUrl)

    return comics


keenspotComics = {
    '13thLabour': 'http://the13labour.comicgenesis.com/',
    '1StComing': 'http://toon.comicgenesis.com/',
    '1StGradeArt': 'http://art.comicgenesis.com/',
    '21StCenturyCoeds': 'http://twentyfirstcenturycoeds.comicgenesis.com/',
    '21stCenturyFox': 'http://techfox.comicgenesis.com/',
    '24fps': 'http://filmbuff.comicgenesis.com/',
    '2DormsDown': 'http://mindflenzing.comicgenesis.com/',
    '2WayMirror': 'http://tande.comicgenesis.com/',
    '3RdEstate': 'http://tasch.comicgenesis.com/',
    '5Universe': 'http://fiveu.comicgenesis.com/',
    '6X9College': 'http://sixbyninecollege.comicgenesis.com/',
    '72Bunnies': 'http://seventy2bunnies.comicgenesis.com/',
    '8to1': 'http://yeahduff.comicgenesis.com/',
    'AbbysAgency': 'http://abbysagency.us/',
    'AberdawnKnights': 'http://aberdawnknights.comicgenesis.com/',
    'AboveMan': 'http://aman.comicgenesis.com/',
    'AbsoluteZero': 'http://absolutezero.comicgenesis.com/',
    'Academy': 'http://theacademy.comicgenesis.com/',
    'Ace147': 'http://ace147.comicgenesis.com/',
    'Ac': 'http://theac.comicgenesis.com/',
    'ACorporateSlave': 'http://cartoongraveyard.comicgenesis.com/',
    'ActiveStuporHeroes': 'http://stuporheroes.comicgenesis.com/',
    'AdamAndSei': ('http://adamandsei.comicgenesis.com/', 'http://adamandsei.comicgenesis.com/comic.html'),
    'AdiosAngel86': 'http://aa86.comicgenesis.com/',
    'Adventurers': 'http://www.adventurers-comic.com/',
    'AdventuresInVastia': 'http://aiv.comicgenesis.com/',
    'AdventuresOfChifley': 'http://chifley.comicgenesis.com/',
    'AdventuresOfGotty': 'http://gotty.comicgenesis.com/',
    'AdventuresOfKeystone': 'http://keystonecomic.comicgenesis.com/',
    'AdventuresOfKiltboi': 'http://realmenwearkilts.comicgenesis.com/',
    'AdventuresOfLilDenverPastrami': 'http://lildenverpastrami.comicgenesis.com/',
    'AdventuresOfMattAndChris': 'http://matthewabel.comicgenesis.com/',
    'AdventuresOfPie': 'http://loonybin.comicgenesis.com/',
    'AdventuresOfPopsicleman': 'http://popsicleman.comicgenesis.com/',
    'AdventuresOfSpaceDevil': 'http://spacedevil.comicgenesis.com/',
    'AdventuresOfTheOffenders': 'http://jmsnooks.comicgenesis.com/',
    'AdventuresOfTheSTeam': 'http://ianthealy.comicgenesis.com/',
    'AdventuresOfToasterboy': 'http://toaster.comicgenesis.com/',
    'AdventuresOfUs': 'http://adventuresofus.comicgenesis.com/',
    'AfterTheEndOfTheWorld': 'http://endoftheworld.comicgenesis.com/',
    'AfterTheRain': 'http://ladyoftherealm.comicgenesis.com/',
    'AFunnyThingHappened': 'http://funnything.comicgenesis.com/',
    'AgaricChampAndEcircTre': 'http://agaric.comicgenesis.com/',
    'AGeekTragedy': 'http://geektragedy.comicgenesis.com/',
    'AjsLife': 'http://ajworks.comicgenesis.com/',
    'AldusMaycombe': 'http://aldus.comicgenesis.com/',
    'AlexHigh': 'http://alexhigh.comicgenesis.com/',
    'AllRosesHaveThorns': 'http://allroses.comicgenesis.com/',
    'AlphaBetaSoup': 'http://abs.comicgenesis.com/',
    'AlphaLuna': 'http://alphaluna.comicgenesis.com/',
    'AltaModaMetro': 'http://www.am-metro.net/',
    'AlternateDelusions': 'http://altdelusions.comicgenesis.com/',
    'AlwaysAnotherDay': 'http://alwaysanotherday.comicgenesis.com/',
    'AmazingNewWorlds': 'http://anw.comicgenesis.com/',
    'AmbersLife': 'http://amberslife.comicgenesis.com/',
    'AmericanGothicDaily': 'http://americangothic.comicgenesis.com/',
    'Amerika': 'http://amerika.comicgenesis.com/',
    'Amethyst': 'http://amethyst.comicgenesis.com/',
    'AmhelakiMisadventures': 'http://amhelaki.comicgenesis.com/',
    'Amoeba': 'http://www.theamoebaonline.co.uk/',
    'AnarchyAndAnthros': 'http://creepylilgothkids.comicgenesis.com/',
    'Andellon': 'http://andellon.comicgenesis.com/',
    'Andiewear': 'http://andiewear.com/',
    'AndShineHeavenNow': 'http://hellsing.comicgenesis.com/',
    'AngelBlood': 'http://angelblood.comicgenesis.com/',
    'Angel': 'http://angelink.comicgenesis.com/',
    'AngelTheDemoness': 'http://angelthedemoness.comicgenesis.com/',
    'AngryAidenSComic': 'http://angryaidenscomic.comicgenesis.com/',
    'AngryArtwerks': 'http://angrydwarf.comicgenesis.com/',
    'AngryComicShopGuy': 'http://angrycomicshopguy.comicgenesis.com/',
    'AngryDMonkey': 'http://www.angrydmonkey.com/',
    'AngrySoul': 'http://angrysoul.comicgenesis.com/',
    'AngstIsAFiveLetterWord': 'http://aiaflw.comicgenesis.com/',
    'AngstMedieval': 'http://gothiccomic.comicgenesis.com/',
    'AnimalInstinct': 'http://animalinstinct.comicgenesis.com/',
    'AnimalTesting': 'http://animaltesting.comicgenesis.com/',
    'AnimeMomentsInHistory': 'http://animehistory.comicgenesis.com/',
    'Animi': 'http://animi.comicgenesis.com/',
    'Anna': 'http://anna.comicgenesis.com/',
    'AnnaMariaAndMaryAnne': 'http://missjaney.comicgenesis.com/',
    'AnotherNormalDay': 'http://super2goten.comicgenesis.com/',
    'AnthropomorphicHardware': 'http://hardware.comicgenesis.com/',
    'ANT': 'http://ant.comicgenesis.com/',
    'Antibunny': 'http://www.antibunny.com/',
    'AntiChristDaiji': 'http://clad.comicgenesis.com/',
    'Antics': 'http://antics.comicgenesis.com/',
    'AntiFeline': 'http://antifeline.comicgenesis.com/',
    'AntiHeroForHire': 'http://www.antiheroforhire.com/',
    'Antinomies': 'http://antinomies.comicgenesis.com/',
    'AnywhereButHere': 'http://anywherebuthere.comicgenesis.com/',
    'ApocalypseWow': 'http://endofdayspress.comicgenesis.com/',
    'Apotheosis': 'http://apotheosis.comicgenesis.com/',
    'Arbitrator': 'http://arbitrator.comicgenesis.com/',
    'Area15': 'http://area15.comicgenesis.com/',
    'Armz': 'http://armz.comicgenesis.com/',
    'ArnieGattonGalleryOfComics': 'http://agallery.comicgenesis.com/',
    'ARtificialTIme': 'http://artificialtime.comicgenesis.com/',
    'Ashfield': 'http://ashfieldonline.com/',
    'Asianosity': 'http://asianosity.comicgenesis.com/',
    'AskillWar': 'http://askillwar.comicgenesis.com/',
    'AsNarratedByDrakenred': 'http://drakenred.comicgenesis.com/',
    'AssO9Tails': 'http://asso9tails.comicgenesis.com/',
    'Astorauth': 'http://www.astorauth.com/',
    'AtaraxiaTheatre': 'http://ataraxia.comicgenesis.com/',
    'Atavism': 'http://atavism.comicgenesis.com/',
    'AThinLine': 'http://thinline.comicgenesis.com/',
    'Atlantis': 'http://atlantis.comicgenesis.com/',
    'AtPerfect': 'http://atperfect.comicgenesis.com/',
    'AugustThe15Th': 'http://jamesgannon.comicgenesis.com/',
    'AU': 'http://auie.comicgenesis.com/',
    'Avalon2': 'http://avalon.comicgenesis.com/',
    'AWasteOfPaper': 'http://monotypical.comicgenesis.com/',
    'AwesomeGamerz': 'http://awesomegamerz.com/',
    'AwfullyGeneric': 'http://awfullygeneric.comicgenesis.com/',
    'AwolAdventures': 'http://awol.comicgenesis.com/',
    'Backroads': 'http://backroads.comicgenesis.com/',
    'BadassBrat': 'http://badassbrat.comicgenesis.com/',
    'BadlyDrawnPenguins': 'http://badlydrawnpenguins.comicgenesis.com/',
    'BakaKun': 'http://bakakun.comicgenesis.com/',
    'BananaTwist': 'http://bananatwist.comicgenesis.com/',
    'Banished': 'http://www.banishedonline.com/',
    'BARAKA': 'http://baraka.comicgenesis.com/',
    'Basics': 'http://moonbay.comicgenesis.com/',
    'BasilFlintMiniseries': 'http://basilflint.keenspot.com/',
    'Bastion': 'http://bastion.comicgenesis.com/',
    'BathathonHeled': 'http://bathathonheled.comicgenesis.com/',
    'BattleCry': 'http://battlecry.comicgenesis.com/',
    'BeastOfEden': 'http://beast.comicgenesis.com/',
    'BeautifulSkies': 'http://bskies.comicgenesis.com/',
    'BecauseOfMathClass': 'http://mathclass.comicgenesis.com/',
    'Beecham': 'http://beecham.comicgenesis.com/',
    'BeforeDawn': 'http://beforedawn.comicgenesis.com/',
    'BestAndTheBrightest': 'http://www.flyovercountry.net/',
    'BetterLifeThanThis': 'http://abetterlifethanthis.comicgenesis.com/',
    'BetweenRealities': 'http://realities.comicgenesis.com/',
    'BeyAndEmerald': 'http://bey.comicgenesis.com/',
    'BeyondGoodNEvil': 'http://goodnevil.comicgenesis.com/',
    'BeyondHalo': 'http://beyondhalo.comicgenesis.com/',
    'BeyondReality': 'http://orion.comicgenesis.com/',
    'BeyondTheRadiator': 'http://radiator.comicgenesis.com/',
    'Bigheads': 'http://thebigheads.comicgenesis.com/',
    'BigTom': 'http://bigtom.comicgenesis.com/',
    'Bikou': 'http://bikou.comicgenesis.com/',
    'BillyThePervertedWonderBoy': 'http://billyisapervert.comicgenesis.com/',
    'Bing': 'http://caitlinf.comicgenesis.com/',
    'BinOfInsanity': 'http://boi.comicgenesis.com/',
    'BirthOfGenesis': 'http://birthofgenesis.comicgenesis.com/',
    'BiscuitsForBreakfast': 'http://valuedan.comicgenesis.com/',
    'BiteTheWaxTadpole': 'http://bitethewaxtadpole.comicgenesis.com/',
    'BitterSweetBS': 'http://bsbs.comicgenesis.com/',
    'Blackaby': 'http://blackaby.comicgenesis.com/',
    'Blackbird27': 'http://blackbird27.comicgenesis.com/',
    'BlackHoleBlues': 'http://blackholeblues.comicgenesis.com/',
    'BlacklightTwilight': 'http://nekkoxiii.comicgenesis.com/',
    'BlackPlague': 'http://blackplague.keenspot.com/',
    'BlackTapestries': 'http://blacktapestries.comicgenesis.com/',
    'BlackTie': 'http://blacktiecomics.comicgenesis.com/',
    'BlankGeorge': 'http://blankgeorge.comicgenesis.com/',
    'Blatah': 'http://blatah.comicgenesis.com/',
    'BleistiftansatzSissy': 'http://bleistiftansatz.comicgenesis.com/',
    'BlindPath': 'http://skyline.comicgenesis.com/',
    'Blindworks': 'http://blindworks.comicgenesis.com/',
    'BloodBound': 'http://www.bloodboundcomic.com/',
    'Blooddrop': 'http://blooddrop.comicgenesis.com/',
    'BloodOfTheDragon': 'http://bdragon.comicgenesis.com/',
    'BloodWing': 'http://bloodwing.comicgenesis.com/',
    'BlueAndOrange': 'http://blueandorange.comicgenesis.com/',
    'BlueBalled': 'http://sunder.comicgenesis.com/',
    'BlueCollarCleanup': 'http://franko.comicgenesis.com/',
    'BlueEyedDevil': 'http://blueeyeddevil.comicgenesis.com/',
    'Blunderclod': 'http://blunderclod.comicgenesis.com/',
    'BobAndSkull': 'http://bobandskull.comicgenesis.com/',
    'BobsSpiffORama': 'http://spifforama.comicgenesis.com/',
    'BobTheBlock': 'http://bobtheblock.comicgenesis.com/',
    'Bobville': 'http://mekryd.comicgenesis.com/',
    'Bohumilek': 'http://bohumilek.comicgenesis.com/',
    'BoobsAhoy': 'http://boobsahoy.comicgenesis.com/',
    'Bookwyrms': 'http://bookwyrms.comicgenesis.com/',
    'BoomerExpress': 'http://www.boomerexpress.com/',
    'BootCamp': 'http://bootcamp.comicgenesis.com/',
    'Borderline': 'http://chinookpictures.comicgenesis.com/',
    'BowspiritsAim': 'http://bowspirits.comicgenesis.com/',
    'BoxJamsDoodle': 'http://boxjamsdoodle.com/',
    'BoyMeetsBoy': 'http://boymeetsboy.keenspot.com/',
    'BradleyDrawn': 'http://bradleydrawn.comicgenesis.com/',
    'BrainCramp': 'http://braincramp.comicgenesis.com/',
    'BreckenChronicles': 'http://brecken.comicgenesis.com/',
    'BringYourOwnController': 'http://byoc.comicgenesis.com/',
    'Brinkerhoff': 'http://www.brinkcomic.com/',
    'BrokenCompass': 'http://brokencompass.comicgenesis.com/',
    'BrokenGlass': 'http://brokenglass.comicgenesis.com/',
    'BrokenWorlds': 'http://brokenworlds.comicgenesis.com/',
    'BrooklynBeatdown': 'http://bklynite20.comicgenesis.com/',
    'BrunoTheBandit': 'http://www.brunothebandit.com/',
    'Brunswick': 'http://brunswick.comicgenesis.com/',
    'Burgundycomics': 'http://bci.stripspace.com/',
    'BusterAndFriends': 'http://busterandfriends.comicgenesis.com/',
    'ButtonsTooHyperToThink': 'http://buttonscrew.comicgenesis.com/',
    'CAGE': 'http://cage.comicgenesis.com/',
    'CallToDestiny': 'http://madgoblin.comicgenesis.com/',
    'Cameocomic': 'http://cameocomic.comicgenesis.com/',
    'CamiXAlex': ('http://camixalex.comicgenesis.com/', 'http://camixalex.comicgenesis.com/home.html'),
    'CampAlaska': 'http://campalaska.comicgenesis.com/',
    'Candidate': 'http://kennystrife.comicgenesis.com/',
    'Candi': 'http://www.candicomics.com/',
    'Candy': 'http://candy.comicgenesis.com/',
    'CanisLupus': 'http://cheetahfox.comicgenesis.com/',
    'CannedHam': 'http://cannedham.comicgenesis.com/',
    'CantStopTheMusic': 'http://cantstopthemusic.comicgenesis.com/',
    'CaptainMike': 'http://captainmike.comicgenesis.com/',
    'CaptainMortua': 'http://captainmortua.comicgenesis.com/',
    'CaptureTheFlag': 'http://kramerthebird.comicgenesis.com/',
    'Carnivores': 'http://carnivores.comicgenesis.com/',
    'CarrotsAndCheese': 'http://cnc.comicgenesis.com/',
    'CascadeFailure': 'http://cascadefailure.comicgenesis.com/',
    'CasualtiesOfWar': 'http://casualtiesofwar.comicgenesis.com/',
    'CatAndMouse': 'http://catandmouse.comicgenesis.com/',
    'CatboyAtTheCon': 'http://trades.comicgenesis.com/',
    'Catpaint': 'http://catpaint.comicgenesis.com/',
    'Catsick': 'http://catsick.comicgenesis.com/',
    'Catvomit': 'http://catvomit.comicgenesis.com/',
    'CaughtenHigh': 'http://caughtenhigh.comicgenesis.com/',
    'CCCC': 'http://horesy.comicgenesis.com/',
    'Chainroaker': 'http://chainroaker.comicgenesis.com/',
    'Chalkdust': 'http://chalkdustcomic.comicgenesis.com/',
    'Changes': 'http://changescomic.comicgenesis.com/',
    'ChaosGeorge': 'http://kawzkaos.comicgenesis.com/',
    'ChaosTheory': 'http://chaostheory.comicgenesis.com/',
    'ChaoticNeutral': 'http://chaoticneutral.comicgenesis.com/',
    'ChildrenAtPlay': 'http://childrenatplay.comicgenesis.com/',
    'ChildrenOfDanu': 'http://childofdanu.comicgenesis.com/',
    'ChildrenOfMoloch': 'http://moloch.comicgenesis.com/',
    'ChimeraQuest': 'http://doggirl.comicgenesis.com/',
    'ChoppingBlock': 'http://choppingblock.org/',
    'ChrisVPresents': 'http://chrisvpresents.comicgenesis.com/',
    'ChronicalsOfTheBlueSquirrel': 'http://cotbs.comicgenesis.com/',
    'ChroniclesOfAvernyght': 'http://www.avernyght.com/',
    'ChroniclesOfSalterre': 'http://salterre.comicgenesis.com/',
    'ChroniclesOfWesnoth': 'http://wescron.comicgenesis.com/',
    'ChronicMisadventures': 'http://chronic.comicgenesis.com/',
    'ChrusherComix': 'http://chrusher.comicgenesis.com/',
    'ChubbyAndNot': 'http://chubbyandnot.comicgenesis.com/',
    'Chu': 'http://chu.comicgenesis.com/',
    'Cimmerian': 'http://cimmerian.comicgenesis.com/',
    'CircleArcadiaKnightsOfTheGoddess': 'http://arcadia.comicgenesis.com/',
    'Citron': 'http://citron.comicgenesis.com/',
    'CityStreets': 'http://poisondusk.comicgenesis.com/',
    'ClanOfTheCats': 'http://www.clanofthecats.com/',
    'ClassMenagerie': 'http://www.theclassm.com/',
    'ClearwaterClan': 'http://clearwaterclan.comicgenesis.com/',
    'Clematis': 'http://clematis.comicgenesis.com/',
    'Cliche': 'http://blaedlocke.comicgenesis.com/',
    'ClippedWings': 'http://clippedwings.comicgenesis.com/',
    'ClockworkEmpire': 'http://clockworkemp.comicgenesis.com/',
    'ClownsInABlender': 'http://clownsinablender.comicgenesis.com/',
    'CMD': 'http://cmd.comicgenesis.com/',
    'Cnetr': 'http://cnetr.comicgenesis.com/',
    'CodeBlack': 'http://codeblack.comicgenesis.com/',
    'Codename9': 'http://codename9.comicgenesis.com/',
    'Cody': 'http://cody.comicgenesis.com/',
    'ColdFeet': 'http://coldfeet.comicgenesis.com/',
    'ColdPlanet': 'http://coldplanet.comicgenesis.com/',
    'ColdServings': 'http://www.coldservings.com/',
    'ColdWhiteNorth': 'http://coldwhitenorth.comicgenesis.com/',
    'CollegeRoomiesFromHell': 'http://www.crfh.net/',
    'CollidingWorlds': 'http://fearunianadv.comicgenesis.com/',
    'ColossalComics': 'http://resolutes.comicgenesis.com/',
    'ComfortablyNumb': 'http://comfortablynumb.comicgenesis.com/',
    'ComicCreatorz': 'http://creatorz.comicgenesis.com/',
    'ComicGraveyard': 'http://comicgraveyard.comicgenesis.com/',
    'CommonDays': 'http://commondays.comicgenesis.com/',
    'Commonplace': 'http://commonplace.comicgenesis.com/',
    'CommonSense': 'http://commonsense.comicgenesis.com/',
    'ComputerGameAddicts': 'http://cgaddicts.comicgenesis.com/',
    'Concession': 'http://concession.comicgenesis.com/',
    'ConfessionsOfAnEnglishCatburglar': 'http://catburglars.comicgenesis.com/',
    'Conned': 'http://con.comicgenesis.com/',
    'ConstantFlux': 'http://constantflux.comicgenesis.com/',
    'CookieWorld': 'http://cookie.comicgenesis.com/',
    'CoolCatStudios': ('http://www.coolcatstudio.com/', 'http://www.coolcatstudio.com/d/20020415.html'),
    'Cooties': 'http://cooties.comicgenesis.com/',
    'CornerAlley13': 'http://corneralley.comicgenesis.com/',
    'CorporateLife': 'http://amacher.comicgenesis.com/',
    'CorridorZ': 'http://billybones.comicgenesis.com/',
    'CosmicAwareness': 'http://cosmicawareness.comicgenesis.com/',
    'CosmicDesign': 'http://cosmicdesign.comicgenesis.com/',
    'CountYourSheep': 'http://www.countyoursheep.com/',
    'CoyoteDance': 'http://cdance.comicgenesis.com/',
    'CracklingSilence': 'http://crackling.comicgenesis.com/',
    'Crackwalker': 'http://crackwalker.comicgenesis.com/',
    'CreateAComicProject': 'http://ccproject.comicgenesis.com/',
    'CreativityShack': 'http://creativityshack.comicgenesis.com/',
    'CreatureKeeper': 'http://creature.comicgenesis.com/',
    'CreepyHead': 'http://creepyhead.comicgenesis.com/',
    'CriminalMastermind': 'http://criminalmastermind.comicgenesis.com/',
    'CrimsonWings': 'http://sdcomics.comicgenesis.com/',
    'CriticalMiss': 'http://criticalmiss.comicgenesis.com/',
    'CrookedHalo': 'http://chaoscricket.comicgenesis.com/',
    'Crossovers': 'http://crossovers.comicgenesis.com/',
    'Crossroads': 'http://anivasion.comicgenesis.com/',
    'CrossroadsOfBoogerCounty': 'http://cobc.comicgenesis.com/',
    'CrossStreetBlues': 'http://crossstreet.comicgenesis.com/',
    'CrossToBear': 'http://crosstobear.comicgenesis.com/',
    'CRouge': 'http://crouge.comicgenesis.com/',
    'CrowsScrapbook': 'http://crowsscrapbook.comicgenesis.com/',
    'CruelFate': ('http://cruelfate.keenspot.com/', 'http://cruelfate.keenspot.com/d/20000630.html'),
    'CrystalHearts': 'http://chs.comicgenesis.com/',
    'Cube30': 'http://cube30.comicgenesis.com/',
    'Cutethulhu': 'http://www.cutethulhu.com/',
    'DaisyMaesBazaar': 'http://daisymaebazaar.comicgenesis.com/',
    'DanskFolly': 'http://danskfolly.comicgenesis.com/',
    'DarkAges': 'http://darkages.comicgenesis.com/',
    'DarkDays': 'http://darkdays.comicgenesis.com/',
    'Darken': 'http://www.darkencomic.com/',
    'DarkForests': 'http://darkforests.comicgenesis.com/',
    'DarkJediAndFriends': 'http://darkjedi.comicgenesis.com/',
    'DarknessVersusLight': 'http://dvsl.comicgenesis.com/',
    'Darksided': 'http://darksided.comicgenesis.com/',
    'DasienSuperheroWebcomic': 'http://www.dasiencomic.com/',
    'DataChasers': 'http://datachasers.comicgenesis.com/',
    'DATAROM': 'http://datarom.comicgenesis.com/',
    'Davin': 'http://davin.comicgenesis.com/',
    'Daydreamer': 'http://daydreamer.comicgenesis.com/',
    'DayDream': 'http://manganese.comicgenesis.com/',
    'DayInTheLifeOfACosplayer': 'http://ditloac.comicgenesis.com/',
    'DDiary': 'http://ddiary.comicgenesis.com/',
    'DeadBeats': 'http://deadbeats.comicgenesis.com/',
    'DearBrotherMine': 'http://lancha.comicgenesis.com/',
    'DearDiary': 'http://deardiary.comicgenesis.com/',
    'DeathByChibi': 'http://deathbychibi.comicgenesis.com/',
    'DecadentAndDepraved': 'http://depraved.comicgenesis.com/',
    'Decypher': 'http://decypher.comicgenesis.com/',
    'DedEnd': 'http://dedend.comicgenesis.com/',
    'Deep': 'http://deep.comicgenesis.com/',
    'DefectiveChineseGirl': 'http://eclipsearikado.comicgenesis.com/',
    'DefinitelyNotAnotherWebcomicWhere': 'http://dna2w.comicgenesis.com/',
    'DelusionsOfAdequacy': 'http://dofa.comicgenesis.com/',
    'DementedEmu': 'http://dementedemu.comicgenesis.com/',
    'DemonChroniclesOfKyo': 'http://demonchronicles.comicgenesis.com/',
    'DemonicBoppu': 'http://demonicboppu.comicgenesis.com/',
    'Demonic': 'http://alyafenume.comicgenesis.com/',
    'DemonicPoint': 'http://demonicpoint.comicgenesis.com/',
    'Demonocity': 'http://demonocity.comicgenesis.com/',
    'DemonSlayers': 'http://demonslayers.comicgenesis.com/',
    'DemonWing': 'http://demonwing.comicgenesis.com/',
    'DemoralizedLogic': 'http://lostmind.comicgenesis.com/',
    'Deo': 'http://deo.comicgenesis.com/',
    'DesolationAngelTango': 'http://desolationangel.comicgenesis.com/',
    'Detalitum': 'http://abaddon.comicgenesis.com/',
    'DetalitumPl': 'http://detalitum.comicgenesis.com/',
    'DetFemteEss': 'http://haykay.comicgenesis.com/',
    'DeusExMinineko': 'http://dem.comicgenesis.com/',
    'DevilsPanties':'http://www.thedevilspanties.com/',
    'DevilsPlayground': 'http://devilsplayground.comicgenesis.com/',
    'DewbackWing': 'http://td501.comicgenesis.com/',
    'DexLives': 'http://dexlives.comicgenesis.com/',
    'DigitalAge': 'http://digitalage.comicgenesis.com/',
    'DigitalWar': 'http://www.digitalwar.co.uk/',
    'DimBulbComics': 'http://www.dimbulbcomics.com/',
    'Dindsneys': 'http://xxxx.comicgenesis.com/',
    'Disorder': 'http://disorder.comicgenesis.com/',
    'DistantEras': 'http://distanteras.comicgenesis.com/',
    'DistantScreaming': 'http://distantscreaming.comicgenesis.com/',
    'DNPIO': 'http://dnpio.comicgenesis.com/',
    'DocHyperion': 'http://dochyperion.comicgenesis.com/',
    'DocTarantula': 'http://doctarantula.comicgenesis.com/',
    'DoctorPepperShow': 'http://doctorpepper.comicgenesis.com/',
    'DogAndPony': 'http://dogandpony.comicgenesis.com/',
    'DogBomb': 'http://dogbomb.comicgenesis.com/',
    'DogDays': 'http://dogdays.comicgenesis.com/',
    'DogTheSpot': 'http://dogthespot.comicgenesis.com/',
    'DoomArmy': 'http://experimental.comicgenesis.com/',
    'DoomCheese': 'http://doomcheese.comicgenesis.com/',
    'Doppies': 'http://doppies.comicgenesis.com/',
    'DoTheBearcat': 'http://dtbc.comicgenesis.com/',
    'DownToEarth': 'http://www.downtoearthcomic.com/',
    'DownwardBound': 'http://downwardbound.comicgenesis.com/',
    'Dragonaur': 'http://dragonaur.comicgenesis.com/',
    'DragonBallTm': 'http://dragonballtm.comicgenesis.com/',
    'DragonBoy': 'http://dragonboy.comicgenesis.com/',
    'DragonInTheCourtyard': 'http://ditc.comicgenesis.com/',
    'DragonKingdoms': 'http://dragonkingdoms.comicgenesis.com/',
    'DragonMail': 'http://dragonmail.comicgenesis.com/',
    'DragonSchoolAndStuff': 'http://dragonss.comicgenesis.com/',
    'Drapetomania': 'http://drapetomania.comicgenesis.com/',
    'DRAW': 'http://draw.comicgenesis.com/',
    'DrawnAndQuartered': 'http://drawnandquartered.comicgenesis.com/',
    'DreamersDynasty': 'http://kidneo66.comicgenesis.com/',
    'DreamLikeDestiny': 'http://dreamlikedestiny.comicgenesis.com/',
    'DreamOfAWorld': 'http://doaw.comicgenesis.com/',
    'DreamsAndMemories': 'http://meghasissues.comicgenesis.com/',
    'DreamwaltzerZera': 'http://dwz.comicgenesis.com/',
    'DreamWay': 'http://dreamway.comicgenesis.com/',
    'Drewford': 'http://drewford.comicgenesis.com/',
    'DriveThruBlues': 'http://drivethrublues.comicgenesis.com/',
    'DrowNazi': 'http://drownazi.comicgenesis.com/',
    'Drunkenkite': 'http://drunkenkite.comicgenesis.com/',
    'DualHorizon': 'http://dualhorizon.comicgenesis.com/',
    'DuaVeno': 'http://wizarddog.comicgenesis.com/',
    'DuchessMew': 'http://duchessmew.comicgenesis.com/',
    'Dugger': 'http://dugger.comicgenesis.com/',
    'DumbAngel': 'http://dumbangel.comicgenesis.com/',
    'DungeonDamage': 'http://dungeondamage.comicgenesis.com/',
    'DysfunctionJunction': 'http://dysfunctionjunction.comicgenesis.com/',
    'DysonsCreek': 'http://dysonscreek.comicgenesis.com/',
    'E2e': 'http://e2e.comicgenesis.com/',
    'EarlAndMyrtle': 'http://earlandmyrtle.comicgenesis.com/',
    'EatingTheInternet': 'http://eating.comicgenesis.com/',
    'EatTheRoses': 'http://eattheroses.com/',
    'Echzeon': 'http://echzeon.comicgenesis.com/',
    'EdensChronicle': 'http://blackeden.comicgenesis.com/',
    'EdgeTheDevilhunter': 'http://edgeknight.comicgenesis.com/',
    'Educated': 'http://educated.comicgenesis.com/',
    'EgoTrip': 'http://egotrip.comicgenesis.com/',
    'EinstiensDesk': 'http://einstiensdesk.comicgenesis.com/',
    'EitherWay': 'http://deadspace.comicgenesis.com/',
    'ElCieloDeLosEspermatozoides': 'http://fjgarcia.comicgenesis.com/',
    'Eldritch': 'http://eldritch.comicgenesis.com/',
    'ElfOnlyInn': 'http://www.elfonlyinn.net/',
    'ElGoonishShiveFiller': 'http://www.egscomics.com/Filler/',
    'ElGoonishShive': 'http://elgoonishshive.com/',
    'ElGoonishShiveNP': 'http://www.egscomics.com/egsnp/',
    'ElleAndAllTheOthers': 'http://elle.comicgenesis.com/',
    'ElSuenoDeLaRazonProduceMonstruos': 'http://cubanaloca.comicgenesis.com/',
    'ElvenExploration': 'http://www.theelven.com/',
    'EmergencyExit': 'http://www.eecomics.net/',
    'Emma': 'http://miruku.comicgenesis.com/',
    'Emo': 'http://emo.comicgenesis.com/',
    'EMotel': 'http://emotel.comicgenesis.com/',
    'EmperorOfOrphans': 'http://emperoroforphans.comicgenesis.com/',
    'EmptyTheater': 'http://mttheater.comicgenesis.com/',
    'EmSquaredACartoon': 'http://emacartoon.comicgenesis.com/',
    'EndlessLimit': 'http://endlesslimit.comicgenesis.com/',
    'EndOfThings': 'http://endofthings.comicgenesis.com/',
    'Ensuing': 'http://ensuing.comicgenesis.com/',
    'EnterTheStory': 'http://savedgames.comicgenesis.com/',
    'Entropy': 'http://entropycomix.comicgenesis.com/',
    'Envoy': 'http://envoy.comicgenesis.com/',
    'EpicTalesOfLaminir': 'http://jideiro.comicgenesis.com/',
    'ErrantVenture': 'http://errantventure.comicgenesis.com/',
    'ESAndD': 'http://esnd.comicgenesis.com/',
    'Esc': 'http://esc.comicgenesis.com/',
    'EshByEsh': 'http://esh.comicgenesis.com/',
    'Essence': 'http://fusion.comicgenesis.com/',
    'EternalQuest': ('http://luniara.comicgenesis.com/', 'http://luniara.comicgenesis.com/in.html'),
    'EternityComplex': ('http://eternitycomplex.comicgenesis.com/', 'http://eternitycomplex.comicgenesis.com/current.html'),
    'EtherealEuphoriaTheSweetestEscape': 'http://beccat.comicgenesis.com/',
    'EveOfCloves': 'http://eveofcloves.comicgenesis.com/',
    'EverscapeNet': 'http://everscape.comicgenesis.com/',
    'EverydaySam': 'http://everydaysam.comicgenesis.com/',
    'EverythingJake': 'http://www.everythingjake.com/',
    'EvilNeedsCandyToo': 'http://evilneedscandytoo.comicgenesis.com/',
    'EvilOverlordsUnited': 'http://eou.comicgenesis.com/',
    'EvilThatMenDo': 'http://theevilthatmendo.comicgenesis.com/',
    'EvilWenchesIncorporated': 'http://evilwenchesinc.comicgenesis.com/',
    'ExterminatusNow': 'http://exterminatusnow.comicgenesis.com/',
    'EyeForAnEye': 'http://spirat.comicgenesis.com/',
    'EyeOfTheMonkey': 'http://eyeofthemonkey.comicgenesis.com/',
    'Faces': 'http://faces.comicgenesis.com/',
    'FadedBrightness': 'http://faebs.comicgenesis.com/',
    'FadeToBlack': 'http://fadetoblack.comicgenesis.com/',
    'FadingInnocence': 'http://fadinginnocence.comicgenesis.com/',
    'FaerieTales': ('http://faerietales.comicgenesis.com/', 'http://faerietales.comicgenesis.com/todayscomics.html'),
    'Fagz': 'http://fagz.comicgenesis.com/',
    'FAIL': 'http://fail.comicgenesis.com/',
    'FallenAngelsUsedBooks': 'http://www.faubcomic.com/',
    'FalseGods': 'http://falsegod.comicgenesis.com/',
    'FamiliarBlue': 'http://familiarblue.comicgenesis.com/',
    'FamiliarMagic': 'http://familiarmagic.comicgenesis.com/',
    'FanserviceMeteorologyWin': 'http://aod.comicgenesis.com/',
    'FantasticalBestiary': 'http://fantasticalbestiary.comicgenesis.com/',
    'FantasyQwest': 'http://creatorauthorman.comicgenesis.com/',
    'Feathers': 'http://feathers.comicgenesis.com/',
    'FelixAndTheKidneyEater': 'http://fnk.comicgenesis.com/',
    'Fellonist': 'http://thefellonist.comicgenesis.com/',
    'FellowFreaks': 'http://fellowfreaks.comicgenesis.com/',
    'FemmeFatale': 'http://femmefatale.comicgenesis.com/',
    'FERAL': 'http://feral.comicgenesis.com/',
    'FFTSB': 'http://fftsb.comicgenesis.com/',
    'FightCastOrEvade': 'http://fightcastorevade.comicgenesis.com/',
    'Filler': 'http://filler.comicgenesis.com/',
    'FilthyLies': 'http://www.filthylies.net/',
    'FinalDraft': 'http://finaldraft.comicgenesis.com/',
    'FireflyCross': 'http://fireflycross.comicgenesis.com/',
    'FirstKingdom': 'http://firstkingdom.comicgenesis.com/',
    'FishFry': 'http://fishfry.comicgenesis.com/',
    'Fish': 'http://fish.comicgenesis.com/',
    'FishMachine': 'http://fishmachine.comicgenesis.com/',
    'Fishman': 'http://fishmancomics.comicgenesis.com/',
    'FistofTheSarariman': 'http://fots.comicgenesis.com/',
    'Fizzle': 'http://fizzle.comicgenesis.com/',
    'FLATLINE': 'http://loadobject.comicgenesis.com/',
    'Flem': 'http://www.flemcomics.com/',
    'FletcherApts': 'http://fletcherapts.comicgenesis.com/',
    'FlinchAndFriends': 'http://flinch.comicgenesis.com/',
    'FloorIsLava': 'http://floorislava.comicgenesis.com/',
    'FlowfieldUnity': 'http://unityflow.comicgenesis.com/',
    'FluffyAndMervin': 'http://debbieann.comicgenesis.com/',
    'Flunkies': 'http://flunkies.comicgenesis.com/',
    'Flux': 'http://flux.comicgenesis.com/',
    'FlyingHighAndLow': 'http://highandlow.comicgenesis.com/',
    'Foma': 'http://foma.comicgenesis.com/',
    'FoolsGold': 'http://foolsgold.comicgenesis.com/',
    'ForestOfIllusion': 'http://angelizland.comicgenesis.com/',
    'Forgiven': 'http://forgiven.comicgenesis.com/',
    'FortunesFools': 'http://fortunesfools.comicgenesis.com/',
    'FortyTwoPlusNineteen': 'http://fpn.comicgenesis.com/',
    'FoundAPeanut': 'http://dice.comicgenesis.com/',
    'FourthWall': 'http://fourthwall.comicgenesis.com/',
    'FoxfireChronicles': 'http://foxfire.comicgenesis.com/',
    'FoxsFreakyAdventures': 'http://basa.comicgenesis.com/',
    'FoxTails': 'http://foxtails.comicgenesis.com/',
    'Fr33St0FfPlz': 'http://fr33st0ffplz.comicgenesis.com/',
    'FracturedService': 'http://fracturedservice.comicgenesis.com/',
    'FramedArtOnTheRun': 'http://artontherun.comicgenesis.com/',
    'FreaksAndG33K': 'http://freaksandgeeks.comicgenesis.com/',
    'FreakU': 'http://freaku.comicgenesis.com/',
    'FreakzTheComic': 'http://freakzcomic.comicgenesis.com/',
    'FredBarlowe': 'http://fredbarlowe.comicgenesis.com/',
    'FredTheDot': 'http://fredthedot.comicgenesis.com/',
    'FreedomFries': 'http://freedomfries.comicgenesis.com/',
    'FriendlyHostility': 'http://friendlyhostility.com/',
    'FrogSkinBoots': 'http://ashdesignsonline.comicgenesis.com/',
    'FromTheDeskOf': 'http://fromthedeskof.comicgenesis.com/',
    'FromTheMargin': 'http://fromthemargin.comicgenesis.com/',
    'FromThenOnForth': 'http://fromthenonforth.comicgenesis.com/',
    'FullCircle': 'http://fullcircle.comicgenesis.com/',
    'FunnyFarm': 'http://www.funnyfarmcomics.com/',
    'FunWithPants': 'http://funwithpants.comicgenesis.com/',
    'Furmentation': 'http://xodin.comicgenesis.com/',
    'FurryWars': 'http://furrywars.comicgenesis.com/',
    'FurthiaHigh': 'http://furthiahigh.comicgenesis.com/',
    'FyshbowlComics': 'http://fysh.comicgenesis.com/',
    'GalacticAcademy': 'http://galacticacademy.comicgenesis.com/',
    'GambitAsBishounen': 'http://snigepippi.comicgenesis.com/',
    'GameJumpers': 'http://gamejumpers.comicgenesis.com/',
    'GameMisconduct': 'http://gmhockey.comicgenesis.com/',
    'GameOver': 'http://gameover.comicgenesis.com/',
    'GamerChicks': 'http://gamerchicks.comicgenesis.com/',
    'GamerKingSenshi': 'http://minion.comicgenesis.com/',
    'GamerPsychotica': 'http://gp.comicgenesis.com/',
    'GameScreenInvestigators': 'http://gsi.comicgenesis.com/',
    'GamingGuardians': 'http://gamingguardians.com/',
    'Gamingreality': 'http://gamingreality.comicgenesis.com/',
    'Garasade': 'http://garasade.comicgenesis.com/',
    'GaryAndSteve': 'http://garyandsteve.comicgenesis.com/',
    'GeebasOnParade': 'http://geebasonparade.keenspot.com/',
    'GeekBlather': 'http://geekblather.comicgenesis.com/',
    'GeekWay': 'http://geekway.comicgenesis.com/',
    'Gemini': 'http://gemini.comicgenesis.com/',
    'GemutationsPlague': 'http://darwin.comicgenesis.com/',
    'GeneCatlow': 'http://www.genecatlow.com/',
    'GenerationDumb': 'http://generationdumb.comicgenesis.com/',
    'GenevievesShadesOfGrey': 'http://genevieve.comicgenesis.com/',
    'GForGenesis': 'http://g4g.comicgenesis.com/',
    'Ghastly': 'http://www.ghastlycomic.com/',
    'GhostHunter': 'http://ghosthunter.comicgenesis.com/',
    'Ghoul': 'http://ghoul.comicgenesis.com/',
    'GirlFromBOLT': 'http://bolt.comicgenesis.com/',
    'GirlNextDoor': 'http://squeakyboo.comicgenesis.com/',
    'Gnerds2000': 'http://gnerds.comicgenesis.com/',
    'GobbleDeeGook': 'http://crissyg.comicgenesis.com/',
    'Goblins': 'http://goblinscomic.com/',
    'GodMode': 'http://www.godmodeonline.com/',
    'Godsboxers': 'http://godsboxers.comicgenesis.com/',
    'GoForIt': 'http://goforit.comicgenesis.com/',
    'GoingNowhereFast': 'http://gnf.comicgenesis.com/',
    'GoldenAge': 'http://goldenage.comicgenesis.com/',
    'GoldenCrystals': 'http://goldencrystals.comicgenesis.com/',
    'GoneAstray': 'http://goneastray.comicgenesis.com/',
    'GoodTimingNoRhythm': 'http://gtnr.comicgenesis.com/',
    'GoosebumpCity': 'http://gbc.comicgenesis.com/',
    'GorgeousPrincessCreamyBeamy': 'http://creamybeamy.comicgenesis.com/',
    'GotPride': 'http://gotpride.comicgenesis.com/',
    'GrandTheftAuto': 'http://gtaweb.comicgenesis.com/',
    'GreaterOfTwoEvils': 'http://g2e.comicgenesis.com/',
    'GreatTree': 'http://tgt.comicgenesis.com/',
    'GreenAvenger': 'http://www.green-avenger.com/',
    'GreenCircle': 'http://greencircle.comicgenesis.com/',
    'GreenLightGo': 'http://glg.comicgenesis.com/',
    'GreenTea': 'http://greentea.comicgenesis.com/',
    'Greymatters': 'http://greymatters.comicgenesis.com/',
    'Grit': 'http://grit.comicgenesis.com/',
    'Gropesville': 'http://gropesville.comicgenesis.com/',
    'GroundFloor': 'http://groundfloor.comicgenesis.com/',
    'Grubs': 'http://www.grubscomic.com/',
    'GrumpyTheFatHamster': 'http://burp.comicgenesis.com/',
    'GuitarFlatTheWebcomic': 'http://guitarflat.comicgenesis.com/',
    'GunmetalAnnie': 'http://mercuryhat.comicgenesis.com/',
    'HackersAnonymous': 'http://hackersanonymous.comicgenesis.com/',
    'HagsPoint': 'http://hagspoint.comicgenesis.com/',
    'HalloweenMonsters': 'http://holloweenmonsters.comicgenesis.com/',
    'HamstaPowah': 'http://hamstapowah.comicgenesis.com/',
    'HauntedByMoonlight': 'http://hauntedbymoonlight.comicgenesis.com/',
    'HaveANiceDay': 'http://yellowsnow.comicgenesis.com/',
    'Hazardswake': 'http://hazardswake.comicgenesis.com/',
    'HbombsBrandNewComic': 'http://hbombshow.comicgenesis.com/',
    'HeadDoctorProductions': 'http://headdoctor.comicgenesis.com/',
    'HeavyMetalChemist': 'http://heavymetalchemist.comicgenesis.com/',
    'Hellbenders': 'http://hellbenders.comicgenesis.com/',
    'Hellroy': 'http://hellroy.comicgenesis.com/',
    'Hepcats': 'http://hepcats.comicgenesis.com/',
    'HerbieAndJeff': 'http://haj.comicgenesis.com/',
    'Hereafter': 'http://hereafter.comicgenesis.com/',
    'HereAfter': 'http://keath.comicgenesis.com/',
    'HeroesOfMittNMagic': 'http://heroesofmittenmagic.comicgenesis.com/',
    'HeroInTraining': 'http://thereisnosaurus.comicgenesis.com/',
    'HerosHandbook': 'http://theheroshandbook.comicgenesis.com/',
    'HeyFox': 'http://heyfox.comicgenesis.com/',
    'Hiakuma': 'http://hiakuma.comicgenesis.com/',
    'HiddenCakeMagic': 'http://hiddencakemagic.comicgenesis.com/',
    'Hiderikan': 'http://hiderikan.comicgenesis.com/',
    'HighSchoolUteM': 'http://hsutem.comicgenesis.com/',
    'Hiro': 'http://hiro.comicgenesis.com/',
    'Hiruko': 'http://happypuke.comicgenesis.com/',
    'HoldingChaos': 'http://holdingchaos.comicgenesis.com/',
    'HomeBySeven': 'http://homebyseven.comicgenesis.com/',
    'HomeFries': 'http://friedgreencomics.comicgenesis.com/',
    'HopeAndLaurie': 'http://hopeandlaurie.comicgenesis.com/',
    'Hopscotch': 'http://hopscotch.comicgenesis.com/',
    'HotAndBothered': 'http://hotandbothered.comicgenesis.com/',
    'HotChocolateIceCream': 'http://hotchocolate.comicgenesis.com/',
    'HouseOfAThousandSeekerlets': 'http://seekerlets.comicgenesis.com/',
    'HouseOfBob': 'http://dustbunny.comicgenesis.com/',
    'HouseOfLimbo': 'http://houseoflimbo.comicgenesis.com/',
    'HouseOfLSD': 'http://houseoflsd.comicgenesis.com/',
    'HowISeeIt': 'http://toasterpip.comicgenesis.com/',
    'HowToBeNormal': 'http://howtobenormal.comicgenesis.com/',
    'Humans': 'http://humans.comicgenesis.com/',
    'HuntersBlade': 'http://huntersblade.comicgenesis.com/',
    'HuntersGuardian': 'http://huntersguardian.comicgenesis.com/',
    'Hyperboy': 'http://hyperboycomics.comicgenesis.com/',
    'HypothesisNo': 'http://hypothesisno.comicgenesis.com/',
    'IAlwaysWakeUpLazy': 'http://www.alwayslazy.com/',
    'IAmMacdoogle': 'http://americana.comicgenesis.com/',
    'ICanFeelARatScratchingMyBrain': 'http://lowkianseong.comicgenesis.com/',
    'IcarusDreams': 'http://icarusdreams.comicgenesis.com/',
    'Idget': 'http://idget.comicgenesis.com/',
    'Idiots': 'http://idiots.comicgenesis.com/',
    'IEatFood': 'http://ieatfood.comicgenesis.com/',
    'IfThenElse': 'http://ifthenelse.comicgenesis.com/',
    'IllegalElian': ('http://illegalelian.keenspot.com/', 'http://illegalelian.keenspot.com/d/20000531.html'),
    'ImAlwaysRight': 'http://alwaysright.comicgenesis.com/',
    'IMO': 'http://imo.comicgenesis.com/',
    'InAPerfectWorld': 'http://iapw.comicgenesis.com/',
    'Incomplete': 'http://incomplete.comicgenesis.com/',
    'Indavo': 'http://indavo.comicgenesis.com/',
    'IndefensiblePositions': ('http://indepos.comicgenesis.com/', 'http://indepos.comicgenesis.com/d/20070904.html'),
    'Industry': 'http://twelfthgecko.comicgenesis.com/',
    'InexplicableAdventuresOfBob': 'http://bobadventures.comicgenesis.com/',
    'Infamous': 'http://theinfamous.comicgenesis.com/',
    'Inferno': 'http://zaliria.comicgenesis.com/',
    'InfinityClub': 'http://infinityclub.comicgenesis.com/',
    'InMyPants': 'http://ilpalazzo.comicgenesis.com/',
    'InniesAndOutties': 'http://inniesandoutties.comicgenesis.com/',
    'InsaneUndertakings': 'http://insaneundertakings.comicgenesis.com/',
    'InSanity': 'http://deviantyouth.comicgenesis.com/',
    'InSearchOfHappyEndings': 'http://isohe.comicgenesis.com/',
    'InsertCoin': 'http://mistermarioman.comicgenesis.com/',
    'InsideTheBox': 'http://boxcomics.com/',
    'InstituteOfMetaphysics': 'http://iofm.comicgenesis.com/',
    'IntermittentTangents': 'http://manekochan.comicgenesis.com/',
    'InternationalHopeFoundation': 'http://ihf.comicgenesis.com/',
    'InternetFriends': 'http://internetfriends.comicgenesis.com/',
    'Interns': 'http://theinterns.comicgenesis.com/',
    'InTheCompanyOfSerpents': 'http://serpents.comicgenesis.com/',
    'InTransit': 'http://squazzy.comicgenesis.com/',
    'IpsoFacto': 'http://ipsofactocomic.comicgenesis.com/',
    'Irlhell': 'http://irlhell.comicgenesis.com/',
    'IslameyOrientalFantasy': 'http://islamey.comicgenesis.com/',
    'ITalkToTheWind': 'http://talk.comicgenesis.com/',
    'ItSAMadMadMadMadDucksWorld': 'http://doctorzaius.comicgenesis.com/',
    'IWasAtMyCenterThenDoubtCreepsIn': 'http://iwas.comicgenesis.com/',
    'JackDaftIII': 'http://jackdaftiii.comicgenesis.com/',
    'JackiesFridge': 'http://jackiesfridge.comicgenesis.com/',
    'Jaded': 'http://www.thejaded.co.uk/',
    'JagerRising': 'http://jinoku.comicgenesis.com/',
    'JannaCom': 'http://janna.comicgenesis.com/',
    'JerryLittle': 'http://suits.comicgenesis.com/',
    'JesusX': 'http://jesusx.comicgenesis.com/',
    'JimBobComics': 'http://falos.comicgenesis.com/',
    'Jitterati': 'http://jitterati.comicgenesis.com/',
    'JoeAverage': 'http://www.joeaverage.org/',
    'JonesAvenue': 'http://jonesave.comicgenesis.com/',
    'JoshInTheGhetto': 'http://joshintheghetto.comicgenesis.com/',
    'Joyride': 'http://www.joyridecomic.com/',
    'JRockShellShock': 'http://jrock.comicgenesis.com/',
    'JulyStreet': 'http://julystreet.comicgenesis.com/',
    'Jump': 'http://jump.comicgenesis.com/',
    'JunkRIOT': 'http://junkriot.comicgenesis.com/',
    'JunkWorld': 'http://junkworld.comicgenesis.com/',
    'JustAnEscape': 'http://justanescape.comicgenesis.com/',
    'JustAnotherEscape': 'http://www.justanotherescape.com/',
    'JusticeMan': 'http://justiceman.comicgenesis.com/',
    'JustTheLifeOfShoe': 'http://justshoe.comicgenesis.com/',
    'JustWarmAndFuzzy': 'http://jwaf.comicgenesis.com/',
    'JuvenileDiversion': 'http://juvenilediversion.comicgenesis.com/',
    'JWalkin': 'http://jwalkin.comicgenesis.com/',
    'KageToOdoru': 'http://kagetoodoru.comicgenesis.com/',
    'KakashiScarecrow': 'http://kakashi.comicgenesis.com/',
    'Kalten': 'http://kalten.comicgenesis.com/',
    'KalusDailyDoodleRequests': 'http://kalu.comicgenesis.com/',
    'KariAndDoug': 'http://karindoug.comicgenesis.com/',
    'Kazei5Rebirth': 'http://whiterabbit.comicgenesis.com/',
    'KeenonballRun': 'http://keenonballrun.keenspot.com/',
    'Keisarinna': 'http://keisarinna.comicgenesis.com/',
    'KenjiTheSmallSamurai': 'http://kenji.comicgenesis.com/',
    'KillingMonday': 'http://killingmonday.comicgenesis.com/',
    'KillingMoon': 'http://thekillingmoon.comicgenesis.com/',
    'KindaLikeReality': 'http://klr.comicgenesis.com/',
    'KindaQueer': 'http://kindaqueer.comicgenesis.com/',
    'KirbyAndSambo': 'http://kirbyandsambo.comicgenesis.com/',
    'KitchenSink': 'http://kitchensink.comicgenesis.com/',
    'Kitewinds': 'http://kitewinds.comicgenesis.com/',
    'KitNKayBoodle': 'http://kitnkayboodle.comicgenesis.com/',
    'Kitsch': 'http://kitsch.comicgenesis.com/',
    'Kizmet': 'http://kizmet.comicgenesis.com/',
    'KnightsOfTheNexus': 'http://www.knightsofthenexus.com/',
    'KnightsOfVesteria': 'http://www.kovcomic.com/',
    'KodamaNoNikki': 'http://www.skimlines.com/',
    'Kokiro': 'http://kokiro.comicgenesis.com/',
    'KottaKokoro': 'http://kottakokoro.comicgenesis.com/',
    'Kungfounded': 'http://kungfounded.comicgenesis.com/',
    'KungFuPandas': 'http://kungfupandas.comicgenesis.com/',
    'KurenaiMashin': 'http://km.comicgenesis.com/',
    'LabBratz': 'http://labbratz.comicgenesis.com/',
    'Lacunae': 'http://lacunae.comicgenesis.com/',
    'Landis': 'http://elisalandis.com/',
    'LandOfGreed': 'http://zarrillo.comicgenesis.com/',
    'LangLang': 'http://langlang.comicgenesis.com/',
    'LarryAndOliver': 'http://lao.comicgenesis.com/',
    'LastManStanding': 'http://www.lms-comic.com/',
    'LastWorld': 'http://lastworld.comicgenesis.com/',
    'LaundromatComics': 'http://laundromatcomics.comicgenesis.com/',
    'LauraSeabrooksWebComix': 'http://lauraseabrook.comicgenesis.com/',
    'LawOfPurple': 'http://dragongirl.comicgenesis.com/',
    'LeagueOfExtraordinaryFurries': 'http://lxfurries.comicgenesis.com/',
    'LeanOnMe': 'http://jadaze.comicgenesis.com/',
    'LeapingWizards': 'http://leapingwizards.comicgenesis.com/',
    'LecheBotte': 'http://rastopopolus.comicgenesis.com/',
    'LeftAngle': 'http://theleftangle.comicgenesis.com/',
    'LegallyDeadMan': 'http://penultima.comicgenesis.com/',
    'Legendary': 'http://legendary.comicgenesis.com/',
    'LegendOfTheFour': 'http://legendoffour.comicgenesis.com/',
    'LegendOfThyme': 'http://midnightcat.comicgenesis.com/',
    'LegendOfTrinity': 'http://legendoftrinity.comicgenesis.com/',
    'LegionInc': 'http://legion.comicgenesis.com/',
    'LegostarGalactica': 'http://legostargalactica.comicgenesis.com/',
    'Leo': 'http://leoninecomics.comicgenesis.com/',
    'LessThanThree': 'http://lessthanthree.comicgenesis.com/',
    'LetThereBeLight': 'http://ltbl.comicgenesis.com/',
    'LeuAndYar': 'http://leunam12.comicgenesis.com/',
    'LibertysJewells': 'http://makdaddymizark.comicgenesis.com/',
    'LieToMe': 'http://lietome.comicgenesis.com/',
    'Lif3': 'http://lif3.comicgenesis.com/',
    'LifeAsSheKnowsIt': 'http://laski.comicgenesis.com/',
    'LifeAtBayside': 'http://bayside.comicgenesis.com/',
    'LifeGoesOn': 'http://lgo.comicgenesis.com/',
    'LifeIsUnfair': 'http://lifeisunfair.comicgenesis.com/',
    'LifeOfBuddha': 'http://lifeofbuddha.comicgenesis.com/',
    'LifeOfLars': 'http://lifeoflars.comicgenesis.com/',
    'LifeOfTheKalahari': 'http://lifeofthekalahari.comicgenesis.com/',
    'LifeOnForbez': 'http://cdc.comicgenesis.com/',
    'LifeOnTheFourthFloor': 'http://fourthfloorcomics.comicgenesis.com/',
    'LifesAWitch': 'http://lifesawitch.comicgenesis.com/',
    'LifeSuchAsItIs': 'http://lifesuchasitis.comicgenesis.com/',
    'LifeSucks': 'http://mdjt.comicgenesis.com/',
    'Lightbringer': 'http://lightbringer.comicgenesis.com/',
    'LikeItIs': 'http://likeitis.comicgenesis.com/',
    'LilDude': 'http://lildudecomics.comicgenesis.com/',
    'LilFas': 'http://lilfas.comicgenesis.com/',
    'LilFreddyVsMiniJason': ('http://fredvsjay.comicgenesis.com/', 'http://fredvsjay.comicgenesis.com/lateststrip.html'),
    'LilianeBiDyke': 'http://liliane.comicgenesis.com/',
    'LindleyHallProjectMk2': 'http://tlhp.comicgenesis.com/',
    'LingeringNight': 'http://lingeringnight.comicgenesis.com/',
    'Linnyanie': 'http://linnyanie.comicgenesis.com/',
    'LionDamhain': 'http://wyrd.comicgenesis.com/',
    'LittleStrangers': 'http://littlestrangers.comicgenesis.com/',
    'LittleVisconte': 'http://visconte.comicgenesis.com/',
    'LiveFromThe7ThCircle': 'http://seventhcircle.comicgenesis.com/',
    'LivingGallery': 'http://livinggallery.comicgenesis.com/',
    'Living': 'http://living.comicgenesis.com/',
    'Llamoo': 'http://llamoo.comicgenesis.com/',
    'Loath': 'http://loath.comicgenesis.com/',
    'LOGO': 'http://www.logocomic.com/',
    'Lola': 'http://lola.comicgenesis.com/',
    'LonelyWorlds': 'http://lonelyworlds.comicgenesis.com/',
    'LoneSwordsman': 'http://theloneswordsman.comicgenesis.com/',
    'LongestSojourn': 'http://longestsojourn.comicgenesis.com/',
    'LongestWalk': 'http://tlw.comicgenesis.com/',
    'LookIntoTheMind': 'http://litm.comicgenesis.com/',
    'LookWhatIBroughtHome': 'http://lookwhatibroughthome.com/',
    'LordOfTheShepherd': 'http://lots.comicgenesis.com/',
    'LordWhatFoolsTheseMortalsBe': 'http://lordwhatfools.comicgenesis.com/',
    'LostAndFound': 'http://www.lostandfoundcomic.com/',
    'Lounge': 'http://thelounge.comicgenesis.com/',
    'LoveMeNot': 'http://lovemenot.comicgenesis.com/',
    'LovesRequiem': 'http://lovesrequiem.comicgenesis.com/',
    'Lowroad75': 'http://lowroad75.comicgenesis.com/',
    'LucidDelirium': 'http://luciddelirium.comicgenesis.com/',
    'LucyTheGhost': 'http://lucytheghost.comicgenesis.com/',
    'Lumina': 'http://lumina.comicgenesis.com/',
    'Luna': 'http://www.lunacomic.com/',
    'LunaticChaos': 'http://lunaticchaos.comicgenesis.com/',
    'LususNaturae': 'http://lususnaturae.comicgenesis.com/',
    'MadAboutU': 'http://madaboutu.keenspot.com/',
    'MadBrothers': 'http://madbrothers.comicgenesis.com/',
    'MadeInHeaven': 'http://mih.comicgenesis.com/',
    'MadHatComics': 'http://madhat.comicgenesis.com/',
    'MadWorld': 'http://madworld.comicgenesis.com/',
    'Magick': 'http://magick.comicgenesis.com/',
    'MagusFerox': 'http://magusferox.comicgenesis.com/',
    'MakeshiftTheatreBrigade': 'http://makeshift.comicgenesis.com/',
    'Malcolm': 'http://www.malcolmcomics.com/',
    'Malefactor': 'http://malefactor.comicgenesis.com/',
    'MangoInDreamland': 'http://mango.comicgenesis.com/',
    'ManicGraffiti': 'http://manic.comicgenesis.com/',
    'ManorJam': 'http://manorjam.comicgenesis.com/',
    'MansionOfE': 'http://mansionofe.comicgenesis.com/',
    'MANTIS': 'http://mantis.comicgenesis.com/',
    'ManWhoHatesFun': 'http://mwhf.comicgenesis.com/',
    'ManyTidingsGrim': 'http://grimtidings.comicgenesis.com/',
    'Maq041': 'http://maq041.comicgenesis.com/',
    'MaraChan': 'http://marachan.comicgenesis.com/',
    'MarchingToADifferentAccordion': 'http://accordion.comicgenesis.com/',
    'MariposaRevelation': 'http://mariposa.comicgenesis.com/',
    'MartianTv': 'http://martiantv.comicgenesis.com/',
    'MarvAndBoop': 'http://marvandboop.comicgenesis.com/',
    'MaryComic': 'http://themarycomic.comicgenesis.com/',
    'MaryQuiteContrary': 'http://marycontrary.comicgenesis.com/',
    'MARYSTATUES': 'http://marystatues.comicgenesis.com/',
    'MaverickHeart': 'http://maverickheart.comicgenesis.com/',
    'MaxSloan': 'http://maxsloan.comicgenesis.com/',
    'MayIHelpYou': 'http://mayihelpyou.comicgenesis.com/',
    'McDuffies': 'http://mcduffies.comicgenesis.com/',
    'McremnantReport': 'http://mcrreport.comicgenesis.com/',
    'Medialia': 'http://www.medialia-comic.com/',
    'MediocreGothBoi': 'http://gothboi.comicgenesis.com/',
    'MediocreManga': 'http://mediocremanga.comicgenesis.com/',
    'Mediocres': 'http://mediocres.comicgenesis.com/',
    'MeetTheDweebles': 'http://dweebles.comicgenesis.com/',
    'MegaCrap': 'http://megacrap.comicgenesis.com/',
    'Meiosis': 'http://meiosis.comicgenesis.com/',
    'Melankoliasta': 'http://melankoliasta.comicgenesis.com/',
    'MelEveryman': 'http://everyman.comicgenesis.com/',
    'MelfTheElf': 'http://melf.comicgenesis.com/',
    'MemoirsOfAnImmortal': 'http://immortal.comicgenesis.com/',
    'Memories': 'http://squaz.comicgenesis.com/',
    'MenageA3': 'http://www.menagea3.net/',
    'Menagerie': 'http://menagerie.comicgenesis.com/',
    'MercsForHire': 'http://mercsforhire.comicgenesis.com/',
    'MichikoMonagatari': ('http://isukiyomi.comicgenesis.com/', 'http://isukiyomi.comicgenesis.com/index2.html'),
    'Midcentral': 'http://midcentral.comicgenesis.com/',
    'MidnightDetectives': 'http://midnightdetectives.comicgenesis.com/',
    'MikeTheMulletThing': 'http://mikethemulletthing.comicgenesis.com/',
    'MindingMyOwnBusiness': 'http://mmob.comicgenesis.com/',
    'MindOfAChild': 'http://tmoac.comicgenesis.com/',
    'MiniatureAlley': 'http://noctology.comicgenesis.com/',
    'MinimalismSucks': 'http://minisuck.comicgenesis.com/',
    'MinionsForHire': 'http://www.minionsforhire.com/',
    'MintWhelpSaga': 'http://mintwhelp.comicgenesis.com/',
    'MiryokutekiMonogatari': 'http://miryomono.comicgenesis.com/',
    'MisadventuresInPhysics': ('http://mip.comicgenesis.com/', 'http://mip.comicgenesis.com/comic.htm'),
    'MisadventuresOfOkk': 'http://okk.comicgenesis.com/',
    'MisadventuresOfTheDrowWizard': 'http://motdw.comicgenesis.com/',
    'Misanthropes': 'http://misanthropes.comicgenesis.com/',
    'MixedBagComics': 'http://lowresatari.comicgenesis.com/',
    'Mobties': 'http://mobties.comicgenesis.com/',
    'ModernDayWitchdoctor': 'http://witchdoctor.comicgenesis.com/',
    'ModernLove': 'http://modernlove.comicgenesis.com/',
    'MolesHole': 'http://l33tgamerz.comicgenesis.com/',
    'MolotovCocktail': 'http://molotovcocktail.comicgenesis.com/',
    'Monkey': 'http://monkey.comicgenesis.com/',
    'MonopolyOfTruth': 'http://monopolyoftruth.comicgenesis.com/',
    'MonsterAffen': 'http://monsteraffen.comicgenesis.com/',
    'MonsterVsTheWorld': 'http://monsterworld.comicgenesis.com/',
    'MooneyTheTurtle': 'http://jwcornelius.comicgenesis.com/',
    'MoonlightFeathers': 'http://moonfea.comicgenesis.com/',
    'MoonlightKnight': 'http://redmoons.comicgenesis.com/',
    'Morningstar': 'http://morningstar.comicgenesis.com/',
    'MortalitysEnd': 'http://mortalitysend.comicgenesis.com/',
    'MortalRevelation': 'http://mortalrevelation.comicgenesis.com/',
    'MouseOfTime': 'http://mouseoftime.comicgenesis.com/',
    'MousesTail': 'http://mouse.comicgenesis.com/',
    'Mp4C': 'http://mp4c.comicgenesis.com/',
    'MrBoffleAndFriends': 'http://mrboffle.comicgenesis.com/',
    'MTheory': 'http://mtheory.comicgenesis.com/',
    'Muertitos': 'http://muertitos.comicgenesis.com/',
    'MundaneNirvana': 'http://mundanenirvana.comicgenesis.com/',
    'MusicOfTheWoods': 'http://sumimasen.comicgenesis.com/',
    'Mutant59': 'http://wrathofautumn.comicgenesis.com/',
    'MyAngelYouAreAngel': ('http://angel.comicgenesis.com/', 'http://angel.comicgenesis.com/mainpage.html'),
    'MyBrainHurts': 'http://mybrainhurts.comicgenesis.com/',
    'MyLifeAsATeenageElvenMaid': 'http://mlaatem.comicgenesis.com/',
    'MyLifeInBlue': 'http://mylifeinblue.comicgenesis.com/',
    'MyRegards': 'http://myregards.comicgenesis.com/',
    'MySoCalledKnife': 'http://radewagon.comicgenesis.com/',
    'MysteriousDrX': 'http://obeydrx.comicgenesis.com/',
    'MysticFantasy': 'http://mysticfantasy.comicgenesis.com/',
    'MysticRevolution': 'http://mysticrevolution.comicgenesis.com/',
    'MythChild': 'http://mysya.comicgenesis.com/',
    'NahastLandsOfStrife': 'http://nahast.comicgenesis.com/',
    'NakedElf': 'http://nakedelf.comicgenesis.com/',
    'NamelessStory': 'http://klest.comicgenesis.com/',
    'NastyChocolates': 'http://nastychocolates.comicgenesis.com/',
    'Necronomicomics': 'http://necronomicomics.comicgenesis.com/',
    'NeedsMoreInspiration': 'http://needsmoreinspiration.comicgenesis.com/',
    'Neighborhood': 'http://neighborhood.comicgenesis.com/',
    'Nekotime': 'http://nekotime.comicgenesis.com/',
    'NemutionJewel': 'http://nemution.comicgenesis.com/',
    'Nerdgasm': 'http://nerdgasm.comicgenesis.com/',
    'NerdRage': 'http://nerdrage.comicgenesis.com/',
    'Netjeru': 'http://netjeru.comicgenesis.com/',
    'NeverYouMind': 'http://neveryoumind.comicgenesis.com/',
    'NewAndImproved': 'http://nai.comicgenesis.com/',
    'Newgirl': 'http://newgirl.comicgenesis.com/',
    'Newlife': 'http://birdie.comicgenesis.com/',
    'NEWPORTGRL55': 'http://newportgrl55.comicgenesis.com/',
    'Newscast': 'http://newscast.comicgenesis.com/',
    'NewtonsTheory': 'http://stevestacy.comicgenesis.com/',
    'NextDoor': 'http://nextdoor.comicgenesis.com/',
    'NickMaticPrivateEye': 'http://nickmatic.comicgenesis.com/',
    'NieceWeb': 'http://www.nieceweb.com/',
    'NighthawkDayhawk': 'http://nighthawkdayhawk.comicgenesis.com/',
    'NightmareHunters': 'http://nightmarehunters.comicgenesis.com/',
    'NightShiftWebComix': 'http://webcomix.comicgenesis.com/',
    'NinjaGirls': 'http://devonhibberd.comicgenesis.com/',
    'NinjaJohn': 'http://dangerchair.comicgenesis.com/',
    'Niunia': 'http://niunia.comicgenesis.com/',
    'NobTheBlob': 'http://nobtheblob.comicgenesis.com/',
    'NoCrap': 'http://nocrap.comicgenesis.com/',
    'Nocturnia': 'http://nocturnia.comicgenesis.com/',
    'NoiseInMyHead': 'http://nimh.comicgenesis.com/',
    'NoPinkPonies': 'http://www.nopinkponies.com/',
    'NoRoomForMagic': 'http://noroomformagic.com/',
    'NorthBy530': 'http://northby530.comicgenesis.com/',
    'NoSecondDateRequired': 'http://nsdr.comicgenesis.com/',
    'NosesOptional': 'http://nosesoptional.comicgenesis.com/',
    'NoSoapRadio': 'http://nosoapradio.comicgenesis.com/',
    'NosveRelease': 'http://nosve.comicgenesis.com/',
    'NothingComesNaturally': 'http://nocona.comicgenesis.com/',
    'NothingLikeSanity': 'http://nothinglikesanity.comicgenesis.com/',
    'NothingSpecial': 'http://nothingspecial.comicgenesis.com/',
    'NothingUnusual': 'http://nothingunusual.comicgenesis.com/',
    'NotQuiteHeroes': 'http://notquiteheroes.comicgenesis.com/',
    'NoVacancy': 'http://novacancy.comicgenesis.com/',
    'NowhereUniversity': 'http://nowhereu.comicgenesis.com/',
    'NthDimension': 'http://nthdimension.comicgenesis.com/',
    'NUCD': 'http://nucd.comicgenesis.com/',
    'NucleolusSuperheroCell': 'http://nucleolus.comicgenesis.com/',
    'NurseryRhymes': 'http://nrnm.comicgenesis.com/',
    'Nutcracker': 'http://nutcracker.comicgenesis.com/',
    'NyteFlyte': 'http://flyte.comicgenesis.com/',
    'NyuterranChronicles': 'http://www.nyuterra.com/',
    'ObsidianDawn': 'http://obsidiandawn.comicgenesis.com/',
    'ODARKCITY': 'http://odark.comicgenesis.com/',
    'OddsAndEnds': 'http://oddends.comicgenesis.com/',
    'OdysseyStar': 'http://odysseystar.comicgenesis.com/',
    'OffCampus': 'http://theoc.comicgenesis.com/',
    'OfficeBitch': 'http://picklejuice.comicgenesis.com/',
    'OhPanda': 'http://ohpanda.comicgenesis.com/',
    'OkayComics': 'http://okaycomics.comicgenesis.com/',
    'OldLadyAndTheTroll': ('http://scottmcd.comicgenesis.com/', 'http://scottmcd.comicgenesis.com/d/20070129.html'),
    'OMG': 'http://omg.comicgenesis.com/',
    'OnceUponAnAlmaMater': 'http://onceuponanalmamater.comicgenesis.com/',
    'OnceUponAStar': 'http://lonestar.comicgenesis.com/',
    'OnceUponATable': 'http://onatable.comicgenesis.com/',
    'OneHourComics': 'http://onehour.comicgenesis.com/',
    'OneOverZero': 'http://oneoverzero.comicgenesis.com/',
    'OnHiatus': 'http://onhiatus.comicgenesis.com/',
    'OnlyOnTuesdays': 'http://onlyontuesdays.comicgenesis.com/',
    'OnTheNose': 'http://lemonbar77.comicgenesis.com/',
    'OopsNevermind': 'http://www.nevermindcomic.com/',
    'OpenMinded': 'http://openminded.comicgenesis.com/',
    'OperationNEKO': 'http://operationneko.comicgenesis.com/',
    'OralSex': 'http://birdland.comicgenesis.com/',
    'OrangeArrow': 'http://orangearrow.comicgenesis.com/',
    'OrangeRevolution': 'http://orangerevolution.comicgenesis.com/',
    'OrcishSpam': 'http://orcishspam.comicgenesis.com/',
    'Origins': 'http://origins.comicgenesis.com/',
    'OurOddWorld': 'http://oddworld.comicgenesis.com/',
    'OurTripThruHell': 'http://phritzi.comicgenesis.com/',
    'OutOfCharacterComics': 'http://ooccomic.comicgenesis.com/',
    'OutOfOrder': 'http://outoforder.comicgenesis.com/',
    'OutOfTheLoops': 'http://theloops.comicgenesis.com/',
    'Overclocked': 'http://overclocked.comicgenesis.com/',
    'OverpoweredNoobs': 'http://overpowered.comicgenesis.com/',
    'Owlie': 'http://owliecomics.com/',
    'Palestra': 'http://palestra.comicgenesis.com/',
    'Pals': 'http://pals.comicgenesis.com/',
    'Pandala': 'http://pandala.comicgenesis.com/',
    'PANDECT': 'http://pandect.comicgenesis.com/',
    'PANDORA': 'http://pandoranohako.comicgenesis.com/',
    'Panic7': 'http://panic7.comicgenesis.com/',
    'PanicHighSchool': 'http://panichighschool.comicgenesis.com/',
    'Pantheon': 'http://www.pantheoncomic.com/',
    'PantsOfDeath': 'http://pantsofdeath.comicgenesis.com/',
    'Papercut': 'http://cdrake.comicgenesis.com/',
    'ParallelDementia': 'http://paralleldementia.comicgenesis.com/',
    'PartiallyIndebted': 'http://partiallyindebted.comicgenesis.com/',
    'PatchworkChampions': 'http://yeti.comicgenesis.com/',
    'Patchwork': 'http://patchwork.comicgenesis.com/',
    'Patheticity': 'http://patheticity.comicgenesis.com/',
    'PCsDayOut': 'http://pc.keenspot.com/',
    'PeabodyComics': 'http://peabody.comicgenesis.com/',
    'PeaceKeeperForce': 'http://www.thepkf.com/',
    'Peno': 'http://peno.comicgenesis.com/',
    'PeopleIHate': 'http://peopleihate.comicgenesis.com/',
    'PerfectRoll': 'http://morbidfreak.comicgenesis.com/',
    'Perjury': 'http://perjury.comicgenesis.com/',
    'PestProductions': 'http://pestproductions.comicgenesis.com/',
    'PET': 'http://petcomic.comicgenesis.com/',
    'PhatypusProductions': 'http://random.comicgenesis.com/',
    'PhillerSpace': 'http://phillerspace.comicgenesis.com/',
    'PhilLikesTacos': 'http://philtaco.comicgenesis.com/',
    'PhilosophyMonkey': 'http://philosophymonkey.comicgenesis.com/',
    'PhineusMagicianForHire': 'http://phinmagic.comicgenesis.com/',
    'Picatrix': 'http://picatrix.comicgenesis.com/',
    'PictureDiary': 'http://thepicturediary.comicgenesis.com/',
    'PillarsOfFaith': 'http://pillarsoffaith.comicgenesis.com/',
    'PILL': 'http://nurseangel.comicgenesis.com/',
    'Pineys': 'http://pineys.comicgenesis.com/',
    'PinkyTa': 'http://ozoneocean.comicgenesis.com/',
    'PiratesVsVikings': 'http://piratesvsvikings.comicgenesis.com/',
    'PiresAway': 'http://piresaway.comicgenesis.com/',
    'PkersUnited': 'http://pkersunited.comicgenesis.com/',
    'PlagueGround': 'http://plagueground.comicgenesis.com/',
    'PlayingWithKnives': 'http://pwk.comicgenesis.com/',
    'PlotlessViolence': 'http://plotlessviolence.comicgenesis.com/',
    'PluggedNickel': 'http://pluggednickel.comicgenesis.com/',
    'PockyOfJustice': 'http://poj.comicgenesis.com/',
    'Poesy': 'http://poesy.comicgenesis.com/',
    'PointGuardian': 'http://www.pointguardian.com/',
    'Pointless': 'http://pointless.comicgenesis.com/',
    'PointsAtRandom': 'http://clubpar.comicgenesis.com/',
    'PokeChow': 'http://blueguy.comicgenesis.com/',
    'PokemonX': 'http://pokemonx.comicgenesis.com/',
    'PonderAndEnlightening': 'http://pande.comicgenesis.com/',
    'PoorlyDrawn': 'http://poorlydrawn.comicgenesis.com/',
    'PowerStalkers': 'http://powerstalkers.comicgenesis.com/',
    'Pr0Ncrest': 'http://pr0ncrest.comicgenesis.com/',
    'PrepareForTomorrow': 'http://preparefortomorrow.comicgenesis.com/',
    'PrimeOfAmbition': 'http://jaadrih.comicgenesis.com/',
    'PrimordialChaos': 'http://shianra.comicgenesis.com/',
    'PrinceOfCastles': 'http://princeofcastles.comicgenesis.com/',
    'Prismatic': 'http://prismatic.comicgenesis.com/',
    'PrismaticVodka': 'http://drunkenscribblings.comicgenesis.com/',
    'PrivateSchoolBoys': 'http://ethancerin.comicgenesis.com/',
    'ProbabilityOfStupidity': 'http://nutpos.comicgenesis.com/',
    'ProfessionalThievery': 'http://pthievery.comicgenesis.com/',
    'Project5': 'http://project5.comicgenesis.com/',
    'ProjectADAM': 'http://themortician.comicgenesis.com/',
    'ProjectB': 'http://projectb.comicgenesis.com/',
    'ProjectSeraph': 'http://projectseraph.comicgenesis.com/',
    'ProjectWhatever': 'http://projectwhatever.comicgenesis.com/',
    'ProjectY': 'http://zaphin.comicgenesis.com/',
    'PropertyOfGwen': 'http://propertyofgwen.comicgenesis.com/',
    'Psionika': 'http://premier666.comicgenesis.com/',
    'Psiotechniqa': 'http://psitech.comicgenesis.com/',
    'PsychoticDesires': 'http://psychoticdesires.comicgenesis.com/',
    'PsychoticKiss': 'http://psychotickiss.comicgenesis.com/',
    'PulpHeroes': 'http://pulpheroes.comicgenesis.com/',
    'Puppetry': 'http://wordsandpictures.comicgenesis.com/',
    'Purgatory': 'http://cocytuz.comicgenesis.com/',
    'PurplePussy': 'http://www.purplepussy.net/',
    'PursuitOfThePast': 'http://pursuit.comicgenesis.com/',
    'PwushChronicles': 'http://pwush.comicgenesis.com/',
    'Pylon': 'http://pylon.comicgenesis.com/',
    'QueenOfWands': 'http://www.queenofwands.net/',
    'QueensOfRandomness': 'http://marshmallow.comicgenesis.com/',
    'Queer': 'http://queer.comicgenesis.com/',
    'QuestForTheHolyStrawberry': 'http://bart.comicgenesis.com/',
    'Quest': 'http://quest.comicgenesis.com/',
    'QuickBiteMe': 'http://quickbiteme.comicgenesis.com/',
    'QuittingTime': 'http://quitting-time.com/',
    'RadsFilesRanosSeries': 'http://radsfilesranos.comicgenesis.com/',
    'RagingChinchilla': 'http://rcch.comicgenesis.com/',
    'RagnarokOnlife': 'http://ragnarokonlife.comicgenesis.com/',
    'Ragtag': 'http://ragtag.comicgenesis.com/',
    'RallyHippo': 'http://annie.comicgenesis.com/',
    'RandomAssembly': 'http://randomassembly.comicgenesis.com/',
    'RandomChocolate': 'http://randomchocolate.comicgenesis.com/',
    'Randomity': 'http://bandoffour.comicgenesis.com/',
    'RandomReality': 'http://randomreality.comicgenesis.com/',
    'RandomThoughts': 'http://randomthoughtscomics.comicgenesis.com/',
    'RandyTheCat': 'http://randythecat.comicgenesis.com/',
    'Rangers': 'http://rangers.comicgenesis.com/',
    'RapidEyeMovement': 'http://rem.comicgenesis.com/',
    'RauchVorFeuer': 'http://rauchvorfeuer.comicgenesis.com/',
    'RaveKitty': 'http://ravekitty.comicgenesis.com/',
    'RayzorComicsAndChrisChrushercomix': 'http://rayzor.comicgenesis.com/',
    'READITANDWEEP': 'http://readitandweep.comicgenesis.com/',
    'ReadyOrNot': 'http://ron.comicgenesis.com/',
    'ReadySetRetreat': 'http://breakdance.comicgenesis.com/',
    'ReadyWit': 'http://witsend.comicgenesis.com/',
    'RealFantasy': 'http://realfantasy.comicgenesis.com/',
    'RealityChallenged': 'http://insearchofdreams.comicgenesis.com/',
    'RealityStream': 'http://stream.comicgenesis.com/',
    'RealmOfKaerwyn': 'http://kaerwyn.comicgenesis.com/',
    'ReasonedCognition': 'http://www.reasonedcognition.com/',
    'ReasonImEverythingYouWant': 'http://everythingyouwant.comicgenesis.com/',
    'RecklessYouth': 'http://recklessyouth.comicgenesis.com/',
    'Reclamation': 'http://reclamation.comicgenesis.com/',
    'RedLexi': 'http://redlexi.comicgenesis.com/',
    'RedTape': 'http://redtape.comicgenesis.com/',
    'ReflectionsThroughAWarpedMind': 'http://rtwm.comicgenesis.com/',
    'Remembrance': 'http://remembrance.comicgenesis.com/',
    'Reporterz': 'http://reporterz.comicgenesis.com/',
    'ResetButton': 'http://theresetbutton.comicgenesis.com/',
    'ResistanceLine': 'http://resistanceline.comicgenesis.com/',
    'RetrogressiveIndexingAndFiling': 'http://spools.comicgenesis.com/',
    'ReturnToEden': 'http://returntoeden.comicgenesis.com/',
    'Reveillerie': 'http://hootoo.comicgenesis.com/',
    'RidingTheMediumBus': 'http://pencilears.comicgenesis.com/',
    'Rifles': 'http://marshcomics.comicgenesis.com/',
    'RingsOfFate': 'http://angelzash.comicgenesis.com/',
    'Riot': 'http://riotoffee.comicgenesis.com/',
    'RIPNormality': 'http://ripnormality.comicgenesis.com/',
    'RitasComic': 'http://ritascomic.comicgenesis.com/',
    'RituallyImpaired': 'http://crowskin.comicgenesis.com/',
    'RobmanShow': 'http://therobmanshow.comicgenesis.com/',
    'RogerAndDominic': 'http://roganddom.comicgenesis.com/',
    'RoguesOfClwydRhan': 'http://rocr.comicgenesis.com/',
    'RoleOfTheDie': 'http://www.roleofthedie.com/',
    'Room': 'http://theroom.comicgenesis.com/',
    'RoswellNewton': 'http://roswellnewton.comicgenesis.com/',
    'Roughies': 'http://www.roughies.com/',
    'RowAndBee': 'http://rowbee.comicgenesis.com/',
    'RoxxorUniversity': 'http://roxxoru.comicgenesis.com/',
    'RoxyComicBookSuperhero': 'http://roxycomic.comicgenesis.com/',
    'RoyalBlue': 'http://royalblue.comicgenesis.com/',
    'RPGWorld': 'http://www.rpgworldcomic.com/',
    'RTPM': 'http://rtpm.comicgenesis.com/',
    'RubyPearl': 'http://rubypearl.comicgenesis.com/',
    'RueTheDay': 'http://ruetheday.comicgenesis.com/',
    'Ruination': 'http://ruination.comicgenesis.com/',
    'RumfAdventures': 'http://rumfus.comicgenesis.com/',
    'SacredGround': 'http://sground.comicgenesis.com/',
    'Sadama': 'http://sadama.comicgenesis.com/',
    'SadismOfAStudent': 'http://rynnadragonheart.comicgenesis.com/',
    'SagaOfGager': 'http://gager.comicgenesis.com/',
    'SaigoNoDensetsuLastLegend': 'http://saigo.comicgenesis.com/',
    'SamAndElisAdventures': 'http://sameliadv.comicgenesis.com/',
    'Sam': 'http://sam.keenspot.com/',
    'SamuraiMushroom': 'http://samuraimushroom.comicgenesis.com/',
    'Sandgate': 'http://sandgate.comicgenesis.com/',
    'Sandusky': 'http://sandusky.comicgenesis.com/',
    'SandwichWorld': 'http://sandwichworld.comicgenesis.com/',
    'Sanitarium3': 'http://san3.comicgenesis.com/',
    'SasjhwasStudio': 'http://sasjhwa.comicgenesis.com/',
    'SaturdayMorningBreakfastCereal': 'http://smbc.comicgenesis.com/',
    'SavannDuh': 'http://savannduh.comicgenesis.com/',
    'SaveUsProcrastinatron': 'http://procrastinatron.comicgenesis.com/',
    'SaveVsMagic': 'http://svmagic.comicgenesis.com/',
    'ScandalSheet': 'http://scandalsheet.comicgenesis.com/',
    'Scarecrow': 'http://scarecrow.comicgenesis.com/',
    'ScaryLittleRyn': 'http://scarylittleryn.comicgenesis.com/',
    'Scatterplot': 'http://scatterplot.comicgenesis.com/',
    'ScentOfASong': 'http://scentofasong.comicgenesis.com/',
    'Schadenfreude': 'http://xschadenfreude.comicgenesis.com/',
    'ScrantonvilleKids': 'http://scrantonvillekids.keenspot.com/',
    'Scratch': 'http://rene.comicgenesis.com/',
    'ScrewJeffOwens': 'http://screwjeffowens.comicgenesis.com/',
    'ScrollDynasty': 'http://scrolldynasty.comicgenesis.com/',
    'Scrued': 'http://www.scrued.com/',
    'Seagate': 'http://seatgate.comicgenesis.com/',
    'SecondStage': 'http://secondstage.comicgenesis.com/',
    'SemiRealTales': 'http://semirealtales.comicgenesis.com/',
    'Senioritis': 'http://senioritis.comicgenesis.com/',
    'SequelLife': 'http://sequellife.comicgenesis.com/',
    'SeriesOfFortunateEvents': 'http://fortunateevents.comicgenesis.com/',
    'SerifFearTheDot': 'http://fearthedot.comicgenesis.com/',
    'SeriouslySuzy': 'http://suzy.comicgenesis.com/',
    'SerpentsInnocence': 'http://halcogeth.comicgenesis.com/',
    'Seven': 'http://eris.comicgenesis.com/',
    'SevenOfSpades': 'http://sevenofspades.comicgenesis.com/',
    'SeventhSoldier': 'http://kirbythestampede.comicgenesis.com/',
    'SexAndViolence': 'http://mrbang.net/',
    'SexLiesAndFord': 'http://slaf.comicgenesis.com/',
    'SexPercussions': 'http://sexpercussions.comicgenesis.com/',
    'ShadowPlanet': 'http://shadowplanet.comicgenesis.com/',
    'Shaman': 'http://graphicpamphleteer.comicgenesis.com/',
    'SharingAUniverse': 'http://sharingauniverse.comicgenesis.com/',
    'Sharper': 'http://sharper.comicgenesis.com/',
    'ShelbyAndPenguin': 'http://shelbyandpenguin.comicgenesis.com/',
    'Shenanigans': 'http://shenanigans.comicgenesis.com/',
    'Shifters': 'http://shifters.comicgenesis.com/',
    'ShineGetDumplingsGoGoTower': 'http://shinegotower.comicgenesis.com/',
    'Shinseki': 'http://shinseki.comicgenesis.com/',
    'Shmorky': 'http://www.shmorky.com/',
    'ShonenAiKudasai': 'http://kudasai.stripspace.com/',
    'ShortEnd': 'http://theshortend.comicgenesis.com/',
    'Shrooms': 'http://shrooms.comicgenesis.com/',
    'Shy': ('http://shy.comicgenesis.com/', 'http://shy.comicgenesis.com/welcome.htm'),
    'SideEffects': 'http://sideeffects.comicgenesis.com/',
    'SidekickForSale': 'http://sidekickforsale.comicgenesis.com/',
    'Sidenote': 'http://ntc.comicgenesis.com/',
    'SiegelDerDoppelseele': 'http://siegel.comicgenesis.com/',
    'SillyScriptures': 'http://scriptures.comicgenesis.com/',
    'SilverBirchForest': 'http://tsbf.comicgenesis.com/',
    'SilveryCentipede': ('http://silverycentipede.keenspot.com/', 'http://silverycentipede.keenspot.com/d/20000428.html'),
    'Silvette': 'http://silvette.comicgenesis.com/',
    'SimpleMinded': 'http://simpleminded.comicgenesis.com/',
    'Simpletown': 'http://simpletown.comicgenesis.com/',
    'Simplistk': 'http://rechan.comicgenesis.com/',
    'SinisterBedfellows': 'http://mckenzee.comicgenesis.com/',
    'SinkOrDrown': 'http://sinkordrown.comicgenesis.com/',
    'SinPerspectiva': 'http://mysp.comicgenesis.com/',
    'SinsAgainstNature': 'http://sane.comicgenesis.com/',
    'SippansSerie': 'http://sippan.comicgenesis.com/',
    'SiteMap': 'http://sitemap.comicgenesis.com/',
    'SixDragons': 'http://sixdragons.comicgenesis.com/',
    'SixSeconds': 'http://sixseconds.comicgenesis.com/',
    'SkardOneInc': 'http://skardoneinc.comicgenesis.com/',
    'Sketchbook': 'http://sss.comicgenesis.com/',
    'SkewedReality': ('http://skewedreality.comicgenesis.com/', 'http://skewedreality.comicgenesis.com/home.html'),
    'SkirtingDanger': 'http://skirtingdanger.keenspot.com/',
    'Skunkadoo': 'http://skunkadoo.comicgenesis.com/',
    'Skunk': 'http://www.skunkcomic.com/',
    'SLAYERSREWIND': 'http://wyldcherry.comicgenesis.com/',
    'SmallestCoherentSliceOfInfinity': 'http://scsoi.comicgenesis.com/',
    'Smitty': 'http://smitty.comicgenesis.com/',
    'Snapshot': 'http://chibchub.comicgenesis.com/',
    'SnowflakeStudios': 'http://snowflakestudios.comicgenesis.com/',
    'SoapOnARope': 'http://www.soaprope.com/',
    'SoccerIsFullOfCheese': 'http://soccercheese.comicgenesis.com/',
    'SocializedMedicine': 'http://socializedmedicine.comicgenesis.com/',
    'Sockd': 'http://www.sockd.com/',
    'SodapopJunkies': 'http://sodapopjunkies.comicgenesis.com/',
    'SoilentIndustriesInc': 'http://soilent.comicgenesis.com/',
    'SoKeiItHurts': 'http://sokeiithurts.comicgenesis.com/',
    'Solipsism': 'http://solipsism.comicgenesis.com/',
    'SomeplaceElse': 'http://someplace.comicgenesis.com/',
    'SomethingStrange': 'http://somethingstrange.comicgenesis.com/',
    'SomewhereCalledHemel': 'http://hemel.comicgenesis.com/',
    'SomewhereIBelong': 'http://zhongda.comicgenesis.com/',
    'SoreThumbs': 'http://www.sorethumbsonline.com/',
    'SouthSprings': 'http://southsprings.comicgenesis.com/',
    'SoWhat': 'http://sowhat.comicgenesis.com/',
    'SpaceTimeFunnies': 'http://spacetimefunnies.comicgenesis.com/',
    'Spacial': 'http://spacial.comicgenesis.com/',
    'SpareChange': 'http://sparechange.comicgenesis.com/',
    'Special': 'http://special.comicgenesis.com/',
    'SpellBinder': ('http://wizard.comicgenesis.com/', 'http://wizard.comicgenesis.com/mainpage.html'),
    'SpiderBubblegum': 'http://spiderbubblegum.comicgenesis.com/',
    'SplendiforousEscapades': 'http://splendiforous.comicgenesis.com/',
    'SporkMan': 'http://www.sporkman.com/',
    'SpqrBlues': 'http://spqrblues.comicgenesis.com/',
    'SpritevilleUSA': 'http://spriteville.comicgenesis.com/',
    'SPUG': 'http://spug.comicgenesis.com/',
    'SquareAndRhomboid': 'http://sar.comicgenesis.com/',
    'SquidGideon': 'http://silus.comicgenesis.com/',
    'SquidNinja': 'http://www.squidninja.com/',
    'SsComix': 'http://sscomix.comicgenesis.com/',
    'SSDD': 'http://poisonedminds.com/',
    'StagnantWaters': 'http://stagnantwaters.comicgenesis.com/',
    'Stalag99': 'http://www.stalag99.net/',
    'StaleChocolates': 'http://stalechocolates.comicgenesis.com/',
    'StalkingMillionaries': 'http://packrat.comicgenesis.com/',
    'StalkingSnape': 'http://snape.comicgenesis.com/',
    'Starbooze': 'http://starbooze.comicgenesis.com/',
    'StarBored': 'http://oosterwijk.comicgenesis.com/',
    'StarshipMoonhawk': 'http://starshipmoonhawk.comicgenesis.com/',
    'StartWreck': 'http://startwreck.comicgenesis.com/',
    'Steamcrows': 'http://eldritch48.comicgenesis.com/',
    'StephanieToTheMax': 'http://stephanietothemax.comicgenesis.com/',
    'StepTooFar': 'http://asoftercore.comicgenesis.com/',
    'SteveAndMac': 'http://steveandmac.comicgenesis.com/',
    'STFU': 'http://stfu.comicgenesis.com/',
    'StickFigureDragons': 'http://feychild.comicgenesis.com/',
    'Stick': 'http://stick.comicgenesis.com/',
    'StickmenFromHell': 'http://hellstick.comicgenesis.com/',
    'Stillville': 'http://stillville.comicgenesis.com/',
    'StolenWish': 'http://kimhura.comicgenesis.com/',
    'StraightAhead': 'http://straightahead.comicgenesis.com/',
    'StraightJacketFreedomForce': 'http://tsjff.comicgenesis.com/',
    'StrangeCandy': 'http://www.strangecandy.net/',
    'StrangeDaze': 'http://strangedaze.comicgenesis.com/',
    'StrangeEmployment': 'http://strangeemployment.comicgenesis.com/',
    'StrangeHappenings': 'http://strangehappenings.comicgenesis.com/',
    'StreetsWeCallTheZoo': 'http://streets.comicgenesis.com/',
    'StripErs': 'http://stripers.comicgenesis.com/',
    'StrippedAgain': 'http://strippedagain.comicgenesis.com/',
    'Striptease': 'http://www.stripteasecomic.com/',
    'StubbsComics': 'http://stubbscomics.comicgenesis.com/',
    'StuffOfLegends': 'http://stuffoflegends.comicgenesis.com/',
    'Styx': 'http://ziggys.comicgenesis.com/',
    'Subconscious': 'http://subconscious.comicgenesis.com/',
    'SubliminalObsession': 'http://subliminalobsession.comicgenesis.com/',
    'Subplot': 'http://reashi.comicgenesis.com/',
    'SubstituteClassImago': 'http://sci.comicgenesis.com/',
    'SuburbanJungle': 'http://www.suburbanjungle.com/',
    'SuburbanSaints': 'http://suburbansaints.comicgenesis.com/',
    'SuicidalKillers': 'http://suicidalkillers.comicgenesis.com/',
    'SuicideForHire': 'http://suicideforhire.comicgenesis.com/',
    'SummerRain': 'http://summerrain.comicgenesis.com/',
    'Summoners': 'http://summoners.comicgenesis.com/',
    'SundaeConnection': 'http://sundaeconnection.comicgenesis.com/',
    'SunlessMorning': 'http://allegory42.comicgenesis.com/',
    'SuperChibiDeathBots': 'http://scdb.comicgenesis.com/',
    'Superfightfight': 'http://superfightfight.comicgenesis.com/',
    'SuperFinalFantasyMarioWorld': 'http://sffmw.comicgenesis.com/',
    'SuperheroSportsBar': 'http://superbar.comicgenesis.com/',
    'SuperPeoples': 'http://superpeoples.comicgenesis.com/',
    'SuperSmashInn': 'http://supersmashinn.comicgenesis.com/',
    'SuperTeenAngst': 'http://superteenangst.comicgenesis.com/',
    'SuperTemps': 'http://megaskunjii.comicgenesis.com/',
    'Superzero': 'http://superzerocomic.comicgenesis.com/',
    'SurrealKins': 'http://www.surreal-kins.com/',
    'SushiComics': 'http://sushi.comicgenesis.com/',
    'SushiDatabase': 'http://sushidatabase.comicgenesis.com/',
    'SwordsAreCool': 'http://gunsnstuff.comicgenesis.com/',
    'TABU': 'http://tabu.comicgenesis.com/',
    'TacosGoHere': 'http://thetacosgohere.comicgenesis.com/',
    'TacoTuesday': 'http://tacotuesdays.comicgenesis.com/',
    'Taffyhat': 'http://taffyhat.comicgenesis.com/',
    'TailsOfIxinia': 'http://nalkari.comicgenesis.com/',
    'Tainted': 'http://tainted.comicgenesis.com/',
    'TaintedTruth': 'http://taintedtruth.comicgenesis.com/',
    'TakeSteveToSchool': 'http://takestevetoschool.comicgenesis.com/',
    'TakingUpSpace': 'http://takingupspace.keenspot.com/',
    'TalesOfAReceptionist': 'http://toar.comicgenesis.com/',
    'TalesOfEpicProportion': 'http://linzmerica.comicgenesis.com/',
    'TalesOfPylea': 'http://talesofpylea.comicgenesis.com/',
    'TalesOfTheDark': 'http://talesofthedark.comicgenesis.com/',
    'TangsWeeklyComic': 'http://tang.comicgenesis.com/',
    'Tankd': 'http://tanked.comicgenesis.com/',
    'Tansocks': 'http://tansocks.comicgenesis.com/',
    'TarAndFeathers': 'http://tarandfeathers.comicgenesis.com/',
    'Tari': 'http://tari.comicgenesis.com/',
    'Tartarus': 'http://tartarus.comicgenesis.com/',
    'TAVision': 'http://tav.comicgenesis.com/',
    'TeaCastle': 'http://teacastle.comicgenesis.com/',
    'TeacosiesWithIrony': 'http://teacosieswithirony.comicgenesis.com/',
    'TeacosiesWithIronyLP': 'http://teacosieswithironylargeprint.comicgenesis.com/',
    'TeamZodiak': 'http://teamzodiak.comicgenesis.com/',
    'TeddyBearAntiChrist': 'http://tbac.comicgenesis.com/',
    'TeeDubbleyuEffSee': 'http://twfc.comicgenesis.com/',
    'Tehuti': ('http://tehuti.comicgenesis.com/', 'http://tehuti.comicgenesis.com/index2.html'),
    'TemuranMyLove': 'http://dhqx.comicgenesis.com/',
    'TeriyakiSavior': 'http://lunaticrage.comicgenesis.com/',
    'TharanFayth': 'http://tharanfayth.comicgenesis.com/',
    'Thatguy': 'http://thatguy.comicgenesis.com/',
    'TheKitchenSink': 'http://thekitchensink.comicgenesis.com/',
    'TheLiving': 'http://theliving.comicgenesis.com/',
    'ThereIsNoCheese': 'http://nocheese.comicgenesis.com/',
    'ThereMayBeNinjas': 'http://tmbn.comicgenesis.com/',
    'TheresACivilizationOnMyFork': 'http://www.tacomf.com/',
    'TheriThere': 'http://therithere.comicgenesis.com/',
    'Thespiphobia': 'http://thespiphobia.comicgenesis.com/',
    'ThinginessOfChaos': 'http://thinginess.comicgenesis.com/',
    'ThingInTheGrass': 'http://thinginthegrass.comicgenesis.com/',
    'ThirdCity': 'http://cityonedge.comicgenesis.com/',
    'ThirdDementia': 'http://thirddementia.comicgenesis.com/',
    'ThirteenthMonth': 'http://thethirteenthmonth.comicgenesis.com/',
    'ThisIs': 'http://cwcomics.comicgenesis.com/',
    'ThisISLife': 'http://thisislife.comicgenesis.com/',
    'ThisSideUp': 'http://tsu.comicgenesis.com/',
    'ThisWeeksAdventureInPerth': 'http://twaip.comicgenesis.com/',
    'ThoroughlyUseless': 'http://thoroughlyuseless.comicgenesis.com/',
    'Thoughts': 'http://thoughts.comicgenesis.com/',
    'TieGuy': 'http://tieguy.comicgenesis.com/',
    'Tightsight': 'http://tightsight.comicgenesis.com/',
    'Tile': 'http://tile.comicgenesis.com/',
    'TimePig': 'http://timepig.comicgenesis.com/',
    'Timmy': 'http://timmy.keenspot.com/',
    'TipOfTheSword': 'http://tipofthesword.comicgenesis.com/',
    'TitlePending': 'http://titlepend.comicgenesis.com/',
    'ToddAndPenguin': 'http://www.toddandpenguin.com/',
    'ToLightYourWay': 'http://badlydubbed.comicgenesis.com/',
    'TonjaSteele': 'http://tonjasteele.comicgenesis.com/',
    'Toolshed': 'http://toolshed.comicgenesis.com/',
    'ToonPimpsPalace': 'http://mhitmand.comicgenesis.com/',
    'TorchlightShootout': 'http://tlso.comicgenesis.com/',
    'Torio': 'http://torio.comicgenesis.com/',
    'TORMENT': 'http://torment.comicgenesis.com/',
    'Tove': 'http://tove.comicgenesis.com/',
    'Towner': ('http://towner.comicgenesis.com/', 'http://towner.comicgenesis.com/d/20070603.html'),
    'TracyAndTristan': 'http://tandt.comicgenesis.com/',
    'Transaction': 'http://transaction.comicgenesis.com/',
    'Transplant': 'http://transplant.comicgenesis.com/',
    'TreadingGround': 'http://treadingground.comicgenesis.com/',
    'TreasureHunters': 'http://treasurehunters.keenspot.com/',
    'TreeSprocket': 'http://treesprocket.comicgenesis.com/',
    'TrentTheEmogoth': 'http://lifeispain.comicgenesis.com/',
    'TrialAndError': 'http://trialanderror.comicgenesis.com/',
    'TrialsInTheLight': 'http://trials.comicgenesis.com/',
    'Triggerpoint': 'http://triggerpoint.comicgenesis.com/',
    'TrikeEpoch': 'http://trikeepoch.comicgenesis.com/',
    'TrilinkSaga': 'http://trilink.comicgenesis.com/',
    'TripleTrouble': 'http://tripletrouble.comicgenesis.com/',
    'TriquetraCats': 'http://triquetracats.comicgenesis.com/',
    'TriumphantLosers': 'http://triumphantlosers.comicgenesis.com/',
    'TrueBums': 'http://truebums.comicgenesis.com/',
    'TrueGroove': 'http://truegroove.comicgenesis.com/',
    'TupmansTheater': 'http://tupmans.comicgenesis.com/',
    'TurboNinjaBastard': 'http://tnb.comicgenesis.com/',
    'TurboTrak': 'http://turbotrak.comicgenesis.com/',
    'TuringsFollyII': 'http://proteancomics.comicgenesis.com/',
    'TwiceDestined': 'http://twicedestined.comicgenesis.com/',
    'Twilight': 'http://zilelabelle.comicgenesis.com/',
    'TwilightOfASorceress': 'http://kenjiandmokoto.comicgenesis.com/',
    'TwistedTales': 'http://www.jastiv.com/',
    'TwobitHeros': 'http://twobitheros.comicgenesis.com/',
    'TwoEvilScientists': 'http://twoevilscientists.comicgenesis.com/',
    'TwoLumps': 'http://www.twolumps.net/',
    'TypeMismatch': 'http://typemismatch.comicgenesis.com/',
    'UberBean': 'http://theuberbean.comicgenesis.com/',
    'UbergeekSpriteWorld': 'http://www.ubergeekthecomic.com/',
    'UglyGirl': 'http://nanda.comicgenesis.com/',
    'UltimateAsshole': 'http://ultimateasshole.keenspot.com/',
    'UmlautHouse': 'http://umlauthouse.comicgenesis.com/',
    'UnbreakblePromises': 'http://unbreakablepromises.comicgenesis.com/',
    'UncertaintyPrinciple': 'http://uncertaintyprinciple.comicgenesis.com/',
    'UnchronologicalChroniclesOfFrank': 'http://joelathon.comicgenesis.com/',
    'UndeadFriend': 'http://www.undeadfriend.com/',
    'UnfamiliarReflection': 'http://emri.comicgenesis.com/',
    'UnfunnyComputerFunnies': 'http://unfunny.comicgenesis.com/',
    'Uni': 'http://uni.comicgenesis.com/',
    'UnityARockstarSaga': 'http://elementalseekers.comicgenesis.com/',
    'UnknownDarkness': 'http://unknowndarkness.comicgenesis.com/',
    'UnknownSuperheroes': 'http://unknownheroes.comicgenesis.com/',
    'UnlifeOnline': 'http://unlifeonline.comicgenesis.com/',
    'UnoTheAlien': 'http://unothealien.comicgenesis.com/',
    'UnrealCity': 'http://unrealcity.comicgenesis.com/',
    'UnrealityCheck': 'http://unrealitycheck.comicgenesis.com/',
    'Unrepentant': 'http://whyyy.comicgenesis.com/',
    'UnsteadyEddie': 'http://steadyeddie.comicgenesis.com/',
    'Untitled': 'http://untitled.comicgenesis.com/',
    'UntitledLoveSong': 'http://west.comicgenesis.com/',
    'Untouchables': 'http://untouchables.comicgenesis.com/',
    'Upheaval': 'http://upheaval.comicgenesis.com/',
    'UrbanFable': 'http://urbanfable.comicgenesis.com/',
    'UsagiNoMori': 'http://usaginomori.comicgenesis.com/',
    'Users': 'http://users.comicgenesis.com/',
    'UsersVsUsers': 'http://usersvsusers.comicgenesis.com/',
    'Vaeille': 'http://fox.comicgenesis.com/',
    'VaguelyAmazing': 'http://vaguelyamazing.comicgenesis.com/',
    'ValkyrieSymphony': 'http://allegranova.comicgenesis.com/',
    'Valrar': 'http://valrar.comicgenesis.com/',
    'VampiresCurse': 'http://vampire.comicgenesis.com/',
    'VaporLock': 'http://vaporlock.comicgenesis.com/',
    'Veena': 'http://veena.comicgenesis.com/',
    'VengeanceAndWrath': 'http://vengeanceandwrath.comicgenesis.com/',
    'VenusAscending': 'http://catgirldo.comicgenesis.com/',
    'VenusEnvy': 'http://venusenvy.comicgenesis.com/',
    'VermilionCage': 'http://vermilioncage.comicgenesis.com/',
    'VerySpaceyDrama': 'http://spaceydrama.comicgenesis.com/',
    'VetoXZahi': 'http://vetoxzahi.comicgenesis.com/',
    'VicAndEdwards': 'http://vicandedwards.comicgenesis.com/',
    'VictorianTimes': 'http://victorian.comicgenesis.com/',
    'Victory': 'http://victoryman.comicgenesis.com/',
    'Vikodin': 'http://vikodin.comicgenesis.com/',
    'VirtualRodeo': 'http://virtualrodeo.comicgenesis.com/',
    'Void': 'http://angrypotatostudios.comicgenesis.com/',
    'VolatileMachinations': 'http://volatilemachinations.comicgenesis.com/',
    'Volet': 'http://volet.comicgenesis.com/',
    'Vreakerz': 'http://vreakerz.comicgenesis.com/',
    'WackyAdventuresOfLunarAndKirk': 'http://lunarandkirk.comicgenesis.com/',
    'Wacoon': 'http://wacoon.comicgenesis.com/',
    'WaistHigh': 'http://waisthigh.comicgenesis.com/',
    'WanderingOnes': 'http://wanderingones.com/',
    'Wanted': 'http://wanted.comicgenesis.com/',
    'WarningBucketsOfBlood': 'http://chaoticcomics.comicgenesis.com/',
    'WarOfWinds': 'http://warofwinds.comicgenesis.com/',
    'WarpedReality': 'http://warpedreality.comicgenesis.com/',
    'WastedOnGaia': ('http://wog.comicgenesis.com/', 'http://wog.comicgenesis.com/Comic.html'),
    'WayOfTheDodo': 'http://dodocomic.comicgenesis.com/',
    'WeCouldntSing': 'http://wecouldntsing.comicgenesis.com/',
    'WeGrewFur': 'http://m1nion.comicgenesis.com/',
    'WelcomeToLemonHouseApartment': 'http://llewenayah.comicgenesis.com/',
    'WelcomeToParadise': 'http://paradise.comicgenesis.com/',
    'Werechild': 'http://werechild.comicgenesis.com/',
    'Wereworld': 'http://wereworld.comicgenesis.com/',
    'WestOfBathurst': 'http://westofbathurst.comicgenesis.com/',
    'WHACKED': 'http://whackedcomic.comicgenesis.com/',
    'Whatever': 'http://www.whatevercomic.com/',
    'WhatTheHell': 'http://whatthehell.comicgenesis.com/',
    'WhatYouDontSee': 'http://phantomlady4.comicgenesis.com/',
    'WhereGodsAndMortalsDance': 'http://wgmd.comicgenesis.com/',
    'WhiskeyAndMelancholy': 'http://sesquipedalophobe.comicgenesis.com/',
    'WhiteAsh': 'http://whiteash.comicgenesis.com/',
    'WhiteFeather': 'http://whitefeathermanga.comicgenesis.com/',
    'WhymeComics': 'http://whymecomics.comicgenesis.com/',
    'WhyNot': 'http://wynt.comicgenesis.com/',
    'Wingmen': 'http://wingmen.comicgenesis.com/',
    'WingsOfChange': 'http://wingsofchange.comicgenesis.com/',
    'WinterHall': 'http://house.comicgenesis.com/',
    'WishInOneHand': 'http://wishin1hand.comicgenesis.com/',
    'WitchAndCat': 'http://witchandcat.comicgenesis.com/',
    'Witchprickers': 'http://buxompiratewench.comicgenesis.com/',
    'Witticisma': 'http://witticisma.comicgenesis.com/',
    'WizardAndWarrior': 'http://wizardandwarrior.comicgenesis.com/',
    'WlcdTheNewsChicks': 'http://lcd.comicgenesis.com/',
    'Wolftigerfox': 'http://wolftigerfox.comicgenesis.com/',
    'Wonderflu': 'http://wonderflu.comicgenesis.com/',
    'WoodenLeg': 'http://thewoodenleg.comicgenesis.com/',
    'WoodsForTheTrees': 'http://woodsforthetrees.comicgenesis.com/',
    'WorldDomination': 'http://wdomination.comicgenesis.com/',
    'WorldOfFenninRo': 'http://wofr.comicgenesis.com/',
    'WorldOfFizz': 'http://fergoandenrique.comicgenesis.com/',
    'WorldUpsideDown': 'http://nekofan.comicgenesis.com/',
    'WorldWarp': 'http://ivstudios.comicgenesis.com/',
    'WouldBeAngelsWouldBeGods': 'http://nekomimi.comicgenesis.com/',
    'WrathOfHeaven': 'http://wrath.comicgenesis.com/',
    'WrongBand': 'http://thewrongband.comicgenesis.com/',
    'XCHOPSTICKSxNeo': 'http://chopsticksneo.comicgenesis.com/',
    'Xenization': 'http://xenization.comicgenesis.com/',
    'XGC': 'http://shaddowflight.comicgenesis.com/',
    'YangChild': 'http://yangchild.comicgenesis.com/',
    'YellowMoon': 'http://yellowmoon.comicgenesis.com/',
    'YinAndYang': 'http://www.yin-and-yang.com/',
    'YOSH': 'http://yosh.comicgenesis.com/',
    'YouDontGetItDoYou': 'http://youdontgetit.comicgenesis.com/',
    'YourInAiryTract': 'http://yourinairytract.comicgenesis.com/',
    'YouScrewedUp': 'http://youscrewedup.comicgenesis.com/',
    'Z0MgTheComic': 'http://z0mg.comicgenesis.com/',
    'Zap': 'http://www.zapinspace.com/',
    'Zarla': 'http://zarla.comicgenesis.com/',
    'ZebraGirl': 'http://zebragirl.keenspot.com/',
    'ZeeraTheSpacePirate': 'http://zeera.comicgenesis.com/',
    'Zelon': 'http://zelon.comicgenesis.com/',
    'ZenekAndJozek': 'http://znj.comicgenesis.com/',
    'Zeta': 'http://zetahome.comicgenesis.com/',
    'ZeuU': 'http://zeurinu.comicgenesis.com/',
    'ZilchAndSolo': 'http://zilchandsolo.comicgenesis.com/',
    'ZombieHouse': 'http://zhouse.comicgenesis.com/',
    'Zoology': 'http://thezoo.comicgenesis.com/',
    'ZorroAndEster': 'http://zorroandester.comicgenesis.com/',
    'Zortic': 'http://www.zortic.com/',
    'ZosKias': 'http://kojika.comicgenesis.com/',
    'ZuraZura': 'http://zurazura.comicgenesis.com/',
    }

globals().update(keenSpot(keenspotComics))
