// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=function, header=GenericFunction.h)
%feature("docstring")  dolfin::GenericFunction "
This is a common base class for functions. Functions can be
evaluated at a given point and they can be restricted to a given
cell in a finite element mesh. This functionality is implemented
by sub-classes that implement the eval() and restrict() functions.

DOLFIN provides two implementations of the GenericFunction
interface in the form of the classes Function and Expression.

Sub-classes may optionally implement the gather() function that
will be called prior to restriction when running in parallel.
";

%feature("docstring")  dolfin::GenericFunction::GenericFunction "
Constructor
";

%feature("docstring")  dolfin::GenericFunction::value_rank "
Return value rank
";

%feature("docstring")  dolfin::GenericFunction::value_dimension "
Return value dimension for given axis
";

%feature("docstring")  dolfin::GenericFunction::eval "
**Overloaded versions**

* eval\ (values, x, cell)

  Evaluate at given point in given cell

* eval\ (values, x)

  Evaluate at given point
";

%feature("docstring")  dolfin::GenericFunction::restrict "
Restrict function to local cell (compute expansion coefficients w)
";

%feature("docstring")  dolfin::GenericFunction::compute_vertex_values "
Compute values at all mesh vertices
";

%feature("docstring")  dolfin::GenericFunction::gather "
Collect off-process coefficients to prepare for interpolation
";

%feature("docstring")  dolfin::GenericFunction::operator "
**Overloaded versions**

* operator\ (x)

  Evaluation at given point (scalar function)

* operator\ (x, y)

  Evaluation at given point (scalar function)

* operator\ (x, y, z)

  Evaluation at given point (scalar function)

* operator\ (p)

  Evaluation at given point (scalar function)

* operator\ (values, x)

  Evaluation at given point (vector-valued function)

* operator\ (values, x, y)

  Evaluation at given point (vector-valued function)

* operator\ (values, x, y, z)

  Evaluation at given point (vector-valued function)

* operator\ (values, p)

  Evaluation at given point (vector-valued function)
";

%feature("docstring")  dolfin::GenericFunction::value_size "
Evaluation at given point
Return value size (product of value dimensions)
";

%feature("docstring")  dolfin::GenericFunction::evaluate "
Evaluate function at given point in cell
";

// Documentation extracted from: (module=function, header=Expression.h)
%feature("docstring")  dolfin::Expression "
This class represents a user-defined expression. Expressions can
be used as coefficients in variational forms or interpolated
into finite element spaces.

An expression is defined by overloading the eval() method. Users
may choose to overload either a simple version of eval(), in the
case of expressions only depending on the coordinate x, or an
optional version for expressions depending on x and mesh data
like cell indices or facet normals.

The geometric dimension (the size of x) and the value rank and
dimensions of an expression must supplied as arguments to the
constructor.
";

%feature("docstring")  dolfin::Expression::Expression "
**Overloaded versions**

* Expression\ ()

  Create scalar expression.

* Expression\ (dim)

  Create vector-valued expression with given dimension.
  
  *Arguments*
      dim (int)
          Dimension of the vector-valued expression.

* Expression\ (dim0, dim1)

  Create matrix-valued expression with given dimensions.
  
  *Arguments*
      dim0 (int)
          Dimension (rows).
      dim1 (int)
          Dimension (columns).

* Expression\ (value_shape)

  Create tensor-valued expression with given shape.
  
  *Arguments*
      value_shape (numpy.array(int))
          Shape of expression.

* Expression\ (expression)

  Copy constructor
  
  *Arguments*
      expression (:py:class:`Expression`)
          Object to be copied.
";

%feature("docstring")  dolfin::Expression::eval "
**Overloaded versions**

* eval\ (values, x, cell)

  Note: The reimplementation of eval is needed for the Python interface.
  Evaluate at given point in given cell.
  
  *Arguments*
      values (numpy.array(float))
          The values at the point.
      x (numpy.array(float))
          The coordinates of the point.
      cell (ufc::cell)
          The cell which contains the given point.

* eval\ (values, x)

  Evaluate at given point.
  
  *Arguments*
      values (numpy.array(float))
          The values at the point.
      x (numpy.array(float))
          The coordinates of the point.
";

%feature("docstring")  dolfin::Expression::value_rank "
Return value rank.

*Returns*
    int
        The value rank.
";

%feature("docstring")  dolfin::Expression::value_dimension "
Return value dimension for given axis.

*Arguments*
    i (int)
        Integer denoting the axis to use.

*Returns*
    int
        The value dimension (for the given axis).
";

%feature("docstring")  dolfin::Expression::restrict "
Restrict function to local cell (compute expansion coefficients w).

*Arguments*
    w (list of doubles)
        Expansion coefficients.
    element (:py:class:`FiniteElement`)
        The element.
    dolfin_cell (:py:class:`Cell`)
        The cell.
    ufc_cell (ufc::cell)
        The ufc::cell.
";

%feature("docstring")  dolfin::Expression::compute_vertex_values "
Compute values at all mesh vertices.

*Arguments*
    vertex_values (numpy.array(float))
        The values at all vertices.
    mesh (:py:class:`Mesh`)
        The mesh.
";

// Documentation extracted from: (module=function, header=Function.h)
%feature("docstring")  dolfin::Function "
This class represents a function :math:`u_h` in a finite
element function space :math:`V_h`, given by

.. math::

    u_h = \sum_{i=1}^{n} U_i \phi_i

where :math:`\{\phi_i\}_{i=1}^{n}` is a basis for :math:`V_h`,
and :math:`U` is a vector of expansion coefficients for :math:`u_h`.
";

%feature("docstring")  dolfin::Function::Function "
**Overloaded versions**

* Function\ (V)

  Create function on given function space
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
  
  *Example*
      .. note::
      
          No example code available for this function.

* Function\ (V)

  Create function on given function space (shared data)
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.

* Function\ (V, x)

  Create function on given function space with a given vector
  (shared data)
  
  *Warning: This constructor is intended for internal library use only*
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      x (:py:class:`GenericVector`)
          The vector.

* Function\ (V, filename)

  Create function from vector of dofs stored to file
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      filename_vector (str)
          The name of the file containing the vector.
      filename_dofdata (str)
          The name of the file containing the dofmap data.

* Function\ (V, filename)

  Create function from vector of dofs stored to file (shared data)
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      filename_dofdata (str)
          The name of the file containing the dofmap data.

* Function\ (v)

  Copy constructor
  
  *Arguments*
      v (:py:class:`Function`)
          The object to be copied.

* Function\ (v, i)

  Sub-function constructor with shallow copy of vector (used in Python
  interface)
  
  *Arguments*
      v (:py:class:`Function`)
          The function to be copied.
      i (int)
          Index of subfunction.
  
";

%feature("docstring")  dolfin::Function::operator= "
**Overloaded versions**

* operator=\ (v)

  Assignment from function
  
  *Arguments*
      v (:py:class:`Function`)
          Another function.

* operator=\ (v)

  Assignment from expression using interpolation
  
  *Arguments*
      v (:py:class:`Expression`)
          The expression.
";

%feature("docstring")  dolfin::Function::operator[] "
Extract subfunction

*Arguments*
    i (int)
        Index of subfunction.
";

%feature("docstring")  dolfin::Function::function_space "
Return shared pointer to function space

*Returns*
    :py:class:`FunctionSpace`
        Return the shared pointer.
";

%feature("docstring")  dolfin::Function::vector "
**Overloaded versions**

* vector\ ()

  Return vector of expansion coefficients (non-const version)
  
  *Returns*
      :py:class:`GenericVector`
          The vector of expansion coefficients.

* vector\ ()

  Return vector of expansion coefficients (const version)
  
  *Returns*
      :py:class:`GenericVector`
          The vector of expansion coefficients (const).
";

%feature("docstring")  dolfin::Function::in "
Check if function is a member of the given function space

*Arguments*
    V (:py:class:`FunctionSpace`)
        The function space.

*Returns*
    bool
        True if the function is in the function space.
";

%feature("docstring")  dolfin::Function::geometric_dimension "
Return geometric dimension

*Returns*
    int
        The geometric dimension.
";

%feature("docstring")  dolfin::Function::eval "
**Overloaded versions**

* eval\ (values, x)

  Evaluate function at given coordinates
  
  *Arguments*
      values (numpy.array(float))
          The values.
      x (numpy.array(float))
          The coordinates.

* eval\ (values, x, dolfin_cell, ufc_cell)

  Evaluate function at given coordinates in given cell
  
  *Arguments*
      values (numpy.array(float))
          The values.
      x (numpy.array(float))
          The coordinates.
      dolfin_cell (:py:class:`Cell`)
          The cell.
      ufc_cell (ufc::cell)
          The ufc::cell.

* eval\ (values, x, cell)

  Evaluate at given point in given cell
  
  *Arguments*
      values (numpy.array(float))
          The values at the point.
      x (numpy.array(float))
          The coordinates of the point.
      cell (ufc::cell)
          The cell which contains the given point.
";

%feature("docstring")  dolfin::Function::interpolate "
Interpolate function (on possibly non-matching meshes)

*Arguments*
    v (:py:class:`GenericFunction`)
        The function to be interpolated.
";

%feature("docstring")  dolfin::Function::extrapolate "
Extrapolate function (from a possibly lower-degree function space)

*Arguments*
    v (:py:class:`Function`)
        The function to be extrapolated.
";

%feature("docstring")  dolfin::Function::value_rank "
Return value rank

*Returns*
    int
        The value rank.
";

%feature("docstring")  dolfin::Function::value_dimension "
Return value dimension for given axis

*Arguments*
    i (int)
        The index of the axis.

*Returns*
    int
        The value dimension.
";

%feature("docstring")  dolfin::Function::non_matching_eval "
Evaluate function for given data (non-matching meshes)

*Arguments*
    values (numpy.array(float))
        The values at the point.
    x (numpy.array(float))
        The coordinates of the point.
    cell (ufc::cell)
        The cell.
";

%feature("docstring")  dolfin::Function::restrict "
Restrict function to local cell (compute expansion coefficients w)

*Arguments*
    w (list of doubles)
        Expansion coefficients.
    element (:py:class:`FiniteElement`)
        The element.
    dolfin_cell (:py:class:`Cell`)
        The cell.
    ufc_cell (ufc::cell)
        The ufc::cell.
";

%feature("docstring")  dolfin::Function::compute_vertex_values "
Compute values at all mesh vertices

*Arguments*
    vertex_values (numpy.array(float))
        The values at all vertices.
    mesh (:py:class:`Mesh`)
        The mesh.
";

%feature("docstring")  dolfin::Function::gather "
Collect off-process coefficients to prepare for interpolation
";

// Documentation extracted from: (module=function, header=FunctionSpace.h)
%feature("docstring")  dolfin::FunctionSpace "
This class represents a finite element function space defined by
a mesh, a finite element, and a local-to-global mapping of the
degrees of freedom (dofmap).
";

%feature("docstring")  dolfin::FunctionSpace::FunctionSpace "
**Overloaded versions**

* FunctionSpace\ (mesh, element, dofmap)

  Create function space for given mesh, element and dofmap
  (shared data)
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      element (:py:class:`FiniteElement`)
          The element.
      dofmap (:py:class:`GenericDofMap`)
          The dofmap.

* FunctionSpace\ (mesh)

  Create empty function space for later initialization. This
  constructor is intended for use by any sub-classes which need
  to construct objects before the initialisation of the base
  class. Data can be attached to the base class using
  FunctionSpace::attach(...).
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.

* FunctionSpace\ (V)

  Copy constructor
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The object to be copied.
";

%feature("docstring")  dolfin::FunctionSpace::attach "
Attach data to an empty function space

*Arguments*
    element (:py:class:`FiniteElement`)
        The element.
    dofmap (:py:class:`GenericDofMap`)
        The dofmap.
";

%feature("docstring")  dolfin::FunctionSpace::operator= "
Assignment operator

*Arguments*
    V (:py:class:`FunctionSpace`)
        Another function space.
";

%feature("docstring")  dolfin::FunctionSpace::operator== "
Equality operator

*Arguments*
    V (:py:class:`FunctionSpace`)
        Another function space.
";

%feature("docstring")  dolfin::FunctionSpace::operator!= "
Unequality operator

*Arguments*
    V (:py:class:`FunctionSpace`)
        Another function space.
";

%feature("docstring")  dolfin::FunctionSpace::mesh "
Return mesh

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::FunctionSpace::element "
Return finite element

*Returns*
    :py:class:`FiniteElement`
        The finite element.
";

%feature("docstring")  dolfin::FunctionSpace::dofmap "
Return dofmap

*Returns*
    :py:class:`GenericDofMap`
        The dofmap.
";

%feature("docstring")  dolfin::FunctionSpace::dim "
Return dimension of function space

*Returns*
    int
        The dimension of the function space.
";

%feature("docstring")  dolfin::FunctionSpace::interpolate "
Interpolate function v into function space, returning the
vector of expansion coefficients

*Arguments*
    expansion_coefficients (:py:class:`GenericVector`)
        The expansion coefficients.
    v (:py:class:`GenericFunction`)
        The function to be interpolated.
";

%feature("docstring")  dolfin::FunctionSpace::operator[] "
Extract subspace for component

*Arguments*
    i (int)
        Index of the subspace.
*Returns*
    :py:class:`FunctionSpace`
        The subspace.
";

%feature("docstring")  dolfin::FunctionSpace::extract_sub_space "
Extract subspace for component

*Arguments*
    component (numpy.array(int))
        The component.

*Returns*
    :py:class:`FunctionSpace`
        The subspace.
";

%feature("docstring")  dolfin::FunctionSpace::collapse "
**Overloaded versions**

* collapse\ ()

  Collapse a subspace and return a new function space
  
  *Returns*
      :py:class:`FunctionSpace`
          The new function space.

* collapse\ (collapsed_dofs)

  Collapse a subspace and return a new function space and a map
  from new to old dofs
  
  *Arguments*
      collapsed_dofs (boost::unordered_map<uint, uint>)
          The map from new to old dofs.
  
  *Returns*
      :py:class:`FunctionSpace`
        The new function space.
";

%feature("docstring")  dolfin::FunctionSpace::has_cell "
Check if function space has given cell

*Arguments*
    cell (:py:class:`Cell`)
        The cell.

*Returns*
    bool
        True if the function space has the given cell.
";

%feature("docstring")  dolfin::FunctionSpace::has_element "
Check if function space has given element

*Arguments*
    element (:py:class:`FiniteElement`)
        The finite element.

*Returns*
    bool
        True if the function space has the given element.
";

%feature("docstring")  dolfin::FunctionSpace::component "
Return component

*Returns*
    numpy.array(int)
        The component (relative to superspace).
";

%feature("docstring")  dolfin::FunctionSpace::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

%feature("docstring")  dolfin::FunctionSpace::print_dofmap "
Print dofmap (useful for debugging)
";

// Documentation extracted from: (module=function, header=SubSpace.h)
%feature("docstring")  dolfin::SubSpace "
This class represents a subspace (component) of a function space.

The subspace is specified by an array of indices. For example,
the array [3, 0, 2] specifies subspace 2 of subspace 0 of
subspace 3.

A typical example is the function space W = V x P for Stokes.
Here, V = W[0] is the subspace for the velocity component and
P = W[1] is the subspace for the pressure component. Furthermore,
W[0][0] = V[0] is the first component of the velocity space etc.
";

%feature("docstring")  dolfin::SubSpace::SubSpace "
**Overloaded versions**

* SubSpace\ (V, component)

  Create subspace for given component (one level)

* SubSpace\ (V, component, sub_component)

  Create subspace for given component (two levels)

* SubSpace\ (V, component)

  Create subspace for given component (n levels)
";

// Documentation extracted from: (module=function, header=Constant.h)
%feature("docstring")  dolfin::Constant "
This class represents a constant-valued expression.
";

%feature("docstring")  dolfin::Constant::Constant "
**Overloaded versions**

* Constant\ (value)

  Create scalar constant
  
  *Arguments*
      value (float)
          The scalar to create a Constant object from.
  
  *Example*
      .. note::
      
          No example code available for this function.

* Constant\ (value0, value1)

  Create vector constant (dim = 2)
  
  *Arguments*
      value0 (float)
          The first vector element.
      value1 (float)
          The second vector element.
  
  *Example*
      .. note::
      
          No example code available for this function.

* Constant\ (value0, value1, value2)

  Create vector constant (dim = 3)
  
  *Arguments*
      value0 (float)
          The first vector element.
      value1 (float)
          The second vector element.
      value2 (float)
          The third vector element.
  
  *Example*
      .. note::
      
          No example code available for this function.

* Constant\ (values)

  Create vector-valued constant
  
  *Arguments*
      values (numpy.array(float))
          Values to create a vector-valued constant from.

* Constant\ (value_shape, values)

  Create tensor-valued constant for flattened array of values
  
  *Arguments*
      value_shape (numpy.array(int))
          Shape of tensor.
      values (numpy.array(float))
          Values to create tensor-valued constant from.

* Constant\ (constant)

  Copy constructor
  
  *Arguments*
      constant (:py:class:`Constant`)
          Object to be copied.
";

%feature("docstring")  dolfin::Constant::operator= "
**Overloaded versions**

* operator=\ (constant)

  Assignment operator
  
  *Arguments*
      constant (:py:class:`Constant`)
          Another constant.

* operator=\ (constant)

  Assignment operator
  
  *Arguments*
      constant (float)
          Another constant.
";

%feature("docstring")  dolfin::Constant::operator double "
Cast to double (for scalar constants)

*Returns*
    float
        The scalar value.
";

// Documentation extracted from: (module=function, header=SpecialFunctions.h)
%feature("docstring")  dolfin::MeshCoordinates "
This Function represents the mesh coordinates on a given mesh.
";

%feature("docstring")  dolfin::MeshCoordinates::MeshCoordinates "
Constructor
";

%feature("docstring")  dolfin::MeshCoordinates::eval "
Evaluate function
";

%feature("docstring")  dolfin::FacetArea "
This function represents the area/length of a cell facet on a given mesh.
";

%feature("docstring")  dolfin::FacetArea::FacetArea "
Constructor
";

%feature("docstring")  dolfin::FacetArea::eval "
Evaluate function
";

// Documentation extracted from: (module=plot, header=plot.h)
%feature("docstring")  dolfin::plot "
**Overloaded versions**

* plot\ (v, title=\"Function\", mode=\"auto\")

  Simple built-in plot commands for plotting functions and meshes.
  For plotting to work, PyDOLFIN and Viper must be installed.
  Plot function

* plot\ (v, mesh, title=\"Expression\", mode=\"auto\")

  Plot function

* plot\ (mesh, title=\"Mesh\")

  Plot mesh

* plot\ (f, MeshFunction<uint>\")

  Plot mesh function

* plot\ (f, title=\"MeshFunction<double>\")

  Plot mesh function

* plot\ (f, title=\"MeshFunction<bool>\")

  Plot mesh function
";

// Documentation extracted from: (module=plot, header=FunctionPlotData.h)
%feature("docstring")  dolfin::FunctionPlotData "
This class is used for communicating plot data for functions
to and from (XML) files. It is used by DOLFIN for plotting
Function objects. The data is stored as a mesh and a vector
of interpolated vertex values.
";

%feature("docstring")  dolfin::FunctionPlotData::FunctionPlotData "
**Overloaded versions**

* FunctionPlotData\ (v, mesh)

  Create plot data for given function

* FunctionPlotData\ ()

  Create empty data to be read from file
";

%feature("docstring")  dolfin::FunctionPlotData::vertex_values "
Return vertex values
";

// Documentation extracted from: (module=nls, header=NonlinearProblem.h)
%feature("docstring")  dolfin::NonlinearProblem "
This is a base class for nonlinear problems which can return the
nonlinear function F(u) and its Jacobian J = dF(u)/du.
";

%feature("docstring")  dolfin::NonlinearProblem::NonlinearProblem "
Constructor
";

%feature("docstring")  dolfin::NonlinearProblem::form "
Function called by Newton solver before requesting F or J.
This can be used to compute F and J together
";

%feature("docstring")  dolfin::NonlinearProblem::F "
Compute F at current point x
";

%feature("docstring")  dolfin::NonlinearProblem::J "
Compute J = F' at current point x
";

// Documentation extracted from: (module=nls, header=NewtonSolver.h)
%feature("docstring")  dolfin::NewtonSolver "
This class defines a Newton solver for nonlinear systems of
equations of the form :math:`F(x) = 0`.
";

%feature("docstring")  dolfin::NewtonSolver::NewtonSolver "
**Overloaded versions**

* NewtonSolver\ (solver_type=\"lu\", pc_type=\"default\")

  Create nonlinear solver with default linear solver and default
  linear algebra backend

* NewtonSolver\ (solver, factory)

  Create nonlinear solver using provided linear solver and linear algebra
  backend determined by factory
  
  *Arguments*
      solver (:py:class:`GenericLinearSolver`)
          The linear solver.
      factory (:py:class:`LinearAlgebraFactory`)
          The factory.
";

%feature("docstring")  dolfin::NewtonSolver::solve "
Solve abstract nonlinear problem :math:`F(x) = 0` for given
:math:`F` and Jacobian :math:`\dfrac{\partial F}{\partial x}`.

*Arguments*
    nonlinear_function (:py:class:`NonlinearProblem`)
        The nonlinear problem.
    x (:py:class:`GenericVector`)
        The vector.

*Returns*
    (int, bool)
        Pair of number of Newton iterations, and whether
        iteration converged)
";

%feature("docstring")  dolfin::NewtonSolver::iteration "
Return Newton iteration number

*Returns*
    int
        The iteration number.
";

%feature("docstring")  dolfin::NewtonSolver::residual "
Return current residual

*Returns*
    float
        Current residual.
";

%feature("docstring")  dolfin::NewtonSolver::relative_residual "
Return current relative residual

*Returns*
    float
      Current relative residual.
";

%feature("docstring")  dolfin::NewtonSolver::linear_solver "
Return the linear solver

*Returns*
    :py:class:`GenericLinearSolver`
        The linear solver.
";

%feature("docstring")  dolfin::NewtonSolver::default_parameters "
Default parameter values

*Returns*
    :py:class:`Parameters`
        Parameter values.
";

%feature("docstring")  dolfin::NewtonSolver::converged "
Convergence test
";

// Documentation extracted from: (module=fem, header=GenericDofMap.h)
%feature("docstring")  dolfin::GenericDofMap "
This class provides a generic interface for dof maps
";

%feature("docstring")  dolfin::GenericDofMap::is_view "
True if dof map is a view into another map (is a sub-dofmap)
";

%feature("docstring")  dolfin::GenericDofMap::needs_mesh_entities "
Return true iff mesh entities of topological dimension d are needed
";

%feature("docstring")  dolfin::GenericDofMap::global_dimension "
Return the dimension of the global finite element function space
";

%feature("docstring")  dolfin::GenericDofMap::cell_dimension "
Return the dimension of the local finite element function space on a
cell
";

%feature("docstring")  dolfin::GenericDofMap::max_cell_dimension "
Return the maximum dimension of the local finite element function space
";

%feature("docstring")  dolfin::GenericDofMap::num_facet_dofs "
Return number of facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::ownership_range "
Return the ownership range (dofs in this range are owned by this process)
";

%feature("docstring")  dolfin::GenericDofMap::off_process_owner "
Return map from nonlocal-dofs (that appear in local dof map) to owning process
";

%feature("docstring")  dolfin::GenericDofMap::cell_dofs "
Local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_dofs "
Tabulate the local-to-global mapping of dofs on a cell
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs
";

%feature("docstring")  dolfin::GenericDofMap::tabulate_coordinates "
**Overloaded versions**

* tabulate_coordinates\ (coordinates, ufc_cell)

  Tabulate the coordinates of all dofs on a cell (UFC cell version)

* tabulate_coordinates\ (coordinates, cell)

  Tabulate the coordinates of all dofs on a cell (DOLFIN cell version)
";

%feature("docstring")  dolfin::GenericDofMap::copy "
Create a copy of the dof map
";

%feature("docstring")  dolfin::GenericDofMap::extract_sub_dofmap "
Extract sub dofmap component
";

%feature("docstring")  dolfin::GenericDofMap::collapse "
Create a \"collapsed\" a dofmap (collapses from a sub-dofmap view)
";

%feature("docstring")  dolfin::GenericDofMap::dofs "
Return the set of dof indices
";

%feature("docstring")  dolfin::GenericDofMap::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=fem, header=DofMap.h)
%feature("docstring")  dolfin::DofMap "
This class handles the mapping of degrees of freedom. It builds
a dof map based on a ufc::dofmap on a specific mesh. It will
reorder the dofs when running in parallel. Sub-dofmaps, both
views and copies, are supported.
";

%feature("docstring")  dolfin::DofMap::DofMap "
**Overloaded versions**

* DofMap\ (ufc_dofmap, mesh)

  Create dof map on mesh (data is not shared)
  
  *Arguments*
      ufc_dofmap (ufc::dofmap)
          The ufc::dofmap.
      mesh (:py:class:`Mesh`)
          The mesh.

* DofMap\ (ufc_dofmap, mesh)

  Create dof map on mesh ((data is not shared), const mesh
  version)
  
  *Arguments*
      ufc_dofmap (ufc::dofmap)
          The ufc::dofmap.
      mesh (:py:class:`Mesh`)
          The mesh.

* DofMap\ (dofmap)

  Copy constructor
  
  *Arguments*
      dofmap (:py:class:`DofMap`)
          The object to be copied.

* DofMap\ (parent_dofmap, component, mesh, distributed)

  Create a sub-dofmap (a view) from parent_dofmap

* DofMap\ (collapsed_map, dofmap_view, mesh, distributed)

  Create a collapsed dofmap from parent_dofmap
";

%feature("docstring")  dolfin::DofMap::is_view "
True if dof map is a view into another map

*Returns*
    bool
        True if the dof map is a sub-dof map (a view into
        another map).
";

%feature("docstring")  dolfin::DofMap::needs_mesh_entities "
Return true iff mesh entities of topological dimension d are
needed

*Arguments*
    d (int)
        Topological dimension.

*Returns*
    bool
        True if the mesh entities are needed.
";

%feature("docstring")  dolfin::DofMap::global_dimension "
Return the dimension of the global finite element function
space

*Returns*
    int
        The dimension of the global finite element function space.
";

%feature("docstring")  dolfin::DofMap::cell_dimension "
Return the dimension of the local finite element function
space on a cell

*Arguments*
    cell_index (int)
        Index of cell

*Returns*
    int
        Dimension of the local finite element function space.
";

%feature("docstring")  dolfin::DofMap::max_cell_dimension "
Return the maximum dimension of the local finite element
function space

*Returns*
    int
        Maximum dimension of the local finite element function
        space.
";

%feature("docstring")  dolfin::DofMap::geometric_dimension "
Return the geometric dimension of the coordinates this dof map
provides

*Returns*
    int
        The geometric dimension.
";

%feature("docstring")  dolfin::DofMap::num_facet_dofs "
Return number of facet dofs

*Returns*
    int
        The number of facet dofs.
";

%feature("docstring")  dolfin::DofMap::ownership_range "
Return the ownership range (dofs in this range are owned by
this process)

*Returns*
    (int, int)
        The ownership range.
";

%feature("docstring")  dolfin::DofMap::off_process_owner "
Return map from nonlocal dofs that appear in local dof map to
owning process

*Returns*
    boost::unordered_map<unsigned int, unsigned int>
        The map from non-local dofs.
";

%feature("docstring")  dolfin::DofMap::cell_dofs "
Local-to-global mapping of dofs on a cell

*Arguments*
    cell_index (int)
        The cell index.

*Returns*
    numpy.array(int)
        Local-to-global mapping of dofs.
";

%feature("docstring")  dolfin::DofMap::tabulate_dofs "
Tabulate the local-to-global mapping of dofs on a cell

*Arguments*
    dofs (int)
        Degrees of freedom on a cell.
    cell (:py:class:`Cell`)
        The cell.
";

%feature("docstring")  dolfin::DofMap::tabulate_facet_dofs "
Tabulate local-local facet dofs

*Arguments*
    dofs (int)
        Degrees of freedom.
    local_facet (int)
        The local facet.
";

%feature("docstring")  dolfin::DofMap::tabulate_coordinates "
**Overloaded versions**

* tabulate_coordinates\ (coordinates, ufc_cell)

  Tabulate the coordinates of all dofs on a cell (UFC cell
  version)
  
  *Arguments*
      coordinates (boost::multi_array<double, 2>)
          The coordinates of all dofs on a cell.
      ufc_cell (ufc::cell)
          The cell.

* tabulate_coordinates\ (coordinates, cell)

  Tabulate the coordinates of all dofs on a cell (DOLFIN cell
  version)
  
  *Arguments*
      coordinates (boost::multi_array<double, 2>)
          The coordinates of all dofs on a cell.
      cell (:py:class:`Cell`)
          The cell.
";

%feature("docstring")  dolfin::DofMap::copy "
Create a copy of the dof map

*Arguments*
    mesh (:py:class:`Mesh`)
        The object to be copied.
";

%feature("docstring")  dolfin::DofMap::extract_sub_dofmap "
Extract subdofmap component

*Arguments*
    component (numpy.array(int))
        The component.
    mesh (:py:class:`Mesh`)
        The mesh.

*Returns*
    DofMap
        The subdofmap component.
";

%feature("docstring")  dolfin::DofMap::collapse "
Create a \"collapsed\" dofmap (collapses a sub-dofmap)

*Arguments*
    collapsed_map (boost::unordered_map<uint, uint>)
        The \"collapsed\" map.
    mesh (:py:class:`Mesh`)
        The mesh.

*Returns*
    DofMap
        The collapsed dofmap.
";

%feature("docstring")  dolfin::DofMap::dofs "
Return the set of dof indices

*Returns*
    boost::unordered_set<dolfin::uint>
        The set of dof indices.
";

%feature("docstring")  dolfin::DofMap::data "
Return the underlying dof map data. Intended for internal library
use only.

*Returns*
    std::vector<std::vector<dolfin::uint> >
        The local-to-global map for each cell.
";

%feature("docstring")  dolfin::DofMap::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=fem, header=Equation.h)
%feature("docstring")  dolfin::Equation "
This class represents a variational equation lhs == rhs.
The equation can be either linear or nonlinear:

1. Linear (a == L), in which case a must be a bilinear form
   and L must be a linear form.

2. Nonlinear (F == 0), in which case F must be a linear form.
";

%feature("docstring")  dolfin::Equation::Equation "
**Overloaded versions**

* Equation\ (a, L)

  Create equation a == L

* Equation\ (F, rhs)

  Create equation F == 0
";

%feature("docstring")  dolfin::Equation::is_linear "
Check whether equation is linear
";

%feature("docstring")  dolfin::Equation::lhs "
Return form for left-hand side
";

%feature("docstring")  dolfin::Equation::rhs "
Return form for right-hand side
";

%feature("docstring")  dolfin::Equation::rhs_int "
Return value for right-hand side
";

// Documentation extracted from: (module=fem, header=FiniteElement.h)
%feature("docstring")  dolfin::FiniteElement "
This is a wrapper for a UFC finite element (ufc::finite_element).
";

%feature("docstring")  dolfin::FiniteElement::FiniteElement "
Create finite element from UFC finite element (data may be shared)
";

%feature("docstring")  dolfin::FiniteElement::signature "
Return a string identifying the finite element
";

%feature("docstring")  dolfin::FiniteElement::cell_shape "
Return the cell shape
";

%feature("docstring")  dolfin::FiniteElement::space_dimension "
Return the dimension of the finite element function space
";

%feature("docstring")  dolfin::FiniteElement::value_rank "
Return the rank of the value space
";

%feature("docstring")  dolfin::FiniteElement::value_dimension "
Return the dimension of the value space for axis i
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis "
**Overloaded versions**

* evaluate_basis\ (i, values, x, cell)

  Evaluate basis function i at given point in cell

* evaluate_basis\ (i, values, x, cell)

  Evaluate basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_all "
**Overloaded versions**

* evaluate_basis_all\ (values, coordinates, c)

  Evaluate all basis functions at given point in cell

* evaluate_basis_all\ (values, coordinates, cell)

  Evaluate all basis functions at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives "
Evaluate order n derivatives of basis function i at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_basis_derivatives_all "
Evaluate order n derivatives of all basis functions at given point in cell
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dof "
Evaluate linear functional for dof i on the function f
";

%feature("docstring")  dolfin::FiniteElement::evaluate_dofs "
Evaluate linear functionals for all dofs on the function f
";

%feature("docstring")  dolfin::FiniteElement::interpolate_vertex_values "
Interpolate vertex values from dof values
";

%feature("docstring")  dolfin::FiniteElement::map_from_reference_cell "
Map coordinate xhat from reference cell to coordinate x in cell
";

%feature("docstring")  dolfin::FiniteElement::map_to_reference_cell "
Map from coordinate x in cell to coordinate xhat in reference cell
";

%feature("docstring")  dolfin::FiniteElement::num_sub_elements "
Return the number of sub elements (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::hash "
Return simple hash of the signature string
";

%feature("docstring")  dolfin::FiniteElement::create_sub_element "
Create a new finite element for sub element i (for a mixed element)
";

%feature("docstring")  dolfin::FiniteElement::create "
Create a new class instance
";

%feature("docstring")  dolfin::FiniteElement::extract_sub_element "
Extract sub finite element for component
";

// Documentation extracted from: (module=fem, header=BasisFunction.h)
%feature("docstring")  dolfin::BasisFunction "
This class represents a finite element basis function. It can be
used for computation of basis function values and derivatives.

Evaluation of basis functions is also possible through the use
of the functions ``evaluate_basis`` and ``evaluate_basis_derivatives``
available in the :py:class:`FiniteElement` class. The BasisFunction class
relies on these functions for evaluation but also implements the
ufc::function interface which allows evaluate_dof to be
evaluated for a basis function (on a possibly different
element).
";

%feature("docstring")  dolfin::BasisFunction::BasisFunction "
Create basis function with given index on element on given cell

*Arguments*
    index (int)
        The index of the basis function.
    element (:py:class:`FiniteElement`)
        The element to create basis function on.
    cell (ufc::cell)
        The cell.
";

%feature("docstring")  dolfin::BasisFunction::eval "
Evaluate basis function at given point

*Arguments*
    values (float)
        The values of the function at the point.
    x (float)
        The coordinates of the point.
";

%feature("docstring")  dolfin::BasisFunction::eval_derivatives "
Evaluate all order n derivatives at given point

*Arguments*
    values (float)
        The values of derivatives at the point.
    x (float)
        The coordinates of the point.
    n (int)
        The order of derivation.
";

%feature("docstring")  dolfin::BasisFunction::evaluate "
Evaluate function at given point in cell

*Arguments*
    values (float)
        The values of the function at the point..
    coordinates (float)
        The coordinates of the point.
    cell (ufc::cell)
        The cell.
";

// Documentation extracted from: (module=fem, header=BoundaryCondition.h)
%feature("docstring")  dolfin::BoundaryCondition "
Common base class for boundary conditions
";

%feature("docstring")  dolfin::BoundaryCondition::BoundaryCondition "
**Overloaded versions**

* BoundaryCondition\ (V)

  Constructor

* BoundaryCondition\ (V)

  Constructor
";

%feature("docstring")  dolfin::BoundaryCondition::apply "
**Overloaded versions**

* apply\ (A)

  Apply boundary condition to a matrix

* apply\ (b)

  Apply boundary condition to a vector

* apply\ (A, b)

  Apply boundary condition to a linear system

* apply\ (b, x)

  Apply boundary condition to a vector for a nonlinear problem

* apply\ (A, b, x)

  Apply boundary condition to a linear system for a nonlinear problem
";

%feature("docstring")  dolfin::BoundaryCondition::function_space "
Return shared pointer to function space
";

// Documentation extracted from: (module=fem, header=DirichletBC.h)
%feature("docstring")  dolfin::DirichletBC "
This class specifies the interface for setting (strong)
Dirichlet boundary conditions for partial differential
equations,

.. math::

    u = g \hbox{ on } G,

where :math:`u` is the solution to be computed, :math:`g` is a function
and :math:`G` is a sub domain of the mesh.

A DirichletBC is specified by the function g, the function space
(trial space) and boundary indicators on (a subset of) the mesh
boundary.

The boundary indicators may be specified in a number of
different ways.

The simplest approach is to specify the boundary by a :py:class:`SubDomain`
object, using the inside() function to specify on which facets
the boundary conditions should be applied.

Alternatively, the boundary may be specified by a :py:class:`MeshFunction`
labeling all mesh facets together with a number that specifies
which facets should be included in the boundary.

The third option is to attach the boundary information to the
mesh. This is handled automatically when exporting a mesh from
for example VMTK.

The ``method`` variable may be used to specify the type of
method used to identify degrees of freedom on the
boundary. Available methods are: topological approach (default),
geometric approach, and pointwise approach. The topological
approach is faster, but will only identify degrees of freedom
that are located on a facet that is entirely on the boundary. In
particular, the topological approach will not identify degrees
of freedom for discontinuous elements (which are all internal to
the cell).  A remedy for this is to use the geometric
approach. To apply pointwise boundary conditions
e.g. pointloads, one will have to use the pointwise approach
which in turn is the slowest of the three possible methods.  The
three possibilties are \"topological\", \"geometric\" and
\"pointwise\".
This class specifies the interface for setting (strong)
";

%feature("docstring")  dolfin::DirichletBC::DirichletBC "
**Overloaded versions**

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (:py:class:`SubDomain`)
          The subdomain.
      method (str)
          Optional argument: A string specifying
          the method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space
      g (:py:class:`GenericFunction`)
          The value
      sub_domain (:py:class:`SubDomain`)
          The subdomain
      method (str)
          Optional argument: A string specifying
          the method to identify dofs

* DirichletBC\ (V, g, sub_domains, sub_domain, method=\"topological\")

  Create boundary condition for subdomain specified by index
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domains (:py:class:`MeshFunction`)
          Subdomain markers
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domains, sub_domain, method=\"topological\")

  Create boundary condition for subdomain specified by index
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domains (:py:class:`MeshFunction`)
          Subdomain markers
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for boundary data included in the mesh
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, sub_domain, method=\"topological\")

  Create boundary condition for boundary data included in the mesh
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      sub_domain (int)
          The subdomain index (number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (V, g, markers, method=\"topological\")

  Create boundary condition for subdomain by boundary markers
  (cells, local facet numbers)
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      g (:py:class:`GenericFunction`)
          The value.
      markers (numpy.array((int, int)))
          Subdomain markers (cells, local facet number)
      method (str)
          Optional argument: A string specifying the
          method to identify dofs.

* DirichletBC\ (bc)

  Copy constructor
  
  *Arguments*
      bc (:py:class:`DirichletBC`)
          The object to be copied.
";

%feature("docstring")  dolfin::DirichletBC::operator= "
Assignment operator

*Arguments*
    bc (:py:class:`DirichletBC`)
        Another DirichletBC object.
";

%feature("docstring")  dolfin::DirichletBC::apply "
**Overloaded versions**

* apply\ (A)

  Apply boundary condition to a matrix
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.

* apply\ (b)

  Apply boundary condition to a vector
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (A, b)

  Apply boundary condition to a linear system
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary condition to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary condition to.

* apply\ (b, x)

  Apply boundary condition to vectors for a nonlinear problem
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).

* apply\ (A, b, x)

  Apply boundary condition to a linear system for a nonlinear problem
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply boundary conditions to.
      b (:py:class:`GenericVector`)
          The vector to apply boundary conditions to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).
";

%feature("docstring")  dolfin::DirichletBC::get_boundary_values "
Get Dirichlet dofs and values

*Arguments*
    boundary_values (boost::unordered_map<uint, double>)
        Map from dof to boundary value.
    method (str)
        Optional argument: A string specifying which
        method to use.
";

%feature("docstring")  dolfin::DirichletBC::zero "
Make rows of matrix associated with boundary condition zero,
useful for non-diagonal matrices in a block matrix.

*Arguments*
    A (:py:class:`GenericMatrix`)
        The matrix
";

%feature("docstring")  dolfin::DirichletBC::zero_columns "
Make columns of matrix associated with boundary condition
zero, and update a (right-hand side) vector to reflect the
changes. Useful for non-diagonals.

*Arguments*
    A (:py:class:`GenericMatrix`)
        The matrix
    b (:py:class:`GenericVector`)
        The vector
    diag_val (float)
        This parameter would normally be -1, 0 or 1.
";

%feature("docstring")  dolfin::DirichletBC::markers "
Return boundary markers

*Returns*
    numpy.array((int, int))
        Boundary markers (facets stored as pairs of cells and
        local facet numbers).
";

%feature("docstring")  dolfin::DirichletBC::value "
Return boundary value g

*Returns*
    :py:class:`GenericFunction`
        The boundary values.
";

%feature("docstring")  dolfin::DirichletBC::user_sub_domain "
Return shared pointer to subdomain

*Returns*
    :py:class:`SubDomain`
        Shared pointer to subdomain.
";

%feature("docstring")  dolfin::DirichletBC::is_compatible "
Check if given function is compatible with boundary condition
(checking only vertex values)

*Arguments*
    v (:py:class:`GenericFunction`)
        The function to check for compability
        with boundary condition.

*Returns*
    bool
        True if compatible.
";

%feature("docstring")  dolfin::DirichletBC::set_value "
**Overloaded versions**

* set_value\ (g)

  Set value g for boundary condition, domain remains unchanged
  
  *Arguments*
      g (:py:class:`GenericFunction`)
          The value.

* set_value\ (g)

  Set value g for boundary condition, domain remains unchanged
  
  *Arguments*
      g (:py:class:`GenericFunction`)
          The value.
";

%feature("docstring")  dolfin::DirichletBC::homogenize "
Set value to 0.0
";

%feature("docstring")  dolfin::DirichletBC::method "
Return method used for computing Dirichet dofs

*Returns*
    str
        Method used for computing Dirichet dofs (\"topological\",
        \"geometric\" or \"pointwise\").
";

%feature("docstring")  dolfin::DirichletBC::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=PeriodicBC.h)
%feature("docstring")  dolfin::PeriodicBC "
This class specifies the interface for setting periodic boundary
conditions for partial differential equations,

.. math::

    u(x) &= u(F^{-1}(x)) \hbox { on } G,

    u(x) &= u(F(x))      \hbox{ on } H,

where F : H --> G is a map from a subdomain H to a subdomain G.

A periodic boundary condition must be defined by the domain G
and the map F pulling coordinates back from H to G. The domain
and the map are both defined by a subclass of :py:class:`SubDomain` which
must overload both the inside() function, which specifies the
points of G, and the map() function, which specifies the map
from the points of H to the points of G.

The implementation is based on matching degrees of freedom on G
with degrees of freedom on H and only works when the mapping F
is bijective between the sets of coordinates associated with the
two domains. In other words, the nodes (degrees of freedom) must
be aligned on G and H.

The matching of degrees of freedom is done at the construction
of the periodic boundary condition and is reused on subsequent
applications to a linear system. The matching may be recomputed
by calling the ``rebuild()`` function.
";

%feature("docstring")  dolfin::PeriodicBC::PeriodicBC "
**Overloaded versions**

* PeriodicBC\ (V, sub_domain)

  Create periodic boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      sub_domain (:py:class:`SubDomain`)
          The sub domain.

* PeriodicBC\ (V, sub_domain)

  Create periodic boundary condition for subdomain
  
  *Arguments*
      V (:py:class:`FunctionSpace`)
          The function space.
      sub_domain (:py:class:`SubDomain`)
          The subdomain.
";

%feature("docstring")  dolfin::PeriodicBC::apply "
**Overloaded versions**

* apply\ (A)

  Apply boundary condition to a matrix
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply bc to.

* apply\ (b)

  Apply boundary condition to a vector
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply bc to.

* apply\ (A, b)

  Apply boundary condition to a linear system
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix.
      b (:py:class:`GenericVector`)
          The vector.

* apply\ (b, x)

  Apply boundary condition to a vector for a nonlinear problem
  
  *Arguments*
      b (:py:class:`GenericVector`)
          The vector to apply bc to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).

* apply\ (A, b, x)

  Apply boundary condition to a linear system for a nonlinear
  problem
  
  *Arguments*
      A (:py:class:`GenericMatrix`)
          The matrix to apply bc to.
      b (:py:class:`GenericVector`)
          The vector to apply bc to.
      x (:py:class:`GenericVector`)
          Another vector (nonlinear problem).
";

%feature("docstring")  dolfin::PeriodicBC::rebuild "
Rebuild mapping between dofs
";

// Documentation extracted from: (module=fem, header=PointSource.h)
%feature("docstring")  dolfin::PointSource "
This class provides an easy mechanism for adding a point source
(Dirac delta function) to the right-hand side vector in a
variational problem. The associated function space must be
scalar in order for the inner product with the (scalar) Dirac
delta function to be well defined.
";

%feature("docstring")  dolfin::PointSource::PointSource "
**Overloaded versions**

* PointSource\ (V, p, magnitude=1.0)

  Create point source at given point of given magnitude

* PointSource\ (V, p, magnitude=1.0)

  Create point source at given point of given magnitude
";

%feature("docstring")  dolfin::PointSource::apply "
Apply (add) point source to right-hand side vector
";

// Documentation extracted from: (module=fem, header=assemble.h)
%feature("docstring")  dolfin::assemble "
**Overloaded versions**

* assemble\ (A, a, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor

* assemble\ (A, a, sub_domain, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor on sub domain

* assemble\ (A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor on sub domains

* assemble\ (a, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble scalar

* assemble\ (a, sub_domain, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble scalar on sub domain

* assemble\ (a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble scalar on sub domains
";

%feature("docstring")  dolfin::assemble_system "
**Overloaded versions**

* assemble_system\ (A, b, a, L, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b)

* assemble_system\ (A, b, a, L, bc, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b) and apply Dirichlet boundary condition

* assemble_system\ (A, b, a, L, bcs, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b) and apply Dirichlet boundary conditions

* assemble_system\ (A, b, a, L, bcs, cell_domains, exterior_facet_domains, interior_facet_domains, x0, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b) on sub domains and apply Dirichlet boundary conditions
";

// Documentation extracted from: (module=fem, header=solve.h)
%feature("docstring")  dolfin::solve "
**Overloaded versions**

* solve\ (equation, u, params=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 without boundary conditions
  Parameters to the Linear/Nonlinear VariationalSolver can be passed
  using params

* solve\ (equation, u, bc, params=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 with a single boundary condition
  Parameters to the Linear/Nonlinear VariationalSolver can be passed
  using params

* solve\ (equation, u, bcs, params=empty_parameters)

  Solve linear variational problem a(u, v) == L(v) or nonlinear
  variational problem F(u; v) = 0 with a list of boundary conditions
  Parameters to the Linear/Nonlinear VariationalSolver can be passed
  using params

* solve\ (equation, u, J, params=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 without boundary
  conditions. The argument J should provide the Jacobian bilinear
  form J = dF/du. Parameters to the Nonlinear VariationalSolver
  can be passed using params

* solve\ (equation, u, bc, J, params=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 with a single
  boundary condition. The argument J should provide the Jacobian
  bilinear form J = dF/du. Parameters to the Nonlinear
  VariationalSolver can be passed using params

* solve\ (equation, u, bcs, J, params=empty_parameters)

  Solve nonlinear variational problem F(u; v) == 0 with a list of
  boundary conditions. The argument J should provide the Jacobian
  bilinear form J = dF/du. Parameters to the Nonlinear
  VariationalSolver can be passed using params
";

// Documentation extracted from: (module=fem, header=Form.h)
%feature("docstring")  dolfin::Form "
Base class for UFC code generated by FFC for DOLFIN with option -l.

A note on the order of trial and test spaces: FEniCS numbers
argument spaces starting with the leading dimension of the
corresponding tensor (matrix). In other words, the test space is
numbered 0 and the trial space is numbered 1. However, in order
to have a notation that agrees with most existing finite element
literature, in particular

    a = a(u, v)

the spaces are numbered from right to

    a: V_1 x V_0 -> R

.. note::

    Figure out how to write this in math mode without it getting
    messed up in the Python version.

This is reflected in the ordering of the spaces that should be
supplied to generated subclasses. In particular, when a bilinear
form is initialized, it should be initialized as

.. code-block:: c++

    a(V_1, V_0) = ...

where ``V_1`` is the trial space and ``V_0`` is the test space.
However, when a form is initialized by a list of argument spaces
(the variable ``function_spaces`` in the constructors below, the
list of spaces should start with space number 0 (the test space)
and then space number 1 (the trial space).
";

%feature("docstring")  dolfin::Form::Form "
**Overloaded versions**

* Form\ (rank, num_coefficients)

  Create form of given rank with given number of coefficients
  
  *Arguments*
      rank (int)
          The rank.
      num_coefficients (int)
          The number of coefficients.

* Form\ (ufc_form, function_spaces, coefficients)

  Create form (shared data)
  
  *Arguments*
      ufc_form (ufc::form)
          The UFC form.
      function_spaces (list of :py:class:`FunctionSpace`)
          Vector of function spaces.
      coefficients (list of :py:class:`GenericFunction`)
          Vector of coefficients.
";

%feature("docstring")  dolfin::Form::rank "
Return rank of form (bilinear form = 2, linear form = 1,
functional = 0, etc)

*Returns*
    int
        The rank of the form.
";

%feature("docstring")  dolfin::Form::num_coefficients "
Return number of coefficients

*Returns*
    int
        The number of coefficients.
";

%feature("docstring")  dolfin::Form::coloring "
Return coloring type for colored (multi-threaded) assembly of form
over a mesh entity of a given dimension

*Arguments*
    entity_dim (int)
        Dimension.

*Returns*
    numpy.array(int)
        Coloring type.
";

%feature("docstring")  dolfin::Form::set_mesh "
Set mesh, necessary for functionals when there are no function spaces

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh.
";

%feature("docstring")  dolfin::Form::mesh "
Extract common mesh from form

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::Form::mesh_shared_ptr "
Return mesh shared pointer (if any)

*Returns*
    :py:class:`Mesh`
        The mesh shared pointer.
";

%feature("docstring")  dolfin::Form::function_space "
Return function space for given argument

*Arguments*
    i (int)
        Index

*Returns*
    :py:class:`FunctionSpace`
        Function space shared pointer.
";

%feature("docstring")  dolfin::Form::function_spaces "
Return function spaces for arguments

*Returns*
    list of :py:class:`FunctionSpace`
        Vector of function space shared pointers.
";

%feature("docstring")  dolfin::Form::set_coefficient "
**Overloaded versions**

* set_coefficient\ (i, coefficient)

  Set coefficient with given number (shared pointer version)
  
  *Arguments*
      i (int)
          The given number.
      coefficient (:py:class:`GenericFunction`)
          The coefficient.

* set_coefficient\ (name, coefficient)

  Set coefficient with given name (shared pointer version)
  
  *Arguments*
      name (str)
          The name.
      coefficient (:py:class:`GenericFunction`)
          The coefficient.
";

%feature("docstring")  dolfin::Form::set_coefficients "
Set all coefficients in given map, possibly a subset (shared
pointer version)

*Arguments*
    coefficients (:py:class:`GenericFunction`)
        The map of coefficients.
";

%feature("docstring")  dolfin::Form::coefficient "
**Overloaded versions**

* coefficient\ (i)

  Return coefficient with given number
  
  *Arguments*
      i (int)
          Index
  
  *Returns*
      :py:class:`GenericFunction`
          The coefficient.

* coefficient\ (name)

  Return coefficient with given name
  
  *Arguments*
      name (str)
          The name.
  
  *Returns*
      :py:class:`GenericFunction`
          The coefficient.
";

%feature("docstring")  dolfin::Form::coefficients "
Return all coefficients

*Returns*
    list of :py:class:`GenericFunction`
        All coefficients.
";

%feature("docstring")  dolfin::Form::coefficient_number "
Return the number of the coefficient with this name

*Arguments*
    name (str)
        The name.

*Returns*
    int
        The number of the coefficient with the given name.
";

%feature("docstring")  dolfin::Form::coefficient_name "
Return the name of the coefficient with this number

*Arguments*
    i (int)
        The number

*Returns*
    str
        The name of the coefficient with the given number.
";

%feature("docstring")  dolfin::Form::cell_domains_shared_ptr "
Return cell domains (zero pointer if no domains have been
specified)

*Returns*
    :py:class:`MeshFunction`
        The cell domains.
";

%feature("docstring")  dolfin::Form::exterior_facet_domains_shared_ptr "
Return exterior facet domains (zero pointer if no domains have
been specified)

*Returns*
    :py:class:`MeshFunction`
        The exterior facet domains.
";

%feature("docstring")  dolfin::Form::interior_facet_domains_shared_ptr "
Return interior facet domains (zero pointer if no domains have
been specified)

*Returns*
    :py:class:`MeshFunction`
        The interior facet domains.
";

%feature("docstring")  dolfin::Form::set_cell_domains "
Set cell domains

*Arguments*
    cell_domains (:py:class:`MeshFunction`)
        The cell domains.
";

%feature("docstring")  dolfin::Form::set_exterior_facet_domains "
Set exterior facet domains

*Arguments*
    exterior_facet_domains (:py:class:`MeshFunction`)
        The exterior facet domains.
";

%feature("docstring")  dolfin::Form::set_interior_facet_domains "
Set interior facet domains

*Arguments*
    interior_facet_domains (:py:class:`MeshFunction`)
        The interior facet domains.
";

%feature("docstring")  dolfin::Form::ufc_form "
Return UFC form shared pointer

*Returns*
    ufc::form
        The UFC form.
";

%feature("docstring")  dolfin::Form::check "
Check function spaces and coefficients
";

%feature("docstring")  dolfin::Form::operator== "
**Overloaded versions**

* operator==\ (rhs)

  Comparison operator, returning equation lhs == rhs

* operator==\ (rhs)

  Comparison operator, returning equation lhs == 0
";

// Documentation extracted from: (module=fem, header=Assembler.h)
%feature("docstring")  dolfin::Assembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

Subdomains for cells and facets may be specified in a number of
different ways:

1. By explicitly passing :py:class:`MeshFunction` (as pointers) to the
   assemble functions

2. By assigning subdomain indicators specified by :py:class:`MeshFunction`
   to the :py:class:`Form` being assembled:

   .. code-block:: c++

       form.dx = cell_domains
       form.ds = exterior_facet_domains
       form.dS = interior_facet_domains

3. By markers stored as part of the :py:class:`Mesh` (in :py:class:`MeshDomains`)

4. By specifying a :py:class:`SubDomain` which specifies the domain numbered
   as 0 (with the rest treated as domain number 1)

Note that (1) overrides (2), which overrides (3).
";

%feature("docstring")  dolfin::Assembler::assemble "
**Overloaded versions**

* assemble\ (A, a, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor from given form
  
  *Arguments*
      A (:py:class:`GenericTensor`)
          The tensor to assemble.
      a (:py:class:`Form`)
          The form to assemble the tensor from.
      reset_sparsity (bool)
          Optional argument: Default value is true.
          This controls whether the sparsity pattern of the
          given tensor is reset prior to assembly.
      add_values (bool)
          Optional argument: Default value is false.
          This controls whether values are added to the given
          tensor or if it is zeroed prior to assembly.
      finalize_tensor (bool)
          Optional argument: Default value is true.
          This controls whether the assembler finalizes the
          given tensor after assembly is completed by calling
          A.apply().

* assemble\ (A, a, sub_domain, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor from given form on subdomain
  
  *Arguments*
      A (:py:class:`GenericTensor`)
          The tensor to assemble.
      a (:py:class:`Form`)
          The form to assemble the tensor from.
      sub_domain (:py:class:`SubDomain`)
          The subdomain to assemble on.
      reset_sparsity (bool)
          Optional argument: Default value is true.
          This controls whether the sparsity pattern of the
          given tensor is reset prior to assembly.
      add_values (bool)
          Optional argument: Default value is false.
          This controls whether values are added to the given
          tensor or if it is zeroed prior to assembly.
      finalize_tensor (bool)
          Optional argument: Default value is true.
          This controls whether the assembler finalizes the
          given tensor after assembly is completed by calling
          A.apply().

* assemble\ (A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor from given form on subdomains
  
  *Arguments*
      A (:py:class:`GenericTensor`)
          The tensor to assemble.
      a (:py:class:`Form`)
          The form to assemble the tensor from.
      cell_domains (:py:class:`MeshFunction`)
          Cell domains.
      exterior_facet_domains (:py:class:`MeshFunction`)
          The exterior facet domains.
      interior_facet_domains (:py:class:`MeshFunction`)
          The interior facet domains.
      reset_sparsity (bool)
          Optional argument: Default value is true.
          This controls whether the sparsity pattern of the
          given tensor is reset prior to assembly.
      add_values (bool)
          Optional argument: Default value is false.
          This controls whether values are added to the given
          tensor or if it is zeroed prior to assembly.
      finalize_tensor (bool)
          Optional argument: Default value is true.
          This controls whether the assembler finalizes the
          given tensor after assembly is completed by calling
          A.apply().
";

%feature("docstring")  dolfin::Assembler::assemble_cells "
Assemble tensor from given form over cells. This function is
provided for users who wish to build a customized assembler.
";

%feature("docstring")  dolfin::Assembler::assemble_exterior_facets "
Assemble tensor from given form over exterior facets. This
function is provided for users who wish to build a customized
assembler.
";

%feature("docstring")  dolfin::Assembler::assemble_interior_facets "
Assemble tensor from given form over interior facets. This
function is provided for users who wish to build a customized
assembler.
";

// Documentation extracted from: (module=fem, header=SparsityPatternBuilder.h)
%feature("docstring")  dolfin::SparsityPatternBuilder "
This class provides functions to compute the sparsity pattern.
";

%feature("docstring")  dolfin::SparsityPatternBuilder::build "
Build sparsity pattern for assembly of given form
";

// Documentation extracted from: (module=fem, header=SystemAssembler.h)
%feature("docstring")  dolfin::SystemAssembler "
This class provides implements an assembler for systems
of the form Ax = b. It differs from the default DOLFIN
assembler in that it assembles both A and b and the same
time (leading to better performance) and in that it applies
boundary conditions at the time of assembly.
";

%feature("docstring")  dolfin::SystemAssembler::assemble "
**Overloaded versions**

* assemble\ (A, b, a, L, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b)

* assemble\ (A, b, a, L, bc, reset_sparsity=true, add_values=true, finalize_tensor=true)

  Assemble system (A, b) and apply Dirichlet boundary condition

* assemble\ (A, b, a, L, bcs, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b) and apply Dirichlet boundary conditions

* assemble\ (A, b, a, L, bcs, cell_domains, exterior_facet_domains, interior_facet_domains, x0, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble system (A, b) and apply Dirichlet boundary conditions
";

// Documentation extracted from: (module=fem, header=LinearVariationalProblem.h)
%feature("docstring")  dolfin::LinearVariationalProblem "
This class represents a linear variational problem:

Find u in V such that

    a(u, v) = L(v)  for all v in V^,

where V is the trial space and V^ is the test space.
";

%feature("docstring")  dolfin::LinearVariationalProblem::LinearVariationalProblem "
**Overloaded versions**

* LinearVariationalProblem\ (a, L, u)

  Create linear variational problem without boundary conditions

* LinearVariationalProblem\ (a, L, u, bc)

  Create linear variational problem with a single boundary condition

* LinearVariationalProblem\ (a, L, u, bcs)

  Create linear variational problem with a list of boundary conditions

* LinearVariationalProblem\ (a, L, u, bcs)

  Create linear variational problem with a list of boundary conditions
  (shared pointer version)
";

%feature("docstring")  dolfin::LinearVariationalProblem::bilinear_form "
Return bilinear form
";

%feature("docstring")  dolfin::LinearVariationalProblem::linear_form "
Return linear form
";

%feature("docstring")  dolfin::LinearVariationalProblem::solution "
**Overloaded versions**

* solution\ ()

  Return solution variable

* solution\ ()

  Return solution variable (const version)
";

%feature("docstring")  dolfin::LinearVariationalProblem::bcs "
Return boundary conditions
";

%feature("docstring")  dolfin::LinearVariationalProblem::trial_space "
Return trial space
";

%feature("docstring")  dolfin::LinearVariationalProblem::test_space "
Return test space
";

// Documentation extracted from: (module=fem, header=LinearVariationalSolver.h)
%feature("docstring")  dolfin::LinearVariationalSolver "
This class implements a solver for linear variational problems.
";

%feature("docstring")  dolfin::LinearVariationalSolver::LinearVariationalSolver "
**Overloaded versions**

* LinearVariationalSolver\ (problem)

  Create linear variational solver for given problem

* LinearVariationalSolver\ (problem)

  Create linear variational solver for given problem (shared pointer version)
";

%feature("docstring")  dolfin::LinearVariationalSolver::solve "
Solve variational problem
";

%feature("docstring")  dolfin::LinearVariationalSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=NonlinearVariationalProblem.h)
%feature("docstring")  dolfin::NonlinearVariationalProblem "
This class represents a nonlinear variational problem:

Find u in V such that

    F(u; v) = 0  for all v in V^,

where V is the trial space and V^ is the test space.
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::NonlinearVariationalProblem "
**Overloaded versions**

* NonlinearVariationalProblem\ (F, u)

  Create nonlinear variational problem without boundary conditions.
  The Jacobian form is not specified which requires the use of a
  nonlinear solver that does not rely on the Jacobian.

* NonlinearVariationalProblem\ (F, u, J)

  Create nonlinear variational problem without boundary conditions.
  The Jacobian form is specified which allows the use of a nonlinear
  solver that relies on the Jacobian (using Newton's method).

* NonlinearVariationalProblem\ (F, u, bc)

  Create nonlinear variational problem with a single boundary condition.
  The Jacobian form is not specified which requires the use of a
  nonlinear solver that does not rely on the Jacobian.

* NonlinearVariationalProblem\ (F, u, bc, J)

  Create nonlinear variational problem with a single boundary condition.
  The Jacobian form is specified which allows the use of a nonlinear
  solver that relies on the Jacobian (using Newton's method).

* NonlinearVariationalProblem\ (F, u, bcs)

  Create nonlinear variational problem with a list of boundary conditions.
  The Jacobian form is not specified which requires the use of a
  nonlinear solver that does not rely on the Jacobian.

* NonlinearVariationalProblem\ (F, u, bcs, J)

  Create nonlinear variational problem with a list of boundary conditions.
  The Jacobian form is specified which allows the use of a nonlinear
  solver that relies on the Jacobian (using Newton's method).

* NonlinearVariationalProblem\ (F, u, bcs)

  Create nonlinear variational problem, shared pointer version.
  The Jacobian form is not specified which requires the use of a
  nonlinear solver that does not rely on the Jacobian.

* NonlinearVariationalProblem\ (F, u, bcs, J)

  Create nonlinear variational problem, shared pointer version.
  The Jacobian form is specified which allows the use of a nonlinear
  solver that relies on the Jacobian (using Newton's method).
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::residual_form "
Return residual form
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::jacobian_form "
Return Jacobian form
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::solution "
**Overloaded versions**

* solution\ ()

  Return solution variable

* solution\ ()

  Return solution variable (const version)
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::bcs "
Return boundary conditions
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::trial_space "
Return trial space
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::test_space "
Return test space
";

%feature("docstring")  dolfin::NonlinearVariationalProblem::has_jacobian "
Check whether Jacobian has been defined
";

// Documentation extracted from: (module=fem, header=NonlinearVariationalSolver.h)
%feature("docstring")  dolfin::NonlinearVariationalSolver "
This class implements a solver for nonlinear variational problems.
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::NonlinearVariationalSolver "
**Overloaded versions**

* NonlinearVariationalSolver\ (problem)

  Create nonlinear variational solver for given problem

* NonlinearVariationalSolver\ (problem)

  Create nonlinear variational solver for given problem (shared pointer version)
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::solve "
Solve variational problem

*Returns*
    (int, bool)
        Pair of number of Newton iterations, and whether
        iteration converged)
";

%feature("docstring")  dolfin::NonlinearVariationalSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=fem, header=OpenMpAssembler.h)
%feature("docstring")  dolfin::OpenMpAssembler "
This class provides automated assembly of linear systems, or
more generally, assembly of a sparse tensor from a given
variational form.

The MeshFunction arguments can be used to specify assembly over
subdomains of the mesh cells, exterior facets or interior
facets. Either a null pointer or an empty MeshFunction may be
used to specify that the tensor should be assembled over the
entire set of cells or facets.
";

%feature("docstring")  dolfin::OpenMpAssembler::assemble "
**Overloaded versions**

* assemble\ (A, a, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor from given form

* assemble\ (A, a, cell_domains, exterior_facet_domains, interior_facet_domains, reset_sparsity=true, add_values=false, finalize_tensor=true)

  Assemble tensor from given form on sub domains
";

// Documentation extracted from: (module=fem, header=VariationalProblem.h)
%feature("docstring")  dolfin::VariationalProblem "
This class is deprecated and is only here to give an informative error
message to users about the new interface.
";

%feature("docstring")  dolfin::VariationalProblem::VariationalProblem "
**Overloaded versions**

* VariationalProblem\ (form_0, form_1)

  Deprecated

* VariationalProblem\ (form_0, form_1, bc)

  Deprecated

* VariationalProblem\ (form_0, form_1, bcs)

  Deprecated

* VariationalProblem\ (form_0, form_1, bcs)

  Deprecated
";

%feature("docstring")  dolfin::VariationalProblem::solve "
**Overloaded versions**

* solve\ (u)

  Deprecated

* solve\ (u0, u1)

  Deprecated

* solve\ (u0, u1, u2)

  Deprecated

* solve\ (u, tol, M)

  Deprecated

* solve\ (u, tol, M, ec)

  Deprecated
";

// Documentation extracted from: (module=log, header=log.h)
%feature("docstring")  dolfin::info "
**Overloaded versions**

* info\ (msg, ...)

  The DOLFIN log system provides the following set of functions for
  uniform handling of log messages, warnings and errors. In addition,
  macros are provided for debug messages and dolfin_assertions.
  
  Only messages with a debug level higher than or equal to the current
  log level are printed (the default being zero). Logging may also be
  turned off by calling set_log_active(false).
  Print message

* info\ (parameters, verbose=false)

  Print parameter (using output of str() method)

* info\ (variable, verbose=false)

  Print variable (using output of str() method)
";

%feature("docstring")  dolfin::info_stream "
Print message to stream
";

%feature("docstring")  dolfin::info_underline "
Print underlined message
";

%feature("docstring")  dolfin::warning "
Print warning
";

%feature("docstring")  dolfin::error "
Print error message and throw an exception.
Note to developers: this function should not be used internally
in DOLFIN. Use the more informative dolfin_error instead.
";

%feature("docstring")  dolfin::dolfin_error "
Print error message. Prefer this to the above generic error message.

*Arguments*
    location (str)
        Name of the file from which the error message was generated.
    task (str)
        Name of the task that failed.
        Note that this string should begin with lowercase.
        Note that this string should not be punctuated.
    reason (str)
        A format string explaining the reason for the failure.
        Note that this string should begin with uppercase.
        Note that this string should not be punctuated.
        Note that this string may contain printf style formatting.
    ... (primitive types like int, uint, double, bool)
        Optional arguments for the format string.

Developers should read the file dolfin/log/README in the DOLFIN
source tree for further notes about the use of this function.
";

%feature("docstring")  dolfin::log "
Print message at given debug level
";

%feature("docstring")  dolfin::begin "
**Overloaded versions**

* begin\ (msg, ...)

  Begin task (increase indentation level)

* begin\ (debug_level, msg, ...)

  Begin task (increase indentation level)
";

%feature("docstring")  dolfin::end "
End task (decrease indentation level)
";

%feature("docstring")  dolfin::set_log_active "
Turn logging on or off
";

%feature("docstring")  dolfin::set_log_level "
Set log level
";

%feature("docstring")  dolfin::set_output_stream "
Set output stream
";

%feature("docstring")  dolfin::get_log_level "
Get log level
";

%feature("docstring")  dolfin::list_timings "
List a summary of timings and tasks, optionally clearing stored timings
";

%feature("docstring")  dolfin::summary "
This function is deprecated, use list_timings
";

%feature("docstring")  dolfin::timing "
Return timing (average) for given task, optionally clearing timing for task
";

%feature("docstring")  dolfin::not_working_in_parallel "
Report that functionality has not (yet) been implemented to work in parallel
";

// Documentation extracted from: (module=log, header=Event.h)
%feature("docstring")  dolfin::Event "
A event is a string message which is displayed
only a limited number of times.

*Example*
    .. code-block:: python
    
        >>> event = dolfin.Event(\"System is stiff, damping is needed.\", 3)
        >>> for i in range(10):
        ...     if i > 7:
        ...         print i
        ...         event()
";

%feature("docstring")  dolfin::Event::Event "
Constructor
";

%feature("docstring")  dolfin::Event::operator "
Display message
";

%feature("docstring")  dolfin::Event::count "
Display count
";

%feature("docstring")  dolfin::Event::maxcount "
Maximum display count
";

// Documentation extracted from: (module=log, header=LogStream.h)
%feature("docstring")  dolfin::LogStream "
This class provides functionality similar to standard C++
streams (std::cout, std::endl) for output but working through
the DOLFIN log system.
";

%feature("docstring")  dolfin::LogStream::LogStream "
Create log stream of given type
";

%feature("docstring")  dolfin::LogStream::operator<< "
**Overloaded versions**

* operator<<\ (stream)

  Output for log stream

* operator<<\ (s)

  Output for string

* operator<<\ (a)

  Output for int

* operator<<\ (a)

  Output for unsigned int

* operator<<\ (a)

  Output for long int

* operator<<\ (a)

  Output for long int

* operator<<\ (a)

  Output for double

* operator<<\ (z)

  Output for complex

* operator<<\ (variable)

  Output for variable (calling str() method)

* operator<<\ (entity)

  Output for mesh entity (not subclass of Variable for efficiency)

* operator<<\ (point)

  Output for point (not subclass of Variable for efficiency)
";

// Documentation extracted from: (module=log, header=Progress.h)
%feature("docstring")  dolfin::Progress "
This class provides a simple way to create and update progress
bars during a computation.

*Example*
    A progress bar may be used either in an iteration with a known number
    of steps:
    
    .. code-block:: python
    
        >>> n = 1000000
        >>> p = dolfin.Progress(\"Iterating...\", n)
        >>> for i in range(n):
        ...     p += 1
    
    or in an iteration with an unknown number of steps:
    
    .. code-block:: python
    
        >>> pr = dolfin.Progress(\"Iterating\")
        >>> t = 0.0
        >>> n = 1000000.0
        >>> while t < n:
        ...     t += 1.0
        ...     p += t/n
";

%feature("docstring")  dolfin::Progress::Progress "
**Overloaded versions**

* Progress\ (title, n)

  Create progress bar with a known number of steps
  
  *Arguments*
      title (str)
          The title.
      n (int)
          Number of steps.

* Progress\ (title)

  Create progress bar with an unknown number of steps
  
  *Arguments*
      title (str)
          The title.
";

%feature("docstring")  dolfin::Progress::operator= "
Set current position

*Arguments*
    p (float)
        The position.
";

%feature("docstring")  dolfin::Progress::operator++ "
Increment progress
";

// Documentation extracted from: (module=log, header=Table.h)
%feature("docstring")  dolfin::Table "
This class provides storage and pretty-printing for tables.
Example usage:

  Table table(\"Timings\");

  table(\"uBLAS\",  \"Assemble\") = 0.010;
  table(\"uBLAS\",  \"Solve\")    = 0.020;
  table(\"PETSc\",  \"Assemble\") = 0.011;
  table(\"PETSc\",  \"Solve\")    = 0.019;
  table(\"Epetra\", \"Assemble\") = 0.012;
  table(\"Epetra\", \"Solve\")    = 0.018;

  info(table);
";

%feature("docstring")  dolfin::Table::Table "
Create empty table
";

%feature("docstring")  dolfin::Table::operator "
Return table entry
";

%feature("docstring")  dolfin::Table::set "
**Overloaded versions**

* set\ (row, col, value)

  Set value of table entry

* set\ (row, col, value)

  Set value of table entry

* set\ (row, col, value)

  Set value of table entry

* set\ (row, col, value)

  Set value of table entry
";

%feature("docstring")  dolfin::Table::get "
Get value of table entry
";

%feature("docstring")  dolfin::Table::get_value "
Get value of table entry
";

%feature("docstring")  dolfin::Table::title "
Return table title
";

%feature("docstring")  dolfin::Table::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Table::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Table::str_latex "
Return informal string representation for LaTeX
";

%feature("docstring")  dolfin::TableEntry "
This class represents an entry in a Table
";

%feature("docstring")  dolfin::TableEntry::TableEntry "
Create table entry
";

%feature("docstring")  dolfin::TableEntry::operator= "
**Overloaded versions**

* operator=\ (value)

  Assign value to table entry

* operator=\ (value)

  Assign value to table entry

* operator=\ (value)

  Assign value to table entry

* operator=\ (value)

  Assign value to table entry
";

%feature("docstring")  dolfin::TableEntry::operator std::string "
Cast to entry value
";

// Documentation extracted from: (module=log, header=LogLevel.h)
// Documentation extracted from: (module=la, header=ublas.h)
// Documentation extracted from: (module=la, header=GenericLinearSolver.h)
%feature("docstring")  dolfin::GenericLinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLinearSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::GenericLinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

// Documentation extracted from: (module=la, header=GenericLUSolver.h)
%feature("docstring")  dolfin::GenericLUSolver "
This a base class for LU solvers
";

%feature("docstring")  dolfin::GenericLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::GenericLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

// Documentation extracted from: (module=la, header=GenericTensor.h)
%feature("docstring")  dolfin::GenericTensor "
This class defines a common interface for arbitrary rank tensors.
";

%feature("docstring")  dolfin::GenericTensor::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::GenericTensor::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericTensor::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericTensor::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericTensor::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericTensor::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericTensor::get "
Get block of values
";

%feature("docstring")  dolfin::GenericTensor::set "
Set block of values
";

%feature("docstring")  dolfin::GenericTensor::add "
**Overloaded versions**

* add\ (block, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, num_rows, rows)

  Add block of values
";

%feature("docstring")  dolfin::GenericTensor::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericTensor::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericTensor::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericTensor::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::GenericTensor::down_cast "
**Overloaded versions**

* down_cast\ ()

  Cast a GenericTensor to its derived class (const version)

* down_cast\ ()

  Cast a GenericTensor to its derived class (non-const version)

* down_cast\ (A)

  Cast a GenericTensor shared ptr to its derived class. Caller
  must check for success (returns null if cast fails).
";

%feature("docstring")  dolfin::GenericTensor::has_type "
Check whether the GenericTensor instance matches a specific type
";

%feature("docstring")  dolfin::GenericTensor::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

%feature("docstring")  dolfin::GenericTensor::shared_instance "
**Overloaded versions**

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap (const version)

* shared_instance\ ()

  Return concrete shared ptr instance / unwrap
";

%feature("docstring")  dolfin::GenericTensor::operator= "
Assignment (must be overloaded by subclass)
";

// Documentation extracted from: (module=la, header=GenericMatrix.h)
%feature("docstring")  dolfin::GenericMatrix "
This class defines a common interface for matrices.
";

%feature("docstring")  dolfin::GenericMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericMatrix::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::GenericMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::GenericMatrix::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values

* get\ (block, m, rows, n, cols)

  Get block of values
";

%feature("docstring")  dolfin::GenericMatrix::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values

* set\ (block, m, rows, n, cols)

  Set block of values
";

%feature("docstring")  dolfin::GenericMatrix::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, m, rows, n, cols)

  Add block of values
";

%feature("docstring")  dolfin::GenericMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::GenericMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericMatrix::resize "
Resize vector y such that is it compatible with matrix for
multuplication Ax = b (dim = 0 -> b, dim = 1 -> x). In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::GenericMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::GenericMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::GenericMatrix::getrow "
Get non-zero values of given row on local process
";

%feature("docstring")  dolfin::GenericMatrix::setrow "
Set values for given row on local process
";

%feature("docstring")  dolfin::GenericMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::GenericMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::GenericMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::GenericMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::GenericMatrix::operator+= "
Add given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator-= "
Subtract given matrix
";

%feature("docstring")  dolfin::GenericMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::GenericMatrix::data "
Return pointers to underlying compresssed row/column storage data
For compressed row storage, data = (row_pointer[#rows +1],
column_index[#nz], matrix_values[#nz], nz)
";

%feature("docstring")  dolfin::GenericMatrix::operator "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericMatrix::setitem "
Set given entry to value. apply(\"insert\") should be called before using
using the object.
";

%feature("docstring")  dolfin::GenericMatrix::ident_zeros "
Insert one on the diagonal for all zero rows
";

// Documentation extracted from: (module=la, header=GenericSparsityPattern.h)
%feature("docstring")  dolfin::GenericSparsityPattern "
Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.
";

%feature("docstring")  dolfin::GenericSparsityPattern::GenericSparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::GenericSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_diagonal "
Fill vector with number of nonzeros for diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "
Fill vector with number of nonzeros for off-diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "
Finalize sparsity pattern
";

// Documentation extracted from: (module=la, header=GenericVector.h)
%feature("docstring")  dolfin::GenericVector "
This class defines a common interface for vectors.
";

%feature("docstring")  dolfin::GenericVector::resize "
**Overloaded versions**

* resize\ (rank, dims)

  Resize tensor with given dimensions

* resize\ (N)

  Resize vector to global size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::GenericVector::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::GenericVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::GenericVector::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::GenericVector::size "
**Overloaded versions**

* size\ (dim)

  Return size of given dimension

* size\ ()

  Return global size of vector
";

%feature("docstring")  dolfin::GenericVector::local_range "
**Overloaded versions**

* local_range\ (dim)

  Return local ownership range

* local_range\ ()

  Return local ownership range of a vector
";

%feature("docstring")  dolfin::GenericVector::get "
**Overloaded versions**

* get\ (block, num_rows, rows)

  Get block of values

* get\ (block, m, rows)

  Get block of values (values may live on any process)
";

%feature("docstring")  dolfin::GenericVector::set "
**Overloaded versions**

* set\ (block, num_rows, rows)

  Set block of values

* set\ (block, m, rows)

  Set block of values
";

%feature("docstring")  dolfin::GenericVector::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, m, rows)

  Add block of values
";

%feature("docstring")  dolfin::GenericVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::GenericVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::GenericVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::GenericVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::GenericVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::GenericVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values (values must all live on the local process)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::GenericVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::GenericVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::GenericVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into Array x
";

%feature("docstring")  dolfin::GenericVector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::GenericVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::GenericVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::GenericVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::GenericVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::GenericVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::GenericVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::GenericVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::GenericVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::GenericVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::GenericVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::GenericVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::GenericVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::GenericVector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::GenericVector::update_ghost_values "
Update ghost values
";

%feature("docstring")  dolfin::GenericVector::operator[] "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::getitem "
Get value of given entry
";

%feature("docstring")  dolfin::GenericVector::setitem "
Set given entry to value. apply(\"insert\") should be called before using
using the object.
";

// Documentation extracted from: (module=la, header=GenericSparsityPattern.h)
%feature("docstring")  dolfin::GenericSparsityPattern "
Base class (interface) for generic tensor sparsity patterns.
Currently, this interface is mostly limited to matrices.
";

%feature("docstring")  dolfin::GenericSparsityPattern::GenericSparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::GenericSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::GenericSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::GenericSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::GenericSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::GenericSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_diagonal "
Fill vector with number of nonzeros for diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::num_nonzeros_off_diagonal "
Fill vector with number of nonzeros for off-diagonal block in local_range for dimension 0
";

%feature("docstring")  dolfin::GenericSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::GenericSparsityPattern::apply "
Finalize sparsity pattern
";

// Documentation extracted from: (module=la, header=PETScObject.h)
%feature("docstring")  dolfin::PETScObject "
This class calls SubSystemsManager to initialise PETSc.

All PETSc objects must be derived from this class.
";

// Documentation extracted from: (module=la, header=PETScBaseMatrix.h)
%feature("docstring")  dolfin::PETScBaseMatrix "
This class is a base class for matrices that can be used in
PETScKrylovSolver.
";

%feature("docstring")  dolfin::PETScBaseMatrix::PETScBaseMatrix "
**Overloaded versions**

* PETScBaseMatrix\ ()

  Constructor

* PETScBaseMatrix\ (A)

  Constructor
";

%feature("docstring")  dolfin::PETScBaseMatrix::resize "
**Overloaded versions**

* resize\ (m, n)

  Resize virtual matrix

* resize\ (y, dim)

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::PETScBaseMatrix::size "
Return number of rows (dim = 0) or columns (dim = 1)
";

%feature("docstring")  dolfin::PETScBaseMatrix::local_range "
Return local range along dimension dim
";

%feature("docstring")  dolfin::PETScBaseMatrix::mat "
Return PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScBaseMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=uBLASFactory.h)
%feature("docstring")  dolfin::uBLASFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::uBLASFactory::create_vector "
Create empty vector
";

%feature("docstring")  dolfin::uBLASFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::uBLASFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::uBLASFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::uBLASFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::uBLASFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::uBLASFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::uBLASFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::uBLASFactory::instance "
Return singleton instance
";

// Documentation extracted from: (module=la, header=uBLASMatrix.h)
%feature("docstring")  dolfin::uBLASMatrix "
This class provides a simple matrix class based on uBLAS.
It is a simple wrapper for a uBLAS matrix implementing the
GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS matrix and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.

Developer note: specialised member functions must be
inlined to avoid link errors.
";

%feature("docstring")  dolfin::uBLASMatrix::uBLASMatrix "
**Overloaded versions**

* uBLASMatrix\ ()

  Create empty matrix

* uBLASMatrix\ (M, N)

  Create M x N matrix

* uBLASMatrix\ (A)

  Copy constructor

* uBLASMatrix\ (A)

  Create matrix from given uBLAS matrix expression
";

%feature("docstring")  dolfin::uBLASMatrix::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::uBLASMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::uBLASMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::uBLASMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::uBLASMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::uBLASMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::uBLASMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASMatrix::resize "
**Overloaded versions**

* resize\ (M, N)

  Resize matrix to M x N

* resize\ (y, dim)

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::uBLASMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::uBLASMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::uBLASMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::uBLASMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::uBLASMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::uBLASMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::uBLASMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::uBLASMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::uBLASMatrix::transpmult "
Matrix-vector product, y = A^T x
";

%feature("docstring")  dolfin::uBLASMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::uBLASMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::uBLASMatrix::data "
Return pointers to underlying compresssed storage data
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::uBLASMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASMatrix::mat "
**Overloaded versions**

* mat\ ()

  Return reference to uBLAS matrix (const version)

* mat\ ()

  Return reference to uBLAS matrix (non-const version)
";

%feature("docstring")  dolfin::uBLASMatrix::solve "
Solve Ax = b out-of-place using uBLAS (A is not destroyed)
";

%feature("docstring")  dolfin::uBLASMatrix::solveInPlace "
**Overloaded versions**

* solveInPlace\ (x, b)

  Solve Ax = b in-place using uBLAS(A is destroyed)

* solveInPlace\ (X)

  General uBLAS LU solver which accepts both vector and matrix right-hand sides
";

%feature("docstring")  dolfin::uBLASMatrix::invert "
Compute inverse of matrix
";

%feature("docstring")  dolfin::uBLASMatrix::lump "
Lump matrix into vector m
";

%feature("docstring")  dolfin::uBLASMatrix::compress "
Compress matrix (eliminate all non-zeros from a sparse matrix)
";

%feature("docstring")  dolfin::uBLASMatrix::operator "
Access value of given entry
";

// Documentation extracted from: (module=la, header=uBLASKrylovMatrix.h)
%feature("docstring")  dolfin::uBLASKrylovMatrix "
This class provides an interface for matrices that define linear
systems for the uBLASKrylovSolver. This interface is implemented
by the classes uBLASSparseMatrix and DenseMatrix. Users may also
overload the mult() function to specify a linear system only in
terms of its action.
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::uBLASKrylovMatrix "
Constructor
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::size "
Return number of rows (dim = 0) or columns (dim = 1)
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::mult "
Compute product y = Ax
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::solve "
Solve linear system Ax = b for a Krylov matrix using uBLAS and dense matrices
";

%feature("docstring")  dolfin::uBLASKrylovMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=PETScMatrix.h)
%feature("docstring")  dolfin::PETScMatrix "
This class provides a simple matrix class based on PETSc.
It is a wrapper for a PETSc matrix pointer (Mat)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Mat pointer using the function mat() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScMatrix::PETScMatrix "
**Overloaded versions**

* PETScMatrix\ ()

  Create empty matrix

* PETScMatrix\ (A)

  Copy constructor

* PETScMatrix\ (A)

  Create matrix from given PETSc Mat pointer
";

%feature("docstring")  dolfin::PETScMatrix::distributed "
Return true if matrix is distributed
";

%feature("docstring")  dolfin::PETScMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::PETScMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::PETScMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::PETScMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::PETScMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::PETScMatrix::apply "
Finalize assembly of tensor. The following values are recognized
for the mode parameter:

  add    - corresponding to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  insert - corresponding to PETSc MatAssemblyBegin+End(MAT_FINAL_ASSEMBLY)
  flush  - corresponding to PETSc MatAssemblyBegin+End(MAT_FLUSH_ASSEMBLY)
";

%feature("docstring")  dolfin::PETScMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScMatrix::resize "
**Overloaded versions**

* resize\ (M, N)

  Resize matrix to M x N

* resize\ (y, dim)

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::PETScMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::PETScMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::PETScMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::PETScMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::PETScMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::PETScMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::PETScMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::PETScMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::PETScMatrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::PETScMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::PETScMatrix::binary_dump "
Dump matrix to PETSc binary format
";

// Documentation extracted from: (module=la, header=PETScKrylovMatrix.h)
%feature("docstring")  dolfin::PETScKrylovMatrix "
This class represents a matrix-free matrix of dimension m x m.
It is a simple wrapper for a PETSc shell matrix. The interface
is intentionally simple. For advanced usage, access the PETSc
Mat pointer using the function mat() and use the standard PETSc
interface.

The class PETScKrylovMatrix enables the use of Krylov subspace
methods for linear systems Ax = b, without having to explicitly
store the matrix A. All that is needed is that the user-defined
PETScKrylovMatrix implements multiplication with vectors. Note that
the multiplication operator needs to be defined in terms of
PETSc data structures (Vec), since it will be called from PETSc.
";

%feature("docstring")  dolfin::PETScKrylovMatrix::PETScKrylovMatrix "
**Overloaded versions**

* PETScKrylovMatrix\ ()

  Constructor

* PETScKrylovMatrix\ (m, n)

  Create a virtual matrix matching the given vectors
";

%feature("docstring")  dolfin::PETScKrylovMatrix::resize "
Resize virtual matrix
";

%feature("docstring")  dolfin::PETScKrylovMatrix::mult "
Compute product y = Ax
";

%feature("docstring")  dolfin::PETScKrylovMatrix::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=PETScPreconditioner.h)
%feature("docstring")  dolfin::PETScPreconditioner "
This class is a wrapper for configuring PETSc preconditioners. It does
not own a preconditioner. It can take a PETScKrylovSolver and set the
preconditioner type and parameters.
";

%feature("docstring")  dolfin::PETScPreconditioner::PETScPreconditioner "
Create a particular preconditioner object
";

%feature("docstring")  dolfin::PETScPreconditioner::set "
Set the precondtioner type and parameters
";

%feature("docstring")  dolfin::PETScPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScPreconditioner::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=EpetraLUSolver.h)
%feature("docstring")  dolfin::EpetraLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of Epetra.
";

%feature("docstring")  dolfin::EpetraLUSolver::EpetraLUSolver "
**Overloaded versions**

* EpetraLUSolver\ (method=\"default\")

  Constructor

* EpetraLUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::EpetraLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::EpetraLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::EpetraLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::EpetraLUSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::EpetraLUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::EpetraLUSolver::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=EpetraKrylovSolver.h)
%feature("docstring")  dolfin::EpetraKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of Epetra.
";

%feature("docstring")  dolfin::EpetraKrylovSolver::EpetraKrylovSolver "
**Overloaded versions**

* EpetraKrylovSolver\ (\"default\", \"default\")

  Create Krylov solver for a particular method and preconditioner

* EpetraKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and TrilinosPreconditioner
";

%feature("docstring")  dolfin::EpetraKrylovSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::set_operators "
Set the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::get_operator "
Get the operator (matrix)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::EpetraKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::EpetraKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::EpetraKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::EpetraKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraKrylovSolver::aztecoo "
Return pointer to Aztec00
";

// Documentation extracted from: (module=la, header=EpetraMatrix.h)
%feature("docstring")  dolfin::EpetraMatrix "
This class provides a simple matrix class based on Epetra.
It is a simple wrapper for an Epetra matrix object (Epetra_FECrsMatrix)
implementing the GenericMatrix interface.

The interface is intentionally simple. For advanced usage,
access the Epetra_FECrsMatrix object using the function mat() and
use the standard Epetra interface.
";

%feature("docstring")  dolfin::EpetraMatrix::EpetraMatrix "
**Overloaded versions**

* EpetraMatrix\ ()

  Create empty matrix

* EpetraMatrix\ (A)

  Copy constuctor

* EpetraMatrix\ (A)

  Create matrix from given Epetra_FECrsMatrix pointer

* EpetraMatrix\ (graph)

  Create matrix from given Epetra_CrsGraph
";

%feature("docstring")  dolfin::EpetraMatrix::distributed "
Return true if matrix is distributed
";

%feature("docstring")  dolfin::EpetraMatrix::init "
**Overloaded versions**

* init\ (sparsity_pattern)

  Initialize zero tensor using sparsity pattern

* init\ (sparsity_pattern)

  Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::EpetraMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::EpetraMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::EpetraMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::EpetraMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::EpetraMatrix::apply "
Finalize assembly of tensor. The following values are recognized
for the mode parameter:

  add    - corresponding to Epetra GlobalAssemble(Add)
  insert - corresponding to Epetra GlobalAssemble(Insert)
";

%feature("docstring")  dolfin::EpetraMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraMatrix::resize "
Resize vector y such that is it compatible with matrix for
multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::EpetraMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::EpetraMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::EpetraMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::EpetraMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::EpetraMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::EpetraMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::EpetraMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::EpetraMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::EpetraMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::EpetraMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::EpetraMatrix::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::EpetraMatrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EpetraMatrix::mat "
Return Epetra_FECrsMatrix pointer
";

// Documentation extracted from: (module=la, header=EpetraVector.h)
%feature("docstring")  dolfin::EpetraVector "
This class provides a simple vector class based on Epetra.
It is a simple wrapper for an Epetra vector object (Epetra_FEVector)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the Epetra_FEVector object using the function vec() or vec_ptr()
and use the standard Epetra interface.
";

%feature("docstring")  dolfin::EpetraVector::EpetraVector "
**Overloaded versions**

* EpetraVector\ (type=\"global\")

  Create empty vector

* EpetraVector\ (N, type=\"global\")

  Create vector of size N

* EpetraVector\ (x)

  Copy constructor

* EpetraVector\ (vector)

  Create vector view from given Epetra_FEVector pointer

* EpetraVector\ (map)

  Create vector from given Epetra_BlockMap
";

%feature("docstring")  dolfin::EpetraVector::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::EpetraVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::EpetraVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::EpetraVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::EpetraVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::EpetraVector::resize "
**Overloaded versions**

* resize\ (N)

  Resize vector to size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::EpetraVector::size "
Return size of vector
";

%feature("docstring")  dolfin::EpetraVector::local_size "
Return size of local vector
";

%feature("docstring")  dolfin::EpetraVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::EpetraVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::EpetraVector::set "
Set block of values
";

%feature("docstring")  dolfin::EpetraVector::add "
Add block of values
";

%feature("docstring")  dolfin::EpetraVector::get_local "
Get all values on local process
";

%feature("docstring")  dolfin::EpetraVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::EpetraVector::add_local "
Add all values to each entry on local process
";

%feature("docstring")  dolfin::EpetraVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into Array x
";

%feature("docstring")  dolfin::EpetraVector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::EpetraVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::EpetraVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::EpetraVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::EpetraVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::EpetraVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::EpetraVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::EpetraVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::EpetraVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::EpetraVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::EpetraVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::EpetraVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::EpetraVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::EpetraVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::EpetraVector::reset "
Reset Epetra_FEVector
";

%feature("docstring")  dolfin::EpetraVector::vec "
Return Epetra_FEVector pointer
";

// Documentation extracted from: (module=la, header=PETScKrylovSolver.h)
%feature("docstring")  dolfin::PETScKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of PETSc.
";

%feature("docstring")  dolfin::PETScKrylovSolver::PETScKrylovSolver "
**Overloaded versions**

* PETScKrylovSolver\ (\"default\", \"default\")

  Create Krylov solver for a particular method and names preconditioner

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and PETScPreconditioner

* PETScKrylovSolver\ (method, preconditioner)

  Create Krylov solver for a particular method and PETScPreconditioner

* PETScKrylovSolver\ (ksp)

  Create solver from given PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::set_operators "
**Overloaded versions**

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix

* set_operators\ (A, P)

  Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::PETScKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::PETScKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScKrylovSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::PETScKrylovSolver::init "
Initialize KSP solver
";

%feature("docstring")  dolfin::PETScKrylovSolver::write_report "
Report the number of iterations
";

// Documentation extracted from: (module=la, header=PETScLUSolver.h)
%feature("docstring")  dolfin::PETScLUSolver "
This class implements the direct solution (LU factorization) for
linear systems of the form Ax = b. It is a wrapper for the LU
solver of PETSc.
";

%feature("docstring")  dolfin::PETScLUSolver::PETScLUSolver "
**Overloaded versions**

* PETScLUSolver\ (method=\"default\")

  Constructor

* PETScLUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::PETScLUSolver::set_operator "
**Overloaded versions**

* set_operator\ (A)

  Set operator (matrix)

* set_operator\ (A)

  Set operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::PETScLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::PETScLUSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScLUSolver::ksp "
Return PETSc KSP pointer
";

%feature("docstring")  dolfin::PETScLUSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::PETScLUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=CholmodCholeskySolver.h)
%feature("docstring")  dolfin::CholmodCholeskySolver "
This class implements the direct solution (Cholesky
factorization) of linear systems of the form Ax = b. Sparse
matrices are solved using CHOLMOD
http://www.cise.ufl.edu/research/sparse/cholmod/ if installed.
";

%feature("docstring")  dolfin::CholmodCholeskySolver::CholmodCholeskySolver "
**Overloaded versions**

* CholmodCholeskySolver\ ()

  Constructor

* CholmodCholeskySolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::CholmodCholeskySolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::CholmodCholeskySolver::solve "
Solve linear system Ax = b for a sparse matrix using CHOLMOD
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorize "
Cholesky-factor sparse matrix A if CHOLMOD is installed
";

%feature("docstring")  dolfin::CholmodCholeskySolver::factorized_solve "
Solve factorized system (CHOLMOD).
";

%feature("docstring")  dolfin::CholmodCholeskySolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::Cholmod::clear "
Clear data
";

%feature("docstring")  dolfin::Cholmod::init "
Initialise with matrix
";

%feature("docstring")  dolfin::Cholmod::factorize "
Factorize
";

%feature("docstring")  dolfin::Cholmod::factorized_solve "
Factorized solve
";

%feature("docstring")  dolfin::Cholmod::residual "
Compute residual: b-Ax
";

%feature("docstring")  dolfin::Cholmod::residual_norm "
Compute residual norm
";

%feature("docstring")  dolfin::Cholmod::refine_once "
Perform one refinement
";

%feature("docstring")  dolfin::Cholmod::check_status "
Check status flag returned by an CHOLMOD function
";

// Documentation extracted from: (module=la, header=UmfpackLUSolver.h)
%feature("docstring")  dolfin::UmfpackLUSolver "
This class implements the direct solution (LU factorization) of
linear systems of the form Ax = b using UMFPACK
(http://www.cise.ufl.edu/research/sparse/umfpack/) if installed.
";

%feature("docstring")  dolfin::UmfpackLUSolver::UmfpackLUSolver "
**Overloaded versions**

* UmfpackLUSolver\ ()

  Constructor

* UmfpackLUSolver\ (A)

  Constructor
";

%feature("docstring")  dolfin::UmfpackLUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::UmfpackLUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b for a sparse matrix using UMFPACK if installed

* solve\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::UmfpackLUSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::UmfpackLUSolver::numeric_factorize "
LU factorisation
";

%feature("docstring")  dolfin::UmfpackLUSolver::solve_factorized "
Solve factorized system (UMFPACK).
";

%feature("docstring")  dolfin::UmfpackLUSolver::umfpack_check_status "
Check status flag returned by an UMFPACK function
";

// Documentation extracted from: (module=la, header=ITLKrylovSolver.h)
%feature("docstring")  dolfin::ITLKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b. It is a wrapper for the Krylov solvers
of ITL.
";

%feature("docstring")  dolfin::ITLKrylovSolver::ITLKrylovSolver "
Create Krylov solver for a particular method and preconditioner
";

%feature("docstring")  dolfin::ITLKrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::ITLKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::ITLKrylovSolver::get_operator "
Get operator (matrix)
";

%feature("docstring")  dolfin::ITLKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::ITLKrylovSolver::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::ITLKrylovSolver::methods "
Return a list of available methods
";

%feature("docstring")  dolfin::ITLKrylovSolver::preconditioners "
Return a list available preconditioners
";

%feature("docstring")  dolfin::ITLKrylovSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=MTL4Matrix.h)
%feature("docstring")  dolfin::MTL4Matrix::MTL4Matrix "
**Overloaded versions**

* MTL4Matrix\ ()

  Create empty matrix

* MTL4Matrix\ (A)

  Copy constuctor

* MTL4Matrix\ (M, N, nz)

  Create M x N matrix with estimate of nonzeroes per row
";

%feature("docstring")  dolfin::MTL4Matrix::distributed "
Return true if matrix is distributed
";

%feature("docstring")  dolfin::MTL4Matrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::MTL4Matrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::MTL4Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::MTL4Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::MTL4Matrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::MTL4Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::MTL4Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::MTL4Matrix::resize "
**Overloaded versions**

* resize\ (M, N)

  Resize matrix to M x N

* resize\ (y, dim)

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.
";

%feature("docstring")  dolfin::MTL4Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::MTL4Matrix::set "
Set block of values
";

%feature("docstring")  dolfin::MTL4Matrix::add "
Add block of values
";

%feature("docstring")  dolfin::MTL4Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::MTL4Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::MTL4Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::MTL4Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::MTL4Matrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::MTL4Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::MTL4Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::MTL4Matrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::MTL4Matrix::data "
Return pointers to underlying compresssed storage data
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::MTL4Matrix::mat "
Return mtl4_sparse_matrix reference
";

// Documentation extracted from: (module=la, header=STLMatrix.h)
%feature("docstring")  dolfin::STLMatrix "
Simple STL-based implementation of the GenericMatrix interface.
The sparse matrix is stored as a pair of std::vector of
std::vector, one for the columns and one for the values.

Historically, this class has undergone a number of different
incarnations, based on various combinations of std::vector,
std::set and std::map. The current implementation has proven to
be the fastest.
";

%feature("docstring")  dolfin::STLMatrix::STLMatrix "
**Overloaded versions**

* STLMatrix\ ()

  Create empty matrix

* STLMatrix\ (M, N)

  Create M x N matrix

* STLMatrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::STLMatrix::distributed "
--- Implementation of the GenericTensor interface ---
Return true if matrix is distributed
";

%feature("docstring")  dolfin::STLMatrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::STLMatrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::STLMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::STLMatrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::STLMatrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::STLMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::STLMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::STLMatrix::resize "
**Overloaded versions**

* resize\ (M, N)

  Initialize M x N matrix

* resize\ (y, dim)

  Resize vector y such that is it compatible with matrix for
  multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
  case, size and layout are important.

* resize\ (rank, dims, reset)

  Resize tensor of given rank and dimensions
";

%feature("docstring")  dolfin::STLMatrix::get "
Get block of values
";

%feature("docstring")  dolfin::STLMatrix::set "
Set block of values
";

%feature("docstring")  dolfin::STLMatrix::add "
Add block of values
";

%feature("docstring")  dolfin::STLMatrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::STLMatrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::STLMatrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::STLMatrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::STLMatrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::STLMatrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::STLMatrix::operator= "
Assignment operator
";

%feature("docstring")  dolfin::STLMatrix::factory "
--- Specialized matrix functions ---
Return linear algebra backend factory
";

// Documentation extracted from: (module=la, header=uBLASVector.h)
%feature("docstring")  dolfin::uBLASVector "
This class provides a simple vector class based on uBLAS.
It is a simple wrapper for a uBLAS vector implementing the
GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the underlying uBLAS vector and use the standard
uBLAS interface which is documented at
http://www.boost.org/libs/numeric/ublas/doc/index.htm.
";

%feature("docstring")  dolfin::uBLASVector::uBLASVector "
**Overloaded versions**

* uBLASVector\ ()

  Create empty vector

* uBLASVector\ (N)

  Create vector of size N

* uBLASVector\ (x)

  Copy constructor

* uBLASVector\ (x)

  Construct vector from a ublas_vector
";

%feature("docstring")  dolfin::uBLASVector::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::uBLASVector::copy "
Create copy of tensor
";

%feature("docstring")  dolfin::uBLASVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::uBLASVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::uBLASVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::uBLASVector::resize "
**Overloaded versions**

* resize\ (N)

  Resize vector to size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::uBLASVector::size "
Return size of vector
";

%feature("docstring")  dolfin::uBLASVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::uBLASVector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::uBLASVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::uBLASVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::uBLASVector::set "
Set block of values
";

%feature("docstring")  dolfin::uBLASVector::add "
Add block of values
";

%feature("docstring")  dolfin::uBLASVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::uBLASVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::uBLASVector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into Array x
";

%feature("docstring")  dolfin::uBLASVector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::uBLASVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::uBLASVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::uBLASVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::uBLASVector::norm "
Compute norm of vector
";

%feature("docstring")  dolfin::uBLASVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::uBLASVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::uBLASVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::uBLASVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::uBLASVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::uBLASVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::uBLASVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::uBLASVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::uBLASVector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::uBLASVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::uBLASVector::vec "
**Overloaded versions**

* vec\ ()

  Return reference to uBLAS vector (const version)

* vec\ ()

  Return reference to uBLAS vector (non-const version)
";

%feature("docstring")  dolfin::uBLASVector::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

// Documentation extracted from: (module=la, header=PETScVector.h)
%feature("docstring")  dolfin::PETScVector "
This class provides a simple vector class based on PETSc.
It is a simple wrapper for a PETSc vector pointer (Vec)
implementing the GenericVector interface.

The interface is intentionally simple. For advanced usage,
access the PETSc Vec pointer using the function vec() and
use the standard PETSc interface.
";

%feature("docstring")  dolfin::PETScVector::PETScVector "
**Overloaded versions**

* PETScVector\ (type=\"global\")

  Create empty vector

* PETScVector\ (N, type=\"global\")

  Create vector of size N

* PETScVector\ (sparsity_pattern)

  Create vector

* PETScVector\ (x)

  Copy constructor

* PETScVector\ (x)

  Create vector from given PETSc Vec pointer
";

%feature("docstring")  dolfin::PETScVector::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::PETScVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::PETScVector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::PETScVector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::PETScVector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::PETScVector::resize "
**Overloaded versions**

* resize\ (N)

  Resize vector to global size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::PETScVector::size "
Return size of vector
";

%feature("docstring")  dolfin::PETScVector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::PETScVector::local_range "
Return ownership range of a vector
";

%feature("docstring")  dolfin::PETScVector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::PETScVector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values (values must all live on the local process)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::PETScVector::set "
Set block of values
";

%feature("docstring")  dolfin::PETScVector::add "
Add block of values
";

%feature("docstring")  dolfin::PETScVector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::PETScVector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::PETScVector::gather "
**Overloaded versions**

* gather\ (y, indices)

  Gather vector entries into a local vector

* gather\ (x, indices)

  Gather entries into Array x
";

%feature("docstring")  dolfin::PETScVector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::PETScVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::PETScVector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::PETScVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::PETScVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::PETScVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::PETScVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::PETScVector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector
";

%feature("docstring")  dolfin::PETScVector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::PETScVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::PETScVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::PETScVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::PETScVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::PETScVector::reset "
Reset data and PETSc vector object
";

%feature("docstring")  dolfin::PETScVector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::PETScVector::vec "
Return shared_ptr to PETSc Vec object
";

// Documentation extracted from: (module=la, header=MTL4Vector.h)
%feature("docstring")  dolfin::MTL4Vector::MTL4Vector "
**Overloaded versions**

* MTL4Vector\ ()

  Create empty vector

* MTL4Vector\ (N)

  Create vector of size N

* MTL4Vector\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::MTL4Vector::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::MTL4Vector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::MTL4Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::MTL4Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::MTL4Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::MTL4Vector::resize "
**Overloaded versions**

* resize\ (N)

  Resize vector to size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::MTL4Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::MTL4Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::MTL4Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::MTL4Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::MTL4Vector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::MTL4Vector::set "
Set block of values
";

%feature("docstring")  dolfin::MTL4Vector::add "
Add block of values
";

%feature("docstring")  dolfin::MTL4Vector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::MTL4Vector::add_local "
Add all values to each entry on local process
";

%feature("docstring")  dolfin::MTL4Vector::gather "
Gather entries into local vector x
";

%feature("docstring")  dolfin::MTL4Vector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::MTL4Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::MTL4Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::MTL4Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::MTL4Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::MTL4Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::MTL4Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::MTL4Vector::sum "
**Overloaded versions**

* sum\ ()

  Return sum of values of vector

* sum\ (rows)

  Return sum of selected rows in vector. Repeated entries are only summed once.
";

%feature("docstring")  dolfin::MTL4Vector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::MTL4Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::MTL4Vector::operator= "
**Overloaded versions**

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::MTL4Vector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::MTL4Vector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::MTL4Vector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data (non-const version)
";

%feature("docstring")  dolfin::MTL4Vector::vec "
**Overloaded versions**

* vec\ ()

  Return const mtl4_vector reference

* vec\ ()

  Return mtl4_vector reference
";

// Documentation extracted from: (module=la, header=SparsityPattern.h)
%feature("docstring")  dolfin::SparsityPattern "
This class implements the GenericSparsityPattern interface.
It is used by most linear algebra backends.
";

%feature("docstring")  dolfin::SparsityPattern::SparsityPattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::SparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::SparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::SparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::SparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros "
Return total number of nonzeros in local_range for dimension 0
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for off-diagonal block
";

%feature("docstring")  dolfin::SparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::SparsityPattern::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::SparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::SparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

// Documentation extracted from: (module=la, header=EpetraSparsityPattern.h)
%feature("docstring")  dolfin::EpetraSparsityPattern "
This class implements the GenericSparsityPattern interface for
the Epetra backend. The common interface is mostly
ignored. Instead, the sparsity pattern is represented as an
Epetra_FECrsGraph and a dynamic_cast is used to retrieve the
underlying representation when creating Epetra matrices.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::EpetraSparsityPattern "
Constructor
";

%feature("docstring")  dolfin::EpetraSparsityPattern::init "
Initialize sparsity pattern for a generic tensor
";

%feature("docstring")  dolfin::EpetraSparsityPattern::insert "
Insert non-zero entries
";

%feature("docstring")  dolfin::EpetraSparsityPattern::rank "
Return rank
";

%feature("docstring")  dolfin::EpetraSparsityPattern::size "
Return global size for dimension i
";

%feature("docstring")  dolfin::EpetraSparsityPattern::local_range "
Return local range for dimension dim
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros "
Return total number of nonzeros in local rows
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros_diagonal "
Fill array with number of nonzeros for diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for diagonal block
";

%feature("docstring")  dolfin::EpetraSparsityPattern::num_nonzeros_off_diagonal "
Fill array with number of nonzeros for off-diagonal block in local_range for dimension 0
For matrices, fill array with number of nonzeros per local row for off-diagonal block
";

%feature("docstring")  dolfin::EpetraSparsityPattern::diagonal_pattern "
Return underlying sparsity pattern (diagonal). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::off_diagonal_pattern "
Return underlying sparsity pattern (off-diagional). Options are
'sorted' and 'unsorted'.
";

%feature("docstring")  dolfin::EpetraSparsityPattern::apply "
Finalize sparsity pattern
";

%feature("docstring")  dolfin::EpetraSparsityPattern::pattern "
Return Epetra CRS graph
";

// Documentation extracted from: (module=la, header=LinearAlgebraFactory.h)
%feature("docstring")  dolfin::LinearAlgebraFactory::LinearAlgebraFactory "
Constructor
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_pattern "
Create empty sparsity pattern (returning zero if not used/needed)
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::LinearAlgebraFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::LinearAlgebraFactory::lu_solver_methods "
Return a list of available LU solver methods.
This function should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::LinearAlgebraFactory::krylov_solver_methods "
Return a list of available Krylov solver methods.
This function should be overloaded by subclass if non-empty.
";

%feature("docstring")  dolfin::LinearAlgebraFactory::krylov_solver_preconditioners "
Return a list of available preconditioners.
This function should be overloaded by subclass if non-empty.
";

// Documentation extracted from: (module=la, header=DefaultFactory.h)
%feature("docstring")  dolfin::DefaultFactory::DefaultFactory "
Constructor
";

%feature("docstring")  dolfin::DefaultFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::DefaultFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::DefaultFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::DefaultFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::DefaultFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::DefaultFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::DefaultFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::DefaultFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::DefaultFactory::factory "
Return instance of default backend
";

// Documentation extracted from: (module=la, header=PETScUserPreconditioner.h)
%feature("docstring")  dolfin::PETScUserPreconditioner "
This class specifies the interface for user-defined Krylov
method PETScPreconditioners. A user wishing to implement her own
PETScPreconditioner needs only supply a function that approximately
solves the linear system given a right-hand side.
";

%feature("docstring")  dolfin::PETScUserPreconditioner::PETScUserPreconditioner "
Constructor
";

%feature("docstring")  dolfin::PETScUserPreconditioner::solve "
Solve linear system approximately for given right-hand side b
";

// Documentation extracted from: (module=la, header=PETScFactory.h)
%feature("docstring")  dolfin::PETScFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::PETScFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::PETScFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::PETScFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::PETScFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::PETScFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::PETScFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::PETScFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::PETScFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::PETScFactory::PETScFactory "
Private constructor
";

// Documentation extracted from: (module=la, header=EpetraFactory.h)
%feature("docstring")  dolfin::EpetraFactory::create_matrix "
--- LinearAlgebraFactory interface
Create empty matrix
";

%feature("docstring")  dolfin::EpetraFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::EpetraFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::EpetraFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::EpetraFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::EpetraFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::EpetraFactory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::EpetraFactory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::EpetraFactory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

// Documentation extracted from: (module=la, header=MTL4Factory.h)
%feature("docstring")  dolfin::MTL4Factory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::MTL4Factory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::MTL4Factory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::MTL4Factory::create_pattern "
Dummy sparsity pattern
";

%feature("docstring")  dolfin::MTL4Factory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::MTL4Factory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::MTL4Factory::lu_solver_methods "
Return a list of available LU solver methods
";

%feature("docstring")  dolfin::MTL4Factory::krylov_solver_methods "
Return a list of available Krylov solver methods
";

%feature("docstring")  dolfin::MTL4Factory::krylov_solver_preconditioners "
Return a list of available preconditioners
";

// Documentation extracted from: (module=la, header=STLFactory.h)
%feature("docstring")  dolfin::STLFactory::create_matrix "
Create empty matrix
";

%feature("docstring")  dolfin::STLFactory::create_vector "
Create empty vector (global)
";

%feature("docstring")  dolfin::STLFactory::create_local_vector "
Create empty vector (local)
";

%feature("docstring")  dolfin::STLFactory::create_pattern "
Create empty sparsity pattern
";

%feature("docstring")  dolfin::STLFactory::create_lu_solver "
Create LU solver
";

%feature("docstring")  dolfin::STLFactory::create_krylov_solver "
Create Krylov solver
";

%feature("docstring")  dolfin::STLFactory::instance "
Return singleton instance
";

%feature("docstring")  dolfin::STLFactory::STLFactory "
Private Constructor
";

// Documentation extracted from: (module=la, header=SLEPcEigenSolver.h)
%feature("docstring")  dolfin::SLEPcEigenSolver "
This class provides an eigenvalue solver for PETSc matrices.
It is a wrapper for the SLEPc eigenvalue solver.

The following parameters may be specified to control the solver.

1. \"spectrum\"

This parameter controls which part of the spectrum to compute.
Possible values are

  \"largest magnitude\"   (eigenvalues with largest magnitude)
  \"smallest magnitude\"  (eigenvalues with smallest magnitude)
  \"largest real\"        (eigenvalues with largest double part)
  \"smallest real\"       (eigenvalues with smallest double part)
  \"largest imaginary\"   (eigenvalues with largest imaginary part)
  \"smallest imaginary\"  (eigenvalues with smallest imaginary part)

For SLEPc versions >= 3.1 , the following values are also possible

  \"target magnitude\"    (eigenvalues closest to target in magnitude)
  \"target real\"         (eigenvalues closest to target in real part)
  \"target imaginary\"    (eigenvalues closest to target in imaginary part)

The default is \"largest magnitude\"

2. \"solver\"

This parameter controls which algorithm is used by SLEPc.
Possible values are

  \"power\"               (power iteration)
  \"subspace\"            (subspace iteration)
  \"arnoldi\"             (Arnoldi)
  \"lanczos\"             (Lanczos)
  \"krylov-schur\"        (Krylov-Schur)
  \"lapack\"              (LAPACK, all values, direct, small systems only)

The default is \"krylov-schur\"

3. \"tolerance\"

This parameter controls the tolerance used by SLEPc.
Possible values are positive double numbers.

The default is 1e-15;

4. \"maximum_iterations\"

This parameter controls the maximum number of iterations used by SLEPc.
Possible values are positive integers.

Note that both the tolerance and the number of iterations must be
specified if either one is specified.

5. \"problem_type\"

This parameter can be used to give extra information about the
type of the eigenvalue problem. Some solver types require this
extra piece of information. Possible values are:

  \"hermitian\"               (Hermitian)
  \"non_hermitian\"           (Non-Hermitian)
  \"gen_hermitian\"           (Generalized Hermitian)
  \"gen_non_hermitian\"       (Generalized Non-Hermitian)

6. \"spectral_transform\"

This parameter controls the application of a spectral transform. A
spectral transform can be used to enhance the convergence of the
eigensolver and in particular to only compute eigenvalues in the
interior of the spectrum. Possible values are:

  \"shift-and-invert\"      (A shift-and-invert transform)

Note that if a spectral transform is given, then also a non-zero
spectral shift parameter has to be provided.

The default is no spectral transform.

7. \"spectral_shift\"

This parameter controls the spectral shift used by the spectral
transform and must be provided if a spectral transform is given. The
possible values are real numbers.

";

%feature("docstring")  dolfin::SLEPcEigenSolver::SLEPcEigenSolver "
**Overloaded versions**

* SLEPcEigenSolver\ (A)

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ (A, B)

  Create eigenvalue solver Ax = \lambda Bx

* SLEPcEigenSolver\ (A)

  Create eigenvalue solver for Ax = \lambda x

* SLEPcEigenSolver\ (A, B)

  Create eigenvalue solver for Ax = \lambda x
";

%feature("docstring")  dolfin::SLEPcEigenSolver::solve "
**Overloaded versions**

* solve\ ()

  Compute all eigenpairs of the matrix A (solve Ax = \lambda x)

* solve\ (n)

  Compute the n first eigenpairs of the matrix A (solve Ax = \lambda x)
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenvalue "
**Overloaded versions**

* get_eigenvalue\ (lr, lc)

  Get the first eigenvalue

* get_eigenvalue\ (lr, lc, i)

  Get eigenvalue i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::get_eigenpair "
**Overloaded versions**

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c)

  Get the first eigenpair

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i

* get_eigenpair\ (lr, lc, r, c, i)

  Get eigenpair i
";

%feature("docstring")  dolfin::SLEPcEigenSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::SLEPcEigenSolver::read_parameters "
Callback for changes in parameter values
";

// Documentation extracted from: (module=la, header=TrilinosPreconditioner.h)
%feature("docstring")  dolfin::TrilinosPreconditioner "
This class is a wrapper for configuring Epetra preconditioners. It does
not own a preconditioner. It can take a EpetraKrylovSolver and set the
preconditioner type and parameters.
";

%feature("docstring")  dolfin::TrilinosPreconditioner::TrilinosPreconditioner "
Create Krylov solver for a particular method and preconditioner
";

%feature("docstring")  dolfin::TrilinosPreconditioner::set "
Set the precondtioner and matrix used in preconditioner
";

%feature("docstring")  dolfin::TrilinosPreconditioner::name "
Return preconditioner name
";

%feature("docstring")  dolfin::TrilinosPreconditioner::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TrilinosPreconditioner::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::TrilinosPreconditioner::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::TrilinosPreconditioner::set_ml "
Setup the ML precondtioner
";

// Documentation extracted from: (module=la, header=uBLASSparseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASDenseMatrix.h)
// Documentation extracted from: (module=la, header=uBLASPreconditioner.h)
%feature("docstring")  dolfin::uBLASPreconditioner "
This class specifies the interface for preconditioners for the
uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASPreconditioner::uBLASPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASPreconditioner::init "
**Overloaded versions**

* init\ (P)

  Initialise preconditioner (sparse matrix)

* init\ (P)

  Initialise preconditioner (dense matrix)

* init\ (P)

  Initialise preconditioner (virtual matrix)
";

%feature("docstring")  dolfin::uBLASPreconditioner::solve "
Solve linear system (M^-1)Ax = y
";

// Documentation extracted from: (module=la, header=uBLASKrylovSolver.h)
%feature("docstring")  dolfin::uBLASKrylovSolver "
This class implements Krylov methods for linear systems
of the form Ax = b using uBLAS data types.
";

%feature("docstring")  dolfin::uBLASKrylovSolver::uBLASKrylovSolver "
**Overloaded versions**

* uBLASKrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Create Krylov solver for a particular method and preconditioner

* uBLASKrylovSolver\ (pc)

  Create Krylov solver for a particular uBLASPreconditioner

* uBLASKrylovSolver\ (method, pc)

  Create Krylov solver for a particular method and uBLASPreconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::set_operator "
Solve the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::uBLASKrylovSolver::get_operator "
Return the operator (matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations

* solve\ (A, x, b)

  Solve linear system Ax = b and return number of iterations (virtual matrix)
";

%feature("docstring")  dolfin::uBLASKrylovSolver::methods "
Return a list of available solver methods
";

%feature("docstring")  dolfin::uBLASKrylovSolver::preconditioners "
Return a list of available preconditioners
";

%feature("docstring")  dolfin::uBLASKrylovSolver::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solve_krylov "
Select solver and solve linear system Ax = b and return number of iterations
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveCG "
Solve linear system Ax = b using CG
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveGMRES "
Solve linear system Ax = b using restarted GMRES
";

%feature("docstring")  dolfin::uBLASKrylovSolver::solveBiCGStab "
Solve linear system Ax = b using BiCGStab
";

%feature("docstring")  dolfin::uBLASKrylovSolver::select_preconditioner "
Select and create named preconditioner
";

%feature("docstring")  dolfin::uBLASKrylovSolver::read_parameters "
Read solver parameters
";

// Documentation extracted from: (module=la, header=uBLASILUPreconditioner.h)
%feature("docstring")  dolfin::uBLASILUPreconditioner "
This class implements an incomplete LU factorization (ILU)
preconditioner for the uBLAS Krylov solver.
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::uBLASILUPreconditioner "
Constructor
";

%feature("docstring")  dolfin::uBLASILUPreconditioner::solve "
Solve linear system Ax = b approximately
";

// Documentation extracted from: (module=la, header=Vector.h)
%feature("docstring")  dolfin::Vector "
This class provides the default DOLFIN vector class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Vector::Vector "
**Overloaded versions**

* Vector\ ()

  Create empty vector

* Vector\ (N)

  Create vector of size N

* Vector\ (x)

  Copy constructor

* Vector\ (x)

  Create a Vector from a GenericVetor
";

%feature("docstring")  dolfin::Vector::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::Vector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Vector::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Vector::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Vector::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Vector::resize "
**Overloaded versions**

* resize\ (N)

  Resize vector to size N

* resize\ (range)

  Resize vector with given ownership range

* resize\ (range, ghost_indices)

  Resize vector with given ownership range and with ghost values
";

%feature("docstring")  dolfin::Vector::size "
Return size of vector
";

%feature("docstring")  dolfin::Vector::local_size "
Return local size of vector
";

%feature("docstring")  dolfin::Vector::local_range "
Return local ownership range of a vector
";

%feature("docstring")  dolfin::Vector::owns_index "
Determine whether global vector index is owned by this process
";

%feature("docstring")  dolfin::Vector::get_local "
**Overloaded versions**

* get_local\ (block, m, rows)

  Get block of values (values must all live on the local process)

* get_local\ (values)

  Get all values on local process
";

%feature("docstring")  dolfin::Vector::set "
Set block of values
";

%feature("docstring")  dolfin::Vector::add "
Add block of values
";

%feature("docstring")  dolfin::Vector::set_local "
Set all values on local process
";

%feature("docstring")  dolfin::Vector::add_local "
Add values to each entry on local process
";

%feature("docstring")  dolfin::Vector::gather "
**Overloaded versions**

* gather\ (x, indices)

  Gather entries into local vector x

* gather\ (x, indices)

  Gather entries into Array x
";

%feature("docstring")  dolfin::Vector::gather_on_zero "
Gather all entries into Array x on process 0
";

%feature("docstring")  dolfin::Vector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::Vector::abs "
Replace all entries in the vector by their absolute values
";

%feature("docstring")  dolfin::Vector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::Vector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::Vector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::Vector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::Vector::sum "
Return sum of values of vector
";

%feature("docstring")  dolfin::Vector::operator*= "
**Overloaded versions**

* operator*=\ (a)

  Multiply vector by given number

* operator*=\ (x)

  Multiply vector by another vector pointwise
";

%feature("docstring")  dolfin::Vector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::Vector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::Vector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::Vector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator

* operator=\ (x)

  Assignment operator
";

%feature("docstring")  dolfin::Vector::data "
**Overloaded versions**

* data\ ()

  Return pointer to underlying data (const version)

* data\ ()

  Return pointer to underlying data
";

%feature("docstring")  dolfin::Vector::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Vector::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Matrix.h)
%feature("docstring")  dolfin::Matrix "
This class provides the default DOLFIN matrix class,
based on the default DOLFIN linear algebra backend.
";

%feature("docstring")  dolfin::Matrix::Matrix "
**Overloaded versions**

* Matrix\ ()

  Create empty matrix

* Matrix\ (A)

  Copy constructor
";

%feature("docstring")  dolfin::Matrix::distributed "
Return true if matrix is distributed
";

%feature("docstring")  dolfin::Matrix::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Matrix::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Matrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Matrix::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Matrix::zero "
**Overloaded versions**

* zero\ ()

  Set all entries to zero and keep any sparse structure

* zero\ (m, rows)

  Set given rows to zero
";

%feature("docstring")  dolfin::Matrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Matrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Matrix::resize "
Resize vector y such that is it compatible with matrix for
multuplication Ax = b (dim = 0 -> b, dim = 1 -> x) In parallel
case, size and layout are important.
";

%feature("docstring")  dolfin::Matrix::get "
Get block of values
";

%feature("docstring")  dolfin::Matrix::set "
Set block of values
";

%feature("docstring")  dolfin::Matrix::add "
Add block of values
";

%feature("docstring")  dolfin::Matrix::axpy "
Add multiple of given matrix (AXPY operation)
";

%feature("docstring")  dolfin::Matrix::norm "
Return norm of matrix
";

%feature("docstring")  dolfin::Matrix::getrow "
Get non-zero values of given row
";

%feature("docstring")  dolfin::Matrix::setrow "
Set values for given row
";

%feature("docstring")  dolfin::Matrix::ident "
Set given rows to identity matrix
";

%feature("docstring")  dolfin::Matrix::operator*= "
Multiply matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator/= "
Divide matrix by given number
";

%feature("docstring")  dolfin::Matrix::operator= "
**Overloaded versions**

* operator=\ (A)

  Assignment operator

* operator=\ (A)

  Assignment operator
";

%feature("docstring")  dolfin::Matrix::data "
Return pointers to underlying compressed storage data.
See GenericMatrix for documentation.
";

%feature("docstring")  dolfin::Matrix::factory "
Return linear algebra backend factory
";

%feature("docstring")  dolfin::Matrix::instance "
**Overloaded versions**

* instance\ ()

  Return concrete instance / unwrap (const version)

* instance\ ()

  Return concrete instance / unwrap (non-const version)
";

// Documentation extracted from: (module=la, header=Scalar.h)
%feature("docstring")  dolfin::Scalar "
This class represents a real-valued scalar quantity and
implements the GenericTensor interface for scalars.
";

%feature("docstring")  dolfin::Scalar::Scalar "
Create zero scalar
";

%feature("docstring")  dolfin::Scalar::distributed "
Return true if tensor is distributed
";

%feature("docstring")  dolfin::Scalar::resize "
Resize tensor to given dimensions
";

%feature("docstring")  dolfin::Scalar::init "
Initialize zero tensor using sparsity pattern
";

%feature("docstring")  dolfin::Scalar::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::Scalar::rank "
Return tensor rank (number of dimensions)
";

%feature("docstring")  dolfin::Scalar::size "
Return size of given dimension
";

%feature("docstring")  dolfin::Scalar::local_range "
Return local ownership range
";

%feature("docstring")  dolfin::Scalar::get "
Get block of values
";

%feature("docstring")  dolfin::Scalar::set "
Set block of values
";

%feature("docstring")  dolfin::Scalar::add "
**Overloaded versions**

* add\ (block, num_rows, rows)

  Add block of values

* add\ (block, rows)

  Add block of values

* add\ (block, rows)

  Add block of values
";

%feature("docstring")  dolfin::Scalar::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::Scalar::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::Scalar::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Scalar::operator double "
Cast to double
";

%feature("docstring")  dolfin::Scalar::operator= "
Assignment from double
";

%feature("docstring")  dolfin::Scalar::factory "
Return a factory for the default linear algebra backend
";

%feature("docstring")  dolfin::Scalar::getval "
Get value
";

// Documentation extracted from: (module=la, header=LinearSolver.h)
%feature("docstring")  dolfin::LinearSolver "
This class provides a general solver for linear systems Ax = b.
";

%feature("docstring")  dolfin::LinearSolver::LinearSolver "
Create linear solver
";

%feature("docstring")  dolfin::LinearSolver::set_operator "
Set the operator (matrix)
";

%feature("docstring")  dolfin::LinearSolver::set_operators "
Set the operator (matrix) and preconitioner matrix
";

%feature("docstring")  dolfin::LinearSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::LinearSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=KrylovSolver.h)
%feature("docstring")  dolfin::KrylovSolver "
This class defines an interface for a Krylov solver. The approproiate solver
is chosen on the basis of the matrix/vector type.
";

%feature("docstring")  dolfin::KrylovSolver::KrylovSolver "
**Overloaded versions**

* KrylovSolver\ (method=\"default\", preconditioner=\"default\")

  Constructor

* KrylovSolver\ (A, method=\"default\", preconditioner=\"default\")

  Constructor
";

%feature("docstring")  dolfin::KrylovSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::KrylovSolver::set_operators "
Set operator (matrix) and preconditioner matrix
";

%feature("docstring")  dolfin::KrylovSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system Ax = b
";

%feature("docstring")  dolfin::KrylovSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=LUSolver.h)
%feature("docstring")  dolfin::LUSolver "
LU solver for the built-in LA backends.
";

%feature("docstring")  dolfin::LUSolver::LUSolver "
**Overloaded versions**

* LUSolver\ (\"default\")

  Constructor

* LUSolver\ (A, method=\"default\")

  Constructor
";

%feature("docstring")  dolfin::LUSolver::set_operator "
Set operator (matrix)
";

%feature("docstring")  dolfin::LUSolver::solve "
**Overloaded versions**

* solve\ (x, b)

  Solve linear system Ax = b

* solve\ (A, x, b)

  Solve linear system
";

%feature("docstring")  dolfin::LUSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=SingularSolver.h)
%feature("docstring")  dolfin::SingularSolver "
This class provides a linear solver for singular linear systems
Ax = b where A has a one-dimensional null-space (kernel). This
may happen for example when solving Poisson's equation with
pure Neumann boundary conditions.

The solver attempts to create an extended non-singular system
by adding the constraint [1, 1, 1, ...]^T x = 0.

If an optional mass matrix M is supplied, the solver attempts
to create an extended non-singular system by adding the
constraint m^T x = 0 where m is the lumped mass matrix. This
corresponds to setting the average (integral) of the finite
element function with coefficients x to zero.

The solver makes not attempt to check that the null-space is
indeed one-dimensional. It is also assumed that the system
Ax = b retains its sparsity pattern between calls to solve().
";

%feature("docstring")  dolfin::SingularSolver::SingularSolver "
Create linear solver
";

%feature("docstring")  dolfin::SingularSolver::solve "
**Overloaded versions**

* solve\ (A, x, b)

  Solve linear system Ax = b

* solve\ (A, x, b, M)

  Solve linear system Ax = b using mass matrix M for setting constraint
";

%feature("docstring")  dolfin::SingularSolver::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=la, header=solve.h)
%feature("docstring")  dolfin::solve "
Solve linear system Ax = b
";

%feature("docstring")  dolfin::list_linear_solver_methods "
List available solver methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_lu_solver_methods "
List available LU methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_methods "
List available Krylov methods for current linear algebra backend
";

%feature("docstring")  dolfin::list_krylov_solver_preconditioners "
List available preconditioners for current linear algebra backend
";

%feature("docstring")  dolfin::linear_solver_methods "
Return a list of available solver methods for current linear algebra backend
";

%feature("docstring")  dolfin::lu_solver_methods "
Return a list of available LU methods for current linear algebra backend
";

%feature("docstring")  dolfin::krylov_solver_methods "
Return a list of available Krylov methods for current linear algebra backend
";

%feature("docstring")  dolfin::krylov_solver_preconditioners "
Return a list of available preconditioners for current linear algebra backend
";

%feature("docstring")  dolfin::residual "
Compute residual ||Ax - b||
";

%feature("docstring")  dolfin::normalize "
Normalize vector according to given normalization type
";

// Documentation extracted from: (module=la, header=BlockVector.h)
%feature("docstring")  dolfin::BlockVector::BlockVector "
Constructor
";

%feature("docstring")  dolfin::BlockVector::copy "
Return copy of tensor
";

%feature("docstring")  dolfin::BlockVector::set_block "
Set function
";

%feature("docstring")  dolfin::BlockVector::get_block "
**Overloaded versions**

* get_block\ (i)

  Get sub-vector (const)

* get_block\ (uint)

  Get sub-vector (non-const)
";

%feature("docstring")  dolfin::BlockVector::axpy "
Add multiple of given vector (AXPY operation)
";

%feature("docstring")  dolfin::BlockVector::inner "
Return inner product with given vector
";

%feature("docstring")  dolfin::BlockVector::norm "
Return norm of vector
";

%feature("docstring")  dolfin::BlockVector::min "
Return minimum value of vector
";

%feature("docstring")  dolfin::BlockVector::max "
Return maximum value of vector
";

%feature("docstring")  dolfin::BlockVector::operator*= "
Multiply vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator/= "
Divide vector by given number
";

%feature("docstring")  dolfin::BlockVector::operator+= "
Add given vector
";

%feature("docstring")  dolfin::BlockVector::operator-= "
Subtract given vector
";

%feature("docstring")  dolfin::BlockVector::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (a)

  Assignment operator
";

%feature("docstring")  dolfin::BlockVector::size "
Number of vectors
";

%feature("docstring")  dolfin::BlockVector::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=la, header=BlockMatrix.h)
%feature("docstring")  dolfin::BlockMatrix::set_block "
Set block
";

%feature("docstring")  dolfin::BlockMatrix::get_block "
**Overloaded versions**

* get_block\ (i, j)

  Get block (const version)

* get_block\ (i, j)

  Get block
";

%feature("docstring")  dolfin::BlockMatrix::size "
Return size of given dimension
";

%feature("docstring")  dolfin::BlockMatrix::zero "
Set all entries to zero and keep any sparse structure
";

%feature("docstring")  dolfin::BlockMatrix::apply "
Finalize assembly of tensor
";

%feature("docstring")  dolfin::BlockMatrix::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::BlockMatrix::mult "
Matrix-vector product, y = Ax
";

%feature("docstring")  dolfin::BlockMatrix::schur_approximation "
Create a crude explicit Schur approximation of S = D - C A^-1 B of (A B; C D)
If symmetry != 0, then the caller promises that B = symmetry * transpose(C).
";

// Documentation extracted from: (module=ale, header=ALE.h)
%feature("docstring")  dolfin::ALE "
This class provides functionality useful for implementation of
ALE (Arbitrary Lagrangian-Eulerian) methods, in particular
moving the boundary vertices of a mesh and then interpolating
the new coordinates for the interior vertices accordingly.
";

%feature("docstring")  dolfin::ALE::move "
**Overloaded versions**

* move\ (mesh, new_boundary)

  Move coordinates of mesh according to new boundary coordinates

* move\ (mesh0, mesh1)

  Move coordinates of mesh0 according to mesh1 with common global vertices

* move\ (mesh, displacement)

  Move coordinates of mesh according to displacement function
";

// Documentation extracted from: (module=refinement, header=refine.h)
%feature("docstring")  dolfin::refine "
**Overloaded versions**

* refine\ (mesh)

  Create uniformly refined mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to refine.
  
  *Returns*
      :py:class:`Mesh`
          The refined mesh.
  
  *Example*
      .. note::
      
          No example code available for this function.

* refine\ (refined_mesh, mesh)

  Create uniformly refined mesh
  
  *Arguments*
      refined_mesh (:py:class:`Mesh`)
          The mesh that will be the refined mesh.
      mesh (:py:class:`Mesh`)
          The original mesh.

* refine\ (mesh, cell_markers)

  Create locally refined mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to refine.
      cell_markers (:py:class:`MeshFunction`)
          A mesh function over booleans specifying which cells
          that should be refined (and which should not).
  
  *Returns*
      :py:class:`Mesh`
          The locally refined mesh.
  
  *Example*
      .. note::
      
          No example code available for this function.

* refine\ (refined_mesh, mesh, cell_markers)

  Create locally refined mesh
  
  *Arguments*
      refined_mesh (:py:class:`Mesh`)
          The mesh that will be the refined mesh.
      mesh (:py:class:`Mesh`)
          The original mesh.
      cell_markers (:py:class:`MeshFunction`)
          A mesh function over booleans specifying which cells
          that should be refined (and which should not).
";

// Documentation extracted from: (module=quadrature, header=Quadrature.h)
%feature("docstring")  dolfin::Quadrature::Quadrature "
Constructor
";

%feature("docstring")  dolfin::Quadrature::size "
Return number of quadrature points
";

%feature("docstring")  dolfin::Quadrature::point "
Return quadrature point
";

%feature("docstring")  dolfin::Quadrature::weight "
Return quadrature weight
";

%feature("docstring")  dolfin::Quadrature::measure "
Return sum of weights (length, area, volume)
";

// Documentation extracted from: (module=quadrature, header=GaussianQuadrature.h)
%feature("docstring")  dolfin::GaussianQuadrature "
Gaussian-type quadrature rule on the double line,
including Gauss, Radau, and Lobatto quadrature.

Points and weights are computed to be exact within a tolerance
of DOLFIN_EPS. Comparing with known exact values for n <= 3 shows
that we obtain full precision (16 digits, error less than 2e-16).
";

// Documentation extracted from: (module=quadrature, header=GaussQuadrature.h)
%feature("docstring")  dolfin::GaussQuadrature "
Gauss (Gauss-Legendre) quadrature on the interval [-1,1].
The n quadrature points are given by the zeros of the
n:th Legendre Pn(x).

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Gauss quadrature with n points
should be exact for polynomials of degree 2n-1.
";

%feature("docstring")  dolfin::GaussQuadrature::GaussQuadrature "
Create Gauss quadrature with n points
";

%feature("docstring")  dolfin::GaussQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=RadauQuadrature.h)
%feature("docstring")  dolfin::RadauQuadrature "
Radau (Gauss-Radau) quadrature on the interval [-1,1].
The n quadrature points are given by the zeros of

    ( Pn-1(x) + Pn(x) ) / (1+x)

where Pn is the n:th Legendre polynomial.

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Radau quadrature with n points
should be exact for polynomials of degree 2n-2.
";

%feature("docstring")  dolfin::RadauQuadrature::RadauQuadrature "
Create Radau quadrature with n points
";

%feature("docstring")  dolfin::RadauQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=LobattoQuadrature.h)
%feature("docstring")  dolfin::LobattoQuadrature "
Lobatto (Gauss-Lobatto) quadrature on the interval [-1,1].
The n quadrature points are given by the end-points -1 and 1,
and the zeros of P{n-1}'(x), where P{n-1}(x) is the (n-1):th
Legendre polynomial.

The quadrature points are computed using Newton's method, and
the quadrature weights are computed by solving a linear system
determined by the condition that Lobatto quadrature with n points
should be exact for polynomials of degree 2n-3.
";

%feature("docstring")  dolfin::LobattoQuadrature::LobattoQuadrature "
Create Lobatto quadrature with n points
";

%feature("docstring")  dolfin::LobattoQuadrature::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=quadrature, header=BarycenterQuadrature.h)
%feature("docstring")  dolfin::BarycenterQuadrature "
This class computes the barycenter of an arbitrary polyhedron or
polygon in 3D and therefore allows for barycenter quadrature on
complex polyhedrons. Note: barycenter quadrature is exact for
polynom deg <= 1.
";

%feature("docstring")  dolfin::BarycenterQuadrature::BarycenterQuadrature "
Create barycenter quadrature rule for given polyhedron
";

%feature("docstring")  dolfin::BarycenterQuadrature::points "
Return points
";

%feature("docstring")  dolfin::BarycenterQuadrature::weights "
Return weights
";

%feature("docstring")  dolfin::BarycenterQuadrature::size "
Return number of quadrature points/weights
";

%feature("docstring")  dolfin::BarycenterQuadrature::compute_quadrature "
Computes barycenter and weight.
";

// Documentation extracted from: (module=mesh, header=CellType.h)
%feature("docstring")  dolfin::CellType "
This class provides a common interface for different cell types.
Each cell type implements mesh functionality that is specific to
a certain type of cell.
";

%feature("docstring")  dolfin::CellType::CellType "
Constructor
";

%feature("docstring")  dolfin::CellType::create "
**Overloaded versions**

* create\ (type)

  Create cell type from type (factory function)

* create\ (type)

  Create cell type from string (factory function)
";

%feature("docstring")  dolfin::CellType::string2type "
Convert from string to cell type
";

%feature("docstring")  dolfin::CellType::type2string "
Convert from cell type to string
";

%feature("docstring")  dolfin::CellType::cell_type "
Return type of cell
";

%feature("docstring")  dolfin::CellType::facet_type "
Return type of cell for facets
";

%feature("docstring")  dolfin::CellType::dim "
Return topological dimension of cell
";

%feature("docstring")  dolfin::CellType::num_entities "
Return number of entitites of given topological dimension
";

%feature("docstring")  dolfin::CellType::num_vertices "
Return number of vertices for entity of given topological dimension
";

%feature("docstring")  dolfin::CellType::orientation "
Return orientation of the cell
";

%feature("docstring")  dolfin::CellType::create_entities "
Create entities e of given topological dimension from vertices v
";

%feature("docstring")  dolfin::CellType::refine_cell "
Refine cell uniformly
";

%feature("docstring")  dolfin::CellType::volume "
Compute (generalized) volume of mesh entity
";

%feature("docstring")  dolfin::CellType::diameter "
Compute diameter of mesh entity
";

%feature("docstring")  dolfin::CellType::normal "
**Overloaded versions**

* normal\ (cell, facet, i)

  Compute component i of normal of given facet with respect to the cell

* normal\ (cell, facet)

  Compute of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::facet_area "
Compute the area/length of given facet with respect to the cell
";

%feature("docstring")  dolfin::CellType::order "
Order entities locally
";

%feature("docstring")  dolfin::CellType::ordered "
Check if entities are ordered
";

%feature("docstring")  dolfin::CellType::description "
Return description of cell type
";

// Documentation extracted from: (module=mesh, header=MeshTopology.h)
%feature("docstring")  dolfin::MeshTopology "
MeshTopology stores the topology of a mesh, consisting of mesh entities
and connectivity (incidence relations for the mesh entities). Note that
the mesh entities don't need to be stored, only the number of entities
and the connectivity. Any numbering scheme for the mesh entities is
stored separately in a MeshFunction over the entities.

A mesh entity e may be identified globally as a pair e = (dim, i), where
dim is the topological dimension and i is the index of the entity within
that topological dimension.
";

%feature("docstring")  dolfin::MeshTopology::MeshTopology "
**Overloaded versions**

* MeshTopology\ ()

  Create empty mesh topology

* MeshTopology\ (topology)

  Copy constructor
";

%feature("docstring")  dolfin::MeshTopology::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshTopology::dim "
Return topological dimension
";

%feature("docstring")  dolfin::MeshTopology::size "
Return number of entities for given dimension
";

%feature("docstring")  dolfin::MeshTopology::clear "
**Overloaded versions**

* clear\ ()

  Clear all data

* clear\ (d0, d1)

  Clear data for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::init "
**Overloaded versions**

* init\ (dim)

  Initialize topology of given maximum dimension

* init\ (dim, size)

  Set number of entities (size) for given topological dimension
";

%feature("docstring")  dolfin::MeshTopology::operator "
**Overloaded versions**

* operator\ (d0, d1)

  Return connectivity for given pair of topological dimensions

* operator\ (d0, d1)

  Return connectivity for given pair of topological dimensions
";

%feature("docstring")  dolfin::MeshTopology::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshGeometry.h)
%feature("docstring")  dolfin::MeshGeometry::MeshGeometry "
**Overloaded versions**

* MeshGeometry\ ()

  Create empty set of coordinates

* MeshGeometry\ (geometry)

  Copy constructor
";

%feature("docstring")  dolfin::MeshGeometry::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshGeometry::dim "
Return Euclidean dimension of coordinate system
";

%feature("docstring")  dolfin::MeshGeometry::size "
Return number of coordinates
";

%feature("docstring")  dolfin::MeshGeometry::x "
**Overloaded versions**

* x\ (n, i)

  Return value of coordinate n in direction i

* x\ (n, i)

  Return value of coordinate n in direction i

* x\ (n)

  Return array of values for coordinate n

* x\ (n)

  Return array of values for coordinate n

* x\ ()

  Return array of values for all coordinates

* x\ ()

  Return array of values for all coordinates
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_x "
**Overloaded versions**

* higher_order_x\ (n)

  Return array of values for higher order coordinate n

* higher_order_x\ (n)

  Return array of values for higher order coordinate n

* higher_order_x\ ()

  Return array of values for all higher order coordinates

* higher_order_x\ ()

  Return array of values for all higher order coordinates
";

%feature("docstring")  dolfin::MeshGeometry::num_higher_order_vertices_per_cell "
Return number of vertices used (per cell) to represent the higher order geometry
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cell "
**Overloaded versions**

* higher_order_cell\ (c)

  Return array of higher order vertex indices for a specific higher order cell

* higher_order_cell\ (c)

  Return array of higher order vertex indices for a specific higher order cell
";

%feature("docstring")  dolfin::MeshGeometry::higher_order_cells "
**Overloaded versions**

* higher_order_cells\ ()

  Return array of values for all higher order cell data

* higher_order_cells\ ()

  Return array of values for all higher order cell data
";

%feature("docstring")  dolfin::MeshGeometry::point "
Return coordinate n as a 3D point value
";

%feature("docstring")  dolfin::MeshGeometry::affine_cell_bool "
Return pointer to boolean affine indicator array
";

%feature("docstring")  dolfin::MeshGeometry::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshGeometry::init "
Initialize coordinate list to given dimension and size
";

%feature("docstring")  dolfin::MeshGeometry::init_higher_order_vertices "
Initialize higher order coordinate list to given dimension and size
";

%feature("docstring")  dolfin::MeshGeometry::init_higher_order_cells "
Initialize higher order cell data list to given number of cells and dofs
";

%feature("docstring")  dolfin::MeshGeometry::init_affine_indicator "
Initialize the affine indicator array
";

%feature("docstring")  dolfin::MeshGeometry::set_affine_indicator "
set affine indicator at index i
";

%feature("docstring")  dolfin::MeshGeometry::set "
Set value of coordinate n in direction i
";

%feature("docstring")  dolfin::MeshGeometry::set_higher_order_coordinates "
Set value of higher order coordinate N in direction i
";

%feature("docstring")  dolfin::MeshGeometry::set_higher_order_cell_data "
Set higher order cell data for cell # N in direction i
";

%feature("docstring")  dolfin::MeshGeometry::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshDomains.h)
%feature("docstring")  dolfin::MeshDomains "
The class :py:class:`MeshDomains` stores the division of a :py:class:`Mesh` into
subdomains. For each topological dimension 0 <= d <= D, where D
is the topological dimension of the :py:class:`Mesh`, a set of integer
markers are stored for a subset of the entities of dimension d,
indicating for each entity in the subset the number of the
subdomain. It should be noted that the subset does not need to
contain all entities of any given dimension; entities not
contained in the subset are \"unmarked\".
";

%feature("docstring")  dolfin::MeshDomains::MeshDomains "
Create empty mesh domains
";

%feature("docstring")  dolfin::MeshDomains::dim "
Return maximal topological dimension of stored markers
";

%feature("docstring")  dolfin::MeshDomains::num_marked "
Return number of marked entities of given dimension
";

%feature("docstring")  dolfin::MeshDomains::is_empty "
Check whether domain data is empty
";

%feature("docstring")  dolfin::MeshDomains::markers "
**Overloaded versions**

* markers\ (dim)

  Get subdomain markers for given dimension

* markers\ (dim)

  Get subdomain markers for given dimension (const version)
";

%feature("docstring")  dolfin::MeshDomains::markers_shared_ptr "
**Overloaded versions**

* markers_shared_ptr\ (dim)

  Get subdomain markers for given dimension (shared pointer version)

* markers_shared_ptr\ (dim)

  Get subdomain markers for given dimension (const shared pointer version)
";

%feature("docstring")  dolfin::MeshDomains::cell_domains "
Get cell domains. This function computes the mesh function
corresponding to markers of dimension D. The mesh function is
cached for later access and will be computed on the first call
to this function.
";

%feature("docstring")  dolfin::MeshDomains::facet_domains "
Get facet domains. This function computes the mesh function
corresponding to markers of dimension D-1. The mesh function
is cached for later access and will be computed on the first
call to this function.
";

%feature("docstring")  dolfin::MeshDomains::init "
Initialize mesh domains for given topological dimension
";

%feature("docstring")  dolfin::MeshDomains::clear "
Clear all data
";

// Documentation extracted from: (module=mesh, header=MeshData.h)
%feature("docstring")  dolfin::MeshData "
The class MeshData is a container for auxiliary mesh data,
represented either as :py:class:`MeshFunction` over topological mesh
entities, arrays or maps. Each dataset is identified by a unique
user-specified string. Only uint-valued data are currently
supported.

Auxiliary mesh data may be attached to a mesh by users as a
convenient way to store data associated with a mesh. It is also
used internally by DOLFIN to communicate data associated with
meshes. The following named mesh data are recognized by DOLFIN:

Facet orientation (used for assembly over interior facets)

  * \"facet_orientation\"     - :py:class:`MeshFunction` <uint> of dimension D - 1

Sub meshes (used by the class SubMesh)

  * \"parent_vertex_indices\" - :py:class:`MeshFunction` <uint> of dimension 0

Note to developers: use underscore in names in place of spaces.
";

%feature("docstring")  dolfin::MeshData::MeshData "
Constructor
";

%feature("docstring")  dolfin::MeshData::operator= "
Assignment operator

*Arguments*
    data (:py:class:`MeshData`)
        Another MeshData object.
";

%feature("docstring")  dolfin::MeshData::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshData::create_mesh_function "
**Overloaded versions**

* create_mesh_function\ (name)

  Create MeshFunction with given name (uninitialized)
  
  *Arguments*
      name (str)
          The name of the mesh function.
  
  *Returns*
      :py:class:`MeshFunction`
          The mesh function.

* create_mesh_function\ (name, dim)

  Create MeshFunction with given name and dimension
  
  *Arguments*
      name (str)
          The name of the mesh function.
      dim (int)
          The dimension of the mesh function.
  
  *Returns*
      :py:class:`MeshFunction`
          The mesh function.
";

%feature("docstring")  dolfin::MeshData::create_array "
**Overloaded versions**

* create_array\ (name)

  Create empty array (vector) with given name
  
  *Arguments*
      name (str)
          The name of the array.
  
  *Returns*
      numpy.array(int)
          The array.

* create_array\ (name, size)

  Create array (vector) with given name and size
  
  *Arguments*
      name (str)
          The name of the array.
      size (unit)
          The size (length) of the array.
  
  *Returns*
      numpy.array(int)
          The array.
";

%feature("docstring")  dolfin::MeshData::mesh_function "
Return MeshFunction with given name (returning zero if data is
not available)

*Arguments*
    name (str)
        The name of the MeshFunction.

*Returns*
    :py:class:`MeshFunction`
        The mesh function with given name
";

%feature("docstring")  dolfin::MeshData::array "
Return array with given name (returning zero if data is not
available)

*Arguments*
    name (str)
        The name of the array.

*Returns*
    numpy.array(int)
        The array.
";

%feature("docstring")  dolfin::MeshData::erase_mesh_function "
Erase MeshFunction with given name

*Arguments*
    name (str)
        The name of the mesh function
";

%feature("docstring")  dolfin::MeshData::erase_array "
Erase array with given name

*Arguments*
    name (str)
        The name of the array.
";

%feature("docstring")  dolfin::MeshData::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=ParallelData.h)
%feature("docstring")  dolfin::ParallelData "
This class stores auxiliary mesh data for parallel computing.
";

%feature("docstring")  dolfin::ParallelData::ParallelData "
**Overloaded versions**

* ParallelData\ (mesh)

  Constructor

* ParallelData\ (data)

  Copy constructor
";

%feature("docstring")  dolfin::ParallelData::have_global_entity_indices "
Return true if global indices have been computed for entity of
dimension d
";

%feature("docstring")  dolfin::ParallelData::global_entity_indices "
**Overloaded versions**

* global_entity_indices\ (d)

  Return global indices (local-to-global) for entity of dimension d

* global_entity_indices\ (d)

  Return global indices (local-to-global) for entity of dimension d (const version)
";

%feature("docstring")  dolfin::ParallelData::global_entity_indices_as_vector "
Return global indices (local-to-global) for entity of dimension d in a vector
";

%feature("docstring")  dolfin::ParallelData::global_to_local_entity_indices "
**Overloaded versions**

* global_to_local_entity_indices\ (d)

  Return global-to-local indices for entity of dimension d

* global_to_local_entity_indices\ (d)

  Return global-to-local indices for entity of dimension d (const version)
";

%feature("docstring")  dolfin::ParallelData::shared_vertices "
**Overloaded versions**

* shared_vertices\ ()

  FIXME: Add description and use better name

* shared_vertices\ ()

  FIXME: Add description and use better name
";

%feature("docstring")  dolfin::ParallelData::exterior_facet "
**Overloaded versions**

* exterior_facet\ ()

  Return MeshFunction that is true for globally exterior facets,
  false otherwise

* exterior_facet\ ()

  Return MeshFunction that is true for globally exterior facets,
  false otherwise (const version)
";

// Documentation extracted from: (module=mesh, header=Mesh.h)
%feature("docstring")  dolfin::Mesh "
A :py:class:`Mesh` consists of a set of connected and numbered mesh entities.

Both the representation and the interface are
dimension-independent, but a concrete interface is also provided
for standard named mesh entities:

.. tabularcolumns:: |c|c|c|

+--------+-----------+-------------+
| Entity | Dimension | Codimension |
+========+===========+=============+
| Vertex |  0        |             |
+--------+-----------+-------------+
| Edge   |  1        |             |
+--------+-----------+-------------+
| Face   |  2        |             |
+--------+-----------+-------------+
| Facet  |           |      1      |
+--------+-----------+-------------+
| Cell   |           |      0      |
+--------+-----------+-------------+

When working with mesh iterators, all entities and connectivity
are precomputed automatically the first time an iterator is
created over any given topological dimension or connectivity.

Note that for efficiency, only entities of dimension zero
(vertices) and entities of the maximal dimension (cells) exist
when creating a :py:class:`Mesh`. Other entities must be explicitly created
by calling init(). For example, all edges in a mesh may be
created by a call to mesh.init(1). Similarly, connectivities
such as all edges connected to a given vertex must also be
explicitly created (in this case by a call to mesh.init(0, 1)).
";

%feature("docstring")  dolfin::Mesh::Mesh "
**Overloaded versions**

* Mesh\ ()

  Create empty mesh

* Mesh\ (mesh)

  Copy constructor.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          Object to be copied.

* Mesh\ (filename)

  Create mesh from data file.
  
  *Arguments*
      filename (str)
          Name of file to load.

* Mesh\ (local_mesh_data)

  Create a distributed mesh from local (per process) data.
  
  *Arguments*
      local_mesh_data (LocalMeshData)
          Data from which to build the mesh.
";

%feature("docstring")  dolfin::Mesh::operator= "
Assignment operator

*Arguments*
    mesh (:py:class:`Mesh`)
        Another :py:class:`Mesh` object.
";

%feature("docstring")  dolfin::Mesh::num_vertices "
Get number of vertices in mesh.

*Returns*
    int
        Number of vertices.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_vertices()
        9
";

%feature("docstring")  dolfin::Mesh::num_edges "
Get number of edges in mesh.

*Returns*
    int
        Number of edges.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_edges()
        0
        >>> mesh.init(1)
        16
        >>> mesh.num_edges()
        16
";

%feature("docstring")  dolfin::Mesh::num_faces "
Get number of faces in mesh.

*Returns*
    int
        Number of faces.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_faces()
        8
";

%feature("docstring")  dolfin::Mesh::num_facets "
Get number of facets in mesh.

*Returns*
    int
        Number of facets.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_facets()
        0
        >>> mesh.init(0,1)
        >>> mesh.num_facets()
        16
";

%feature("docstring")  dolfin::Mesh::num_cells "
Get number of cells in mesh.

*Returns*
    int
        Number of cells.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.num_cells()
        8
";

%feature("docstring")  dolfin::Mesh::num_entities "
Get number of entities of given topological dimension.

*Arguments*
    d (int)
        Topological dimension.

*Returns*
    int
        Number of entities of topological dimension d.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.init(0,1)
        >>> mesh.num_entities(0)
        9
        >>> mesh.num_entities(1)
        16
        >>> mesh.num_entities(2)
        8
";

%feature("docstring")  dolfin::Mesh::coordinates "
**Overloaded versions**

* coordinates\ ()

  Get vertex coordinates.
  
  *Returns*
      numpy.array(float)
          Coordinates of all vertices.
  
  *Example*
      .. code-block:: python
      
          >>> mesh = dolfin.UnitSquare(1,1)
          >>> mesh.coordinates()
          array([[ 0.,  0.],
                 [ 1.,  0.],
                 [ 0.,  1.],
                 [ 1.,  1.]])

* coordinates\ ()

  Return coordinates of all vertices (const version).
";

%feature("docstring")  dolfin::Mesh::cells "
Get cell connectivity.

*Returns*
    numpy.array(int)
        Connectivity for all cells.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(1,1)
        >>> mesh.cells()
        array([[0, 1, 3],
              [0, 2, 3]])
";

%feature("docstring")  dolfin::Mesh::size "
Get number of entities of given topological dimension.

*Arguments*
    dim (int)
        Topological dimension.

*Returns*
    int
        Number of entities of topological dimension d.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.init(0,1)
        >>> mesh.size(0)
        9
        >>> mesh.size(1)
        16
        >>> mesh.size(2)
        8
";

%feature("docstring")  dolfin::Mesh::topology "
**Overloaded versions**

* topology\ ()

  Get mesh topology.
  
  *Returns*
      :py:class:`MeshTopology`
          The topology object associated with the mesh.

* topology\ ()

  Get mesh topology (const version).
";

%feature("docstring")  dolfin::Mesh::geometry "
**Overloaded versions**

* geometry\ ()

  Get mesh geometry.
  
  *Returns*
      :py:class:`MeshGeometry`
          The geometry object associated with the mesh.

* geometry\ ()

  Get mesh geometry (const version).
";

%feature("docstring")  dolfin::Mesh::domains "
**Overloaded versions**

* domains\ ()

  Get mesh (sub)domains.
  
  *Returns*
      :py:class:`MeshDomains`
          The (sub)domains associated with the mesh.

* domains\ ()

  Get mesh (sub)domains.
";

%feature("docstring")  dolfin::Mesh::intersection_operator "
**Overloaded versions**

* intersection_operator\ ()

  Get intersection operator.
  
  *Returns*
      :py:class:`IntersectionOperator`
          The intersection operator object associated with the mesh.

* intersection_operator\ ()

  Return intersection operator (const version);
";

%feature("docstring")  dolfin::Mesh::data "
**Overloaded versions**

* data\ ()

  Get mesh data.
  
  *Returns*
      :py:class:`MeshData`
          The mesh data object associated with the mesh.

* data\ ()

  Get mesh data (const version).
";

%feature("docstring")  dolfin::Mesh::parallel_data "
**Overloaded versions**

* parallel_data\ ()

  Get parallel mesh data.
  
  *Returns*
      :py:class:`ParallelData`
          The parallel data object associated with the mesh.

* parallel_data\ ()

  Get parallel mesh data (const version).
";

%feature("docstring")  dolfin::Mesh::type "
**Overloaded versions**

* type\ ()

  Get mesh cell type.
  
  *Returns*
      :py:class:`CellType`
          The cell type object associated with the mesh.

* type\ ()

  Get mesh cell type (const version).
";

%feature("docstring")  dolfin::Mesh::init "
**Overloaded versions**

* init\ (dim)

  Compute entities of given topological dimension.
  
  *Arguments*
      dim (int)
          Topological dimension.
  
  *Returns*
      int
          Number of created entities.

* init\ (d0, d1)

  Compute connectivity between given pair of dimensions.
  
  *Arguments*
      d0 (int)
          Topological dimension.
  
      d1 (int)
          Topological dimension.

* init\ ()

  Compute all entities and connectivity.
";

%feature("docstring")  dolfin::Mesh::clear "
Clear all mesh data.
";

%feature("docstring")  dolfin::Mesh::clean "
Clean out all auxiliary topology data. This clears all
topological data, except the connectivity between cells and
vertices.
";

%feature("docstring")  dolfin::Mesh::order "
Order all mesh entities.

.. seealso::

    UFC documentation (put link here!)
";

%feature("docstring")  dolfin::Mesh::ordered "
Check if mesh is ordered according to the UFC numbering convention.

*Returns*
    bool
        The return values is true iff the mesh is ordered.
";

%feature("docstring")  dolfin::Mesh::move "
**Overloaded versions**

* move\ (boundary)

  Move coordinates of mesh according to new boundary coordinates.
  
  *Arguments*
      boundary (:py:class:`BoundaryMesh`)
          A mesh containing just the boundary cells.

* move\ (mesh)

  Move coordinates of mesh according to adjacent mesh with common global
  vertices.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          A :py:class:`Mesh` object.

* move\ (displacement)

  Move coordinates of mesh according to displacement function.
  
  *Arguments*
      displacement (:py:class:`Function`)
          A :py:class:`Function` object.
";

%feature("docstring")  dolfin::Mesh::smooth "
Smooth internal vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.
";

%feature("docstring")  dolfin::Mesh::smooth_boundary "
Smooth boundary vertices of mesh by local averaging.

*Arguments*
    num_iterations (int)
        Number of iterations to perform smoothing,
        default value is 1.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::snap_boundary "
Snap boundary vertices of mesh to match given sub domain.

*Arguments*
    sub_domain (:py:class:`SubDomain`)
        A :py:class:`SubDomain` object.

    harmonic_smoothing (bool)
        Flag to turn on harmonics smoothing, default
        value is true.
";

%feature("docstring")  dolfin::Mesh::color "
**Overloaded versions**

* color\ (coloring_type)

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<unsigned int> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (str)
          Coloring type, specifying what relation makes two
          cells neighbors, can be one of \"vertex\", \"edge\" or
          \"facet\".
  
  *Returns*
      MeshFunction<unsigned int>
          The colors as a mesh function over the cells of the mesh.

* color\ (coloring_type)

  Color the cells of the mesh such that no two neighboring cells
  share the same color. A colored mesh keeps a
  CellFunction<unsigned int> named \"cell colors\" as mesh data which
  holds the colors of the mesh.
  
  *Arguments*
      coloring_type (numpy.array(int))
          Coloring type given as list of topological dimensions,
          specifying what relation makes two mesh entinties neighbors.
  
  *Returns*
      MeshFunction<unsigned int>
          The colors as a mesh function over entities of the mesh.
";

%feature("docstring")  dolfin::Mesh::intersected_cells "
**Overloaded versions**

* intersected_cells\ (point, cells)

  Compute all cells which are intersected by the given point.
  
  *Arguments*
      point (:py:class:`Point`)
          A :py:class:`Point` object.
  
      cells (set of int)
          A set of indices of all intersected cells.

* intersected_cells\ (points, cells)

  Compute all cells which are intersected by any of a vector of points.
  
  *Arguments*
      points (list of :py:class:`Point`)
          A vector of :py:class:`Point` objects.
  
      cells (set of int)
          A set of indices of all intersected cells.

* intersected_cells\ (entity, cells)

  Compute all cells which are intersected by the given entity.
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          A :py:class:`MeshEntity` object.
  
      cells (numpy.array(int))
          A vector of indices of all intersected cells.

* intersected_cells\ (entities, cells)

  Compute all cells which are intersected by any of a vector of entities.
  
  *Arguments*
      entities (list of :py:class:`MeshEntity`)
          A vector of :py:class:`MeshEntity` objects.
  
      cells (set of int)
          A vector of indices of all intersected cells.

* intersected_cells\ (mesh, cells)

  Compute all cells which are intersected by the given mesh.
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          A :py:class:`Mesh` object.
  
      cells (set of int)
          A set of indices of all intersected cells.
";

%feature("docstring")  dolfin::Mesh::intersected_cell "
Find the cell (if any) containing the given point. If the point
is contained in several cells, the first cell is returned.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    int
        The index of the cell containing the point. If no cell
        is found, the return value is -1.
";

%feature("docstring")  dolfin::Mesh::closest_point "
Find the point in the mesh closest to the given point.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    :py:class:`Point`
        The closest point.
";

%feature("docstring")  dolfin::Mesh::closest_cell "
Find the cell in the mesh closest to the given point.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    int
        The index of the closest cell.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(1, 1)
        >>> point = dolfin.Point(0.0, 2.0)
        >>> mesh.closest_cell(point)
        1
";

%feature("docstring")  dolfin::Mesh::closest_point_and_cell "
Find the point and corresponding cell closest to the given point.

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    Swig Object< std::pair<:py:class:`Point`, int> >
        A pair consisting of the closest point and corresponding cell index.
";

%feature("docstring")  dolfin::Mesh::distance "
Computes the distance between a given point and the mesh

*Arguments*
    point (:py:class:`Point`)
        A :py:class:`Point` object.

*Returns*
    float
        The distance to the mesh.
";

%feature("docstring")  dolfin::Mesh::hmin "
Compute minimum cell diameter.

*Returns*
    float
        The minimum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmin()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::hmax "
Compute maximum cell diameter.

*Returns*
    float
        The maximum cell diameter, the diameter is computed as
        two times the circumradius
        (http://mathworld.wolfram.com).

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.hmax()
        0.70710678118654757
";

%feature("docstring")  dolfin::Mesh::str "
Informal string representation.

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the mesh.

*Example*
    .. code-block:: python
    
        >>> mesh = dolfin.UnitSquare(2,2)
        >>> mesh.str(False)
        '<Mesh of topological dimension 2 (triangles) with 9 vertices and 8 cells, ordered>'
";

// Documentation extracted from: (module=mesh, header=MeshEntity.h)
%feature("docstring")  dolfin::MeshEntity "
A MeshEntity represents a mesh entity associated with
a specific topological dimension of some :py:class:`Mesh`.
";

%feature("docstring")  dolfin::MeshEntity::MeshEntity "
**Overloaded versions**

* MeshEntity\ ()

  Default Constructor

* MeshEntity\ (mesh, dim, index)

  Constructor
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The topological dimension.
      index (int)
          The index.
";

%feature("docstring")  dolfin::MeshEntity::init "
Initialize mesh entity with given data

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh.
    dim (int)
        The topological dimension.
    index (int)
        The index.
";

%feature("docstring")  dolfin::MeshEntity::operator== "
Comparision Operator

*Arguments*
    another (:py:class:`MeshEntity`)
        Another mesh entity

*Returns*
    bool
        True if the two mesh entities are equal.
";

%feature("docstring")  dolfin::MeshEntity::operator!= "
Comparision Operator

*Arguments*
    another (MeshEntity)
        Another mesh entity.

*Returns*
    bool
        True if the two mesh entities are NOT equal.
";

%feature("docstring")  dolfin::MeshEntity::mesh "
Return mesh associated with mesh entity

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::MeshEntity::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshEntity::index "
**Overloaded versions**

* index\ ()

  Return index of mesh entity
  
  *Returns*
      int
          The index.

* index\ (entity)

  Compute local index of given incident entity (error if not
  found)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      int
          The local index of given entity.
";

%feature("docstring")  dolfin::MeshEntity::num_entities "
Return number of incident mesh entities of given topological dimension

*Arguments*
    dim (int)
        The topological dimension.

*Returns*
    int
        The number of incident MeshEntity objects of given dimension.
";

%feature("docstring")  dolfin::MeshEntity::entities "
Return array of indices for incident mesh entitites of given
topological dimension

*Arguments*
    dim (int)
        The topological dimension.

*Returns*
    int
        The index for incident mesh entities of given dimension.
";

%feature("docstring")  dolfin::MeshEntity::mesh_id "
Return unique mesh ID

*Returns*
    int
        The unique mesh ID.
";

%feature("docstring")  dolfin::MeshEntity::incident "
Check if given entity is incident

*Arguments*
    entity (:py:class:`MeshEntity`)
        The entity.

*Returns*
    bool
        True if the given entity is incident
";

%feature("docstring")  dolfin::MeshEntity::intersects "
**Overloaded versions**

* intersects\ (point)

  Check if given point intersects (using inexact but fast
  numerics)
  
  *Arguments*
      point (:py:class:`Point`)
          The point.
  
  *Returns*
      bool
          True if the given point intersects.

* intersects\ (entity)

  Check if given entity intersects (using inexact but fast
  numerics)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      bool
          True if the given entity intersects.
";

%feature("docstring")  dolfin::MeshEntity::intersects_exactly "
**Overloaded versions**

* intersects_exactly\ (point)

  Check if given point intersects (using exact numerics)
  
  *Arguments*
      point (:py:class:`Point`)
          The point.
  
  *Returns*
      bool
          True if the given point intersects.

* intersects_exactly\ (entity)

  Check if given entity intersects (using exact numerics)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      bool
          True if the given entity intersects.
";

%feature("docstring")  dolfin::MeshEntity::midpoint "
Compute midpoint of cell

*Returns*
    :py:class:`Point`
        The midpoint of the cell.
";

%feature("docstring")  dolfin::MeshEntity::bbox "
Returns a 3D bounding box of the mesh entity. For lower
dimension it may be a degenerated box.
";

%feature("docstring")  dolfin::MeshEntity::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=mesh, header=MeshEntityIterator.h)
%feature("docstring")  dolfin::MeshEntityIterator "
MeshEntityIterator provides a common iterator for mesh entities
over meshes, boundaries and incidence relations. The basic use
is illustrated below.

*Example*
    The following example shows how to iterate over all mesh entities
    of a mesh of topological dimension dim:
    
    .. code-block:: python
    
        >>> for e in dolfin.cpp.entities(mesh, 1):
        ...     print e.index()
    
    The following example shows how to iterate over mesh entities of
    topological dimension dim connected (incident) to some mesh entity f:
    
    .. code-block:: python
    
        >>> f = dolfin.cpp.MeshEntity(mesh, 0, 0)
        >>> for e in dolfin.cpp.entities(f, 1):
        ...     print e.index()
In addition to the general iterator, a set of specific named iterators
are provided for entities of type :py:class:`Vertex`, :py:class:`Edge`, :py:class:`Face`, :py:class:`Facet`
and :py:class:`Cell`. These iterators are defined along with their respective
classes.
";

%feature("docstring")  dolfin::MeshEntityIterator::MeshEntityIterator "
**Overloaded versions**

* MeshEntityIterator\ ()

  Default constructor

* MeshEntityIterator\ (mesh, dim)

  Create iterator for mesh entities over given topological dimension

* MeshEntityIterator\ (entity, dim)

  Create iterator for entities of given dimension connected to given entity

* MeshEntityIterator\ (it)

  Copy constructor
";

%feature("docstring")  dolfin::MeshEntityIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-- "
Step to the previous mesh entity (prefix decrease)
";

%feature("docstring")  dolfin::MeshEntityIterator::pos "
Return current position
";

%feature("docstring")  dolfin::MeshEntityIterator::operator== "
Comparison operator.
";

%feature("docstring")  dolfin::MeshEntityIterator::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::MeshEntityIterator::operator[] "
Random access operator.
";

%feature("docstring")  dolfin::MeshEntityIterator::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::MeshEntityIterator::end_iterator "
Provide a safeguard iterator pointing beyond the end of an iteration
process, either iterating over the mesh /or incident entities. Added to
be bit more like STL iterators, since many algorithms rely on a kind of
beyond iterator.
";

%feature("docstring")  dolfin::MeshEntityIterator::set_end "
Set pos to end position. To create a kind of mesh.end() iterator.
";

// Documentation extracted from: (module=mesh, header=SubsetIterator.h)
%feature("docstring")  dolfin::SubsetIterator "
A :py:class:`SubsetIterator` is similar to a :py:class:`MeshEntityIterator` but
iterates over a specified subset of the range of entities as
specified by a :py:class:`MeshFunction` that labels the entites.
";

%feature("docstring")  dolfin::SubsetIterator::SubsetIterator "
**Overloaded versions**

* SubsetIterator\ (labels, label)

  Create iterator for given mesh function. The iterator visits
  all entities that match the given label.

* SubsetIterator\ (subset_iter)

  Copy Constructor
";

%feature("docstring")  dolfin::SubsetIterator::operator++ "
Step to next mesh entity (prefix increment)
";

%feature("docstring")  dolfin::SubsetIterator::operator== "
Comparison operator
";

%feature("docstring")  dolfin::SubsetIterator::operator!= "
Comparison operator
";

%feature("docstring")  dolfin::SubsetIterator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::SubsetIterator::operator-> "
Member access operator
";

%feature("docstring")  dolfin::SubsetIterator::end "
Check if iterator has reached the end
";

%feature("docstring")  dolfin::SubsetIterator::set_end "
Set pos to end position. To create a kind of mesh.end() iterator.
";

// Documentation extracted from: (module=mesh, header=Point.h)
%feature("docstring")  dolfin::Point "
A Point represents a point in :math:`\mathbb{R}^3` with
coordinates :math:`x, y, z,` or alternatively, a vector in
:math:`\mathbb{R}^3`, supporting standard operations like the
norm, distances, scalar and vector products etc.
";

%feature("docstring")  dolfin::Point::Point "
**Overloaded versions**

* Point\ (x=0.0, y=0.0, z=0.0)

  Create a point at (x, y, z). Default value (0, 0, 0).
  
  *Arguments*
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
      z (float)
          The z-coordinate.

* Point\ (dim, x)

  Create point from array
  
  *Arguments*
      dim (int)
          Dimension of the array.
      x (float)
          The array to create a Point from.

* Point\ (p)

  Copy constructor
  
  *Arguments*
      p (:py:class:`Point`)
          The object to be copied.

* Point\ (point)

  Constructor taking a CGAL::Point_3. Allows conversion from
  CGAL Point_3 class to Point class.
";

%feature("docstring")  dolfin::Point::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Return address of coordinate in direction i
  
  *Arguments*
      i (int)
          Direction.
  
  *Returns*
      float
          Adress of coordinate in the given direction.

* operator[]\ (i)

  Return coordinate in direction i
  
  *Arguments*
      i (int)
          Direction.
  
  *Returns*
      float
          The coordinate in the given direction.
";

%feature("docstring")  dolfin::Point::x "
Return x-coordinate

*Returns*
    float
        The x-coordinate.
";

%feature("docstring")  dolfin::Point::y "
Return y-coordinate

*Returns*
    float
        The y-coordinate.
";

%feature("docstring")  dolfin::Point::z "
Return z-coordinate

*Returns*
    float
        The z-coordinate.
";

%feature("docstring")  dolfin::Point::coordinates "
**Overloaded versions**

* coordinates\ ()

  Return coordinate array
  
  *Returns*
      list of doubles
          The coordinates.

* coordinates\ ()

  Return coordinate array (const. version)
  
  *Returns*
      list of doubles
          The coordinates.
";

%feature("docstring")  dolfin::Point::operator+ "
Compute sum of two points
";

%feature("docstring")  dolfin::Point::operator- "
Compute difference of two points
";

%feature("docstring")  dolfin::Point::operator+= "
Add given point
";

%feature("docstring")  dolfin::Point::operator-= "
Subtract given point
";

%feature("docstring")  dolfin::Point::operator* "
**Overloaded versions**

* operator*\ (a)

  Multiplication with scalar

* operator*\ (a, p)

  Multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator*= "
Incremental multiplication with scalar
";

%feature("docstring")  dolfin::Point::operator/ "
Division by scalar
";

%feature("docstring")  dolfin::Point::operator/= "
Incremental division by scalar
";

%feature("docstring")  dolfin::Point::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Point::operator CGAL::Point_3<Kernel> "
Conversion operator to appropriate CGAL Point_3 class.
";

%feature("docstring")  dolfin::Point::bbox "
Provides a CGAL bounding box, using conversion operator.
";

%feature("docstring")  dolfin::Point::distance "
Compute distance to given point

*Arguments*
    p (:py:class:`Point`)
        The point to compute distance to.

*Returns*
    float
        The distance.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::norm "
Compute norm of point representing a vector from the origin

*Returns*
    float
        The (Euclidean) norm of the vector from the origin to
        the point.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::cross "
Compute cross product with given vector

*Arguments*
    p (:py:class:`Point`)
        Another point.

*Returns*
    Point
        The cross product.
";

%feature("docstring")  dolfin::Point::dot "
Compute dot product with given vector

*Arguments*
    p (:py:class:`Point`)
        Another point.

*Returns*
    float
        The dot product.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Point::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation of the function space.
";

// Documentation extracted from: (module=mesh, header=Vertex.h)
%feature("docstring")  dolfin::Vertex "
A Vertex is a MeshEntity of topological dimension 0.
";

%feature("docstring")  dolfin::Vertex::Vertex "
**Overloaded versions**

* Vertex\ (mesh, index)

  Create vertex on given mesh

* Vertex\ (entity)

  Create vertex from mesh entity
";

%feature("docstring")  dolfin::Vertex::x "
**Overloaded versions**

* x\ (i)

  Return value of vertex coordinate i

* x\ ()

  Return array of vertex coordinates (const version)
";

%feature("docstring")  dolfin::Vertex::point "
Return vertex coordinates as a 3D point value
";

%feature("docstring")  dolfin::VertexIterator "
A VertexIterator is a MeshEntityIterator of topological dimension 0.
";

%feature("docstring")  dolfin::VertexFunction "
A VertexFunction is a MeshFunction of topological dimension 0.
";

// Documentation extracted from: (module=mesh, header=Edge.h)
%feature("docstring")  dolfin::Edge "
An Edge is a :py:class:`MeshEntity` of topological dimension 1.
";

%feature("docstring")  dolfin::Edge::Edge "
**Overloaded versions**

* Edge\ (mesh, index)

  Create edge on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      index (int)
          Index of the edge.

* Edge\ (entity)

  Create edge from mesh entity
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity to create an edge from.
";

%feature("docstring")  dolfin::Edge::length "
Compute Euclidean length of edge

*Returns*
    float
        Euclidean length of edge.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Edge::dot "
Compute dot product between edge and other edge

*Arguments*
    edge (:py:class:`Edge`)
        Another edge.

*Returns*
    float
        The dot product.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::EdgeIterator "
An EdgeIterator is a :py:class:`MeshEntityIterator` of topological dimension 1.
";

%feature("docstring")  dolfin::EdgeFunction "
An EdgeFunction is a :py:class:`MeshFunction` of topological dimension 1.
";

// Documentation extracted from: (module=mesh, header=Face.h)
%feature("docstring")  dolfin::Face "
A Face is a MeshEntity of topological dimension 2.
";

%feature("docstring")  dolfin::Face::Face "
Constructor
";

%feature("docstring")  dolfin::Face::area "
Calculate the area of the face (triangle)
";

%feature("docstring")  dolfin::Face::normal "
**Overloaded versions**

* normal\ (i)

  Compute component i of the normal to the face

* normal\ ()

  Compute normal to the face
";

%feature("docstring")  dolfin::FaceIterator "
A FaceIterator is a MeshEntityIterator of topological dimension 2.
";

%feature("docstring")  dolfin::FaceFunction "
A FaceFunction is a MeshFunction of topological dimension 2.
";

// Documentation extracted from: (module=mesh, header=Facet.h)
%feature("docstring")  dolfin::Facet "
A Facet is a MeshEntity of topological codimension 1.
";

%feature("docstring")  dolfin::Facet::Facet "
Constructor
";

%feature("docstring")  dolfin::Facet::normal "
**Overloaded versions**

* normal\ (i)

  Compute component i of the normal to the facet

* normal\ ()

  Compute normal to the facet
";

%feature("docstring")  dolfin::Facet::exterior "
Return true if facet is an exterior facet (relative to global mesh,
so this function will return false for facets on partition boundaries)
Facet connectivity must be initialized before calling this function.
";

%feature("docstring")  dolfin::Facet::adjacent_cells "
Return adjacent cells. An optional argument that lists for
each facet the index of the first cell may be given to specify
the ordering of the two cells. If not specified, the ordering
will depend on the (arbitrary) ordering of the mesh
connectivity.
";

%feature("docstring")  dolfin::FacetIterator "
A FacetIterator is a MeshEntityIterator of topological codimension 1.
";

%feature("docstring")  dolfin::FacetFunction "
A FacetFunction is a MeshFunction of topological codimension 1.
";

// Documentation extracted from: (module=mesh, header=Cell.h)
%feature("docstring")  dolfin::Cell "
A Cell is a :py:class:`MeshEntity` of topological codimension 0.
";

%feature("docstring")  dolfin::Cell::Cell "
**Overloaded versions**

* Cell\ ()

  Create empty cell

* Cell\ (mesh, index)

  Create cell on given mesh with given index
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      index (int)
          The index.
";

%feature("docstring")  dolfin::Cell::type "
Return type of cell
";

%feature("docstring")  dolfin::Cell::orientation "
Compute orientation of cell

*Returns*
    float
        Orientation of the cell (0 is right, 1 is left).
";

%feature("docstring")  dolfin::Cell::volume "
Compute (generalized) volume of cell

*Returns*
    float
        The volume of the cell.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::diameter "
Compute diameter of cell

*Returns*
    float
        The diameter of the cell.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::Cell::normal "
**Overloaded versions**

* normal\ (facet, i)

  Compute component i of normal of given facet with respect to the cell
  
  *Arguments*
      facet (int)
          Index of facet.
      i (int)
          Component.
  
  *Returns*
      float
          Component i of the normal of the facet.

* normal\ (facet)

  Compute normal of given facet with respect to the cell
  
  *Arguments*
      facet (int)
          Index of facet.
  
  *Returns*
      :py:class:`Point`
          Normal of the facet.
";

%feature("docstring")  dolfin::Cell::facet_area "
Compute the area/length of given facet with respect to the cell

*Arguments*
    facet (int)
        Index of the facet.

*Returns*
    float
        Area/length of the facet.
";

%feature("docstring")  dolfin::Cell::order "
Order entities locally

*Arguments*
    global_vertex_indices (:py:class:`MeshFunction`)
        The global vertex indices.
";

%feature("docstring")  dolfin::Cell::ordered "
Check if entities are ordered

*Arguments*
    global_vertex_indices (:py:class:`MeshFunction`)
        The global vertex indices.

*Returns*
    bool
        True if ordered.
";

%feature("docstring")  dolfin::CellIterator "
A CellIterator is a MeshEntityIterator of topological codimension 0.
";

%feature("docstring")  dolfin::CellFunction "
A CellFunction is a MeshFunction of topological codimension 0.
";

// Documentation extracted from: (module=mesh, header=FacetCell.h)
%feature("docstring")  dolfin::FacetCell "
This class represents a cell in a mesh incident to a facet on
the boundary. It is useful in cases where one needs to iterate
over a boundary mesh and access the corresponding cells in the
original mesh.
";

%feature("docstring")  dolfin::FacetCell::FacetCell "
Create cell on mesh corresponding to given facet (cell) on boundary
";

%feature("docstring")  dolfin::FacetCell::facet_index "
Return local index of facet with respect to the cell
";

// Documentation extracted from: (module=mesh, header=MeshConnectivity.h)
%feature("docstring")  dolfin::MeshConnectivity "
Mesh connectivity stores a sparse data structure of connections
(incidence relations) between mesh entities for a fixed pair of
topological dimensions.

The connectivity can be specified either by first giving the
number of entities and the number of connections for each entity,
which may either be equal for all entities or different, or by
giving the entire (sparse) connectivity pattern.
";

%feature("docstring")  dolfin::MeshConnectivity::MeshConnectivity "
**Overloaded versions**

* MeshConnectivity\ (d0, d1)

  Create empty connectivity between given dimensions (d0 -- d1)

* MeshConnectivity\ (connectivity)

  Copy constructor
";

%feature("docstring")  dolfin::MeshConnectivity::operator= "
Assignment
";

%feature("docstring")  dolfin::MeshConnectivity::size "
**Overloaded versions**

* size\ ()

  Return total number of connections

* size\ (entity)

  Return number of connections for given entity
";

%feature("docstring")  dolfin::MeshConnectivity::operator "
**Overloaded versions**

* operator\ (entity)

  Return array of connections for given entity

* operator\ ()

  Return contiguous array of connections for all entities
";

%feature("docstring")  dolfin::MeshConnectivity::clear "
Clear all data
";

%feature("docstring")  dolfin::MeshConnectivity::init "
**Overloaded versions**

* init\ (num_entities, num_connections)

  Initialize number of entities and number of connections (equal for all)

* init\ (num_connections)

  Initialize number of entities and number of connections (individually)
";

%feature("docstring")  dolfin::MeshConnectivity::set "
**Overloaded versions**

* set\ (entity, connection, pos)

  Set given connection for given entity

* set\ (entity, connections)

  Set all connections for given entity

* set\ (entity, connections)

  Set all connections for given entity

* set\ (connectivity)

  Set all connections for all entities
";

%feature("docstring")  dolfin::MeshConnectivity::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=mesh, header=MeshEditor.h)
%feature("docstring")  dolfin::MeshEditor "
A simple mesh editor for creating simplicial meshes in 1D, 2D
and 3D.
";

%feature("docstring")  dolfin::MeshEditor::MeshEditor "
Constructor
";

%feature("docstring")  dolfin::MeshEditor::open "
**Overloaded versions**

* open\ (mesh, tdim, gdim)

  Open mesh of given topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.
  
  *Example*
      .. note::
      
          No example code available for this function.

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      type (CellType::Type)
          Cell type.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to open.
      type (str)
          Cell type.
      tdim (int)
          The topological dimension.
      gdim (int)
          The geometrical dimension.
";

%feature("docstring")  dolfin::MeshEditor::init_vertices "
Specify number of vertices

*Arguments*
    num_vertices (int)
        The number of vertices.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_vertices "
Specify number of vertices

*Arguments*
    num_higher_order_vertices (int)
        The number of higher order vertices.
";

%feature("docstring")  dolfin::MeshEditor::init_cells "
Specify number of cells

*Arguments*
    num_cells (int)
        The number of cells.

*Example*
    .. note::
    
        No example code available for this function.
";

%feature("docstring")  dolfin::MeshEditor::init_higher_order_cells "
Specify number of cells

*Arguments*
    num_higher_order_cells (int)
        The number of higher order cells.
    num_higher_order_cell_dof (int)
        The number of cell dofs.
";

%feature("docstring")  dolfin::MeshEditor::set_affine_cell_indicator "
Set boolean indicator inside MeshGeometry
";

%feature("docstring")  dolfin::MeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ (v, p)

  Add vertex v at given point p
  
  *Arguments*
      v (int)
          The vertex (index).
      p (:py:class:`Point`)
          The point.

* add_vertex\ (v, x)

  Add vertex v at given coordinate x
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.

* add_vertex\ (v, x, y)

  Add vertex v at given coordinate (x, y)
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
  
  *Example*
      .. note::
      
          No example code available for this function.

* add_vertex\ (v, x, y, z)

  Add vertex v at given coordinate (x, y, z)
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
      z (float)
          The z-coordinate.
";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_vertex "
**Overloaded versions**

* add_higher_order_vertex\ (v, p)

  Add vertex v at given point p
  
  *Arguments*
      v (int)
          The vertex (index).
      p (:py:class:`Point`)
          The point.

* add_higher_order_vertex\ (v, x)

  Add vertex v at given coordinate x
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.

* add_higher_order_vertex\ (v, x, y)

  Add vertex v at given coordinate (x, y)
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.

* add_higher_order_vertex\ (v, x, y, z)

  Add vertex v at given coordinate (x, y, z)
  
  *Arguments*
      v (int)
          The vertex (index).
      x (float)
          The x-coordinate.
      y (float)
          The y-coordinate.
      z (float)
          The z-coordinate.
";

%feature("docstring")  dolfin::MeshEditor::add_cell "
**Overloaded versions**

* add_cell\ (c, v)

  Add cell with given vertices
  
  *Arguments*
      c (int)
          The cell (index).
      v (numpy.array(int))
          The vertex indices

* add_cell\ (c, v0, v1)

  Add cell (interval) with given vertices
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (int)
          Index of the first vertex.
      v1 (int)
          Index of the second vertex.

* add_cell\ (c, v0, v1, v2)

  Add cell (triangle) with given vertices
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (int)
          Index of the first vertex.
      v1 (int)
          Index of the second vertex.
      v2 (int)
          Index of the third vertex.
  
  *Example*
      .. note::
      
          No example code available for this function.

* add_cell\ (c, v0, v1, v2, v3)

  Add cell (tetrahedron) with given vertices
  
  *Arguments*
      c (int)
          The cell (index).
      v0 (int)
          Index of the first vertex.
      v1 (int)
          Index of the second vertex.
      v2 (int)
          Index of the third vertex.
      v3 (int)
          Index of the fourth vertex.
";

%feature("docstring")  dolfin::MeshEditor::add_higher_order_cell_data "
Add higher order cell data (assume P2 triangle for now)

*Arguments*
    c (int)
        The cell (index).
    v0 (int)
        Index of the first vertex.
    v1 (int)
        Index of the second vertex.
    v2 (int)
        Index of the third vertex.
    v3 (int)
        Index of the fourth vertex.
    v4 (int)
        Index of the fifth vertex.
    v5 (int)
        Index of the sixth vertex.
";

%feature("docstring")  dolfin::MeshEditor::close "
Close mesh, finish editing, and order entities locally

*Arguments*
    order (bool)
        Order entities locally if true. Default values is true.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=DynamicMeshEditor.h)
%feature("docstring")  dolfin::DynamicMeshEditor "
This class provides an interface for dynamic editing of meshes,
that is, when the number of vertices and cells are not known
a priori. If the number of vertices and cells are known a priori,
it is more efficient to use the default editor MeshEditor.
";

%feature("docstring")  dolfin::DynamicMeshEditor::DynamicMeshEditor "
Constructor
";

%feature("docstring")  dolfin::DynamicMeshEditor::open "
**Overloaded versions**

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension

* open\ (mesh, type, tdim, gdim)

  Open mesh of given cell type, topological and geometrical dimension
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_vertex "
**Overloaded versions**

* add_vertex\ (v, p)

  Add vertex v at given point p

* add_vertex\ (v, x)

  Add vertex v at given coordinate x

* add_vertex\ (v, x, y)

  Add vertex v at given coordinate (x, y)

* add_vertex\ (v, x, y, z)

  Add vertex v at given coordinate (x, y, z)
";

%feature("docstring")  dolfin::DynamicMeshEditor::add_cell "
**Overloaded versions**

* add_cell\ (c, v)

  Add cell with given vertices

* add_cell\ (c, v0, v1)

  Add cell (interval) with given vertices

* add_cell\ (c, v0, v1, v2)

  Add cell (triangle) with given vertices

* add_cell\ (c, v0, v1, v2, v3)

  Add cell (tetrahedron) with given vertices
";

%feature("docstring")  dolfin::DynamicMeshEditor::close "
Close mesh, finish editing, and order entities locally
";

// Documentation extracted from: (module=mesh, header=LocalMeshValueCollection.h)
%feature("docstring")  dolfin::LocalMeshValueCollection "
This class stores mesh data on a local processor corresponding
to a portion of a MeshValueCollection.
";

%feature("docstring")  dolfin::LocalMeshValueCollection::LocalMeshValueCollection "
Create local mesh data for given LocalMeshValueCollection
";

%feature("docstring")  dolfin::LocalMeshValueCollection::dim "
Return dimension of cell entity
";

%feature("docstring")  dolfin::LocalMeshValueCollection::values "
Return data
";

// Documentation extracted from: (module=mesh, header=MeshFunction.h)
%feature("docstring")  dolfin::MeshFunction "
A MeshFunction is a function that can be evaluated at a set of
mesh entities. A MeshFunction is discrete and is only defined
at the set of mesh entities of a fixed topological dimension.
A MeshFunction may for example be used to store a global
numbering scheme for the entities of a (parallel) mesh, marking
sub domains or boolean markers for mesh refinement.
";

%feature("docstring")  dolfin::MeshFunction::MeshFunction "
**Overloaded versions**

* MeshFunction\ ()

  Create empty mesh function

* MeshFunction\ (mesh)

  Create empty mesh function on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.

* MeshFunction\ (mesh, dim)

  Create mesh function of given dimension on given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension for the mesh function.

* MeshFunction\ (mesh, dim, value)

  Create mesh of given dimension on given mesh and initialize
  to a value
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      dim (int)
          The mesh entity dimension.
      value (T)
          The value.

* MeshFunction\ (mesh, filename)

  Create function from data file
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      filename (str)
          The filename to create mesh function from.

* MeshFunction\ (mesh, value_collection)

  Create function from a MeshValueCollecion
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to create mesh function on.
      value_collection (:py:class:`MeshValueCollection`)
          The mesh value collection for the mesh function data.

* MeshFunction\ (f)

  Copy constructor
  
  *Arguments*
      f (:py:class:`MeshFunction`)
          The object to be copied.
";

%feature("docstring")  dolfin::MeshFunction::operator= "
**Overloaded versions**

* operator=\ (f)

  Assign mesh function to other mesh function
  Assignment operator
  
  *Arguments*
      f (:py:class:`MeshFunction`)
          A :py:class:`MeshFunction` object to asssign to another MeshFunction.

* operator=\ (mesh)

  Assignment operator
  
  *Arguments*
      mesh (:py:class:`MeshValueCollection`)
          A :py:class:`MeshValueCollection` object used to construct a MeshFunction.

* operator=\ (value)

  Set all values to given value
";

%feature("docstring")  dolfin::MeshFunction::mesh "
Return mesh associated with mesh function

*Returns*
    :py:class:`Mesh`
        The mesh.
";

%feature("docstring")  dolfin::MeshFunction::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshFunction::size "
Return size (number of entities)

*Returns*
    int
        The size.
";

%feature("docstring")  dolfin::MeshFunction::values "
**Overloaded versions**

* values\ ()

  Return array of values (const. version)
  
  *Returns*
      T
          The values.

* values\ ()

  Return array of values
  
  *Returns*
      T
          The values.
";

%feature("docstring")  dolfin::MeshFunction::operator[] "
**Overloaded versions**

* operator[]\ (entity)

  Return value at given mesh entity
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      T
          The value at the given entity.

* operator[]\ (entity)

  Return value at given mesh entity (const version)
  
  *Arguments*
      entity (:py:class:`MeshEntity`)
          The mesh entity.
  
  *Returns*
      T
          The value at the given entity.

* operator[]\ (index)

  Return value at given index
  
  *Arguments*
      index (int)
          The index.
  
  *Returns*
      T
          The value at the given index.

* operator[]\ (index)

  Return value at given index  (const version)
  
  *Arguments*
      index (int)
          The index.
  
  *Returns*
      T
          The value at the given index.
";

%feature("docstring")  dolfin::MeshFunction::init "
**Overloaded versions**

* init\ (dim)

  Initialize mesh function for given topological dimension
  
  *Arguments*
      dim (int)
          The dimension.

* init\ (dim, size)

  Initialize mesh function for given topological dimension of
  given size
  
  *Arguments*
      dim (int)
          The dimension.
      size (int)
          The size.

* init\ (mesh, dim)

  Initialize mesh function for given topological dimension
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.

* init\ (mesh, dim, size)

  Initialize mesh function for given topological dimension of
  given size
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh.
      dim (int)
          The dimension.
      size (int)
          The size.
";

%feature("docstring")  dolfin::MeshFunction::set_value "
**Overloaded versions**

* set_value\ (index, value)

  Set value at given index
  
  *Arguments*
      index (int)
          The index.
      value (T)
          The value.

* set_value\ (index, value, mesh)

  Compatibility function for use in SubDomains
";

%feature("docstring")  dolfin::MeshFunction::set_values "
Set values

*Arguments*
    values (std::vector<T>)
        The values.
";

%feature("docstring")  dolfin::MeshFunction::set_all "
Set all values to given value

*Arguments*
    value (T)
        The value to set all values to.
";

%feature("docstring")  dolfin::MeshFunction::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=MeshPartitioning.h)
%feature("docstring")  dolfin::MeshPartitioning "
This class partitions and distributes a mesh based on
partitioned local mesh data. Note that the local mesh data will
also be repartitioned and redistributed during the computation
of the mesh partitioning.

After partitioning, each process has a local mesh and set of
mesh data that couples the meshes together.

The following mesh data is created:

1. \"global entity indices 0\" (MeshFunction<uint>)

This maps each local vertex to its global index.

2. \"overlap\" (std::map<uint, std::vector<uint> >)

This maps each shared vertex to a list of the processes sharing
the vertex.

3. \"global entity indices %d\" (MeshFunction<uint>)

After partitioning, the function number_entities() may be called
to create global indices for all entities of a given topological
dimension. These are stored as mesh data (MeshFunction<uint>)
named

   \"global entity indices 1\"
   \"global entity indices 2\"
   etc

4. \"num global entities\" (std::vector<uint>)

The function number_entities also records the number of global
entities for the dimension of the numbered entities in the array
named \"num global entities\". This array has size D + 1, where D
is the topological dimension of the mesh. This array is
initially created by the mesh and then contains only the number
entities of dimension 0 (vertices) and dimension D (cells).
";

%feature("docstring")  dolfin::MeshPartitioning::build_distributed_mesh "
**Overloaded versions**

* build_distributed_mesh\ (mesh)

  Build a partitioned mesh based on local meshes

* build_distributed_mesh\ (mesh, data)

  Build a partitioned mesh based on local mesh data
";

%feature("docstring")  dolfin::MeshPartitioning::number_entities "
Create global entity indices for entities of dimension d
";

%feature("docstring")  dolfin::MeshPartitioning::partition "
Create a partitioned mesh based on local mesh data
";

%feature("docstring")  dolfin::MeshPartitioning::build_mesh_domains "
Create and attach distributed MeshDomains from local_data
";

%feature("docstring")  dolfin::MeshPartitioning::build_mesh_value_collection "
Create and attach distributed MeshDomains from local_data
[entry, (cell_index, local_index, value)]
";

// Documentation extracted from: (module=mesh, header=MeshValueCollection.h)
%feature("docstring")  dolfin::MeshValueCollection "
The MeshValueCollection class can be used to store data
associated with a subset of the entities of a mesh of a given
topological dimension. It differs from the MeshFunction class in
two ways. First, data does not need to be associated with all
entities (only a subset). Second, data is associated with
entities through the corresponding cell index and local entity
number (relative to the cell), not by global entity index, which
means that data may be stored robustly to file.
";

%feature("docstring")  dolfin::MeshValueCollection::MeshValueCollection "
**Overloaded versions**

* MeshValueCollection\ ()

  Create empty mesh value collection
  

* MeshValueCollection\ (dim)

  Create empty mesh value collection of given dimension
  
  *Arguments*
      dim (int)
          The mesh entity dimension for the mesh value collection.

* MeshValueCollection\ (mesh_function)

  Create a mesh value collection from a MeshFunction
  
  *Arguments*
      mesh_function (:py:class:`MeshFunction`)
          The mesh function for creating a MeshValueCollection.

* MeshValueCollection\ (mesh, filename, dim)

  Create a mesh value collection from a file.
  
  *Arguments*
      mesh (Mesh)
          A mesh associated with the collection. The mesh is used to
          map collection values to the appropriate process.
      filename (str)
          The XML file name.
      dim (int)
          The mesh entity dimension for the mesh value collection.
";

%feature("docstring")  dolfin::MeshValueCollection::operator= "
**Overloaded versions**

* operator=\ (mesh_function)

  Assignment operator
  
  *Arguments*
      mesh_function (:py:class:`MeshFunction`)
          A :py:class:`MeshFunction` object used to construct a MeshValueCollection.

* operator=\ (mesh_value_collection)

  Assignment operator
  
  *Arguments*
      mesh_value_collection (:py:class:`MeshValueCollection`)
          A :py:class:`MeshValueCollection` object used to construct a MeshValueCollection.
";

%feature("docstring")  dolfin::MeshValueCollection::set_dim "
Set the topological dimension

*Arguments*
    dim (int)
        The mesh entity dimension for the mesh value collection.
";

%feature("docstring")  dolfin::MeshValueCollection::dim "
Return topological dimension

*Returns*
    int
        The dimension.
";

%feature("docstring")  dolfin::MeshValueCollection::size "
Return size (number of entities in subset)

*Returns*
    int
        The size.
";

%feature("docstring")  dolfin::MeshValueCollection::set_value "
**Overloaded versions**

* set_value\ (cell_index, local_entity, value)

  Set marker value for given entity defined by a cell index and
  a local entity index
  
  *Arguments*
      cell_index (int)
          The index of the cell.
      local_entity (int)
          The local index of the entity relative to the cell.
      marker_value (T)
          The value of the marker.
  
  *Returns*
      bool
          True is a new value is inserted, false if overwriting
          an existing value.

* set_value\ (entity_index, value, mesh)

  Set value for given entity index
  
  *Arguments*
      entity_index (int)
          Index of the entity.
      value (T)
          The value of the marker.
      mesh (:py:class:`Mesh`)
          The mesh.
  
  *Returns*
      bool
          True is a new value is inserted, false if overwriting
          an existing value.
";

%feature("docstring")  dolfin::MeshValueCollection::get_value "
Get marker value for given entity defined by a cell index and
a local entity index

*Arguments*
    cell_index (int)
        The index of the cell.
    local_entity (int)
        The local index of the entity relative to the cell.

*Returns*
    marker_value (T)
        The value of the marker.
";

%feature("docstring")  dolfin::MeshValueCollection::values "
**Overloaded versions**

* values\ ()

  Get all values
  
  *Returns*
      std::map<std::pair<uint, uint>, T>
          A map from positions to values.

* values\ ()

  Get all values (const version)
  
  *Returns*
      std::map<std::pair<uint, uint>, T>
          A map from positions to values.
";

%feature("docstring")  dolfin::MeshValueCollection::clear "
Clear all values
";

%feature("docstring")  dolfin::MeshValueCollection::str "
Return informal string representation (pretty-print)

*Arguments*
    verbose (bool)
        Flag to turn on additional output.

*Returns*
    str
        An informal representation.
";

// Documentation extracted from: (module=mesh, header=MeshColoring.h)
%feature("docstring")  dolfin::MeshColoring "
This class computes colorings for a local mesh. It supports
vertex, edge, and facet-based colorings.
";

%feature("docstring")  dolfin::MeshColoring::color_cells "
Color the cells of a mesh for given coloring type, which can
be one of \"vertex\", \"edge\" or \"facet\".
";

%feature("docstring")  dolfin::MeshColoring::color "
Color the cells of a mesh for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1.
";

%feature("docstring")  dolfin::MeshColoring::compute_colors "
Compute cell colors for given coloring type specified by
topological dimension, which can be one of 0, 1 or D - 1.
";

%feature("docstring")  dolfin::MeshColoring::type_to_dim "
Convert coloring type to topological dimension
";

// Documentation extracted from: (module=mesh, header=MeshRenumbering.h)
%feature("docstring")  dolfin::MeshRenumbering "
This class implements renumbering algorithms for meshes.
";

// Documentation extracted from: (module=mesh, header=LocalMeshData.h)
%feature("docstring")  dolfin::LocalMeshData::LocalMeshData "
**Overloaded versions**

* LocalMeshData\ ()

  Create empty local mesh data

* LocalMeshData\ (mesh)

  Create local mesh data for given mesh
";

%feature("docstring")  dolfin::LocalMeshData::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::LocalMeshData::clear "
Clear all data
";

%feature("docstring")  dolfin::LocalMeshData::extract_mesh_data "
Copy data from mesh
";

%feature("docstring")  dolfin::LocalMeshData::broadcast_mesh_data "
Broadcast mesh data from main process
";

%feature("docstring")  dolfin::LocalMeshData::receive_mesh_data "
Receive mesh data from main process
";

// Documentation extracted from: (module=mesh, header=SubDomain.h)
%feature("docstring")  dolfin::SubDomain "
This class defines the interface for definition of subdomains.
Alternatively, subdomains may be defined by a :py:class:`Mesh` and a
:py:class:`MeshFunction` <uint> over the mesh.
";

%feature("docstring")  dolfin::SubDomain::SubDomain "
Constructor
";

%feature("docstring")  dolfin::SubDomain::inside "
Return true for points inside the subdomain

*Arguments*
    x (numpy.array(float))
        The coordinates of the point.
    on_boundary (bool)
        True for points on the boundary.

*Returns*
    bool
        True for points inside the subdomain.
";

%feature("docstring")  dolfin::SubDomain::map "
Map coordinate x in domain H to coordinate y in domain G (used for
periodic boundary conditions)

*Arguments*
    x (numpy.array(float))
        The coordinates in domain H.
    unnamed (numpy.array(float))
        The coordinates in domain G.
";

%feature("docstring")  dolfin::SubDomain::snap "
Snap coordinate to boundary of subdomain

*Arguments*
    x (numpy.array(float))
        The coordinates.
";

%feature("docstring")  dolfin::SubDomain::mark_cells "
Set subdomain markers (uint) on cells for given subdomain number

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh to be marked.
    sub_domain (int)
        The subdomain number.
";

%feature("docstring")  dolfin::SubDomain::mark_facets "
Set subdomain markers (uint) on facets for given subdomain number

*Arguments*
    mesh (:py:class:`Mesh`)
        The mesh to be marked.
    sub_domain (int)
        The subdomain number.
";

%feature("docstring")  dolfin::SubDomain::mark "
**Overloaded versions**

* mark\ (mesh, dim, sub_domain)

  Set subdomain markers (uint) for given topological dimension
  and subdomain number
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to be marked.
      dim (int)
          The topological dimension of entities to be marked.
      sub_domain (int)
          The subdomain number.

* mark\ (sub_domains, sub_domain)

  Set subdomain markers (uint) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.

* mark\ (sub_domains, sub_domain)

  Set subdomain markers (int) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.

* mark\ (sub_domains, sub_domain)

  Set subdomain markers (double) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (float)
          The subdomain number.

* mark\ (sub_domains, sub_domain)

  Set subdomain markers (bool) for given subdomain
  
  *Arguments*
      sub_domains (:py:class:`MeshFunction`)
          The subdomain markers.
      sub_domain (bool)
          The subdomain number.

* mark\ (sub_domains, sub_domain, mesh)

  Set subdomain markers (uint) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers.
      sub_domain (int)
          The subdomain number.
      mesn (:py:class:`Mesh`)
          The mesh.

* mark\ (sub_domains, sub_domain, mesh)

  Set subdomain markers (int) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers
      sub_domain (int)
          The subdomain number

* mark\ (sub_domains, sub_domain, mesh)

  Set subdomain markers (double) for given subdomain number
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers.
      sub_domain (float)
          The subdomain number

* mark\ (sub_domains, sub_domain, mesh)

  Set subdomain markers (bool) for given subdomain
  
  *Arguments*
      sub_domains (:py:class:`MeshValueCollection`)
          The subdomain markers
      sub_domain (bool)
          The subdomain number
";

%feature("docstring")  dolfin::SubDomain::geometric_dimension "
Return geometric dimension

*Returns*
    int
        The geometric dimension.
";

%feature("docstring")  dolfin::SubDomain::apply_markers "
Apply marker of type T (most likely an uint) to object of class
S (most likely MeshFunction or MeshValueCollection)
";

// Documentation extracted from: (module=mesh, header=SubMesh.h)
%feature("docstring")  dolfin::SubMesh "
A SubMesh is a mesh defined as a subset of a given mesh. It
provides a convenient way to create matching meshes for
multiphysics applications by creating meshes for subdomains as
subsets of a single global mesh. A mapping from the vertices of
the sub mesh to the vertices of the parent mesh is stored as the
mesh data named \"parent_vertex_indices\".
";

%feature("docstring")  dolfin::SubMesh::SubMesh "
**Overloaded versions**

* SubMesh\ (mesh, sub_domain)

  Create subset of given mesh marked by sub domain

* SubMesh\ (mesh, sub_domains, sub_domain)

  Create subset of given mesh marked by mesh function
";

%feature("docstring")  dolfin::SubMesh::init "
Create sub mesh
";

// Documentation extracted from: (module=mesh, header=DomainBoundary.h)
%feature("docstring")  dolfin::DomainBoundary "
This class provides a SubDomain which picks out the boundary of
a mesh, and provides a convenient way to specify boundary
conditions on the entire boundary of a mesh.
";

%feature("docstring")  dolfin::DomainBoundary::DomainBoundary "
Constructor
";

%feature("docstring")  dolfin::DomainBoundary::inside "
Return true for points on the boundary
";

// Documentation extracted from: (module=mesh, header=BoundaryMesh.h)
%feature("docstring")  dolfin::BoundaryMesh "
A BoundaryMesh is a mesh over the boundary of some given mesh.
";

%feature("docstring")  dolfin::BoundaryMesh::BoundaryMesh "
**Overloaded versions**

* BoundaryMesh\ ()

  Create an empty boundary mesh

* BoundaryMesh\ (mesh)

  Create (interior) boundary mesh from given mesh
";

%feature("docstring")  dolfin::BoundaryMesh::init_exterior_boundary "
Initialize exterior boundary of given mesh
";

%feature("docstring")  dolfin::BoundaryMesh::init_interior_boundary "
Initialize interior boundary of given mesh
";

%feature("docstring")  dolfin::BoundaryMesh::cell_map "
Get cell mapping from the boundary mesh to the original full mesh
";

%feature("docstring")  dolfin::BoundaryMesh::vertex_map "
Get vertex mapping from the boundary mesh to the original full mesh
";

// Documentation extracted from: (module=mesh, header=UnitTetrahedron.h)
%feature("docstring")  dolfin::UnitTetrahedron "
A mesh consisting of a single tetrahedron with vertices at

  (0, 0, 0)
  (1, 0, 0)
  (0, 1, 0)
  (0, 0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTetrahedron::UnitTetrahedron "
Create mesh of unit tetrahedron
";

// Documentation extracted from: (module=mesh, header=UnitCube.h)
%feature("docstring")  dolfin::UnitCube "
Tetrahedral mesh of the 3D unit cube [0,1] x [0,1] x [0,1].
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::UnitCube::UnitCube "
Define a uniform finite element :py:class:`Mesh` over the unit cube
[0,1] x [0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in :math:`x` direction.
    ny (int)
        Number of cells in :math:`y` direction.
    nz (int)
        Number of cells in :math:`z` direction.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=UnitInterval.h)
%feature("docstring")  dolfin::UnitInterval "
A mesh of the unit interval (0, 1) with a given number of cells
(nx) in the axial direction. The total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::UnitInterval::UnitInterval "
Create mesh of unit interval
";

// Documentation extracted from: (module=mesh, header=Interval.h)
%feature("docstring")  dolfin::Interval "
Interval mesh of the 1D line [a,b].  Given the number of cells
(nx) in the axial direction, the total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::Interval::Interval "
Constructor

*Arguments*
    nx (int)
        The number of cells.
    a (float)
        The minimum point (inclusive).
    b (float)
        The maximum point (inclusive).

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=UnitTriangle.h)
%feature("docstring")  dolfin::UnitTriangle "
A mesh consisting of a single triangle with vertices at

  (0, 0)
  (1, 0)
  (0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTriangle::UnitTriangle "
Create mesh of unit triangle
";

// Documentation extracted from: (module=mesh, header=UnitSquare.h)
%feature("docstring")  dolfin::UnitSquare "
Triangular mesh of the 2D unit square [0,1] x [0,1].
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\",
or \"crossed\") indicates the direction of the diagonals.
";

%feature("docstring")  dolfin::UnitSquare::UnitSquare "
Define a uniform finite element :py:class:`Mesh` over the unit square
[0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in horizontal direction.
    ny (int)
        Number of cells in vertical direction.
    diagonal (str)
        Optional argument: A std::string indicating
        the direction of the diagonals.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=UnitCircle.h)
%feature("docstring")  dolfin::UnitCircle "
Triangular mesh of the 2D unit circle.
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).
std::string diagonal (\"left\", \"right\" or \"crossed\") indicates the
direction of the diagonals.
std:string transformation (\"maxn\", \"sumn\" or \"rotsumn\")
";

// Documentation extracted from: (module=mesh, header=Box.h)
%feature("docstring")  dolfin::Box "
Tetrahedral mesh of the 3D rectangular prism [x0, x1] x [y0, y1]
x [z0, z1].  Given the number of cells (nx, ny, nz) in each
direction, the total number of tetrahedra will be 6*nx*ny*nz and
the total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::Box::Box "
Define a uniform finite element :py:class:`Mesh` over the rectangular prism
[x0, x1] x [y0, y1] x [z0, z1].

*Arguments*
    x0 (float)
        :math:`x`-min.
    x1 (float)
        :math:`x`-max.
    y0 (float)
        :math:`y`-min.
    y1 (float)
        :math:`y`-max.
    z0 (float)
        :math:`z`-min.
    z1 (float)
        :math:`z`-max.
    xn (float)
        Number of cells in :math:`x`-direction.
    yn (float)
        Number of cells in :math:`y`-direction.
    zn (float)
        Number of cells in :math:`z`-direction.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=mesh, header=Rectangle.h)
%feature("docstring")  dolfin::Rectangle "
Triangular mesh of the 2D rectangle (x0, y0) x (x1, y1).
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\", or \"crossed\")
indicates the direction of the diagonals.
";

// Documentation extracted from: (module=mesh, header=UnitSphere.h)
%feature("docstring")  dolfin::UnitSphere "
Triangular mesh of the 3D unit sphere.

Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

// Documentation extracted from: (module=common, header=init.h)
%feature("docstring")  dolfin::init "
Initialize DOLFIN (and PETSc) with command-line arguments. This
should not be needed in most cases since the initialization is
otherwise handled automatically.
";

// Documentation extracted from: (module=common, header=defines.h)
// Documentation extracted from: (module=common, header=types.h)
// Documentation extracted from: (module=common, header=constants.h)
// Documentation extracted from: (module=common, header=timing.h)
%feature("docstring")  dolfin::tic "
Timing functions measure CPU time as determined by clock(),
the precision of which seems to be 0.01 seconds.
Start timing (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::toc "
Return elapsed CPU time (should not be used internally in DOLFIN!)
";

%feature("docstring")  dolfin::time "
Return current CPU time used by process
";

// Documentation extracted from: (module=common, header=Array.h)
%feature("docstring")  dolfin::Array "
This class provides a simple wrapper for a pointer to an array. A purpose
of this class is to enable the simple and safe exchange of data between
C++ and Python.
";

%feature("docstring")  dolfin::Array::Array "
**Overloaded versions**

* Array\ ()

  Create empty array

* Array\ (N)

  Create array of size N

* Array\ (other)

  Copy constructor (arg name need to have a different name that 'x')

* Array\ (N, x)

  Construct array from a shared pointer

* Array\ (N, x)

  Construct array from a pointer. Array will not take ownership.
";

%feature("docstring")  dolfin::Array::operator= "
**Overloaded versions**

* operator=\ (x)

  Assignment operator

* operator=\ (x)

  Assign value to all entries
";

%feature("docstring")  dolfin::Array::update "
Construct array from a pointer. Array will not take ownership.
";

%feature("docstring")  dolfin::Array::str "
Return informal string representation (pretty-print).
Note that the Array class is not a subclass of Variable (for
efficiency) which means that one needs to call str() directly
instead of using the info() function on Array objects.
";

%feature("docstring")  dolfin::Array::clear "
Clear array
";

%feature("docstring")  dolfin::Array::resize "
Resize array to size N. If size changes, contents will be destroyed.
";

%feature("docstring")  dolfin::Array::size "
Return size of array
";

%feature("docstring")  dolfin::Array::zero "
Zero array
";

%feature("docstring")  dolfin::Array::zero_eps "
Set entries which meet (abs(x[i]) < eps) to zero
";

%feature("docstring")  dolfin::Array::min "
Return minimum value of array
";

%feature("docstring")  dolfin::Array::max "
Return maximum value of array
";

%feature("docstring")  dolfin::Array::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Access value of given entry (const version)

* operator[]\ (i)

  Access value of given entry (non-const version)
";

%feature("docstring")  dolfin::Array::data "
**Overloaded versions**

* data\ ()

  Return pointer to data (const version)

* data\ ()

  Return pointer to data (non-const version)
";

// Documentation extracted from: (module=common, header=IndexSet.h)
%feature("docstring")  dolfin::IndexSet "
This class provides an efficient data structure for index sets.
The cost of checking whether a given index is in the set is O(1)
and very very fast (optimal) at the cost of extra storage.
";

%feature("docstring")  dolfin::IndexSet::IndexSet "
Create index set of given size
";

%feature("docstring")  dolfin::IndexSet::size "
Return size of set
";

%feature("docstring")  dolfin::IndexSet::has_index "
Check whether index is in set
";

%feature("docstring")  dolfin::IndexSet::find "
Return position (if any) for given index
";

%feature("docstring")  dolfin::IndexSet::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Return given index

* operator[]\ (i)

  Return given index (const version)
";

%feature("docstring")  dolfin::IndexSet::insert "
Insert index into set
";

%feature("docstring")  dolfin::IndexSet::fill "
Fill index set with indices 0, 1, 2, ..., size - 1
";

%feature("docstring")  dolfin::IndexSet::clear "
Clear set
";

// Documentation extracted from: (module=common, header=Set.h)
%feature("docstring")  dolfin::Set::Set "
**Overloaded versions**

* Set\ ()

  Create empty set

* Set\ (x)

  Wrap std::vectpr as a set. Contents will be erased.

* Set\ (x)

  Copy constructor
";

%feature("docstring")  dolfin::Set::find "
**Overloaded versions**

* find\ (x)

  Find entry in set and return an iterator to the entry

* find\ (x)

  Find entry in set and return an iterator to the entry (const)
";

%feature("docstring")  dolfin::Set::insert "
**Overloaded versions**

* insert\ (x)

  Insert entry

* insert\ (first, last)

  Insert entries
";

%feature("docstring")  dolfin::Set::size "
Set size
";

%feature("docstring")  dolfin::Set::erase "
Erase an entry
";

%feature("docstring")  dolfin::Set::sort "
Sort set
";

%feature("docstring")  dolfin::Set::clear "
Clear set
";

%feature("docstring")  dolfin::Set::operator[] "
Index the nth entry in the set
";

%feature("docstring")  dolfin::Set::set "
**Overloaded versions**

* set\ ()

  Return the vector that stores the data in the Set

* set\ ()

  Return the vector that stores the data in the Set
";

// Documentation extracted from: (module=common, header=Timer.h)
%feature("docstring")  dolfin::Timer "
A timer can be used for timing tasks. The basic usage is

  Timer timer(\"Assembling over cells\");

The timer is started at construction and timing ends
when the timer is destroyed (goes out of scope). It is
also possible to start and stop a timer explicitly by

  timer.start();
  timer.stop();

Timings are stored globally and a summary may be printed
by calling

  summary();
";

%feature("docstring")  dolfin::Timer::Timer "
Create timer
";

%feature("docstring")  dolfin::Timer::start "
Start timer
";

%feature("docstring")  dolfin::Timer::stop "
Stop timer
";

%feature("docstring")  dolfin::Timer::value "
Return value of timer (or time at start if not stopped)
";

// Documentation extracted from: (module=common, header=Variable.h)
%feature("docstring")  dolfin::Variable "
Common base class for DOLFIN variables.
";

%feature("docstring")  dolfin::Variable::Variable "
**Overloaded versions**

* Variable\ ()

  Create unnamed variable

* Variable\ (name, label)

  Create variable with given name and label

* Variable\ (variable)

  Copy constructor
";

%feature("docstring")  dolfin::Variable::rename "
Rename variable
";

%feature("docstring")  dolfin::Variable::name "
Return name
";

%feature("docstring")  dolfin::Variable::label "
Return label (description)
";

%feature("docstring")  dolfin::Variable::id "
Get unique identifier.

*Returns*
    _uint_
        The unique integer identifier associated with the object.
";

%feature("docstring")  dolfin::Variable::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=common, header=Hierarchical.h)
%feature("docstring")  dolfin::Hierarchical "
This class provides storage and data access for hierarchical
classes; that is, classes where an object may have a child
and a parent.

Note to developers: each subclass of Hierarchical that
implements an assignment operator must call the base class
assignment operator at the *end* of the subclass assignment
operator. See the Mesh class for an example.
";

%feature("docstring")  dolfin::Hierarchical::Hierarchical "
Constructor
";

%feature("docstring")  dolfin::Hierarchical::depth "
Return depth of the hierarchy; that is, the total number of
objects in the hierarchy linked to the current object via
child-parent relationships, including the object itself.

*Returns*
    int
        The depth of the hierarchy.
";

%feature("docstring")  dolfin::Hierarchical::has_parent "
Check if the object has a parent.

*Returns*
    bool
        The return value is true iff the object has a parent.
";

%feature("docstring")  dolfin::Hierarchical::has_child "
Check if the object has a child.

*Returns*
    bool
        The return value is true iff the object has a child.
";

%feature("docstring")  dolfin::Hierarchical::parent "
**Overloaded versions**

* parent\ ()

  Return parent in hierarchy. An error is thrown if the object
  has no parent.
  
  *Returns*
      _Object_
          The parent object.

* parent\ ()

  Return parent in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::parent_shared_ptr "
**Overloaded versions**

* parent_shared_ptr\ ()

  Return shared pointer to parent. A zero pointer is returned if
  the object has no parent.
  
  *Returns*
      shared_ptr<T>
          The parent object.

* parent_shared_ptr\ ()

  Return shared pointer to parent (const version).
";

%feature("docstring")  dolfin::Hierarchical::child "
**Overloaded versions**

* child\ ()

  Return child in hierarchy. An error is thrown if the object
  has no child.
  
  *Returns*
      _T_
          The child object.

* child\ ()

  Return child in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::child_shared_ptr "
**Overloaded versions**

* child_shared_ptr\ ()

  Return shared pointer to child. A zero pointer is returned if
  the object has no child.
  
  *Returns*
      shared_ptr<T>
          The child object.

* child_shared_ptr\ ()

  Return shared pointer to child (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node "
**Overloaded versions**

* root_node\ ()

  Return root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node\ ()

  Return root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::root_node_shared_ptr "
**Overloaded versions**

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy.
  
  *Returns*
      _T_
          The root node object.

* root_node_shared_ptr\ ()

  Return shared pointer to root node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node "
**Overloaded versions**

* leaf_node\ ()

  Return leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node\ ()

  Return leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::leaf_node_shared_ptr "
**Overloaded versions**

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy.
  
  *Returns*
      _T_
          The leaf node object.

* leaf_node_shared_ptr\ ()

  Return shared pointer to leaf node object in hierarchy (const version).
";

%feature("docstring")  dolfin::Hierarchical::set_parent "
Set parent
";

%feature("docstring")  dolfin::Hierarchical::set_child "
Set child
";

%feature("docstring")  dolfin::Hierarchical::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Hierarchical::_debug "
Function useful for debugging the hierarchy
";

// Documentation extracted from: (module=common, header=MPI.h)
%feature("docstring")  dolfin::MPICommunicator::MPICommunicator "
Create communicator (copy of MPI_COMM_WORLD)
";

%feature("docstring")  dolfin::MPICommunicator::operator* "
Dereference operator
";

%feature("docstring")  dolfin::MPI "
This class provides utility functions for easy communcation with MPI.
";

%feature("docstring")  dolfin::MPI::process_number "
Return proccess number
";

%feature("docstring")  dolfin::MPI::num_processes "
Return number of processes
";

%feature("docstring")  dolfin::MPI::is_broadcaster "
Determine whether we should broadcast (based on current parallel policy)
";

%feature("docstring")  dolfin::MPI::is_receiver "
Determine whether we should receive (based on current parallel policy)
";

%feature("docstring")  dolfin::MPI::barrier "
Set a barrier (synchronization point)
";

%feature("docstring")  dolfin::MPI::distribute "
**Overloaded versions**

* distribute\ (in_values, destinations, out_values, sources)

  Distribute local arrays on all processors according to given partition

* distribute\ (in_values, destinations, out_values)

  Distribute local arrays on all processors according to given partition
";

%feature("docstring")  dolfin::MPI::scatter "
Scatter in_values[i] to process i
";

%feature("docstring")  dolfin::MPI::global_offset "
Find global offset (index) (wrapper for MPI_(Ex)Scan with MPI_SUM as
reduction op)
";

%feature("docstring")  dolfin::MPI::send_recv "
Send-receive and data
";

%feature("docstring")  dolfin::MPI::local_range "
**Overloaded versions**

* local_range\ (N)

  Return local range for local process, splitting [0, N - 1] into
  num_processes() portions of almost equal size

* local_range\ (process, N)

  Return local range for given process, splitting [0, N - 1] into
  num_processes() portions of almost equal size

* local_range\ (process, N, num_processes)

  Return local range for given process, splitting [0, N - 1] into
  num_processes portions of almost equal size
";

%feature("docstring")  dolfin::MPI::index_owner "
Return which process owns index (inverse of local_range)
";

// Documentation extracted from: (module=common, header=SubSystemsManager.h)
%feature("docstring")  dolfin::SubSystemsManager "
This is a singleton class which manages the initialisation and
finalisation of various sub systems, such as MPI and PETSc.
";

%feature("docstring")  dolfin::SubSystemsManager::init_mpi "
Initialise MPI
";

%feature("docstring")  dolfin::SubSystemsManager::init_petsc "
**Overloaded versions**

* init_petsc\ ()

  Initialize PETSc without command-line arguments

* init_petsc\ (argc, argv[])

  Initialize PETSc with command-line arguments. Note that PETSc
  command-line arguments may also be filtered and sent to PETSc
  by parameters.parse(argc, argv).
";

%feature("docstring")  dolfin::SubSystemsManager::finalize "
Finalize subsytems. This will be called by the destructor, but in
special cases it may be necessary to call finalize() explicitly.
";

// Documentation extracted from: (module=io, header=File.h)
%feature("docstring")  dolfin::File "
A File represents a data file for reading and writing objects.
Unless specified explicitly, the format is determined by the
file name suffix.
A list of objects that can be read/written to file can be found in
GenericFile.h. Compatible file formats include:
    * XML (.xml)
    * VTK (.pvd)
    * RAW (.raw)
    * XYZ (.xyz)
    * Binary (.bin)
";

%feature("docstring")  dolfin::File::File "
**Overloaded versions**

* File\ (filename, encoding=\"ascii\")

  Create a file with given name
  
  *Arguments*
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (filename, type, encoding=\"ascii\")

  Create a file with given name and type (format)
  
  *Arguments*
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (outstream)

  Create an outfile object writing to stream
  
  *Arguments*
      outstream (std::ostream)
          The stream.
";

%feature("docstring")  dolfin::File::operator>> "
Read from file
";

%feature("docstring")  dolfin::File::operator<< "
**Overloaded versions**

* operator<<\ (Function*, u)

  Write Function to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (t)

  Write object to file
";

%feature("docstring")  dolfin::File::exists "
Check if file exists

*Arguments*
    filename (str)
        Name of file.

*Returns*
    bool
        True if the file exists.
";

// Documentation extracted from: (module=adaptivity, header=GenericAdaptiveVariationalSolver.h)
%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver "
An abstract class for goal-oriented adaptive solution of
variational problems.
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::solve "
**Overloaded versions**

* solve\ (tol, goal, control)

  Solve such that the error measured in the functional 'goal' is
  less than the given tolerance using the ErrorControl object
  'control'
  
  *Arguments*
      tol (float)
          The error tolerance
      goal (:py:class:`Form`)
          The goal functional
      control (:py:class:`ErrorControl`)
          The error controller

* solve\ (tol, M)

  Solve such that the error measured in the goal functional 'M'
  is less than the given tolerance using the GoalFunctional's
  ErrorControl object. Must be overloaded in subclass.
  
  *Arguments*
      tol (float)
          The error tolerance
      goal (:py:class:`GoalFunctional`)
          The goal functional
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::solve_primal "
Solve the primal problem. Must be overloaded in subclass.

*Returns*
    :py:class:`Function`
        The solution to the primal problem
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::extract_bcs "
Extract the boundary conditions for the primal problem. Must
be overloaded in subclass.

*Returns*
    list of :py:class:`BoundaryCondition`
        The primal boundary conditions
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::evaluate_goal "
Evaluate the goal functional. Must be overloaded in subclass.

*Arguments*
   M (:py:class:`Form`)
       The functional to be evaluated
   u (:py:class:`Function`)
       The function of which to evaluate the functional

*Returns*
    float
        The value of M evaluated at u
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::adapt_problem "
Adapt the problem to other mesh. Must be overloaded in subclass.

*Arguments*
   mesh (:py:class:`Mesh`)
       The other mesh
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::adaptive_data "
Return stored adaptive data

*Returns*
   list of :py:class:`Parameters`
       The data stored in the adaptive loop
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::default_parameters "
Default parameter values:

    \"max_iterations\"     (int)
    \"max_dimension\"      (int)
    \"plot_mesh\"          (bool)
    \"save_data\"          (bool)
    \"data_label\"         (std::string)
    \"reference\"          (double)
    \"marking_strategy\"   (std::string)
    \"marking_fraction\"   (double)
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::summary "
Present summary of all adaptive data and parameters
";

%feature("docstring")  dolfin::GenericAdaptiveVariationalSolver::num_dofs_primal "
Return the number of degrees of freedom for primal problem

*Returns*
    _uint_
        The number of degrees of freedom
";

// Documentation extracted from: (module=adaptivity, header=AdaptiveLinearVariationalSolver.h)
%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver "
A class for goal-oriented adaptive solution of linear
variational problems.

For a linear variational problem of the form: find u in V
satisfying

    a(u, v) = L(v) for all v in :math:`\hat V`

and a corresponding conforming discrete problem: find u_h in V_h
satisfying

    a(u_h, v) = L(v) for all v in :math:`\hat V_h`

and a given goal functional M and tolerance tol, the aim is to
find a V_H and a u_H in V_H satisfying the discrete problem such
that

    \|M(u) - M(u_H)\| < tol

This strategy is based on dual-weighted residual error
estimators designed and automatically generated for the primal
problem and subsequent h-adaptivity.
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::AdaptiveLinearVariationalSolver "
**Overloaded versions**

* AdaptiveLinearVariationalSolver\ (problem)

  Create AdaptiveLinearVariationalSolver
  
  *Arguments*
      problem (:py:class:`LinearVariationalProblem`)
          The primal problem

* AdaptiveLinearVariationalSolver\ (problem)

  Create AdaptiveLinearVariationalSolver
  
  *Arguments*
      problem (:py:class:`LinearVariationalProblem`)
          The primal problem
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::solve "
Solve problem such that the error measured in the goal
functional 'M' is less than the given tolerance using the
GoalFunctional's ErrorControl object.

*Arguments*
    tol (float)
        The error tolerance
    goal (:py:class:`GoalFunctional`)
        The goal functional
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::solve_primal "
Solve the primal problem.

*Returns*
    :py:class:`Function`
        The solution to the primal problem
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::extract_bcs "
Extract the boundary conditions for the primal problem.

*Returns*
    list of :py:class:`BoundaryCondition`
        The primal boundary conditions
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::evaluate_goal "
Evaluate the goal functional.

*Arguments*
   M (:py:class:`Form`)
       The functional to be evaluated
   u (:py:class:`Function`)
       The function at which to evaluate the functional

*Returns*
    float
        The value of M evaluated at u
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::adapt_problem "
Adapt the problem to other mesh.

*Arguments*
   mesh (:py:class:`Mesh`)
       The other mesh
";

%feature("docstring")  dolfin::AdaptiveLinearVariationalSolver::num_dofs_primal "
Return the number of degrees of freedom for primal problem

*Returns*
    _uint_
        The number of degrees of freedom
";

// Documentation extracted from: (module=adaptivity, header=AdaptiveNonlinearVariationalSolver.h)
%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver "
A class for goal-oriented adaptive solution of nonlinear
variational problems.

For a nonlinear variational problem of the form: find u in V
satisfying

    F(u; v) = 0 for all v in :math:`\hat V`

and a corresponding conforming discrete problem: find u_h in V_h
satisfying (at least approximately)

    F(u_h; v) = 0 for all v in :math:`\hat V_h`

and a given goal functional M and tolerance tol, the aim is to
find a V_H and a u_H in V_H satisfying the discrete problem such
that

    \|M(u) - M(u_H)\| < tol

This strategy is based on dual-weighted residual error
estimators designed and automatically generated for the primal
problem and subsequent h-adaptivity.
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::AdaptiveNonlinearVariationalSolver "
**Overloaded versions**

* AdaptiveNonlinearVariationalSolver\ (problem)

  Create AdaptiveNonlinearVariationalSolver
  
  *Arguments*
      problem (:py:class:`NonlinearVariationalProblem`)
          The primal problem

* AdaptiveNonlinearVariationalSolver\ (problem)

  Create AdaptiveNonlinearVariationalSolver
  
  *Arguments*
      problem (:py:class:`NonlinearVariationalProblem`)
          The primal problem
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::solve "
Solve problem such that the error measured in the goal
functional 'M' is less than the given tolerance using the
GoalFunctional's ErrorControl object.

*Arguments*
    tol (float)
        The error tolerance
    goal (:py:class:`GoalFunctional`)
        The goal functional
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::solve_primal "
Solve the primal problem.

*Returns*
    :py:class:`Function`
        The solution to the primal problem
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::extract_bcs "
Extract the boundary conditions for the primal problem.

*Returns*
    list of :py:class:`BoundaryCondition`
        The primal boundary conditions
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::evaluate_goal "
Evaluate the goal functional.

*Arguments*
   M (:py:class:`Form`)
       The functional to be evaluated
   u (:py:class:`Function`)
       The function at which to evaluate the functional

*Returns*
    float
        The value of M evaluated at u
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::adapt_problem "
Adapt the problem to other mesh.

*Arguments*
   mesh (:py:class:`Mesh`)
       The other mesh
";

%feature("docstring")  dolfin::AdaptiveNonlinearVariationalSolver::num_dofs_primal "
Return the number of degrees of freedom for primal problem

*Returns*
    _uint_
        The number of degrees of freedom
";

// Documentation extracted from: (module=adaptivity, header=GoalFunctional.h)
%feature("docstring")  dolfin::GoalFunctional "
A :py:class:`GoalFunctional` is a :py:class:`Form` of rank 0 with an associated
:py:class:`ErrorControl`.
";

%feature("docstring")  dolfin::GoalFunctional::GoalFunctional "
Create :py:class:`GoalFunctional`

*Arguments*
    rank (int)
        the rank of the functional (should be 0)
    num_coefficients (int)
        the number of coefficients in functional
";

%feature("docstring")  dolfin::GoalFunctional::update_ec "
Update error control instance with given forms

*Arguments*
    a (:py:class:`Form`)
        a bilinear form
    L (:py:class:`Form`)
        a linear form
";

// Documentation extracted from: (module=adaptivity, header=ErrorControl.h)
%feature("docstring")  dolfin::ErrorControl "
(Goal-oriented) Error Control class.
The notation used here follows the notation in \"Automated
goal-oriented error control I: stationary variational problems\",
ME Rognes and A Logg, 2010-2011.
";

%feature("docstring")  dolfin::ErrorControl::ErrorControl "
Create error control object

*Arguments*
    a_star (:py:class:`Form`)
       the bilinear form for the dual problem
    L_star (:py:class:`Form`)
       the linear form for the dual problem
    residual (:py:class:`Form`)
       a functional for the residual (error estimate)
    a_R_T (:py:class:`Form`)
       the bilinear form for the strong cell residual problem
    L_R_T (:py:class:`Form`)
       the linear form for the strong cell residual problem
    a_R_dT (:py:class:`Form`)
       the bilinear form for the strong facet residual problem
    L_R_dT (:py:class:`Form`)
       the linear form for the strong facet residual problem
    eta_T (:py:class:`Form`)
       a linear form over DG_0 for error indicators
    is_linear (bool)
       true iff primal problem is linear
";

%feature("docstring")  dolfin::ErrorControl::default_parameters "
Default parameter values:
";

%feature("docstring")  dolfin::ErrorControl::estimate_error "
Estimate the error relative to the goal M of the discrete
approximation 'u' relative to the variational formulation by
evaluating the weak residual at an approximation to the dual
solution.

*Arguments*
    u (:py:class:`Function`)
       the primal approximation

    bcs (list of :py:class:`BoundaryCondition`)
        the primal boundary conditions

*Returns*
    float
        error estimate
";

%feature("docstring")  dolfin::ErrorControl::compute_indicators "
Compute error indicators

*Arguments*
    indicators (:py:class:`Vector`)
        the error indicators (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::residual_representation "
Compute strong representation (strong cell and facet
residuals) of the weak residual.

*Arguments*
    R_T (:py:class:`Function`)
        the strong cell residual (to be computed)

    R_dT (:py:class:`SpecialFacetFunction`)
        the strong facet residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::compute_cell_residual "
Compute representation for the strong cell residual
from the weak residual

*Arguments*
    R_T (:py:class:`Function`)
        the strong cell residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation
";

%feature("docstring")  dolfin::ErrorControl::compute_facet_residual "
Compute representation for the strong facet residual from the
weak residual and the strong cell residual

*Arguments*
    R_dT (:py:class:`SpecialFacetFunction`)
        the strong facet residual (to be computed)

    u (:py:class:`Function`)
        the primal approximation

    R_T (:py:class:`Function`)
        the strong cell residual
";

%feature("docstring")  dolfin::ErrorControl::compute_dual "
Compute dual approximation defined by dual variational
problem and dual boundary conditions given by homogenized primal
boundary conditions.

*Arguments*
    z (:py:class:`Function`)
        the dual approximation (to be computed)

    bcs (list of :py:class:`BoundaryCondition`)
        the primal boundary conditions
";

%feature("docstring")  dolfin::ErrorControl::compute_extrapolation "
Compute extrapolation with boundary conditions

*Arguments*
    z (:py:class:`Function`)
        the extrapolated function (to be computed)

    bcs (list of :py:class:`BoundaryCondition`)
        the dual boundary conditions
";

// Documentation extracted from: (module=adaptivity, header=Extrapolation.h)
%feature("docstring")  dolfin::Extrapolation "
This class implements an algorithm for extrapolating a function
on a given function space from an approximation of that function
on a possibly lower-order function space.

This can be used to obtain a higher-order approximation of a
computed dual solution, which is necessary when the computed
dual approximation is in the test space of the primal problem,
thereby being orthogonal to the residual.

It is assumed that the extrapolation is computed on the same
mesh as the original function.
";

%feature("docstring")  dolfin::Extrapolation::extrapolate "
Compute extrapolation w from v
";

// Documentation extracted from: (module=adaptivity, header=LocalAssembler.h)
%feature("docstring")  dolfin::LocalAssembler "

";

%feature("docstring")  dolfin::LocalAssembler::assemble "

";

%feature("docstring")  dolfin::LocalAssembler::assemble_cell "

";

%feature("docstring")  dolfin::LocalAssembler::assemble_exterior_facet "

";

%feature("docstring")  dolfin::LocalAssembler::assemble_interior_facet "

";

// Documentation extracted from: (module=adaptivity, header=SpecialFacetFunction.h)
%feature("docstring")  dolfin::SpecialFacetFunction::SpecialFacetFunction "
**Overloaded versions**

* SpecialFacetFunction\ (f_e)

  Create (scalar-valued) SpecialFacetFunction
  
  *Arguments*
      f_e (list of :py:class:`Function`)
         Separate _Function_s for each facet

* SpecialFacetFunction\ (f_e, dim)

  Create (vector-valued) SpecialFacetFunction
  
  *Arguments*
      f_e (list of :py:class:`Function`)
         Separate _Function_s for each facet
  
      dim (int)
          The value-dimension of the Functions
";

%feature("docstring")  dolfin::SpecialFacetFunction::eval "
Evaluate SpecialFacetFunction (cf :py:class:`Expression`.eval)
Evaluate function for given cell
";

%feature("docstring")  dolfin::SpecialFacetFunction::operator[] "
Extract sub-function i

*Arguments*
    i (int)
       component

*Returns*
    :py:class:`Function`
";

// Documentation extracted from: (module=adaptivity, header=TimeSeries.h)
%feature("docstring")  dolfin::TimeSeries "
This class stores a time series of objects to file(s) in a
binary format which is efficient for reading and writing.

When objects are retrieved, the object stored at the time
closest to the given time will be used.

A new time series will check if values have been stored to
file before (for a series with the same name) and in that
case reuse those values. If new values are stored, old
values will be cleared.
";

%feature("docstring")  dolfin::TimeSeries::TimeSeries "
Create empty time series

*Arguments*
    name (str)
        The time series name
    compressed (bool)
        Use compressed file format (default false)
    store_connectivity (bool)
        Store all computed connectivity (default false)
";

%feature("docstring")  dolfin::TimeSeries::store "
**Overloaded versions**

* store\ (vector, t)

  Store vector at given time
  
  *Arguments*
      vector (:py:class:`GenericVector`)
          The vector to be stored.
      t (float)
          The time.

* store\ (mesh, t)

  Store mesh at given time
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh to be stored.
      t (float)
          The time.
";

%feature("docstring")  dolfin::TimeSeries::retrieve "
**Overloaded versions**

* retrieve\ (vector, t, interpolate=true)

  Retrieve vector at given time
  
  *Arguments*
      vector (:py:class:`GenericVector`)
          The vector (values to be retrieved).
      t (float)
          The time.
      interpolate (bool)
          Optional argument: If true (default), interpolate
          time samples closest to t if t is not present.

* retrieve\ (mesh, t)

  Retrieve mesh at given time
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          The mesh (values to be retrieved).
      t (float)
          The time.
";

%feature("docstring")  dolfin::TimeSeries::vector_times "
Return array of sample times for vectors

*Returns*
    numpy.array(float)
        The times.
";

%feature("docstring")  dolfin::TimeSeries::mesh_times "
Return array of sample times for meshes

*Returns*
    numpy.array(float)
        The times.
";

%feature("docstring")  dolfin::TimeSeries::clear "
Clear time series
";

%feature("docstring")  dolfin::TimeSeries::filename_data "
Return filename for data

*Arguments*
    series_name (str)
        The time series name
    type_name (str)
        The type of data
    index (int)
        The index
    compressed (bool)
        True if compressed file format

*Returns*
    str
        The filename
";

%feature("docstring")  dolfin::TimeSeries::filename_times "
Return filename for times

*Arguments*
    series_name (str)
        The time series name
    type_name (str)
        The type of data
    compressed (bool)
        True if compressed file format

*Returns*
    str
        The filename
";

%feature("docstring")  dolfin::TimeSeries::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::TimeSeries::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=adaptivity, header=adapt.h)
%feature("docstring")  dolfin::adapt "
**Overloaded versions**

* adapt\ (mesh)

  Refine mesh uniformly

* adapt\ (mesh, cell_markers)

  Refine mesh based on cell markers

* adapt\ (space)

  Refine function space uniformly

* adapt\ (space, cell_markers)

  Refine function space based on cell markers

* adapt\ (space, adapted_mesh)

  Refine function space based on refined mesh

* adapt\ (function, adapted_mesh, interpolate=true)

  Adapt Function based on adapted mesh
  
  *Arguments*
      function (:py:class:`Function`)
          The function that should be adapted
      adapted_mesh (:py:class:`Mesh`)
          The new mesh
      interpolate (bool)
          Optional argument, default is true. If false, the
          function's function space is adapted, but the values are
          not interpolated.
  
  *Returns*
      :py:class:`Function`
          The adapted function

* adapt\ (function, adapted_mesh)

  Refine GenericFunction based on refined mesh

* adapt\ (mesh_function, adapted_mesh)

  Refine mesh function<uint> based on mesh

* adapt\ (bc, adapted_mesh, S)

  Refine Dirichlet bc based on refined mesh

* adapt\ (form, adapted_mesh, adapt_coefficients=true)

  Adapt form based on adapted mesh
  
  *Arguments*
      form (:py:class:`Form`)
          The form that should be adapted
      adapted_mesh (:py:class:`Mesh`)
          The new mesh
      adapt_coefficients (bool)
          Optional argument, default is true. If false, the form
          coefficients are not explictly adapted, but pre-adapted
          coefficients will be transferred.
  
  *Returns*
      :py:class:`Form`
          The adapted form

* adapt\ (problem, adapted_mesh)

  Refine linear variational problem based on mesh

* adapt\ (problem, adapted_mesh)

  Refine nonlinear variational problem based on mesh

* adapt\ (ec, adapted_mesh, adapt_coefficients=true)

  Adapt error control object based on adapted mesh
  
  *Arguments*
      ec (:py:class:`ErrorControl`)
          The error control object to be adapted
      adapted_mesh (:py:class:`Mesh`)
          The new mesh
      adapt_coefficients (bool)
          Optional argument, default is true. If false, any form
          coefficients are not explictly adapted, but pre-adapted
          coefficients will be transferred.
  
  *Returns*
      :py:class:`ErrorControl`
          The adapted error control object
";

%feature("docstring")  dolfin::adapt_markers "
Helper function for refinement of boundary conditions
";

// Documentation extracted from: (module=adaptivity, header=marking.h)
%feature("docstring")  dolfin::mark "
Mark cells based on indicators and given marking strategy

*Arguments*
    markers (:py:class:`MeshFunction`)
        the cell markers (to be computed)

    indicators (:py:class:`Vector`)
        error indicators (one per cell)

    strategy (str)
        the marking strategy

    fraction (float)
        the marking fraction
";

%feature("docstring")  dolfin::dorfler_mark "
Mark cells using Dorfler marking

*Arguments*
    markers (:py:class:`MeshFunction`)
        the cell markers (to be computed)

    indicators (:py:class:`Vector`)
        error indicators (one per cell)

    fraction (float)
        the marking fraction
";

// Documentation extracted from: (module=adaptivity, header=adaptivesolve.h)
%feature("docstring")  dolfin::solve "
**Overloaded versions**

* solve\ (equation, u, tol, M)

  Solve linear variational problem a(u, v) == L(v) without
  essential boundary conditions

* solve\ (equation, u, bc, tol, M)

  Solve linear variational problem a(u, v) == L(v) with single
  boundary condition

* solve\ (equation, u, bcs, tol, M)

  Solve linear variational problem a(u, v) == L(v) with list of
  boundary conditions

* solve\ (equation, u, J, tol, M)

  Solve nonlinear variational problem F(u; v) = 0 without
  essential boundary conditions

* solve\ (equation, u, bc, J, tol, M)

  Solve linear variational problem F(u; v) = 0 with single
  boundary condition

* solve\ (equation, u, bcs, J, tol, M)

  Solve linear variational problem F(u; v) = 0 with list of
  boundary conditions
";

// Documentation extracted from: (module=intersection, header=IntersectionOperator.h)
%feature("docstring")  dolfin::IntersectionOperator::IntersectionOperator "
**Overloaded versions**

* IntersectionOperator\ (_mesh, \"SimpleCartesian\")

  Create intersection detector for a given mesh
  
  
  @param kernel_type The CGAL geometric kernel is used to compute predicates,
  intersections and such. Depending on this choice the kernel
  (kernel_type = \"ExcactPredicates\") can compute predicates excactly
  (without roundoff error) or only approximately (default, kernel_type =
  \"SimpleCartesian\").

* IntersectionOperator\ (labels, label, \"SimpleCartesian\")

  Create  IntersectionOperator for a given mesh
  
  *Arguments*
      labels (_MeshFunction<unsigned int>_)
          A MeshFunction over entities labeling the part of the Mesh
          for which the distance will be measured to
  
      label (int)
          The label determining the part of the mesh for which
          the distance will be measured to
  
      kernel_type (str)
          The CGAL geometric kernel which is used to compute predicates,
          intersections and such. Depending on this choice the kernel
          (kernel_type = \"ExcactPredicates\") can compute predicates
          excactly (without roundoff error) or only approximately
          default value is \"SimpleCartesian\".

* IntersectionOperator\ (labels, label, kernel_type=\"SimpleCartesian\")

  Create IntersectionOperator for a given mesh (shared data)
  
  *Arguments*
      labels (_MeshFunction<unsigned int>_)
          A MeshFunction over facets labeling the part of the Boundary
          for which the distance will be measured to
  
      label (int)
          The label determining the part of the mesh for which
          the distance will be measured to
  
      kernel_type (str)
          The CGAL geometric kernel which is used to compute predicates,
          intersections and such. Depending on this choice the kernel
          (kernel_type = \"ExcactPredicates\") can compute predicates
          excactly (without roundoff error) or only approximately
          default value is \"SimpleCartesian\".
";

%feature("docstring")  dolfin::IntersectionOperator::all_intersected_entities "
**Overloaded versions**

* all_intersected_entities\ (point, ids_result)

  Compute all id of all cells which are intersects by a \em point.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (points, ids_result)

  Compute all id of all cells which are intersects any point in \em points.
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (entity, ids_result)

  Compute all id of all cells which are intersects by a \em entity.
  \param[out] ids_result The ids of the intersected entities are saved in a vector.
  This allows is more efficent than using a set and allows a map between
  the (external) cell and the intersected cell of the mesh. If you
  are only interested in intersection with a list of cells without caring about which
  cell what intersected by which one, use
  void IntersectionOperator::all_intersected_entities(const std::vector<Cell> &, std::set<uint> &) const;
  @internal
  @todo This function has to improved: 1) it requires the object the
  mesh is to be cut with to be another mesh entitiy instead of being just a
  kind of geometric object. 2) Requires a runtime switch 3) would require a
  implementation for each geometric  primitive if they have no common base
  class.

* all_intersected_entities\ (entities, ids_result)

  Compute all id of all cells which are intersects by any of the entities in \em entities. This
  \param[out] ids_result The ids of the intersected set are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.

* all_intersected_entities\ (another_mesh, ids_result)

  Compute all id of all cells which are intersects by the given mesh \em another_mesh;
  \param[out] ids_result The ids of the intersected entities are saved in a set for efficienty
  reasons, to avoid to sort out duplicates later on.
";

%feature("docstring")  dolfin::IntersectionOperator::any_intersected_entity "
Computes only the first id of the entity, which contains the point. Returns -1 if no cell is intersected.
@internal @remark This makes the function evaluation significantly faster.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point "
Computes the point inside the mesh which is closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_cell "
Computes the index of the cell inside the mesh which are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::closest_point_and_cell "
Computes the point inside the mesh and the corresponding cell index
that are closest to the point query.
";

%feature("docstring")  dolfin::IntersectionOperator::distance "
Computes the distance between the given point and the nearest entity
";

%feature("docstring")  dolfin::IntersectionOperator::reset_kernel "
Rebuilds the underlying search structure from scratch and uses
the kernel kernel_type underlying CGAL Geometry kernel.
";

%feature("docstring")  dolfin::IntersectionOperator::clear "
Clears search structure. Should be used if the mesh has changed
";

// Documentation extracted from: (module=intersection, header=PrimitiveIntersector.h)
%feature("docstring")  dolfin::PrimitiveIntersector "
This class implements an intersection detection, detecting
whether two given (arbitrary) meshentities intersect.
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect "
**Overloaded versions**

* do_intersect\ (entity_1, entity_2)

  Computes whether two mesh entities intersect using an inexact
  geometry kernel which is fast but may suffer from floating
  point precision

* do_intersect\ (entity_1, point)

  Computes whether a mesh entity and point intersect using an
  inexact geometry kernel which is fast but may suffer from
  floating point precision
";

%feature("docstring")  dolfin::PrimitiveIntersector::do_intersect_exact "
**Overloaded versions**

* do_intersect_exact\ (entity_1, entity_2)

  Computes whether two mesh entities intersect using an exact
  geometry kernel which is slow but always correct

* do_intersect_exact\ (entity_1, point)

  Computes whether a mesh entity and point intersect using an
  exact geometry kernel which is slow but always correct
";

// Documentation extracted from: (module=intersection, header=PrimitiveTraits.h)
// Documentation extracted from: (module=intersection, header=MeshPrimitive.h)
%feature("docstring")  dolfin::getEntity "
Static, so only reference to a mesh and entity index have to be saved
";

%feature("docstring")  dolfin::MeshPrimitive "
**Overloaded versions**

* MeshPrimitive\ (entity)

  Create a MeshPrimitive from a given MeshEntityIterator

* MeshPrimitive\ (entity)

  Create a MeshPrimitive from a given SubsetIterator
";

// Documentation extracted from: (module=parameter, header=Parameter.h)
%feature("docstring")  dolfin::Parameter "
Base class for parameters.
";

%feature("docstring")  dolfin::Parameter::Parameter "
Create parameter for given key
";

%feature("docstring")  dolfin::Parameter::key "
Return parameter key
";

%feature("docstring")  dolfin::Parameter::description "
Return parameter description
";

%feature("docstring")  dolfin::Parameter::is_set "
Return true if parameter is set, return false otherwise
";

%feature("docstring")  dolfin::Parameter::access_count "
Return access count (number of times parameter has been accessed)
";

%feature("docstring")  dolfin::Parameter::change_count "
Return change count (number of times parameter has been changed)
";

%feature("docstring")  dolfin::Parameter::set_range "
**Overloaded versions**

* set_range\ (min_value, max_value)

  Set range for int-valued parameter

* set_range\ (min_value, max_value)

  Set range for double-valued parameter

* set_range\ (range)

  Set range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::get_range "
**Overloaded versions**

* get_range\ (min_value, max_value)

  Get range for int-valued parameter

* get_range\ (min_value, max_value)

  Get range for double-valued parameter

* get_range\ (range)

  Get range for string-valued parameter
";

%feature("docstring")  dolfin::Parameter::operator= "
**Overloaded versions**

* operator=\ (value)

  Assignment from int

* operator=\ (value)

  Assignment from double

* operator=\ (value)

  Assignment from string

* operator=\ (value)

  Assignment from string

* operator=\ (value)

  Assignment from bool
";

%feature("docstring")  dolfin::Parameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::Parameter::operator dolfin::uint "
Cast parameter to uint
";

%feature("docstring")  dolfin::Parameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::Parameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::Parameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::Parameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::Parameter::value_str "
Return value string
";

%feature("docstring")  dolfin::Parameter::range_str "
Return range string
";

%feature("docstring")  dolfin::Parameter::str "
Return short string description
";

%feature("docstring")  dolfin::IntParameter "
Parameter with value type int
";

%feature("docstring")  dolfin::IntParameter::IntParameter "
**Overloaded versions**

* IntParameter\ (key)

  Create unset int-valued

* IntParameter\ (key, value)

  Create int-valued parameter
";

%feature("docstring")  dolfin::IntParameter::set_range "
Set range
";

%feature("docstring")  dolfin::IntParameter::get_range "
Get range
";

%feature("docstring")  dolfin::IntParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::IntParameter::operator int "
Cast parameter to int
";

%feature("docstring")  dolfin::IntParameter::operator dolfin::uint "
Cast parameter to uint
";

%feature("docstring")  dolfin::IntParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::IntParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::IntParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::IntParameter::str "
Return short string description
";

%feature("docstring")  dolfin::DoubleParameter "
Parameter with value type double
";

%feature("docstring")  dolfin::DoubleParameter::DoubleParameter "
**Overloaded versions**

* DoubleParameter\ (key)

  Create unset double-valued parameter

* DoubleParameter\ (key, value)

  Create double-valued parameter
";

%feature("docstring")  dolfin::DoubleParameter::set_range "
Set range
";

%feature("docstring")  dolfin::DoubleParameter::get_range "
Get range
";

%feature("docstring")  dolfin::DoubleParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::DoubleParameter::operator double "
Cast parameter to double
";

%feature("docstring")  dolfin::DoubleParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::DoubleParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::DoubleParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::DoubleParameter::str "
Return short string description
";

%feature("docstring")  dolfin::StringParameter "
Parameter with value type string
";

%feature("docstring")  dolfin::StringParameter::StringParameter "
**Overloaded versions**

* StringParameter\ (key)

  Create unset string-valued parameter

* StringParameter\ (key, value)

  Create string-valued parameter
";

%feature("docstring")  dolfin::StringParameter::set_range "
Set range
";

%feature("docstring")  dolfin::StringParameter::get_range "
Get range
";

%feature("docstring")  dolfin::StringParameter::operator= "
**Overloaded versions**

* operator=\ (value)

  Assignment

* operator=\ (value)

  Assignment
";

%feature("docstring")  dolfin::StringParameter::operator std::string "
Cast parameter to string
";

%feature("docstring")  dolfin::StringParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::StringParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::StringParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::StringParameter::str "
Return short string description
";

%feature("docstring")  dolfin::BoolParameter "
Parameter with value type bool
";

%feature("docstring")  dolfin::BoolParameter::BoolParameter "
**Overloaded versions**

* BoolParameter\ (key)

  Create unset bool-valued parameter

* BoolParameter\ (key, value)

  Create bool-valued parameter
";

%feature("docstring")  dolfin::BoolParameter::operator= "
Assignment
";

%feature("docstring")  dolfin::BoolParameter::operator bool "
Cast parameter to bool
";

%feature("docstring")  dolfin::BoolParameter::type_str "
Return value type string
";

%feature("docstring")  dolfin::BoolParameter::value_str "
Return value string
";

%feature("docstring")  dolfin::BoolParameter::range_str "
Return range string
";

%feature("docstring")  dolfin::BoolParameter::str "
Return short string description
";

// Documentation extracted from: (module=parameter, header=Parameters.h)
%feature("docstring")  dolfin::Parameters "
This class stores a set of parameters. Each parameter is
identified by a unique string (the key) and a value of some
given value type. Parameter sets can be nested at arbitrary
depths.

A parameter may be either int, double, string or boolean valued.

Parameters may be added as follows:

  Parameters p(\"my_parameters\");
  p.add(\"relative_tolerance\",  1e-15);
  p.add(\"absolute_tolerance\",  1e-15);
  p.add(\"gmres_restart\",       30);
  p.add(\"monitor_convergence\", false);

Parameters may be changed as follows:

  p[\"gmres_restart\"] = 50;

Parameter values may be retrieved as follows:

  int gmres_restart = p[\"gmres_restart\"];

Parameter sets may be nested as follows:

  Parameters q(\"nested_parameters\");
  p.add(q);

Nested parameters may then be accessed by

  p(\"nested_parameters\")[\"...\"]

Parameters may be nested at arbitrary depths.

Parameters may be parsed from the command-line as follows:

  p.parse(argc, argv);

Note: spaces in parameter keys are not allowed (to simplify
usage from command-line).
";

%feature("docstring")  dolfin::Parameters::Parameters "
**Overloaded versions**

* Parameters\ (\"parameters\")

  Create empty parameter set

* Parameters\ (parameters)

  Copy constructor
";

%feature("docstring")  dolfin::Parameters::name "
Return name for parameter set
";

%feature("docstring")  dolfin::Parameters::rename "
Rename parameter set
";

%feature("docstring")  dolfin::Parameters::clear "
Clear parameter set
";

%feature("docstring")  dolfin::Parameters::add "
**Overloaded versions**

* add\ (key)

  Add an unset parameter of type T. For example, to create a unset
  parameter of type bool, do parameters.add<bool>(\"my_setting\")

* add\ (key, value)

  Add int-valued parameter

* add\ (key, value, min_value, max_value)

  Add int-valued parameter with given range

* add\ (key, value)

  Add double-valued parameter

* add\ (key, value, min_value, max_value)

  Add double-valued parameter with given range

* add\ (key, value)

  Add string-valued parameter

* add\ (key, value)

  Add string-valued parameter

* add\ (key, value, range)

  Add string-valued parameter with given range

* add\ (key, value, range)

  Add string-valued parameter with given range

* add\ (key, value)

  Add bool-valued parameter

* add\ (parameters)

  Add nested parameter set
";

%feature("docstring")  dolfin::Parameters::remove "
Remove parameter or parameter set with given key
";

%feature("docstring")  dolfin::Parameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::Parameters::update "
Update parameters with another set of parameters
";

%feature("docstring")  dolfin::Parameters::operator[] "
**Overloaded versions**

* operator[]\ (key)

  Return parameter for given key

* operator[]\ (key)

  Return parameter for given key (const version)
";

%feature("docstring")  dolfin::Parameters::operator "
**Overloaded versions**

* operator\ (key)

  Return nested parameter set for given key

* operator\ (key)

  Return nested parameter set for given key (const)
";

%feature("docstring")  dolfin::Parameters::operator= "
Assignment operator
";

%feature("docstring")  dolfin::Parameters::has_key "
Check if parameter set has key (parameter or nested parameter set)
";

%feature("docstring")  dolfin::Parameters::has_parameter "
Check if parameter set has given parameter
";

%feature("docstring")  dolfin::Parameters::has_parameter_set "
Check if parameter set has given nested parameter set
";

%feature("docstring")  dolfin::Parameters::get_parameter_keys "
Return a vector of parameter keys
";

%feature("docstring")  dolfin::Parameters::get_parameter_set_keys "
Return a vector of parameter set keys
";

%feature("docstring")  dolfin::Parameters::str "
Return informal string representation (pretty-print)
";

%feature("docstring")  dolfin::Parameters::parse_common "
Parse filtered options (everything except PETSc options)
";

%feature("docstring")  dolfin::Parameters::parse_petsc "
Parse filtered options (only PETSc options)
";

// Documentation extracted from: (module=parameter, header=GlobalParameters.h)
%feature("docstring")  dolfin::GlobalParameters "
This class defines the global DOLFIN parameter database.
";

%feature("docstring")  dolfin::GlobalParameters::GlobalParameters "
Constructor
";

%feature("docstring")  dolfin::GlobalParameters::parse "
Parse parameters from command-line
";

%feature("docstring")  dolfin::GlobalParameters::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=math, header=basic.h)
%feature("docstring")  dolfin::ipow "
Return a to the power n
";

%feature("docstring")  dolfin::rand "
Return a random number, uniformly distributed between [0.0, 1.0)
";

%feature("docstring")  dolfin::seed "
Seed random number generator
";

%feature("docstring")  dolfin::near "
Check whether x is close to x0 (to within DOLFIN_EPS)
";

%feature("docstring")  dolfin::between "
Check whether x is between x0 and x1 (inclusive, to within DOLFIN_EPS)
";

// Documentation extracted from: (module=math, header=Lagrange.h)
%feature("docstring")  dolfin::Lagrange "
Lagrange polynomial (basis) with given degree q determined by n = q + 1 nodal points.

Example: q = 1 (n = 2)

  Lagrange p(1);
  p.set(0, 0.0);
  p.set(1, 1.0);

It is the callers reponsibility that the points are distinct.

This creates a Lagrange polynomial (actually two Lagrange polynomials):

  p(0,x) = 1 - x   (one at x = 0, zero at x = 1)
  p(1,x) = x       (zero at x = 0, one at x = 1)

";

%feature("docstring")  dolfin::Lagrange::Lagrange "
**Overloaded versions**

* Lagrange\ (q)

  Constructor

* Lagrange\ (p)

  Copy constructor
";

%feature("docstring")  dolfin::Lagrange::set "
Specify point
";

%feature("docstring")  dolfin::Lagrange::size "
Return number of points
";

%feature("docstring")  dolfin::Lagrange::degree "
Return degree
";

%feature("docstring")  dolfin::Lagrange::point "
Return point
";

%feature("docstring")  dolfin::Lagrange::operator "
Return value of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::eval "
Return value of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::ddx "
Return derivate of polynomial i at given point x
";

%feature("docstring")  dolfin::Lagrange::dqdx "
Return derivative q (a constant) of polynomial
";

%feature("docstring")  dolfin::Lagrange::str "
Return informal string representation (pretty-print)
";

// Documentation extracted from: (module=math, header=Legendre.h)
%feature("docstring")  dolfin::Legendre "
Interface for computing Legendre polynomials via Boost.
";

%feature("docstring")  dolfin::Legendre::eval "
Evaluate polynomial of order n at point x
";

%feature("docstring")  dolfin::Legendre::ddx "
Evaluate first derivative of polynomial of order n at point x
";

%feature("docstring")  dolfin::Legendre::d2dx "
Evaluate second derivative of polynomial of order n at point x
";

