#!/usr/bin/env python

##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##

import locale, gettext
import getopt, sys

import pygtk
pygtk.require ("2.0")
import gtk

from libdisksearch import Constants
from libdisksearch import DSApp

def print_usage():
    """Print command usage."""
    
    print "Usage: disksearch.py [-a file] [-V] [-h]"
    print "-a, --archive file    use specified archive file"
    print "-V, --version         show program version"
    print "-h, --help            show this usage information"
    
def print_version():
    """Print program version."""
    
    print "DiskSearch, Version 1.1.0"


# start the DiskSearch application
if __name__ == '__main__':
    
    # i18n
    try:
        locale.setlocale(locale.LC_ALL, "")
    except locale.Error:
        print "Setting locale failed!"
    
    gettext.bindtextdomain(Constants.LOCALE_APP, Constants.LOCALE_DIR)
    gettext.textdomain(Constants.LOCALE_APP)
    gettext.install(Constants.LOCALE_APP, Constants.LOCALE_DIR, unicode=1)
    gtk.glade.bindtextdomain(Constants.LOCALE_APP, Constants.LOCALE_DIR)
    gtk.glade.textdomain(Constants.LOCALE_APP)
        
    # parse command line args
    archive = None
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "a:Vh", ["archive=", "version", "help"])
    except getopt.GetoptError, optErr:
        print "disksearch.py: " + str(optErr)
        print_usage()
        sys.exit(2)

    for optName, optVal  in opts:
        if optName in ("-a", "--archive"):
            archive = optVal
        elif optName in ("-V", "--version"):
            print_version()
            sys.exit()
        elif optName in ("-h", "--help"):
            print_usage()
            sys.exit()
    
    # finally start the application main class    
    DSApp.DSApp (archive)
