/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioMenuItem;
import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.KafenioPanelActions;
import de.xeinfach.kafenio.KafenioPanelConfiguration;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;

public class KafenioMenuBar {
    private static LeanLogger log = new LeanLogger("KafenioMenuBar.class");
    public static final String KEY_MENU_FILE = "file";
    public static final String KEY_MENU_EDIT = "edit";
    public static final String KEY_MENU_VIEW = "view";
    public static final String KEY_MENU_FONT = "font";
    public static final String KEY_MENU_FORMAT = "format";
    public static final String KEY_MENU_INSERT = "insert";
    public static final String KEY_MENU_TABLE = "table";
    public static final String KEY_MENU_FORMS = "forms";
    public static final String KEY_MENU_SEARCH = "search";
    public static final String KEY_MENU_TOOLS = "tools";
    public static final String KEY_MENU_HELP = "help";
    public static final String KEY_MENU_DEBUG = "debug";
    public static final String DOTS = "...";
    private KafenioPanel parent;
    private KafenioPanelConfiguration config;
    private JMenuBar menuBar;
    private Hashtable menus;
    private JCheckBoxMenuItem viewToolbarItem;
    private JCheckBoxMenuItem viewSourceItem;
    private static ArrayList parameters = new ArrayList();

    public KafenioMenuBar(KafenioPanel kafenioPanel) {
        this.parent = kafenioPanel;
        this.menuBar = new JMenuBar();
        this.config = this.parent.getConfig();
        log.debug("initializing menu hashtable.");
        this.initMenuHashtable();
    }

    private void initMenuHashtable() {
        log.debug("initializing...");
        this.menus = new Hashtable();
        this.menus.put(KEY_MENU_FILE, this.getFileMenu());
        log.debug("added File Menu.");
        this.menus.put(KEY_MENU_EDIT, this.getEditMenu());
        log.debug("added Edit Menu.");
        this.menus.put(KEY_MENU_VIEW, this.getViewMenu());
        log.debug("added View Menu.");
        this.menus.put(KEY_MENU_FONT, this.getFontMenu());
        log.debug("added Font Menu.");
        this.menus.put(KEY_MENU_FORMAT, this.getFormatMenu());
        log.debug("added Format Menu.");
        this.menus.put(KEY_MENU_SEARCH, this.getSearchMenu());
        log.debug("added Search Menu.");
        this.menus.put(KEY_MENU_INSERT, this.getInsertMenu());
        log.debug("added Insert Menu.");
        this.menus.put(KEY_MENU_TABLE, this.getTableMenu());
        log.debug("added Table Menu.");
        this.menus.put(KEY_MENU_FORMS, this.getFormsMenu());
        log.debug("added Forms Menu.");
        this.menus.put(KEY_MENU_HELP, this.getHelpMenu());
        log.debug("added Help Menu.");
        this.menus.put(KEY_MENU_DEBUG, this.getDebugMenu());
        log.debug("added Debug Menu\n...done.");
    }

    public static ArrayList getOrderedMenuKeys() {
        return parameters;
    }

    public JMenuBar createCustomMenuBar(Vector vector) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(this.config.getBgcolor());
        for (int i = 0; i < vector.size(); ++i) {
            String string = ((String)vector.elementAt(i)).toLowerCase();
            if (!this.menus.containsKey(string)) continue;
            jMenuBar.add((JMenu)this.menus.get(string));
        }
        return jMenuBar;
    }

    public JMenuBar createDefaultKafenioMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(this.config.getBgcolor());
        for (int i = 0; i < KafenioMenuBar.getOrderedMenuKeys().size(); ++i) {
            if (!this.menus.containsKey((String)KafenioMenuBar.getOrderedMenuKeys().get(i))) continue;
            jMenuBar.add((JMenu)this.menus.get((String)KafenioMenuBar.getOrderedMenuKeys().get(i)));
        }
        return jMenuBar;
    }

    public JMenu getDebugMenu() {
        JMenu jMenu = this.getNewMenu("Debug");
        jMenu.add(new KafenioMenuItem(this, this.getString("DescribeDoc"), "describe", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("DescribeCSS"), "describecss", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("WhatTags"), "whattags", this.getParent()));
        return jMenu;
    }

    public JMenu getHelpMenu() {
        JMenu jMenu = this.getNewMenu("Help");
        jMenu.add(new KafenioMenuItem(this, this.getString("About"), "helpabout", this.getParent()));
        return jMenu;
    }

    public JMenu getSearchMenu() {
        JMenu jMenu = this.getNewMenu("Search");
        jMenu.add(new KafenioMenuItem(this, this.getString("SearchFind"), "find", (ActionListener)this.getParent(), KeyStroke.getKeyStroke(70, 2, false)));
        jMenu.add(new KafenioMenuItem(this, this.getString("SearchFindAgain"), "findagain", (ActionListener)this.getParent(), KeyStroke.getKeyStroke(71, 2, false)));
        jMenu.add(new KafenioMenuItem(this, this.getString("SearchReplace"), "replace", (ActionListener)this.getParent(), KeyStroke.getKeyStroke(82, 2, false)));
        return jMenu;
    }

    public JMenu getFormsMenu() {
        JMenu jMenu = this.getNewMenu("Forms");
        jMenu.add(new KafenioMenuItem(this, this.getString("FormInsertForm"), "insertform", this.getParent()));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("FormTextfield"), "inserttextfield", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormTextarea"), "inserttextarea", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormCheckbox"), "insertcheckbox", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormRadio"), "insertradiobutton", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormPassword"), "insertpassword", this.getParent()));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("FormButton"), "insertbutton", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormButtonSubmit"), "insertbuttonsubmit", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("FormButtonReset"), "insertbuttonreset", this.getParent()));
        return jMenu;
    }

    public JMenu getTableMenu() {
        JMenu jMenu = this.getNewMenu("Table");
        jMenu.add(new KafenioMenuItem(this, this.getString("InsertTable") + DOTS, "inserttable", this.getParent(), null, this.getParent().getMenuIcon("Table")));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("InsertTableRow"), "inserttablerow", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("InsertTableColumn"), "inserttablecolumn", this.getParent()));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("DeleteTableRow"), "deletetablerow", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, this.getString("DeleteTableColumn"), "deletetablecolumn", this.getParent()));
        return jMenu;
    }

    public JMenu getInsertMenu() {
        JMenu jMenu = this.getNewMenu("Insert");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionInsertHyperlink(), null, this.getParent().getMenuIcon("Anchor")));
        jMenu.add(new KafenioMenuItem(this, this.getString("InsertBreak"), "insertbreak", (ActionListener)this.getParent(), KeyStroke.getKeyStroke(10, 1, false)));
        jMenu.add(new KafenioMenuItem(this, this.getString("InsertNBSP"), "insertnbsp", this.getParent()));
        jMenu.add(new KafenioMenuItem(this, (Action)this.getParent().getTActions().get("InsertHR"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionInsertCharacter(), null, this.getParent().getMenuIcon("Character")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAddParagraph(), null, null));
        jMenu.addSeparator();
        if (!this.config.isApplet()) {
            JMenu jMenu2 = this.getNewMenu("InsertLocalImage");
            jMenu2.setIcon(this.getParent().getMenuIcon("InsertImage"));
            jMenu2.add(new KafenioMenuItem(this, this.getString("InsertLocalImage") + DOTS, "insertlocalimage", this.getParent(), null, null));
            jMenu2.add(new KafenioMenuItem(this, this.getActionList().getActionInsertServerImage(), null, null));
            jMenu.add(jMenu2);
        } else {
            jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionInsertServerImage(), null, this.getParent().getMenuIcon("InsertImage")));
        }
        return jMenu;
    }

    public JMenu getFormatMenu() {
        JMenu jMenu = this.getNewMenu("Format");
        jMenu.add(this.getFormatAlignMenu());
        jMenu.addSeparator();
        jMenu.add(this.getFormatHeadingMenu());
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionListUnordered(), null, this.getParent().getMenuIcon("UList")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionListOrdered(), null, this.getParent().getMenuIcon("OList")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAddListItem(), null, null));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionBlockquote(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionPre(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionStrong(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionEmphasis(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionTT(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionSpan(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionToggleCase(), null, null));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionClearFormat(), null, this.getParent().getMenuIcon("ClearFormat")));
        return jMenu;
    }

    public JMenu getFormatHeadingMenu() {
        JMenu jMenu = this.getNewMenu("Heading");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading1(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading2(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading3(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading4(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading5(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionHeading6(), null, null));
        return jMenu;
    }

    public JMenu getFormatAlignMenu() {
        JMenu jMenu = this.getNewMenu("Align");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAlignLeft(), null, this.getParent().getMenuIcon("AlignLeft")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAlignCenter(), null, this.getParent().getMenuIcon("AlignCenter")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAlignRight(), null, this.getParent().getMenuIcon("AlignRight")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionAlignJustified(), null, this.getParent().getMenuIcon("AlignJustified")));
        return jMenu;
    }

    public JMenu getFontMenu() {
        JMenu jMenu = this.getNewMenu("Font");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontBold(), KeyStroke.getKeyStroke(66, 2, false), this.getParent().getMenuIcon("Bold")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontItalic(), KeyStroke.getKeyStroke(73, 2, false), this.getParent().getMenuIcon("Italic")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontUnderline(), KeyStroke.getKeyStroke(85, 2, false), this.getParent().getMenuIcon("Underline")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontStrike(), null, this.getParent().getMenuIcon("Strike")));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFormatBig(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFormatSmall(), null, null));
        jMenu.add(this.getFontSizeMenu());
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSuperscript(), null, this.getParent().getMenuIcon("Super")));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSubscript(), null, this.getParent().getMenuIcon("Sub")));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("FontSerif"), (Action)this.getParent().getTActions().get("font-family-Serif"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("FontSansserif"), (Action)this.getParent().getTActions().get("font-family-SansSerif"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("FontMonospaced"), (Action)this.getParent().getTActions().get("font-family-Monospaced"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("FontSelect"), this.getActionList().getActionSelectFont(), null, null));
        jMenu.addSeparator();
        jMenu.add(this.getFontColorMenu());
        return jMenu;
    }

    public JMenu getFontColorMenu() {
        JMenu jMenu = this.getNewMenu("Color");
        jMenu.setIcon(this.getParent().getMenuIcon("Color"));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("color", "black");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontCustomColor(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorAqua(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorBlack(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorBlue(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorFuschia(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorGray(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorGreen(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorLime(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorMaroon(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorNavy(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorOlive(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorPurple(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorSilver(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorTeal(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorWhite(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontColorYellow(), null, null));
        return jMenu;
    }

    public JMenu getFontSizeMenu() {
        JMenu jMenu = this.getNewMenu("FontSize");
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize1(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize2(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize3(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize4(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize5(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize6(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getActionList().getActionFontSize7(), null, null));
        return jMenu;
    }

    public JMenu getViewMenu() {
        JMenu jMenu = this.getNewMenu("View");
        this.viewToolbarItem = new JCheckBoxMenuItem(this.getString("ViewToolbar"), false);
        this.viewToolbarItem.setActionCommand("toggletoolbar");
        this.viewToolbarItem.addActionListener(this.parent);
        this.viewToolbarItem.setBackground(this.config.getBgcolor());
        jMenu.add(this.viewToolbarItem);
        log.debug("added ViewToolbar Menuitem: toolbar1: " + this.config.isShowToolbar());
        this.viewSourceItem = new JCheckBoxMenuItem(this.getString("ViewSource"), false);
        this.viewSourceItem.setActionCommand("viewsource");
        this.viewSourceItem.addActionListener(this.parent);
        this.viewSourceItem.setBackground(this.config.getBgcolor());
        jMenu.add(this.viewSourceItem);
        log.debug("added ViewSource Menuitem");
        return jMenu;
    }

    public JMenu getEditMenu() {
        JMenu jMenu = this.getNewMenu("Edit");
        if (!"off".equalsIgnoreCase(this.config.getOutputmode())) {
            jMenu.add(new KafenioMenuItem(this, this.getString("SaveBody"), "savecontent", (ActionListener)this.getParent(), KeyStroke.getKeyStroke(83, 2, false)));
            jMenu.addSeparator();
        }
        if (this.getParent().getSysClipboard() != null) {
            jMenu.add(new KafenioMenuItem(this, this.getString("Cut"), "textcut", this.getParent(), KeyStroke.getKeyStroke(88, 2, false), this.getParent().getMenuIcon("Cut")));
            jMenu.add(new KafenioMenuItem(this, this.getString("Copy"), "textcopy", this.getParent(), KeyStroke.getKeyStroke(67, 2, false), this.getParent().getMenuIcon("Copy")));
            jMenu.add(new KafenioMenuItem(this, this.getString("Paste"), "textpaste", this.getParent(), KeyStroke.getKeyStroke(86, 2, false), this.getParent().getMenuIcon("Paste")));
        } else {
            jMenu.add(new KafenioMenuItem(this, this.getString("Cut"), new DefaultEditorKit.CutAction(), KeyStroke.getKeyStroke(88, 2, false), (Icon)this.getParent().getMenuIcon("Cut")));
            jMenu.add(new KafenioMenuItem(this, this.getString("Copy"), new DefaultEditorKit.CopyAction(), KeyStroke.getKeyStroke(67, 2, false), (Icon)this.getParent().getMenuIcon("Copy")));
            jMenu.add(new KafenioMenuItem(this, this.getString("Paste"), new DefaultEditorKit.PasteAction(), KeyStroke.getKeyStroke(86, 2, false), (Icon)this.getParent().getMenuIcon("Paste")));
        }
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getParent().getUndoAction(), KeyStroke.getKeyStroke(90, 2, false), this.getParent().getMenuIcon("Undo")));
        jMenu.add(new KafenioMenuItem(this, this.getParent().getRedoAction(), KeyStroke.getKeyStroke(89, 2, false), this.getParent().getMenuIcon("Redo")));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("SelectAll"), (Action)this.getParent().getTActions().get("select-all"), KeyStroke.getKeyStroke(65, 2, false), null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SelectParagraph"), (Action)this.getParent().getTActions().get("select-paragraph"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SelectLine"), (Action)this.getParent().getTActions().get("select-line"), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SelectWord"), (Action)this.getParent().getTActions().get("select-word"), null, null));
        return jMenu;
    }

    public JMenu getFileMenu() {
        JMenu jMenu = this.getNewMenu("File");
        jMenu.add(new KafenioMenuItem(this, this.getString("NewDocument"), "newdoc", this.getParent(), KeyStroke.getKeyStroke(78, 2, false), this.getParent().getMenuIcon("New")));
        jMenu.add(new KafenioMenuItem(this, this.getString("OpenDocument") + DOTS, "openhtml", this.getParent(), KeyStroke.getKeyStroke(79, 2, false), this.getParent().getMenuIcon("Open")));
        jMenu.add(new KafenioMenuItem(this, this.getString("OpenStyle"), "opencss", this.getParent(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("OpenBase64Document"), "openb64", this.getParent(), null, null));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("Save"), "save", this.getParent(), KeyStroke.getKeyStroke(83, 2, false), this.getParent().getMenuIcon("Save")));
        jMenu.add(new KafenioMenuItem(this, this.getString("SaveAs") + DOTS, "saveas", this.getParent(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SaveBody") + DOTS, "savebody", this.getParent(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SaveRTF") + DOTS, "savertf", this.getParent(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("SaveB64") + DOTS, "saveb64", this.getParent(), null, null));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("Serialize") + DOTS, "serialize", this.getParent(), null, null));
        jMenu.add(new KafenioMenuItem(this, this.getString("ReadFromSer") + DOTS, "readfromser", this.getParent(), null, null));
        jMenu.addSeparator();
        jMenu.add(new KafenioMenuItem(this, this.getString("Exit"), "exit", this.getParent(), null, null));
        return jMenu;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public KafenioPanel getParent() {
        return this.parent;
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.menuBar = jMenuBar;
    }

    public void setParent(KafenioPanel kafenioPanel) {
        this.parent = kafenioPanel;
    }

    public JCheckBoxMenuItem getViewSourceItem() {
        return this.viewSourceItem;
    }

    public JCheckBoxMenuItem getViewToolbarItem() {
        return this.viewToolbarItem;
    }

    public JMenu getNewMenu(String string) {
        JMenu jMenu = new JMenu(this.getString(string));
        jMenu.setBackground(this.config.getBgcolor());
        return jMenu;
    }

    private KafenioPanelActions getActionList() {
        return this.getParent().getKafenioActions();
    }

    private String getString(String string) {
        return this.getParent().getTranslation(string);
    }

    static {
        parameters.add(KEY_MENU_FILE);
        parameters.add(KEY_MENU_EDIT);
        parameters.add(KEY_MENU_VIEW);
        parameters.add(KEY_MENU_FONT);
        parameters.add(KEY_MENU_FORMAT);
        parameters.add(KEY_MENU_INSERT);
        parameters.add(KEY_MENU_TABLE);
        parameters.add(KEY_MENU_FORMS);
        parameters.add(KEY_MENU_SEARCH);
        parameters.add(KEY_MENU_TOOLS);
        parameters.add(KEY_MENU_HELP);
        parameters.add(KEY_MENU_DEBUG);
    }
}

